/* sound.c generated by valac 0.32.1, the Vala compiler
 * generated from sound.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gvc-mixer-stream.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gvc-mixer-ui-device.h>
#include <gvc-mixer-card.h>
#include <pango/pango.h>


#define TYPE_SOUND_WIDGET (sound_widget_get_type ())
#define SOUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOUND_WIDGET, SoundWidget))
#define SOUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOUND_WIDGET, SoundWidgetClass))
#define IS_SOUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOUND_WIDGET))
#define IS_SOUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOUND_WIDGET))
#define SOUND_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOUND_WIDGET, SoundWidgetClass))

typedef struct _SoundWidget SoundWidget;
typedef struct _SoundWidgetClass SoundWidgetClass;
typedef struct _SoundWidgetPrivate SoundWidgetPrivate;

#define BUDGIE_TYPE_HEADER_WIDGET (budgie_header_widget_get_type ())
#define BUDGIE_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget))
#define BUDGIE_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))
#define BUDGIE_IS_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_IS_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_HEADER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))

typedef struct _BudgieHeaderWidget BudgieHeaderWidget;
typedef struct _BudgieHeaderWidgetClass BudgieHeaderWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_RAVEN_EXPANDER (budgie_raven_expander_get_type ())
#define BUDGIE_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander))
#define BUDGIE_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))
#define BUDGIE_IS_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_IS_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_RAVEN_EXPANDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))

typedef struct _BudgieRavenExpander BudgieRavenExpander;
typedef struct _BudgieRavenExpanderClass BudgieRavenExpanderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SoundWidget {
	GtkBox parent_instance;
	SoundWidgetPrivate * priv;
};

struct _SoundWidgetClass {
	GtkBoxClass parent_class;
};

struct _SoundWidgetPrivate {
	GtkScale* scale;
	gulong scale_id;
	GvcMixerControl* mixer;
	GtkSwitch* output_switch;
	gulong output_switch_id;
	GtkBox* output_box;
	GtkRadioButton* output_leader;
	GHashTable* outputs;
	GvcMixerStream* output_stream;
	gulong output_notify_id;
	GtkSwitch* input_switch;
	gulong input_switch_id;
	GtkBox* input_box;
	GtkRadioButton* input_leader;
	GHashTable* inputs;
	GvcMixerStream* input_stream;
	gulong input_notify_id;
	BudgieHeaderWidget* header;
};


static gpointer sound_widget_parent_class = NULL;

GType sound_widget_get_type (void) G_GNUC_CONST;
GType budgie_header_widget_get_type (void) G_GNUC_CONST;
#define SOUND_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOUND_WIDGET, SoundWidgetPrivate))
enum  {
	SOUND_WIDGET_DUMMY_PROPERTY
};
SoundWidget* sound_widget_new (void);
SoundWidget* sound_widget_construct (GType object_type);
static void sound_widget_on_output_scale_change (SoundWidget* self);
static void _sound_widget_on_output_scale_change_gtk_range_value_changed (GtkRange* _sender, gpointer self);
BudgieHeaderWidget* budgie_header_widget_new (const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
BudgieHeaderWidget* budgie_header_widget_construct (GType object_type, const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
GType budgie_raven_expander_get_type (void) G_GNUC_CONST;
BudgieRavenExpander* budgie_raven_expander_new (BudgieHeaderWidget* header);
BudgieRavenExpander* budgie_raven_expander_construct (GType object_type, BudgieHeaderWidget* header);
static void _g_object_unref0_ (gpointer var);
static void sound_widget_on_state_changed (SoundWidget* self, guint state);
static void _sound_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender, guint new_state, gpointer self);
static void sound_widget_on_output_added (SoundWidget* self, guint id);
static void _sound_widget_on_output_added_gvc_mixer_control_output_added (GvcMixerControl* _sender, guint id, gpointer self);
static void sound_widget_on_output_removed (SoundWidget* self, guint id);
static void _sound_widget_on_output_removed_gvc_mixer_control_output_removed (GvcMixerControl* _sender, guint id, gpointer self);
static void sound_widget_on_input_added (SoundWidget* self, guint id);
static void _sound_widget_on_input_added_gvc_mixer_control_input_added (GvcMixerControl* _sender, guint id, gpointer self);
static void sound_widget_on_input_removed (SoundWidget* self, guint id);
static void _sound_widget_on_input_removed_gvc_mixer_control_input_removed (GvcMixerControl* _sender, guint id, gpointer self);
static void sound_widget_on_sink_changed (SoundWidget* self, guint id);
static void _sound_widget_on_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender, guint id, gpointer self);
static void sound_widget_on_source_changed (SoundWidget* self, guint id);
static void _sound_widget_on_source_changed_gvc_mixer_control_default_source_changed (GvcMixerControl* _sender, guint id, gpointer self);
static void sound_widget_on_output_mute_changed (SoundWidget* self);
static void _sound_widget_on_output_mute_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sound_widget_on_input_mute_changed (SoundWidget* self);
static void _sound_widget_on_input_mute_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void budgie_raven_expander_set_expanded (BudgieRavenExpander* self, gboolean value);
static void sound_widget_on_input_selected (SoundWidget* self, GtkToggleButton* btn);
static void __lambda26_ (SoundWidget* self, GObject* n, GParamSpec* p);
static void sound_widget_update_input (SoundWidget* self);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sound_widget_on_output_selected (SoundWidget* self, GtkToggleButton* btn);
static void __lambda25_ (SoundWidget* self, GObject* n, GParamSpec* p);
static void sound_widget_update_volume (SoundWidget* self);
static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void budgie_header_widget_set_icon_name (BudgieHeaderWidget* self, const gchar* value);
static void _sound_widget_on_output_selected_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _sound_widget_on_input_selected_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void sound_widget_update_mixers (SoundWidget* self);
static void sound_widget_finalize (GObject* obj);


static void _sound_widget_on_output_scale_change_gtk_range_value_changed (GtkRange* _sender, gpointer self) {
	sound_widget_on_output_scale_change ((SoundWidget*) self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _sound_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender, guint new_state, gpointer self) {
	sound_widget_on_state_changed ((SoundWidget*) self, new_state);
}


static void _sound_widget_on_output_added_gvc_mixer_control_output_added (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_widget_on_output_added ((SoundWidget*) self, id);
}


static void _sound_widget_on_output_removed_gvc_mixer_control_output_removed (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_widget_on_output_removed ((SoundWidget*) self, id);
}


static void _sound_widget_on_input_added_gvc_mixer_control_input_added (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_widget_on_input_added ((SoundWidget*) self, id);
}


static void _sound_widget_on_input_removed_gvc_mixer_control_input_removed (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_widget_on_input_removed ((SoundWidget*) self, id);
}


static void _sound_widget_on_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_widget_on_sink_changed ((SoundWidget*) self, id);
}


static void _sound_widget_on_source_changed_gvc_mixer_control_default_source_changed (GvcMixerControl* _sender, guint id, gpointer self) {
	sound_widget_on_source_changed ((SoundWidget*) self, id);
}


static void _sound_widget_on_output_mute_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	sound_widget_on_output_mute_changed ((SoundWidget*) self);
}


static void _sound_widget_on_input_mute_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	sound_widget_on_input_mute_changed ((SoundWidget*) self);
}


SoundWidget* sound_widget_construct (GType object_type) {
	SoundWidget * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkScale* _tmp1_ = NULL;
	GtkScale* _tmp2_ = NULL;
	GtkScale* _tmp3_ = NULL;
	GtkScale* _tmp4_ = NULL;
	BudgieHeaderWidget* _tmp5_ = NULL;
	BudgieRavenExpander* expander = NULL;
	BudgieHeaderWidget* _tmp6_ = NULL;
	BudgieRavenExpander* _tmp7_ = NULL;
	GtkEventBox* ebox = NULL;
	GtkEventBox* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_ = NULL;
	GHashFunc _tmp10_ = NULL;
	GEqualFunc _tmp11_ = NULL;
	GHashTable* _tmp12_ = NULL;
	GHashFunc _tmp13_ = NULL;
	GEqualFunc _tmp14_ = NULL;
	GHashTable* _tmp15_ = NULL;
	GvcMixerControl* _tmp16_ = NULL;
	GvcMixerControl* _tmp17_ = NULL;
	GvcMixerControl* _tmp18_ = NULL;
	GvcMixerControl* _tmp19_ = NULL;
	GvcMixerControl* _tmp20_ = NULL;
	GvcMixerControl* _tmp21_ = NULL;
	GvcMixerControl* _tmp22_ = NULL;
	GvcMixerControl* _tmp23_ = NULL;
	GtkBox* main_layout = NULL;
	GtkBox* _tmp24_ = NULL;
	GtkBox* row = NULL;
	GtkBox* _tmp25_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkStyleContext* _tmp29_ = NULL;
	GtkBox* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	GtkSwitch* _tmp33_ = NULL;
	GtkSwitch* _tmp34_ = NULL;
	GtkSwitch* _tmp35_ = NULL;
	gulong _tmp36_ = 0UL;
	GtkBox* _tmp37_ = NULL;
	GtkSwitch* _tmp38_ = NULL;
	GtkBox* _tmp39_ = NULL;
	GtkBox* _tmp40_ = NULL;
	GtkBox* _tmp41_ = NULL;
	GtkBox* _tmp42_ = NULL;
	GtkBox* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkStyleContext* _tmp47_ = NULL;
	GtkBox* _tmp48_ = NULL;
	GtkLabel* _tmp49_ = NULL;
	GtkLabel* _tmp50_ = NULL;
	GtkSwitch* _tmp51_ = NULL;
	GtkSwitch* _tmp52_ = NULL;
	GtkSwitch* _tmp53_ = NULL;
	gulong _tmp54_ = 0UL;
	GtkBox* _tmp55_ = NULL;
	GtkSwitch* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBox* _tmp58_ = NULL;
	GtkBox* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GvcMixerControl* _tmp61_ = NULL;
	self = (SoundWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "audio-widget");
	_tmp1_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 10);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->scale);
	self->priv->scale = _tmp1_;
	_tmp2_ = self->priv->scale;
	gtk_scale_set_draw_value (_tmp2_, FALSE);
	_tmp3_ = self->priv->scale;
	g_signal_connect_object ((GtkRange*) _tmp3_, "value-changed", (GCallback) _sound_widget_on_output_scale_change_gtk_range_value_changed, self, 0);
	_tmp4_ = self->priv->scale;
	_tmp5_ = budgie_header_widget_new ("", "audio-volume-muted-symbolic", FALSE, (GtkWidget*) _tmp4_, NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp5_;
	_tmp6_ = self->priv->header;
	_tmp7_ = budgie_raven_expander_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	expander = _tmp7_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) expander, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp8_);
	ebox = _tmp8_;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) ebox);
	gtk_style_context_add_class (_tmp9_, "raven-background");
	gtk_container_add ((GtkContainer*) expander, (GtkWidget*) ebox);
	_tmp10_ = g_direct_hash;
	_tmp11_ = g_direct_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->outputs);
	self->priv->outputs = _tmp12_;
	_tmp13_ = g_direct_hash;
	_tmp14_ = g_direct_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->inputs);
	self->priv->inputs = _tmp15_;
	_tmp16_ = gvc_mixer_control_new ("Budgie Volume Control");
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp16_;
	_tmp17_ = self->priv->mixer;
	g_signal_connect_object (_tmp17_, "state-changed", (GCallback) _sound_widget_on_state_changed_gvc_mixer_control_state_changed, self, 0);
	_tmp18_ = self->priv->mixer;
	g_signal_connect_object (_tmp18_, "output-added", (GCallback) _sound_widget_on_output_added_gvc_mixer_control_output_added, self, 0);
	_tmp19_ = self->priv->mixer;
	g_signal_connect_object (_tmp19_, "output-removed", (GCallback) _sound_widget_on_output_removed_gvc_mixer_control_output_removed, self, 0);
	_tmp20_ = self->priv->mixer;
	g_signal_connect_object (_tmp20_, "input-added", (GCallback) _sound_widget_on_input_added_gvc_mixer_control_input_added, self, 0);
	_tmp21_ = self->priv->mixer;
	g_signal_connect_object (_tmp21_, "input-removed", (GCallback) _sound_widget_on_input_removed_gvc_mixer_control_input_removed, self, 0);
	_tmp22_ = self->priv->mixer;
	g_signal_connect_object (_tmp22_, "default-sink-changed", (GCallback) _sound_widget_on_sink_changed_gvc_mixer_control_default_sink_changed, self, 0);
	_tmp23_ = self->priv->mixer;
	g_signal_connect_object (_tmp23_, "default-source-changed", (GCallback) _sound_widget_on_source_changed_gvc_mixer_control_default_source_changed, self, 0);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp24_);
	main_layout = _tmp24_;
	gtk_widget_set_margin_top ((GtkWidget*) main_layout, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) main_layout, 6);
	gtk_widget_set_margin_start ((GtkWidget*) main_layout, 12);
	gtk_widget_set_margin_end ((GtkWidget*) main_layout, 12);
	gtk_container_add ((GtkContainer*) ebox, (GtkWidget*) main_layout);
	_tmp25_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp25_);
	row = _tmp25_;
	_tmp26_ = _ ("Output");
	_tmp27_ = (GtkLabel*) gtk_label_new (_tmp26_);
	g_object_ref_sink (_tmp27_);
	label = _tmp27_;
	_tmp28_ = label;
	_tmp29_ = gtk_widget_get_style_context ((GtkWidget*) _tmp28_);
	gtk_style_context_add_class (_tmp29_, "heading");
	_tmp30_ = row;
	_tmp31_ = label;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
	_tmp32_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_START);
	_tmp33_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->output_switch);
	self->priv->output_switch = _tmp33_;
	_tmp34_ = self->priv->output_switch;
	gtk_switch_set_active (_tmp34_, FALSE);
	_tmp35_ = self->priv->output_switch;
	_tmp36_ = g_signal_connect_object ((GObject*) _tmp35_, "notify::active", (GCallback) _sound_widget_on_output_mute_changed_g_object_notify, self, 0);
	self->priv->output_switch_id = _tmp36_;
	_tmp37_ = row;
	_tmp38_ = self->priv->output_switch;
	gtk_box_pack_end (_tmp37_, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
	_tmp39_ = row;
	gtk_box_pack_start (main_layout, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
	_tmp40_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->output_box);
	self->priv->output_box = _tmp40_;
	_tmp41_ = self->priv->output_box;
	gtk_box_pack_start (main_layout, (GtkWidget*) _tmp41_, FALSE, FALSE, (guint) 0);
	_tmp42_ = self->priv->output_box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp42_, 6);
	_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (row);
	row = _tmp43_;
	_tmp44_ = _ ("Input");
	_tmp45_ = (GtkLabel*) gtk_label_new (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (label);
	label = _tmp45_;
	_tmp46_ = label;
	_tmp47_ = gtk_widget_get_style_context ((GtkWidget*) _tmp46_);
	gtk_style_context_add_class (_tmp47_, "heading");
	_tmp48_ = row;
	_tmp49_ = label;
	gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, TRUE, TRUE, (guint) 0);
	_tmp50_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp50_, GTK_ALIGN_START);
	_tmp51_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->input_switch);
	self->priv->input_switch = _tmp51_;
	_tmp52_ = self->priv->input_switch;
	gtk_switch_set_active (_tmp52_, FALSE);
	_tmp53_ = self->priv->input_switch;
	_tmp54_ = g_signal_connect_object ((GObject*) _tmp53_, "notify::active", (GCallback) _sound_widget_on_input_mute_changed_g_object_notify, self, 0);
	self->priv->input_switch_id = _tmp54_;
	_tmp55_ = row;
	_tmp56_ = self->priv->input_switch;
	gtk_box_pack_end (_tmp55_, (GtkWidget*) _tmp56_, FALSE, FALSE, (guint) 0);
	_tmp57_ = row;
	gtk_box_pack_start (main_layout, (GtkWidget*) _tmp57_, FALSE, FALSE, (guint) 0);
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->input_box);
	self->priv->input_box = _tmp58_;
	_tmp59_ = self->priv->input_box;
	gtk_box_pack_start (main_layout, (GtkWidget*) _tmp59_, FALSE, FALSE, (guint) 0);
	_tmp60_ = self->priv->input_box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp60_, 6);
	budgie_raven_expander_set_expanded (expander, TRUE);
	_tmp61_ = self->priv->mixer;
	gvc_mixer_control_open (_tmp61_);
	_g_object_unref0 (label);
	_g_object_unref0 (row);
	_g_object_unref0 (main_layout);
	_g_object_unref0 (ebox);
	_g_object_unref0 (expander);
	return self;
}


SoundWidget* sound_widget_new (void) {
	return sound_widget_construct (TYPE_SOUND_WIDGET);
}


/**
     * New volume from our scale
     */
static void sound_widget_on_output_scale_change (SoundWidget* self) {
	GvcMixerStream* _tmp0_ = NULL;
	GvcMixerStream* _tmp1_ = NULL;
	GtkScale* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->output_stream;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->output_stream;
	_tmp2_ = self->priv->scale;
	_tmp3_ = gtk_range_get_value ((GtkRange*) _tmp2_);
	_tmp4_ = gvc_mixer_stream_set_volume (_tmp1_, (guint32) _tmp3_);
	if (_tmp4_) {
		GvcMixerStream* _tmp5_ = NULL;
		_tmp5_ = self->priv->output_stream;
		gvc_mixer_stream_push_volume (_tmp5_);
	}
}


/**
     * Allow users to mute
     */
static void sound_widget_on_output_mute_changed (SoundWidget* self) {
	GvcMixerStream* _tmp0_ = NULL;
	GvcMixerStream* _tmp1_ = NULL;
	GtkSwitch* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->output_stream;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->output_stream;
	_tmp2_ = self->priv->output_switch;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	gvc_mixer_stream_change_is_muted (_tmp1_, !_tmp4_);
}


/**
     * Allow users to mute mic
     */
static void sound_widget_on_input_mute_changed (SoundWidget* self) {
	GvcMixerStream* _tmp0_ = NULL;
	GvcMixerStream* _tmp1_ = NULL;
	GtkSwitch* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_stream;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->input_stream;
	_tmp2_ = self->priv->input_switch;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	gvc_mixer_stream_change_is_muted (_tmp1_, !_tmp4_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda26_ (SoundWidget* self, GObject* n, GParamSpec* p) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (n != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	_tmp1_ = _tmp0_->name;
	if (g_strcmp0 (_tmp1_, "is-muted") == 0) {
		sound_widget_update_input (self);
	}
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda26_ ((SoundWidget*) self, _sender, pspec);
}


static void sound_widget_on_source_changed (SoundWidget* self, guint id) {
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_ = NULL;
	GvcMixerStream* _tmp1_ = NULL;
	GvcMixerStream* _tmp2_ = NULL;
	GvcMixerStream* _tmp3_ = NULL;
	GvcMixerStream* _tmp4_ = NULL;
	GvcMixerStream* _tmp19_ = NULL;
	GvcMixerStream* _tmp22_ = NULL;
	gulong _tmp23_ = 0UL;
	GvcMixerStream* _tmp24_ = NULL;
	GvcMixerStream* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_get_default_source (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp3_ = stream;
	_tmp4_ = self->priv->input_stream;
	if (_tmp3_ == _tmp4_) {
		_g_object_unref0 (stream);
		return;
	}
	{
		GvcMixerUIDevice* device = NULL;
		GvcMixerControl* _tmp5_ = NULL;
		GvcMixerStream* _tmp6_ = NULL;
		GvcMixerUIDevice* _tmp7_ = NULL;
		GvcMixerUIDevice* _tmp8_ = NULL;
		guint did = 0U;
		GvcMixerUIDevice* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GtkRadioButton* check = NULL;
		GHashTable* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		gconstpointer _tmp13_ = NULL;
		GtkRadioButton* _tmp14_ = NULL;
		GtkRadioButton* _tmp15_ = NULL;
		_tmp5_ = self->priv->mixer;
		_tmp6_ = stream;
		_tmp7_ = gvc_mixer_control_lookup_device_from_stream (_tmp5_, _tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		device = _tmp8_;
		_tmp9_ = device;
		_tmp10_ = gvc_mixer_ui_device_get_id (_tmp9_);
		did = _tmp10_;
		_tmp11_ = self->priv->inputs;
		_tmp12_ = did;
		_tmp13_ = g_hash_table_lookup (_tmp11_, (gpointer) ((guintptr) _tmp12_));
		_tmp14_ = _g_object_ref0 ((GtkRadioButton*) _tmp13_);
		check = _tmp14_;
		_tmp15_ = check;
		if (_tmp15_ != NULL) {
			GtkRadioButton* _tmp16_ = NULL;
			GtkRadioButton* _tmp17_ = NULL;
			GtkRadioButton* _tmp18_ = NULL;
			_tmp16_ = check;
			g_signal_handlers_block_by_func ((void*) _tmp16_, (void*) sound_widget_on_input_selected, self);
			_tmp17_ = check;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp17_, TRUE);
			_tmp18_ = check;
			g_signal_handlers_unblock_by_func ((void*) _tmp18_, (void*) sound_widget_on_input_selected, self);
		}
		_g_object_unref0 (check);
		_g_object_unref0 (device);
	}
	_tmp19_ = self->priv->input_stream;
	if (_tmp19_ != NULL) {
		GvcMixerStream* _tmp20_ = NULL;
		gulong _tmp21_ = 0UL;
		_tmp20_ = self->priv->input_stream;
		_tmp21_ = self->priv->input_notify_id;
		g_signal_handler_disconnect ((GObject*) _tmp20_, _tmp21_);
		self->priv->input_notify_id = (gulong) 0;
	}
	_tmp22_ = stream;
	_tmp23_ = g_signal_connect_object ((GObject*) _tmp22_, "notify", (GCallback) ___lambda26__g_object_notify, self, 0);
	self->priv->input_notify_id = _tmp23_;
	_tmp24_ = stream;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->input_stream);
	self->priv->input_stream = _tmp25_;
	sound_widget_update_input (self);
	_g_object_unref0 (stream);
}


/** Update mute status on input stream */
static void sound_widget_update_input (SoundWidget* self) {
	GvcMixerStream* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_stream;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->input_switch_id;
	if (_tmp1_ > ((gulong) 0)) {
		GtkSwitch* _tmp2_ = NULL;
		gulong _tmp3_ = 0UL;
		GtkSwitch* _tmp4_ = NULL;
		GvcMixerStream* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		GtkSwitch* _tmp8_ = NULL;
		gulong _tmp9_ = 0UL;
		_tmp2_ = self->priv->input_switch;
		_tmp3_ = self->priv->input_switch_id;
		g_signal_handler_block (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->input_switch;
		_tmp5_ = self->priv->input_stream;
		g_object_get (_tmp5_, "is-muted", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		gtk_switch_set_active (_tmp4_, !_tmp7_);
		_tmp8_ = self->priv->input_switch;
		_tmp9_ = self->priv->input_switch_id;
		g_signal_handler_unblock (_tmp8_, _tmp9_);
	} else {
		GtkSwitch* _tmp10_ = NULL;
		GvcMixerStream* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = self->priv->input_switch;
		_tmp11_ = self->priv->input_stream;
		g_object_get (_tmp11_, "is-muted", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		gtk_switch_set_active (_tmp10_, !_tmp13_);
	}
}


static void __lambda25_ (SoundWidget* self, GObject* n, GParamSpec* p) {
	gboolean _tmp0_ = FALSE;
	GParamSpec* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (n != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = p;
	_tmp2_ = _tmp1_->name;
	if (g_strcmp0 (_tmp2_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		GParamSpec* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = p;
		_tmp4_ = _tmp3_->name;
		_tmp0_ = g_strcmp0 (_tmp4_, "is-muted") == 0;
	}
	if (_tmp0_) {
		sound_widget_update_volume (self);
	}
}


static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda25_ ((SoundWidget*) self, _sender, pspec);
}


static void sound_widget_on_sink_changed (SoundWidget* self, guint id) {
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_ = NULL;
	GvcMixerStream* _tmp1_ = NULL;
	GvcMixerStream* _tmp2_ = NULL;
	GvcMixerStream* _tmp3_ = NULL;
	GvcMixerStream* _tmp4_ = NULL;
	GvcMixerStream* _tmp19_ = NULL;
	GvcMixerStream* _tmp22_ = NULL;
	gulong _tmp23_ = 0UL;
	GvcMixerStream* _tmp24_ = NULL;
	GvcMixerStream* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_get_default_sink (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp3_ = stream;
	_tmp4_ = self->priv->output_stream;
	if (_tmp3_ == _tmp4_) {
		_g_object_unref0 (stream);
		return;
	}
	{
		GvcMixerUIDevice* device = NULL;
		GvcMixerControl* _tmp5_ = NULL;
		GvcMixerStream* _tmp6_ = NULL;
		GvcMixerUIDevice* _tmp7_ = NULL;
		GvcMixerUIDevice* _tmp8_ = NULL;
		guint did = 0U;
		GvcMixerUIDevice* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GtkRadioButton* check = NULL;
		GHashTable* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		gconstpointer _tmp13_ = NULL;
		GtkRadioButton* _tmp14_ = NULL;
		GtkRadioButton* _tmp15_ = NULL;
		_tmp5_ = self->priv->mixer;
		_tmp6_ = stream;
		_tmp7_ = gvc_mixer_control_lookup_device_from_stream (_tmp5_, _tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		device = _tmp8_;
		_tmp9_ = device;
		_tmp10_ = gvc_mixer_ui_device_get_id (_tmp9_);
		did = _tmp10_;
		_tmp11_ = self->priv->outputs;
		_tmp12_ = did;
		_tmp13_ = g_hash_table_lookup (_tmp11_, (gpointer) ((guintptr) _tmp12_));
		_tmp14_ = _g_object_ref0 ((GtkRadioButton*) _tmp13_);
		check = _tmp14_;
		_tmp15_ = check;
		if (_tmp15_ != NULL) {
			GtkRadioButton* _tmp16_ = NULL;
			GtkRadioButton* _tmp17_ = NULL;
			GtkRadioButton* _tmp18_ = NULL;
			_tmp16_ = check;
			g_signal_handlers_unblock_by_func ((void*) _tmp16_, (void*) sound_widget_on_output_selected, self);
			_tmp17_ = check;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp17_, TRUE);
			_tmp18_ = check;
			g_signal_handlers_unblock_by_func ((void*) _tmp18_, (void*) sound_widget_on_output_selected, self);
		}
		_g_object_unref0 (check);
		_g_object_unref0 (device);
	}
	_tmp19_ = self->priv->output_stream;
	if (_tmp19_ != NULL) {
		GvcMixerStream* _tmp20_ = NULL;
		gulong _tmp21_ = 0UL;
		_tmp20_ = self->priv->output_stream;
		_tmp21_ = self->priv->output_notify_id;
		g_signal_handler_disconnect ((GObject*) _tmp20_, _tmp21_);
		self->priv->output_notify_id = (gulong) 0;
	}
	_tmp22_ = stream;
	_tmp23_ = g_signal_connect_object ((GObject*) _tmp22_, "notify", (GCallback) ___lambda25__g_object_notify, self, 0);
	self->priv->output_notify_id = _tmp23_;
	_tmp24_ = stream;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->output_stream);
	self->priv->output_stream = _tmp25_;
	sound_widget_update_volume (self);
	_g_object_unref0 (stream);
}


static void sound_widget_update_volume (SoundWidget* self) {
	gulong _tmp0_ = 0UL;
	gdouble vol_norm = 0.0;
	GvcMixerControl* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	guint32 vol = 0U;
	GvcMixerStream* _tmp15_ = NULL;
	guint32 _tmp16_ = 0U;
	gint n = 0;
	guint32 _tmp17_ = 0U;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gchar* image_name = NULL;
	gboolean _tmp20_ = FALSE;
	GvcMixerStream* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	BudgieHeaderWidget* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp31_ = NULL;
	gdouble _tmp32_ = 0.0;
	gdouble step_size = 0.0;
	gdouble _tmp33_ = 0.0;
	gulong _tmp34_ = 0UL;
	GtkScale* _tmp37_ = NULL;
	gdouble _tmp38_ = 0.0;
	GtkScale* _tmp39_ = NULL;
	guint32 _tmp40_ = 0U;
	GtkScale* _tmp41_ = NULL;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gulong _tmp44_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->output_switch_id;
	if (_tmp0_ > ((gulong) 0)) {
		GtkSwitch* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
		GtkSwitch* _tmp3_ = NULL;
		GvcMixerStream* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GtkSwitch* _tmp7_ = NULL;
		gulong _tmp8_ = 0UL;
		_tmp1_ = self->priv->output_switch;
		_tmp2_ = self->priv->output_switch_id;
		g_signal_handler_block (_tmp1_, _tmp2_);
		_tmp3_ = self->priv->output_switch;
		_tmp4_ = self->priv->output_stream;
		g_object_get (_tmp4_, "is-muted", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		gtk_switch_set_active (_tmp3_, !_tmp6_);
		_tmp7_ = self->priv->output_switch;
		_tmp8_ = self->priv->output_switch_id;
		g_signal_handler_unblock (_tmp7_, _tmp8_);
	} else {
		GtkSwitch* _tmp9_ = NULL;
		GvcMixerStream* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp9_ = self->priv->output_switch;
		_tmp10_ = self->priv->output_stream;
		g_object_get (_tmp10_, "is-muted", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		gtk_switch_set_active (_tmp9_, !_tmp12_);
	}
	_tmp13_ = self->priv->mixer;
	_tmp14_ = gvc_mixer_control_get_vol_max_norm (_tmp13_);
	vol_norm = _tmp14_;
	_tmp15_ = self->priv->output_stream;
	_tmp16_ = gvc_mixer_stream_get_volume (_tmp15_);
	vol = _tmp16_;
	_tmp17_ = vol;
	_tmp18_ = vol_norm;
	_tmp19_ = floor ((3 * _tmp17_) / _tmp18_);
	n = ((gint) _tmp19_) + 1;
	_tmp21_ = self->priv->output_stream;
	_tmp22_ = gvc_mixer_stream_get_is_muted (_tmp21_);
	if (_tmp22_) {
		_tmp20_ = TRUE;
	} else {
		guint32 _tmp23_ = 0U;
		_tmp23_ = vol;
		_tmp20_ = _tmp23_ <= ((guint32) 0);
	}
	if (_tmp20_) {
		gchar* _tmp24_ = NULL;
		_tmp24_ = g_strdup ("audio-volume-muted-symbolic");
		_g_free0 (image_name);
		image_name = _tmp24_;
	} else {
		gint _tmp25_ = 0;
		_tmp25_ = n;
		switch (_tmp25_) {
			case 1:
			{
				gchar* _tmp26_ = NULL;
				_tmp26_ = g_strdup ("audio-volume-low-symbolic");
				_g_free0 (image_name);
				image_name = _tmp26_;
				break;
			}
			case 2:
			{
				gchar* _tmp27_ = NULL;
				_tmp27_ = g_strdup ("audio-volume-medium-symbolic");
				_g_free0 (image_name);
				image_name = _tmp27_;
				break;
			}
			default:
			{
				gchar* _tmp28_ = NULL;
				_tmp28_ = g_strdup ("audio-volume-high-symbolic");
				_g_free0 (image_name);
				image_name = _tmp28_;
				break;
			}
		}
	}
	_tmp29_ = self->priv->header;
	_tmp30_ = image_name;
	budgie_header_widget_set_icon_name (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->mixer;
	_tmp32_ = gvc_mixer_control_get_vol_max_norm (_tmp31_);
	vol_max = _tmp32_;
	_tmp33_ = vol_max;
	step_size = _tmp33_ / 20;
	_tmp34_ = self->priv->scale_id;
	if (_tmp34_ > ((gulong) 0)) {
		GtkScale* _tmp35_ = NULL;
		gulong _tmp36_ = 0UL;
		_tmp35_ = self->priv->scale;
		_tmp36_ = self->priv->scale_id;
		g_signal_handler_block (_tmp35_, _tmp36_);
	}
	_tmp37_ = self->priv->scale;
	_tmp38_ = vol_max;
	gtk_range_set_range ((GtkRange*) _tmp37_, (gdouble) 0, _tmp38_);
	_tmp39_ = self->priv->scale;
	_tmp40_ = vol;
	gtk_range_set_value ((GtkRange*) _tmp39_, (gdouble) _tmp40_);
	_tmp41_ = self->priv->scale;
	_tmp42_ = step_size;
	_tmp43_ = step_size;
	gtk_range_set_increments ((GtkRange*) _tmp41_, _tmp42_, _tmp43_);
	_tmp44_ = self->priv->scale_id;
	if (_tmp44_ > ((gulong) 0)) {
		GtkScale* _tmp45_ = NULL;
		gulong _tmp46_ = 0UL;
		_tmp45_ = self->priv->scale;
		_tmp46_ = self->priv->scale_id;
		g_signal_handler_unblock (_tmp45_, _tmp46_);
	}
	_g_free0 (image_name);
}


static void sound_widget_on_output_selected (SoundWidget* self, GtkToggleButton* btn) {
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint id = 0U;
	GtkToggleButton* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GvcMixerUIDevice* _tmp6_ = NULL;
	GvcMixerUIDevice* _tmp7_ = NULL;
	GvcMixerUIDevice* _tmp8_ = NULL;
	GvcMixerControl* _tmp10_ = NULL;
	GvcMixerUIDevice* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = btn;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = btn;
	_tmp3_ = g_object_get_data ((GObject*) _tmp2_, "output_id");
	id = (guint) ((guintptr) _tmp3_);
	_tmp4_ = self->priv->mixer;
	_tmp5_ = id;
	_tmp6_ = gvc_mixer_control_lookup_output_id (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	device = _tmp7_;
	_tmp8_ = device;
	if (_tmp8_ == NULL) {
		guint _tmp9_ = 0U;
		_tmp9_ = id;
		g_warning ("sound.vala:293: Output selected does not exist! %u", _tmp9_);
		_g_object_unref0 (device);
		return;
	}
	_tmp10_ = self->priv->mixer;
	_tmp11_ = device;
	gvc_mixer_control_change_output (_tmp10_, _tmp11_);
	_g_object_unref0 (device);
}


static void sound_widget_on_input_selected (SoundWidget* self, GtkToggleButton* btn) {
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint id = 0U;
	GtkToggleButton* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GvcMixerUIDevice* _tmp6_ = NULL;
	GvcMixerUIDevice* _tmp7_ = NULL;
	GvcMixerUIDevice* _tmp8_ = NULL;
	GvcMixerControl* _tmp10_ = NULL;
	GvcMixerUIDevice* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = btn;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = btn;
	_tmp3_ = g_object_get_data ((GObject*) _tmp2_, "input_id");
	id = (guint) ((guintptr) _tmp3_);
	_tmp4_ = self->priv->mixer;
	_tmp5_ = id;
	_tmp6_ = gvc_mixer_control_lookup_input_id (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	device = _tmp7_;
	_tmp8_ = device;
	if (_tmp8_ == NULL) {
		guint _tmp9_ = 0U;
		_tmp9_ = id;
		g_warning ("sound.vala:307: Input selected does not exist! %u", _tmp9_);
		_g_object_unref0 (device);
		return;
	}
	_tmp10_ = self->priv->mixer;
	_tmp11_ = device;
	gvc_mixer_control_change_input (_tmp10_, _tmp11_);
	_g_object_unref0 (device);
}


static void _sound_widget_on_output_selected_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	sound_widget_on_output_selected ((SoundWidget*) self, _sender);
}


static void sound_widget_on_output_added (SoundWidget* self, guint id) {
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GvcMixerUIDevice* _tmp5_ = NULL;
	GvcMixerUIDevice* _tmp6_ = NULL;
	GvcMixerCard* card = NULL;
	GvcMixerUIDevice* _tmp7_ = NULL;
	void* _tmp8_ = NULL;
	void* _tmp9_ = NULL;
	GvcMixerCard* _tmp10_ = NULL;
	GtkRadioButton* check = NULL;
	GtkRadioButton* _tmp11_ = NULL;
	GvcMixerUIDevice* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GvcMixerCard* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkRadioButton* _tmp22_ = NULL;
	GtkRadioButton* _tmp23_ = NULL;
	GtkRadioButton* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GtkRadioButton* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	GtkRadioButton* _tmp28_ = NULL;
	guint _tmp29_ = 0U;
	GtkRadioButton* _tmp30_ = NULL;
	GtkBox* _tmp31_ = NULL;
	GtkRadioButton* _tmp32_ = NULL;
	GtkRadioButton* _tmp33_ = NULL;
	GtkRadioButton* _tmp34_ = NULL;
	GHashTable* _tmp38_ = NULL;
	guint _tmp39_ = 0U;
	GtkRadioButton* _tmp40_ = NULL;
	GtkRadioButton* _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->outputs;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->mixer;
	_tmp4_ = id;
	_tmp5_ = gvc_mixer_control_lookup_output_id (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	device = _tmp6_;
	_tmp7_ = device;
	g_object_get (_tmp7_, "card", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gvc_mixer_card_get_type ()) ? ((GvcMixerCard*) _tmp9_) : NULL);
	card = _tmp10_;
	_tmp11_ = self->priv->output_leader;
	_tmp12_ = device;
	g_object_get (_tmp12_, "description", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = card;
	g_object_get (_tmp16_, "name", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s - %s", _tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp11_, _tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp15_);
	check = _tmp23_;
	_tmp24_ = check;
	_tmp25_ = gtk_bin_get_child ((GtkBin*) _tmp24_);
	gtk_label_set_ellipsize (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp25_) : NULL, PANGO_ELLIPSIZE_END);
	_tmp26_ = check;
	_tmp27_ = gtk_bin_get_child ((GtkBin*) _tmp26_);
	gtk_label_set_max_width_chars (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp27_) : NULL, 30);
	_tmp28_ = check;
	_tmp29_ = id;
	g_object_set_data_full ((GObject*) _tmp28_, "output_id", (gpointer) ((guintptr) _tmp29_), NULL);
	_tmp30_ = check;
	g_signal_connect_object ((GtkToggleButton*) _tmp30_, "toggled", (GCallback) _sound_widget_on_output_selected_gtk_toggle_button_toggled, self, 0);
	_tmp31_ = self->priv->output_box;
	_tmp32_ = check;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	_tmp33_ = check;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->output_leader;
	if (_tmp34_ == NULL) {
		GtkRadioButton* _tmp35_ = NULL;
		GtkRadioButton* _tmp36_ = NULL;
		GtkRadioButton* _tmp37_ = NULL;
		_tmp35_ = check;
		_tmp36_ = _g_object_ref0 (_tmp35_);
		_g_object_unref0 (self->priv->output_leader);
		self->priv->output_leader = _tmp36_;
		_tmp37_ = check;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp37_, 3);
	}
	_tmp38_ = self->priv->outputs;
	_tmp39_ = id;
	_tmp40_ = check;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	g_hash_table_insert (_tmp38_, (gpointer) ((guintptr) _tmp39_), _tmp41_);
	_g_object_unref0 (check);
	_g_object_unref0 (card);
	_g_object_unref0 (device);
}


static void _sound_widget_on_input_selected_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	sound_widget_on_input_selected ((SoundWidget*) self, _sender);
}


static void sound_widget_on_input_added (SoundWidget* self, guint id) {
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GvcMixerUIDevice* _tmp5_ = NULL;
	GvcMixerUIDevice* _tmp6_ = NULL;
	GvcMixerCard* card = NULL;
	GvcMixerUIDevice* _tmp7_ = NULL;
	void* _tmp8_ = NULL;
	void* _tmp9_ = NULL;
	GvcMixerCard* _tmp10_ = NULL;
	GtkRadioButton* check = NULL;
	GtkRadioButton* _tmp11_ = NULL;
	GvcMixerUIDevice* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GvcMixerCard* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkRadioButton* _tmp22_ = NULL;
	GtkRadioButton* _tmp23_ = NULL;
	GtkRadioButton* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GtkRadioButton* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	GtkRadioButton* _tmp28_ = NULL;
	guint _tmp29_ = 0U;
	GtkRadioButton* _tmp30_ = NULL;
	GtkBox* _tmp31_ = NULL;
	GtkRadioButton* _tmp32_ = NULL;
	GtkRadioButton* _tmp33_ = NULL;
	GtkRadioButton* _tmp34_ = NULL;
	GHashTable* _tmp38_ = NULL;
	guint _tmp39_ = 0U;
	GtkRadioButton* _tmp40_ = NULL;
	GtkRadioButton* _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->inputs;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->mixer;
	_tmp4_ = id;
	_tmp5_ = gvc_mixer_control_lookup_input_id (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	device = _tmp6_;
	_tmp7_ = device;
	g_object_get (_tmp7_, "card", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gvc_mixer_card_get_type ()) ? ((GvcMixerCard*) _tmp9_) : NULL);
	card = _tmp10_;
	_tmp11_ = self->priv->input_leader;
	_tmp12_ = device;
	g_object_get (_tmp12_, "description", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = card;
	g_object_get (_tmp16_, "name", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s - %s", _tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp11_, _tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp15_);
	check = _tmp23_;
	_tmp24_ = check;
	_tmp25_ = gtk_bin_get_child ((GtkBin*) _tmp24_);
	gtk_label_set_ellipsize (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp25_) : NULL, PANGO_ELLIPSIZE_END);
	_tmp26_ = check;
	_tmp27_ = gtk_bin_get_child ((GtkBin*) _tmp26_);
	gtk_label_set_max_width_chars (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp27_) : NULL, 30);
	_tmp28_ = check;
	_tmp29_ = id;
	g_object_set_data_full ((GObject*) _tmp28_, "input_id", (gpointer) ((guintptr) _tmp29_), NULL);
	_tmp30_ = check;
	g_signal_connect_object ((GtkToggleButton*) _tmp30_, "toggled", (GCallback) _sound_widget_on_input_selected_gtk_toggle_button_toggled, self, 0);
	_tmp31_ = self->priv->input_box;
	_tmp32_ = check;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	_tmp33_ = check;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->input_leader;
	if (_tmp34_ == NULL) {
		GtkRadioButton* _tmp35_ = NULL;
		GtkRadioButton* _tmp36_ = NULL;
		GtkRadioButton* _tmp37_ = NULL;
		_tmp35_ = check;
		_tmp36_ = _g_object_ref0 (_tmp35_);
		_g_object_unref0 (self->priv->input_leader);
		self->priv->input_leader = _tmp36_;
		_tmp37_ = check;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp37_, 3);
	}
	_tmp38_ = self->priv->inputs;
	_tmp39_ = id;
	_tmp40_ = check;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	g_hash_table_insert (_tmp38_, (gpointer) ((guintptr) _tmp39_), _tmp41_);
	_g_object_unref0 (check);
	_g_object_unref0 (card);
	_g_object_unref0 (device);
}


static void sound_widget_on_output_removed (SoundWidget* self, guint id) {
	GtkRadioButton* btn = NULL;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
	GtkRadioButton* _tmp3_ = NULL;
	GtkRadioButton* _tmp4_ = NULL;
	GHashTable* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GtkRadioButton* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->outputs;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	_tmp3_ = _g_object_ref0 ((GtkRadioButton*) _tmp2_);
	btn = _tmp3_;
	_tmp4_ = btn;
	if (_tmp4_ == NULL) {
		guint _tmp5_ = 0U;
		_tmp5_ = id;
		g_warning ("sound.vala:367: Removing id we don\'t know about: %u", _tmp5_);
		_g_object_unref0 (btn);
		return;
	}
	_tmp6_ = self->priv->outputs;
	_tmp7_ = id;
	g_hash_table_steal (_tmp6_, (gpointer) ((guintptr) _tmp7_));
	_tmp8_ = btn;
	gtk_widget_destroy ((GtkWidget*) _tmp8_);
	_g_object_unref0 (btn);
}


static void sound_widget_on_input_removed (SoundWidget* self, guint id) {
	GtkRadioButton* btn = NULL;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
	GtkRadioButton* _tmp3_ = NULL;
	GtkRadioButton* _tmp4_ = NULL;
	GHashTable* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GtkRadioButton* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->inputs;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	_tmp3_ = _g_object_ref0 ((GtkRadioButton*) _tmp2_);
	btn = _tmp3_;
	_tmp4_ = btn;
	if (_tmp4_ == NULL) {
		guint _tmp5_ = 0U;
		_tmp5_ = id;
		g_warning ("sound.vala:378: Removing id we don\'t know about: %u", _tmp5_);
		_g_object_unref0 (btn);
		return;
	}
	_tmp6_ = self->priv->inputs;
	_tmp7_ = id;
	g_hash_table_steal (_tmp6_, (gpointer) ((guintptr) _tmp7_));
	_tmp8_ = btn;
	gtk_widget_destroy ((GtkWidget*) _tmp8_);
	_g_object_unref0 (btn);
}


static void sound_widget_update_mixers (SoundWidget* self) {
	g_return_if_fail (self != NULL);
}


static void sound_widget_on_state_changed (SoundWidget* self, guint state) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = state;
	switch (_tmp0_) {
		case GVC_STATE_READY:
		{
			sound_widget_update_mixers (self);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void sound_widget_class_init (SoundWidgetClass * klass) {
	sound_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SoundWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = sound_widget_finalize;
}


static void sound_widget_instance_init (SoundWidget * self) {
	self->priv = SOUND_WIDGET_GET_PRIVATE (self);
	self->priv->scale = NULL;
	self->priv->scale_id = (gulong) 0;
	self->priv->mixer = NULL;
	self->priv->output_switch = NULL;
	self->priv->output_switch_id = (gulong) 0;
	self->priv->output_box = NULL;
	self->priv->output_leader = NULL;
	self->priv->output_stream = NULL;
	self->priv->output_notify_id = (gulong) 0;
	self->priv->input_switch = NULL;
	self->priv->input_switch_id = (gulong) 0;
	self->priv->input_box = NULL;
	self->priv->input_leader = NULL;
	self->priv->input_stream = NULL;
	self->priv->input_notify_id = (gulong) 0;
	self->priv->header = NULL;
}


static void sound_widget_finalize (GObject* obj) {
	SoundWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND_WIDGET, SoundWidget);
	_g_object_unref0 (self->priv->scale);
	_g_object_unref0 (self->priv->mixer);
	_g_object_unref0 (self->priv->output_switch);
	_g_object_unref0 (self->priv->output_box);
	_g_object_unref0 (self->priv->output_leader);
	_g_hash_table_unref0 (self->priv->outputs);
	_g_object_unref0 (self->priv->output_stream);
	_g_object_unref0 (self->priv->input_switch);
	_g_object_unref0 (self->priv->input_box);
	_g_object_unref0 (self->priv->input_leader);
	_g_hash_table_unref0 (self->priv->inputs);
	_g_object_unref0 (self->priv->input_stream);
	_g_object_unref0 (self->priv->header);
	G_OBJECT_CLASS (sound_widget_parent_class)->finalize (obj);
}


GType sound_widget_get_type (void) {
	static volatile gsize sound_widget_type_id__volatile = 0;
	if (g_once_init_enter (&sound_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SoundWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundWidget), 0, (GInstanceInitFunc) sound_widget_instance_init, NULL };
		GType sound_widget_type_id;
		sound_widget_type_id = g_type_register_static (gtk_box_get_type (), "SoundWidget", &g_define_type_info, 0);
		g_once_init_leave (&sound_widget_type_id__volatile, sound_widget_type_id);
	}
	return sound_widget_type_id__volatile;
}



