/* background.c generated by valac 0.32.1, the Vala compiler
 * generated from background.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-background-group.h>
#include <meta/screen.h>
#include <gio/gio.h>
#include <clutter/clutter.h>
#include <meta/meta-background-image.h>
#include <libgnome-desktop/gnome-bg-crossfade.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <libgnome-desktop/gnome-bg.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <libgnome-desktop/gnome-idle-monitor.h>
#include <libgnome-desktop/gnome-languages.h>
#include <libgnome-desktop/gnome-pnp-ids.h>
#include <libgnome-desktop/gnome-rr-config.h>
#include <libgnome-desktop/gnome-rr.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <meta/boxes.h>
#include <float.h>
#include <math.h>
#include <meta/meta-background.h>
#include <meta/meta-background-actor.h>


#define BUDGIE_TYPE_BUDGIE_BACKGROUND (budgie_budgie_background_get_type ())
#define BUDGIE_BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground))
#define BUDGIE_BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundClass))
#define BUDGIE_IS_BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND))
#define BUDGIE_IS_BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_BACKGROUND))
#define BUDGIE_BUDGIE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundClass))

typedef struct _BudgieBudgieBackground BudgieBudgieBackground;
typedef struct _BudgieBudgieBackgroundClass BudgieBudgieBackgroundClass;
typedef struct _BudgieBudgieBackgroundPrivate BudgieBudgieBackgroundPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _BudgieBudgieBackgroundLoadUriData BudgieBudgieBackgroundLoadUriData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

struct _BudgieBudgieBackground {
	MetaBackgroundGroup parent_instance;
	BudgieBudgieBackgroundPrivate * priv;
};

struct _BudgieBudgieBackgroundClass {
	MetaBackgroundGroupClass parent_class;
};

struct _BudgieBudgieBackgroundPrivate {
	MetaScreen* _screen;
	gint _index;
	GSettings* settings;
	ClutterActor* bg;
	ClutterActor* old_bg;
	MetaBackgroundImageCache* cache;
	GnomeBG* gnome_bg;
	GHashTable* images;
};

struct _Block1Data {
	int _ref_count_;
	BudgieBudgieBackground* self;
	MetaBackgroundImage* image;
	gulong rid;
	gpointer _async_data_;
};

struct _BudgieBudgieBackgroundLoadUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieBudgieBackground* self;
	gchar* uri;
	Block1Data* _data1_;
	GHashTable* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GFile* f;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	MetaBackgroundImageCache* _tmp6_;
	GFile* _tmp7_;
	MetaBackgroundImage* _tmp8_;
	MetaBackgroundImage* _tmp9_;
	gboolean _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	MetaBackgroundImage* _tmp14_;
	MetaBackgroundImage* _tmp15_;
	MetaBackgroundImage* _tmp16_;
	gulong _tmp17_;
};

struct _Block2Data {
	int _ref_count_;
	BudgieBudgieBackground* self;
	MetaBackground* background;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GFile* bg_file;
};


static gpointer budgie_budgie_background_parent_class = NULL;

#define BUDGIE_BACKGROUND_SCHEMA "org.gnome.desktop.background"
#define BUDGIE_PICTURE_URI_KEY "picture-uri"
#define BUDGIE_PRIMARY_COLOR_KEY "primary-color"
#define BUDGIE_SECONDARY_COLOR_KEY "secondary-color"
#define BUDGIE_COLOR_SHADING_TYPE_KEY "color-shading-type"
#define BUDGIE_BACKGROUND_STYLE_KEY "picture-options"
#define BUDGIE_GNOME_COLOR_HACK "gnome-control-center/pixmaps/noise-texture-light.png"
GType budgie_budgie_background_get_type (void) G_GNUC_CONST;
#define BUDGIE_BUDGIE_BACKGROUND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundPrivate))
enum  {
	BUDGIE_BUDGIE_BACKGROUND_DUMMY_PROPERTY,
	BUDGIE_BUDGIE_BACKGROUND_SCREEN,
	BUDGIE_BUDGIE_BACKGROUND_INDEX
};
#define BUDGIE_BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT 850
static gboolean budgie_budgie_background_is_color_wallpaper (BudgieBudgieBackground* self, const gchar* bg_filename);
BudgieBudgieBackground* budgie_budgie_background_new (MetaScreen* screen, gint index);
BudgieBudgieBackground* budgie_budgie_background_construct (GType object_type, MetaScreen* screen, gint index);
gint budgie_budgie_background_get_index (BudgieBudgieBackground* self);
static gboolean __lambda4_ (BudgieBudgieBackground* self);
static gboolean ___lambda4__g_settings_change_event (GSettings* _sender, GQuark* keys, int keys_length1, gpointer self);
static void __lambda5_ (BudgieBudgieBackground* self);
static void budgie_budgie_background_update (BudgieBudgieBackground* self);
static void ___lambda5__gnome_bg_changed (GnomeBG* _sender, gpointer self);
static void budgie_budgie_background_remove_old (BudgieBudgieBackground* self, ClutterActor* actor);
static void budgie_budgie_background_load_uri_data_free (gpointer _data);
static void budgie_budgie_background_load_uri (BudgieBudgieBackground* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void budgie_budgie_background_load_uri_finish (BudgieBudgieBackground* self, GAsyncResult* _res_);
static gboolean budgie_budgie_background_load_uri_co (BudgieBudgieBackgroundLoadUriData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void __lambda6_ (Block1Data* _data1_);
static gboolean _budgie_budgie_background_load_uri_co_gsource_func (gpointer self);
static void ___lambda6__meta_background_image_loaded (MetaBackgroundImage* _sender, gpointer self);
static void budgie_budgie_background_begin_remove_old (BudgieBudgieBackground* self, ClutterActor* actor);
static void _budgie_budgie_background_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void budgie_budgie_background_on_update (BudgieBudgieBackground* self);
static void _budgie_budgie_background_begin_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static ClutterColor* _clutter_color_dup (ClutterColor* self);
MetaScreen* budgie_budgie_background_get_screen (BudgieBudgieBackground* self);
static void _budgie_budgie_background_on_update_meta_background_changed (MetaBackground* _sender, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda7_ (Block3Data* _data3_);
static void ____lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void budgie_budgie_background_set_screen (BudgieBudgieBackground* self, MetaScreen* value);
void budgie_budgie_background_set_index (BudgieBudgieBackground* self, gint value);
static void budgie_budgie_background_finalize (GObject* obj);
static void _vala_budgie_budgie_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_budgie_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Determine if the wallpaper is a colour wallpaper or not
     */
static gboolean budgie_budgie_background_is_color_wallpaper (BudgieBudgieBackground* self, const gchar* bg_filename) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GnomeBG* _tmp1_ = NULL;
	GDesktopBackgroundStyle _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bg_filename != NULL, FALSE);
	_tmp1_ = self->priv->gnome_bg;
	_tmp2_ = gnome_bg_get_placement (_tmp1_);
	if (_tmp2_ == G_DESKTOP_BACKGROUND_STYLE_NONE) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = bg_filename;
		_tmp4_ = g_str_has_suffix (_tmp3_, BUDGIE_GNOME_COLOR_HACK);
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda4_ (BudgieBudgieBackground* self) {
	gboolean result = FALSE;
	GnomeBG* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	_tmp0_ = self->priv->gnome_bg;
	_tmp1_ = self->priv->settings;
	gnome_bg_load_from_preferences (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ___lambda4__g_settings_change_event (GSettings* _sender, GQuark* keys, int keys_length1, gpointer self) {
	gboolean result;
	result = __lambda4_ ((BudgieBudgieBackground*) self);
	return result;
}


static void __lambda5_ (BudgieBudgieBackground* self) {
	budgie_budgie_background_update (self);
}


static void ___lambda5__gnome_bg_changed (GnomeBG* _sender, gpointer self) {
	__lambda5_ ((BudgieBudgieBackground*) self);
}


BudgieBudgieBackground* budgie_budgie_background_construct (GType object_type, MetaScreen* screen, gint index) {
	BudgieBudgieBackground * self = NULL;
	MetaScreen* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	MetaRectangle rect = {0};
	MetaBackgroundImageCache* _tmp2_ = NULL;
	MetaBackgroundImageCache* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GnomeBG* _tmp5_ = NULL;
	MetaScreen* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	MetaRectangle _tmp8_ = {0};
	MetaRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	MetaRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	MetaRectangle _tmp13_ = {0};
	gint _tmp14_ = 0;
	MetaRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	GnomeBG* _tmp18_ = NULL;
	ClutterColor* _tmp19_ = NULL;
	GnomeBG* _tmp20_ = NULL;
	GSettings* _tmp21_ = NULL;
	_tmp0_ = screen;
	_tmp1_ = index;
	self = (BudgieBudgieBackground*) g_object_new (object_type, "screen", _tmp0_, "index", _tmp1_, NULL);
	_tmp2_ = meta_background_image_cache_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = gnome_bg_new ();
	_g_object_unref0 (self->priv->gnome_bg);
	self->priv->gnome_bg = _tmp5_;
	_tmp6_ = screen;
	_tmp7_ = self->priv->_index;
	meta_screen_get_monitor_geometry (_tmp6_, _tmp7_, &_tmp8_);
	rect = _tmp8_;
	_tmp9_ = rect;
	_tmp10_ = _tmp9_.x;
	_tmp11_ = rect;
	_tmp12_ = _tmp11_.y;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp10_, (gfloat) _tmp12_);
	_tmp13_ = rect;
	_tmp14_ = _tmp13_.width;
	_tmp15_ = rect;
	_tmp16_ = _tmp15_.height;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp14_, (gfloat) _tmp16_);
	_tmp17_ = self->priv->settings;
	g_signal_connect_object (_tmp17_, "change-event", (GCallback) ___lambda4__g_settings_change_event, self, 0);
	_tmp18_ = self->priv->gnome_bg;
	g_signal_connect_object (_tmp18_, "changed", (GCallback) ___lambda5__gnome_bg_changed, self, 0);
	_tmp19_ = clutter_color_get_static (CLUTTER_COLOR_BLACK);
	clutter_actor_set_background_color ((ClutterActor*) self, _tmp19_);
	_tmp20_ = self->priv->gnome_bg;
	_tmp21_ = self->priv->settings;
	gnome_bg_load_from_preferences (_tmp20_, _tmp21_);
	return self;
}


BudgieBudgieBackground* budgie_budgie_background_new (MetaScreen* screen, gint index) {
	return budgie_budgie_background_construct (BUDGIE_TYPE_BUDGIE_BACKGROUND, screen, index);
}


static void budgie_budgie_background_remove_old (BudgieBudgieBackground* self, ClutterActor* actor) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = actor;
	clutter_actor_destroy (_tmp0_);
	_g_object_unref0 (self->priv->old_bg);
	self->priv->old_bg = NULL;
}


static void budgie_budgie_background_load_uri_data_free (gpointer _data) {
	BudgieBudgieBackgroundLoadUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieBudgieBackgroundLoadUriData, _data_);
}


static void budgie_budgie_background_load_uri (BudgieBudgieBackground* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieBudgieBackgroundLoadUriData* _data_;
	BudgieBudgieBackground* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (BudgieBudgieBackgroundLoadUriData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_budgie_background_load_uri);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_budgie_background_load_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	budgie_budgie_background_load_uri_co (_data_);
}


static void budgie_budgie_background_load_uri_finish (BudgieBudgieBackground* self, GAsyncResult* _res_) {
	BudgieBudgieBackgroundLoadUriData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Load the image from the meta background cache
     *
     * Note we purposefully load the image into the cache manually, as this will
     * enable smooth background transitions
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieBudgieBackground* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->image);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gboolean _budgie_budgie_background_load_uri_co_gsource_func (gpointer self) {
	gboolean result;
	result = budgie_budgie_background_load_uri_co (self);
	return result;
}


static void __lambda6_ (Block1Data* _data1_) {
	BudgieBudgieBackground* self;
	MetaBackgroundImage* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	self = _data1_->self;
	_tmp0_ = _data1_->image;
	_tmp1_ = _data1_->rid;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_budgie_background_load_uri_co_gsource_func, _data1_->_async_data_, NULL);
}


static void ___lambda6__meta_background_image_loaded (MetaBackgroundImage* _sender, gpointer self) {
	__lambda6_ (self);
}


static gboolean budgie_budgie_background_load_uri_co (BudgieBudgieBackgroundLoadUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->images;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_str_hash;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_str_equal;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_hash_table_new_full (_data_->_tmp1_, _data_->_tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (_data_->self->priv->images);
		_data_->self->priv->images = _data_->_tmp3_;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->uri;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_file_new_for_uri (_data_->_tmp4_);
	_data_->f = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->cache;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->f;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = meta_background_image_cache_load (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_data1_->image = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data1_->image;
	_data_->_tmp10_ = FALSE;
	_data_->_tmp10_ = meta_background_image_is_loaded (_data_->_tmp9_);
	if (_data_->_tmp10_) {
		_g_object_unref0 (_data_->f);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->self->priv->images;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->uri;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_data1_->image;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
	g_hash_table_insert (_data_->_tmp11_, _data_->_tmp13_, _data_->_tmp15_);
	_data_->_data1_->rid = (gulong) 0;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_data1_->image;
	_data_->_tmp17_ = 0UL;
	_data_->_tmp17_ = g_signal_connect_data (_data_->_tmp16_, "loaded", (GCallback) ___lambda6__meta_background_image_loaded, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_data1_->rid = _data_->_tmp17_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->f);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->f);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Remove the old wallpaper during the new wallpaper update
     */
static void _budgie_budgie_background_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
	budgie_budgie_background_remove_old ((BudgieBudgieBackground*) self, _sender);
}


static void budgie_budgie_background_begin_remove_old (BudgieBudgieBackground* self, ClutterActor* actor) {
	gboolean _tmp0_ = FALSE;
	ClutterActor* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->old_bg;
	if (_tmp1_ != NULL) {
		ClutterActor* _tmp2_ = NULL;
		ClutterActor* _tmp3_ = NULL;
		_tmp2_ = self->priv->old_bg;
		_tmp3_ = self->priv->bg;
		_tmp0_ = _tmp2_ != _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ClutterActor* _tmp4_ = NULL;
		ClutterActor* _tmp5_ = NULL;
		ClutterActor* _tmp6_ = NULL;
		ClutterActor* _tmp7_ = NULL;
		ClutterActor* _tmp8_ = NULL;
		ClutterActor* _tmp9_ = NULL;
		_tmp4_ = self->priv->old_bg;
		g_signal_connect_object (_tmp4_, "transitions-completed", (GCallback) _budgie_budgie_background_remove_old_clutter_actor_transitions_completed, self, 0);
		_tmp5_ = self->priv->old_bg;
		clutter_actor_save_easing_state (_tmp5_);
		_tmp6_ = self->priv->old_bg;
		clutter_actor_set_easing_mode (_tmp6_, CLUTTER_EASE_OUT_QUAD);
		_tmp7_ = self->priv->old_bg;
		clutter_actor_set_easing_duration (_tmp7_, (guint) BUDGIE_BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT);
		_tmp8_ = self->priv->old_bg;
		g_object_set ((GObject*) _tmp8_, "opacity", 0, NULL);
		_tmp9_ = self->priv->old_bg;
		clutter_actor_restore_easing_state (_tmp9_);
	}
}


/**
     * Wallpaper updated, begin modifying the new one
     */
static void _budgie_budgie_background_begin_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
	budgie_budgie_background_begin_remove_old ((BudgieBudgieBackground*) self, _sender);
}


static void budgie_budgie_background_on_update (BudgieBudgieBackground* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bg;
	clutter_actor_save_easing_state (_tmp0_);
	_tmp1_ = self->priv->bg;
	g_signal_connect_object (_tmp1_, "transitions-completed", (GCallback) _budgie_budgie_background_begin_remove_old_clutter_actor_transitions_completed, self, 0);
	_tmp2_ = self->priv->bg;
	clutter_actor_set_easing_mode (_tmp2_, CLUTTER_EASE_IN_EXPO);
	_tmp3_ = self->priv->bg;
	clutter_actor_set_easing_duration (_tmp3_, (guint) BUDGIE_BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT);
	_tmp4_ = self->priv->bg;
	g_object_set ((GObject*) _tmp4_, "opacity", 255, NULL);
	_tmp5_ = self->priv->bg;
	clutter_actor_restore_easing_state (_tmp5_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieBudgieBackground* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->background);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static ClutterColor* _clutter_color_dup (ClutterColor* self) {
	ClutterColor* dup;
	dup = g_new0 (ClutterColor, 1);
	memcpy (dup, self, sizeof (ClutterColor));
	return dup;
}


static gpointer __clutter_color_dup0 (gpointer self) {
	return self ? _clutter_color_dup (self) : NULL;
}


static void _budgie_budgie_background_on_update_meta_background_changed (MetaBackground* _sender, gpointer self) {
	budgie_budgie_background_on_update ((BudgieBudgieBackground*) self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieBudgieBackground* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->bg_file);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static void ___lambda7_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	BudgieBudgieBackground* self;
	MetaBackground* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GnomeBG* _tmp2_ = NULL;
	GDesktopBackgroundStyle _tmp3_ = 0;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->background;
	_tmp1_ = _data3_->bg_file;
	_tmp2_ = self->priv->gnome_bg;
	_tmp3_ = gnome_bg_get_placement (_tmp2_);
	meta_background_set_file (_tmp0_, _tmp1_, _tmp3_);
	budgie_budgie_background_on_update (self);
}


static void ____lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda7_ (self);
	block3_data_unref (self);
}


static void budgie_budgie_background_update (BudgieBudgieBackground* self) {
	Block2Data* _data2_;
	gchar* bg_filename = NULL;
	GnomeBG* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GDesktopBackgroundShading shading_direction = 0;
	MetaRectangle rect = {0};
	ClutterColor* primary_color = NULL;
	ClutterColor _tmp3_ = {0};
	ClutterColor* _tmp4_ = NULL;
	ClutterColor* secondary_color = NULL;
	ClutterColor _tmp5_ = {0};
	ClutterColor* _tmp6_ = NULL;
	MetaBackgroundActor* actor = NULL;
	MetaScreen* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	MetaBackgroundActor* _tmp9_ = NULL;
	MetaScreen* _tmp10_ = NULL;
	MetaBackground* _tmp11_ = NULL;
	MetaBackgroundActor* _tmp12_ = NULL;
	MetaBackground* _tmp13_ = NULL;
	MetaScreen* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	MetaRectangle _tmp16_ = {0};
	MetaBackgroundActor* _tmp17_ = NULL;
	MetaRectangle _tmp18_ = {0};
	gint _tmp19_ = 0;
	MetaRectangle _tmp20_ = {0};
	gint _tmp21_ = 0;
	MetaBackgroundActor* _tmp22_ = NULL;
	MetaBackgroundActor* _tmp23_ = NULL;
	MetaBackgroundActor* _tmp24_ = NULL;
	ClutterActor* _tmp25_ = NULL;
	MetaBackgroundActor* _tmp28_ = NULL;
	ClutterActor* _tmp29_ = NULL;
	GSettings* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gchar* color_str = NULL;
	GSettings* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp35_ = NULL;
	GSettings* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp43_ = NULL;
	gboolean _tmp48_ = FALSE;
	const gchar* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->gnome_bg;
	_tmp1_ = gnome_bg_get_filename (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	bg_filename = _tmp2_;
	memset (&_tmp3_, 0, sizeof (ClutterColor));
	_tmp4_ = __clutter_color_dup0 (&_tmp3_);
	primary_color = _tmp4_;
	memset (&_tmp5_, 0, sizeof (ClutterColor));
	_tmp6_ = __clutter_color_dup0 (&_tmp5_);
	secondary_color = _tmp6_;
	_tmp7_ = self->priv->_screen;
	_tmp8_ = self->priv->_index;
	_tmp9_ = (MetaBackgroundActor*) meta_background_actor_new (_tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	actor = _tmp9_;
	_tmp10_ = self->priv->_screen;
	_tmp11_ = meta_background_new (_tmp10_);
	_data2_->background = _tmp11_;
	_tmp12_ = actor;
	_tmp13_ = _data2_->background;
	meta_background_actor_set_background (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->_screen;
	_tmp15_ = self->priv->_index;
	meta_screen_get_monitor_geometry (_tmp14_, _tmp15_, &_tmp16_);
	rect = _tmp16_;
	_tmp17_ = actor;
	_tmp18_ = rect;
	_tmp19_ = _tmp18_.width;
	_tmp20_ = rect;
	_tmp21_ = _tmp20_.height;
	clutter_actor_set_size ((ClutterActor*) _tmp17_, (gfloat) _tmp19_, (gfloat) _tmp21_);
	_tmp22_ = actor;
	g_object_set ((GObject*) _tmp22_, "opacity", 0, NULL);
	_tmp23_ = actor;
	clutter_actor_show ((ClutterActor*) _tmp23_);
	_tmp24_ = actor;
	clutter_actor_insert_child_at_index ((ClutterActor*) self, (ClutterActor*) _tmp24_, -1);
	_tmp25_ = self->priv->bg;
	if (_tmp25_ != NULL) {
		ClutterActor* _tmp26_ = NULL;
		ClutterActor* _tmp27_ = NULL;
		_tmp26_ = self->priv->bg;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_g_object_unref0 (self->priv->old_bg);
		self->priv->old_bg = _tmp27_;
	}
	_tmp28_ = actor;
	_tmp29_ = _g_object_ref0 ((ClutterActor*) _tmp28_);
	_g_object_unref0 (self->priv->bg);
	self->priv->bg = _tmp29_;
	_tmp30_ = self->priv->settings;
	_tmp31_ = g_settings_get_enum (_tmp30_, BUDGIE_COLOR_SHADING_TYPE_KEY);
	shading_direction = (GDesktopBackgroundShading) _tmp31_;
	_tmp32_ = self->priv->settings;
	_tmp33_ = g_settings_get_string (_tmp32_, BUDGIE_PRIMARY_COLOR_KEY);
	color_str = _tmp33_;
	_tmp35_ = color_str;
	if (_tmp35_ != NULL) {
		const gchar* _tmp36_ = NULL;
		_tmp36_ = color_str;
		_tmp34_ = g_strcmp0 (_tmp36_, "") != 0;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		const gchar* _tmp37_ = NULL;
		ClutterColor _tmp38_ = {0};
		ClutterColor* _tmp39_ = NULL;
		_tmp37_ = color_str;
		clutter_color_from_string (&_tmp38_, _tmp37_);
		_tmp39_ = __clutter_color_dup0 (&_tmp38_);
		_g_free0 (primary_color);
		primary_color = _tmp39_;
		_g_free0 (color_str);
		color_str = NULL;
	}
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_get_string (_tmp40_, BUDGIE_SECONDARY_COLOR_KEY);
	_g_free0 (color_str);
	color_str = _tmp41_;
	_tmp43_ = color_str;
	if (_tmp43_ != NULL) {
		const gchar* _tmp44_ = NULL;
		_tmp44_ = color_str;
		_tmp42_ = g_strcmp0 (_tmp44_, "") != 0;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		const gchar* _tmp45_ = NULL;
		ClutterColor _tmp46_ = {0};
		ClutterColor* _tmp47_ = NULL;
		_tmp45_ = color_str;
		clutter_color_from_string (&_tmp46_, _tmp45_);
		_tmp47_ = __clutter_color_dup0 (&_tmp46_);
		_g_free0 (secondary_color);
		secondary_color = _tmp47_;
		_g_free0 (color_str);
		color_str = NULL;
	}
	_tmp49_ = bg_filename;
	_tmp50_ = budgie_budgie_background_is_color_wallpaper (self, _tmp49_);
	if (_tmp50_) {
		_tmp48_ = TRUE;
	} else {
		const gchar* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		_tmp51_ = bg_filename;
		_tmp52_ = g_str_has_suffix (_tmp51_, ".xml");
		_tmp48_ = _tmp52_;
	}
	if (_tmp48_) {
		MetaBackground* _tmp53_ = NULL;
		GDesktopBackgroundShading _tmp54_ = 0;
		_tmp53_ = _data2_->background;
		g_signal_connect_object (_tmp53_, "changed", (GCallback) _budgie_budgie_background_on_update_meta_background_changed, self, 0);
		_tmp54_ = shading_direction;
		if (_tmp54_ == G_DESKTOP_BACKGROUND_SHADING_SOLID) {
			MetaBackground* _tmp55_ = NULL;
			ClutterColor* _tmp56_ = NULL;
			ClutterColor _tmp57_ = {0};
			_tmp55_ = _data2_->background;
			_tmp56_ = primary_color;
			_tmp57_ = *_tmp56_;
			meta_background_set_color (_tmp55_, &_tmp57_);
		} else {
			MetaBackground* _tmp58_ = NULL;
			GDesktopBackgroundShading _tmp59_ = 0;
			ClutterColor* _tmp60_ = NULL;
			ClutterColor* _tmp61_ = NULL;
			ClutterColor _tmp62_ = {0};
			ClutterColor _tmp63_ = {0};
			_tmp58_ = _data2_->background;
			_tmp59_ = shading_direction;
			_tmp60_ = primary_color;
			_tmp61_ = secondary_color;
			_tmp62_ = *_tmp60_;
			_tmp63_ = *_tmp61_;
			meta_background_set_gradient (_tmp58_, _tmp59_, &_tmp62_, &_tmp63_);
		}
	} else {
		Block3Data* _data3_;
		const gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		GFile* _tmp67_ = NULL;
		GFile* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp64_ = bg_filename;
		_tmp65_ = g_strconcat ("file://", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_file_new_for_uri (_tmp66_);
		_tmp68_ = _tmp67_;
		_g_free0 (_tmp66_);
		_data3_->bg_file = _tmp68_;
		_tmp69_ = bg_filename;
		_tmp70_ = g_strconcat ("file://", _tmp69_, NULL);
		_tmp71_ = _tmp70_;
		budgie_budgie_background_load_uri (self, _tmp71_, ____lambda7__gasync_ready_callback, block3_data_ref (_data3_));
		_g_free0 (_tmp71_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	_g_free0 (color_str);
	_g_object_unref0 (actor);
	_g_free0 (secondary_color);
	_g_free0 (primary_color);
	_g_free0 (bg_filename);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


MetaScreen* budgie_budgie_background_get_screen (BudgieBudgieBackground* self) {
	MetaScreen* result;
	MetaScreen* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_screen;
	result = _tmp0_;
	return result;
}


void budgie_budgie_background_set_screen (BudgieBudgieBackground* self, MetaScreen* value) {
	MetaScreen* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_screen = _tmp0_;
	g_object_notify ((GObject *) self, "screen");
}


gint budgie_budgie_background_get_index (BudgieBudgieBackground* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_index;
	result = _tmp0_;
	return result;
}


void budgie_budgie_background_set_index (BudgieBudgieBackground* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_index = _tmp0_;
	g_object_notify ((GObject *) self, "index");
}


static void budgie_budgie_background_class_init (BudgieBudgieBackgroundClass * klass) {
	budgie_budgie_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieBudgieBackgroundPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_budgie_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_budgie_background_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_budgie_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BUDGIE_BACKGROUND_SCREEN, g_param_spec_object ("screen", "screen", "screen", meta_screen_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BUDGIE_BACKGROUND_INDEX, g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void budgie_budgie_background_instance_init (BudgieBudgieBackground * self) {
	self->priv = BUDGIE_BUDGIE_BACKGROUND_GET_PRIVATE (self);
	self->priv->settings = NULL;
	self->priv->bg = NULL;
	self->priv->old_bg = NULL;
	self->priv->cache = NULL;
	self->priv->images = NULL;
}


static void budgie_budgie_background_finalize (GObject* obj) {
	BudgieBudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->bg);
	_g_object_unref0 (self->priv->old_bg);
	_g_object_unref0 (self->priv->cache);
	_g_object_unref0 (self->priv->gnome_bg);
	_g_hash_table_unref0 (self->priv->images);
	G_OBJECT_CLASS (budgie_budgie_background_parent_class)->finalize (obj);
}


GType budgie_budgie_background_get_type (void) {
	static volatile gsize budgie_budgie_background_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_budgie_background_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieBudgieBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_budgie_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBudgieBackground), 0, (GInstanceInitFunc) budgie_budgie_background_instance_init, NULL };
		GType budgie_budgie_background_type_id;
		budgie_budgie_background_type_id = g_type_register_static (meta_background_group_get_type (), "BudgieBudgieBackground", &g_define_type_info, 0);
		g_once_init_leave (&budgie_budgie_background_type_id__volatile, budgie_budgie_background_type_id);
	}
	return budgie_budgie_background_type_id__volatile;
}


static void _vala_budgie_budgie_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieBudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground);
	switch (property_id) {
		case BUDGIE_BUDGIE_BACKGROUND_SCREEN:
		g_value_set_object (value, budgie_budgie_background_get_screen (self));
		break;
		case BUDGIE_BUDGIE_BACKGROUND_INDEX:
		g_value_set_int (value, budgie_budgie_background_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_budgie_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieBudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground);
	switch (property_id) {
		case BUDGIE_BUDGIE_BACKGROUND_SCREEN:
		budgie_budgie_background_set_screen (self, g_value_get_object (value));
		break;
		case BUDGIE_BUDGIE_BACKGROUND_INDEX:
		budgie_budgie_background_set_index (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



