/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.doxia.sink.impl;

import org.apache.maven.doxia.sink.SinkEventAttributes;

/**
 * Empty implementation of the <code>Sink</code> interface. Useful for testing purposes.
 *
 * @since 1.0
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @author <a href="mailto:vincent.siveton@gmail.com">Vincent Siveton</a>
 */
public class SinkAdapter extends AbstractSink {

    /** {@inheritDoc} */
    @Override
    public void head_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void body_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void article_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void navigation_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void sidebar_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void list_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void listItem_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void numberedList_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void numberedListItem_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definitionList_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definitionListItem_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definition_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void figure_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void table_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableRows_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableRow_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void title_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void author_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void date_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void header_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void content_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void footer_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void paragraph_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void data_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void time_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void address_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void blockquote_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void division_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void verbatim_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definedTerm_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void figureCaption_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableCell_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableHeaderCell_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableCaption_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void pageBreak() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void anchor_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void link_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void inline_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void italic() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void italic_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void bold() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void bold_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void monospaced() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void monospaced_() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void nonBreakingSpace() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void rawText(String text) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void comment(String comment) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void flush() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void close() {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void head(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void title(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void author(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void date(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void body(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void article(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void navigation(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void sidebar(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void section(int level, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void section_(int level) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void sectionTitle_(int level) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void header(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void content(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void footer(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void list(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void listItem(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void numberedList(int numbering, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void numberedListItem(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definitionList(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definitionListItem(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definition(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void definedTerm(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void figure(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void figureCaption(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void table(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableRows(int[] justification, boolean grid) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableRow(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableCell(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableHeaderCell(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void tableCaption(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void paragraph(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void data(String value, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void time(String datetime, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void address(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void blockquote(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void division(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void verbatim(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void horizontalRule(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void link(String name, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void inline(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void lineBreak(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void lineBreakOpportunity(SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void text(String text, SinkEventAttributes attributes) {
        // nop
    }

    /** {@inheritDoc} */
    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        // nop
    }
}
