/*******************************************************************************
 * Copyright (c) 2007, 2020 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.ui.tests.quickfix;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Hashtable;
import java.util.Map;

import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import org.eclipse.jface.viewers.StructuredSelection;

import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;

import org.eclipse.jdt.internal.corext.fix.CleanUpConstants;

import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jdt.ui.tests.core.rules.ProjectTestSetup;

import org.eclipse.jdt.internal.ui.actions.MultiSortMembersAction;

/**
 * @since 3.4
 */
@RunWith(JUnit4.class)
public class CleanUpActionTest extends CleanUpTestCase {

	@Rule
    public ProjectTestSetup projectsetup = new ProjectTestSetup();

	//205600 [clean up] 'Sort members' action uses workspace/project clean up options
	@Test
	public void testSortMembersAction() throws Exception {
		IPackageFragment pack1= fSourceFolder.createPackageFragment("testSortMembersAction", false, null);
		StringBuffer buf= new StringBuffer();
		buf.append("package testSortMembersAction;\n");
		buf.append("public class E1 {\n");
		buf.append("    private void methodX() {}\n");
		buf.append("    private void methodA() {}\n");
		buf.append("    private int fieldX;\n");
		buf.append("    private int fieldA;\n");
		buf.append("}\n");
		ICompilationUnit cu1= pack1.createCompilationUnit("E1.java", buf.toString(), false, null);

		IWorkbenchPartSite site= PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
		MultiSortMembersAction action= new MultiSortMembersAction(site) {
			@Override
			protected Map<String, String> getSettings() {
				Hashtable<String, String> result= new Hashtable<>();
				result.put(CleanUpConstants.SORT_MEMBERS, CleanUpOptions.TRUE);
				result.put(CleanUpConstants.SORT_MEMBERS_ALL, CleanUpOptions.TRUE);
				return result;
			}
		};
		StructuredSelection selection= new StructuredSelection(cu1);
		action.selectionChanged(selection);
		assertTrue(action.isEnabled());

		action.run(selection);

		buf= new StringBuffer();
		buf.append("package testSortMembersAction;\n");
		buf.append("public class E1 {\n");
		buf.append("    private int fieldA;\n");
		buf.append("    private int fieldX;\n");
		buf.append("    private void methodA() {}\n");
		buf.append("    private void methodX() {}\n");
		buf.append("}\n");
		String expected1= buf.toString();

		assertEquals(expected1, cu1.getBuffer().getContents());
	}

}
