/*
This file is part of Caelum.
See http://www.ogre3d.org/wiki/index.php/Caelum 

Copyright (c) 2008 Caelum team. See Contributors.txt for details.

Caelum is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Caelum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with Caelum. If not, see <http://www.gnu.org/licenses/>.
*/

#include "CaelumPrecompiled.h"
#include "PointStarfield.h"

// Data from http://heasarc.gsfc.nasa.gov/W3Browse/star-catalog/bsc5p.html
// Converted using the following MSVS regexps:
// ^\|0*{:d+} 0*{:d+} 0*{[0-9.]+}\|{[+\-]}0*{:d+} 0*{:d+} 0*{[0-9.]+}\|{.*}\|$
// { \(2,1), \(2,2), \(5,3), \4\(2,5), \(2,6), \(4,7),\(5, 8) },
const Caelum::BrightStarCatalogueEntry Caelum::BrightStarCatalogue[BrightStarCatalogueSize] = {
    { 21,  8, 46.20, -88, 57, 23.0, 5.47 },
    { 22, 45, 28.61, -88, 49,  5.9, 6.57 },
    { 15, 28, 19.10, -88,  7, 59.2, 6.48 },
    { 18, 54, 46.90, -87, 36, 20.9, 5.28 },
    { 17, 15, 59.30, -87, 33, 59.0, 6.57 },
    { 23, 28,  3.70, -87, 28, 55.9, 5.49 },
    {  6, 46, 58.70, -87,  1, 30.0, 6.47 },
    { 17,  0, 58.49, -86, 21, 51.8, 6.04 },
    { 12, 25, 37.49, -86,  9,  2.2, 6.33 },
    { 22, 31, 37.39, -85, 58,  1.9, 5.77 },
    { 13, 40, 55.49, -85, 47, 10.0, 5.58 },
    {  8, 56, 41.09, -85, 39, 47.2, 5.42 },
    { 12,  2, 20.11, -85, 37, 54.1, 6.05 },
    {  3, 42, 32.11, -85, 15, 43.9, 6.41 },
    { 18,  1, 34.10, -85, 12, 52.9, 6.45 },
    { 12, 54, 58.61, -85,  7, 23.9, 5.46 },
    {  0, 13, 19.39, -84, 59, 39.1, 5.77 },
    { 21, 32,  4.20, -84, 48, 36.0, 6.45 },
    { 15, 11,  8.30, -84, 47, 15.0, 5.91 },
    {  5, 30, 13.90, -84, 47,  6.0, 6.20 },
    {  1, 37, 28.01, -84, 46, 10.9, 5.69 },
    { 10, 59, 13.80, -84, 35, 38.0, 6.19 },
    { 15, 43, 16.80, -84, 27, 55.1, 5.57 },
    { 14, 26, 54.89, -83, 40,  4.1, 4.32 },
    { 18, 51, 57.89, -83, 18, 59.0, 7.16 },
    { 20, 24, 54.41, -83, 18, 38.2, 6.17 },
    { 16, 45, 53.59, -83, 14, 20.0, 6.57 },
    { 15,  1, 50.81, -83, 13, 40.1, 5.65 },
    { 11, 41,  1.20, -83,  6,   .0, 6.33 },
    { 15,  4, 46.70, -83,  2, 17.9, 5.65 },
    {  1, 37, 55.61, -82, 58, 30.0, 5.87 },
    {  4, 22, 50.90, -82, 53, 57.1, 6.76 },
    { 14, 24, 23.30, -82, 50, 55.0, 6.42 },
    { 21, 50, 54.31, -82, 43,  9.1, 5.29 },
    { 21, 33, 54.41, -82, 40, 59.2, 6.38 },
    { 13, 55, 38.71, -82, 39, 58.0, 5.95 },
    {  4, 58, 50.90, -82, 28, 14.2, 5.85 },
    {  0, 10,  2.09, -82, 13, 26.0, 5.28 },
    { 10,  0, 43.70, -82, 12, 52.9, 5.52 },
    { 23, 57, 32.71, -82, 10, 12.0, 5.73 },
    { 23, 52,  6.41, -82,  1,  8.0, 5.11 },
    { 10, 31, 51.00, -81, 55, 16.0, 7.07 },
    { 18, 42, 14.09, -81, 48, 28.1, 6.27 },
    {  4, 20, 57.89, -81, 34, 48.0, 5.79 },
    { 10,  4,  7.61, -81, 33, 56.9, 6.60 },
    { 10, 59, 12.91, -81, 33, 22.0, 6.71 },
    {  5, 12, 25.70, -81, 32, 30.1, 6.51 },
    { 18,  5, 26.69, -81, 29, 11.0, 6.35 },
    { 22, 46,  3.31, -81, 22, 54.1, 4.15 },
    { 19, 56,  1.51, -81, 20, 58.9, 6.39 },
    { 20, 38, 18.60, -81, 17, 20.0, 5.91 },
    { 14, 18, 13.80, -81,  0, 28.1, 4.91 },
    { 20, 33, 17.50, -80, 57, 54.0, 5.77 },
    {  9, 33, 53.21, -80, 56, 29.0, 5.11 },
    {  8, 24, 19.80, -80, 54, 51.1, 5.69 },
    { 23, 12, 12.00, -80, 54, 46.1, 6.41 },
    { 17, 31, 27.29, -80, 51, 33.1, 5.88 },
    {  6, 40,  2.71, -80, 48, 49.0, 5.64 },
    {  9, 24,  9.10, -80, 47, 12.8, 5.36 },
    { 10, 45, 46.80, -80, 32, 25.1, 4.45 },
    { 10, 45, 15.70, -80, 28, 10.9, 5.47 },
    {  5, 37,  9.79, -80, 28,  9.1, 5.65 },
    { 22, 20,  1.51, -80, 26, 22.9, 5.10 },
    { 18, 29, 19.49, -80, 13, 58.1, 5.95 },
    {  4, 17, 59.09, -80, 12, 50.0, 5.69 },
    {  1, 47, 46.51, -80, 10, 36.1, 6.06 },
    { 22, 50, 22.90, -80,  7, 27.1, 5.35 },
    { 14, 22, 22.70, -80,  6, 32.0, 5.06 },
    { 21, 33, 20.59, -80,  2, 21.1, 6.47 },
    { 10, 41, 51.29, -79, 46, 59.9, 5.97 },
    { 11, 18, 34.30, -79, 40,  7.0, 6.35 },
    { 10, 52, 27.50, -79, 33, 33.8, 6.33 },
    {  8, 45, 55.20, -79, 30, 15.8, 5.79 },
    { 23,  8, 23.71, -79, 28, 50.9, 6.12 },
    { 23, 19,  8.11, -79, 28, 22.1, 6.33 },
    { 21, 38, 56.21, -79, 26, 33.0, 6.18 },
    {  6, 56, 34.39, -79, 25, 13.1, 5.45 },
    {  5, 50, 16.70, -79, 21, 41.0, 5.47 },
    { 12, 18, 20.69, -79, 18, 43.9, 4.26 },
    { 11, 42, 55.39, -79, 18, 23.0, 6.39 },
    {  1, 41, 21.31, -79,  8, 53.9, 6.33 },
    {  2, 31, 40.51, -79,  6, 33.8, 5.28 },
    {  7, 25, 37.99, -79,  5, 39.1, 5.53 },
    {  8, 43, 12.41, -79,  4, 10.9, 6.05 },
    { 14, 47, 51.60, -79,  2, 40.9, 3.83 },
    {  3,  7, 31.99, -78, 59, 21.8, 5.57 },
    {  8, 41, 19.51, -78, 57, 47.9, 5.47 },
    { 16, 33, 27.00, -78, 53, 49.9, 3.89 },
    {  5, 35, 36.31, -78, 49, 14.9, 6.05 },
    { 23, 44, 40.70, -78, 47, 29.0, 5.75 },
    {  0, 16, 49.01, -78, 46, 50.2, 6.77 },
    { 22, 35, 26.40, -78, 46, 18.1, 6.15 },
    { 16, 20, 20.81, -78, 41, 44.9, 4.68 },
    { 16, 20, 26.81, -78, 40,  1.9, 5.27 },
    { 10, 35, 28.10, -78, 36, 28.1, 4.11 },
    { 14,  0, 32.81, -78, 35, 24.0, 6.09 },
    { 12, 13, 55.70, -78, 34, 25.0, 6.35 },
    {  1, 33, 39.19, -78, 30, 16.9, 6.11 },
    { 13, 14, 17.21, -78, 26, 49.9, 5.85 },
    {  3, 29, 58.80, -78, 21,  6.8, 5.70 },
    {  1, 55, 50.50, -78, 20, 53.9, 6.16 },
    {  3, 36, 30.00, -78, 19, 23.2, 6.29 },
    {  5,  0, 13.20, -78, 18,  1.1, 6.29 },
    { 11, 59, 37.30, -78, 13, 18.8, 4.91 },
    { 15, 39, 18.29, -77, 55,  5.2, 6.18 },
    { 18, 47, 49.39, -77, 52,  1.9, 6.39 },
    { 14, 16, 54.89, -77, 39, 50.0, 6.47 },
    { 22,  1, 52.10, -77, 39, 45.0, 6.41 },
    {  4, 38, 21.70, -77, 39, 22.0, 6.05 },
    {  7, 36,  4.20, -77, 38,  3.1, 6.18 },
    { 11, 21, 57.10, -77, 36, 29.9, 6.43 },
    { 13, 33, 14.81, -77, 34,  5.9, 6.48 },
    { 16, 43,  4.61, -77, 31,  3.0, 4.24 },
    { 22, 17, 50.50, -77, 30, 42.1, 5.51 },
    {  8, 20, 38.50, -77, 29,  3.8, 4.35 },
    {  0, 21, 28.61, -77, 25, 36.8, 5.97 },
    { 21, 41, 28.49, -77, 23, 24.0, 3.76 },
    {  3, 15, 57.60, -77, 23, 17.9, 5.52 },
    { 23, 33, 19.49, -77, 23,  7.1, 5.81 },
    {  0, 25, 45.10, -77, 15, 15.1, 2.80 },
    { 15,  0, 11.81, -77,  9, 37.1, 5.93 },
    {  0,  1, 35.71, -77,  3, 56.9, 4.78 },
    { 22, 49, 40.90, -77,  3,  2.2, 6.73 },
    { 21,  4, 43.01, -77,  1, 26.0, 5.15 },
    {  8, 18, 31.61, -76, 55, 10.9, 4.07 },
    { 23, 38, 24.10, -76, 52, 12.0, 6.00 },
    { 14,  5, 19.80, -76, 47, 48.1, 5.50 },
    {  9, 46, 20.59, -76, 46, 34.0, 5.45 },
    { 14, 29, 36.79, -76, 43, 45.1, 6.07 },
    {  9, 12, 12.31, -76, 39, 47.2, 6.14 },
    { 14, 57, 52.90, -76, 39, 46.1, 5.34 },
    { 12,  4, 46.51, -76, 31,  9.1, 5.04 },
    {  5, 31, 52.90, -76, 20, 28.0, 5.19 },
    { 10, 35, 24.79, -76, 18, 33.1, 6.30 },
    { 21,  8, 47.90, -76, 12, 45.0, 6.58 },
    { 20, 42,  2.90, -76, 10, 50.2, 6.00 },
    { 17, 57, 41.81, -76, 10, 39.0, 6.07 },
    { 22,  3,  3.79, -76,  7,  7.0, 5.95 },
    { 22, 11, 55.30, -76,  6, 58.0, 6.15 },
    { 15, 41, 54.60, -76,  4, 54.8, 5.95 },
    {  0, 15, 55.20, -75, 54, 41.0, 6.49 },
    { 11, 37, 15.60, -75, 53, 48.1, 5.65 },
    { 18, 11, 15.70, -75, 53, 29.0, 5.86 },
    { 22, 10, 42.50, -75, 52, 50.2, 6.55 },
    { 13, 39, 11.90, -75, 41,  2.0, 6.34 },
    { 12, 39, 14.50, -75, 22,  9.8, 6.49 },
    { 12,  7, 49.80, -75, 22,   .8, 5.18 },
    { 20, 41, 43.70, -75, 21,  2.2, 6.55 },
    { 21, 18, 16.10, -75, 20, 48.1, 6.63 },
    { 11, 19, 36.29, -75,  8, 33.0, 6.27 },
    { 10, 57, 15.70, -75,  5, 58.9, 6.13 },
    {  2, 50, 28.51, -75,  4,   .8, 4.75 },
    { 18, 23, 36.10, -75,  2, 39.1, 5.47 },
    { 14, 59, 55.99, -75,  1, 57.0, 6.20 },
    { 22, 25, 51.00, -75,  0, 56.2, 6.04 },
    {  4, 55, 11.21, -74, 56, 12.8, 5.47 },
    {  0, 48, 35.40, -74, 55, 23.9, 5.07 },
    {  9, 17, 25.39, -74, 53, 39.8, 5.29 },
    { 13, 25,  7.10, -74, 53, 16.1, 5.05 },
    { 14,  8, 27.10, -74, 51,  1.1, 6.02 },
    {  6, 10, 14.40, -74, 45, 11.2, 5.09 },
    {  9, 17, 27.41, -74, 44,  4.9, 5.86 },
    { 13, 27, 18.29, -74, 41, 30.8, 6.63 },
    { 17, 16, 35.59, -74, 31, 59.2, 6.25 },
    { 10, 39, 16.61, -74, 29, 37.0, 6.07 },
    {  7, 35, 21.79, -74, 16, 32.2, 7.26 },
    {  7, 35, 21.70, -74, 16, 32.2, 7.16 },
    {  3, 47, 14.30, -74, 14, 20.0, 3.24 },
    { 12,  3, 44.30, -74, 12, 50.0, 6.44 },
    { 10, 24, 23.71, -74,  1, 54.1, 4.00 },
    { 10, 24, 44.30, -73, 58, 18.1, 6.19 },
    { 18, 32, 55.30, -73, 57, 56.2, 5.89 },
    {  5, 34, 44.69, -73, 44, 29.0, 5.78 },
    { 18, 12, 34.49, -73, 40, 18.1, 5.85 },
    {  2, 22, 52.30, -73, 38, 44.9, 5.01 },
    { 23,  8, 35.69, -73, 35, 11.0, 6.15 },
    { 15, 40, 21.19, -73, 26, 48.1, 5.65 },
    {  8, 22,  4.39, -73, 24,   .0, 5.29 },
    { 15, 31, 30.79, -73, 23, 21.8, 5.49 },
    {  8, 32, 42.19, -73, 21, 24.1, 6.12 },
    {  7, 59, 16.10, -73, 14, 40.9, 6.34 },
    {  0, 10, 38.59, -73, 13, 27.8, 6.64 },
    { 10, 31,  1.99, -73, 13, 18.1, 4.93 },
    { 14, 53, 13.70, -73, 11, 24.0, 5.60 },
    { 21,  9, 22.30, -73, 10, 23.2, 5.68 },
    {  0, 38, 40.80, -73,  8, 13.9, 6.85 },
    {  6, 43, 36.79, -73,  7,  5.2, 6.37 },
    {  9, 31, 36.29, -73,  4, 50.9, 5.47 },
    {  5,  6,  9.29, -73,  2, 16.1, 6.27 },
    { 12, 32, 10.01, -73,  0,  6.1, 5.88 },
    { 18, 49, 43.49, -72, 59, 40.9, 6.06 },
    { 20,  0, 35.50, -72, 54, 38.2, 3.96 },
    {  0,  4, 30.70, -72, 53, 52.1, 7.31 },
    { 15, 12, 33.79, -72, 46, 13.1, 6.01 },
    {  5, 47, 48.10, -72, 42,  7.9, 6.53 },
    { 12, 16, 23.50, -72, 36, 52.9, 6.22 },
    {  7, 41, 49.20, -72, 36, 22.0, 3.95 },
    {  9,  5,  8.81, -72, 36, 10.1, 4.48 },
    {  8, 49, 50.30, -72, 33,  2.9, 6.11 },
    { 21, 11, 20.69, -72, 32, 39.1, 6.20 },
    { 19, 49, 25.30, -72, 30, 11.9, 5.41 },
    { 11, 28, 18.19, -72, 28, 27.8, 6.09 },
    { 10, 44, 26.50, -72, 26, 38.0, 6.27 },
    {  4, 53,  5.50, -72, 24, 27.0, 6.28 },
    { 16,  5, 55.80, -72, 24,  2.9, 5.70 },
    { 11, 24, 11.09, -72, 15, 24.1, 5.59 },
    { 22, 24, 36.79, -72, 15, 20.2, 5.29 },
    { 17, 44, 19.70, -72, 13, 14.9, 6.49 },
    { 12, 56, 31.51, -72, 11,  7.1, 5.93 },
    { 13, 22, 52.61, -72,  8, 48.1, 6.05 },
    { 12, 32, 28.01, -72,  7, 59.2, 3.87 },
    {  0, 24,  5.80, -72,  4, 52.0,      },
    { 13, 19, 18.91, -72,  2,  8.2, 6.04 },
    { 11, 20,  3.91, -71, 59, 39.8, 6.41 },
    { 10, 30, 20.11, -71, 59, 35.2, 4.74 },
    { 12, 49, 44.90, -71, 59, 11.0, 5.55 },
    { 15,  7,  8.71, -71, 54, 19.1, 6.52 },
    {  3,  2, 15.41, -71, 54,  9.0, 5.53 },
    { 21, 25, 18.10, -71, 47, 57.8, 6.09 },
    {  6, 40, 57.79, -71, 46, 32.2, 6.51 },
    {  6, 15,  5.90, -71, 42, 10.1, 6.64 },
    {  9, 27,  6.41, -71, 36,  7.9, 5.47 },
    { 13,  2, 16.20, -71, 32, 56.0, 3.62 },
    {  8, 19, 49.01, -71, 30, 54.0, 5.37 },
    {  8, 20,   .70, -71, 30, 19.1, 5.65 },
    { 12,  2, 28.61, -71, 29, 20.0, 6.42 },
    { 13,  3,  5.21, -71, 28, 34.0, 6.03 },
    {  0,  4, 41.30, -71, 26, 12.8, 5.59 },
    { 11, 11, 29.50, -71, 26, 11.0, 6.35 },
    { 18, 43,  2.11, -71, 25, 41.2, 4.01 },
    {  9, 56,  9.70, -71, 23, 21.8, 6.35 },
    {  5,  2, 43.01, -71, 18, 51.8, 5.31 },
    {  0, 33, 23.30, -71, 15, 58.0, 6.13 },
    { 21, 45, 28.80, -71,  0, 32.0, 6.01 },
    { 16, 34, 19.30, -70, 59, 17.2, 5.50 },
    {  6, 51, 27.00, -70, 57, 47.9, 5.40 },
    {  4, 43,  3.91, -70, 55, 52.0, 5.54 },
    { 11,  6, 49.90, -70, 52, 41.2, 5.57 },
    { 10, 44, 19.39, -70, 51, 36.0, 6.26 },
    { 10, 44, 32.09, -70, 51, 18.0, 6.46 },
    { 13, 40,   .60, -70, 47, 17.9, 6.59 },
    { 18, 14, 24.10, -70, 45,  5.0, 6.73 },
    { 17, 12, 19.80, -70, 43, 16.0, 6.22 },
    { 10, 53, 42.00, -70, 43, 13.1, 5.99 },
    { 13, 25, 50.11, -70, 37, 39.0, 5.67 },
    {  9,  5, 38.30, -70, 32, 20.0, 4.71 },
    {  7,  8, 44.90, -70, 29, 56.0, 3.78 },
    {  7,  8, 42.19, -70, 29, 49.9, 5.69 },
    { 23, 44, 25.39, -70, 29, 25.1, 6.07 },
    { 13, 38, 45.70, -70, 26, 42.0, 6.10 },
    {  6, 44, 56.09, -70, 26,  2.0, 6.11 },
    { 22, 25, 10.51, -70, 25, 54.1, 5.78 },
    {  8, 39,  5.21, -70, 23, 12.8, 5.20 },
    { 22, 49, 17.40, -70, 20, 52.1, 6.34 },
    { 14, 10, 30.91, -70, 18, 20.2, 6.05 },
    { 15, 40, 11.50, -70, 13, 40.1, 6.44 },
    { 11, 49, 56.59, -70, 13, 32.9, 4.97 },
    { 12, 12, 46.80, -70,  9,  6.8, 6.17 },
    { 21, 13, 20.50, -70,  7, 35.0, 5.02 },
    { 17, 22,  5.90, -70,  7, 23.9, 5.41 },
    {  8, 27, 16.90, -70,  5, 35.9, 5.53 },
    { 16, 28, 28.10, -70,  5,  3.8, 4.91 },
    { 15, 14, 19.10, -70,  4, 45.8, 5.81 },
    { 22, 54, 39.41, -70,  4, 25.0, 6.05 },
    { 17, 20, 12.79, -70,  2, 44.2, 6.53 },
    { 10, 13, 44.21, -70,  2, 17.2, 3.32 },
    {  6, 22, 38.21, -69, 59,  3.1, 5.56 },
    { 13, 11, 51.60, -69, 56, 30.8, 5.91 },
    {  7, 44, 13.01, -69, 49, 17.0, 6.18 },
    { 21, 24, 16.70, -69, 44,  3.1, 6.41 },
    { 14, 11,  1.90, -69, 43, 10.9, 6.06 },
    {  9, 13, 12.00, -69, 43,  1.9, 1.68 },
    {  6, 25, 28.61, -69, 41, 25.1, 5.38 },
    { 13, 15, 25.70, -69, 40, 46.9, 6.37 },
    { 21, 50, 47.11, -69, 37, 45.8, 5.53 },
    { 13, 28, 46.39, -69, 37, 41.2, 6.20 },
    {  0, 20, 39.00, -69, 37, 30.0, 5.51 },
    {  3, 24,  2.50, -69, 37, 28.9, 6.15 },
    { 20, 35, 51.70, -69, 36, 40.0, 6.11 },
    {  0, 55,   .31, -69, 31, 36.8, 5.45 },
    { 21, 28, 44.90, -69, 30, 19.1, 5.34 },
    {  0, 52, 24.29, -69, 30, 15.8, 6.22 },
    { 12, 42,  5.11, -69, 24, 27.0, 6.33 },
    { 13, 51, 47.40, -69, 24,  5.0, 5.75 },
    {  3, 25, 36.19, -69, 20, 11.0, 5.96 },
    { 16, 59, 33.79, -69, 16,  5.9, 5.79 },
    {  3,  7, 49.20, -69, 15, 56.2, 6.15 },
    { 12,  2, 37.70, -69, 11, 31.9, 5.89 },
    { 19, 16, 28.49, -69, 11, 26.2, 6.27 },
    { 19, 58, 41.30, -69,  9, 50.0, 5.75 },
    { 12, 37, 10.99, -69,  8,  8.2, 2.69 },
    {  9, 56, 59.69, -69,  6,  6.8, 6.20 },
    { 16, 48, 39.89, -69,  1, 40.1, 1.92 },
    {  1, 15, 46.10, -68, 52, 34.0, 4.86 },
    {  6,  8, 44.21, -68, 50, 35.9, 5.06 },
    {  7,  6, 14.09, -68, 50, 13.9, 6.47 },
    { 12, 45,  1.70, -68, 49, 52.0, 6.16 },
    { 23,  4, 52.20, -68, 49, 13.1, 5.52 },
    { 20, 49, 18.10, -68, 46, 35.0, 5.41 },
    { 19, 58, 52.99, -68, 45, 43.9, 6.39 },
    { 19,  3, 29.69, -68, 45, 19.1, 5.88 },
    {  9, 17, 17.21, -68, 41, 21.8, 5.39 },
    {  9,  1,  8.50, -68, 41,  2.0, 5.88 },
    { 10,  9, 30.50, -68, 40, 59.9, 5.81 },
    { 15, 18, 54.60, -68, 40, 45.8, 2.89 },
    {  2, 21, 44.90, -68, 39, 33.8, 4.09 },
    { 12,  6, 19.80, -68, 39,  2.9, 6.23 },
    {  5, 27,   .00, -68, 37, 22.1, 6.03 },
    {  8,  7, 55.80, -68, 37,  1.9, 4.35 },
    { 15, 55, 29.59, -68, 36, 11.2, 5.09 },
    { 19, 31, 10.90, -68, 26,  2.0, 5.96 },
    { 19,  9, 52.70, -68, 25, 28.9, 5.33 },
    { 23, 47, 23.30, -68, 23, 39.1, 6.89 },
    { 19, 24,  5.40, -68, 22, 16.0, 6.34 },
    { 12,  4, 38.71, -68, 19, 45.1, 5.35 },
    { 15, 26, 14.69, -68, 18, 33.1, 5.89 },
    { 12, 22, 11.90, -68, 18, 27.0, 5.74 },
    { 16, 41, 23.30, -68, 17, 46.0, 5.91 },
    {  2, 39, 35.40, -68, 16,   .8, 4.11 },
    { 18, 18,   .91, -68, 13, 45.1, 6.33 },
    {  8, 43, 54.31, -68, 12, 42.1, 6.32 },
    { 21,  1, 28.10, -68, 12, 34.9, 6.37 },
    { 14, 25,  6.29, -68, 11, 43.1, 5.61 },
    { 12, 46, 16.90, -68,  6, 29.2, 3.05 },
    { 12, 17, 34.10, -67, 57, 38.9, 4.11 },
    {  7, 16, 49.80, -67, 57, 25.9, 3.98 },
    { 16, 17,  5.50, -67, 56, 29.0, 5.75 },
    { 14, 37, 46.30, -67, 55, 55.9, 6.04 },
    {  6, 59, 50.50, -67, 54, 58.0, 5.17 },
    { 13, 15, 14.90, -67, 53, 39.8, 4.80 },
    {  2, 14, 14.69, -67, 50, 30.1, 5.55 },
    { 11, 17, 19.01, -67, 49, 25.0, 6.06 },
    { 17, 21, 59.40, -67, 46, 14.2, 4.78 },
    {  2, 15, 28.51, -67, 44, 47.0, 5.69 },
    { 14, 31, 16.51, -67, 43,  1.9, 5.83 },
    { 16, 52, 17.40, -67, 40, 54.8, 6.32 },
    { 13, 54, 48.91, -67, 39,  9.0, 5.71 },
    {  1, 54, 56.09, -67, 38, 49.9, 4.69 },
    { 12, 23, 13.80, -67, 37, 54.1, 6.36 },
    { 11, 37, 48.41, -67, 37, 13.1, 5.96 },
    {  2, 45, 32.59, -67, 37,   .1, 4.84 },
    { 12, 22,  7.30, -67, 31, 18.8, 5.15 },
    { 22, 28, 37.70, -67, 29, 21.1, 5.55 },
    { 15, 20, 40.70, -67, 28, 53.0, 6.28 },
    { 23, 18, 19.99, -67, 28, 16.0, 6.13 },
    { 16, 43, 22.10, -67, 25, 57.0, 6.03 },
    { 20,  5, 32.81, -67, 19, 14.9, 6.07 },
    { 18, 56, 57.00, -67, 14,  1.0, 4.44 },
    { 17, 13, 17.50, -67, 11, 48.1, 5.89 },
    { 12, 38, 52.51, -67, 11, 35.2, 6.25 },
    {  5, 13, 45.41, -67, 11,  7.1, 4.83 },
    { 16, 46, 40.01, -67,  6, 34.9, 5.13 },
    { 15,  9, 29.90, -67,  5,  3.1, 5.76 },
    {  9, 17, 51.70, -67,  3,  2.9, 6.11 },
    { 10, 30,  8.71, -66, 59,  6.0, 6.19 },
    { 11, 32, 19.90, -66, 57, 43.9, 5.90 },
    { 20,  0, 22.99, -66, 56, 57.8, 5.76 },
    { 20,  1, 52.39, -66, 56, 39.1, 5.31 },
    {  3, 17, 58.99, -66, 55, 36.8, 6.05 },
    { 10, 22, 58.10, -66, 54,  6.1, 4.99 },
    {  5, 49, 53.59, -66, 54,  4.0, 5.11 },
    { 23, 10, 11.69, -66, 51, 27.0, 6.47 },
    { 11, 48, 14.30, -66, 48, 52.9, 4.72 },
    { 19, 49, 53.30, -66, 48, 46.1, 6.45 },
    {  8, 50, 34.80, -66, 47, 35.2, 5.35 },
    { 13, 17, 13.01, -66, 47,  1.0, 4.87 },
    { 20, 41, 57.10, -66, 45, 38.9, 5.15 },
    { 11, 45, 36.41, -66, 43, 43.0, 3.64 },
    {  9, 31, 32.90, -66, 43,  9.8, 6.27 },
    {  2, 43, 26.59, -66, 42, 51.8, 6.26 },
    {  9, 28, 30.60, -66, 42,  6.8, 5.91 },
    { 19, 39, 52.10, -66, 41,  8.2, 6.39 },
    {  4, 53, 30.50, -66, 40, 32.2, 6.41 },
    { 19, 17, 12.00, -66, 39, 41.0, 5.53 },
    { 19,  0,  3.50, -66, 39, 11.9, 6.01 },
    { 14, 48, 44.40, -66, 35, 38.0, 5.91 },
    { 14, 16, 38.59, -66, 35, 16.1, 5.75 },
    { 23, 27,  7.20, -66, 34, 52.0, 6.45 },
    {  5, 36, 54.70, -66, 33, 37.1, 6.31 },
    { 12, 39, 55.61, -66, 30, 42.1, 6.26 },
    {  2, 25, 26.30, -66, 29, 40.9, 6.41 },
    {  3, 30, 51.60, -66, 29, 22.9, 5.83 },
    {  1, 17,  3.60, -66, 23, 53.2, 6.24 },
    {  9,  2, 26.81, -66, 23, 46.0, 4.00 },
    { 10, 13, 30.60, -66, 22, 23.2, 5.16 },
    { 20,  8, 20.50, -66, 21, 16.9, 6.45 },
    { 15, 36, 43.20, -66, 19,   .8, 4.11 },
    { 14,  0, 52.20, -66, 16,  7.0, 5.97 },
    { 13, 12, 48.91, -66, 13, 36.8, 5.90 },
    { 20, 44, 57.50, -66, 12, 11.2, 3.42 },
    {  7, 49, 40.99, -66, 11, 44.9, 5.79 },
    { 20,  8, 43.61, -66, 10, 54.8, 3.56 },
    { 14, 25, 39.50, -66, 10, 23.9, 6.36 },
    {  8, 25, 44.21, -66,  8, 12.8, 3.77 },
    {  7, 44, 43.90, -66,  4, 18.8, 6.38 },
    {  1, 59, 41.09, -66,  3, 59.0, 6.10 },
    {  6,  6,  9.41, -66,  2, 22.9, 5.71 },
    { 14, 54, 42.41, -65, 59, 29.0, 6.09 },
    { 19, 41, 37.49, -65, 51, 15.1, 6.09 },
    { 12, 20, 28.01, -65, 50, 34.1, 6.21 },
    {  8, 44, 30.00, -65, 49, 32.2, 6.05 },
    { 14, 27,  7.10, -65, 49, 18.1, 5.85 },
    { 10,  8, 42.60, -65, 48, 55.1, 5.28 },
    { 13, 58, 31.20, -65, 48,  2.2, 6.20 },
    { 12, 25, 17.30, -65, 46, 14.2, 6.30 },
    {  3, 34, 24.70, -65, 45, 51.8, 6.75 },
    {  5, 44, 46.39, -65, 44,  8.2, 4.35 },
    { 12,  6, 23.11, -65, 42, 33.1, 6.06 },
    { 10, 27, 25.30, -65, 42, 16.9, 6.01 },
    { 12, 17,  6.00, -65, 41, 34.1, 6.06 },
    { 13, 33, 35.69, -65, 37, 57.0, 6.37 },
    {  8, 18, 18.91, -65, 36, 47.9, 5.07 },
    { 15, 36, 17.40, -65, 36, 47.9, 6.51 },
    { 19, 51,  1.30, -65, 36, 18.0, 6.05 },
    {  6, 11, 15.00, -65, 35, 21.8, 5.01 },
    { 23, 59, 55.01, -65, 34, 37.9, 4.50 },
    {  6, 30,  3.00, -65, 34,  5.9, 6.29 },
    { 12,  5, 53.21, -65, 32, 49.9, 6.33 },
    { 16, 35, 44.81, -65, 29, 43.1, 5.52 },
    { 17, 53, 18.41, -65, 29, 21.1, 6.49 },
    {  0, 42, 28.39, -65, 28,  5.2, 5.39 },
    {  1,  2, 42.91, -65, 27, 22.0, 6.21 },
    { 15, 47, 53.71, -65, 26, 33.0, 6.39 },
    { 15, 47, 53.59, -65, 26, 33.0, 6.18 },
    {  1, 57, 53.59, -65, 25, 28.9, 6.37 },
    { 11, 39, 29.40, -65, 23, 52.1, 5.17 },
    { 16, 51, 53.90, -65, 22, 32.2, 6.13 },
    { 21, 26, 26.59, -65, 21, 58.0, 4.22 },
    { 13,  8,  7.01, -65, 18, 23.0, 5.51 },
    { 15,  7, 56.81, -65, 16, 32.2, 6.17 },
    { 11, 51, 51.19, -65, 12, 22.0, 4.90 },
    { 15, 52, 56.71, -65,  9,  9.0, 6.54 },
    { 13, 16, 44.81, -65,  8, 17.9, 6.07 },
    {  0, 36, 37.39, -65,  7, 28.9, 6.42 },
    { 10, 40, 11.30, -65,  6,  2.2, 5.52 },
    { 18, 48, 37.80, -65,  4, 40.1, 5.73 },
    {  9, 47,  6.70, -65,  4, 21.0, 6.26 },
    {  9, 47,  6.10, -65,  4, 18.8, 3.01 },
    { 15, 58, 58.10, -65,  2, 16.1, 5.75 },
    { 14, 42, 30.41, -64, 58, 31.1, 3.19 },
    { 22, 27, 19.99, -64, 57, 59.0, 4.48 },
    { 11, 23, 21.79, -64, 57, 18.0, 5.11 },
    {  9, 36,  5.11, -64, 57,  2.2, 6.56 },
    {  9, 26, 44.21, -64, 55, 46.9, 6.05 },
    {  0, 20,  4.30, -64, 52, 28.9, 4.23 },
    { 18, 45, 26.90, -64, 52, 17.0, 4.79 },
    { 11,  6, 24.19, -64, 50, 22.9, 6.41 },
    { 21, 38,  2.90, -64, 49, 27.1, 6.20 },
    {  3, 44, 12.00, -64, 48, 24.8, 3.85 },
    { 17, 45, 43.99, -64, 43, 26.0, 3.62 },
    { 21, 50,   .10, -64, 42, 45.0, 5.62 },
    { 23, 35, 12.70, -64, 41, 21.8, 7.40 },
    { 21, 18,   .31, -64, 40, 54.1, 6.31 },
    { 10, 19,  4.80, -64, 40, 35.0, 5.67 },
    { 13, 29,  7.61, -64, 40, 32.9, 6.11 },
    { 18, 42, 22.51, -64, 38, 35.2, 6.37 },
    { 12,  6, 52.90, -64, 36, 49.0, 4.15 },
    {  8, 25, 51.60, -64, 36,  2.9, 5.97 },
    { 11, 19, 16.51, -64, 34, 57.0, 5.99 },
    { 13, 40, 10.90, -64, 34, 36.8, 5.79 },
    { 18, 43, 37.20, -64, 33,  4.0, 5.78 },
    { 18,  7, 48.31, -64, 33,   .0, 6.41 },
    { 13, 24,   .50, -64, 32,  8.9, 4.53 },
    { 15, 27, 33.10, -64, 31, 53.0, 5.71 },
    { 10, 46, 16.51, -64, 30, 54.0, 5.34 },
    {  7, 28, 51.31, -64, 30, 36.0, 6.39 },
    {  9,  6,  7.61, -64, 29, 58.9, 6.37 },
    {  9, 57, 15.19, -64, 29, 21.8, 6.58 },
    { 13, 25, 13.90, -64, 29,  7.1, 5.31 },
    {  5, 54, 11.90, -64, 28, 55.9, 6.63 },
    { 10, 42, 13.99, -64, 27, 59.0, 4.82 },
    {  2, 54, 20.90, -64, 26,  8.2, 6.56 },
    { 12, 14, 16.80, -64, 24, 31.0, 6.22 },
    { 23, 44, 12.00, -64, 24, 15.8, 5.72 },
    { 10, 42, 57.41, -64, 23, 39.8, 2.76 },
    { 10, 46, 51.19, -64, 22, 59.9, 4.85 },
    {  1, 25,  5.30, -64, 22,  9.8, 5.93 },
    { 12, 28, 18.91, -64, 20, 29.0, 6.04 },
    { 11, 58, 47.69, -64, 20, 21.1, 5.61 },
    {  2, 28,  4.39, -64, 17, 58.9, 6.37 },
    { 23, 57, 35.21, -64, 17, 53.9, 5.00 },
    {  2, 39, 31.70, -64, 16, 54.8, 6.55 },
    { 10, 46, 29.69, -64, 15, 47.9, 5.23 },
    { 10, 43, 51.19, -64, 14, 56.0, 5.77 },
    {  5, 32, 59.59, -64, 13, 39.0, 5.34 },
    {  4,  7, 21.60, -64, 13, 21.0, 6.38 },
    { 10, 28, 52.61, -64, 10, 19.9, 5.29 },
    { 11, 12, 45.19, -64, 10, 10.9, 5.23 },
    {  8, 21,  7.70, -64,  6, 22.0, 6.12 },
    {  2, 58, 47.81, -64,  4, 17.0, 4.99 },
    { 16, 27, 57.31, -64,  3, 29.2, 5.27 },
    {  5, 51, 22.99, -64,  2,  1.0, 6.36 },
    { 15,  4, 48.19, -64,  1, 54.1, 5.17 },
    { 12, 18, 26.09, -64,  0, 11.2, 4.04 },
    { 11, 25, 43.20, -63, 58, 22.1, 5.17 },
    { 10, 44,  6.89, -63, 57, 40.0, 4.82 },
    { 21,  8, 32.90, -63, 55, 44.0, 5.76 },
    {  5, 30, 15.91, -63, 55, 40.1, 6.19 },
    { 18, 19, 40.20, -63, 53, 12.8, 6.18 },
    {  6, 24, 55.61, -63, 49, 40.1, 6.27 },
    { 14, 52, 34.99, -63, 48, 36.0, 5.87 },
    {  8,  8, 24.50, -63, 48,  4.0, 6.28 },
    { 12, 27, 24.60, -63, 47, 21.1, 6.00 },
    { 11, 49, 41.09, -63, 47, 17.9, 4.32 },
    { 16,  1, 10.70, -63, 46, 36.1, 6.41 },
    {  2, 45, 27.50, -63, 42, 15.8, 5.74 },
    { 18, 14, 16.20, -63, 41, 21.8, 6.47 },
    { 13, 57, 38.90, -63, 41, 12.1, 4.71 },
    { 16, 15, 26.30, -63, 41,  8.2, 3.85 },
    {  6, 23,  1.30, -63, 40, 59.2, 6.27 },
    { 18,  8, 34.80, -63, 40,  5.9, 4.35 },
    { 15,  9, 25.49, -63, 38, 34.1, 6.28 },
    { 15, 17, 38.90, -63, 36, 38.2, 4.86 },
    {  8,  0, 19.99, -63, 34,  3.0, 4.82 },
    { 12, 31, 55.80, -63, 30, 22.0, 5.95 },
    {  3, 56,  4.01, -63, 27, 49.0, 6.14 },
    { 15, 55,  8.50, -63, 25, 50.2, 2.85 },
    {  6, 24, 26.30, -63, 25, 44.0, 6.46 },
    { 20, 14, 26.90, -63, 24, 56.9, 6.09 },
    {  5,  7, 34.01, -63, 23, 58.9, 5.20 },
    {  4, 21, 53.30, -63, 23, 11.0, 5.24 },
    { 12,  3,  1.51, -63, 18, 46.1, 4.33 },
    { 13, 11, 53.11, -63, 18, 10.1, 6.33 },
    {  7, 57, 12.50, -63, 17, 48.8, 6.14 },
    { 11, 54, 59.81, -63, 16, 44.0, 5.91 },
    { 16, 55, 24.70, -63, 16, 10.9, 6.02 },
    {  4, 17, 40.20, -63, 15, 20.2, 5.87 },
    { 20, 19,  3.00, -63, 13, 52.0, 6.27 },
    {  4, 44, 57.89, -63, 13, 46.9, 6.46 },
    { 14,  8, 14.30, -63, 12, 29.2, 6.40 },
    {  7, 12,  1.99, -63, 11, 24.0, 6.02 },
    { 22, 52,  9.91, -63, 11, 19.0, 6.12 },
    { 12,  4, 19.20, -63,  9, 56.2, 4.72 },
    { 16, 25, 22.01, -63,  7, 28.9, 6.15 },
    { 12, 26, 30.91, -63,  7, 21.0, 4.86 },
    { 23, 29,  1.01, -63,  6, 38.9, 5.68 },
    { 12, 26, 36.50, -63,  5, 57.8, 1.73 },
    { 12, 26, 35.90, -63,  5, 57.1, 1.33 },
    {  5, 54,  6.10, -63,  5, 24.0, 4.65 },
    { 12, 42, 50.30, -63,  3, 31.0, 5.31 },
    { 18, 15, 40.90, -63,  3, 20.2, 5.60 },
    { 17, 28,  7.70, -63,  2, 11.0, 6.24 },
    {  0, 32, 43.80, -63,  1, 52.0, 5.09 },
    { 18, 25, 31.51, -63,  1, 17.0, 6.14 },
    { 11, 35, 46.80, -63,  1, 10.9, 3.13 },
    {  0, 31, 33.60, -62, 57, 56.9, 4.54 },
    {  0, 31, 32.71, -62, 57, 29.2, 4.37 },
    { 23, 57, 19.90, -62, 57, 23.0, 5.97 },
    { 12, 12, 22.01, -62, 57,  2.9, 5.92 },
    {  3, 29, 22.70, -62, 56, 15.0, 4.72 },
    {  8, 15, 15.91, -62, 54, 56.9, 5.16 },
    {  2, 52, 19.20, -62, 54, 34.9, 6.03 },
    { 20, 39, 51.41, -62, 54, 28.1, 6.22 },
    { 11, 43, 52.90, -62, 52, 41.9, 6.10 },
    { 14, 45, 17.30, -62, 52, 32.9, 5.36 },
    {  0, 53, 37.90, -62, 52, 17.0, 5.70 },
    { 17, 24,  1.10, -62, 51, 51.1, 5.70 },
    {  8, 37, 18.79, -62, 51, 13.0, 5.47 },
    { 23, 49, 44.69, -62, 50, 21.8, 6.59 },
    {  8,  4, 42.89, -62, 50, 10.0, 6.30 },
    {  4, 33, 34.01, -62, 49, 25.0, 5.79 },
    {  2, 49,  1.49, -62, 48, 24.1, 5.26 },
    { 18, 56, 54.70, -62, 48,  4.0, 6.48 },
    {  9, 32, 14.59, -62, 47, 20.0, 6.10 },
    { 14, 56, 43.99, -62, 46, 50.9, 5.11 },
    {  9, 50, 55.70, -62, 44, 43.1, 5.57 },
    { 23, 14,  6.60, -62, 42,   .0, 6.12 },
    { 11, 50, 27.19, -62, 38, 57.8, 5.70 },
    { 15, 53, 22.80, -62, 36, 24.8, 6.19 },
    { 13, 47, 10.70, -62, 35, 24.0, 6.51 },
    {  2, 33, 33.60, -62, 35, 12.8, 6.77 },
    {  3, 17, 46.20, -62, 34, 31.1, 5.54 },
    { 16,  2, 52.39, -62, 32, 30.1, 6.25 },
    {  4, 27, 45.91, -62, 31, 14.9, 5.75 },
    {  9, 45, 14.81, -62, 30, 28.1, 3.69 },
    {  3, 18, 12.89, -62, 30, 23.0, 5.24 },
    {  0, 44, 32.30, -62, 29, 52.1, 6.07 },
    {  5, 33, 37.49, -62, 29, 22.9, 3.76 },
    { 11, 43, 31.20, -62, 29, 21.8, 5.03 },
    {  4, 14, 25.51, -62, 28, 26.0, 3.35 },
    { 11, 57, 40.10, -62, 26, 56.0, 5.57 },
    { 20, 51, 38.30, -62, 25, 45.1, 6.28 },
    { 20, 51, 38.81, -62, 25, 45.1, 6.59 },
    { 11,  6, 32.40, -62, 25, 27.1, 4.61 },
    {  9, 20, 56.81, -62, 24, 16.9, 4.81 },
    {  9, 11, 16.61, -62, 19,  1.9, 3.97 },
    {  5, 29, 17.40, -62, 18, 51.8, 6.59 },
    { 18, 31, 22.39, -62, 16, 41.9, 4.64 },
    {  9, 28, 46.99, -62, 16, 23.2, 5.92 },
    {  4, 14, 48.70, -62, 11, 30.8, 5.45 },
    { 18, 52, 13.01, -62, 11, 15.0, 4.22 },
    {  4,  0, 53.81, -62,  9, 33.8, 4.51 },
    { 10,  2, 49.39, -62,  9, 23.0, 6.42 },
    {  6,  7,  3.41, -62,  9, 16.9, 5.05 },
    { 11, 40, 53.59, -62,  5, 24.0, 4.94 },
    {  4, 36, 45.60, -62,  4, 39.0, 5.40 },
    { 18, 10, 26.11, -62,  0,  7.9, 5.49 },
    { 23, 16, 57.70, -62,  0,  4.0, 5.66 },
    { 22, 33,   .10, -61, 58, 55.9, 4.81 },
    {  9, 25, 27.10, -61, 57,  1.1, 5.77 },
    { 11,  8, 34.01, -61, 56, 49.9, 5.13 },
    {  6, 48, 11.40, -61, 56, 29.0, 3.27 },
    { 21, 55, 11.50, -61, 53, 11.0, 5.90 },
    { 10,  3, 34.30, -61, 53,  2.0, 6.14 },
    {  6, 31, 10.61, -61, 52, 46.9, 6.15 },
    { 12, 35, 28.99, -61, 50, 30.8, 6.22 },
    { 10, 54, 29.59, -61, 49, 36.1, 5.93 },
    { 11, 38,  7.30, -61, 49, 35.0, 5.15 },
    { 12, 28, 25.49, -61, 47, 43.1, 6.22 },
    {  1,  7, 18.70, -61, 46, 31.1, 5.37 },
    { 15, 13,  1.01, -61, 44, 38.0, 6.32 },
    { 13, 37, 12.19, -61, 41, 30.8, 5.63 },
    { 10, 32,  1.39, -61, 41,  7.1, 3.32 },
    { 22, 48, 21.41, -61, 41,  3.1, 6.37 },
    { 17, 10,  6.29, -61, 40, 32.2, 6.39 },
    { 10, 13, 21.19, -61, 39, 32.0, 6.41 },
    {  9, 24,  5.69, -61, 38, 56.0, 5.99 },
    { 16, 30, 49.39, -61, 38,  1.0, 5.20 },
    {  1, 58, 46.20, -61, 34, 10.9, 2.86 },
    { 10,  9, 21.89, -61, 32, 57.1, 5.60 },
    {  6, 38,   .60, -61, 31, 59.2, 6.18 },
    { 20, 37, 35.30, -61, 31, 48.0, 4.88 },
    { 18, 23, 13.61, -61, 29, 38.0, 4.36 },
    { 14,  0, 17.30, -61, 28, 53.0, 6.49 },
    { 15, 10, 44.59, -61, 25, 21.0, 6.30 },
    {  3, 58, 44.69, -61, 24,  1.1, 4.56 },
    { 10, 30, 39.19, -61, 21, 22.0, 6.43 },
    { 10, 17,  4.99, -61, 19, 55.9, 3.40 },
    {  9, 39, 21.00, -61, 19, 41.2, 4.52 },
    { 10, 59, 13.99, -61, 19, 13.1, 6.16 },
    {  8,  9,   .70, -61, 18,  9.0, 4.76 },
    { 11, 37,   .60, -61, 16, 59.9, 5.15 },
    { 11, 31, 15.00, -61, 16, 41.9, 6.38 },
    { 12, 11,  4.90, -61, 16, 39.0, 6.08 },
    { 14, 19, 51.50, -61, 16, 23.2, 5.23 },
    {  4, 25,  5.30, -61, 14, 17.9, 5.94 },
    { 11, 46, 30.79, -61, 10, 41.9, 4.11 },
    {  5, 34, 57.60, -61, 10, 32.9, 6.32 },
    { 19, 54, 40.39, -61, 10, 14.9, 6.24 },
    { 11, 26, 35.30, -61,  6, 55.1, 5.30 },
    { 18, 45, 11.50, -61,  5, 42.0, 6.04 },
    {  4,  1, 18.19, -61,  4, 44.0, 4.97 },
    { 19, 50, 21.70, -61,  3, 41.0, 6.21 },
    { 11, 36, 22.30, -61,  3,  7.9, 5.83 },
    {  3, 32, 51.60, -61,  1,   .8, 6.41 },
    { 16, 38, 52.70, -60, 59, 25.1, 6.18 },
    { 13, 22, 37.90, -60, 59, 17.9, 4.53 },
    { 10, 34, 12.91, -60, 59, 16.1, 6.23 },
    { 12, 45, 37.90, -60, 58, 52.0, 4.69 },
    { 13, 22, 35.69, -60, 58, 19.9, 6.18 },
    { 12,  4, 57.10, -60, 58,  9.1, 5.96 },
    {  9,  0, 45.70, -60, 57, 50.0, 5.79 },
    { 15, 16, 56.71, -60, 57, 27.0, 5.09 },
    {  4, 16, 21.10, -60, 56, 55.0, 6.37 },
    { 15, 16, 36.41, -60, 54, 14.0, 5.73 },
    {  1, 55, 46.39, -60, 51, 41.0, 6.06 },
    { 12,  8, 24.60, -60, 50, 49.9, 6.22 },
    { 14, 39, 36.10, -60, 50,  8.2, 1.33 },
    { 14, 39, 35.90, -60, 50,  7.1,-0.01 },
    {  7, 58, 50.50, -60, 49, 27.8, 5.81 },
    {  1, 41, 48.00, -60, 47, 21.8, 5.71 },
    { 15, 54, 52.61, -60, 44, 35.9, 6.15 },
    {  0, 58, 22.39, -60, 41, 47.0, 6.23 },
    { 17, 31,  5.90, -60, 41,  2.0, 3.62 },
    { 17, 24, 18.70, -60, 40, 25.0, 5.77 },
    { 15, 23, 10.39, -60, 39, 24.8, 5.67 },
    {  8, 55,  2.81, -60, 38, 40.9, 3.84 },
    { 10, 46, 16.80, -60, 36, 11.9, 6.25 },
    {  7, 59, 37.61, -60, 35, 12.8, 5.17 },
    { 20, 35, 34.80, -60, 34, 54.1, 4.76 },
    { 10, 43, 32.09, -60, 34,   .1, 4.57 },
    { 20, 40,  2.59, -60, 32, 56.0, 5.12 },
    {  7, 56, 18.60, -60, 31, 35.0, 5.74 },
    { 10, 55, 17.21, -60, 31,   .8, 5.92 },
    { 22, 44, 16.51, -60, 29, 57.8, 6.30 },
    { 15, 18, 48.91, -60, 29, 47.0, 5.46 },
    { 15, 56,  6.00, -60, 28, 58.1, 5.76 },
    { 16, 40, 50.50, -60, 26, 46.0, 6.18 },
    { 10,  2,   .00, -60, 25, 14.9, 5.94 },
    { 12, 21, 21.60, -60, 24,  4.0, 3.59 },
    { 12, 50, 12.00, -60, 24,  2.9, 6.75 },
    { 12, 53, 49.10, -60, 22, 36.8, 5.90 },
    { 14,  3, 49.39, -60, 22, 23.2, 0.61 },
    {  8, 53, 48.70, -60, 21, 15.1, 5.78 },
    { 12, 51, 17.81, -60, 19, 46.9, 5.72 },
    { 12, 53, 21.79, -60, 19, 43.0, 5.76 },
    { 11, 12, 36.00, -60, 19,  3.0, 4.60 },
    {  8, 39, 13.20, -60, 19,  1.9, 6.36 },
    {  2, 24, 53.90, -60, 18, 42.8, 5.35 },
    {  7, 57, 46.90, -60, 18, 11.9, 5.60 },
    {  9, 23, 27.41, -60, 18,  9.0, 6.30 },
    { 15, 43, 55.10, -60, 17, 13.9, 6.48 },
    {  7, 49, 12.89, -60, 17,  1.0, 5.78 },
    {  6, 24, 13.70, -60, 16, 52.0, 5.80 },
    {  0, 42, 41.81, -60, 15, 45.0, 5.98 },
    { 22, 18, 30.10, -60, 15, 34.9, 2.86 },
    {  6, 50,  1.10, -60, 14, 57.1, 6.11 },
    {  7, 59, 40.20, -60, 12, 27.0, 6.33 },
    { 18, 58, 36.41, -60, 12,  2.2, 5.14 },
    { 10,  2, 59.90, -60, 10, 43.0, 6.19 },
    { 15, 55, 32.30, -60, 10, 40.1, 5.77 },
    { 17, 51, 35.50, -60,  9, 51.8, 5.78 },
    { 14, 55, 34.61, -60,  6, 51.1, 5.20 },
    {  6,  2,  9.19, -60,  5, 48.8, 6.45 },
    { 23, 22, 56.90, -60,  3, 20.9, 6.09 },
    {  7, 49, 54.79, -60,  3,  4.0, 6.72 },
    { 14, 35, 17.21, -60,  0, 56.9, 6.40 },
    { 13, 12, 17.40, -59, 55, 14.9, 4.60 },
    { 10, 48,  5.40, -59, 55,  9.1, 6.00 },
    { 10, 13,  1.30, -59, 55,  5.2, 6.10 },
    { 14, 16, 34.20, -59, 54, 50.0, 6.39 },
    { 15, 39, 56.50, -59, 54, 29.9, 5.95 },
    { 10, 16,  3.10, -59, 54, 11.9, 6.22 },
    { 22, 51, 44.90, -59, 52, 53.0, 6.46 },
    { 13,  7, 24.19, -59, 51, 38.2, 5.99 },
    { 17, 35, 34.90, -59, 50, 46.0, 6.28 },
    { 13, 12, 55.99, -59, 49,   .1, 6.16 },
    { 13, 20, 34.90, -59, 46, 23.9, 6.18 },
    {  8, 40, 37.01, -59, 45, 40.0, 4.33 },
    {  3,  3, 36.79, -59, 44, 16.1, 5.11 },
    {  4, 44, 21.10, -59, 43, 58.1, 5.27 },
    { 10, 57, 48.41, -59, 43, 54.8, 6.11 },
    { 14,  6, 25.10, -59, 42, 56.2, 6.42 },
    { 17, 19, 12.41, -59, 41, 39.8, 5.91 },
    { 12, 47, 43.20, -59, 41, 19.0, 1.25 },
    { 12, 41, 56.59, -59, 41,  8.9, 4.93 },
    { 10, 45,  3.60, -59, 41,  3.1, 6.21 },
    { 10, 41, 17.59, -59, 40, 36.8, 6.42 },
    { 22,  5, 50.90, -59, 38, 10.0, 5.62 },
    { 11, 13, 30.79, -59, 37,  9.8, 5.74 },
    { 10, 36, 20.30, -59, 33, 52.9, 5.08 },
    { 11, 31, 48.79, -59, 30, 56.9, 5.15 },
    {  8, 22, 30.79, -59, 30, 34.9, 1.86 },
    {  0, 40, 26.40, -59, 27, 15.8, 5.89 },
    { 11, 31, 46.10, -59, 26, 31.9, 5.13 },
    {  9, 51, 12.10, -59, 25, 32.9, 5.79 },
    { 12, 31, 40.30, -59, 25, 26.0, 5.48 },
    {  9, 12, 55.61, -59, 24, 51.8, 5.54 },
    { 20,  1, 44.69, -59, 22, 34.0, 5.13 },
    {  6, 52, 45.41, -59, 20, 28.0, 6.41 },
    { 10, 49, 24.10, -59, 19, 25.0, 5.91 },
    { 15, 23, 22.70, -59, 19, 14.9, 4.51 },
    {  4, 16, 28.90, -59, 18,  6.8, 4.44 },
    { 14,  8, 56.30, -59, 16, 36.1, 6.34 },
    {  9, 17,  5.40, -59, 16, 31.1, 2.25 },
    {  9, 34, 26.71, -59, 13, 45.8, 4.08 },
    {  8, 56, 58.39, -59, 13, 45.8, 4.92 },
    { 10, 42, 40.61, -59, 12, 56.9, 5.38 },
    {  6, 16, 18.50, -59, 12, 49.0, 6.43 },
    { 14, 28, 43.49, -59, 11, 52.1, 6.45 },
    { 19, 50, 44.81, -59, 11, 35.2, 5.42 },
    { 10, 38, 45.10, -59, 10, 59.2, 4.66 },
    {  7,  3, 15.60, -59, 10, 41.2, 5.50 },
    {  8, 17, 55.80, -59, 10,   .8, 6.42 },
    { 12, 54, 39.19, -59,  8, 48.1, 4.62 },
    {  7, 56, 50.71, -59,  7, 35.0, 6.25 },
    { 13, 14, 14.81, -59,  6, 11.9, 4.92 },
    {  8, 59, 24.10, -59,  5,  1.0, 5.16 },
    { 16, 49, 47.09, -59,  2, 29.0, 3.76 },
    { 18,  9, 57.60, -59,  2, 24.0, 6.38 },
    { 21, 58, 30.10, -59,  0, 43.9, 6.12 },
    { 12, 27, 28.70, -58, 59, 30.8, 5.50 },
    { 11,  8, 35.40, -58, 58, 30.0, 3.91 },
    {  9, 10, 58.01, -58, 58,   .8, 3.44 },
    { 17,  1, 47.40, -58, 57, 29.9, 6.11 },
    {  4, 40, 18.29, -58, 56, 37.0, 6.53 },
    {  7,  1,  5.09, -58, 56, 24.0, 6.02 },
    {  5, 26, 19.30, -58, 54, 45.0, 5.14 },
    { 12, 43, 28.20, -58, 54, 11.2, 6.40 },
    { 19, 57,  6.19, -58, 54,  5.0, 5.26 },
    {  5, 35,  2.40, -58, 52, 16.0, 6.75 },
    { 10, 53, 29.59, -58, 51, 11.9, 3.78 },
    { 10, 11, 35.21, -58, 49, 41.2, 6.40 },
    { 10, 38, 59.40, -58, 49,   .8, 5.92 },
    { 15, 17, 30.79, -58, 48,  4.0, 4.07 },
    {  9, 45, 55.39, -58, 47, 39.1, 6.22 },
    { 13, 42,  1.10, -58, 47, 13.9, 5.38 },
    {  6, 31, 58.39, -58, 45, 15.1, 5.70 },
    { 12, 15,  8.71, -58, 44, 56.0, 2.80 },
    { 10, 27, 52.70, -58, 44, 21.8, 3.82 },
    { 10, 37, 26.81, -58, 43, 59.9, 5.45 },
    {  8, 45,  5.30, -58, 43, 30.0, 6.21 },
    { 18, 33, 29.50, -58, 42, 33.1, 6.44 },
    { 13, 14, 12.10, -58, 41,  2.0, 5.89 },
    { 11,  6, 29.30, -58, 40, 31.1, 6.02 },
    { 10, 32, 47.59, -58, 40,   .8, 6.00 },
    {  7, 42, 10.20, -58, 37, 50.9, 6.43 },
    { 14, 41, 55.70, -58, 36, 58.0, 6.22 },
    { 16, 28, 15.19, -58, 35, 58.9, 5.69 },
    { 10, 24, 59.40, -58, 34, 35.0, 5.95 },
    {  4, 54, 52.99, -58, 32, 49.9, 6.12 },
    {  6, 23, 46.90, -58, 32, 38.0, 6.48 },
    { 16, 46, 21.19, -58, 30, 13.0, 5.74 },
    { 14, 44, 55.49, -58, 28, 40.1, 6.11 },
    { 23, 27, 15.00, -58, 28, 34.0, 5.63 },
    { 14, 22, 37.01, -58, 27, 33.8, 4.92 },
    { 11, 10, 54.70, -58, 27, 19.1, 6.88 },
    { 20, 54, 48.60, -58, 27, 15.1, 3.65 },
    { 12, 54, 22.01, -58, 25, 50.2, 6.58 },
    { 13, 38,  7.61, -58, 24, 54.0, 6.42 },
    {  9, 15, 17.50, -58, 23, 19.0, 6.02 },
    {  9, 30, 23.40, -58, 21, 42.1, 5.88 },
    { 16, 47, 19.51, -58, 20, 29.0, 5.58 },
    {  1, 36, 44.81, -58, 16, 14.9, 6.18 },
    {  8, 54, 54.00, -58, 14, 24.0, 6.38 },
    { 23, 17, 25.80, -58, 14,  8.9, 3.99 },
    {  7, 42, 53.30, -58, 13, 48.0, 6.21 },
    {  8, 35, 15.41, -58, 13, 30.0, 5.26 },
    { 10, 33, 25.30, -58, 11, 25.1, 6.14 },
    {  1, 35, 15.19, -58,  8, 21.8, 6.01 },
    { 10, 11, 46.51, -58,  3, 38.2, 5.72 },
    { 17, 22, 55.01, -58,  0, 37.1, 5.88 },
    {  8, 35, 19.61, -58,  0, 33.1, 4.86 },
    {  6, 27,  4.01, -58,  0,  7.9, 5.82 },
    {  9, 40, 42.50, -57, 59,  1.0, 5.32 },
    { 19, 38, 25.90, -57, 58, 59.9, 6.18 },
    {  8, 21, 12.00, -57, 58, 23.2, 5.97 },
    { 10, 23, 50.90, -57, 57, 14.0, 6.35 },
    { 16,  9, 18.60, -57, 56,  3.8, 5.57 },
    { 19, 56, 57.70, -57, 55, 32.2, 6.53 },
    { 16, 15, 49.70, -57, 54, 43.9, 5.63 },
    { 16, 54,   .50, -57, 54, 33.8, 5.94 },
    { 16, 18, 51.89, -57, 53, 58.9, 6.49 },
    { 21, 56, 13.99, -57, 53, 57.8, 6.19 },
    { 22, 35, 52.90, -57, 53,  1.0, 6.23 },
    {  9,  4, 48.00, -57, 51,  9.0, 6.44 },
    { 22, 24, 56.40, -57, 47, 49.9, 5.32 },
    { 16,  3, 31.90, -57, 46, 31.1, 4.63 },
    { 16, 29, 45.00, -57, 45, 20.9, 6.06 },
    { 17,  4, 24.70, -57, 42, 43.9, 5.73 },
    { 11, 47, 19.10, -57, 41, 47.0, 5.41 },
    {  1, 10,  7.39, -57, 41, 39.8, 6.41 },
    { 12, 22, 49.30, -57, 40, 34.0, 5.39 },
    { 10, 27, 24.41, -57, 38, 20.0, 4.66 },
    {  8, 51, 36.60, -57, 38,  1.0, 5.59 },
    { 13, 38, 49.10, -57, 37, 23.2, 6.01 },
    {  9, 15, 34.99, -57, 34, 41.2, 6.32 },
    { 10, 35, 35.30, -57, 33, 28.1, 4.45 },
    { 17, 44, 55.80, -57, 32, 43.1, 6.01 },
    {  8, 40, 43.61, -57, 32, 43.1, 6.34 },
    {  9, 16, 12.19, -57, 32, 29.0, 4.34 },
    { 20, 11,  7.20, -57, 31, 26.0, 6.37 },
    { 18, 29, 56.69, -57, 31, 23.2, 5.76 },
    { 22, 20, 36.19, -57, 30, 36.0, 6.34 },
    { 12,  1, 28.99, -57, 30, 13.0, 6.16 },
    {  5,  5, 30.60, -57, 28, 22.1, 4.72 },
    { 10, 47, 38.71, -57, 28,  4.1, 6.36 },
    {  0, 43, 21.19, -57, 27, 47.2, 4.36 },
    { 22, 40, 48.89, -57, 25, 19.9, 5.97 },
    { 11, 54, 11.50, -57, 24, 36.0, 6.06 },
    { 10,  1, 58.01, -57, 20, 58.9, 6.20 },
    {  3, 12, 33.19, -57, 19, 18.1, 5.74 },
    {  7, 54, 53.21, -57, 18, 11.2, 5.63 },
    {  9, 41,  2.21, -57, 15, 34.9, 5.80 },
    { 10, 38,  2.50, -57, 15, 23.0, 5.91 },
    { 10, 52, 30.91, -57, 14, 26.2, 5.25 },
    {  1, 37, 42.89, -57, 14, 12.1, 0.46 },
    {  9, 45, 40.49, -57, 11,  8.2, 6.46 },
    { 12, 54, 35.59, -57, 10, 40.1, 4.03 },
    { 12, 54, 36.79, -57, 10,  5.9, 5.17 },
    {  5, 52, 20.30, -57,  9, 22.0, 5.94 },
    { 12, 31,  9.89, -57,  6, 47.9, 1.63 },
    {  3, 58, 42.89, -57,  6,  9.0, 6.05 },
    { 14, 14, 57.00, -57,  5,  8.9, 5.07 },
    { 12, 31, 16.70, -57,  4, 52.0, 6.42 },
    {  4, 24, 12.19, -57,  4, 17.0, 6.29 },
    {  9, 31, 13.30, -57,  2,  3.8, 3.13 },
    {  1,  2,  1.80, -57,  0,  9.0, 6.11 },
    { 11, 52, 10.10, -56, 59, 16.1, 5.57 },
    { 10,  0, 34.39, -56, 56, 48.1, 6.52 },
    { 17, 31, 22.99, -56, 55, 14.2, 5.95 },
    { 17, 14, 13.20, -56, 53, 17.9, 6.09 },
    { 14, 32, 32.90, -56, 53, 16.1, 6.93 },
    { 18, 45, 23.71, -56, 52, 54.1, 6.22 },
    {  6, 29, 28.51, -56, 51, 10.1, 5.22 },
    { 23, 25, 19.39, -56, 50, 57.1, 5.59 },
    { 12, 55, 57.00, -56, 50, 10.0, 5.32 },
    { 22,  3, 21.60, -56, 47, 10.0, 4.69 },
    { 11, 23,  8.11, -56, 46, 45.8, 5.79 },
    {  8, 46, 42.50, -56, 46, 10.9, 4.49 },
    { 13, 42, 56.09, -56, 46,  5.2, 6.00 },
    { 10, 46, 57.50, -56, 45, 25.9, 5.23 },
    {  7,  4, 18.29, -56, 44, 58.9, 5.17 },
    { 20, 25, 38.90, -56, 44,  6.0, 1.94 },
    {  7, 45, 35.59, -56, 43, 21.0, 6.12 },
    { 14, 49,  6.89, -56, 40,  4.1, 6.23 },
    {  8, 53,  3.79, -56, 38, 57.8, 6.03 },
    { 17, 23,  6.89, -56, 31, 31.1, 5.80 },
    { 12, 29, 53.90, -56, 31, 28.9, 5.80 },
    {  0, 41, 46.39, -56, 30,  6.1, 5.70 },
    { 12, 46, 22.70, -56, 29, 20.0, 4.65 },
    {  7, 48, 19.20, -56, 28, 16.0, 6.33 },
    { 14, 40, 32.81, -56, 26, 26.9, 6.30 },
    {  9, 48, 40.01, -56, 24, 42.8, 6.06 },
    {  7, 49,  6.70, -56, 24, 38.2, 5.59 },
    { 12, 28, 33.41, -56, 24, 28.1, 6.15 },
    {  6, 58, 36.19, -56, 23, 40.9, 6.45 },
    { 14, 20, 19.51, -56, 23, 12.1, 4.33 },
    { 17, 25, 23.59, -56, 22, 39.0, 3.34 },
    { 12, 21, 57.50, -56, 22, 28.9, 5.92 },
    {  6, 22, 55.80, -56, 22, 12.0, 5.61 },
    { 19, 48,  1.20, -56, 21, 45.0, 5.35 },
    { 11, 58, 15.19, -56, 19,  1.9, 5.44 },
    { 14,  3, 26.21, -56, 12, 49.0, 5.92 },
    {  1, 39, 47.40, -56, 11, 53.2, 5.87 },
    {  1, 39, 47.81, -56, 11, 40.9, 5.76 },
    { 16,  7, 24.00, -56, 11, 29.0, 6.16 },
    { 12, 43,  9.10, -56, 10, 34.0, 6.00 },
    {  5, 49, 49.70, -56, 10,   .1, 4.51 },
    {  5, 22, 22.10, -56,  8,  3.8, 6.11 },
    { 10, 18, 37.61, -56,  6, 36.0, 5.81 },
    {  8,  9, 33.60, -56,  5,  8.2, 5.66 },
    { 10, 20, 54.79, -56,  2, 35.2, 4.50 },
    { 18, 17,  7.49, -56,  1, 23.9, 5.33 },
    { 16, 58, 37.20, -55, 59, 25.1, 3.13 },
    { 12, 42, 49.61, -55, 56, 49.9, 6.08 },
    {  2, 19, 54.29, -55, 56, 40.9, 5.81 },
    {  7, 36,  1.70, -55, 53, 15.0, 6.39 },
    { 22,  0, 24.10, -55, 52, 58.1, 6.01 },
    {  9,  6, 34.01, -55, 48, 11.9, 6.11 },
    { 13, 20, 48.29, -55, 48,  2.2, 6.02 },
    {  8, 42, 20.90, -55, 46, 27.1, 6.29 },
    { 21, 40, 33.60, -55, 44, 15.0, 6.33 },
    {  6, 58, 39.60, -55, 43, 45.8, 6.27 },
    { 19,  8, 52.10, -55, 43, 13.1, 6.49 },
    { 10, 39, 18.41, -55, 36, 11.9, 4.28 },
    { 14, 45, 10.90, -55, 36,  6.8, 6.10 },
    {  9, 14, 18.00, -55, 34, 10.9, 5.27 },
    { 16, 13, 22.61, -55, 32, 26.9, 5.81 },
    {  6, 47, 18.70, -55, 32, 24.0, 5.61 },
    { 17, 25, 18.00, -55, 31, 48.0, 2.85 },
    {  9, 21, 49.99, -55, 30, 54.0, 5.63 },
    {  8,  1, 31.49, -55, 27, 18.0, 6.28 },
    { 19, 29, 52.61, -55, 26, 29.0, 6.13 },
    { 17, 48, 38.11, -55, 24,  6.1, 6.11 },
    {  9, 53,   .00, -55, 22, 23.9, 6.48 },
    { 15, 11, 16.01, -55, 20, 46.0, 5.54 },
    {  1,  8, 23.11, -55, 14, 44.9, 3.92 },
    {  9, 41, 47.81, -55, 12, 51.1, 6.00 },
    {  8, 29, 36.31, -55, 11, 28.0, 6.36 },
    {  9, 19, 32.59, -55, 11, 12.1, 6.28 },
    { 17, 28, 38.71, -55, 10, 10.9, 5.94 },
    { 12, 18, 59.69, -55,  8, 35.2, 5.00 },
    { 16, 20, 25.20, -55,  8, 24.0, 5.77 },
    { 19, 30, 34.49, -55,  6, 36.0, 6.30 },
    { 15, 51,  6.79, -55,  3, 20.9, 5.73 },
    { 20, 20, 32.30, -55,  3,  2.9, 6.27 },
    {  4, 33, 59.81, -55,  2, 42.0, 3.27 },
    { 10, 19, 36.79, -55,  1, 45.8, 4.57 },
    { 20,  7, 35.09, -55,  0, 59.0, 6.26 },
    {  8, 27, 27.41, -55,  0, 42.1, 6.53 },
    {  9, 22,  6.79, -55,  0, 38.9, 2.50 },
    { 14, 33, 32.40, -54, 59, 53.9, 5.87 },
    { 21, 57, 55.10, -54, 59, 33.0, 4.40 },
    { 19, 52, 39.00, -54, 58, 36.1, 6.50 },
    { 10, 15, 16.61, -54, 58, 27.1, 6.16 },
    { 19, 52, 37.61, -54, 58, 16.0, 5.74 },
    {  6, 10, 17.90, -54, 58,  7.0, 4.81 },
    {  8, 55, 11.90, -54, 57, 56.2, 5.71 },
    { 12, 53,  3.91, -54, 57,  9.0, 5.93 },
    {  5, 33, 44.40, -54, 54,  7.9, 6.43 },
    { 10, 26, 49.01, -54, 52, 39.0, 5.58 },
    {  0, 35, 33.41, -54, 49, 18.8, 6.06 },
    { 21,  5, 14.21, -54, 43, 37.9, 5.16 },
    {  8, 44, 42.19, -54, 42, 29.9, 1.96 },
    { 13, 56, 33.00, -54, 42, 15.8, 6.00 },
    {  6, 46, 41.50, -54, 41, 40.9, 6.46 },
    { 14,  5, 46.51, -54, 40,  9.8, 6.17 },
    { 21, 26, 15.41, -54, 39, 38.2, 6.12 },
    { 16, 13, 28.70, -54, 37, 50.2, 4.94 },
    { 14, 13, 39.89, -54, 37, 32.9, 6.11 },
    { 17,  0,  6.19, -54, 35, 48.8, 5.65 },
    { 16,  1,  6.41, -54, 34, 40.1, 6.13 },
    {  9, 56, 51.79, -54, 34,  4.1, 3.54 },
    { 13, 41, 44.69, -54, 33, 36.0, 5.01 },
    {  2, 40, 39.60, -54, 33,   .0, 5.21 },
    {  8,  1, 22.90, -54, 30, 54.0, 6.10 },
    { 17, 38,  5.59, -54, 30,  1.1, 5.25 },
    {  9, 17, 42.31, -54, 29, 43.1, 6.33 },
    { 11, 21,   .41, -54, 29, 28.0, 3.89 },
    { 19, 22, 51.10, -54, 25, 25.0, 5.05 },
    { 19, 40, 18.31, -54, 25,  3.0, 6.26 },
    {  5,  5,   .60, -54, 24, 27.0, 6.27 },
    {  7, 30, 30.91, -54, 23, 57.8, 5.96 },
    {  8, 31, 29.59, -54, 23, 39.1, 6.34 },
    {  0, 37, 18.10, -54, 23, 39.1, 6.41 },
    {  7, 52, 29.69, -54, 22,  1.9, 5.70 },
    {  5, 47, 13.01, -54, 21, 38.9, 6.18 },
    { 19, 27, 48.10, -54, 19, 31.1, 5.69 },
    {  3, 44, 33.79, -54, 16, 26.0, 6.30 },
    { 11, 34, 45.70, -54, 15, 51.1, 4.62 },
    {  8,  0, 49.90, -54,  9,  5.0, 5.87 },
    { 13, 56, 19.80, -54,  7, 54.8, 6.14 },
    {  6, 52, 46.90, -54,  5, 24.0, 6.57 },
    { 15, 59, 54.00, -54,  1, 16.0, 6.10 },
    {  0,  9,  2.40, -54,  0,  6.8, 6.33 },
    { 11, 40, 42.60, -53, 58,  7.0, 5.96 },
    { 23,  4, 39.60, -53, 57, 54.0, 5.37 },
    {  9, 43, 42.19, -53, 53, 30.1, 5.56 },
    { 12, 52, 24.60, -53, 49, 45.8, 6.24 },
    { 16, 16, 43.10, -53, 48, 40.0, 5.44 },
    { 23, 23, 54.31, -53, 48, 29.9, 6.15 },
    {  1, 42, 29.30, -53, 44, 26.2, 5.52 },
    { 10, 31, 21.79, -53, 42, 56.2, 4.89 },
    {  0, 45,   .00, -53, 42, 54.0, 6.15 },
    { 21, 29,   .31, -53, 42, 20.9, 6.39 },
    { 16, 13, 16.80, -53, 40, 18.1, 5.83 },
    {  9, 37, 12.31, -53, 40,  7.0, 5.45 },
    { 14, 13, 16.39, -53, 39, 56.9, 5.56 },
    { 22, 18, 15.60, -53, 37, 40.1, 5.37 },
    {  6, 49, 51.31, -53, 37, 19.9, 4.40 },
    { 17, 50, 28.20, -53, 36, 43.9, 5.92 },
    {  9,  3,  5.21, -53, 32, 58.9, 6.40 },
    {  1, 46,  6.31, -53, 31, 18.8, 5.04 },
    { 14, 15, 21.19, -53, 30, 34.9, 6.39 },
    { 22, 45, 37.90, -53, 30,  1.1, 4.85 },
    { 13, 39, 53.21, -53, 27, 59.0, 2.30 },
    {  4, 50, 55.20, -53, 27, 41.0, 5.61 },
    { 13,  7, 38.30, -53, 27, 34.9, 5.71 },
    {  4, 50, 56.30, -53, 27, 34.9, 6.42 },
    { 21, 19, 52.01, -53, 26, 58.9, 4.39 },
    {  8, 39, 23.81, -53, 26, 22.9, 5.48 },
    { 14,  9, 54.79, -53, 26, 21.1, 4.75 },
    {  1, 38, 48.19, -53, 26, 20.0, 6.84 },
    {  5, 57, 14.40, -53, 25, 34.0, 6.45 },
    { 19, 18,  9.41, -53, 23, 12.1, 6.38 },
    {  9, 26, 18.10, -53, 22, 45.1, 5.11 },
    { 13, 53, 43.10, -53, 22, 25.0, 5.89 },
    { 10,  1, 40.49, -53, 21, 51.8, 6.20 },
    { 17, 35, 19.99, -53, 21, 10.1, 6.10 },
    {  7, 39,   .41, -53, 16, 23.9, 6.06 },
    { 21, 15, 45.91, -53, 15, 47.2, 5.75 },
    { 17,  3,  8.81, -53, 14, 12.8, 5.29 },
    { 11, 13, 39.31, -53, 13, 54.1, 5.76 },
    {  8, 32,  4.80, -53, 12, 43.9, 5.69 },
    { 15, 50,  6.89, -53, 12, 33.8, 5.77 },
    { 19, 32, 53.81, -53, 11,  8.9, 5.75 },
    { 14, 23, 48.41, -53, 10, 36.1, 6.00 },
    { 16, 59, 35.11, -53,  9, 38.2, 4.06 },
    { 11, 26, 47.30, -53,  9, 36.0, 5.81 },
    { 16, 44, 39.79, -53,  9,  9.0, 5.96 },
    { 17, 51, 10.99, -53,  7, 50.2, 6.09 },
    {  8, 42, 25.49, -53,  6, 50.0, 4.86 },
    {  8,  5,  4.01, -53,  6, 29.2, 5.53 },
    {  8, 42, 18.91, -53,  6,   .0, 5.52 },
    {  8, 38, 44.90, -53,  5, 26.2, 6.47 },
    {  8, 27, 36.50, -53,  5, 19.0, 5.09 },
    { 16, 17, 20.90, -53,  5, 12.1, 6.33 },
    {  8, 39, 57.60, -53,  3, 18.0, 5.19 },
    {  8, 40, 17.40, -53,  0, 55.1, 5.61 },
    {  7, 56, 46.70, -52, 58, 55.9, 3.47 },
    {  6, 34, 58.61, -52, 58, 32.2, 4.39 },
    {  9, 36, 46.30, -52, 56, 39.1, 6.19 },
    { 18, 58, 27.70, -52, 56, 19.0, 4.87 },
    {  8, 40, 17.59, -52, 55, 18.8, 3.62 },
    { 18, 34, 31.20, -52, 53, 30.8, 6.22 },
    { 19, 48, 55.10, -52, 53, 17.2, 6.25 },
    { 20,  7, 23.21, -52, 52, 50.9, 4.94 },
    {  4, 18, 40.01, -52, 51, 36.0, 6.09 },
    {  8, 48,   .19, -52, 51,  2.2, 6.30 },
    { 13, 52,  4.80, -52, 48, 42.1, 5.25 },
    { 14, 56, 17.30, -52, 48, 34.9, 5.38 },
    {  8, 26, 25.20, -52, 48, 27.0, 6.05 },
    {  6, 24, 48.19, -52, 48, 23.0, 6.51 },
    { 12, 50, 57.91, -52, 47, 15.0, 5.73 },
    {  5, 50, 28.61, -52, 46,  4.1, 6.35 },
    { 23,  0, 52.80, -52, 45, 15.1, 4.12 },
    { 13, 20, 37.80, -52, 44, 53.2, 5.48 },
    { 23, 58, 55.80, -52, 44, 44.9, 5.13 },
    { 21, 33, 17.71, -52, 44, 15.0, 6.41 },
    {  6, 17, 51.70, -52, 43, 59.2, 6.41 },
    {  8, 56, 19.39, -52, 43, 25.0, 4.69 },
    { 23, 26, 36.60, -52, 43, 18.1, 5.52 },
    {  6, 23, 57.10, -52, 41, 44.9,-0.72 },
    { 22, 39,  8.40, -52, 41, 31.9, 6.65 },
    {  3, 54, 34.01, -52, 41, 26.2, 6.46 },
    { 14, 33, 29.90, -52, 40, 48.0, 5.87 },
    {  7, 29, 59.59, -52, 39,  4.0, 5.87 },
    {  9, 57, 10.90, -52, 38, 20.0, 6.12 },
    {  5, 54, 50.21, -52, 38,  7.1, 5.29 },
    {  7, 55,   .50, -52, 34, 59.2, 6.38 },
    {  2, 44, 10.70, -52, 34, 14.2, 6.15 },
    { 13, 10, 58.39, -52, 34,   .8, 6.06 },
    {  2, 37, 24.41, -52, 32, 35.2, 5.31 },
    {  7, 35, 39.70, -52, 32,  2.0, 4.94 },
    {  7, 15, 21.00, -52, 29, 58.9, 5.97 },
    { 20, 14, 19.01, -52, 26, 44.2, 5.65 },
    { 15, 48, 50.30, -52, 26, 17.2, 6.07 },
    {  6, 45, 53.69, -52, 24, 36.0, 5.80 },
    { 14, 47,  1.30, -52, 23,  1.0, 5.21 },
    {  0, 34, 27.79, -52, 22, 23.2, 5.57 },
    { 15, 38, 49.51, -52, 22, 22.1, 5.44 },
    { 12, 11, 39.10, -52, 22,  7.0, 3.96 },
    { 21, 39, 59.69, -52, 21, 33.1, 6.21 },
    { 19,  6, 19.90, -52, 20, 26.9, 5.16 },
    {  6, 33, 26.09, -52, 19, 44.0, 6.19 },
    {  5, 24, 46.20, -52, 18, 59.0, 6.27 },
    {  7, 20, 21.41, -52, 18, 42.1, 6.05 },
    {  7, 20, 21.70, -52, 18, 34.9, 6.60 },
    { 17, 27, 57.60, -52, 17, 49.9, 5.75 },
    { 16, 56, 28.70, -52, 17,  2.0, 5.94 },
    { 14, 47, 12.31, -52, 12, 20.2, 6.07 },
    {  6, 45, 26.09, -52, 12,  4.0, 6.57 },
    {  9,  1, 44.59, -52, 11, 17.9, 5.23 },
    { 10,  6,  7.10, -52, 11, 17.2, 6.52 },
    { 13, 22, 16.20, -52, 10, 59.2, 5.83 },
    {  5, 15, 38.90, -52, 10, 54.8, 6.49 },
    {  6, 23, 37.70, -52, 10, 52.0, 5.98 },
    { 10, 12, 22.99, -52,  9, 47.9, 6.16 },
    { 13, 55, 12.19, -52,  9, 40.0, 5.71 },
    {  8, 52, 40.80, -52,  7, 45.1, 6.39 },
    {  8, 22, 55.20, -52,  7, 26.0, 5.85 },
    { 13,  5, 30.79, -52,  6, 54.0, 6.43 },
    {  5, 50, 53.21, -52,  6, 32.0, 5.17 },
    { 18, 52, 39.60, -52,  6, 27.0, 5.17 },
    { 15, 12, 17.09, -52,  5, 57.1, 3.41 },
    {  7, 20, 38.69, -52,  5, 10.0, 5.39 },
    {  5, 13, 53.30, -52,  1, 52.0, 6.05 },
    {  7,  7, 13.30, -51, 58,  4.1, 5.96 },
    { 17, 26, 56.30, -51, 56, 57.1, 6.19 },
    { 18, 53, 12.10, -51, 55, 52.0, 6.31 },
    { 20, 44,  2.30, -51, 55, 16.0, 4.51 },
    { 23, 24, 13.10, -51, 53, 29.0, 5.75 },
    { 17, 44,  8.71, -51, 50,  3.1, 5.15 },
    {  6, 31, 18.29, -51, 49, 34.0, 5.60 },
    { 11,  0,  8.59, -51, 49,  4.1, 6.15 },
    { 10,  8, 56.30, -51, 48, 40.0, 4.86 },
    {  1, 57,   .10, -51, 45, 58.0, 6.10 },
    { 10, 13, 28.01, -51, 45, 22.0, 5.78 },
    {  9, 23, 59.50, -51, 44, 13.9, 6.08 },
    {  8, 25, 31.01, -51, 43, 41.2, 5.17 },
    { 11, 59, 10.90, -51, 41, 48.1, 6.05 },
    {  4, 39,  4.30, -51, 40, 22.1, 6.44 },
    {  1, 55, 57.50, -51, 36, 32.0, 3.70 },
    { 20, 51, 30.10, -51, 36, 29.9, 5.05 },
    { 15, 28, 27.19, -51, 35, 51.0, 6.10 },
    {  4,  0, 15.70, -51, 33, 52.9, 6.51 },
    {  9, 18, 42.19, -51, 33, 38.2, 5.87 },
    {  9, 30,  5.21, -51, 31,  1.9, 5.45 },
    {  2, 16, 30.60, -51, 30, 43.9, 3.56 },
    { 14,  9, 34.99, -51, 30, 16.9, 6.00 },
    {  4, 16,  1.61, -51, 29, 12.1, 4.25 },
    {  7, 34, 39.50, -51, 28, 28.9, 6.28 },
    { 12, 26, 31.61, -51, 27,  2.9, 4.82 },
    {  7, 58, 21.41, -51, 26, 55.0, 6.44 },
    { 14, 57,  1.39, -51, 26, 48.8, 6.64 },
    { 13, 46, 39.31, -51, 25, 58.1, 4.65 },
    {  7,  0, 51.50, -51, 24,  9.0, 5.14 },
    { 12, 11, 31.39, -51, 21, 33.8, 6.23 },
    {  9, 56, 21.89, -51, 20, 10.0, 6.37 },
    { 22, 48, 33.31, -51, 19,   .8, 3.49 },
    { 13, 18, 34.61, -51, 17, 10.0, 6.19 },
    {  6, 46, 52.80, -51, 15, 56.9, 5.40 },
    { 21,  0, 21.50, -51, 15, 55.1, 5.76 },
    {  9, 34,  8.81, -51, 15, 19.1, 5.01 },
    { 10, 13, 22.80, -51, 13, 59.9, 5.28 },
    {  9, 43, 27.50, -51, 13, 41.9, 6.15 },
    {  6,  0, 49.20, -51, 12, 59.0, 5.67 },
    { 11,  6,  5.81, -51, 12, 45.0, 6.30 },
    {  9,  7, 14.69, -51, 12, 42.8, 6.73 },
    { 10, 16, 40.20, -51, 12, 18.0, 6.30 },
    { 12, 57,  4.39, -51, 11, 55.0, 5.16 },
    { 13, 29, 25.20, -51,  9, 55.1, 5.06 },
    {  9, 53, 50.21, -51,  8, 48.8, 5.93 },
    { 17,  1, 46.10, -51,  7, 50.9, 6.45 },
    {  2, 33, 54.60, -51,  5, 37.0, 6.24 },
    {  2, 22, 54.60, -51,  5, 31.9, 5.92 },
    { 18, 17,   .91, -51,  4,  5.9, 6.06 },
    {  5, 47, 17.11, -51,  3, 59.0, 3.85 },
    {  9, 18,  5.81, -51,  3,  4.0, 5.26 },
    { 19,  3, 57.41, -51,  1,  7.0, 5.93 },
    {  7, 26, 21.89, -51,  1,  5.9, 5.10 },
    { 13, 44, 15.91, -51,  0, 47.2, 6.47 },
    {  0, 50, 41.21, -50, 59, 12.8, 5.22 },
    {  8, 35, 52.10, -50, 58, 12.0, 5.80 },
    { 11,  6, 27.41, -50, 57, 24.1, 6.32 },
    { 23,  1,  7.49, -50, 57,   .0, 5.68 },
    {  2, 54,  6.50, -50, 52, 17.0, 6.21 },
    {  2, 10, 25.61, -50, 49, 27.8, 6.12 },
    {  1, 46,  5.81, -50, 48, 59.0, 5.49 },
    {  2, 42, 33.50, -50, 48,  1.1, 5.41 },
    { 13, 42, 54.60, -50, 47, 26.2, 6.41 },
    { 14, 23, 20.30, -50, 46, 19.9, 6.02 },
    { 10, 57,  7.90, -50, 45, 54.0, 5.91 },
    { 12,  8,  4.80, -50, 45, 47.9, 6.37 },
    { 20, 54, 34.99, -50, 43, 40.1, 6.24 },
    { 12,  8, 21.50, -50, 43, 21.0, 2.60 },
    { 13, 13, 23.50, -50, 42,   .0, 5.89 },
    { 23,  7, 14.69, -50, 41, 11.0, 5.83 },
    { 16, 56,  8.90, -50, 40, 30.0, 6.33 },
    { 12,  8,  5.21, -50, 39, 41.0, 4.47 },
    { 16, 58, 18.00, -50, 38, 28.0, 5.55 },
    { 17, 26,   .00, -50, 38,  1.0, 5.23 },
    { 17, 27, 12.41, -50, 37, 49.1, 5.92 },
    { 15, 52, 51.50, -50, 36, 55.1, 6.60 },
    {  6, 49, 56.21, -50, 36, 52.9, 2.93 },
    {  6, 54,  2.30, -50, 36, 42.1, 6.26 },
    {  5, 19, 22.10, -50, 36, 22.0, 5.45 },
    {  8,  4, 42.41, -50, 35, 26.2, 5.95 },
    {  0, 28, 43.10, -50, 31, 58.1, 6.26 },
    { 17, 42,  3.89, -50, 30, 38.2, 6.24 },
    {  7, 50, 23.90, -50, 30, 34.9, 5.91 },
    { 19, 12, 46.10, -50, 29, 11.0, 6.13 },
    {  4, 42, 46.39, -50, 28, 53.0, 5.31 },
    { 14, 32, 36.89, -50, 27, 24.8, 4.42 },
    {  8, 15, 23.30, -50, 26, 57.8, 6.44 },
    {  3, 32, 34.80, -50, 22, 43.0, 5.68 },
    { 13, 59, 17.30, -50, 22, 12.0, 5.91 },
    {  5, 54, 10.70, -50, 21, 42.8, 6.52 },
    {  7,  5, 16.49, -50, 21, 37.1, 6.46 },
    {  6, 18, 46.80, -50, 21, 33.1, 7.04 },
    {  0,  1, 19.99, -50, 20, 13.9, 5.53 },
    { 13, 47, 38.40, -50, 19, 16.0, 5.45 },
    { 23, 20, 49.99, -50, 18, 24.1, 6.05 },
    { 13, 47, 27.60, -50, 14, 57.8, 5.91 },
    {  9, 54, 51.29, -50, 14, 38.0, 5.72 },
    {  6, 29, 49.10, -50, 14, 21.1, 5.27 },
    { 12, 28,  2.40, -50, 13, 50.2, 3.91 },
    { 23, 47, 16.01, -50, 13, 36.1, 5.18 },
    {  1, 50, 54.50, -50, 12, 22.0, 5.94 },
    {  8, 13, 34.10, -50, 11, 46.0, 5.51 },
    { 23, 27,  9.10, -50,  9, 25.9, 6.20 },
    { 16, 19, 50.40, -50,  9, 20.2, 4.02 },
    { 18, 46, 59.09, -50,  5, 39.8, 6.54 },
    { 18,  6, 37.90, -50,  5, 30.1, 3.66 },
    { 16, 17,   .91, -50,  4,  5.9, 4.99 },
    { 17, 19, 30.31, -50,  3, 47.9, 6.27 },
    { 17, 37, 27.19, -50,  3, 36.0, 5.93 },
    { 16, 50, 35.90, -50,  2, 44.2, 6.47 },
    {  1, 41, 41.09, -50,  2, 20.0, 6.64 },
    { 20, 21, 40.99, -49, 59, 57.8, 6.27 },
    {  7, 43,  6.89, -49, 59, 34.1, 6.57 },
    {  7, 59, 12.29, -49, 58, 36.1, 6.32 },
    {  7, 59, 13.39, -49, 58, 25.0, 6.34 },
    { 13, 39, 59.69, -49, 57,  1.1, 6.00 },
    {  8, 34, 43.61, -49, 56, 39.1, 5.01 },
    { 21, 21, 16.39, -49, 56, 16.1, 6.38 },
    { 12, 33, 59.21, -49, 54, 33.8, 6.38 },
    { 13,  6, 54.60, -49, 54, 22.0, 4.27 },
    {  2, 53, 52.90, -49, 53, 25.1, 4.00 },
    { 18, 54, 32.30, -49, 52, 43.0, 6.60 },
    { 17, 31, 50.50, -49, 52, 34.0, 2.95 },
    { 13, 23, 52.30, -49, 49, 23.2, 6.48 },
    {  8, 43, 40.30, -49, 49, 22.1, 5.16 },
    { 11, 12, 56.90, -49, 44, 11.0, 6.11 },
    {  1, 32, 36.31, -49, 43, 40.1, 6.28 },
    { 22, 46, 28.30, -49, 41,  8.9, 6.48 },
    { 16, 41, 40.20, -49, 39,  6.1, 5.65 },
    {  5, 54, 41.09, -49, 37, 36.8, 6.10 },
    { 23, 13, 15.00, -49, 37,  8.0, 6.80 },
    {  7, 53,  3.70, -49, 36, 47.2, 4.63 },
    { 23,  7,  9.50, -49, 36, 24.1, 6.33 },
    {  7,  3, 53.69, -49, 35,  2.0, 4.93 },
    {  5,  4, 58.01, -49, 34, 40.1, 5.03 },
    { 16, 22, 28.01, -49, 34, 19.9, 5.33 },
    {  6,  9, 23.30, -49, 33, 46.1, 6.49 },
    { 13,  3, 33.19, -49, 31, 37.9, 4.85 },
    { 14, 30, 20.90, -49, 31,  9.1, 5.37 },
    { 21, 45, 19.01, -49, 29, 55.0, 6.45 },
    { 15, 42, 37.20, -49, 29, 21.8, 6.04 },
    { 14, 37, 53.21, -49, 25, 32.9, 4.05 },
    {  9,  9, 45.10, -49, 25, 28.9, 6.48 },
    { 10, 46, 46.20, -49, 25, 12.0, 2.69 },
    { 17, 40, 23.59, -49, 24, 56.2, 4.77 },
    { 10, 28,  1.90, -49, 24, 20.2, 6.10 },
    { 11,  5,  4.20, -49, 23, 33.0, 6.13 },
    { 13, 27, 20.81, -49, 22, 50.9, 6.28 },
    {  9, 36, 49.61, -49, 21, 19.1, 4.35 },
    { 20,  0, 25.30, -49, 21,  4.0, 6.17 },
    {  7, 58, 14.40, -49, 14, 42.0, 4.41 },
    { 16,  3, 12.91, -49, 13, 46.9, 4.65 },
    {  5,  2, 48.60, -49,  9,  5.0, 5.38 },
    { 13, 27,  6.29, -49,  8, 38.0, 6.31 },
    { 11, 34, 56.81, -49,  8, 12.1, 5.50 },
    { 11, 12, 33.10, -49,  6,  4.0, 5.36 },
    { 15,  7, 25.90, -49,  5, 17.9, 5.77 },
    {  0,  6, 19.01, -49,  4, 30.0, 5.70 },
    {  1, 31, 15.10, -49,  4, 22.1, 3.95 },
    { 18, 28, 49.90, -49,  4, 14.9, 4.13 },
    { 11, 45, 12.60, -49,  4, 10.9, 6.26 },
    { 14, 39, 24.70, -49,  3, 20.2, 6.39 },
    {  9, 33, 44.50, -49,  0, 18.0, 5.12 },
    {  8,  0, 14.90, -48, 58, 53.0, 6.02 },
    { 22, 46,  7.99, -48, 58, 44.0, 6.62 },
    { 12, 41, 31.01, -48, 57, 34.9, 2.17 },
    { 13, 14, 43.10, -48, 57, 24.1, 5.89 },
    { 12, 53,  6.89, -48, 56, 35.9, 4.33 },
    {  7, 10, 47.50, -48, 55, 55.9, 5.14 },
    {  8, 41,  5.30, -48, 55, 21.0, 5.90 },
    { 12, 26, 48.19, -48, 54, 47.9, 6.26 },
    { 15, 49, 57.50, -48, 54, 42.8, 5.84 },
    { 17, 11, 38.90, -48, 52, 27.1, 5.84 },
    {  8,  0, 28.90, -48, 52, 17.0, 6.12 },
    { 14, 58,  8.81, -48, 51, 47.2, 6.35 },
    {  7, 36, 43.90, -48, 49, 49.1, 5.72 },
    { 12, 42, 35.40, -48, 48, 47.2, 4.66 },
    {  0,  1,  4.51, -48, 48, 36.0, 5.71 },
    {  0, 31, 25.01, -48, 48, 13.0, 4.77 },
    { 16, 41, 20.30, -48, 45, 47.2, 5.65 },
    {  9, 36, 25.30, -48, 45,  5.0, 6.17 },
    { 15, 11, 57.60, -48, 44, 37.0, 5.69 },
    {  6, 20,  6.10, -48, 44, 28.0, 6.60 },
    { 15, 11, 56.09, -48, 44, 16.1, 3.87 },
    {  3, 10, 27.41, -48, 44,  3.1, 6.12 },
    {  6, 56, 16.01, -48, 43, 16.0, 4.95 },
    { 12,  8, 14.69, -48, 41, 34.1, 5.34 },
    {  8,  9,  9.60, -48, 41,  3.8, 5.70 },
    { 17,  0, 27.10, -48, 38, 52.1, 6.00 },
    {  7, 38, 18.19, -48, 36,  4.0, 5.68 },
    { 22, 53, 37.90, -48, 35, 53.2, 6.04 },
    {  8, 57, 55.80, -48, 34, 23.9, 5.87 },
    { 13, 23,  2.59, -48, 33, 46.1, 6.38 },
    { 12, 37, 42.19, -48, 32, 28.0, 3.86 },
    {  8, 22, 31.61, -48, 29, 25.1, 4.82 },
    { 13,  6, 16.70, -48, 27, 49.0, 4.71 },
    {  8, 11, 11.09, -48, 27, 42.8, 5.82 },
    { 12, 50, 19.61, -48, 27, 34.9, 6.24 },
    {  6,  4, 46.90, -48, 27, 31.0, 6.58 },
    {  9, 57, 42.50, -48, 24, 51.8, 6.05 },
    { 18, 53,  2.50, -48, 21, 36.0, 6.19 },
    {  8, 52, 38.59, -48, 21, 33.1, 5.91 },
    { 14, 22, 38.71, -48, 19, 13.1, 6.09 },
    { 15, 21, 48.19, -48, 19,  4.1, 5.65 },
    { 19,  6, 55.61, -48, 17, 57.1, 5.97 },
    {  6, 51, 32.81, -48, 17, 33.0, 6.42 },
    { 13, 34, 28.90, -48, 16, 19.9, 6.33 },
    {  7, 14, 38.21, -48, 16, 18.1, 4.76 },
    { 10, 37, 18.10, -48, 13, 32.9, 3.84 },
    {  6, 38, 37.61, -48, 13, 13.1, 4.93 },
    { 15, 12, 31.30, -48, 13,  7.0, 6.33 },
    {  0, 30, 26.09, -48, 12, 54.0, 5.69 },
    {  6, 25, 43.61, -48, 10, 37.9, 5.76 },
    { 15, 57,  3.79, -48,  9, 43.9, 6.31 },
    { 18, 26, 53.90, -48,  7,   .8, 5.46 },
    { 22,  9, 58.01, -48,  6, 25.9, 6.43 },
    {  7, 53, 18.19, -48,  6, 11.2, 4.24 },
    { 19, 35, 13.01, -48,  5, 57.1, 4.90 },
    {  8, 42, 16.01, -48,  5, 57.1, 5.51 },
    { 18, 41, 30.60, -48,  5, 42.0, 6.49 },
    { 12, 52,  5.30, -48,  5, 39.1, 6.33 },
    { 15, 15, 53.81, -48,  4, 27.1, 5.95 },
    {  3, 44, 50.59, -48,  3, 41.0, 6.49 },
    {  0, 35, 41.11, -48,  0,  2.9, 5.51 },
    { 22, 56, 47.81, -47, 58,  9.1, 5.70 },
    { 13, 22, 52.70, -47, 56, 35.2, 6.16 },
    {  8,  9, 43.20, -47, 56, 15.0, 5.23 },
    {  8, 29,  4.70, -47, 55, 45.1, 5.33 },
    { 15, 22,  8.30, -47, 55, 40.1, 5.00 },
    { 18, 39, 14.30, -47, 54, 34.9, 5.86 },
    {  7, 57, 19.99, -47, 53, 25.1, 6.22 },
    { 14, 56, 31.99, -47, 52, 45.1, 5.64 },
    { 15, 18, 31.99, -47, 52, 30.0, 4.27 },
    {  8, 31, 10.80, -47, 52,   .1, 6.39 },
    {  1, 50, 20.21, -47, 48, 59.0, 6.14 },
    {  3, 21, 33.29, -47, 46, 36.8, 6.39 },
    {  3, 17, 26.59, -47, 45,  6.1, 5.85 },
    { 11, 37, 33.91, -47, 44, 49.9, 5.44 },
    { 15, 40, 58.30, -47, 44,  8.2, 6.23 },
    { 20, 18, 55.99, -47, 42, 38.9, 6.31 },
    {  2, 26, 59.11, -47, 42, 14.0, 4.25 },
    { 10, 20, 16.70, -47, 41, 57.1, 5.65 },
    { 11,  4, 31.20, -47, 40, 45.1, 5.67 },
    {  6, 40, 49.30, -47, 40, 28.9, 6.65 },
    { 11, 35, 55.61, -47, 38, 30.1, 5.25 },
    { 20, 19, 17.90, -47, 34, 49.1, 6.13 },
    { 19, 50, 13.80, -47, 33, 25.9, 5.94 },
    { 16, 27, 11.09, -47, 33, 18.0, 4.47 },
    {  0, 45, 45.60, -47, 33,  6.1, 5.80 },
    {  8, 53, 50.69, -47, 31, 14.9, 5.33 },
    { 18, 11,  4.49, -47, 30, 47.2, 6.07 },
    { 17, 23, 16.10, -47, 28,  5.9, 5.25 },
    { 14, 46, 29.09, -47, 26, 28.0, 5.74 },
    { 14, 41, 55.80, -47, 23, 17.9, 2.30 },
    {  1, 57, 10.01, -47, 23,  6.0, 4.83 },
    {  3, 30, 37.01, -47, 22, 31.1, 5.99 },
    { 11, 35, 13.20, -47, 22, 21.0, 5.71 },
    { 16, 15, 15.31, -47, 22, 19.9, 5.14 },
    { 10,  6, 11.30, -47, 22, 12.0, 5.08 },
    {  3, 45, 15.79, -47, 21, 34.9, 5.73 },
    {  8,  9, 29.30, -47, 20, 44.9, 4.27 },
    {  9, 13, 34.51, -47, 20, 19.0, 5.92 },
    {  8,  9, 31.99, -47, 20, 12.1, 1.78 },
    {  8, 41, 13.10, -47, 19,   .8, 4.77 },
    {  5, 36,  2.71, -47, 18, 50.0, 6.11 },
    { 21, 48, 15.79, -47, 18, 13.0, 5.58 },
    { 20, 37, 34.01, -47, 17, 29.0, 3.11 },
    { 13, 55, 32.40, -47, 17, 17.9, 2.55 },
    {  8, 58, 52.30, -47, 14,  4.9, 5.18 },
    { 18, 29, 55.80, -47, 13, 13.1, 5.70 },
    { 22, 42, 36.89, -47, 12, 38.2, 5.98 },
    { 17,  3, 41.71, -47,  9, 36.0, 6.06 },
    { 13, 53, 56.90, -47,  7, 41.2, 6.10 },
    {  9,  4,  9.31, -47,  5, 52.1, 3.75 },
    {  7, 48, 20.30, -47,  4, 40.1, 4.71 },
    {  5, 30,  9.50, -47,  4, 40.1, 5.46 },
    { 11, 56, 43.90, -47,  4, 21.0, 6.26 },
    { 15, 51, 31.51, -47,  3, 38.2, 6.01 },
    { 15,  5,  7.20, -47,  3,  4.0, 4.82 },
    { 15,  5,  7.20, -47,  3,  4.0, 4.72 },
    { 10, 32, 56.90, -47,  0, 11.9, 5.02 },
    {  8, 13, 36.19, -46, 59, 30.8, 5.13 },
    {  8,  5, 20.40, -46, 58, 44.0, 6.19 },
    {  3,  2, 55.90, -46, 58, 30.0, 5.82 },
    {  8, 33, 30.41, -46, 58, 16.0, 6.24 },
    { 22,  8, 13.99, -46, 57, 40.0, 1.74 },
    {  4, 27,  6.00, -46, 56, 51.0, 6.10 },
    { 22, 46, 43.70, -46, 56, 21.8, 6.56 },
    {  9, 50, 42.00, -46, 56,  3.8, 5.73 },
    { 17, 41, 16.30, -46, 55, 18.8, 5.79 },
    { 13, 51, 47.21, -46, 53, 57.1, 5.77 },
    {  3, 53, 33.29, -46, 53, 37.0, 5.93 },
    { 22, 42, 40.10, -46, 53,  4.9, 2.10 },
    { 13, 20, 57.70, -46, 52, 50.2, 5.77 },
    {  7, 49, 12.89, -46, 51, 28.1, 5.84 },
    {  7, 14, 45.91, -46, 50, 58.9, 5.72 },
    {  7, 16, 15.50, -46, 46, 27.8, 5.66 },
    {  7, 12, 33.60, -46, 45, 33.8, 4.49 },
    {  1, 29, 30.41, -46, 45, 23.0, 6.31 },
    { 15, 29, 24.31, -46, 43, 58.1, 5.24 },
    {  1,  6,  4.99, -46, 43,  7.0, 3.31 },
    {  0, 48, 56.69, -46, 41, 52.1, 6.27 },
    {  8, 40, 37.61, -46, 38, 56.0, 3.84 },
    {  8, 12,   .00, -46, 38, 39.1, 5.76 },
    { 23, 39, 28.01, -46, 38, 16.1, 6.09 },
    { 10,  3, 20.50, -46, 38, 10.0, 6.12 },
    { 17, 19,  3.19, -46, 38,  2.0, 5.48 },
    { 21, 24, 20.81, -46, 36, 54.0, 6.31 },
    {  6, 49, 54.60, -46, 36, 52.9, 5.14 },
    {  7, 47, 31.49, -46, 36, 31.0, 5.23 },
    {  5, 46, 27.41, -46, 35, 49.9, 5.31 },
    { 18, 52, 27.10, -46, 35, 43.1, 5.54 },
    { 13, 56, 19.51, -46, 35, 33.0, 5.83 },
    { 18, 52, 59.59, -46, 35,  8.9, 6.19 },
    { 14, 39, 10.99, -46, 35,  3.1, 6.07 },
    {  9, 11, 33.19, -46, 35,  2.0, 5.79 },
    {  9, 51, 40.80, -46, 32, 52.1, 4.58 },
    { 22, 45, 40.70, -46, 32, 51.0, 5.51 },
    {  8, 50, 33.50, -46, 31, 45.1, 5.10 },
    {  2, 42,  8.50, -46, 31, 27.8, 6.10 },
    {  4, 29, 19.99, -46, 30, 55.1, 6.16 },
    { 17, 35, 39.60, -46, 30, 20.2, 4.59 },
    { 13, 37, 23.71, -46, 25, 41.9, 5.90 },
    {  1,  2, 49.20, -46, 23, 51.0, 5.36 },
    {  7, 49, 14.30, -46, 22, 23.9, 4.11 },
    {  8, 29, 45.60, -46, 19, 54.8, 5.99 },
    {  1, 53, 38.81, -46, 18,  9.0, 4.41 },
    {  2, 45, 16.49, -46, 17, 13.9, 6.85 },
    {  8, 12, 30.91, -46, 15, 51.1, 6.03 },
    { 14, 36, 19.01, -46, 14, 43.1, 5.55 },
    { 16, 29, 42.31, -46, 14, 35.9, 5.35 },
    { 20, 49, 28.99, -46, 13, 36.8, 4.89 },
    {  9, 51, 19.80, -46, 11, 38.0, 5.62 },
    {  8, 47, 18.91, -46,  9, 20.2, 5.75 },
    { 12, 41, 22.99, -46,  8, 44.2, 5.84 },
    { 14, 27, 12.19, -46,  8,  3.8, 5.83 },
    { 14, 37, 20.11, -46,  8,  2.0, 5.41 },
    {  0, 41, 19.61, -46,  5,  6.0, 4.59 },
    { 16, 43,  3.41, -46,  4, 14.2, 6.23 },
    { 14, 19, 24.19, -46,  3, 28.1, 3.55 },
    {  9, 22, 24.00, -46,  2, 51.0, 5.75 },
    {  8, 46,  1.70, -46,  2, 30.1, 3.91 },
    { 17, 31, 49.10, -46,  2, 11.0, 6.03 },
    { 18, 26, 58.39, -45, 58,  5.9, 3.51 },
    { 18, 11, 13.80, -45, 57, 15.8, 4.53 },
    { 22, 22, 43.90, -45, 56, 52.1, 6.62 },
    { 22, 23,  7.99, -45, 55, 43.0, 5.62 },
    {  5, 31, 36.10, -45, 55, 31.1, 5.86 },
    { 18, 31, 45.41, -45, 54, 54.0, 4.96 },
    {  8, 46, 30.60, -45, 54, 46.1, 5.46 },
    { 11, 16, 27.70, -45, 52, 48.0, 6.31 },
    {  4,  8, 33.91, -45, 51, 52.9, 6.59 },
    { 17, 26, 51.50, -45, 50, 37.0, 5.29 },
    {  8, 14, 23.90, -45, 50,  3.8, 5.83 },
    {  5, 43, 41.09, -45, 49, 59.2, 6.39 },
    { 18, 49, 27.41, -45, 48, 37.1, 5.81 },
    {  6, 58, 41.81, -45, 46,  5.2, 6.22 },
    { 18,  8, 30.10, -45, 46,  1.9, 6.15 },
    { 18, 32,  1.99, -45, 45, 25.9, 5.07 },
    {  0,  9, 24.70, -45, 44, 51.0, 3.88 },
    {  9, 49, 57.10, -45, 43, 58.1, 5.08 },
    { 12, 14,  2.59, -45, 43, 26.0, 5.31 },
    { 11, 45, 43.90, -45, 41, 24.0, 5.29 },
    { 14,  1, 43.39, -45, 36, 13.0, 4.34 },
    { 17, 51, 44.50, -45, 36,  2.2, 6.11 },
    {  7, 57, 51.79, -45, 34, 40.1, 5.17 },
    {  1, 31, 39.10, -45, 34, 32.2, 6.17 },
    {  9, 15, 14.59, -45, 33, 20.2, 6.25 },
    {  1, 15, 11.09, -45, 31, 53.0, 4.96 },
    { 17,  5,  5.30, -45, 30,  6.1, 6.28 },
    { 23, 37, 51.00, -45, 29, 33.0, 4.74 },
    { 19, 16, 21.70, -45, 27, 59.0, 5.40 },
    {  8,  0, 19.61, -45, 27, 24.8, 6.61 },
    { 17,  0, 32.30, -45, 27,  6.1, 6.65 },
    {  6, 49, 57.79, -45, 27,   .0, 6.55 },
    { 12, 11,  2.90, -45, 25, 22.1, 6.61 },
    {  8, 41, 56.90, -45, 24, 38.9, 5.23 },
    { 15, 50, 16.30, -45, 24,  6.1, 6.12 },
    { 14, 26, 10.80, -45, 22, 45.8, 4.35 },
    { 16, 24, 54.19, -45, 20, 57.1, 6.33 },
    { 14, 30,  8.59, -45, 19, 18.1, 5.50 },
    {  8, 49, 47.69, -45, 18, 29.2, 4.93 },
    {  9, 54, 17.59, -45, 17,  2.0, 5.71 },
    {  6, 10, 39.91, -45, 16, 54.8, 6.31 },
    { 15,  8, 50.59, -45, 16, 46.9, 4.05 },
    { 15, 11, 31.90, -45, 16, 45.8, 7.39 },
    { 19, 39, 42.00, -45, 16, 41.2, 6.25 },
    { 15, 11, 34.90, -45, 16, 39.0, 6.44 },
    { 19, 33, 21.60, -45, 16, 18.8, 5.61 },
    {  8,  6, 40.39, -45, 15, 59.0, 5.05 },
    { 23, 10, 21.60, -45, 14, 48.1, 3.90 },
    { 16, 35,  7.90, -45, 14, 40.9, 6.46 },
    { 14, 26,  8.21, -45, 13, 17.0, 4.56 },
    {  7, 59,  1.80, -45, 12, 58.0, 5.99 },
    { 19, 14, 39.70, -45, 11, 35.9, 5.92 },
    {  8, 40, 35.30, -45, 11, 29.0, 5.71 },
    { 14, 20, 42.50, -45, 11, 13.9, 4.77 },
    {  7, 13, 13.39, -45, 10, 59.2, 4.89 },
    { 11, 51,  8.71, -45, 10, 25.0, 4.46 },
    {  7, 42, 57.19, -45, 10, 23.9, 5.06 },
    { 16,  6, 29.40, -45, 10, 23.9, 4.72 },
    { 20,  0, 48.31, -45,  6, 47.2, 5.81 },
    {  6,  7,  1.90, -45,  5, 29.0, 6.51 },
    { 23, 44,  1.39, -45,  4, 59.9, 6.09 },
    {  6,  4, 40.20, -45,  4, 44.0, 5.93 },
    { 10, 31, 56.59, -45,  4,  9.8, 6.09 },
    { 10, 31, 57.50, -45,  4,   .1, 5.74 },
    {  8, 55, 19.30, -45,  2, 30.1, 6.26 },
    {  6,  4, 28.39, -45,  2, 12.1, 6.35 },
    { 21, 20,  9.50, -45,  1, 19.9, 6.00 },
    { 14, 15, 38.81, -45,  0,  2.9, 6.31 },
    { 15, 35, 53.21, -44, 57, 31.0, 4.54 },
    {  4, 30, 50.09, -44, 57, 14.0, 5.07 },
    {  9, 16,  4.20, -44, 53, 55.0, 6.04 },
    {  5, 49, 34.10, -44, 52, 31.1, 6.38 },
    {  9, 11,  4.39, -44, 52,  5.2, 5.00 },
    { 21, 33, 23.50, -44, 50, 55.0, 5.57 },
    { 23, 31, 27.00, -44, 50, 37.0, 6.02 },
    { 13, 58, 40.80, -44, 48, 13.0, 3.87 },
    { 19, 23, 13.20, -44, 47, 58.9, 4.29 },
    {  0, 39, 52.01, -44, 47, 48.1, 6.01 },
    {  9, 46, 30.41, -44, 45, 18.0, 5.55 },
    {  7, 49, 28.20, -44, 45,  6.8, 6.32 },
    {  8, 30, 39.19, -44, 44, 13.9, 6.30 },
    {  8, 29, 27.60, -44, 43, 30.0, 4.99 },
    {  2,  1, 42.41, -44, 42, 49.0, 5.14 },
    { 15, 22, 40.90, -44, 41, 21.8, 3.37 },
    { 12, 34, 42.31, -44, 40, 23.9, 5.77 },
    { 15, 41, 11.30, -44, 39, 40.0, 4.64 },
    { 11, 22, 23.11, -44, 38, 44.9, 6.12 },
    {  7, 13, 32.40, -44, 38, 22.9, 5.10 },
    {  7, 41, 21.79, -44, 37, 55.9, 6.41 },
    { 10, 32, 33.60, -44, 37,  8.0, 5.91 },
    {  7, 50, 42.41, -44, 34, 46.9, 6.45 },
    { 17, 10, 42.29, -44, 33, 27.0, 5.08 },
    {  1, 24, 41.90, -44, 31, 41.9, 6.26 },
    { 20, 33, 55.10, -44, 30, 58.0, 5.11 },
    { 15, 12, 49.51, -44, 30,  2.2, 4.82 },
    { 23, 29,   .79, -44, 29, 52.1, 6.43 },
    { 23, 16, 39.70, -44, 29, 21.1, 5.92 },
    { 19, 22, 38.30, -44, 27, 32.0, 4.01 },
    { 22, 15, 35.09, -44, 27,  6.8, 6.10 },
    {  3, 12, 25.80, -44, 25, 10.9, 5.93 },
    { 15, 36, 12.10, -44, 23, 48.8, 5.43 },
    { 11, 13, 14.69, -44, 22, 19.9, 5.80 },
    {  4, 12, 31.61, -44, 22,  5.9, 6.71 },
    {  6,  8, 34.61, -44, 21, 22.0, 6.27 },
    { 17, 56, 47.40, -44, 20, 31.9, 4.86 },
    { 12,  8, 53.81, -44, 19, 34.0, 5.75 },
    {  0,  0, 19.20, -44, 17, 26.2, 6.29 },
    {  4, 19, 16.61, -44, 16,  5.2, 5.34 },
    {  9, 16, 23.11, -44, 15, 56.9, 5.12 },
    { 22, 42, 43.10, -44, 14, 52.1, 6.07 },
    {  5, 24, 55.61, -44, 13, 32.9, 6.08 },
    { 17, 19, 24.50, -44, 13, 23.2, 6.65 },
    { 18, 15, 52.70, -44, 12, 24.1, 5.46 },
    { 17, 24, 13.01, -44,  9, 45.0, 5.12 },
    {  4, 25, 19.10, -44,  9, 38.9, 6.39 },
    {  8, 29,  7.61, -44,  9, 38.2, 5.79 },
    { 12, 54, 58.49, -44,  9,  6.8, 5.89 },
    {  9, 14,  8.21, -44,  8, 44.9, 5.85 },
    { 13, 37,  6.00, -44,  8, 35.9, 5.98 },
    { 17, 18, 48.00, -44,  7, 46.9, 5.76 },
    {  8,  9, 35.90, -44,  7, 22.1, 5.21 },
    { 18, 24, 18.19, -44,  6, 37.1, 5.25 },
    {  7, 57, 18.41, -44,  6, 34.9, 5.09 },
    { 17,  5, 48.60, -44,  6, 18.0, 6.19 },
    { 16, 34,  4.99, -44,  2, 43.1, 4.94 },
    {  5, 58, 37.61, -44,  2,  3.8, 5.81 },
    { 20, 48, 29.21, -43, 59, 19.0, 5.11 },
    {  7, 18,  4.20, -43, 59, 12.1, 5.85 },
    {  4, 48, 33.79, -43, 58, 48.0, 6.72 },
    { 13, 17, 13.90, -43, 58, 45.8, 5.84 },
    {  6, 52, 47.11, -43, 58, 32.9, 6.46 },
    { 16, 22, 28.90, -43, 54, 43.9, 5.88 },
    { 18, 29, 12.89, -43, 50, 44.9, 6.36 },
    {  7, 55, 46.49, -43, 50, 42.0, 6.02 },
    {  2, 10,  4.90, -43, 48, 56.2, 6.32 },
    { 10, 59, 59.40, -43, 48, 25.9, 5.81 },
    {  7, 45, 18.10, -43, 45,  7.9, 6.03 },
    { 22, 29, 45.50, -43, 44, 57.8, 4.11 },
    { 11, 14, 54.00, -43, 44,  3.1, 6.21 },
    { 19, 24, 21.41, -43, 43, 23.2, 6.17 },
    {  0, 51, 52.10, -43, 42, 33.1, 6.90 },
    {  0, 26, 12.19, -43, 40, 48.0, 3.94 },
    { 18, 48, 50.50, -43, 40, 48.0, 5.49 },
    { 10, 35, 10.49, -43, 39, 52.9, 6.08 },
    {  9, 12, 30.60, -43, 36, 49.0, 5.57 },
    {  7,  3, 58.80, -43, 36, 42.1, 6.79 },
    {  7,  3, 57.29, -43, 36, 29.2, 5.54 },
    { 14, 51, 38.40, -43, 34, 32.2, 4.32 },
    { 14, 47, 32.09, -43, 33, 27.0, 6.30 },
    { 23,  6, 52.80, -43, 31, 14.2, 4.28 },
    {  2,  9,  9.29, -43, 31,   .1, 5.85 },
    { 18, 31, 56.21, -43, 30, 28.1, 5.72 },
    {  7, 56, 57.89, -43, 30,  1.1, 5.35 },
    { 22, 29, 16.20, -43, 29, 44.2, 3.97 },
    { 15, 16, 10.49, -43, 29,  4.9, 6.04 },
    { 14,  8, 51.89, -43, 28, 16.0, 6.17 },
    { 19, 29, 23.90, -43, 26, 44.9, 5.71 },
    { 18, 49, 34.99, -43, 26,  2.0, 5.61 },
    {  9,  7, 59.81, -43, 25, 57.0, 2.21 },
    { 18,  6, 49.80, -43, 25, 28.9, 5.77 },
    { 18,  6, 49.80, -43, 25, 28.9, 5.77 },
    {  7,  2, 15.60, -43, 24, 15.1, 6.43 },
    { 16, 38, 26.21, -43, 23, 55.0, 5.83 },
    {  0, 50,  3.70, -43, 23, 40.9, 6.48 },
    { 13, 11, 23.21, -43, 22,  8.0, 5.25 },
    {  1, 28, 21.89, -43, 19,  5.9, 3.41 },
    {  7, 29, 13.80, -43, 18,  5.0, 3.25 },
    { 17, 12,  9.19, -43, 14, 21.1, 3.33 },
    {  0, 18, 42.60, -43, 14,  7.1, 6.33 },
    {  9, 14, 24.50, -43, 13, 39.0, 5.25 },
    {  2, 22, 11.81, -43, 12,   .0, 6.31 },
    {  6, 37, 45.70, -43, 11, 46.0, 3.17 },
    {  9, 38,  1.51, -43, 11, 28.0, 5.50 },
    { 18, 39, 34.99, -43, 11, 10.0, 5.37 },
    {  9,  0, 22.20, -43, 10, 23.9, 6.07 },
    { 14, 59, 27.10, -43,  9, 36.0, 6.10 },
    { 13, 13, 57.50, -43,  8, 20.0, 6.16 },
    { 14, 58, 31.90, -43,  8,  2.0, 2.68 },
    { 23, 23, 45.41, -43,  7, 27.8, 6.10 },
    { 10, 15, 31.51, -43,  6, 45.0, 5.60 },
    { 11, 41, 19.80, -43,  5, 44.9, 5.55 },
    {  7, 51, 20.50, -43,  5, 44.2, 6.32 },
    { 14,  6, 10.90, -43,  5, 30.8, 6.20 },
    {  7, 33, 13.30, -43,  5, 11.0, 6.52 },
    {  3, 19, 55.70, -43,  4, 10.9, 4.27 },
    { 14, 20,  9.70, -43,  3, 32.0, 5.56 },
    { 16, 53, 42.50, -43,  3,  2.9, 5.96 },
    { 20,  0, 26.50, -43,  2, 35.9, 6.14 },
    { 21,  2, 12.60, -43,  0,  6.8, 6.64 },
    { 17, 37, 19.20, -42, 59, 52.1, 1.87 },
    {  8, 37, 38.71, -42, 59, 21.1, 4.14 },
    {  8, 11, 25.90, -42, 59, 13.9, 4.75 },
    {  8,  3, 29.50, -42, 56, 55.0, 6.29 },
    { 21, 34, 16.99, -42, 55, 30.0, 6.32 },
    {  5, 53, 22.90, -42, 55, 17.0, 6.55 },
    {  4,  7, 25.10, -42, 55,   .8, 6.59 },
    { 12, 55, 19.39, -42, 54, 56.9, 5.47 },
    { 16, 15, 24.00, -42, 53, 58.9, 6.14 },
    {  2, 39, 48.00, -42, 53, 30.1, 4.75 },
    {  7, 51, 40.30, -42, 53, 17.9, 6.04 },
    { 17, 38,  8.50, -42, 52, 50.2, 6.10 },
    { 15,  8, 39.10, -42, 52,  4.1, 5.85 },
    { 23,  9, 57.29, -42, 51, 38.2, 5.81 },
    { 16, 36, 22.51, -42, 51, 32.0, 5.47 },
    {  5, 59,  8.81, -42, 48, 55.1, 3.96 },
    { 20, 12, 23.90, -42, 46, 50.2, 6.22 },
    {  8, 24, 57.19, -42, 46,  9.8, 5.98 },
    { 10, 38, 50.30, -42, 45, 13.0, 6.11 },
    { 10, 26,  9.50, -42, 44, 20.0, 6.13 },
    { 17, 44, 42.00, -42, 43, 44.0, 5.87 },
    { 18, 56, 16.90, -42, 42, 38.2, 5.36 },
    { 13, 12, 50.90, -42, 41, 58.9, 6.22 },
    {  0, 44, 57.10, -42, 40, 36.1, 5.94 },
    { 11, 28, 35.11, -42, 40, 27.1, 5.08 },
    { 16, 19, 17.69, -42, 40, 26.0, 5.45 },
    { 11, 24, 22.10, -42, 40,  9.1, 6.12 },
    {  8, 44, 24.00, -42, 38, 57.1, 4.07 },
    {  8,  9, 47.71, -42, 38, 26.2, 6.26 },
    { 11,  7, 16.61, -42, 38, 19.0, 5.15 },
    {  3, 29, 55.01, -42, 38,  3.1, 5.78 },
    { 23, 35,  4.61, -42, 36, 54.0, 4.71 },
    { 15, 38,  3.19, -42, 34,  3.0, 4.33 },
    { 21, 27,  1.61, -42, 32, 52.1, 5.51 },
    { 12, 25,  8.50, -42, 30, 51.8, 6.11 },
    {  8, 51, 27.91, -42, 30, 15.8, 6.55 },
    {  6, 52, 39.70, -42, 30, 15.8, 6.52 },
    {  1, 54, 22.01, -42, 29, 48.8, 5.11 },
    { 16, 54, 26.90, -42, 28, 44.0, 5.88 },
    { 13, 49, 37.01, -42, 28, 26.0, 3.04 },
    { 10, 25, 17.21, -42, 28,  5.2, 6.18 },
    {  8, 48,  8.81, -42, 27, 50.0, 6.43 },
    { 12,  3, 39.60, -42, 26,  3.1, 5.15 },
    { 20, 23, 53.21, -42, 25, 22.1, 5.64 },
    {  7, 56, 57.89, -42, 24, 22.0, 6.09 },
    {  6, 54, 26.71, -42, 21, 56.2, 6.32 },
    { 16, 53, 59.69, -42, 21, 43.9, 4.73 },
    { 16, 54, 34.99, -42, 21, 41.0, 3.62 },
    {  7,  4,  2.81, -42, 20, 13.9, 5.20 },
    { 14, 26, 13.39, -42, 19,  9.1, 6.32 },
    { 18, 33, 30.19, -42, 18, 45.0, 4.64 },
    {  0, 26, 16.99, -42, 18, 22.0, 2.39 },
    {  6,  6, 40.99, -42, 17, 55.0, 6.12 },
    {  4, 14,   .10, -42, 17, 39.8, 3.86 },
    { 18, 18, 40.01, -42, 17, 17.9, 6.30 },
    {  9, 13, 18.60, -42, 16, 25.0, 6.29 },
    { 10, 55,  1.01, -42, 15,  4.0, 6.11 },
    { 13, 11,  8.81, -42, 13, 59.2, 5.79 },
    { 11,  0,  9.31, -42, 13, 32.9, 4.39 },
    {  9, 21, 50.90, -42, 11, 42.0, 5.58 },
    { 14, 35, 30.41, -42,  9, 28.1, 2.31 },
    {  6,  7, 52.90, -42,  9, 14.0, 5.50 },
    {  8, 25, 51.89, -42,  9, 11.9, 5.47 },
    { 10, 14, 44.21, -42,  7, 18.8, 3.85 },
    { 14, 59,  9.70, -42,  6, 15.1, 3.13 },
    { 13, 58, 16.30, -42,  6,  2.9, 3.83 },
    { 14, 34,  7.99, -42,  5, 58.9, 6.60 },
    { 19,  3,  6.89, -42,  5, 43.1, 4.75 },
    {  8, 50, 21.00, -42,  5, 24.0, 6.00 },
    { 13, 43, 40.01, -42,  4,  3.0, 5.98 },
    { 20, 22, 27.50, -42,  2, 58.9, 5.59 },
    {  1, 59, 38.81, -42,  1, 50.2, 5.57 },
    { 19, 22,  9.60, -42,  0, 58.0, 6.34 },
    { 17, 52, 52.70, -41, 59, 48.1, 6.20 },
    { 16, 53, 58.80, -41, 59, 40.9, 6.32 },
    {  4, 10, 50.59, -41, 59, 37.0, 4.93 },
    {  4, 28,  9.41, -41, 57, 36.0, 6.44 },
    { 10, 23, 40.39, -41, 57, 11.9, 6.27 },
    { 18, 31,  3.00, -41, 54, 49.0, 6.04 },
    { 12, 15, 30.50, -41, 54, 47.2, 6.26 },
    { 19,  2,  8.71, -41, 54, 36.0, 6.23 },
    { 19,  9, 57.79, -41, 53, 33.0, 5.88 },
    { 19, 55, 15.70, -41, 52,  5.9, 4.13 },
    {  9,  1, 20.81, -41, 51, 51.8, 5.55 },
    {  4, 40, 33.70, -41, 51, 50.0, 4.45 },
    { 16, 52, 19.10, -41, 51, 15.8, 6.49 },
    { 16, 54, 11.81, -41, 51,  1.1, 6.45 },
    {  2, 19, 24.70, -41, 50, 53.9, 6.37 },
    { 14, 14, 42.60, -41, 50, 15.0, 5.61 },
    { 16, 54, 19.61, -41, 49, 12.0, 6.59 },
    { 15, 44, 22.61, -41, 49,  9.8, 5.94 },
    { 16, 31, 41.71, -41, 49,   .8, 5.33 },
    { 16, 54,  1.80, -41, 48, 23.0, 5.45 },
    {  1, 47, 16.80, -41, 45, 36.0, 6.18 },
    {  5,  3, 54.00, -41, 44, 42.0, 6.31 },
    { 15, 59, 30.31, -41, 44, 39.8, 4.99 },
    {  8, 47, 40.49, -41, 44, 13.9, 6.36 },
    { 12, 29, 57.91, -41, 44, 10.0, 6.02 },
    { 17, 57, 47.71, -41, 42, 58.0, 4.88 },
    { 10, 10, 37.90, -41, 42, 54.0, 5.98 },
    { 13, 49, 30.31, -41, 41, 16.1, 3.41 },
    { 10, 18, 28.20, -41, 40,  5.9, 5.96 },
    { 10, 22, 19.61, -41, 39,   .0, 4.83 },
    {  3, 26, 11.71, -41, 38, 12.8, 6.32 },
    { 22, 16, 26.59, -41, 37, 39.0, 5.10 },
    { 13,  6, 35.11, -41, 35, 19.0, 5.59 },
    {  6, 36, 51.31, -41, 33, 24.8, 6.34 },
    { 14, 35, 31.51, -41, 31,  1.9, 5.87 },
    { 13, 26, 56.09, -41, 29, 53.2, 5.69 },
    {  1, 24, 40.80, -41, 29, 33.0, 5.42 },
    { 15, 16,  4.01, -41, 29, 28.0, 5.16 },
    {  1,  7, 47.90, -41, 29, 12.8, 5.21 },
    { 23,  3, 59.50, -41, 28, 41.9, 5.79 },
    {  7, 14, 57.10, -41, 25, 32.9, 5.94 },
    { 14,  3, 27.50, -41, 25, 23.9, 6.11 },
    { 22, 43, 30.00, -41, 24, 51.8, 4.85 },
    { 13, 42, 55.01, -41, 24,  4.0, 5.98 },
    { 21,  6, 25.51, -41, 23, 10.0, 5.53 },
    { 12, 24, 44.69, -41, 23,  3.1, 6.25 },
    { 22, 14, 38.59, -41, 22, 54.1, 6.23 },
    {  3, 30, 13.61, -41, 22, 12.0, 6.12 },
    { 18, 11,  5.59, -41, 21, 33.1, 5.86 },
    { 22, 15, 36.89, -41, 20, 48.1, 4.79 },
    { 18, 13, 12.60, -41, 20, 10.0, 5.47 },
    {  4, 50, 16.20, -41, 19, 14.9, 6.07 },
    {  8,  2, 44.81, -41, 18, 36.0, 5.52 },
    {  9,  0,  5.40, -41, 15, 14.0, 4.45 },
    { 12,  8, 54.50, -41, 13, 53.0, 5.48 },
    { 16, 51, 33.70, -41, 13, 50.2, 5.22 },
    { 13,  4, 48.10, -41, 11, 48.1, 6.26 },
    { 23, 16, 49.80, -41, 11, 39.8, 6.47 },
    { 14,  6,  2.81, -41, 10, 46.9, 4.36 },
    { 21, 32,  5.90, -41, 10, 45.1, 5.29 },
    { 17, 33,  7.39, -41, 10, 25.0, 5.84 },
    { 15, 35,  8.50, -41, 10,   .8, 2.78 },
    {  2, 14, 31.99, -41, 10,   .1, 5.91 },
    { 16, 54, 58.39, -41,  9,  4.0, 5.77 },
    {  8, 46, 23.81, -41,  7, 32.2, 6.21 },
    { 16, 11, 17.69, -41,  7, 10.9, 5.86 },
    { 16, 43, 45.50, -41,  7,  8.0, 6.20 },
    { 16, 43, 53.90, -41,  6, 47.2, 6.12 },
    { 23, 14, 58.61, -41,  6, 20.2, 5.77 },
    {  6, 28, 42.29, -41,  4, 27.8, 6.32 },
    { 15,  5, 19.10, -41,  4,  1.9, 5.15 },
    {  4, 43, 44.21, -41,  3, 52.9, 6.25 },
    { 15, 18,  9.41, -41,  3, 38.9, 6.28 },
    { 12, 35, 45.50, -41,  1, 18.8, 5.13 },
    { 21, 24, 24.79, -41,  0, 24.1, 5.77 },
    { 11, 58, 20.30, -40, 56, 49.9, 6.79 },
    {  5, 27,  5.30, -40, 56, 37.0, 5.87 },
    {  0, 30, 27.79, -40, 56, 21.8, 6.19 },
    {  7, 43, 41.90, -40, 56,  2.0, 5.17 },
    {  6, 30, 59.81, -40, 54, 59.0, 6.20 },
    {  7,  7,  7.10, -40, 53, 35.9, 5.79 },
    { 15,  4, 42.91, -40, 51, 41.0, 6.41 },
    { 14, 30, 56.50, -40, 50, 42.0, 6.39 },
    {  2, 24, 33.79, -40, 50, 26.2, 6.18 },
    { 16, 44, 42.60, -40, 50, 22.9, 5.71 },
    {  9, 56,  5.40, -40, 49, 28.9, 6.41 },
    { 23, 18,  9.91, -40, 49, 27.8, 5.53 },
    { 16, 56, 36.00, -40, 49, 25.0, 6.15 },
    { 20,  1, 26.40, -40, 48, 51.1, 6.29 },
    { 21, 20, 45.60, -40, 48, 34.9, 4.82 },
    { 20, 25, 47.90, -40, 47, 47.0, 6.09 },
    { 15, 18, 56.40, -40, 47, 17.9, 5.59 },
    { 17, 51, 32.81, -40, 46, 21.0, 5.96 },
    { 15, 21, 35.30, -40, 44, 58.9, 6.20 },
    {  7, 56, 24.29, -40, 44, 11.0, 6.78 },
    {  5, 38, 43.61, -40, 42, 27.0, 5.82 },
    {  3, 44,  6.19, -40, 39, 37.1, 6.45 },
    { 15, 59, 58.01, -40, 39, 10.1, 6.49 },
    {  5, 47, 58.10, -40, 39,  9.0, 6.61 },
    {  7, 48,  8.50, -40, 39,  7.9, 6.14 },
    {  9, 32, 19.30, -40, 38, 57.8, 5.35 },
    { 15, 21, 22.30, -40, 38, 51.0, 3.22 },
    { 19, 23, 53.21, -40, 36, 58.0, 3.97 },
    { 23, 10,  9.79, -40, 35, 30.1, 5.83 },
    { 22, 36, 58.80, -40, 35, 28.0, 5.86 },
    { 11, 33, 37.30, -40, 35, 12.8, 5.39 },
    { 15,  8, 12.10, -40, 35,  2.0, 5.79 },
    { 22, 36, 29.30, -40, 34, 58.1, 6.28 },
    {  7, 52, 13.01, -40, 34, 32.9, 3.73 },
    {  2, 43, 20.30, -40, 31, 39.0, 6.36 },
    { 21, 15, 14.69, -40, 30, 23.0, 6.21 },
    {  9, 26, 28.49, -40, 30,  6.8, 6.20 },
    { 11, 46, 31.10, -40, 30,  2.2, 4.91 },
    {  7, 12, 15.79, -40, 29, 56.0, 5.31 },
    { 19,  8, 20.90, -40, 29, 48.1, 4.59 },
    {  9, 30, 42.00, -40, 28,   .1, 3.60 },
    {  8, 53, 50.69, -40, 26, 51.0, 6.47 },
    { 11, 32, 48.10, -40, 26, 11.0, 5.64 },
    { 16,  0, 53.71, -40, 26,  7.1, 6.21 },
    { 18, 47, 44.59, -40, 24, 22.0, 5.24 },
    {  4, 13, 35.71, -40, 21, 28.1, 6.37 },
    {  3, 54, 23.21, -40, 21, 25.9, 5.71 },
    {  6, 10, 10.30, -40, 21, 13.0, 5.58 },
    {  6, 41, 14.09, -40, 20, 58.9, 6.12 },
    {  8, 14,  2.90, -40, 20, 53.2, 4.44 },
    { 10, 13, 45.91, -40, 20, 44.9, 5.90 },
    {  8, 49, 39.19, -40, 19, 14.2, 5.48 },
    { 10, 13, 56.59, -40, 18, 38.2, 6.35 },
    { 17, 56, 55.80, -40, 18, 20.2, 6.43 },
    {  2, 58, 15.70, -40, 18, 16.9, 3.24 },
    {  2, 58, 16.30, -40, 18, 15.8, 4.35 },
    { 23, 54, 38.59, -40, 18,   .0, 6.03 },
    {  6, 24, 44.50, -40, 17,  3.1, 6.31 },
    {  3, 37,  5.71, -40, 16, 28.9, 4.58 },
    { 21, 12, 13.61, -40, 16,  9.8, 5.83 },
    {  8, 40, 19.30, -40, 15, 51.1, 5.20 },
    { 14,  1, 19.01, -40, 13, 19.9, 6.13 },
    { 14, 36, 44.21, -40, 12, 42.1, 5.74 },
    { 15, 47, 25.39, -40, 11, 39.1, 6.42 },
    { 23, 46,  1.20, -40, 10, 57.0, 6.31 },
    { 12, 53, 26.21, -40, 10, 44.0, 4.27 },
    { 12, 43, 26.30, -40, 10, 40.1, 6.44 },
    { 13, 27, 14.69, -40,  9, 47.2, 6.40 },
    {  8, 37, 19.90, -40,  8, 51.0, 6.55 },
    { 17, 47, 35.09, -40,  7, 36.8, 3.03 },
    { 17, 50, 11.21, -40,  5, 26.2, 4.81 },
    { 15, 34,  1.61, -40,  3, 58.0, 5.82 },
    {  7, 46, 33.41, -40,  3, 34.9, 6.57 },
    {  7, 33, 13.51, -40,  3, 32.0, 6.26 },
    { 13, 39, 48.60, -40,  3,  6.8, 5.60 },
    { 19, 34,  8.50, -40,  2,  4.9, 5.89 },
    {  8,  3, 35.09, -40,  0, 11.9, 2.25 },
    {  7, 38, 24.19, -39, 59, 29.0, 6.59 },
    { 12, 39, 52.51, -39, 59, 15.0, 4.64 },
    { 10,  4, 23.40, -39, 58, 32.9, 6.43 },
    {  8, 35, 12.60, -39, 58, 12.0, 6.47 },
    {  5, 54, 52.51, -39, 57, 29.2, 5.57 },
    {  2, 50, 47.90, -39, 55, 54.1, 6.36 },
    {  0, 28, 26.40, -39, 54, 54.0, 5.43 },
    { 14, 58, 36.79, -39, 54, 24.1, 6.15 },
    {  7, 33, 58.51, -39, 54, 20.9, 6.76 },
    { 13, 50, 19.39, -39, 54,  4.0, 6.44 },
    { 18, 33,   .91, -39, 53, 31.9, 6.22 },
    { 19, 51, 50.59, -39, 52, 27.8, 5.33 },
    { 14, 26, 49.90, -39, 52, 26.0, 6.35 },
    { 12, 36,  1.20, -39, 52, 12.0, 5.80 },
    { 15, 56,  6.50, -39, 51, 51.1, 6.03 },
    {  2, 40, 40.01, -39, 51, 20.2, 4.11 },
    { 19,  9, 39.70, -39, 49, 41.2, 6.46 },
    { 18, 57, 34.70, -39, 49, 23.9, 6.31 },
    { 20, 53, 40.20, -39, 48, 36.0, 5.35 },
    {  9, 22, 36.70, -39, 46, 28.9, 6.54 },
    { 17, 14, 27.70, -39, 46,   .8, 6.60 },
    { 13, 26,  7.80, -39, 45, 19.1, 5.09 },
    { 13, 39, 40.80, -39, 44, 53.2, 6.27 },
    {  5,  1, 34.51, -39, 43,  5.2, 6.03 },
    { 15, 24, 44.90, -39, 42, 37.1, 5.37 },
    { 18, 32, 21.41, -39, 42, 14.0, 5.16 },
    { 11, 55, 54.70, -39, 41, 21.1, 6.13 },
    { 18, 44, 57.19, -39, 41, 11.0, 5.43 },
    { 12, 51, 56.81, -39, 40, 50.9, 5.98 },
    {  5, 23, 24.00, -39, 40, 43.0, 5.71 },
    {  7,  8, 51.10, -39, 39, 20.9, 4.83 },
    {  4, 54, 54.79, -39, 37, 43.0, 6.10 },
    {  8, 21, 24.19, -39, 37, 14.9, 6.16 },
    {  8, 11, 21.50, -39, 37,  7.0, 4.45 },
    {  9, 38, 40.70, -39, 36, 51.1, 6.70 },
    { 14, 36, 24.19, -39, 35, 49.9, 6.13 },
    {  9, 44, 15.79, -39, 34, 16.0, 6.82 },
    { 10, 35, 12.91, -39, 33, 46.1, 5.38 },
    { 20, 42, 52.99, -39, 33, 31.0, 6.29 },
    { 22,  6,  6.89, -39, 32, 35.9, 4.46 },
    {  6, 46,  3.29, -39, 32, 24.0, 6.62 },
    { 18, 59, 11.11, -39, 32,  4.9, 6.49 },
    { 14, 23,  2.21, -39, 30, 43.9, 4.42 },
    { 17, 12, 16.20, -39, 30, 24.8, 5.67 },
    { 19, 39, 55.70, -39, 25, 59.9, 6.61 },
    { 16, 20, 32.59, -39, 25, 50.9, 6.12 },
    {  9, 24, 16.30, -39, 25, 32.9, 6.06 },
    { 21, 13,  3.10, -39, 25, 31.1, 5.26 },
    { 14, 56, 35.81, -39, 24, 58.0, 6.36 },
    { 13, 31,  2.69, -39, 24, 27.0, 3.88 },
    {  5, 43, 30.19, -39, 24, 24.8, 6.25 },
    {  9,  2,  6.41, -39, 24,  9.0, 6.27 },
    {  9, 16, 57.19, -39, 24,  5.0, 5.33 },
    { 16, 46, 47.81, -39, 22, 37.9, 5.48 },
    {  4, 45, 55.39, -39, 21, 24.1, 6.05 },
    { 15, 34, 20.90, -39, 20, 57.8, 6.36 },
    { 19, 10,  1.70, -39, 20, 26.9, 4.11 },
    {  7, 47,  5.81, -39, 19, 53.0, 6.31 },
    { 12, 23, 36.89, -39, 18, 11.2, 6.40 },
    {  7, 59, 28.39, -39, 17, 49.9, 5.24 },
    {  6, 16, 35.59, -39, 15, 51.8, 6.00 },
    {  9, 11, 40.99, -39, 15, 32.0, 6.00 },
    {  7, 18, 33.60, -39, 12, 37.1, 5.25 },
    { 20, 46, 20.09, -39, 11, 57.1, 5.50 },
    {  6, 43, 23.30, -39, 11, 35.9, 6.30 },
    { 16, 24,  1.30, -39, 11, 35.2, 5.40 },
    { 15, 38, 32.69, -39,  9, 38.9, 6.57 },
    { 22, 51,  2.21, -39,  9, 24.8, 5.42 },
    {  8, 49, 52.39, -39,  8, 30.1, 6.39 },
    { 17, 57, 57.79, -39,  8, 12.8, 6.29 },
    { 22, 28, 39.19, -39,  7, 54.8, 5.47 },
    {  9, 33,  7.80, -39,  7, 44.0, 6.43 },
    { 15, 38, 42.31, -39,  7, 41.2, 6.04 },
    { 16,  8, 34.20, -39,  6, 19.1, 7.05 },
    { 16,  8, 34.39, -39,  5, 35.2, 6.65 },
    {  8, 31, 24.60, -39,  3, 51.1, 6.31 },
    {  8, 26, 18.19, -39,  3, 37.1, 7.25 },
    {  8, 26, 17.59, -39,  3, 33.8, 6.53 },
    { 12, 28, 22.51, -39,  2, 29.0, 5.44 },
    { 17, 42, 29.30, -39,  1, 48.0, 2.41 },
    { 19, 11,  1.80, -39,  0, 18.0, 6.36 },
    { 18, 28, 27.10, -38, 59, 44.2, 5.64 },
    { 12, 13, 25.30, -38, 55, 45.1, 5.76 },
    {  1,  1, 18.31, -38, 55,   .1, 5.59 },
    { 12, 23, 44.90, -38, 54, 40.0, 5.79 },
    { 23,  6, 53.59, -38, 53, 31.9, 5.61 },
    { 14, 31, 10.80, -38, 52, 10.9, 5.97 },
    {  7, 43,  7.01, -38, 51, 51.1, 6.89 },
    {  7, 52, 38.69, -38, 51, 47.2, 4.49 },
    { 18, 29, 16.80, -38, 51,  4.0, 6.63 },
    {  8, 33, 38.30, -38, 50, 56.0, 5.96 },
    { 17, 12, 16.51, -38, 49, 19.9, 6.30 },
    {  7, 29,  5.71, -38, 48, 43.9, 5.43 },
    { 14, 38, 19.61, -38, 47, 39.1, 6.02 },
    { 15, 10,  7.49, -38, 47, 33.0, 5.98 },
    {  7, 38, 32.59, -38, 46, 52.0, 6.19 },
    { 15, 25, 20.21, -38, 44,  1.0, 4.60 },
    { 18, 33, 23.11, -38, 43, 34.0, 5.65 },
    {  8, 52, 48.00, -38, 43, 27.1, 5.82 },
    { 18, 33, 23.30, -38, 43, 13.1, 6.32 },
    { 18, 22, 18.60, -38, 39, 24.8, 5.10 },
    { 17, 36, 32.81, -38, 38,  7.1, 4.29 },
    { 21,  2, 58.01, -38, 37, 54.1, 5.30 },
    {  6, 33, 10.30, -38, 37, 31.1, 6.44 },
    { 15, 32,  4.39, -38, 37, 23.2, 6.25 },
    {  9, 13, 25.90, -38, 36, 59.0, 6.31 },
    { 16,  3, 24.19, -38, 36,  9.0, 4.89 },
    {  1, 53, 23.21, -38, 35, 40.9, 6.10 },
    { 17, 15, 35.90, -38, 35, 38.0, 5.96 },
    {  9, 15, 36.70, -38, 34, 12.0, 4.94 },
    { 21, 44, 29.50, -38, 33,  9.0, 6.30 },
    {  7, 41, 15.79, -38, 32,  1.0, 5.42 },
    { 21,  2, 27.19, -38, 31, 50.2, 5.94 },
    {  7, 41, 58.01, -38, 31, 44.0, 6.54 },
    {  5, 52, 47.71, -38, 31, 32.9, 6.70 },
    { 17, 29, 25.70, -38, 31,   .1, 6.39 },
    {  5, 32, 51.31, -38, 30, 47.2, 5.48 },
    {  7, 47, 25.01, -38, 30, 40.0, 5.08 },
    {  0, 42, 42.91, -38, 27, 47.9, 6.06 },
    {  2, 53, 34.39, -38, 26, 12.8, 5.92 },
    {  0, 44, 12.10, -38, 25, 18.1, 5.90 },
    {  9, 29, 16.30, -38, 24, 14.0, 6.19 },
    {  1, 49, 48.79, -38, 24, 14.0, 6.37 },
    { 13, 32,  5.30, -38, 23, 57.1, 6.16 },
    {  6, 42, 16.39, -38, 23, 55.0, 6.29 },
    { 16,  0,  7.30, -38, 23, 48.8, 3.41 },
    { 21, 59, 17.90, -38, 23, 43.1, 5.50 },
    {  2, 42,  6.60, -38, 23,  2.0, 6.01 },
    {  7,  6,  2.30, -38, 22, 58.1, 6.11 },
    {  8, 33, 19.90, -38, 22, 16.0, 6.49 },
    { 18, 43, 46.90, -38, 19, 25.0, 5.13 },
    {  7, 16, 31.80, -38, 19,  8.0, 5.80 },
    {  7, 39, 27.41, -38, 18, 29.9, 4.84 },
    { 14, 47,  5.11, -38, 17, 26.9, 5.94 },
    {  8, 23, 17.21, -38, 17,  8.9, 6.32 },
    {  7, 39, 47.81, -38, 15, 38.9, 5.76 },
    { 19,  3, 17.71, -38, 15, 11.9, 5.74 },
    { 22, 47, 47.11, -38, 13, 18.8, 6.71 },
    { 15, 21, 30.10, -38, 13,  9.1, 6.48 },
    {  7, 43, 42.89, -38, 12,  6.8, 6.40 },
    {  2, 57, 32.69, -38, 11, 28.0, 6.41 },
    { 15, 25,  6.60, -38, 10,  9.8, 7.03 },
    {  6, 39, 56.90, -38,  9, 32.0, 6.58 },
    { 16, 43, 47.59, -38,  9, 24.1, 6.05 },
    { 17,  3, 50.81, -38,  9,  7.9, 5.91 },
    {  6, 37,  1.90, -38,  8, 48.1, 6.04 },
    {  7, 39, 43.80, -38,  8, 21.8, 5.73 },
    {  1, 41, 27.31, -38,  7, 59.2, 6.17 },
    { 17, 47,  7.30, -38,  6, 42.1, 6.43 },
    { 20, 34, 55.51, -38,  5, 22.9, 6.44 },
    { 17, 37, 26.81, -38,  3, 56.2, 6.26 },
    { 19, 57, 41.30, -38,  3, 29.9, 6.55 },
    { 15,  1, 13.01, -38,  3, 29.9, 5.89 },
    { 16, 51, 52.20, -38,  2, 51.0, 3.08 },
    { 16, 52, 20.11, -38,  1,  3.0, 3.57 },
    { 11, 17, 11.81, -38,  0, 51.8, 6.27 },
    {  7, 37, 45.19, -38,  0, 38.2, 6.38 },
    { 10, 23, 29.30, -38,  0, 36.0, 5.33 },
    {  2, 38, 24.79, -37, 59, 26.2, 6.49 },
    {  7, 45, 15.31, -37, 58,  7.0, 3.61 },
    {  7, 44, 34.20, -37, 56, 35.2, 5.88 },
    { 20,  3, 33.50, -37, 56, 26.9, 4.77 },
    {  7, 46, 10.39, -37, 56,  2.0, 5.88 },
    {  6, 47, 21.41, -37, 55, 46.9, 5.26 },
    {  8, 12, 51.50, -37, 55, 27.8, 6.43 },
    { 15, 47, 28.99, -37, 54, 59.0, 6.01 },
    { 20, 51,   .70, -37, 54, 47.9, 5.52 },
    { 19,  9, 28.30, -37, 54, 15.8, 4.11 },
    {  6, 27,  7.49, -37, 53, 44.2, 6.48 },
    {  7, 45,  4.61, -37, 53, 16.1, 6.54 },
    { 14, 20, 33.41, -37, 53,  7.1, 4.05 },
    { 14, 59, 13.90, -37, 52, 53.0, 6.47 },
    { 12, 10, 33.79, -37, 52, 13.1, 6.06 },
    { 16,  4, 36.70, -37, 51, 47.2, 5.90 },
    {  1, 12, 45.41, -37, 51, 23.0, 5.92 },
    { 21, 26, 22.90, -37, 49, 45.8, 5.63 },
    { 23, 32, 58.30, -37, 49,  5.9, 4.37 },
    {  7, 28, 22.80, -37, 48, 37.1, 6.58 },
    { 19,  6, 52.51, -37, 48, 37.1, 6.16 },
    { 17, 22, 39.41, -37, 48, 18.0, 6.41 },
    { 14, 52, 51.10, -37, 48, 11.9, 5.03 },
    { 13, 12,  3.19, -37, 48, 11.2, 4.85 },
    { 14, 41, 57.60, -37, 47, 37.0, 4.00 },
    {  6, 46, 12.10, -37, 46, 32.2, 6.21 },
    {  9, 23, 44.81, -37, 45, 25.9, 6.48 },
    { 11, 54, 25.80, -37, 44, 56.0, 6.46 },
    { 11, 25, 33.10, -37, 44, 52.1, 5.89 },
    { 21, 57,  2.21, -37, 44, 48.8, 6.18 },
    {  6, 17,  1.20, -37, 44, 15.0, 5.53 },
    { 20,  0, 15.91, -37, 42,  7.9, 5.95 },
    {  6, 32, 21.31, -37, 41, 48.1, 5.24 },
    {  8,  8, 37.61, -37, 40, 53.0, 6.37 },
    {  5, 52, 33.19, -37, 37, 52.0, 5.63 },
    {  3, 48, 35.40, -37, 37, 19.9, 5.40 },
    { 16, 58, 52.39, -37, 37, 16.0, 6.09 },
    {  3, 48, 35.90, -37, 37, 14.2, 4.73 },
    {  8, 34, 29.30, -37, 36, 41.0, 6.30 },
    {  9, 14, 57.19, -37, 36,  9.0, 5.86 },
    { 19, 12,  9.79, -37, 34, 58.1, 6.57 },
    {  9, 20, 29.59, -37, 34, 53.0, 6.05 },
    {  7, 39, 58.01, -37, 34, 45.8, 6.00 },
    {  2, 23,  6.50, -37, 34, 35.0, 6.53 },
    { 16, 24, 31.70, -37, 33, 56.9, 5.42 },
    { 19, 43, 37.61, -37, 32, 20.0, 6.16 },
    { 16, 50, 59.81, -37, 30, 51.8, 6.11 },
    { 15, 58, 30.70, -37, 30, 11.2, 6.31 },
    { 18, 20, 55.30, -37, 29, 15.0, 6.45 },
    { 17, 35, 43.01, -37, 26, 24.0, 6.48 },
    { 15, 42, 38.30, -37, 25, 30.0, 5.24 },
    {  9, 15, 45.10, -37, 24, 47.9, 4.62 },
    { 20, 26, 52.99, -37, 24, 11.2, 6.25 },
    {  5, 11, 35.90, -37, 23, 43.1, 6.57 },
    {  8, 18, 12.60, -37, 22, 27.1, 6.70 },
    { 21, 53, 55.70, -37, 21, 54.0, 3.01 },
    { 18, 56, 40.51, -37, 20, 35.9, 5.38 },
    {  7, 30, 42.41, -37, 20, 22.9, 6.65 },
    {  5, 23, 39.00, -37, 20, 12.1, 6.82 },
    { 10,  8,  1.70, -37, 20,  1.0, 6.36 },
    {  3, 42, 50.11, -37, 18, 49.0, 4.59 },
    { 17, 30, 45.79, -37, 17, 44.9, 2.69 },
    {  8, 11,  1.61, -37, 17, 31.9, 6.44 },
    {  7, 24, 47.30, -37, 17, 26.9, 6.84 },
    {  7, 24, 47.21, -37, 17, 24.0, 6.97 },
    {  8,  1, 37.39, -37, 17,  1.0, 5.95 },
    { 21, 56, 22.80, -37, 15, 13.0, 5.46 },
    {  6, 17,  9.50, -37, 15, 11.2, 5.87 },
    {  6,  7, 31.61, -37, 15, 11.2, 5.02 },
    { 11, 36, 40.80, -37, 14, 16.1, 6.31 },
    {  5, 28, 15.31, -37, 13, 50.2, 5.57 },
    { 17,  6, 20.30, -37, 13, 39.0, 5.98 },
    { 17, 22, 54.91, -37, 13, 14.2, 5.93 },
    { 16, 39,  5.21, -37, 13,  3.0, 5.91 },
    { 11, 43, 27.19, -37, 11, 25.1, 5.98 },
    {  9, 49, 28.10, -37, 11, 11.0, 5.97 },
    { 16, 28, 14.69, -37, 10, 45.8, 5.79 },
    {  1, 47, 47.81, -37,  9, 34.9, 6.32 },
    {  8, 44, 51.89, -37,  8, 49.9, 5.76 },
    {  4, 42,  3.50, -37,  8, 39.8, 5.05 },
    { 10, 56, 43.10, -37,  8, 16.1, 4.60 },
    {  5, 55, 29.90, -37,  7, 14.9, 4.97 },
    { 18, 58, 43.39, -37,  6, 27.0, 4.87 },
    { 17, 33, 36.50, -37,  6, 14.0, 1.63 },
    {  7, 17,  8.59, -37,  5, 51.0, 2.70 },
    { 15, 19, 31.61, -37,  5, 48.1, 6.20 },
    { 19,  6, 25.10, -37,  3, 47.9, 4.93 },
    { 19,  6, 25.10, -37,  3, 47.9, 4.99 },
    { 19,  1,  4.30, -37,  3, 42.8, 6.40 },
    { 19,  1,  3.19, -37,  3, 38.9, 6.69 },
    {  8,  2,  6.19, -37,  3,  2.2, 6.34 },
    { 17, 49, 51.50, -37,  2, 35.9, 3.21 },
    { 14, 19, 23.90, -37,  0, 13.0, 5.94 },
    {  6, 37, 13.80, -36, 59, 26.2, 5.71 },
    { 17, 42, 51.00, -36, 56, 44.9, 5.54 },
    {  6, 31, 34.99, -36, 56, 24.0, 6.34 },
    {  1, 32, 55.99, -36, 51, 55.1, 5.51 },
    { 15, 23,  9.41, -36, 51, 31.0, 4.54 },
    { 17, 58, 55.61, -36, 51, 29.9, 5.74 },
    {  1, 42,  3.00, -36, 49, 57.0, 5.72 },
    { 10, 18, 37.80, -36, 48, 16.9, 6.30 },
    { 16,  6, 35.50, -36, 48,  7.9, 4.23 },
    {  6, 35, 24.10, -36, 46, 48.0, 5.59 },
    { 17, 28, 56.11, -36, 46, 41.9, 6.02 },
    { 15, 27, 18.19, -36, 46,  4.1, 5.45 },
    { 18, 17, 37.61, -36, 45, 42.1, 3.11 },
    { 16,  7, 16.39, -36, 45, 20.2, 5.73 },
    {  7, 18, 38.21, -36, 44, 34.1, 5.11 },
    {  7, 18, 18.41, -36, 44,  3.1, 4.66 },
    {  8, 30, 29.59, -36, 43, 16.0, 6.69 },
    { 18, 44,  7.70, -36, 43,  7.0, 6.32 },
    { 13, 20, 35.81, -36, 42, 43.9, 2.75 },
    {  6, 24,  1.01, -36, 42, 28.1, 5.62 },
    { 18,  9, 22.39, -36, 40, 21.0, 6.58 },
    { 18, 22, 53.11, -36, 40,  9.8, 5.34 },
    {  8, 18, 33.29, -36, 39, 33.8, 4.45 },
    { 14, 48, 38.11, -36, 38,  4.9, 6.04 },
    {  8, 39, 22.10, -36, 36, 24.8, 6.13 },
    {  7, 16, 49.51, -36, 35, 34.1, 5.03 },
    {  8, 52, 38.59, -36, 32, 44.2, 6.42 },
    {  7, 12, 25.70, -36, 32, 39.8, 5.96 },
    { 11, 17, 43.01, -36, 32,  3.8, 6.68 },
    {  1, 38, 27.41, -36, 31, 41.9, 5.94 },
    { 10, 15, 20.90, -36, 31,  5.2, 6.19 },
    {  7, 38, 43.90, -36, 29, 48.8, 5.80 },
    {  8, 21, 21.00, -36, 29,  3.8, 5.20 },
    { 17, 55,  7.90, -36, 28, 32.9, 6.06 },
    { 20, 16, 23.71, -36, 27, 15.8, 6.39 },
    { 13, 51, 36.60, -36, 25, 59.9, 6.35 },
    {  2, 32, 14.81, -36, 25, 39.0, 6.30 },
    {  3, 50, 37.61, -36, 25, 31.1, 6.86 },
    { 21, 13, 18.89, -36, 25, 26.0, 5.96 },
    { 23,  2, 34.01, -36, 25, 14.9, 6.47 },
    { 22, 55, 14.90, -36, 23, 19.0, 6.40 },
    { 10,  5, 15.19, -36, 23,  2.0, 6.27 },
    { 18,  1, 48.31, -36, 22, 40.1, 6.30 },
    { 13, 15,  9.70, -36, 22, 16.0, 6.19 },
    { 14,  6, 40.99, -36, 22, 12.0, 2.06 },
    {  7, 53,  3.50, -36, 21, 50.0, 5.43 },
    { 12, 43, 58.70, -36, 20, 57.1, 6.39 },
    {  8, 13, 58.80, -36, 20, 28.0, 6.11 },
    {  7, 33, 51.00, -36, 20, 17.9, 5.54 },
    {  8, 13, 58.39, -36, 19, 21.0, 5.08 },
    {  9, 49, 51.29, -36, 16,  7.0, 6.37 },
    { 15,  6, 13.90, -36, 15, 51.1, 6.27 },
    { 15, 21, 48.41, -36, 15, 41.0, 3.56 },
    { 13, 46, 56.40, -36, 15,  6.8, 5.15 },
    { 18, 23, 28.90, -36, 14, 17.9, 5.55 },
    {  6, 33, 49.51, -36, 13, 55.9, 5.42 },
    {  6, 51, 42.29, -36, 13, 49.1, 5.96 },
    { 21, 15, 46.80, -36, 12, 38.9, 6.12 },
    {  3, 49, 27.31, -36, 12,  1.1, 4.17 },
    { 15, 57, 21.29, -36, 11,  6.0, 5.80 },
    { 19,  9, 36.41, -36,  9, 52.9, 6.56 },
    { 11, 23, 12.70, -36,  9, 52.9, 5.00 },
    {  7, 31, 25.80, -36,  9, 10.1, 6.68 },
    { 14, 41,  1.39, -36,  8,  6.0, 5.67 },
    { 20, 59, 59.69, -36,  7, 46.9, 6.11 },
    { 20, 46, 18.60, -36,  7, 13.1, 6.49 },
    {  3, 47, 49.61, -36,  6, 20.9, 6.21 },
    { 20, 11, 11.90, -36,  6,  4.0, 5.32 },
    {  9, 37, 28.30, -36,  5, 44.9, 5.98 },
    { 12, 17, 47.30, -36,  5, 38.0, 6.15 },
    { 15, 13,  7.39, -36,  5, 29.0, 6.10 },
    {  6, 35, 54.00, -36,  5, 20.0, 6.35 },
    { 11, 25, 29.40, -36,  3, 47.2, 5.22 },
    {  7, 44,  9.60, -36,  3, 46.1, 5.80 },
    {  7, 43, 12.00, -36,  3,  1.1, 5.60 },
    { 18,  6, 23.71, -36,  1, 10.9, 5.95 },
    { 18, 25, 21.70, -35, 59, 30.1, 6.15 },
    {  5, 14, 28.80, -35, 58, 37.9, 5.76 },
    {  7, 32, 22.30, -35, 57, 41.0, 6.30 },
    {  9, 29, 14.69, -35, 57,  5.0, 4.51 },
    {  3, 13,  1.49, -35, 56, 38.0, 6.27 },
    {  8, 42, 57.00, -35, 56, 35.9, 6.42 },
    { 17,  0, 36.89, -35, 56,  3.1, 5.97 },
    {  3, 25, 55.80, -35, 55, 14.9, 6.39 },
    { 17, 22, 37.99, -35, 54, 36.0, 6.47 },
    { 11, 47,  7.01, -35, 54, 24.8, 6.17 },
    {  8, 15, 58.90, -35, 54, 10.1, 6.16 },
    { 18,  4, 50.40, -35, 54,  5.0, 6.00 },
    {  8, 13, 29.59, -35, 53, 58.9, 4.78 },
    {  9, 58, 52.30, -35, 53, 28.0, 5.23 },
    {  7, 31, 42.79, -35, 53, 16.1, 6.61 },
    {  7, 54, 10.99, -35, 52, 39.0, 5.49 },
    { 13,  6, 54.31, -35, 51, 42.8, 6.54 },
    { 10,  9, 31.80, -35, 51, 24.1, 6.13 },
    {  3, 28, 11.50, -35, 51, 11.9, 6.50 },
    {  2, 50, 14.81, -35, 50, 37.0, 5.92 },
    {  7, 23, 58.30, -35, 50, 16.1, 6.31 },
    {  5, 13, 46.49, -35, 49, 32.2, 6.98 },
    {  9, 35, 11.81, -35, 49, 26.0, 6.49 },
    { 11,  4, 54.19, -35, 48, 16.9, 5.43 },
    {  5, 50, 57.60, -35, 46,  5.9, 3.12 },
    { 17, 16, 21.50, -35, 44, 57.8, 6.12 },
    { 10, 40, 51.60, -35, 44, 30.1, 6.37 },
    {  5,  8, 14.81, -35, 43,  5.9, 6.52 },
    {  9, 31, 32.90, -35, 42, 54.0, 5.87 },
    {  5,  4, 26.09, -35, 42, 19.1, 6.34 },
    { 13, 48, 55.10, -35, 42, 14.0, 6.53 },
    { 12,  5, 56.71, -35, 41, 38.0, 6.23 },
    {  3, 27, 33.41, -35, 40, 53.0, 5.71 },
    {  2, 50, 40.39, -35, 40, 34.0, 5.47 },
    {  5, 47, 18.60, -35, 40, 28.9, 6.32 },
    { 20, 20, 51.89, -35, 40, 25.0, 6.46 },
    { 13, 53, 32.81, -35, 39, 51.1, 5.54 },
    {  1,  6, 26.50, -35, 39, 38.9, 6.61 },
    {  4, 30, 40.30, -35, 39, 13.0, 5.96 },
    { 18, 44, 19.39, -35, 38, 30.8, 4.87 },
    { 17, 52, 57.89, -35, 37, 27.1, 6.03 },
    { 20, 28, 46.70, -35, 35, 44.9, 6.10 },
    {  2, 47, 33.70, -35, 33,  2.9, 6.51 },
    {  4, 23,  7.70, -35, 32, 42.0, 6.39 },
    { 23, 28,   .70, -35, 32, 39.8, 6.32 },
    { 22, 58, 34.99, -35, 31, 23.2, 6.13 },
    {  6,  5, 27.10, -35, 30, 49.0, 5.80 },
    {  6, 57, 17.59, -35, 30, 27.0, 6.23 },
    {  9, 42, 41.40, -35, 30,  6.1, 6.41 },
    {  8, 14, 13.20, -35, 29, 26.2, 5.78 },
    {  5,  4, 24.41, -35, 28, 59.9, 4.55 },
    {  5, 31, 12.70, -35, 28, 14.2, 3.87 },
    {  8,  9, 10.20, -35, 27, 18.0, 6.20 },
    {  8, 18, 17.40, -35, 27,  6.1, 5.58 },
    { 17,  6, 28.39, -35, 27,  4.0, 6.13 },
    { 19, 19, 40.01, -35, 25, 17.0, 5.59 },
    { 12, 23, 35.40, -35, 24, 46.1, 5.32 },
    {  6, 56, 45.70, -35, 20, 30.1, 6.29 },
    { 11, 27, 58.49, -35, 19, 43.0, 6.45 },
    { 13, 53, 52.20, -35, 18, 51.8, 6.19 },
    {  8, 40,  6.19, -35, 18, 29.9, 3.97 },
    {  5, 57, 32.21, -35, 16, 59.9, 4.36 },
    {  7, 37, 44.81, -35, 16, 37.9, 6.60 },
    { 19, 59, 44.21, -35, 16, 35.0, 4.37 },
    {  4, 10, 45.79, -35, 16, 26.0, 6.44 },
    {  6, 31, 13.01, -35, 15, 33.1, 5.84 },
    { 16, 36, 22.51, -35, 15, 20.2, 4.16 },
    {  7, 49, 14.69, -35, 14, 35.9, 5.93 },
    { 20, 16, 26.50, -35, 11, 52.1, 6.53 },
    { 14, 44, 59.21, -35, 11, 30.8, 4.92 },
    { 12, 25, 21.79, -35, 11, 11.0, 5.73 },
    { 14, 43, 39.41, -35, 10, 25.0, 4.05 },
    {  6, 16, 33.10, -35,  8, 26.2, 4.37 },
    {  5, 33,  7.39, -35,  8, 22.9, 5.78 },
    {  0, 11, 43.99, -35,  7, 59.2, 5.25 },
    {  8, 27, 59.30, -35,  6, 50.0, 5.75 },
    { 11, 53, 26.81, -35,  4,   .1, 6.17 },
    {  6, 25, 29.90, -35,  3, 50.0, 6.25 },
    { 17, 52, 55.90, -35,  1,  7.0, 6.45 },
    {  9, 27, 38.40, -35,  0, 28.1, 6.65 },
    { 17, 18, 57.19, -34, 59, 22.9, 5.91 },
    { 19, 21, 29.90, -34, 59,  2.0, 6.48 },
    {  7, 37, 22.10, -34, 58,  7.0, 4.53 },
    {  5, 15, 46.99, -34, 55, 36.1, 6.66 },
    {  4, 51, 28.20, -34, 54, 23.0, 5.86 },
    {  0, 14, 58.20, -34, 54, 15.8, 6.17 },
    { 17, 53, 23.30, -34, 53, 43.1, 5.60 },
    {  5, 17, 29.09, -34, 53, 43.1, 4.83 },
    {  7, 54, 39.91, -34, 50, 48.8, 6.15 },
    { 17, 53, 58.10, -34, 49, 54.1, 6.42 },
    { 17, 52, 13.61, -34, 47, 57.1, 5.90 },
    { 14, 22, 19.70, -34, 47, 12.8, 5.56 },
    { 17, 53, 45.50, -34, 47,  8.9, 6.38 },
    {  7,  5, 31.99, -34, 46, 40.1, 6.14 },
    {  4, 24, 56.40, -34, 45, 28.1, 6.55 },
    { 17, 53, 54.91, -34, 45,  9.0, 5.96 },
    { 23,  3, 29.81, -34, 44, 57.8, 5.11 },
    { 18, 49, 17.21, -34, 44, 55.0, 6.62 },
    { 11, 40, 12.79, -34, 44, 40.9, 4.70 },
    { 11, 17, 39.19, -34, 44, 13.9, 6.45 },
    {  3, 53, 38.90, -34, 43, 55.9, 5.11 },
    { 17, 53, 19.61, -34, 43, 50.2, 6.17 },
    { 15, 42, 40.99, -34, 42, 38.2, 4.75 },
    {  7, 52, 15.70, -34, 42, 19.1, 5.01 },
    { 12, 10,  2.50, -34, 42, 18.0, 6.17 },
    { 16, 31, 22.90, -34, 42, 15.8, 4.23 },
    {  5, 20, 20.59, -34, 41, 56.0, 6.34 },
    { 19, 59, 51.29, -34, 41, 52.1, 5.30 },
    { 17, 25,  2.71, -34, 41, 47.0, 6.16 },
    { 15, 46, 44.21, -34, 40, 57.0, 5.61 },
    {  5, 42, 15.10, -34, 40,  4.1, 5.29 },
    {  2, 33,  7.01, -34, 39,   .0, 5.90 },
    {  8, 32, 58.61, -34, 38,  2.0, 6.36 },
    {  8, 46, 49.20, -34, 37, 22.1, 6.37 },
    {  8, 19, 29.40, -34, 35, 25.1, 6.43 },
    {  2, 36, 58.61, -34, 34, 41.9, 5.79 },
    { 13, 36, 50.50, -34, 28,  4.1, 6.50 },
    { 17, 54, 27.19, -34, 27, 59.0, 5.96 },
    { 13, 49, 26.71, -34, 27,  2.9, 4.19 },
    { 17, 52, 19.70, -34, 25,   .1, 5.84 },
    { 15, 39, 46.01, -34, 24, 42.8, 4.67 },
    {  6, 19, 40.99, -34, 23, 48.1, 5.78 },
    { 18, 24, 10.30, -34, 23,  4.9, 1.85 },
    {  6, 50, 52.39, -34, 22,  1.9, 4.99 },
    { 15,  1, 58.10, -34, 21, 32.0, 6.22 },
    {  5, 21, 16.90, -34, 20, 43.1, 6.09 },
    {  6,  7,  3.70, -34, 18, 42.8, 5.83 },
    { 16, 50,  9.79, -34, 17, 35.9, 2.29 },
    { 17, 32, 24.50, -34, 16, 46.9, 6.17 },
    {  7, 45, 34.99, -34, 10, 23.2, 5.37 },
    { 22, 47, 19.10, -34,  9, 40.0, 6.28 },
    {  6, 20, 36.31, -34,  8, 38.0, 5.53 },
    {  7, 26, 42.29, -34,  8, 26.9, 5.90 },
    { 12, 13, 13.01, -34,  7, 32.2, 6.50 },
    { 17,  4, 49.39, -34,  7, 22.1, 4.87 },
    { 17, 52, 49.20, -34,  6, 51.1, 6.06 },
    {  6, 58, 25.10, -34,  6, 42.1, 5.06 },
    { 18, 17, 36.10, -34,  6, 25.9, 6.16 },
    {  9, 19, 47.90, -34,  6, 11.9, 6.39 },
    {  5, 39, 38.90, -34,  4, 27.1, 2.64 },
    { 10, 49, 57.00, -34,  3, 29.2, 5.61 },
    { 22,  8, 25.99, -34,  2, 38.0, 4.99 },
    {  4, 24,  2.21, -34,  1,   .8, 3.96 },
    { 22,  9, 55.70, -34,  0, 52.9, 5.37 },
    {  4, 45, 49.61, -34,  0, 18.0, 6.86 },
    { 12, 50, 41.21, -33, 59, 57.8, 4.91 },
    { 15, 56, 53.50, -33, 57, 59.0, 5.12 },
    { 15, 56, 54.19, -33, 57, 51.1, 5.62 },
    {  0, 39, 57.91, -33, 57, 42.1, 6.69 },
    { 18, 25, 54.60, -33, 56, 43.1, 6.30 },
    { 21, 32, 14.59, -33, 56, 40.9, 5.97 },
    {  6,  1, 16.39, -33, 54, 42.1, 5.55 },
    { 11, 52, 54.60, -33, 54, 29.2, 4.28 },
    {  4, 19,  3.00, -33, 54, 18.0, 6.37 },
    { 14, 55, 44.69, -33, 51, 20.9, 5.32 },
    {  2, 28,  1.70, -33, 48, 40.0, 5.14 },
    {  5, 53,  6.89, -33, 48,  5.0, 4.87 },
    { 18, 10, 55.20, -33, 47, 58.9, 6.16 },
    {  4, 17, 53.69, -33, 47, 53.9, 3.56 },
    { 12, 13, 36.70, -33, 47, 34.1, 6.33 },
    { 20, 49, 58.10, -33, 46, 46.9, 4.90 },
    {  1, 28, 43.30, -33, 45, 49.0, 6.58 },
    {  8, 37, 29.69, -33, 44, 44.9, 6.48 },
    { 10, 59, 13.90, -33, 44, 13.9, 5.71 },
    {  7, 19, 13.70, -33, 43, 37.9, 6.30 },
    { 23, 19, 43.20, -33, 42, 29.2, 6.37 },
    { 20,  0, 20.30, -33, 42, 14.0, 5.66 },
    { 17, 31, 47.40, -33, 42, 10.1, 6.44 },
    { 21, 39,  6.10, -33, 40, 45.1, 6.28 },
    { 15, 50, 57.50, -33, 37, 37.9, 3.95 },
    { 13, 41, 45.70, -33, 35, 48.8, 6.05 },
    { 11, 36, 34.99, -33, 34, 12.0, 5.74 },
    {  8, 13, 41.09, -33, 34,  9.1, 6.37 },
    {  8,  5, 44.90, -33, 34,  9.1, 6.14 },
    { 17, 15, 19.30, -33, 32, 53.9, 5.53 },
    { 16,  9, 52.61, -33, 32, 44.9, 5.54 },
    {  0,  8,  3.50, -33, 31, 45.8, 5.68 },
    { 19, 16, 32.81, -33, 31, 18.1, 6.25 },
    { 16, 55, 57.79, -33, 30, 25.9, 6.37 },
    { 13,  0, 32.59, -33, 30, 19.1, 6.02 },
    {  7,  0, 49.80, -33, 27, 55.1, 6.40 },
    {  7, 34, 12.79, -33, 27, 47.9, 6.11 },
    {  6, 22,  6.79, -33, 26, 11.0, 3.85 },
    { 20, 40, 19.80, -33, 25, 54.8, 5.47 },
    {  9, 56, 35.50, -33, 25,  7.0, 5.84 },
    {  5, 41, 27.00, -33, 24,  2.2, 6.34 },
    { 12, 46, 46.01, -33, 18, 56.2, 5.86 },
    { 11, 57,  3.70, -33, 18, 55.1, 6.21 },
    { 13, 34, 43.61, -33, 18, 38.9, 6.44 },
    { 14, 54, 37.99, -33, 18,  2.2, 5.82 },
    {  7, 49, 35.40, -33, 17, 20.0, 5.60 },
    { 16, 57, 11.09, -33, 15, 33.8, 5.48 },
    { 14, 16, 18.29, -33, 14, 29.0, 6.55 },
    { 14, 18, 23.81, -33, 13, 14.2, 6.54 },
    { 16,  4, 17.81, -33, 12, 51.8, 6.10 },
    { 16, 23, 56.71, -33, 11, 57.8, 6.47 },
    { 13, 23,  8.71, -33, 11, 24.0, 6.22 },
    {  8, 43, 35.50, -33, 11, 11.0, 3.68 },
    { 20, 51, 58.80, -33, 10, 37.9, 6.04 },
    { 16, 41, 45.50, -33,  8, 47.0, 5.87 },
    { 22,  8, 42.70, -33,  7, 32.2, 6.37 },
    { 15, 36, 11.40, -33,  5, 34.1, 6.24 },
    { 22, 38, 51.50, -33,  4, 53.0, 5.66 },
    {  5, 35, 15.41, -33,  4, 48.0, 5.78 },
    {  1, 58, 26.69, -33,  4,   .1, 6.35 },
    {  8, 21, 22.99, -33,  3, 15.8, 4.83 },
    { 17, 43,  6.89, -33,  3,  4.0, 6.40 },
    { 21, 36, 48.89, -33,  2, 53.2, 6.11 },
    { 19, 55,  5.09, -33,  2, 47.0, 6.46 },
    { 13, 45, 41.21, -33,  2, 38.0, 4.23 },
    { 10, 13, 24.79, -33,  1, 54.8, 6.38 },
    { 21, 44, 56.81, -33,  1, 32.9, 4.34 },
    { 18, 33, 57.79, -33,  1,   .1, 5.28 },
    { 16, 14, 22.30, -33,  0, 41.0, 5.92 },
    {  0, 27, 55.70, -33,  0, 25.9, 4.81 },
    { 20,  5, 32.11, -33,  0,   .0, 6.53 },
    { 13, 51, 50.11, -32, 59, 40.9, 6.06 },
    { 13, 51, 49.61, -32, 59, 39.8, 4.56 },
    { 18, 31,  4.80, -32, 59, 21.1, 5.34 },
    { 22,  8, 22.99, -32, 59, 19.0, 4.50 },
    { 11, 37,  1.20, -32, 59, 17.2, 6.29 },
    { 15, 31, 50.30, -32, 52, 52.0, 6.46 },
    { 22, 52, 31.61, -32, 52, 32.2, 4.46 },
    { 11, 34, 29.50, -32, 49, 53.0, 5.98 },
    { 12, 26, 51.70, -32, 49, 48.0, 5.55 },
    { 22, 49, 59.09, -32, 48, 19.1, 6.33 },
    {  8, 49, 51.50, -32, 46, 50.2, 5.21 },
    { 18,  9, 59.90, -32, 43, 10.9, 6.43 },
    {  6, 34, 35.30, -32, 42, 59.0, 5.62 },
    { 10, 42, 43.20, -32, 42, 56.9, 5.64 },
    {  3, 23, 44.59, -32, 42, 25.9, 6.50 },
    {  8,  4, 16.20, -32, 40, 30.0, 5.31 },
    { 17, 17,  3.70, -32, 39, 46.1, 5.55 },
    { 16,  9, 31.70, -32, 38, 58.9, 6.19 },
    { 15,  2, 59.30, -32, 38, 35.9, 5.44 },
    { 14, 56, 30.91, -32, 38, 12.1, 6.06 },
    {  5, 39, 49.80, -32, 37, 45.1, 5.45 },
    {  8, 34, 31.70, -32, 35, 55.0, 6.43 },
    { 11,  7,  8.40, -32, 35, 13.9, 6.59 },
    { 17, 34, 42.50, -32, 34, 54.1, 5.70 },
    {  6, 28, 10.10, -32, 34, 48.0, 4.48 },
    { 17, 18, 20.40, -32, 33, 11.9, 6.36 },
    { 22, 10,  8.81, -32, 32, 53.9, 4.92 },
    {  1, 26, 58.10, -32, 32, 35.2, 5.79 },
    { 22, 55, 56.90, -32, 32, 22.9, 4.21 },
    { 12, 32,  4.51, -32, 32,  1.0, 6.46 },
    { 23, 18, 49.39, -32, 31, 54.8, 4.41 },
    {  2, 44, 20.50, -32, 31, 30.0, 6.22 },
    {  8, 52, 26.09, -32, 30, 33.1, 6.50 },
    {  6, 49, 50.50, -32, 30, 31.0, 3.96 },
    {  2, 59, 38.30, -32, 30, 25.9, 6.31 },
    { 11, 41, 43.99, -32, 29, 58.9, 5.22 },
    {  8,  3,  4.10, -32, 27, 50.0, 5.82 },
    { 17, 12, 58.70, -32, 26, 19.0, 6.01 },
    { 11, 12, 14.81, -32, 26,  2.0, 6.38 },
    {  2, 49,  5.40, -32, 24, 20.9, 4.46 },
    {  6, 28, 39.19, -32, 22, 16.0, 5.74 },
    { 11,  9, 53.40, -32, 22,  3.0, 5.81 },
    { 22, 31, 30.31, -32, 20, 46.0, 4.29 },
    { 21,  6, 24.70, -32, 20, 30.1, 5.18 },
    {  6, 37, 47.59, -32, 20, 22.9, 5.27 },
    {  1, 42,  8.59, -32, 19, 36.8, 5.25 },
    {  5, 45, 59.90, -32, 18, 23.0, 5.17 },
    { 21,  1, 17.50, -32, 15, 28.1, 4.67 },
    {  7, 23, 31.90, -32, 12,  7.9, 5.39 },
    {  9, 37,  9.89, -32, 10, 43.0, 5.63 },
    { 21, 17, 56.30, -32, 10, 21.0, 4.71 },
    {  6,  4, 20.30, -32, 10, 21.0, 5.65 },
    {  8, 30, 28.61, -32,  9, 33.8, 5.65 },
    { 17,  1, 52.70, -32,  8, 37.0, 5.03 },
    {  8, 14, 10.99, -32,  8, 26.9, 6.06 },
    {  0, 29, 48.91, -32,  7,   .1, 6.57 },
    { 16, 43, 38.71, -32,  6, 22.0, 6.46 },
    { 19, 30, 14.69, -32,  5, 31.9, 6.60 },
    { 23, 40, 38.21, -32,  4, 23.2, 5.31 },
    { 20,  4, 19.61, -32,  3, 23.0, 4.99 },
    { 20, 50, 47.11, -32,  3, 15.8, 6.36 },
    {  6, 32, 39.00, -32,  1, 50.2, 5.69 },
    { 16,  3, 34.30, -32,  0,  2.2, 6.01 },
    {  5, 56, 49.01, -31, 58, 34.0, 6.44 },
    { 11,  3, 16.10, -31, 57, 38.9, 6.46 },
    {  3, 42, 14.90, -31, 56, 17.9, 5.00 },
    { 13, 53, 12.50, -31, 55, 40.1, 4.73 },
    {  7, 23,   .60, -31, 55, 26.0, 5.43 },
    { 23, 55, 16.61, -31, 55, 18.1, 6.10 },
    { 19, 46,  1.20, -31, 54, 31.0, 5.52 },
    {  1, 34, 50.71, -31, 53, 31.9, 6.12 },
    {  9, 30, 45.41, -31, 53, 29.0, 7.00 },
    { 16,  1, 19.51, -31, 53, 21.8, 6.33 },
    {  9, 30, 46.10, -31, 53, 21.8, 6.18 },
    { 23, 55, 16.61, -31, 53,  3.1, 6.83 },
    {  3, 34, 33.50, -31, 52, 28.9, 6.40 },
    {  9, 31, 32.21, -31, 52, 18.8, 5.93 },
    { 23, 37,  5.40, -31, 52, 14.9, 6.52 },
    { 11, 33,   .10, -31, 51, 28.1, 3.54 },
    {  7, 28, 51.31, -31, 50, 53.9, 6.38 },
    {  7, 28, 51.50, -31, 50, 48.8, 7.13 },
    { 11,  0, 40.80, -31, 50, 21.8, 6.07 },
    { 19, 20, 26.21, -31, 49,  4.1, 6.58 },
    {  7, 24, 43.80, -31, 48, 32.0, 5.35 },
    {  6, 45, 22.80, -31, 47, 37.0, 5.92 },
    {  6, 23, 14.40, -31, 47, 24.0, 6.34 },
    {  6, 55, 54.79, -31, 47, 24.0, 6.36 },
    { 15, 56, 13.90, -31, 47,  8.9, 6.29 },
    {  5,  2, 22.80, -31, 46, 17.0, 5.94 },
    {  9, 20, 44.21, -31, 45, 38.2, 6.82 },
    {  7, 25, 43.01, -31, 44, 19.0, 6.31 },
    {  6, 50, 23.30, -31, 42, 22.0, 5.70 },
    { 17, 49, 10.51, -31, 42, 11.9, 4.83 },
    { 10, 48, 14.21, -31, 41, 17.9, 5.88 },
    { 14,  3,  1.70, -31, 41,  2.0, 6.18 },
    {  8, 27, 16.39, -31, 40, 23.2, 6.33 },
    { 22, 36, 35.40, -31, 39, 50.0, 5.82 },
    {  7, 40, 52.70, -31, 39, 38.9, 6.56 },
    { 22, 55, 51.41, -31, 37, 59.2, 6.10 },
    { 13, 52,   .91, -31, 37,  9.8, 6.12 },
    { 20, 41, 23.71, -31, 35, 53.9, 5.76 },
    { 22, 56, 24.00, -31, 33, 56.2, 6.48 },
    {  1,  2, 26.40, -31, 33,  6.8, 5.50 },
    { 15, 14, 37.30, -31, 31,  9.1, 4.91 },
    { 13, 16, 53.11, -31, 30, 22.0, 5.10 },
    {  8, 32, 51.50, -31, 30,  2.9, 6.38 },
    {  7, 29,  4.90, -31, 27, 23.0, 5.77 },
    {  0, 16,  8.90, -31, 26, 47.0, 5.67 },
    {  5, 56, 20.90, -31, 22, 57.0, 5.50 },
    { 13, 55, 44.50, -31, 17,  6.0, 6.51 },
    { 21, 29,  3.79, -31, 14, 19.0, 6.50 },
    { 15, 40, 15.41, -31, 12, 49.0, 6.34 },
    { 15, 18, 41.30, -31, 12, 33.8, 6.18 },
    {  2, 28, 35.40, -31,  6,  9.0, 6.11 },
    { 11, 32, 54.10, -31,  5, 13.9, 5.04 },
    {  7, 13, 47.11, -31,  5,  2.0, 6.60 },
    { 15, 55, 30.41, -31,  5,  1.0, 6.21 },
    {  3, 33, 56.81, -31,  4, 49.1, 6.20 },
    {  1, 49, 19.49, -31,  4, 22.1, 6.34 },
    {  6, 44, 28.39, -31,  4, 14.2, 5.20 },
    { 10, 27,  9.10, -31,  4,  4.1, 4.25 },
    { 19,  4, 25.10, -31,  2, 48.8, 5.50 },
    { 18, 58, 21.29, -31,  2, 10.0, 6.12 },
    {  0, 23, 12.60, -31,  2, 10.0, 6.55 },
    {  6, 58, 43.80, -30, 59, 52.1, 6.42 },
    {  7, 30, 42.50, -30, 57, 43.9, 4.65 },
    {  6, 45, 31.30, -30, 56, 56.0, 5.80 },
    {  1, 23, 31.01, -30, 56, 44.2, 5.84 },
    { 14, 41, 51.10, -30, 55, 59.9, 6.37 },
    {  8, 15, 52.51, -30, 55, 32.9, 6.21 },
    { 15,  6, 33.29, -30, 55,  8.0, 5.96 },
    {  7, 55, 13.70, -30, 55,  3.0, 6.44 },
    { 16, 19, 32.69, -30, 54, 24.1, 5.49 },
    { 21, 47, 44.21, -30, 53, 53.9, 5.01 },
    {  7, 16, 57.19, -30, 53, 48.1, 6.32 },
    { 11, 51, 41.59, -30, 50,  6.0, 5.85 },
    {  3, 16, 11.30, -30, 49, 39.0, 6.65 },
    {  7, 12,  4.10, -30, 49, 18.1, 6.10 },
    {  2, 51, 55.30, -30, 48, 51.8, 6.40 },
    {  1, 12, 23.40, -30, 48,  7.9, 6.52 },
    {  4, 43,  9.29, -30, 45, 56.2, 5.68 },
    { 18, 25,  1.51, -30, 45, 24.1, 5.60 },
    { 18, 52, 41.69, -30, 44,  3.1, 6.63 },
    { 18, 10,  5.69, -30, 43, 43.0, 5.53 },
    {  2, 12, 54.50, -30, 43, 26.0, 5.28 },
    { 20, 53, 25.01, -30, 43,  7.0, 6.35 },
    {  4, 36, 50.90, -30, 43,   .1, 6.30 },
    { 14, 33,  9.60, -30, 42, 51.1, 6.09 },
    {  7, 15, 21.00, -30, 41, 11.0, 5.36 },
    { 22, 40, 22.30, -30, 39, 32.0, 5.87 },
    {  7,  6,   .60, -30, 39, 20.2, 6.34 },
    {  2, 40,  2.50, -30, 38,  2.0, 6.52 },
    { 10, 29, 35.40, -30, 36, 25.9, 5.56 },
    { 21, 55, 55.61, -30, 36, 23.0, 6.41 },
    { 16, 54, 36.00, -30, 35, 13.9, 6.35 },
    {  6, 45,  2.40, -30, 35, 10.0, 6.54 },
    { 10,  2, 49.30, -30, 34, 39.0, 6.54 },
    { 14, 52, 33.10, -30, 34, 36.8, 6.29 },
    {  4, 35, 33.00, -30, 33, 43.9, 3.82 },
    { 17, 51, 12.50, -30, 33, 25.9, 6.66 },
    { 19, 58, 56.40, -30, 32, 17.2, 6.28 },
    {  5, 42, 11.59, -30, 32,  8.2, 6.19 },
    {  4,  0, 40.70, -30, 29, 26.9, 5.93 },
    { 20, 34, 47.40, -30, 28, 25.0, 6.40 },
    {  6, 39, 42.70, -30, 28, 13.1, 5.71 },
    { 18,  5, 48.50, -30, 25, 27.1, 2.99 },
    { 12, 39,  3.50, -30, 25, 19.9, 5.89 },
    { 17,  8, 47.50, -30, 24, 13.0, 5.97 },
    {  9,  9, 56.40, -30, 21, 55.1, 5.59 },
    {  7, 13, 57.19, -30, 20, 24.0, 6.33 },
    {  7, 57, 40.10, -30, 20,  4.9, 4.79 },
    {  8,  9,  6.70, -30, 19, 21.0, 6.65 },
    { 11, 47, 15.70, -30, 17, 12.8, 6.48 },
    {  7, 56, 22.80, -30, 17,  7.1, 6.33 },
    {  1, 31, 43.30, -30, 16, 59.9, 5.82 },
    { 17, 59,  5.50, -30, 15, 11.9, 7.04 },
    { 17, 59,  5.21, -30, 15, 11.2, 5.16 },
    {  7, 23, 54.29, -30, 13,   .8, 6.60 },
    { 17, 15, 51.50, -30, 12, 38.2, 6.21 },
    {  9, 45, 21.79, -30, 12, 10.1, 6.45 },
    {  2, 38, 18.70, -30, 11, 39.1, 5.83 },
    { 11,  7, 54.41, -30, 10, 28.9, 6.54 },
    {  3, 47, 55.99, -30, 10,  4.1, 5.54 },
    { 10, 23, 13.10, -30,  9, 43.9, 6.27 },
    { 15, 17, 49.90, -30,  8, 56.0, 4.34 },
    { 21,  6,  1.20, -30,  7, 30.0, 5.68 },
    {  5, 29,  6.70, -30,  7,   .1, 6.75 },
    {  6, 20, 18.79, -30,  3, 47.9, 3.02 },
    {  2, 36,  9.29, -30,  2, 40.9, 5.75 },
    {  4, 47, 49.61, -30,  1, 13.1, 6.37 },
    { 20, 15, 50.59, -30,  0, 19.1, 6.30 },
    {  8, 17, 58.30, -30,  0, 11.9, 6.45 },
    {  2,  1, 14.71, -30,  0,  6.1, 5.35 },
    { 11,  8, 15.79, -29, 58, 22.1, 6.49 },
    { 22,  4, 23.90, -29, 55,   .1, 6.47 },
    {  8, 12, 46.01, -29, 54, 38.9, 6.52 },
    {  1, 36,  8.40, -29, 54, 27.0, 5.69 },
    { 22,  3, 17.21, -29, 54, 15.1, 7.10 },
    {  3, 47, 20.11, -29, 54,  6.8, 6.55 },
    { 15, 52, 12.79, -29, 53, 12.1, 6.40 },
    { 19,  2, 36.70, -29, 52, 49.1, 2.60 },
    { 17, 27, 21.29, -29, 52,   .8, 4.29 },
    {  2, 57, 13.10, -29, 51, 19.1, 6.29 },
    {  5, 33, 52.10, -29, 50, 56.0, 6.53 },
    { 18, 20, 59.69, -29, 49, 41.2, 2.70 },
    { 18, 27, 49.49, -29, 48, 59.0, 5.92 },
    {  3, 13, 37.99, -29, 48, 15.1, 6.16 },
    {  6, 15, 57.19, -29, 47, 17.9, 6.67 },
    { 15, 38, 39.41, -29, 46, 40.1, 3.66 },
    {  4, 33, 30.60, -29, 46,   .1, 4.51 },
    {  6,  6,  5.50, -29, 45, 31.0, 5.81 },
    { 19, 26, 56.50, -29, 44, 35.9, 5.67 },
    { 17, 27, 37.49, -29, 43, 27.8, 6.00 },
    {  0,  2, 19.90, -29, 43, 13.1, 5.01 },
    { 16, 24, 39.70, -29, 42, 16.9, 5.84 },
    { 16, 24, 39.60, -29, 42, 11.9, 6.63 },
    { 18, 35, 59.69, -29, 41, 57.1, 6.37 },
    { 21, 34, 52.99, -29, 41, 46.0, 6.41 },
    {  2,  2, 28.10, -29, 39, 54.0, 6.42 },
    { 10, 29, 28.99, -29, 39, 49.0, 5.58 },
    { 22, 57, 39.10, -29, 37, 19.9, 1.16 },
    { 18,  5,  1.30, -29, 34, 48.0, 4.69 },
    { 13, 32, 34.51, -29, 33, 55.1, 6.45 },
    {  8, 39, 42.50, -29, 33, 40.0, 4.89 },
    { 13, 38, 42.00, -29, 33, 38.9, 5.83 },
    {  0, 33, 41.11, -29, 33, 29.9, 5.55 },
    { 22, 51, 20.90, -29, 32, 10.0, 5.97 },
    {  1,  3, 17.59, -29, 31, 32.9, 6.29 },
    { 23, 10, 46.61, -29, 31, 30.0, 6.51 },
    { 19, 11, 18.89, -29, 30,  7.9, 6.30 },
    { 14, 28, 10.39, -29, 29, 30.1, 4.97 },
    { 23, 59, 27.89, -29, 29,  6.0, 5.62 },
    {  8, 50,  2.21, -29, 27, 47.2, 5.87 },
    { 22, 59, 35.81, -29, 27, 43.9, 5.51 },
    {  5, 51, 59.50, -29, 26, 55.0, 6.45 },
    { 16, 11,  1.99, -29, 24, 59.0, 5.13 },
    {  6, 13, 33.29, -29, 23, 46.0, 6.54 },
    { 18, 52, 37.01, -29, 22, 45.8, 6.13 },
    { 22, 42, 22.10, -29, 21, 38.9, 6.17 },
    {  0, 58, 36.41, -29, 21, 27.0, 4.31 },
    {  3, 46, 27.41, -29, 20, 17.2, 5.90 },
    { 19, 25,  4.10, -29, 18, 33.1, 5.93 },
    {  7, 24,  5.71, -29, 18, 11.2, 2.45 },
    {  2,  4, 29.40, -29, 17, 48.8, 4.69 },
    { 14, 15,  1.30, -29, 16, 54.8, 6.08 },
    {  0,  4, 20.30, -29, 16,  7.0, 6.40 },
    { 11, 32, 16.10, -29, 15, 47.9, 5.81 },
    { 11, 32, 16.30, -29, 15, 40.0, 5.64 },
    {  8, 26, 50.81, -29, 12, 55.1, 6.73 },
    { 15, 56, 53.11, -29, 12, 51.1, 3.88 },
    { 20, 20, 28.10, -29, 11, 49.9, 6.30 },
    { 11, 41,  8.40, -29, 11, 47.0, 6.44 },
    { 14, 57, 13.61, -29,  9, 28.1, 6.29 },
    {  7, 27, 59.21, -29,  9, 20.9, 5.54 },
    {  5, 54, 14.09, -29,  8, 52.1, 6.36 },
    { 16,  2, 39.41, -29,  8,  8.9, 6.03 },
    { 20, 30, 56.81, -29,  6, 45.0, 6.39 },
    { 13, 50,  6.50, -29,  4, 53.0, 6.18 },
    { 10, 18,  7.61, -28, 59, 30.8, 5.34 },
    {  3, 12,  4.30, -28, 59, 12.8, 3.87 },
    {  0, 21, 31.20, -28, 58, 54.1, 5.18 },
    {  6, 58, 37.49, -28, 58, 19.9, 1.50 },
    {  7, 43, 48.50, -28, 57, 16.9, 3.96 },
    {  2, 59,  6.60, -28, 54, 24.8, 6.14 },
    { 18, 11, 58.20, -28, 54,  5.0, 6.51 },
    { 23,  1, 19.39, -28, 51, 13.0, 5.55 },
    {  9, 23, 12.31, -28, 50,  2.0, 4.69 },
    { 23,  8, 21.00, -28, 49, 23.9, 5.60 },
    {  8, 59, 15.70, -28, 48, 22.0, 6.25 },
    {  3, 18,  2.81, -28, 47, 48.8, 5.91 },
    { 19, 49, 11.59, -28, 47, 20.0, 6.05 },
    {  9, 26, 44.81, -28, 47, 15.0, 6.10 },
    {  6, 24, 43.90, -28, 46, 48.0, 6.39 },
    { 21, 18, 54.41, -28, 45, 56.2, 6.40 },
    { 17, 58, 39.10, -28, 45, 33.1, 6.01 },
    { 22, 38, 44.69, -28, 44, 52.1, 6.47 },
    { 11,  6, 38.71, -28, 43, 40.1, 6.77 },
    {  5, 36, 10.30, -28, 42, 28.1, 6.26 },
    { 13, 32, 35.90, -28, 41, 34.1, 5.69 },
    {  5, 37, 44.59, -28, 41, 21.8, 5.31 },
    { 20, 25, 26.81, -28, 39, 47.9, 5.85 },
    { 18, 17, 24.00, -28, 39,  9.0, 6.19 },
    {  5, 47,  4.70, -28, 38, 21.1, 6.22 },
    { 19,  7, 30.91, -28, 38, 12.8, 6.04 },
    {  9, 32, 18.50, -28, 37, 41.2, 6.46 },
    {  8, 50, 21.60, -28, 37,  5.2, 6.17 },
    { 16, 18, 17.90, -28, 36, 50.0, 4.78 },
    { 10, 12,  2.90, -28, 36, 23.0, 6.28 },
    { 13, 54, 16.61, -28, 34, 10.9, 6.04 },
    {  6, 53, 33.91, -28, 32, 22.9, 6.04 },
    { 16, 45,   .19, -28, 30, 34.9, 6.02 },
    {  7,  0, 42.60, -28, 29, 21.8, 6.27 },
    { 11, 55, 40.10, -28, 28, 36.8, 5.93 },
    { 18,  8,  4.99, -28, 27, 25.9, 4.57 },
    { 22,  0, 50.21, -28, 27, 13.0, 5.42 },
    { 18, 22,   .19, -28, 25, 48.0, 6.16 },
    { 16, 12, 15.91, -28, 25,  3.0, 5.67 },
    {  7, 43, 32.40, -28, 24, 40.0, 4.59 },
    {  7, 35, 22.80, -28, 22,  9.8, 4.64 },
    { 22, 39, 43.99, -28, 19, 31.1, 6.31 },
    { 12, 44,   .50, -28, 19, 26.0, 5.48 },
    { 22, 10,   .10, -28, 17, 33.0, 6.44 },
    { 18, 17, 23.71, -28, 17, 21.1, 6.40 },
    { 10, 31, 48.60, -28, 14, 15.0, 6.05 },
    {  2, 33, 50.71, -28, 13, 57.0, 4.90 },
    { 16, 35, 52.99, -28, 12, 58.0, 2.82 },
    { 15, 38, 15.70, -28, 12, 24.1, 6.32 },
    { 17, 23, 21.60, -28,  8, 35.2, 5.35 },
    { 15, 37,  1.51, -28,  8,  6.0, 3.58 },
    { 23, 48, 55.61, -28,  7, 49.1, 4.57 },
    { 13, 31, 33.29, -28,  6, 46.1, 6.47 },
    {  3,  1, 37.70, -28,  5, 30.1, 5.89 },
    { 23,  9, 44.59, -28,  5, 19.0, 5.87 },
    {  4, 46, 25.80, -28,  5, 15.0, 6.19 },
    { 11,  8, 43.90, -28,  4, 50.2, 5.44 },
    { 17, 56, 41.90, -28,  3, 55.1, 5.80 },
    { 15, 46, 12.79, -28,  3, 42.1, 6.51 },
    { 15,  2,  6.41, -28,  3, 38.2, 5.85 },
    { 15, 34, 37.30, -28,  2, 48.8, 5.15 },
    {  0,  9, 21.00, -27, 59, 16.1, 5.42 },
    { 14, 50, 17.30, -27, 57, 37.1, 4.41 },
    {  7, 40, 43.39, -27, 56, 44.9, 6.76 },
    {  3, 38, 47.69, -27, 56, 35.2, 6.01 },
    {  2, 49, 54.19, -27, 56, 30.1, 5.39 },
    {  7,  1, 43.10, -27, 56,  4.9, 3.47 },
    { 16, 12, 18.19, -27, 55, 35.0, 4.59 },
    { 20, 54,  6.79, -27, 55, 32.2, 6.41 },
    { 17, 43, 17.81, -27, 53,  3.1, 6.36 },
    {  7, 16, 34.99, -27, 52, 52.0, 4.64 },
    {  5, 37, 16.49, -27, 52, 17.0, 6.16 },
    { 19, 24, 30.10, -27, 51, 56.2, 6.04 },
    {  7, 23, 29.09, -27, 50,  3.1, 5.38 },
    {  3,  7, 50.90, -27, 49, 52.0, 6.19 },
    { 17, 47, 33.60, -27, 49, 50.9, 4.54 },
    {  0, 11, 34.39, -27, 47, 58.9, 5.41 },
    {  0, 55, 55.49, -27, 46, 32.2, 6.10 },
    {  6, 30, 46.30, -27, 46,  9.8, 5.93 },
    {  9, 44, 12.10, -27, 46,  9.8, 4.79 },
    { 22, 14, 18.79, -27, 46,   .8, 5.43 },
    { 17, 12, 25.01, -27, 45, 42.8, 6.14 },
    { 14, 23,  5.81, -27, 45, 14.0, 4.77 },
    { 12, 25, 18.41, -27, 44, 57.1, 6.09 },
    { 21,  3, 10.20, -27, 43, 54.8, 6.25 },
    {  8, 50, 31.90, -27, 42, 36.0, 4.01 },
    { 20,  2, 39.50, -27, 42, 34.9, 4.58 },
    {  8, 55, 31.51, -27, 40, 54.8, 4.89 },
    { 19,  6, 56.40, -27, 40, 14.2, 3.32 },
    { 14, 58, 39.19, -27, 39, 25.9, 5.65 },
    {  4,  5, 37.39, -27, 39,  6.1, 5.59 },
    { 21, 13, 17.30, -27, 37,  9.8, 5.42 },
    { 12, 48, 26.40, -27, 35, 51.0, 5.66 },
    {  6, 57, 42.41, -27, 32, 15.0, 6.23 },
    {  7, 10, 19.39, -27, 29, 29.0, 5.46 },
    {  9, 56, 54.00, -27, 28, 30.0, 6.32 },
    {  7, 12, 24.10, -27, 28, 27.1, 6.59 },
    { 16, 44, 17.30, -27, 27, 22.0, 6.58 },
    { 14,  2, 22.80, -27, 25, 48.0, 5.48 },
    { 10, 37, 13.70, -27, 24, 45.0, 4.89 },
    {  5, 19, 23.69, -27, 22,  8.0, 5.99 },
    {  7, 13, 36.31, -27, 21, 23.0, 6.12 },
    {  1, 46,  1.01, -27, 20, 57.1, 6.39 },
    {  6, 44, 51.89, -27, 20, 29.0, 6.45 },
    { 15, 54, 30.00, -27, 20, 19.0, 6.14 },
    {  6, 50,  6.00, -27, 20,  2.0, 7.04 },
    {  8, 29, 27.60, -27, 19, 57.0, 6.70 },
    {  9, 52, 58.01, -27, 19, 55.9, 6.30 },
    {  3, 26, 22.51, -27, 19,  3.0, 5.93 },
    { 11,  5, 19.90, -27, 17, 37.0, 4.94 },
    { 11,  5, 57.60, -27, 17, 16.1, 5.71 },
    { 11, 50, 37.10, -27, 16, 40.1, 6.48 },
    { 14, 12, 46.01, -27, 15, 40.0, 5.08 },
    { 20, 45, 13.20, -27, 14, 49.9, 6.50 },
    { 19, 56, 56.81, -27, 10, 12.0, 4.52 },
    {  6, 58,  7.61, -27,  9, 52.9, 6.37 },
    {  6, 10, 34.61, -27,  9, 15.1, 5.72 },
    { 12, 37, 42.19, -27,  8, 20.0, 5.45 },
    { 22, 29, 46.01, -27,  6, 25.9, 5.95 },
    { 22, 40, 39.41, -27,  2, 37.0, 4.17 },
    { 18, 18,  3.19, -27,  2, 33.0, 4.65 },
    { 23, 54, 21.41, -27,  2, 31.9, 6.35 },
    {  7, 14, 51.10, -27,  2, 17.2, 5.58 },
    { 20, 15, 17.40, -27,  1, 58.1, 5.73 },
    { 10, 13, 19.39, -27,  1, 44.0, 6.25 },
    {  7, 34, 34.90, -27,  0, 42.8, 5.77 },
    { 18, 45, 39.41, -26, 59, 26.9, 3.17 },
    { 23, 21, 15.50, -26, 59, 12.1, 5.64 },
    { 19, 29, 52.20, -26, 59,  8.2, 5.52 },
    { 17, 48, 27.79, -26, 58, 30.0, 6.35 },
    {  7, 20, 55.01, -26, 57, 49.0, 6.01 },
    {  6, 53,   .10, -26, 57, 27.0, 6.40 },
    {  5, 15, 24.29, -26, 56, 35.9, 5.07 },
    { 20, 51, 49.30, -26, 55,  9.1, 4.11 },
    { 21,  1, 45.31, -26, 52, 52.0, 6.05 },
    {  7, 39, 26.90, -26, 51, 47.2, 6.50 },
    { 14, 25, 47.69, -26, 51,  9.0, 6.48 },
    {  8, 35, 28.80, -26, 50, 37.0, 5.96 },
    { 11,  2, 24.41, -26, 49, 53.0, 6.23 },
    { 22,  4, 36.79, -26, 49, 21.0, 5.96 },
    {  7, 38, 49.80, -26, 48, 13.0, 4.62 },
    {  7, 38, 49.30, -26, 48,  6.1, 4.50 },
    {  7, 17, 47.90, -26, 47, 51.0, 6.46 },
    {  7, 14, 48.70, -26, 46, 22.1, 3.85 },
    {  9,  8, 43.49, -26, 46,  4.1, 6.15 },
    { 18, 28,  6.19, -26, 45, 25.9, 6.27 },
    { 11, 48, 45.10, -26, 44, 58.9, 5.11 },
    { 11, 32, 23.30, -26, 44, 48.1, 6.16 },
    { 12, 51, 57.91, -26, 44, 17.2, 6.15 },
    {  5, 23, 12.00, -26, 42, 20.9, 6.49 },
    {  6,  9, 47.21, -26, 42,  2.9, 6.27 },
    { 14,  6, 22.30, -26, 40, 57.0, 3.27 },
    { 10, 36,  4.61, -26, 40, 30.0, 6.29 },
    {  9,  1, 11.40, -26, 39, 50.0, 6.20 },
    {  7,  7,   .10, -26, 39, 28.1, 6.62 },
    { 18, 52, 28.49, -26, 39,  1.1, 6.29 },
    { 14, 47, 57.50, -26, 38, 47.0, 5.77 },
    { 20, 40, 36.00, -26, 38, 42.0, 6.51 },
    { 18, 27, 43.80, -26, 38,  4.9, 6.31 },
    { 23, 57,  8.30, -26, 37, 25.0, 6.26 },
    { 14, 13, 13.20, -26, 36, 43.9, 6.24 },
    {  3, 20, 45.19, -26, 36, 23.0, 6.39 },
    { 17, 15, 21.00, -26, 36, 10.1, 5.11 },
    { 17, 15, 20.81, -26, 36,  5.0, 5.07 },
    {  9, 29, 54.50, -26, 35, 22.9, 5.48 },
    {  7, 18, 51.19, -26, 35,  8.9, 5.28 },
    { 18, 28, 57.41, -26, 34, 54.1, 6.50 },
    { 13, 11, 39.19, -26, 33,  6.1, 6.50 },
    {  9, 56, 46.51, -26, 33,  1.1, 6.28 },
    { 16, 31, 22.80, -26, 32, 16.1, 6.10 },
    { 17,  6, 53.21, -26, 30, 47.2, 6.29 },
    { 13, 36, 48.41, -26, 29, 42.0, 5.78 },
    { 10, 30, 51.41, -26, 29,  2.0, 6.51 },
    {  6, 11, 13.51, -26, 28, 55.9, 6.09 },
    { 12, 56, 30.10, -26, 27, 37.1, 6.62 },
    { 16, 29, 24.41, -26, 25, 54.8, 0.96 },
    {  7,  8, 23.50, -26, 23, 35.9, 1.84 },
    { 21, 19, 45.79, -26, 21, 11.2, 6.56 },
    {  7, 14, 15.19, -26, 21,  9.0, 4.66 },
    {  7, 42, 48.10, -26, 21,  4.0, 5.64 },
    {  8, 22, 49.90, -26, 20, 53.2, 5.90 },
    { 15, 10, 18.60, -26, 19, 58.1, 5.76 },
    { 22, 12, 57.50, -26, 19, 40.1, 6.17 },
    { 16,  8,  7.61, -26, 19, 36.1, 5.38 },
    { 19, 55, 50.40, -26, 17, 57.8, 4.70 },
    { 18, 55, 15.91, -26, 17, 48.1, 2.02 },
    { 20, 56, 47.30, -26, 17, 47.0, 5.70 },
    {  0, 13, 44.21, -26, 17,  4.9, 6.31 },
    {  6,  3, 15.50, -26, 17,  3.8, 5.04 },
    { 15, 37, 28.49, -26, 16, 48.0, 6.19 },
    {  5,  2,  9.79, -26, 16, 30.0, 5.02 },
    { 17, 31, 44.40, -26, 16, 10.9, 6.05 },
    { 15, 55, 30.10, -26, 15, 56.9, 5.62 },
    {  8, 37, 52.20, -26, 15, 18.0, 5.27 },
    { 23, 44, 28.90, -26, 14, 47.0, 6.17 },
    {  1, 30, 22.90, -26, 12, 28.1, 5.93 },
    { 19, 58, 57.19, -26, 11, 44.2, 4.83 },
    { 15, 13, 53.30, -26, 11, 37.0, 5.84 },
    { 21, 36, 10.99, -26, 10, 17.0, 5.73 },
    {  5,  5, 16.20, -26,  9,  9.0, 5.73 },
    {  8, 27, 53.50, -26,  7, 57.0, 6.62 },
    {  7, 34, 28.80, -26,  7,   .1, 6.65 },
    { 13, 45, 36.89, -26,  6, 58.0, 5.81 },
    { 15, 58, 51.10, -26,  6, 51.1, 2.89 },
    {  3, 15,   .19, -26,  6,  1.1, 6.25 },
    { 14, 47, 44.81, -26,  5, 15.0, 5.24 },
    { 22, 30, 53.71, -26,  4, 25.0, 6.43 },
    {  0, 13, 42.10, -26,  1, 18.8, 5.94 },
    { 20, 41, 24.10, -26,  0,   .0, 6.28 },
    {  9, 21, 29.59, -25, 57, 56.2, 4.72 },
    {  2, 18, 58.51, -25, 56, 44.2, 6.34 },
    { 17, 26, 55.20, -25, 56, 35.9, 6.44 },
    {  7, 12, 12.19, -25, 56, 33.0, 5.92 },
    {  7, 48,  5.21, -25, 56, 13.9, 4.50 },
    {  9, 54, 12.31, -25, 55, 57.0, 4.88 },
    { 22, 47, 56.21, -25, 54, 42.8, 6.30 },
    {  5, 10, 44.50, -25, 54, 33.8, 6.41 },
    { 11, 58, 54.41, -25, 54, 32.0, 6.43 },
    { 19, 13, 13.70, -25, 54, 24.1, 5.80 },
    { 22, 16, 37.39, -25, 53, 53.9, 6.15 },
    {  7, 21,  4.30, -25, 53, 29.0, 5.87 },
    { 16,  3, 20.59, -25, 51, 55.1, 5.00 },
    {  9,  8,  2.90, -25, 51, 29.9, 4.58 },
    {  6, 27, 11.21, -25, 51, 24.1, 6.07 },
    {  2, 24, 20.11, -25, 50, 51.0, 6.44 },
    { 14, 19,   .79, -25, 48, 56.2, 5.87 },
    { 15,  5, 47.69, -25, 47, 22.9, 6.67 },
    { 20, 49, 17.59, -25, 46, 53.0, 5.86 },
    {  6, 50, 36.89, -25, 46, 41.2, 6.33 },
    { 15, 50, 58.70, -25, 45,  5.0, 4.64 },
    {  4, 21, 31.30, -25, 43, 41.9, 6.01 },
    {  4, 55, 30.19, -25, 43, 40.1, 6.72 },
    { 11, 54, 42.50, -25, 42, 50.0, 5.30 },
    { 23,  0, 24.60, -25, 37, 36.1, 6.29 },
    { 14, 47, 22.51, -25, 37, 27.8, 5.63 },
    {  3, 31, 53.90, -25, 36, 51.1, 6.38 },
    { 18, 18, 41.69, -25, 36, 16.9, 6.51 },
    { 16, 21, 11.30, -25, 35, 34.1, 2.89 },
    {  3, 22, 16.30, -25, 35, 16.1, 6.35 },
    {  6, 23, 55.90, -25, 34, 40.1, 5.63 },
    {  0, 27, 14.71, -25, 32, 49.9, 5.98 },
    { 16, 46, 51.29, -25, 31, 43.0, 6.71 },
    {  9,  3,  8.81, -25, 30, 15.8, 6.74 },
    {  7, 43, 39.10, -25, 30, 14.0, 6.55 },
    { 13, 44, 45.70, -25, 30,  2.9, 6.21 },
    { 16, 14, 53.59, -25, 28, 36.8, 6.05 },
    { 18,  8, 54.10, -25, 28, 21.0, 6.61 },
    { 14, 46,   .10, -25, 26, 35.2, 4.94 },
    { 18, 27, 58.20, -25, 25, 18.1, 2.81 },
    {  6,  1, 13.10, -25, 25,  4.1, 6.05 },
    {  6, 58, 35.90, -25, 24, 50.0, 5.59 },
    {  8, 45, 49.30, -25, 23, 15.0, 6.10 },
    {  7, 38, 18.00, -25, 21, 52.9, 4.70 },
    { 23, 49, 49.61, -25, 19, 53.0, 6.42 },
    { 15, 53, 36.70, -25, 19, 37.9, 4.59 },
    { 10,  3, 41.40, -25, 19,   .1, 6.70 },
    { 15, 13, 28.70, -25, 18, 33.1, 6.45 },
    {  9, 37,   .19, -25, 17, 48.1, 5.70 },
    { 15,  4,  4.20, -25, 16, 54.8, 3.29 },
    {  2, 59, 36.10, -25, 16, 27.1, 5.71 },
    { 20, 46,  5.69, -25, 16, 14.9, 4.14 },
    { 19, 15, 32.40, -25, 15, 24.1, 4.85 },
    { 18, 29, 22.01, -25, 15, 23.0, 6.59 },
    { 17, 12, 13.61, -25, 15, 16.9, 6.54 },
    { 15, 54, 39.50, -25, 14, 37.0, 5.87 },
    {  7,  9, 42.89, -25, 13, 52.0, 5.69 },
    {  7, 25, 25.30, -25, 13,  4.1, 5.78 },
    {  7,  1,  5.90, -25, 12, 55.1, 5.63 },
    {  2, 30, 13.80, -25, 11, 11.0, 6.51 },
    { 18, 19, 58.00, -25, 11,  3.0,      },
    { 22, 13, 44.40, -25, 10, 50.9, 5.58 },
    { 23,  0,  5.81, -25,  9, 51.1, 5.65 },
    { 16, 30, 12.41, -25,  6, 54.0, 4.79 },
    { 20, 37, 52.10, -25,  6, 32.0, 6.36 },
    { 21, 41, 46.10, -25,  6,  6.8, 6.49 },
    { 16, 59, 57.60, -25,  5, 30.8, 5.86 },
    {  1, 45, 38.81, -25,  3,  9.0, 5.31 },
    {  1, 38, 49.99, -25,  1, 18.8, 6.70 },
    { 18, 44, 49.61, -25,  0, 40.0, 5.83 },
    { 14,  0,   .10, -25,  0, 37.1, 5.77 },
    { 21,  7,  7.70, -25,  0, 20.9, 4.50 },
    { 17, 22,   .60, -24, 59, 57.8, 3.27 },
    { 14, 43, 13.61, -24, 59, 51.0, 5.73 },
    { 17,  0,  9.50, -24, 59, 21.1, 5.75 },
    { 13, 58, 31.10, -24, 58, 19.9, 5.15 },
    {  7,  6, 52.30, -24, 57, 38.2, 6.08 },
    {  7, 18, 42.41, -24, 57, 15.1, 4.40 },
    { 20, 32, 52.39, -24, 56, 38.0, 6.36 },
    { 19,  0, 24.79, -24, 56, 31.9, 6.36 },
    { 18, 21, 31.39, -24, 54, 54.0, 6.25 },
    {  7, 49,  1.70, -24, 54, 43.9, 5.33 },
    {  4, 23,  5.71, -24, 53, 31.9, 5.83 },
    { 17, 54, 54.00, -24, 53, 13.9, 6.20 },
    { 19, 36, 42.41, -24, 53,  1.0, 4.60 },
    { 18, 58, 20.50, -24, 52, 36.1, 6.62 },
    {  7, 49, 17.71, -24, 51, 34.9, 3.34 },
    { 12, 47, 53.71, -24, 51,  6.1, 6.44 },
    { 19,  2, 27.70, -24, 50, 48.8, 5.65 },
    { 12, 23, 21.60, -24, 50, 26.2, 5.68 },
    { 15, 58, 34.80, -24, 49, 53.0, 5.43 },
    { 14, 24, 48.60, -24, 48, 23.0, 5.32 },
    {  0, 53, 12.41, -24, 46, 36.8, 6.46 },
    {  5, 21, 46.20, -24, 46, 23.2, 5.06 },
    {  0, 37, 20.71, -24, 46,  1.9, 5.57 },
    { 22, 23, 30.91, -24, 45, 45.0, 5.53 },
    { 23, 56, 29.90, -24, 44, 13.9, 6.31 },
    { 12,  8, 24.79, -24, 43, 44.0, 4.02 },
    { 16,  3, 54.70, -24, 43, 35.0, 6.21 },
    { 11, 39,   .41, -24, 43, 16.0, 6.42 },
    { 19, 36,  1.70, -24, 43,  9.1, 5.65 },
    {  7, 33,  9.70, -24, 42, 38.9, 5.85 },
    {  9, 36, 33.70, -24, 42, 10.1, 6.53 },
    {  7, 44, 34.01, -24, 40, 26.0, 5.62 },
    { 19,  8, 14.59, -24, 39, 24.8, 6.30 },
    { 14, 54, 20.11, -24, 38, 31.9, 5.30 },
    {  6, 57, 33.91, -24, 37, 50.2, 5.46 },
    {  3, 53, 42.60, -24, 36, 45.0, 4.65 },
    {  8, 33,  4.80, -24, 36, 23.0, 6.19 },
    { 21, 32, 33.31, -24, 35, 26.2, 6.43 },
    {  2, 49, 51.00, -24, 33, 37.1, 6.14 },
    {  7, 18, 40.30, -24, 33, 32.0, 4.98 },
    {  6, 53, 55.30, -24, 32, 21.1, 6.21 },
    { 15, 53, 53.81, -24, 31, 59.2, 5.39 },
    {  7, 51,   .00, -24, 31, 41.9, 6.45 },
    { 19, 25, 16.51, -24, 30, 31.0, 5.03 },
    { 15, 33,  9.10, -24, 29, 21.8, 7.00 },
    {  4, 40,  6.79, -24, 28, 57.0, 5.58 },
    { 16, 41, 36.19, -24, 28,  5.2, 6.09 },
    { 11, 29, 38.59, -24, 27, 47.9, 5.76 },
    { 16,  7, 51.89, -24, 27, 42.8, 6.33 },
    { 16, 13, 45.70, -24, 25, 18.8, 6.41 },
    { 13, 51, 20.40, -24, 23, 26.9, 6.45 },
    {  5,  3, 53.30, -24, 23, 16.1, 5.61 },
    { 14, 12, 24.50, -24, 21, 51.1, 6.34 },
    { 18,  3, 52.39, -24, 21, 38.2, 5.97 },
    {  2,  9, 34.80, -24, 20, 44.9, 6.48 },
    {  8,  7, 32.59, -24, 18, 15.1, 2.81 },
    { 17, 18,   .70, -24, 17, 12.8, 5.20 },
    { 10,  4, 21.00, -24, 17,  8.2, 5.70 },
    { 17, 18,   .50, -24, 17,  3.1, 6.80 },
    { 18,  2, 51.10, -24, 16, 55.9, 5.34 },
    { 14, 49, 18.70, -24, 15,  6.1, 5.68 },
    { 17, 25,  6.19, -24, 14, 37.0, 6.19 },
    { 23, 53, 20.81, -24, 13, 45.1, 6.24 },
    { 18, 34, 32.81, -24, 13, 21.0, 6.51 },
    {  6,  5, 45.70, -24, 11, 44.2, 6.95 },
    {  6, 54,  7.90, -24, 11,  2.0, 3.87 },
    { 19, 15, 33.19, -24, 10, 45.1, 6.25 },
    { 17, 26, 22.20, -24, 10, 31.1, 4.17 },
    { 16, 20, 38.21, -24, 10,  9.8, 4.55 },
    { 23, 41,  7.01, -24,  9, 37.1, 6.60 },
    {  0,  3,  7.70, -24,  8, 43.1, 6.44 },
    {  0, 49, 13.90, -24,  8, 11.0, 5.90 },
    {  3, 19, 34.80, -24,  7, 23.2, 5.61 },
    {  4, 26, 57.00, -24,  4, 53.0, 6.11 },
    {  6, 49, 43.99, -24,  4, 32.9, 6.33 },
    {  8, 25,  3.70, -24,  2, 46.0, 5.28 },
    {  7,  8, 49.30, -24,  2, 39.1, 6.65 },
    { 18, 33, 53.50, -24,  1, 57.0, 5.49 },
    {  3, 59, 55.51, -24,  0, 59.0, 4.66 },
    { 15, 13, 17.50, -24,  0, 29.9, 6.47 },
    {  0, 52, 40.61, -24,  0, 20.9, 5.46 },
    {  1,  7, 13.10, -23, 59, 47.0, 6.37 },
    {  1,  6,  7.70, -23, 59, 33.0, 6.14 },
    { 22, 35, 36.50, -23, 59, 28.0, 5.97 },
    { 15, 53, 55.80, -23, 58, 41.2, 5.42 },
    { 17, 31, 25.01, -23, 57, 46.1, 4.81 },
    { 19, 25, 29.69, -23, 57, 43.9, 5.43 },
    {  9, 59,  6.10, -23, 57,  1.1, 6.21 },
    { 19, 54, 17.71, -23, 56, 28.0, 6.18 },
    {  6, 54, 13.01, -23, 55, 41.9, 6.91 },
    {  9, 42, 14.40, -23, 54, 56.2, 4.94 },
    {  3, 47, 39.60, -23, 52, 28.9, 5.24 },
    {  6, 13, 45.10, -23, 51, 42.8, 6.39 },
    {  2, 57, 23.71, -23, 51, 42.8, 5.45 },
    {  7,  7, 22.61, -23, 50, 25.1, 5.71 },
    { 18, 41, 51.60, -23, 49, 59.9, 6.23 },
    {  7,  3,  1.49, -23, 49, 59.9, 3.02 },
    {  8, 55, 55.90, -23, 49,  5.9, 6.39 },
    { 15, 40, 16.90, -23, 49,  5.2, 4.96 },
    {  2, 22, 32.59, -23, 48, 59.0, 5.20 },
    { 17, 59, 47.59, -23, 48, 58.0, 4.76 },
    {  0, 40, 32.90, -23, 48, 15.8, 6.14 },
    {  0, 30, 22.70, -23, 47, 16.1, 5.19 },
    { 20, 53,  1.20, -23, 46, 59.2, 6.33 },
    {  7, 37, 16.80, -23, 46, 30.0, 6.37 },
    { 20, 40, 11.69, -23, 46, 26.0, 6.37 },
    { 10, 34,   .91, -23, 44, 43.1, 5.08 },
    { 23,  6, 40.90, -23, 44, 35.2, 4.47 },
    {  7, 15, 47.50, -23, 44, 26.2, 6.32 },
    {  3, 10, 35.40, -23, 44, 17.9, 6.38 },
    {  7, 26, 40.70, -23, 42, 43.9, 6.56 },
    { 10, 21, 28.70, -23, 42, 38.9, 6.50 },
    { 18, 11, 43.39, -23, 42,  4.0, 4.98 },
    { 12, 30, 17.50, -23, 41, 48.1, 5.63 },
    {  6, 39, 36.31, -23, 41, 44.2, 6.05 },
    { 16,  8, 43.70, -23, 41,  8.2, 5.88 },
    { 22, 26, 10.70, -23, 40, 57.0, 6.29 },
    {  3, 21, 24.00, -23, 38,  7.1, 5.52 },
    {  3,  2, 23.50, -23, 37, 27.8, 4.09 },
    { 16,  6,  6.29, -23, 36, 23.0, 5.92 },
    {  2, 58,  5.71, -23, 36, 22.0, 5.84 },
    { 12, 11,  3.91, -23, 36,  9.0, 5.46 },
    {  9, 41, 16.99, -23, 35, 30.1, 4.77 },
    { 18, 38, 30.70, -23, 30, 18.0, 5.81 },
    {  7, 34, 19.10, -23, 28, 28.9, 5.87 },
    {  7, 34, 18.60, -23, 28, 25.0, 5.83 },
    {  6, 45, 23.30, -23, 27, 42.8, 6.05 },
    { 21, 35, 15.91, -23, 27, 15.1, 6.40 },
    { 13, 41, 30.91, -23, 26, 58.9, 6.59 },
    { 16, 25, 35.21, -23, 26, 49.9, 5.02 },
    { 16, 25, 35.11, -23, 26, 46.0, 5.92 },
    { 19, 40,  7.10, -23, 25, 43.0, 5.97 },
    { 19, 39, 49.39, -23, 25, 40.1, 6.34 },
    {  6, 31, 51.31, -23, 25,  5.9, 4.33 },
    { 12, 34, 23.21, -23, 23, 48.1, 2.65 },
    {  0, 49, 33.41, -23, 21, 42.1, 6.28 },
    { 12, 15, 46.99, -23, 21, 13.0, 6.54 },
    {  9, 29, 49.90, -23, 20, 43.1, 6.24 },
    {  7, 16, 36.79, -23, 18, 56.2, 4.79 },
    {  7, 59,  5.71, -23, 18, 38.2, 5.11 },
    { 13, 29, 42.79, -23, 16, 53.0, 4.97 },
    { 21, 42,   .79, -23, 15, 46.1, 5.24 },
    {  3, 46, 50.90, -23, 14, 58.9, 4.23 },
    {  5, 56, 34.51, -23, 12, 56.2, 6.36 },
    {  9, 10, 22.99, -23, 10, 36.1, 6.53 },
    { 10, 34, 57.70, -23, 10, 34.0, 6.10 },
    { 18, 56,   .60, -23, 10, 25.0, 5.93 },
    { 13, 18, 55.30, -23, 10, 18.1, 3.00 },
    {  8, 24, 55.10, -23,  9, 13.0, 5.68 },
    { 14, 46,  6.79, -23,  9, 11.2, 5.81 },
    { 15, 39, 21.29, -23,  9,  1.1, 6.34 },
    { 16, 56, 48.00, -23,  9,   .0, 5.58 },
    { 15, 37, 48.10, -23,  8, 30.1, 5.78 },
    { 22, 16, 59.81, -23,  8, 24.0, 6.17 },
    { 13,  9,  3.29, -23,  7,  5.2, 4.95 },
    {  6,  6, 31.99, -23,  6, 38.2, 5.47 },
    {  0,  6, 50.11, -23,  6, 27.0, 6.18 },
    {  7, 26, 59.40, -23,  5, 10.0, 5.61 },
    {  8, 28, 35.90, -23,  4, 18.1, 6.51 },
    {  7, 29, 51.41, -23,  1, 27.8, 4.85 },
    { 13, 57, 27.70, -23,  1, 22.1, 6.14 },
    {  5, 49, 53.50, -22, 58, 18.1, 5.87 },
    {  4, 18, 37.39, -22, 58, 13.1, 6.07 },
    {  6, 35,  3.41, -22, 57, 52.9, 4.54 },
    {  6, 55, 46.80, -22, 56, 29.0, 5.30 },
    {  5, 51, 28.61, -22, 55, 34.0, 6.17 },
    {  8, 20, 27.41, -22, 55, 28.9, 6.13 },
    {  7, 24, 17.21, -22, 54, 46.1, 6.19 },
    {  7, 13, 48.29, -22, 54, 23.0, 6.36 },
    {  7, 56, 51.50, -22, 52, 48.0, 4.20 },
    {  9, 33, 26.21, -22, 51, 50.0, 5.91 },
    {  7, 27, 42.89, -22, 51, 34.9, 5.95 },
    {  7, 20, 53.21, -22, 51,  6.1, 6.61 },
    {  0, 36,  6.91, -22, 50, 33.0, 6.06 },
    {  5, 56, 14.30, -22, 50, 25.1, 5.96 },
    { 11, 11, 39.50, -22, 49, 32.9, 4.48 },
    {  5,  2, 44.90, -22, 47, 42.0, 5.75 },
    { 23,  1, 22.99, -22, 47, 26.9, 6.28 },
    { 18,  1, 54.41, -22, 46, 50.2, 5.77 },
    {  6,  9, 47.90, -22, 46, 27.1, 5.71 },
    { 12, 57, 33.19, -22, 45, 14.0, 6.31 },
    { 21, 24,  7.90, -22, 44, 48.8, 6.38 },
    { 18, 54, 10.20, -22, 44, 42.0, 4.83 },
    { 20,  1, 23.90, -22, 44, 13.9, 6.01 },
    { 18,  3,  1.70, -22, 43,  5.9, 6.74 },
    {  6, 17,  3.50, -22, 42, 54.0, 6.07 },
    { 19,  1, 37.80, -22, 41, 44.2, 6.24 },
    {  2, 29, 55.39, -22, 40, 58.1, 6.77 },
    {  7, 13, 23.90, -22, 40, 23.9, 6.01 },
    { 18, 55,  7.10, -22, 40, 17.0, 4.99 },
    { 21, 23,   .50, -22, 40,  8.0, 5.60 },
    {  8, 39,  7.99, -22, 39, 42.8, 5.05 },
    { 16,  0, 19.99, -22, 37, 18.1, 2.32 },
    { 12, 10,  7.49, -22, 37, 10.9, 3.00 },
    {  6, 36, 40.90, -22, 36, 54.0, 6.35 },
    { 20,  3, 44.30, -22, 35, 44.2, 6.45 },
    {  2, 30, 32.81, -22, 32, 44.2, 6.10 },
    { 18, 58, 24.60, -22, 31, 45.8, 6.14 },
    { 10, 21, 36.00, -22, 31, 41.9, 6.51 },
    {  1, 56, 40.20, -22, 31, 36.8, 4.85 },
    {  0, 46, 11.81, -22, 31, 18.8, 5.50 },
    {  7, 47, 12.50, -22, 31, 10.9, 5.90 },
    {  3, 18, 22.10, -22, 30, 41.0, 4.88 },
    {  0,  7, 46.80, -22, 30, 32.0, 5.94 },
    {  9, 54, 31.70, -22, 29, 17.9, 6.24 },
    {  2, 47, 11.21, -22, 29,  8.2, 6.47 },
    { 17, 47, 45.60, -22, 28, 41.2, 6.18 },
    { 23,  9, 54.79, -22, 27, 27.0, 4.69 },
    {  6, 42, 45.79, -22, 26, 57.1, 6.13 },
    {  5, 44, 27.79, -22, 26, 53.9, 3.60 },
    {  6,  8, 57.89, -22, 25, 39.0, 5.50 },
    { 14,  3, 53.11, -22, 25, 18.1, 6.30 },
    {  5, 44, 26.50, -22, 25, 18.1, 6.15 },
    { 21, 26, 40.01, -22, 24, 41.0, 3.74 },
    { 19, 20, 38.11, -22, 24,  9.0, 5.58 },
    { 15, 16, 22.99, -22, 23, 57.8, 5.50 },
    { 18, 46, 20.59, -22, 23, 31.9, 5.37 },
    { 20, 29, 31.30, -22, 23, 30.1, 6.16 },
    {  2, 53, 35.30, -22, 22, 35.0, 5.95 },
    {  5, 42, 13.90, -22, 22, 25.0, 5.87 },
    {  5,  5, 27.70, -22, 22, 16.0, 3.19 },
    {  9, 27, 18.41, -22, 20, 38.0, 4.69 },
    {  7, 41, 23.59, -22, 20, 13.9, 6.18 },
    {  7, 34,  3.19, -22, 17, 46.0, 4.45 },
    { 12, 20, 33.70, -22, 12, 56.9, 5.21 },
    {  6, 57, 14.81, -22, 12, 11.9, 6.61 },
    { 12, 20, 10.70, -22, 10, 32.2, 5.97 },
    { 18, 50, 50.50, -22,  9, 43.9, 6.61 },
    {  7, 36,  7.80, -22,  9, 38.2, 6.34 },
    {  7,  0, 19.30, -22,  7,  9.8, 6.53 },
    { 17, 35, 18.50, -22,  2, 38.0, 6.57 },
    {  7,  4, 47.11, -22,  1, 55.9, 6.09 },
    { 15,  6, 27.10, -22,  1, 54.8, 6.17 },
    {  0, 44, 44.40, -22,  0, 22.0, 5.24 },
    {  7, 25, 19.90, -21, 58, 58.1, 6.05 },
    { 12,  0, 42.50, -21, 50, 13.9, 6.28 },
    {  6,  6, 57.60, -21, 48, 46.1, 5.78 },
    { 20, 18,  1.39, -21, 48, 36.0, 5.87 },
    { 21, 28, 43.39, -21, 48, 25.9, 4.51 },
    { 19, 26, 19.20, -21, 46, 36.1, 5.59 },
    {  3, 19, 31.01, -21, 45, 28.1, 3.69 },
    { 11, 12, 34.61, -21, 44, 57.1, 6.40 },
    { 19,  4, 40.99, -21, 44, 30.1, 3.77 },
    {  0, 48,  1.10, -21, 43, 21.0, 5.57 },
    { 18, 14, 15.91, -21, 42, 47.2, 5.44 },
    { 17, 43, 25.80, -21, 40, 59.9, 4.87 },
    { 19, 12, 28.01, -21, 39, 29.2, 6.41 },
    {  2, 46, 45.19, -21, 38, 22.9, 6.49 },
    {  3, 33, 47.30, -21, 37, 58.1, 4.27 },
    {  1, 29, 36.10, -21, 37, 45.8, 5.12 },
    {  6, 59, 39.29, -21, 36, 11.9, 6.26 },
    { 22, 21, 35.59, -21, 35, 53.9, 5.13 },
    { 17,  6, 11.81, -21, 33, 52.9, 6.30 },
    { 20, 46, 10.01, -21, 30, 51.1, 5.93 },
    { 17, 30, 41.70, -21, 29, 14.0,      },
    { 16, 32,  8.21, -21, 27, 59.0, 4.45 },
    { 18,  7, 11.40, -21, 26, 38.0, 6.28 },
    { 17, 24, 42.00, -21, 26, 30.1, 5.85 },
    { 14, 57, 28.01, -21, 24, 56.2, 5.74 },
    { 18, 37, 54.41, -21, 23, 52.1, 5.94 },
    {  5, 27, 36.50, -21, 22, 32.2, 6.07 },
    { 23, 31, 42.10, -21, 22,  9.8, 6.29 },
    { 18, 54,   .10, -21, 21, 34.9, 5.69 },
    { 14, 47, 13.70, -21, 19, 28.9, 6.06 },
    {  8, 16, 54.19, -21, 19, 13.1, 6.60 },
    { 19, 30, 54.00, -21, 18, 43.9, 6.13 },
    { 16, 16, 58.80, -21, 18, 14.0, 6.61 },
    {  4, 45,  4.20, -21, 17,  1.0, 5.72 },
    {  1, 38, 51.79, -21, 16, 31.1, 5.58 },
    {  5, 20, 26.90, -21, 14, 21.8, 4.71 },
    { 22, 11,  2.40, -21, 13, 57.0, 6.09 },
    { 21, 27, 14.81, -21, 11, 46.0, 5.78 },
    { 21,  8, 33.60, -21, 11, 37.0, 5.30 },
    { 21, 58, 43.80, -21, 10, 58.1, 6.12 },
    { 14, 46, 10.90, -21, 10, 34.0, 6.40 },
    {  7, 51, 42.89, -21, 10, 26.0, 5.63 },
    { 23,  9, 26.81, -21, 10, 21.0, 3.66 },
    {  8, 44, 55.20, -21, 10,  4.1, 6.11 },
    {  9, 33, 12.50, -21,  6, 56.9, 5.01 },
    { 17, 21,   .19, -21,  6, 46.1, 4.39 },
    { 16, 14, 28.80, -21,  6, 27.0, 6.41 },
    { 18, 57, 43.80, -21,  6, 24.1, 3.51 },
    {  2,  0,   .29, -21,  4, 40.1, 4.00 },
    { 22, 14, 18.00, -21,  4, 27.1, 5.32 },
    { 18, 13, 45.79, -21,  3, 32.0, 3.86 },
    { 18, 38, 53.40, -21,  3,  6.8, 5.86 },
    {  8, 49, 44.90, -21,  2, 55.0, 6.47 },
    {  8, 25, 19.10, -21,  2, 44.9, 6.01 },
    { 19,  9, 45.79, -21,  1, 25.0, 2.89 },
    { 15, 38, 16.30, -21,  0, 58.0, 5.84 },
    {  6, 47,  1.49, -21,  0, 56.2, 6.08 },
    {  2, 51,  2.30, -21,  0, 15.1, 4.75 },
    { 18, 45, 18.70, -21,  0,  5.0, 6.36 },
    {  2, 13,   .89, -21,  0,  1.1, 5.86 },
    { 15, 57, 40.39, -20, 58, 59.2, 5.85 },
    {  8, 28, 53.30, -20, 57,  1.1, 6.67 },
    {  6, 18, 58.99, -20, 55, 34.0, 5.81 },
    {  6, 33, 26.59, -20, 55, 26.0, 6.40 },
    { 23, 33, 16.61, -20, 54, 51.8, 4.71 },
    {  3, 48, 35.81, -20, 54, 11.2, 5.81 },
    {  7, 11, 41.59, -20, 52, 59.2, 5.84 },
    {  5, 51, 19.30, -20, 52, 45.1, 3.81 },
    { 23,  2, 44.30, -20, 52, 14.2, 5.97 },
    { 16,  7, 24.31, -20, 52,  7.0, 4.32 },
    {  5, 31,  7.61, -20, 51, 49.0, 5.55 },
    { 21, 24,  9.60, -20, 51,  6.8, 5.41 },
    { 12, 14, 59.59, -20, 50, 39.1, 5.83 },
    {  8, 27, 33.29, -20, 50, 38.0, 6.56 },
    { 18, 35, 21.29, -20, 50, 26.9, 6.48 },
    {  1, 59, 46.10, -20, 49, 27.8, 5.41 },
    { 11, 31, 47.59, -20, 46, 36.1, 6.24 },
    {  5, 28, 14.69, -20, 45, 33.8, 2.84 },
    {  9, 29, 12.60, -20, 44, 55.0, 5.66 },
    { 15, 30, 36.29, -20, 43, 41.9, 6.22 },
    { 18, 15, 12.89, -20, 43, 41.9, 5.38 },
    {  4, 18, 15.91, -20, 42, 56.2, 6.00 },
    { 22, 34, 41.59, -20, 42, 29.9, 5.20 },
    { 10, 16, 45.60, -20, 40, 14.2, 6.57 },
    { 16,  6, 48.41, -20, 40,  9.1, 3.96 },
    { 10, 55, 11.59, -20, 39, 54.0, 6.44 },
    { 18, 57, 20.50, -20, 39, 23.0, 5.08 },
    { 21, 15, 37.90, -20, 39,  6.1, 5.24 },
    { 23, 26,  2.81, -20, 38, 30.8, 4.39 },
    {  4, 20, 39.00, -20, 38, 22.9, 5.38 },
    { 13,  3, 46.10, -20, 34, 59.2, 5.58 },
    { 21,  9, 33.00, -20, 33, 23.0, 6.25 },
    {  8,  7, 18.00, -20, 33, 16.9, 5.38 },
    { 18, 25, 21.00, -20, 32, 30.1, 4.81 },
    { 12, 35, 58.61, -20, 31, 37.9, 6.20 },
    {  4,  5, 46.70, -20, 30, 43.9, 6.34 },
    { 17,  4, 45.31, -20, 29, 40.9, 6.30 },
    { 14, 34, 50.69, -20, 26, 21.1, 6.50 },
    { 16, 53, 25.20, -20, 24, 56.2, 5.88 },
    { 16, 40, 34.51, -20, 24, 31.0, 6.26 },
    {  6, 55,  2.71, -20, 24, 16.9, 5.74 },
    { 18, 15, 12.89, -20, 23, 17.2, 5.95 },
    {  4,  4, 40.99, -20, 22, 54.1, 6.13 },
    {  8,  8, 43.51, -20, 21, 47.2, 6.36 },
    {  4, 11, 36.19, -20, 21, 22.0, 5.79 },
    { 18,  0,   .10, -20, 20, 21.1, 6.21 },
    {  0, 28, 21.10, -20, 20,  6.0, 6.43 },
    { 18, 49, 40.10, -20, 19, 28.9, 5.24 },
    { 11, 42,  3.50, -20, 17, 38.0, 6.22 },
    {  6, 15,  8.40, -20, 16, 19.9, 5.91 },
    {  6, 53, 32.90, -20, 13, 27.1, 4.83 },
    { 16, 19,  7.70, -20, 13,  4.1, 6.29 },
    {  0, 16, 42.50, -20, 12, 38.2, 6.47 },
    {  7, 49, 45.19, -20, 12, 24.8, 6.56 },
    { 15, 53, 20.11, -20, 10,  1.9, 5.03 },
    { 15, 31, 43.39, -20,  9, 52.9, 6.22 },
    {  7,  0,  8.11, -20,  9, 32.0, 6.31 },
    {  4,  3, 36.79, -20,  9, 29.9, 7.01 },
    {  4,  3, 24.70, -20,  8, 39.1, 6.46 },
    { 10, 53, 29.50, -20,  8, 20.0, 5.24 },
    {  6, 55, 37.39, -20,  8, 11.0, 4.68 },
    {  5, 44, 28.39, -20,  7, 35.0, 6.34 },
    { 23, 22, 58.20, -20,  6,  2.2, 3.97 },
    { 21, 34, 51.00, -20,  5,  3.8, 5.69 },
    {  8, 21, 21.19, -20,  4, 45.1, 5.58 },
    {  0, 21, 46.30, -20,  3, 28.1, 5.12 },
    {  5,  1, 25.61, -20,  3,  6.8, 4.91 },
    {  0,  2, 57.60, -20,  2, 46.0, 6.25 },
    {  2, 26, 35.21, -20,  2, 34.1, 5.88 },
    { 16, 24,  6.19, -20,  2, 15.0, 4.50 },
    {  2, 33, 40.20, -20,  0,  6.8, 6.21 },
    { 14, 25, 29.81, -19, 58, 10.9, 6.61 },
    {  6, 18, 13.70, -19, 58,   .8, 5.52 },
    { 13, 15, 58.80, -19, 56, 35.2, 5.22 },
    { 13, 14, 10.90, -19, 55, 50.9, 5.33 },
    { 16, 41, 53.71, -19, 55, 27.8, 5.57 },
    {  4, 35,   .50, -19, 55, 14.2, 6.13 },
    { 13, 50, 34.51, -19, 53, 49.9, 6.53 },
    { 10, 22, 12.91, -19, 52,   .8, 6.13 },
    { 21,  4, 24.31, -19, 51, 18.0, 4.84 },
    { 18, 11, 14.81, -19, 50, 31.9, 6.36 },
    { 16,  5, 26.21, -19, 48, 20.2, 2.62 },
    { 19,  9, 48.10, -19, 48, 13.0, 6.13 },
    { 16,  5, 26.50, -19, 48,  6.8, 4.92 },
    { 12, 33, 22.39, -19, 47, 30.8, 6.26 },
    { 15, 12, 13.30, -19, 47, 30.1, 4.54 },
    {  6, 23, 47.59, -19, 47,  7.1, 6.60 },
    { 19, 46, 21.70, -19, 45, 40.0, 4.86 },
    { 12, 41, 49.20, -19, 45, 31.0, 6.03 },
    {  9, 11, 58.70, -19, 44, 52.1, 5.73 },
    {  8, 38, 40.30, -19, 44, 12.8, 6.33 },
    {  8,  4, 41.50, -19, 43, 41.2, 6.13 },
    {  7, 36, 40.99, -19, 42,  7.9, 5.74 },
    {  5, 25, 59.81, -19, 41, 44.2, 5.89 },
    { 15, 41, 56.81, -19, 40, 44.0, 4.74 },
    {  4, 40, 26.50, -19, 40, 18.1, 4.32 },
    { 15, 32, 36.70, -19, 40, 14.2, 5.52 },
    {  7, 40, 13.61, -19, 39, 38.9, 5.93 },
    { 12,  0, 51.19, -19, 39, 32.0, 5.26 },
    { 15, 13, 19.20, -19, 38, 51.0, 6.08 },
    {  5, 53, 57.41, -19, 38, 17.9, 6.69 },
    { 21, 43, 13.49, -19, 37, 14.9, 6.22 },
    { 22, 47, 33.10, -19, 36, 47.9, 5.26 },
    { 18, 46,  1.20, -19, 36, 23.0, 6.42 },
    {  3, 41, 22.39, -19, 35,  4.9, 6.59 },
    {  9, 35, 33.70, -19, 35,  1.0, 6.31 },
    {  8, 31, 30.91, -19, 34, 39.0, 5.42 },
    { 16, 57,  4.01, -19, 32, 24.0, 6.27 },
    {  7, 50,  5.71, -19, 31, 25.0, 6.12 },
    { 13, 21, 29.90, -19, 29, 20.0, 6.21 },
    { 21, 37,  4.80, -19, 27, 58.0, 4.68 },
    { 16, 11, 59.69, -19, 27, 38.2, 4.01 },
    {  4, 28, 39.00, -19, 27, 29.9, 5.96 },
    { 16, 11, 58.61, -19, 26, 58.9, 6.30 },
    {  7, 33, 19.51, -19, 24, 45.0, 5.66 },
    {  9, 32, 20.40, -19, 24,  1.1, 5.74 },
    { 15, 55,   .31, -19, 22, 59.2, 5.94 },
    { 17, 20, 34.20, -19, 19, 58.1, 6.52 },
    { 15, 38, 54.50, -19, 18,  6.8, 5.38 },
    { 19,  8, 16.70, -19, 17, 24.0, 5.54 },
    { 18, 42, 55.20, -19, 17,  2.0, 6.35 },
    {  7, 19,  1.99, -19, 16, 49.1, 6.09 },
    {  6, 36, 40.99, -19, 15, 20.9, 3.95 },
    { 19,  3,  3.79, -19, 14, 43.1, 6.05 },
    {  8,  9,  1.61, -19, 14, 42.0, 4.40 },
    { 19, 21, 37.10, -19, 14,  3.1, 6.26 },
    {  8, 59, 39.89, -19, 12, 29.2, 6.18 },
    {  6,  7, 41.59, -19,  9, 56.9, 5.31 },
    { 10, 12, 37.80, -19,  9, 13.0, 6.44 },
    { 21, 29, 59.59, -19,  8, 52.1, 6.57 },
    { 18, 49, 35.50, -19,  8, 31.9, 6.75 },
    { 18, 31, 53.30, -19,  7, 30.0, 6.68 },
    { 20, 19, 23.59, -19,  7,  7.0, 5.28 },
    { 19,  3,  7.01, -19,  6, 11.9, 6.37 },
    {  1, 22, 30.50, -19,  4, 53.0, 6.35 },
    {  0, 17, 32.59, -19,  3,  4.0, 6.45 },
    { 19, 52, 12.00, -19,  2, 42.0, 5.92 },
    { 20, 59, 36.10, -19,  2,  7.1, 6.25 },
    {  6, 53, 18.79, -19,  1, 58.1, 5.64 },
    {  7, 22, 13.51, -19,  1,   .1, 4.96 },
    {  7, 24, 50.71, -19,  0, 43.9, 6.24 },
    {  9, 54, 52.20, -19,  0, 33.8, 4.94 },
    { 19, 17, 38.11, -18, 57, 11.2, 4.96 },
    {  6, 53, 21.70, -18, 55, 59.9, 6.14 },
    {  0, 14, 38.40, -18, 55, 58.1, 4.44 },
    { 23, 51, 21.29, -18, 54, 32.0, 5.18 },
    { 17,  1, 51.19, -18, 53,  8.2, 6.26 },
    { 21, 42, 39.50, -18, 51, 59.0, 4.73 },
    { 18, 21, 23.11, -18, 51, 36.0, 5.75 },
    { 19, 36, 26.11, -18, 51, 10.1, 6.11 },
    { 22, 43, 35.30, -18, 49, 49.1, 4.69 },
    { 13, 13, 26.81, -18, 49, 36.1, 6.28 },
    { 17, 55, 55.01, -18, 48,  7.9, 6.52 },
    { 11, 23, 21.89, -18, 46, 48.0, 5.09 },
    { 19,  7,  8.50, -18, 44, 16.1, 6.29 },
    { 18, 30, 11.90, -18, 43, 44.0, 5.66 },
    { 13, 32,  2.81, -18, 43, 44.0, 6.01 },
    { 14, 18, 38.30, -18, 42, 58.0, 5.90 },
    { 23, 24,  7.80, -18, 41, 15.0, 6.19 },
    {  7, 10,  9.29, -18, 41,  7.1, 6.23 },
    {  7, 39,  7.10, -18, 40, 45.1, 6.72 },
    { 23, 46,   .91, -18, 40, 41.2, 5.29 },
    {  4, 44,  7.99, -18, 40,   .1, 5.53 },
    { 18, 15, 30.79, -18, 39, 41.0, 6.07 },
    {  6, 36, 22.80, -18, 39, 36.0, 5.70 },
    { 21, 51, 41.81, -18, 37, 23.2, 6.16 },
    { 18, 18, 43.30, -18, 37,  9.8, 6.84 },
    { 18, 48, 45.31, -18, 36,  5.0, 6.47 },
    { 20, 29, 52.51, -18, 35, 12.1, 6.74 },
    { 14, 17,  3.79, -18, 35,  7.1, 6.22 },
    { 20, 29, 53.90, -18, 34, 59.9, 5.94 },
    {  2, 45,  6.19, -18, 34, 21.0, 4.47 },
    { 10, 35, 38.90, -18, 34,  9.1, 6.49 },
    { 18, 59, 26.81, -18, 34,   .8, 6.37 },
    {  3, 18, 41.21, -18, 33, 34.9, 5.71 },
    {  5, 43, 21.60, -18, 33, 27.0, 5.73 },
    { 16, 14, 39.10, -18, 32,  7.1, 6.32 },
    {  5, 19, 17.50, -18, 31, 12.0, 6.36 },
    { 22,  8, 58.99, -18, 31, 10.9, 5.81 },
    {  5, 19, 18.29, -18, 30, 34.9, 6.54 },
    { 11, 12, 30.41, -18, 30,   .0, 6.13 },
    {  6, 15, 17.50, -18, 28, 36.1, 5.99 },
    { 18, 17, 28.49, -18, 27, 47.9, 6.54 },
    { 16, 27,  1.39, -18, 27, 23.0, 4.42 },
    { 17, 24, 37.10, -18, 26, 44.9, 6.21 },
    {  3, 53, 13.01, -18, 26,  3.8, 6.22 },
    { 18, 31, 26.30, -18, 24, 10.1, 5.14 },
    {  7, 59, 52.01, -18, 23, 57.1, 4.61 },
    {  2, 22, 57.79, -18, 21, 15.8, 6.22 },
    { 11, 44, 45.79, -18, 21,  2.9, 4.73 },
    { 16,  9, 55.20, -18, 20, 26.9, 6.47 },
    {  9,  9,  4.30, -18, 19, 43.0, 5.73 },
    { 13, 18, 24.31, -18, 18, 41.0, 4.74 },
    { 19, 21, 50.90, -18, 18, 29.9, 5.87 },
    { 10, 59, 46.51, -18, 17, 56.0, 4.08 },
    { 23, 44, 12.10, -18, 16, 36.8, 5.24 },
    { 12, 38, 44.59, -18, 15,  1.1, 6.00 },
    {  8, 55, 12.41, -18, 14, 29.0, 5.75 },
    {  6, 37, 53.40, -18, 14, 15.0, 4.43 },
    { 19, 37,  3.31, -18, 13, 52.0, 5.64 },
    { 20, 27, 19.20, -18, 12, 42.1, 5.25 },
    { 14, 15, 24.10, -18, 12,  2.9, 5.43 },
    { 15, 20, 53.71, -18,  9, 31.0, 6.17 },
    { 20, 40,  3.00, -18,  8, 19.0, 5.10 },
    { 13, 49, 52.30, -18,  8,  3.1, 4.97 },
    {  5, 18, 50.40, -18,  7, 48.0, 5.96 },
    {  6,  9, 20.30, -18,  7, 34.0, 6.35 },
    { 10,  4,  2.90, -18,  6,  6.1, 5.86 },
    { 23, 19, 24.10, -18,  4, 31.1, 5.93 },
    {  0, 47, 43.30, -18,  3, 41.0, 5.70 },
    { 20, 49, 20.50, -18,  2,  8.9, 6.21 },
    { 23, 41, 34.49, -18,  1, 37.9, 5.34 },
    {  0, 43, 35.40, -17, 59, 12.1, 2.04 },
    { 21, 17, 57.29, -17, 59,  7.1, 5.43 },
    { 10, 21,  7.80, -17, 59,  6.0, 6.51 },
    {  6, 22, 42.00, -17, 57, 20.9, 1.98 },
    {  0, 12, 10.01, -17, 56, 17.9, 5.25 },
    { 20, 54, 47.90, -17, 55, 23.2, 5.78 },
    { 22,  2, 11.90, -17, 54, 13.0, 6.28 },
    {  7, 27,  7.99, -17, 51, 51.8, 5.63 },
    { 13, 47, 25.39, -17, 51, 36.0, 5.43 },
    {  5, 39, 16.30, -17, 50, 57.8, 6.38 },
    { 19, 21, 40.39, -17, 50, 49.9, 3.93 },
    {  5, 32, 43.80, -17, 49, 19.9, 2.58 },
    { 23, 41, 45.79, -17, 48, 59.0, 4.82 },
    { 20, 28, 51.60, -17, 48, 49.0, 4.78 },
    { 18, 27, 56.50, -17, 48,   .0, 6.20 },
    {  2,  8, 45.70, -17, 46, 45.8, 6.10 },
    { 15, 14, 33.70, -17, 46,  7.0, 6.17 },
    {  6, 12, 46.30, -17, 45, 47.2, 6.52 },
    { 17, 19, 53.30, -17, 45, 23.0, 6.02 },
    { 16, 41, 34.39, -17, 44, 31.9, 4.96 },
    { 13, 23,  1.10, -17, 44,  7.1, 5.37 },
    { 11, 24, 52.90, -17, 41,  2.0, 4.08 },
    {  2, 22,  4.99, -17, 39, 43.9, 5.87 },
    { 17,  8, 14.90, -17, 36, 33.1, 5.99 },
    {  8, 21, 54.60, -17, 35, 11.0, 5.75 },
    {  0,  8, 33.41, -17, 34, 39.0, 6.06 },
    { 12, 15, 48.41, -17, 32, 30.8, 2.59 },
    {  5, 42, 14.30, -17, 31, 49.1, 6.15 },
    {  3, 36, 17.40, -17, 28,   .8, 5.23 },
    {  6, 28, 37.30, -17, 27, 58.0, 5.77 },
    { 21, 18, 15.70, -17, 27, 43.9, 7.05 },
    { 21,  7, 44.59, -17, 27, 19.1, 6.17 },
    {  8, 25, 39.41, -17, 26, 21.8, 6.44 },
    {  0,  7, 18.19, -17, 23, 11.0, 6.19 },
    { 18, 17, 11.59, -17, 22, 26.0, 5.75 },
    { 21, 15,  6.60, -17, 20, 42.0, 6.04 },
    {  0,  3, 44.40, -17, 20, 10.0, 4.55 },
    { 10, 46, 52.01, -17, 17, 48.1, 5.42 },
    { 21,  5, 56.81, -17, 13, 58.1, 4.07 },
    {  7, 49, 41.21, -17, 13, 41.9, 5.18 },
    { 18,  1, 23.11, -17,  9, 24.8, 6.28 },
    { 18,  7, 48.41, -17,  9, 15.1, 5.52 },
    { 11, 56,   .91, -17,  9,  2.9, 5.18 },
    {  5, 16, 48.10, -17,  8, 30.1, 6.56 },
    { 10,  7,  9.50, -17,  8, 30.1, 5.60 },
    {  6, 50, 21.89, -17,  5,  2.0, 5.79 },
    { 23,  5, 12.79, -17,  4, 45.1, 6.14 },
    {  6, 56,  8.21, -17,  3, 15.1, 4.37 },
    {  5, 24, 28.39, -16, 58, 34.0, 5.65 },
    { 22,  2, 26.59, -16, 57, 51.1, 6.37 },
    {  4, 47, 36.31, -16, 56,  3.8, 5.51 },
    {  1, 52, 52.10, -16, 55, 45.1, 5.80 },
    { 10, 38, 34.99, -16, 52, 36.1, 4.91 },
    {  6, 38, 35.40, -16, 52, 25.0, 6.03 },
    { 15, 32, 55.20, -16, 51, 10.1, 5.50 },
    { 21, 50, 13.10, -16, 50, 40.9, 6.38 },
    { 10, 26,  5.40, -16, 50, 11.0, 3.81 },
    { 21, 22, 14.81, -16, 50,  3.8, 4.28 },
    {  6, 17, 41.71, -16, 48, 56.9, 5.14 },
    { 16, 56,  1.80, -16, 48, 22.0, 6.37 },
    { 22, 26, 34.39, -16, 44, 33.0, 6.35 },
    { 22, 26, 34.20, -16, 44, 29.0, 6.57 },
    {  4, 55,  6.79, -16, 44, 26.2, 5.70 },
    { 15, 53, 49.51, -16, 43, 45.8, 4.15 },
    {  5, 41, 41.50, -16, 43, 32.2, 6.21 },
    { 15, 28, 15.41, -16, 42, 59.0, 5.64 },
    {  6, 45,  8.90, -16, 42, 58.0,-1.46 },
    {  8, 56, 34.10, -16, 42, 33.8, 5.96 },
    { 12, 17,  3.29, -16, 41, 37.0, 6.05 },
    { 21, 40,  5.50, -16, 39, 43.9, 3.68 },
    { 12, 27, 49.39, -16, 37, 54.8, 6.35 },
    { 11, 39, 50.40, -16, 37, 13.1, 6.19 },
    {  6, 16,  7.70, -16, 37,  4.1, 5.92 },
    { 16, 31,  8.30, -16, 36, 46.1, 4.28 },
    { 15, 30, 40.39, -16, 36, 33.8, 5.82 },
    {  4,  4,  8.71, -16, 35, 20.0, 6.39 },
    {  9, 51, 59.59, -16, 32,  4.9, 6.08 },
    { 16,  0, 19.61, -16, 31, 59.9, 5.47 },
    {  0,  4, 19.70, -16, 31, 44.0, 5.78 },
    { 20, 35, 32.21, -16, 31, 32.9, 6.19 },
    {  0, 40, 28.61, -16, 31,   .8, 6.49 },
    { 12, 29, 51.89, -16, 30, 56.2, 2.95 },
    {  6,  4, 59.09, -16, 29,  3.8, 4.93 },
    {  0, 45, 41.69, -16, 25, 27.1, 6.47 },
    {  4, 55, 18.60, -16, 25,  4.1, 5.72 },
    {  7, 19, 28.10, -16, 23, 42.0, 5.70 },
    {  4,  9, 17.81, -16, 23,  8.9, 5.37 },
    { 18, 55, 31.01, -16, 22, 36.1, 5.79 },
    {  4, 59,  1.30, -16, 22, 32.9, 5.66 },
    { 10, 59, 30.91, -16, 21, 14.0, 5.89 },
    { 10, 36, 16.70, -16, 20, 39.8, 6.03 },
    { 14,  5, 13.99, -16, 20,  8.9, 6.56 },
    {  4, 48, 32.50, -16, 19, 45.8, 5.77 },
    { 17, 18, 19.20, -16, 18, 42.8, 6.43 },
    { 14, 10, 50.50, -16, 18,  6.8, 4.91 },
    { 19, 40, 43.39, -16, 17, 35.9, 6.20 },
    {  8, 17, 23.11, -16, 17,  6.0, 6.16 },
    { 11, 33, 14.59, -16, 16, 50.2, 6.05 },
    { 22, 54, 45.50, -16, 16, 18.8, 5.56 },
    { 15,  6, 37.61, -16, 15, 24.8, 5.20 },
    {  8,  9, 28.51, -16, 14, 56.0, 5.68 },
    {  5, 47,  7.61, -16, 14, 16.1, 6.17 },
    {  7,  9, 33.19, -16, 14,  4.9, 6.03 },
    { 19,  6, 52.30, -16, 13, 44.0, 6.03 },
    {  4, 50, 11.59, -16, 13,  1.9, 5.03 },
    {  5, 12, 55.90, -16, 12, 20.2, 3.31 },
    {  7, 24, 40.10, -16, 12,  4.0, 5.33 },
    { 13, 12,  3.50, -16, 11, 55.0, 5.04 },
    { 12, 32,  4.20, -16, 11, 46.0, 4.31 },
    { 10, 49, 37.49, -16, 11, 37.0, 3.11 },
    { 13, 44, 29.81, -16, 10, 45.1, 5.60 },
    {  8, 58, 43.90, -16,  7, 58.1, 5.86 },
    { 21, 47,  2.40, -16,  7, 37.9, 2.87 },
    { 20, 40, 32.50, -16,  7, 27.1, 5.80 },
    { 19, 42, 31.10, -16,  7, 26.0, 5.06 },
    { 14, 50, 52.70, -16,  2, 30.1, 2.75 },
    { 20, 57, 40.61, -16,  1, 54.1, 5.87 },
    {  3, 11, 16.80, -16,  1, 31.1, 6.26 },
    {  7, 47, 45.19, -16,  0, 51.8, 6.43 },
    { 14, 50, 41.21, -15, 59, 49.9, 5.15 },
    {  7, 47, 38.50, -15, 59, 26.9, 6.34 },
    { 13, 27, 27.19, -15, 58, 25.0, 4.76 },
    { 19, 21, 43.61, -15, 57, 18.0, 4.61 },
    {  8, 41, 43.30, -15, 56, 35.9, 4.88 },
    {  1, 44,  4.10, -15, 56, 15.0, 3.50 },
    { 11, 50, 19.51, -15, 51, 50.0, 6.13 },
    { 23, 49, 31.61, -15, 51, 40.0, 6.24 },
    { 23, 58, 21.19, -15, 50, 51.0, 6.26 },
    {  9, 19, 33.19, -15, 50,  3.8, 5.78 },
    { 18, 20,  8.81, -15, 49, 54.1, 5.39 },
    { 22, 54, 39.00, -15, 49, 14.9, 3.27 },
    { 17, 56, 19.01, -15, 48, 45.0, 5.89 },
    { 11,  0, 57.19, -15, 47, 34.1, 6.34 },
    {  8, 13, 19.99, -15, 47, 17.9, 4.99 },
    { 13, 45, 35.11, -15, 46,  3.0, 6.19 },
    { 20, 28, 43.61, -15, 44, 30.1, 6.41 },
    { 17, 10, 22.70, -15, 43, 28.9, 2.43 },
    {  1, 34, 37.80, -15, 40, 34.0, 5.63 },
    { 15, 44,  4.39, -15, 40, 22.1, 5.41 },
    { 16, 49, 27.79, -15, 40,  3.0, 6.10 },
    {  1, 24, 39.79, -15, 39, 37.1, 6.14 },
    { 19,  5, 41.21, -15, 39, 37.1, 5.97 },
    {  7,  3, 45.50, -15, 37, 59.9, 4.12 },
    {  9, 20, 55.49, -15, 37,  4.1, 6.33 },
    { 10,  8, 35.50, -15, 36, 42.1, 6.27 },
    { 18, 54, 43.10, -15, 36, 11.2, 5.10 },
    {  7, 16, 14.50, -15, 35,  8.9, 5.46 },
    {  9, 30, 22.61, -15, 34, 37.9, 5.85 },
    { 17, 37, 36.19, -15, 34, 16.0, 5.94 },
    { 15, 21,  1.39, -15, 32, 53.9, 6.30 },
    { 19, 19,   .10, -15, 32, 11.0, 6.06 },
    { 19, 57, 57.00, -15, 29, 29.0, 5.02 },
    { 19, 43, 33.50, -15, 28, 12.0, 5.49 },
    {  0, 11, 15.91, -15, 28,  5.2, 4.89 },
    { 14, 45, 57.79, -15, 27, 34.9, 6.33 },
    { 23, 42, 27.89, -15, 26, 52.1, 5.28 },
    { 10, 53, 32.90, -15, 26, 44.2, 6.38 },
    {  1, 35, 58.99, -15, 24,  1.1, 5.42 },
    { 17, 37, 35.21, -15, 23, 55.0, 3.54 },
    { 13, 32, 51.70, -15, 21, 47.2, 5.55 },
    {  2, 26,   .31, -15, 20, 28.0, 5.83 },
    { 12, 55, 53.30, -15, 19, 36.8, 6.17 },
    {  2,  2, 58.61, -15, 18, 20.9, 5.86 },
    { 23, 43, 49.49, -15, 17,  3.8, 6.36 },
    { 19,  1, 33.50, -15, 16, 57.0, 6.32 },
    {  7, 40, 23.21, -15, 15, 49.0, 4.94 },
    { 10, 47, 37.99, -15, 15, 42.8, 6.67 },
    { 23, 34, 49.39, -15, 14, 44.9, 5.96 },
    {  2, 32,  5.21, -15, 14, 40.9, 4.75 },
    {  3, 40, 11.40, -15, 13, 36.1, 6.33 },
    { 21, 15, 44.90, -15, 10, 17.0, 5.28 },
    {  6, 48, 57.79, -15,  8, 40.9, 5.39 },
    {  6, 23, 46.01, -15,  4, 18.1, 6.24 },
    { 20, 31,  4.30, -15,  3, 23.0, 6.12 },
    { 19, 26, 11.11, -15,  3, 11.2, 5.72 },
    { 15, 43, 24.89, -15,  2, 35.9, 6.31 },
    { 23, 22, 39.19, -15,  2, 21.1, 5.20 },
    {  8, 32, 33.29, -15,  1, 45.8, 6.38 },
    {  9, 15, 24.89, -15,  1, 28.9, 6.35 },
    {  6, 18, 48.79, -15,  1, 28.9, 6.06 },
    {  7, 29, 21.89, -14, 59, 57.1, 6.05 },
    {  0, 36,  3.00, -14, 58, 25.0, 6.45 },
    { 14,  4, 27.00, -14, 58, 18.1, 6.28 },
    { 20, 39, 16.39, -14, 57, 16.9, 5.22 },
    {  6,  6,  9.29, -14, 56,  7.1, 4.67 },
    {  8, 25, 55.61, -14, 55, 46.9, 5.98 },
    { 16, 48, 27.00, -14, 54, 33.8, 6.03 },
    { 16, 19,   .41, -14, 52, 21.0, 5.94 },
    { 16, 58, 41.59, -14, 52, 10.9, 6.59 },
    { 18, 32, 43.30, -14, 51, 56.2, 5.50 },
    {  0, 29, 51.89, -14, 51, 51.1, 6.14 },
    { 18, 33, 39.00, -14, 51, 13.0, 5.76 },
    { 16, 15, 51.50, -14, 50, 57.1, 6.09 },
    {  9, 51, 28.70, -14, 50, 48.1, 4.12 },
    {  7, 52, 18.91, -14, 50, 47.0, 5.69 },
    { 15, 56, 33.41, -14, 49, 45.1, 6.13 },
    {  5, 46, 57.29, -14, 49, 18.8, 3.55 },
    {  4, 59, 36.50, -14, 48, 20.9, 7.71 },
    {  6, 45, 59.30, -14, 47, 46.0, 5.32 },
    { 15, 35, 31.61, -14, 47, 21.8, 3.91 },
    { 20, 20, 46.61, -14, 47,  6.0, 6.10 },
    { 20, 21,   .70, -14, 46, 53.0, 3.08 },
    { 11, 19, 20.50, -14, 46, 43.0, 3.56 },
    { 21, 44,  1.01, -14, 44, 57.8, 5.99 },
    { 17, 47, 36.79, -14, 43, 32.9, 5.94 },
    {  7, 45, 29.09, -14, 41, 26.9, 6.07 },
    {  7, 45, 28.70, -14, 41, 10.0, 6.89 },
    {  0,  2,  7.30, -14, 40, 34.0, 7.10 },
    { 18, 32, 20.81, -14, 38, 39.1, 6.37 },
    {  5, 13, 59.90, -14, 36, 24.1, 6.21 },
    { 19, 53,  6.41, -14, 36, 11.2, 6.48 },
    {  1, 25, 37.20, -14, 35, 56.0, 4.90 },
    { 22, 30, 17.40, -14, 35,  8.9, 6.37 },
    {  6,  9, 34.30, -14, 35,  3.1, 5.56 },
    { 17, 15, 20.30, -14, 35,  2.0, 5.99 },
    { 18, 29, 46.80, -14, 34, 54.1, 5.96 },
    {  9, 17,  7.49, -14, 34, 25.0, 5.84 },
    { 18, 29, 11.90, -14, 33, 56.9, 4.70 },
    { 18, 41, 42.50, -14, 33, 51.1, 6.42 },
    {  7, 45, 56.90, -14, 33, 50.0, 5.04 },
    { 19, 26, 24.60, -14, 33,  4.0, 6.70 },
    { 16, 29, 46.90, -14, 33,  2.9, 5.68 },
    {  2, 41, 34.01, -14, 32, 57.8, 5.98 },
    { 23, 42, 43.30, -14, 32, 42.0, 4.49 },
    {  7, 33, 47.90, -14, 31, 26.0, 4.97 },
    { 23,  9, 49.61, -14, 30, 38.2, 6.42 },
    {  6,  2, 33.79, -14, 29, 49.9, 6.20 },
    {  7, 36,  3.91, -14, 29, 34.1, 5.70 },
    {  5, 49, 36.50, -14, 29,  1.0, 5.49 },
    { 20, 58, 41.90, -14, 28, 58.1, 6.01 },
    { 21, 11, 41.30, -14, 28, 19.9, 6.48 },
    { 11, 39, 51.10, -14, 28,  7.0, 6.21 },
    {  7, 37, 38.90, -14, 26, 28.0, 6.53 },
    {  6, 46, 51.10, -14, 25, 32.9, 5.29 },
    { 23, 50, 33.31, -14, 24,  6.8, 5.72 },
    { 21, 43,  4.39, -14, 23, 58.9, 5.88 },
    { 15, 56, 14.40, -14, 23, 57.8, 6.37 },
    {  5,  3, 52.01, -14, 22,  9.8, 6.41 },
    {  7, 20, 58.20, -14, 21, 36.0, 5.45 },
    {  4, 39, 19.70, -14, 21, 33.1, 5.45 },
    {  7, 33, 22.10, -14, 20, 17.9, 6.21 },
    {  9, 40, 18.41, -14, 19, 55.9, 5.06 },
    {  4, 38, 10.80, -14, 18, 14.0, 3.87 },
    { 19, 37, 34.39, -14, 18,  6.1, 5.47 },
    { 15, 58, 11.40, -14, 16, 45.8, 4.88 },
    { 23, 52, 30.00, -14, 15,  4.0, 5.87 },
    {  4, 57, 44.81, -14, 13, 53.0, 6.15 },
    { 23, 39, 47.11, -14, 13, 18.1, 5.00 },
    { 22, 12, 25.80, -14, 11, 38.0, 6.03 },
    {  5, 56, 24.29, -14, 10,  4.1, 3.71 },
    { 14, 49, 19.10, -14,  8, 56.0, 5.31 },
    {  6, 39, 16.70, -14,  8, 44.9, 4.82 },
    { 15, 51, 38.40, -14,  8,  1.0, 6.19 },
    { 11,  0, 11.59, -14,  4, 59.9, 5.88 },
    { 16,  7,  3.41, -14,  4, 14.9, 6.32 },
    { 22, 47, 42.79, -14,  3, 23.0, 5.66 },
    { 21, 41, 32.90, -14,  2, 51.0, 5.18 },
    {  6, 56,  6.60, -14,  2, 37.0, 5.00 },
    { 18, 38,  4.61, -14,  0, 16.9, 6.47 },
    { 10, 42, 31.30, -13, 58, 30.0, 6.24 },
    { 18,  9, 43.39, -13, 56,  3.8, 6.39 },
    {  5, 23, 30.19, -13, 55, 37.9, 5.25 },
    {  7, 51, 46.30, -13, 53, 53.2, 5.17 },
    { 19, 25, 21.60, -13, 53, 48.8, 5.69 },
    { 22,  6, 26.21, -13, 52, 10.9, 4.27 },
    { 12, 32, 36.00, -13, 51, 33.1, 5.74 },
    {  2, 44,  7.39, -13, 51, 31.0, 4.25 },
    {  8, 10, 39.79, -13, 47, 57.1, 5.54 },
    {  4, 49, 42.19, -13, 46, 10.9, 6.26 },
    { 10, 54, 17.81, -13, 45, 29.2, 5.66 },
    {  5, 21, 51.00, -13, 45, 22.0, 6.56 },
    {  7, 25,  8.30, -13, 45,  6.8, 5.78 },
    { 20, 34, 11.69, -13, 43, 16.0, 6.13 },
    {  6, 15, 44.90, -13, 43,  5.9, 5.01 },
    { 19, 48,  3.00, -13, 42, 11.9, 6.11 },
    {  4, 31, 25.90, -13, 38, 42.0, 6.21 },
    { 20,  1, 58.61, -13, 38, 12.8, 5.71 },
    { 22, 49, 35.50, -13, 35, 33.0, 4.01 },
    {  4, 30,  9.70, -13, 35, 31.9, 6.24 },
    { 10, 30, 59.81, -13, 35, 17.9, 5.58 },
    { 12, 20, 55.70, -13, 33, 56.2, 5.14 },
    {  0, 49, 25.61, -13, 33, 41.0, 5.59 },
    { 21, 53, 17.81, -13, 33,  6.1, 5.08 },
    {  8, 46, 22.51, -13, 32, 52.1, 4.32 },
    { 22, 24, 27.10, -13, 31, 45.8, 5.76 },
    {  5, 17, 40.20, -13, 31, 10.9, 5.50 },
    {  9, 32, 55.80, -13, 31,   .8, 5.94 },
    { 17, 43, 48.60, -13, 30, 31.0, 6.39 },
    {  3, 58,  1.80, -13, 30, 31.0, 2.95 },
    { 23, 19,  6.70, -13, 27, 32.0, 5.08 },
    { 11,  3, 36.50, -13, 26,  3.8, 6.34 },
    { 12, 30,  4.80, -13, 23, 35.2, 6.35 },
    { 10, 37, 33.19, -13, 23,  3.8, 4.82 },
    { 14, 19,  6.60, -13, 22, 16.0, 4.52 },
    {  7, 49, 28.61, -13, 21, 11.9, 6.23 },
    {  6, 36, 46.70, -13, 19, 14.9, 5.97 },
    { 22, 19,   .79, -13, 18, 18.0, 5.95 },
    { 21, 17, 13.49, -13, 16, 44.0, 6.40 },
    {  8, 52, 30.70, -13, 14,  1.0, 6.13 },
    { 13, 34, 40.49, -13, 12, 51.8, 5.91 },
    { 11, 38, 40.10, -13, 12,  6.8, 5.48 },
    {  5, 19, 34.51, -13, 10, 36.1, 4.29 },
    {  6, 30, 34.70, -13,  8, 53.2, 6.16 },
    {  5,  6, 36.70, -13,  7, 18.8, 6.05 },
    { 22, 59, 35.69, -13,  4, 14.9, 6.07 },
    { 10,  5,  7.49, -13,  3, 52.9, 4.60 },
    { 23, 37, 39.60, -13,  3, 37.1, 5.65 },
    {  1, 26, 51.60, -13,  3, 24.1, 5.66 },
    {  8, 22, 46.80, -13,  3, 16.9, 6.11 },
    {  4, 29,  6.89, -13,  2, 53.9, 5.60 },
    { 12, 41, 16.20, -13,  0, 54.0, 5.98 },
    { 12, 41, 16.01, -13,  0, 49.0, 6.08 },
    {  6, 37, 40.90, -12, 59,  6.0, 6.12 },
    {  6, 24, 20.50, -12, 57, 45.0, 6.12 },
    {  5, 13, 13.90, -12, 56, 29.0, 4.36 },
    {  8, 11, 16.30, -12, 55, 36.8, 4.72 },
    { 22, 30,  1.51, -12, 54, 54.0, 6.40 },
    {  6,  0, 17.71, -12, 53, 58.9, 6.22 },
    { 16, 59, 30.20, -12, 53, 27.0,      },
    {  0, 45, 28.70, -12, 52, 50.9, 6.15 },
    { 21, 24, 11.50, -12, 52, 41.2, 5.49 },
    { 17, 41, 24.91, -12, 52, 31.1, 4.26 },
    { 17, 20, 49.70, -12, 50, 48.8, 4.33 },
    { 18, 59, 23.81, -12, 50, 26.2, 5.53 },
    { 14, 47, 54.89, -12, 50, 22.9, 6.35 },
    { 22, 16, 48.10, -12, 49, 53.0, 5.34 },
    { 12, 33, 34.30, -12, 49, 49.1, 5.58 },
    {  7, 51, 40.90, -12, 49,  9.8, 6.36 },
    { 10, 10,  5.90, -12, 48, 58.0, 5.31 },
    {  4,  4, 22.70, -12, 47, 33.0, 5.61 },
    {  2, 52, 32.11, -12, 46,  9.8, 6.04 },
    { 20, 20, 39.79, -12, 45, 33.1, 4.76 },
    { 16,  7, 36.41, -12, 44, 44.2, 5.78 },
    { 21, 49, 41.11, -12, 43, 23.2, 6.31 },
    { 13, 26, 43.20, -12, 42, 28.1, 5.25 },
    {  7, 46, 44.90, -12, 40, 31.1, 6.39 },
    {  3, 29, 36.00, -12, 40, 28.9, 5.59 },
    { 20,  5, 26.40, -12, 39, 55.1, 6.55 },
    {  8, 18, 23.90, -12, 37, 54.8, 5.98 },
    { 20, 12, 25.90, -12, 37,  3.0, 5.85 },
    {  0, 10, 42.79, -12, 34, 48.0, 5.85 },
    {  3, 59, 30.10, -12, 34, 27.1, 5.60 },
    { 20, 50, 41.81, -12, 32, 42.0, 5.88 },
    { 20, 18,  3.31, -12, 32, 40.9, 3.57 },
    {  4, 59, 55.80, -12, 32, 15.0, 4.79 },
    {  8, 26, 41.90, -12, 32,  3.8, 5.54 },
    { 10, 19, 16.80, -12, 31, 41.2, 6.00 },
    { 17, 27,  2.11, -12, 30, 45.0, 6.21 },
    { 20, 17, 38.90, -12, 30, 29.9, 4.24 },
    {  5,  7, 25.01, -12, 29, 26.2, 5.97 },
    {  8, 40,  1.51, -12, 28, 31.1, 4.98 },
    {  2, 47, 55.99, -12, 27, 38.2, 6.90 },
    { 10, 38, 50.40, -12, 26, 37.0, 6.04 },
    { 13, 45, 56.30, -12, 25, 36.1, 5.51 },
    {  7,  6, 35.90, -12, 23, 38.0, 6.48 },
    { 20, 11, 57.89, -12, 23, 33.0, 6.34 },
    {  6, 31, 22.99, -12, 23, 30.1, 5.15 },
    { 15, 23, 52.20, -12, 22,  9.8, 5.72 },
    {  9,  9, 11.50, -12, 21, 28.1, 5.77 },
    { 11, 27,  9.50, -12, 21, 24.1, 5.94 },
    { 10, 10, 35.30, -12, 21, 15.1, 3.61 },
    { 20, 16, 22.80, -12, 20, 12.8, 6.32 },
    {  5, 19, 59.09, -12, 18, 56.2, 5.30 },
    { 14, 36, 59.81, -12, 18, 19.1, 6.20 },
    {  2, 25, 57.00, -12, 17, 26.2, 4.89 },
    { 19, 13, 15.50, -12, 16, 57.0, 5.51 },
    { 19, 35, 33.60, -12, 15, 10.1, 6.27 },
    { 10, 36, 32.40, -12, 13, 49.1, 5.70 },
    {  0, 22, 51.79, -12, 12, 33.8, 6.39 },
    {  7, 47, 56.71, -12, 11, 35.2, 5.48 },
    { 11, 51, 21.89, -12, 11, 16.1, 6.35 },
    {  4, 38, 53.59, -12,  7, 23.2, 5.01 },
    {  3, 46,  8.50, -12,  6,  6.1, 4.42 },
    {  3, 55, 16.30, -12,  5, 57.1, 6.00 },
    { 10,  9, 56.50, -12,  5, 44.9, 6.24 },
    {  6, 54, 11.40, -12,  2, 19.0, 4.07 },
    { 18, 23, 12.19, -12,  0, 52.9, 5.73 },
    {  0, 43, 50.21, -12,  0, 42.1, 6.02 },
    {  9, 19, 46.39, -11, 58, 30.0, 4.79 },
    {  8, 42,  9.79, -11, 57, 58.0, 6.45 },
    { 23, 47, 15.91, -11, 54, 38.9, 5.73 },
    {  5, 27,  4.80, -11, 54,  2.9, 6.35 },
    { 14, 54, 22.90, -11, 53, 53.9, 5.80 },
    {  2, 39, 33.79, -11, 52, 19.9, 4.84 },
    {  5, 12, 17.90, -11, 52,  9.1, 4.45 },
    {  5, 11, 22.80, -11, 50, 57.1, 5.68 },
    { 16, 13, 50.90, -11, 50, 15.0, 5.22 },
    {  3, 41, 13.80, -11, 48, 11.2, 6.49 },
    { 16, 54, 40.30, -11, 47, 33.0, 6.57 },
    {  5, 37,  8.81, -11, 46, 32.2, 6.11 },
    {  5, 54, 43.61, -11, 46, 26.0, 5.66 },
    {  6, 21, 24.70, -11, 46, 23.9, 5.64 },
    { 10, 37, 11.59, -11, 44, 55.0, 6.52 },
    { 14, 23, 25.61, -11, 42, 51.1, 6.21 },
    { 23, 17, 40.01, -11, 42, 47.2, 6.34 },
    { 23, 41,  8.90, -11, 40, 50.2, 5.89 },
    { 14, 24, 40.90, -11, 40, 10.9, 6.49 },
    { 12, 54, 18.70, -11, 38, 55.0, 6.00 },
    { 22, 53, 28.70, -11, 37,   .1, 5.80 },
    { 12, 25, 11.71, -11, 36, 37.1, 5.95 },
    { 20,  5,  5.40, -11, 35, 57.8, 6.34 },
    { 20, 53,  5.59, -11, 34, 25.0, 6.38 },
    { 21, 28, 13.90, -11, 34,  5.9, 6.61 },
    { 22, 10, 37.49, -11, 33, 54.0, 5.46 },
    {  7, 27, 51.70, -11, 33, 24.8, 5.79 },
    {  6, 24, 10.30, -11, 31, 49.1, 5.22 },
    { 23, 28,  5.21, -11, 26, 58.9, 6.37 },
    { 14, 56, 46.10, -11, 24, 34.9, 5.46 },
    {  0, 58, 43.90, -11, 22, 48.0, 5.61 },
    { 16,  4, 22.10, -11, 22, 23.2, 5.07 },
    { 16,  4, 22.10, -11, 22, 23.2, 4.77 },
    { 21,  9, 35.69, -11, 22, 18.1, 4.51 },
    { 21, 46, 32.11, -11, 21, 56.9, 5.58 },
    {  8,  8, 56.90, -11, 20, 22.9, 6.32 },
    {  1, 41, 44.71, -11, 19, 28.9, 5.75 },
    {  9, 19, 33.70, -11, 18, 51.1, 6.62 },
    { 11,  3, 14.90, -11, 18, 13.0, 5.50 },
    {  7,  6, 40.70, -11, 17, 39.1, 5.39 },
    {  3, 28,  1.01, -11, 17, 12.1, 5.73 },
    {  0, 56,  1.51, -11, 16,   .1, 5.31 },
    {  7, 13,  7.20, -11, 15,  5.0, 5.78 },
    { 17, 34, 46.39, -11, 14, 30.8, 5.55 },
    {  1, 20, 27.79, -11, 14, 20.0, 6.15 },
    { 10, 16,  9.10, -11, 12, 11.9, 6.08 },
    {  3, 35, 57.70, -11, 11, 37.0, 5.57 },
    {  6,  6, 51.89, -11, 10, 25.0, 6.66 },
    {  6, 32, 46.90, -11,  9, 59.0, 6.24 },
    { 13, 25, 11.59, -11,  9, 41.0, 0.98 },
    { 14, 58, 13.39, -11,  9, 18.0, 6.60 },
    { 14, 58, 53.59, -11,  8, 39.1, 5.87 },
    {  7, 50, 55.20, -11,  7, 43.0, 6.16 },
    { 11,  5, 34.01, -11,  5, 20.0, 6.09 },
    {  8, 46,  6.89, -11,  0, 23.0, 6.25 },
    { 18, 35,  2.40, -10, 58, 37.9, 5.14 },
    { 16, 57, 26.09, -10, 57, 47.9, 6.19 },
    { 17, 38,  9.50, -10, 55, 35.0, 5.75 },
    { 22, 31, 41.30, -10, 54, 20.2, 6.38 },
    {  1, 27, 46.61, -10, 54,  6.1, 6.13 },
    { 17, 53,  3.60, -10, 53, 58.9, 6.18 },
    { 10,  8, 45.70, -10, 53,  4.9, 6.53 },
    { 19, 49,  2.21, -10, 52, 14.9, 6.04 },
    { 11, 24, 36.60, -10, 51, 33.8, 4.83 },
    { 18, 31, 25.70, -10, 47, 44.9, 5.72 },
    {  4, 33, 22.01, -10, 47,  8.9, 6.06 },
    { 16, 49, 49.99, -10, 46, 59.2, 4.65 },
    {  2, 22,  1.39, -10, 46, 40.1, 5.46 },
    {  9, 40, 20.11, -10, 46,  9.1, 6.37 },
    { 19, 50, 46.80, -10, 45, 49.0, 5.39 },
    { 13,  7, 53.81, -10, 44, 25.1, 5.19 },
    {  6, 17, 35.21, -10, 43, 31.1, 6.75 },
    { 17, 20, 52.70, -10, 41, 46.0, 6.46 },
    { 23, 14, 40.20, -10, 41, 19.0, 6.12 },
    {  1, 49, 35.09, -10, 41, 11.0, 4.67 },
    { 22, 30, 38.81, -10, 40, 41.2, 4.82 },
    {  7,  5, 49.70, -10, 39, 40.0, 6.49 },
    {  0, 50,  7.61, -10, 38, 39.8, 5.19 },
    {  0, 44, 11.40, -10, 36, 33.8, 4.76 },
    { 21, 14, 16.70, -10, 36, 19.1, 6.77 },
    {  6,  1, 50.40, -10, 35, 53.2, 4.95 },
    {  7, 15, 43.10, -10, 35,  2.0, 5.95 },
    { 10, 36, 17.40, -10, 34, 59.9, 6.57 },
    { 21, 39, 28.10, -10, 34, 36.8, 6.08 },
    {  9, 39, 47.40, -10, 34, 13.1, 6.31 },
    { 16, 37,  9.50, -10, 34,  1.9, 2.56 },
    { 19, 35,  7.30, -10, 33, 37.1, 5.12 },
    { 22, 48, 30.19, -10, 33, 20.2, 6.19 },
    {  9, 31, 38.90, -10, 33,  7.9, 6.14 },
    {  5, 47, 26.71, -10, 31, 59.2, 6.03 },
    { 17,  9, 48.00, -10, 31, 23.9, 5.56 },
    {  0,  4, 30.10, -10, 30, 33.8, 4.94 },
    {  3, 43, 33.79, -10, 29,  8.2, 5.60 },
    { 12,  0, 44.50, -10, 26, 46.0, 5.55 },
    {  3, 39, 25.39, -10, 26, 13.9, 6.19 },
    {  5, 40, 46.01, -10, 24, 33.8, 6.52 },
    {  9, 31, 55.80, -10, 22, 14.2, 6.13 },
    {  7,  9, 20.30, -10, 20, 49.9, 6.21 },
    { 12, 51, 22.90, -10, 20, 17.9, 6.41 },
    {  1, 51, 27.60, -10, 20,  6.0, 3.73 },
    { 14,  9,   .60, -10, 20,  3.8, 6.47 },
    { 13,  9, 45.31, -10, 19, 45.8, 5.94 },
    {  5, 25,  1.61, -10, 19, 45.1, 5.61 },
    {  7, 29, 22.10, -10, 19, 36.1, 5.75 },
    { 15, 24, 11.90, -10, 19, 19.9, 4.94 },
    {  7, 14, 28.20, -10, 19,   .1, 6.03 },
    { 11, 48, 23.50, -10, 18, 47.9, 6.26 },
    { 12, 15, 10.61, -10, 18, 45.0, 6.11 },
    { 21, 53, 36.00, -10, 18, 42.1, 6.59 },
    { 14, 12, 53.81, -10, 16, 25.0, 4.19 },
    {  4, 59, 50.40, -10, 15, 47.9, 5.38 },
    {  4, 14, 23.71, -10, 15, 23.0, 4.87 },
    {  6,  5, 27.00, -10, 14, 34.1, 5.87 },
    { 18, 23,  2.21, -10, 13,  7.0, 6.33 },
    {  1,  8, 35.40, -10, 10, 55.9, 3.45 },
    {  8, 19, 15.10, -10,  9, 56.9, 6.32 },
    { 13, 32, 58.10, -10,  9, 54.0, 5.21 },
    { 18, 46, 43.30, -10,  7, 30.0, 5.71 },
    {  7,  3, 57.29, -10,  7, 27.1, 6.45 },
    {  6, 46, 39.00, -10,  6, 25.9, 5.66 },
    {  6, 30, 11.30, -10,  4, 53.0, 5.93 },
    { 15, 34, 10.70, -10,  3, 51.8, 4.62 },
    { 16, 12,   .00, -10,  3, 51.1, 4.94 },
    { 20,  8, 31.30, -10,  3, 46.1, 6.18 },
    {  2, 11, 22.20, -10,  3,  7.9, 6.01 },
    {  1,  5, 36.79, - 9, 58, 45.1, 6.12 },
    { 23, 50, 14.69, - 9, 58, 27.1, 5.94 },
    {  3,  1, 56.09, - 9, 57, 41.0, 5.83 },
    { 19, 59, 47.40, - 9, 57, 29.9, 5.88 },
    {  7, 14, 15.50, - 9, 56, 51.0, 5.90 },
    {  6, 23, 36.00, - 9, 52, 27.8, 6.19 },
    {  3, 34, 37.39, - 9, 52,  7.0, 6.25 },
    { 20, 32, 23.71, - 9, 51, 11.9, 5.65 },
    { 10, 49, 43.49, - 9, 51, 10.1, 5.86 },
    {  1,  6,  5.09, - 9, 50, 21.8, 5.58 },
    {  9, 22, 50.90, - 9, 50, 20.0, 6.53 },
    { 11, 36, 40.90, - 9, 48,  7.9, 4.70 },
    {  1,  7, 46.20, - 9, 47,  8.2, 5.82 },
    {  2, 58, 47.40, - 9, 46, 35.0, 6.14 },
    { 18, 50, 58.49, - 9, 46, 27.1, 5.83 },
    { 17, 59,  1.61, - 9, 46, 25.0, 3.34 },
    {  3, 43, 14.90, - 9, 45, 47.9, 3.54 },
    { 18, 17, 24.19, - 9, 45, 31.0, 6.31 },
    {  3, 56, 37.90, - 9, 45,  2.9, 6.19 },
    { 21, 25, 13.10, - 9, 44, 55.0, 5.70 },
    {  8, 28, 50.90, - 9, 44, 53.9, 6.00 },
    {  4, 35, 13.99, - 9, 44, 12.1, 6.37 },
    { 13, 47, 13.49, - 9, 42, 33.1, 6.05 },
    {  5, 39, 30.79, - 9, 42, 24.1, 6.50 },
    { 20, 56, 54.00, - 9, 41, 51.0, 5.51 },
    {  5, 47, 45.41, - 9, 40, 10.9, 2.06 },
    { 20, 23,   .79, - 9, 39, 16.9, 6.30 },
    { 23, 18, 57.70, - 9, 36, 38.9, 4.98 },
    { 18, 53,  1.90, - 9, 34, 34.0, 6.34 },
    { 10,  3, 40.99, - 9, 34, 26.0, 6.12 },
    {  0, 14, 54.50, - 9, 34, 10.9, 5.75 },
    {  5, 59,  4.30, - 9, 33, 29.9, 5.03 },
    {  9, 20, 28.99, - 9, 33, 20.9, 4.80 },
    { 16, 39, 39.10, - 9, 33, 15.8, 6.35 },
    {  7, 41, 14.81, - 9, 33,  4.0, 3.93 },
    { 12, 54, 21.19, - 9, 32, 20.0, 4.79 },
    { 13,  9, 14.40, - 9, 32, 17.9, 6.32 },
    { 20, 47, 40.61, - 9, 29, 44.9, 3.77 },
    {  2, 15, 28.30, - 9, 27, 56.2, 6.55 },
    {  3, 32, 55.80, - 9, 27, 29.9, 3.73 },
    {  2, 40, 12.31, - 9, 27, 11.2, 5.78 },
    { 12, 33, 46.80, - 9, 27,  6.8, 5.48 },
    {  2, 52, 50.50, - 9, 26, 28.0, 6.32 },
    {  9, 37, 51.50, - 9, 25, 27.8, 6.40 },
    {  1, 37, 37.70, - 9, 24, 14.0, 6.24 },
    {  6, 18, 50.59, - 9, 23, 25.1, 5.36 },
    { 15, 17,   .41, - 9, 22, 59.2, 2.61 },
    {  5, 59,  1.01, - 9, 22, 55.9, 6.12 },
    { 21, 10, 46.90, - 9, 21, 14.0, 6.27 },
    { 21, 22, 56.30, - 9, 19,  9.8, 5.99 },
    { 14,  6, 42.79, - 9, 18, 47.9, 5.46 },
    { 21, 46, 16.30, - 9, 16, 32.9, 6.00 },
    { 23, 29,   .60, - 9, 15, 58.0, 6.18 },
    {  8,  6, 27.50, - 9, 14, 42.0, 6.23 },
    {  9, 27, 14.59, - 9, 13, 25.0, 6.54 },
    {  7,  0, 39.29, - 9, 12, 11.2, 6.49 },
    {  7, 50, 10.61, - 9, 10, 59.9, 5.61 },
    { 15, 34, 26.59, - 9, 10, 59.9, 5.17 },
    { 23, 17, 54.19, - 9, 10, 57.0, 4.39 },
    {  6, 41, 56.40, - 9, 10,  1.9, 5.19 },
    {  3, 16, 35.71, - 9,  9, 15.8, 6.14 },
    { 23, 15, 53.50, - 9,  5, 16.1, 4.21 },
    { 21, 45,   .31, - 9,  4, 57.0, 5.09 },
    { 10, 19, 59.40, - 9,  3, 32.0, 6.32 },
    { 18, 42, 16.39, - 9,  3,  9.0, 4.72 },
    {  8, 41,  1.61, - 9,  3,  6.8, 6.63 },
    {  5, 52,  7.61, - 9,  2, 29.0, 5.97 },
    { 22, 16, 52.61, - 9,  2, 24.0, 5.79 },
    {  6, 15, 25.99, - 9,  2,  7.1, 6.10 },
    {  1, 33,  3.50, - 9,  0, 52.9, 6.59 },
    {  6, 47, 37.10, - 8, 59, 53.9, 5.07 },
    { 23, 52, 50.50, - 8, 59, 48.1, 5.75 },
    { 13,  8, 32.50, - 8, 59,  3.8, 5.55 },
    { 20, 52, 39.19, - 8, 58, 59.9, 4.73 },
    {  7, 22,  1.99, - 8, 58, 45.1, 6.43 },
    {  4, 34, 11.71, - 8, 58, 13.1, 5.26 },
    { 18, 23, 39.50, - 8, 56,  3.1, 4.68 },
    {  1, 10, 12.00, - 8, 54, 22.0, 6.40 },
    {  2, 56, 25.70, - 8, 53, 53.2, 3.89 },
    { 10, 50, 18.10, - 8, 53, 52.1, 5.79 },
    {  7, 32,  5.81, - 8, 52, 50.9, 5.90 },
    {  7, 21, 16.90, - 8, 52, 41.9, 6.55 },
    {  4,  5, 56.50, - 8, 51, 22.0, 6.26 },
    { 20, 11, 10.10, - 8, 50, 31.9, 6.49 },
    {  0,  8, 17.40, - 8, 49, 26.0, 5.99 },
    {  0, 19, 25.70, - 8, 49, 26.0, 3.56 },
    {  4, 10, 47.69, - 8, 49, 10.9, 5.70 },
    {  3, 15, 49.99, - 8, 49, 10.9, 4.80 },
    {  8, 28, 19.70, - 8, 48, 58.0, 6.43 },
    {  4, 43, 35.09, - 8, 47, 46.0, 6.70 },
    { 15, 38, 40.01, - 8, 47, 39.8, 6.50 },
    {  4, 43, 34.61, - 8, 47, 37.0, 6.82 },
    { 15, 38, 40.10, - 8, 47, 28.0, 6.48 },
    {  9,  9, 35.50, - 8, 47, 16.1, 5.46 },
    {  5,  9,  8.81, - 8, 45, 15.1, 4.27 },
    {  9, 16, 41.30, - 8, 44, 40.9, 5.47 },
    {  0, 54, 17.59, - 8, 44, 26.9, 6.16 },
    { 13, 41, 36.79, - 8, 42, 11.2, 5.01 },
    {  5,  8, 20.21, - 8, 39, 54.0, 5.78 },
    {  9, 27, 35.21, - 8, 39, 31.0, 1.98 },
    {  9,  8, 42.19, - 8, 35, 21.8, 5.60 },
    {  6, 19,  7.90, - 8, 35, 11.0, 6.22 },
    { 19, 54,  8.21, - 8, 34, 27.1, 5.79 },
    { 16, 12,  7.30, - 8, 32, 51.0, 5.43 },
    {  2,  0, 26.90, - 8, 31, 25.0, 5.51 },
    { 15,  0, 58.39, - 8, 31,  8.0, 4.92 },
    {  9, 33,  2.09, - 8, 30, 19.1, 6.12 },
    {  4, 44,  5.30, - 8, 30, 13.0, 5.90 },
    { 10, 10, 55.80, - 8, 25,  5.9, 5.65 },
    {  5, 23, 18.50, - 8, 24, 56.9, 5.90 },
    { 16,  0, 47.59, - 8, 24, 41.0, 5.55 },
    { 10, 10,  7.49, - 8, 24, 29.9, 5.91 },
    {  7,  0, 23.69, - 8, 24, 24.8, 5.96 },
    { 16, 27, 48.10, - 8, 22, 18.1, 4.63 },
    { 16, 15, 37.30, - 8, 22,  9.8, 5.50 },
    { 18,  6,  7.39, - 8, 19, 26.0, 5.85 },
    { 22, 43,  3.50, - 8, 18, 42.1, 6.45 },
    {  7, 36, 16.61, - 8, 18, 41.0, 6.27 },
    { 18, 43, 31.30, - 8, 16, 31.1, 4.90 },
    { 18, 35, 12.41, - 8, 14, 39.1, 3.85 },
    { 19, 54, 38.11, - 8, 14, 13.9, 6.49 },
    {  4, 34, 11.59, - 8, 13, 53.0, 5.11 },
    { 19, 54, 37.61, - 8, 13, 37.9, 5.71 },
    { 17, 28,  2.30, - 8, 12, 29.9, 6.37 },
    {  5, 14, 32.30, - 8, 12,  6.1, 0.12 },
    { 19, 22, 20.69, - 8, 12,  4.0, 6.31 },
    {  7, 40, 35.50, - 8, 11,  8.9, 6.01 },
    {  1, 24,  1.39, - 8, 10, 59.9, 3.60 },
    { 18,  3,  4.90, - 8, 10, 50.2, 5.24 },
    { 18,  3,  4.99, - 8, 10, 49.1, 5.94 },
    {  6, 57,   .10, - 8, 10, 44.0, 6.34 },
    {  6, 31, 50.09, - 8,  9, 29.2, 5.43 },
    {  5, 13, 33.29, - 8,  8, 52.1, 6.37 },
    { 16, 28, 48.91, - 8,  7, 44.0, 6.48 },
    { 17, 37, 50.69, - 8,  7,  8.0, 4.62 },
    {  9, 52, 30.41, - 8,  6, 18.0, 5.05 },
    { 10, 17, 37.80, - 8,  4,  8.0, 5.24 },
    { 13, 54, 58.20, - 8,  3, 32.0, 6.19 },
    {  0, 18, 41.81, - 8,  3, 10.1, 6.46 },
    {  6, 50, 42.29, - 8,  2, 28.0, 6.29 },
    {  1, 24,  2.50, - 8,  0, 27.0, 6.21 },
    { 12, 39, 14.81, - 7, 59, 44.2, 4.66 },
    {  8, 35, 28.20, - 7, 58, 55.9, 5.72 },
    {  8, 55, 29.59, - 7, 58, 16.0, 6.67 },
    {  8, 55, 29.50, - 7, 58, 13.1, 6.91 },
    { 19, 12, 40.70, - 7, 56, 21.8, 5.34 },
    {  1, 14, 24.00, - 7, 55, 23.2, 5.13 },
    { 18, 50, 19.99, - 7, 54, 27.0, 6.80 },
    { 22, 38, 22.20, - 7, 53, 52.1, 6.23 },
    {  6, 25, 58.80, - 7, 53, 39.1, 6.40 },
    {  2, 34, 42.70, - 7, 51, 33.8, 5.75 },
    { 21, 37, 45.10, - 7, 51, 15.1, 4.69 },
    {  2, 36,   .00, - 7, 49, 54.1, 5.53 },
    { 11, 32, 47.50, - 7, 49, 39.0, 5.95 },
    {  6, 19, 42.79, - 7, 49, 23.2, 5.27 },
    { 22, 20, 11.90, - 7, 49, 16.0, 5.37 },
    {  5, 23, 56.81, - 7, 48, 29.2, 4.14 },
    {  3, 23, 17.81, - 7, 47, 39.1, 6.20 },
    { 18, 40,   .50, - 7, 47, 26.2, 5.84 },
    { 22, 16, 49.99, - 7, 46, 59.9, 4.16 },
    {  0, 14, 27.60, - 7, 46, 50.2, 5.12 },
    {  8, 11, 33.00, - 7, 46, 21.0, 5.36 },
    { 23, 16, 50.90, - 7, 43, 36.1, 5.06 },
    { 23,  5,  9.79, - 7, 41, 37.0, 5.43 },
    {  3,  2, 42.31, - 7, 41,  7.1, 5.32 },
    { 12,  2, 51.60, - 7, 41,  1.0, 6.22 },
    {  3,  1, 10.01, - 7, 39, 46.1, 5.75 },
    {  4, 15, 16.30, - 7, 39, 10.1, 4.43 },
    { 10, 30, 58.70, - 7, 38, 15.0, 6.20 },
    {  3,  4, 16.39, - 7, 36,  2.9, 5.26 },
    { 16, 27, 43.49, - 7, 35, 53.2, 5.23 },
    {  4, 20, 42.79, - 7, 35, 33.0, 5.85 },
    { 22, 52, 36.89, - 7, 34, 46.9, 3.74 },
    {  7, 29, 25.70, - 7, 33,  4.0, 5.86 },
    {  8, 22, 54.00, - 7, 32, 35.9, 5.96 },
    { 14, 18,   .60, - 7, 32, 33.0, 6.47 },
    {  5, 51, 22.01, - 7, 31,  5.2, 5.35 },
    { 16, 30, 29.90, - 7, 30, 54.0, 6.50 },
    {  6, 26, 44.90, - 7, 30, 41.0, 6.27 },
    { 20,  4,  1.20, - 7, 28, 10.9, 6.72 },
    { 23, 35, 32.11, - 7, 27, 51.8, 6.39 },
    { 19, 35, 29.81, - 7, 27, 37.1, 6.34 },
    {  5, 30, 20.71, - 7, 26,  4.9, 6.33 },
    { 19, 23,  4.61, - 7, 24,  1.1, 6.32 },
    {  3, 38, 29.21, - 7, 23, 30.1, 5.85 },
    {  0, 55, 42.41, - 7, 20, 49.9, 5.85 },
    { 10, 11, 17.81, - 7, 19,   .1, 6.25 },
    {  5, 31, 55.80, - 7, 18,  5.0, 4.62 },
    {  8, 43, 40.39, - 7, 14,  1.0, 4.62 },
    {  5, 38, 53.11, - 7, 12, 47.2, 4.80 },
    { 22, 54, 34.10, - 7, 12, 16.9, 6.19 },
    { 13, 33,   .70, - 7, 11, 42.0, 6.68 },
    { 22, 23, 32.11, - 7, 11, 39.8, 5.93 },
    {  9, 33, 20.11, - 7, 11, 24.0, 6.24 },
    {  8, 51, 34.51, - 7, 10, 37.9, 5.54 },
    {  5,  1, 26.30, - 7, 10, 26.0, 4.81 },
    { 11, 16, 58.20, - 7,  8,  4.9, 6.14 },
    {  9, 12, 25.99, - 7,  6, 34.9, 6.11 },
    { 17, 43, 46.99, - 7,  4, 45.8, 6.30 },
    { 18, 24, 42.10, - 7,  4, 31.1, 6.31 },
    { 18, 42, 36.10, - 7,  4, 23.9, 6.15 },
    { 23,  1, 23.59, - 7,  3, 40.0, 6.21 },
    { 10, 25, 44.30, - 7,  3, 34.9, 5.57 },
    { 19, 29, 21.50, - 7,  2, 38.0, 6.61 },
    {  6, 28, 49.51, - 7,  2,  3.8, 5.40 },
    {  6, 28, 49.51, - 7,  2,  3.8, 5.60 },
    {  6, 28, 49.01, - 7,  1, 58.1, 4.60 },
    { 19, 36, 53.50, - 7,  1, 39.0, 4.95 },
    {  1, 33, 42.89, - 7,  1, 31.1, 5.76 },
    { 22, 43, 14.30, - 6, 57, 46.1, 6.41 },
    {  4, 10, 22.51, - 6, 55, 26.0, 5.44 },
    {  1, 24, 20.59, - 6, 54, 52.9, 5.91 },
    { 14, 28, 41.71, - 6, 54,  2.2, 5.42 },
    { 20, 53, 58.39, - 6, 53, 22.9, 6.44 },
    {  5, 17, 36.41, - 6, 50, 39.8, 3.60 },
    {  4, 34, 14.21, - 6, 50, 16.1, 6.09 },
    {  4, 11, 51.91, - 6, 50, 15.0, 4.04 },
    { 18, 43, 51.41, - 6, 49,  7.0, 6.31 },
    {  3, 29, 39.10, - 6, 48, 18.0, 5.99 },
    {  5, 42, 53.81, - 6, 47, 46.0, 6.02 },
    {  7, 46,  2.21, - 6, 46, 21.0, 5.49 },
    {  6, 11,  1.30, - 6, 45, 15.1, 6.15 },
    {  4, 33, 54.79, - 6, 44, 20.0, 5.72 },
    { 19, 55, 19.61, - 6, 44,  3.1, 6.51 },
    {  6,  4, 13.51, - 6, 42, 33.1, 5.21 },
    {  5, 31, 20.90, - 6, 42, 29.9, 6.22 },
    {  7, 17, 31.70, - 6, 40, 48.0, 6.29 },
    { 11, 43, 55.10, - 6, 40, 37.9, 6.07 },
    {  8, 38, 20.30, - 6, 39, 45.0, 6.51 },
    { 14, 16, 21.50, - 6, 37, 18.8, 6.44 },
    { 23,  2, 32.59, - 6, 34, 27.1, 6.15 },
    {  5, 38, 37.80, - 6, 34, 26.0, 5.96 },
    {  8, 48,  4.90, - 6, 33, 31.0, 6.09 },
    { 22, 31, 18.41, - 6, 33, 18.0, 6.14 },
    {  6, 11, 51.79, - 6, 33,  1.1, 5.05 },
    { 16, 38,  1.61, - 6, 32, 17.2, 6.09 },
    { 22,  3, 16.39, - 6, 31, 21.0, 5.54 },
    {  3,  2,  9.29, - 6, 29, 40.9, 6.19 },
    {  4, 17, 19.20, - 6, 28, 18.8, 5.94 },
    { 13, 30, 25.70, - 6, 28, 13.1, 6.09 },
    {  2, 16, 58.99, - 6, 25, 19.9, 5.51 },
    {  8, 27, 17.21, - 6, 24, 34.9, 6.59 },
    { 23, 48, 32.50, - 6, 22, 50.2, 6.07 },
    { 20, 20, 26.11, - 6, 21, 42.1, 6.63 },
    {  9, 16, 41.71, - 6, 21, 11.2, 5.24 },
    {  8,  2, 25.99, - 6, 20, 13.9, 6.33 },
    { 12, 47, 33.41, - 6, 18,  6.8, 6.26 },
    { 16,  5, 44.50, - 6, 17, 30.1, 6.53 },
    { 23, 31,  1.10, - 6, 17, 17.9, 6.39 },
    {  6, 14, 51.31, - 6, 16, 28.9, 3.98 },
    { 13, 31, 57.91, - 6, 15, 20.9, 4.69 },
    {  4, 20, 38.69, - 6, 14, 44.2, 6.27 },
    { 17, 16, 42.79, - 6, 14, 42.0, 6.09 },
    {  9, 51, 21.60, - 6, 10, 54.1, 6.42 },
    {  8, 22, 30.19, - 6, 10, 45.1, 6.15 },
    { 16, 54, 35.69, - 6,  9, 14.0, 5.25 },
    { 17, 52, 38.81, - 6,  8, 37.0, 6.21 },
    { 16,  5, 59.81, - 6,  8, 21.8, 6.41 },
    { 15, 46, 45.41, - 6,  7, 13.1, 6.24 },
    { 14, 27, 24.41, - 6,  7, 13.1, 6.17 },
    {  3,  6, 33.50, - 6,  5, 19.0, 5.27 },
    {  9, 27, 46.80, - 6,  4, 16.0, 5.38 },
    {  5, 36, 35.71, - 6,  3, 54.0, 5.72 },
    {  5, 12, 48.19, - 6,  3, 25.9, 5.91 },
    { 23, 14, 19.39, - 6,  2, 56.0, 4.22 },
    {  0,  1, 57.60, - 6,  0, 51.1, 4.41 },
    {  5, 35,   .91, - 6,  0, 33.1, 5.67 },
    {  5, 35,  2.71, - 6,  0,  6.8, 4.78 },
    { 14, 16,   .91, - 6,  0,  2.2, 4.08 },
    {  7, 22, 25.39, - 5, 58, 58.1, 5.82 },
    { 14, 14, 21.29, - 5, 56, 51.0, 6.36 },
    {  5, 37, 27.41, - 5, 56, 17.9, 6.05 },
    { 17, 29, 47.40, - 5, 55, 10.9, 6.37 },
    {  3, 16,   .89, - 5, 55,  7.0, 6.17 },
    { 21, 47, 38.11, - 5, 55,  1.9, 6.17 },
    { 17, 19, 59.50, - 5, 55,  1.9, 6.32 },
    {  9, 34, 32.69, - 5, 54, 54.0, 5.56 },
    { 18, 49, 40.99, - 5, 54, 46.1, 5.99 },
    { 18, 33, 22.90, - 5, 54, 41.0, 6.36 },
    {  5, 35, 25.99, - 5, 54, 36.0, 2.77 },
    { 23, 20, 40.90, - 5, 54, 29.2, 6.17 },
    {  6, 32, 23.11, - 5, 52,  8.0, 5.60 },
    {  6, 54,  8.50, - 5, 51,  9.0, 6.41 },
    { 18, 57,  3.70, - 5, 50, 46.0, 4.83 },
    { 12, 36, 47.40, - 5, 49, 54.8, 5.87 },
    { 15, 21,  7.61, - 5, 49, 28.9, 5.54 },
    { 21,  4,  4.61, - 5, 49, 23.9, 7.31 },
    { 21,  4,  4.70, - 5, 49, 23.2, 5.89 },
    {  7, 25, 51.00, - 5, 46, 30.0, 5.97 },
    {  5,  0, 49.01, - 5, 45, 11.9, 6.22 },
    { 17, 33, 29.90, - 5, 44, 40.9, 5.62 },
    { 19,  1, 40.80, - 5, 44, 20.0, 4.02 },
    {  1, 45, 59.30, - 5, 43, 59.9, 5.34 },
    { 18, 30, 14.30, - 5, 43, 27.1, 6.28 },
    {  7,  1, 56.40, - 5, 43, 19.9, 5.20 },
    {  6,  9, 36.19, - 5, 42, 40.0, 6.17 },
    {  0,  5, 20.11, - 5, 42, 27.0, 4.61 },
    { 18, 47, 28.99, - 5, 42, 18.0, 5.20 },
    { 15, 34, 20.81, - 5, 41, 42.0, 6.51 },
    { 19,  4, 24.19, - 5, 41,  6.0, 6.90 },
    {  4, 48, 36.31, - 5, 40, 26.0, 5.78 },
    { 14, 43,  3.60, - 5, 39, 29.9, 3.88 },
    {  5, 36, 15.00, - 5, 38, 53.2, 6.54 },
    { 20, 51, 25.70, - 5, 37, 35.0, 5.99 },
    {  3, 39,  1.10, - 5, 37, 34.0, 5.96 },
    { 21, 31, 33.50, - 5, 34, 16.0, 2.91 },
    { 13,  9, 57.00, - 5, 32, 20.0, 4.38 },
    {  5, 26,  2.40, - 5, 31,  5.9, 6.23 },
    { 20, 52,  8.71, - 5, 30, 24.8, 5.55 },
    { 15, 14, 50.69, - 5, 30, 10.1, 6.28 },
    { 13, 43, 54.31, - 5, 29, 56.0, 6.51 },
    {  3, 58, 52.30, - 5, 28, 12.0, 5.83 },
    {  4, 52, 53.69, - 5, 27, 10.1, 4.39 },
    {  8, 54, 17.90, - 5, 26,  3.8, 6.00 },
    {  7, 52, 47.90, - 5, 25, 41.2, 5.76 },
    { 21, 58, 13.30, - 5, 25, 28.9, 6.33 },
    {  5, 35, 22.90, - 5, 24, 58.0, 5.08 },
    { 19, 20, 32.90, - 5, 24, 56.9, 5.01 },
    { 13, 35, 31.30, - 5, 23, 46.0, 5.73 },
    {  5, 35, 16.49, - 5, 23, 22.9, 5.13 },
    {  5, 35, 17.30, - 5, 23, 16.1, 6.70 },
    { 22, 17,  6.50, - 5, 23, 13.9, 5.75 },
    {  5, 35, 15.91, - 5, 23, 13.9, 6.73 },
    {  5, 35, 16.10, - 5, 23,  7.1, 7.96 },
    { 14,  4, 14.59, - 5, 22, 53.0, 6.39 },
    {  7,  0, 18.00, - 5, 22,   .8, 6.30 },
    {  5, 20, 26.40, - 5, 22,   .1, 6.39 },
    {  3, 52, 41.59, - 5, 21, 41.0, 5.48 },
    { 18,  2, 46.30, - 5, 21, 31.0, 6.76 },
    { 11, 51,  2.21, - 5, 19, 59.9, 5.64 },
    {  8, 20, 17.11, - 5, 19, 45.1, 6.13 },
    {  7,  4,  5.21, - 5, 19, 25.0, 5.62 },
    {  6, 52, 22.90, - 5, 18, 58.0, 6.30 },
    {  0, 10, 18.79, - 5, 14, 55.0, 5.84 },
    {  7, 30, 51.10, - 5, 13, 35.0, 6.24 },
    {  6, 36, 35.30, - 5, 12, 40.0, 5.52 },
    {  3, 40, 38.30, - 5, 12, 38.2, 5.53 },
    {  4, 56, 24.19, - 5, 10, 17.0, 5.51 },
    { 13, 24, 33.19, - 5,  9, 50.0, 5.75 },
    { 23, 19, 24.00, - 5,  7, 27.8, 5.55 },
    {  9, 25, 24.00, - 5,  7,  3.0, 5.59 },
    { 10, 19, 32.21, - 5,  6, 20.9, 6.37 },
    { 17, 26, 37.90, - 5,  5, 12.1, 4.54 },
    {  5,  7, 51.00, - 5,  5, 11.0, 2.79 },
    {  3, 30, 37.10, - 5,  4, 31.1, 4.73 },
    { 12, 31, 38.71, - 5,  3,  9.0, 6.19 },
    { 20, 47, 44.21, - 5,  1, 40.1, 4.42 },
    { 14, 58, 52.80, - 4, 59, 21.1, 6.09 },
    { 22, 55, 10.99, - 4, 59, 16.1, 5.72 },
    {  8, 37, 27.10, - 4, 56,  1.0, 6.19 },
    { 13, 23, 18.91, - 4, 55, 27.8, 5.89 },
    {  6, 15, 29.69, - 4, 54, 55.1, 5.99 },
    { 19, 25,  1.61, - 4, 53,  3.1, 6.52 },
    { 19,  6, 14.90, - 4, 52, 57.0, 3.44 },
    {  5, 35, 39.50, - 4, 51, 20.9, 5.26 },
    {  5, 35, 23.21, - 4, 50, 17.9, 4.59 },
    { 22, 24,  6.89, - 4, 50, 12.8, 5.78 },
    {  1,  3,  2.59, - 4, 50, 12.1, 5.43 },
    { 17, 59, 36.70, - 4, 49, 17.0, 5.87 },
    {  5, 37, 53.40, - 4, 48, 49.0, 6.19 },
    { 22, 57, 17.21, - 4, 48, 36.0, 6.31 },
    { 23,  3, 57.29, - 4, 47, 43.1, 6.68 },
    {  5, 55, 35.40, - 4, 47, 17.9, 6.28 },
    {  1, 43, 54.79, - 4, 45, 56.2, 6.19 },
    {  6, 27, 57.60, - 4, 45, 43.9, 5.06 },
    { 18,  6, 15.19, - 4, 45,  5.0, 5.77 },
    { 18, 47, 10.51, - 4, 44, 52.1, 4.22 },
    { 21,  0, 33.79, - 4, 43, 49.1, 6.21 },
    { 22, 12, 43.80, - 4, 43, 14.9, 6.39 },
    {  8, 24, 36.41, - 4, 43,   .8, 6.01 },
    { 23,  1, 31.70, - 4, 42, 41.0, 5.94 },
    { 16, 18, 19.30, - 4, 41, 33.0, 3.24 },
    {  6, 23, 22.70, - 4, 41, 13.9, 6.67 },
    {  6, 11, 43.70, - 4, 39, 56.2, 6.18 },
    {  5,  6, 45.70, - 4, 39, 18.0, 5.12 },
    { 19, 37, 47.30, - 4, 38, 51.0, 5.46 },
    {  0, 45, 24.10, - 4, 37, 45.1, 6.15 },
    {  5, 55, 30.31, - 4, 36, 59.0, 5.87 },
    { 12, 27, 51.60, - 4, 36, 55.1, 6.22 },
    {  6, 26, 34.51, - 4, 35, 49.9, 6.15 },
    {  6, 14, 36.70, - 4, 34,  5.9, 5.83 },
    { 21, 21,  4.30, - 4, 33, 36.0, 5.87 },
    {  7, 26,  3.50, - 4, 32, 15.0, 6.76 },
    { 23, 29, 32.11, - 4, 31, 58.1, 6.25 },
    { 21, 18, 11.11, - 4, 31,  9.8, 5.82 },
    {  5, 35, 21.79, - 4, 29, 35.9, 6.56 },
    {  5,  8, 43.61, - 4, 27, 22.0, 5.12 },
    {  5, 35, 22.51, - 4, 25, 31.1, 6.24 },
    { 21, 58, 55.01, - 4, 22, 23.2, 6.22 },
    {  5, 35, 31.10, - 4, 21, 52.9, 6.38 },
    {  0, 40, 42.41, - 4, 21,  6.8, 5.91 },
    { 14, 57, 10.99, - 4, 20, 47.0, 4.49 },
    {  2, 19, 40.80, - 4, 20, 44.2, 6.50 },
    { 21, 54, 10.39, - 4, 16, 34.0, 5.71 },
    {  5, 46,  2.81, - 4, 16,  5.9, 6.34 },
    { 22, 10, 33.79, - 4, 16,  1.9, 6.01 },
    {  9, 29, 32.40, - 4, 14, 49.9, 6.26 },
    {  9, 51, 13.99, - 4, 14, 35.9, 6.01 },
    {  7,  2, 54.79, - 4, 14, 21.1, 4.99 },
    {  7, 10, 13.70, - 4, 14, 13.9, 4.92 },
    { 22, 37, 45.41, - 4, 13, 41.2, 5.03 },
    { 12, 53, 38.11, - 4, 13, 26.0, 6.44 },
    { 17,  1,  3.60, - 4, 13, 21.0, 4.82 },
    { 16, 12, 56.50, - 4, 13, 14.9, 6.25 },
    {  5,  2, 45.50, - 4, 12, 34.9, 5.85 },
    {  6,  6, 38.69, - 4, 11, 38.0, 5.38 },
    {  7, 37, 16.70, - 4,  6, 40.0, 5.13 },
    {  2,  3, 40.51, - 4,  6, 13.0, 5.62 },
    {  5, 48, 34.90, - 4,  5, 40.9, 5.97 },
    { 23, 31, 31.51, - 4,  5, 13.9, 6.49 },
    { 17, 56, 47.71, - 4,  4, 54.8, 5.47 },
    { 20,  6, 12.19, - 4,  4, 41.9, 6.47 },
    { 10, 23, 26.50, - 4,  4, 27.1, 5.97 },
    {  5, 54, 34.70, - 4,  3, 50.0, 6.57 },
    { 19,  4, 57.60, - 4,  1, 53.0, 5.42 },
    { 10, 49, 17.30, - 4,  1, 27.1, 6.61 },
    { 18, 13, 10.01, - 4,  0, 42.1, 6.59 },
    {  8, 26, 27.19, - 3, 59, 15.0, 5.59 },
    { 21, 35, 17.59, - 3, 58, 59.2, 5.77 },
    {  0, 30,  2.40, - 3, 57, 25.9, 5.72 },
    { 12, 18,  9.10, - 3, 57, 15.8, 6.99 },
    { 16, 16, 55.30, - 3, 57, 11.9, 6.18 },
    { 12, 18,  9.60, - 3, 56, 55.0, 6.54 },
    {  8, 25, 39.60, - 3, 54, 23.0, 3.90 },
    {  7, 14, 10.99, - 3, 54,  5.0, 5.75 },
    { 22, 10, 21.10, - 3, 53, 39.1, 6.27 },
    {  6, 25, 47.11, - 3, 53, 21.1, 6.35 },
    { 17,  8, 54.50, - 3, 52, 58.1, 6.36 },
    { 15, 48, 56.81, - 3, 49,  7.0, 5.53 },
    { 12, 59, 39.50, - 3, 48, 42.8, 5.79 },
    {  3, 11, 18.79, - 3, 48, 42.1, 6.05 },
    {  8, 24, 34.99, - 3, 45,  4.0, 5.61 },
    {  4, 23, 40.80, - 3, 44, 44.2, 5.17 },
    { 10, 28, 43.99, - 3, 44, 33.0, 6.05 },
    {  6, 13, 54.29, - 3, 44, 29.0, 5.83 },
    {  2, 56, 37.39, - 3, 42, 43.9, 5.17 },
    { 19,  2, 54.50, - 3, 41, 56.0, 5.42 },
    { 16, 14, 20.69, - 3, 41, 39.8, 2.74 },
    {  1, 42, 43.49, - 3, 41, 25.1, 4.99 },
    { 18,  0, 28.99, - 3, 41, 25.1, 4.62 },
    {  7, 59, 44.09, - 3, 40, 46.9, 4.93 },
    { 13,  3, 54.41, - 3, 39, 47.9, 6.59 },
    { 11, 16, 39.70, - 3, 39,  6.1, 4.47 },
    { 18, 15, 58.01, - 3, 37,  3.0, 6.36 },
    {  4, 36,  1.61, - 3, 36, 42.8, 6.33 },
    {  0, 35, 14.90, - 3, 35, 34.1, 5.20 },
    { 18, 24,  3.50, - 3, 34, 59.9, 6.38 },
    {  5, 39, 31.20, - 3, 33, 52.9, 6.00 },
    { 20, 56, 18.31, - 3, 33, 41.0, 6.57 },
    { 21, 25, 16.99, - 3, 33, 24.1, 5.49 },
    { 23, 58, 40.39, - 3, 33, 22.0, 4.86 },
    { 22, 40, 48.00, - 3, 33, 15.1, 6.31 },
    { 12, 53, 11.21, - 3, 33, 11.2, 6.11 },
    { 13, 59, 49.30, - 3, 32, 58.9, 6.40 },
    { 23, 15, 34.30, - 3, 29, 47.0, 5.55 },
    { 16,  9, 50.50, - 3, 28,   .8, 5.37 },
    {  5, 29, 23.59, - 3, 26, 47.0, 5.79 },
    {  8, 49, 21.70, - 3, 26, 35.2, 5.31 },
    { 15, 49, 37.20, - 3, 25, 49.1, 3.53 },
    { 21, 24, 51.70, - 3, 23, 53.9, 6.36 },
    {  2, 37, 41.81, - 3, 23, 46.0, 5.65 },
    {  3, 39, 38.30, - 3, 23, 35.2, 6.23 },
    { 13,  0, 35.90, - 3, 22,  7.0, 5.99 },
    { 20, 28, 24.91, - 3, 21, 28.1, 6.13 },
    {  4, 36, 19.10, - 3, 21,  9.0, 3.93 },
    { 18, 51, 22.10, - 3, 19,  4.1, 6.10 },
    {  5, 28, 56.71, - 3, 18, 27.0, 6.39 },
    { 21, 54, 35.90, - 3, 18,  4.0, 6.20 },
    {  4, 45, 30.10, - 3, 15, 16.9, 4.02 },
    {  5, 35, 35.81, - 3, 15, 10.1, 6.40 },
    {  1, 20, 34.49, - 3, 14, 48.8, 6.23 },
    {  2, 41, 48.29, - 3, 12, 47.9, 6.05 },
    {  4, 32, 37.39, - 3, 12, 33.1, 5.81 },
    { 14, 16, 30.10, - 3, 11, 47.0, 6.15 },
    { 18, 38, 23.71, - 3, 11, 37.0, 6.49 },
    { 23, 52, 55.61, - 3,  9, 20.2, 5.93 },
    { 12,  5, 59.81, - 3,  7, 54.1, 6.37 },
    { 19, 53, 18.70, - 3,  6, 51.8, 5.65 },
    { 10, 51,  5.40, - 3,  5, 33.0, 5.95 },
    { 15, 51, 15.60, - 3,  5, 26.2, 5.11 },
    {  6,  0,  3.41, - 3,  4, 27.1, 4.53 },
    {  5,  4, 54.50, - 3,  2, 22.9, 6.05 },
    { 15,  2, 44.90, - 3,  1, 53.0, 6.61 },
    {  0,  1, 49.39, - 3,  1, 39.0, 5.10 },
    { 18, 16, 53.11, - 3,  0, 25.9, 6.00 },
    { 11, 30, 18.91, - 3,  0, 13.0, 4.77 },
    {  8,  8, 35.59, - 2, 59,  2.0, 4.34 },
    {  7, 22, 18.50, - 2, 58, 44.0, 6.23 },
    {  2, 19, 20.71, - 2, 58, 39.0, 3.04 },
    {  3, 54, 17.50, - 2, 57, 16.9, 4.79 },
    {  4, 46, 24.10, - 2, 57, 15.8, 6.33 },
    {  3, 54, 17.40, - 2, 57, 10.1, 6.14 },
    {  6, 19, 59.59, - 2, 56, 39.8, 4.90 },
    { 22, 31, 18.41, - 2, 54, 40.0, 6.16 },
    { 18, 21, 18.60, - 2, 53, 56.0, 3.26 },
    {  5, 41, 40.30, - 2, 53, 46.0, 6.42 },
    { 20, 29, 39.00, - 2, 53,  8.2, 4.91 },
    { 19, 45, 52.20, - 2, 52, 59.9, 6.48 },
    {  8,  0, 44.09, - 2, 52, 54.1, 6.51 },
    {  3,  0, 51.00, - 2, 52, 43.0, 6.11 },
    {  1, 24, 48.70, - 2, 50, 55.0, 6.15 },
    {  5, 40, 37.30, - 2, 49, 30.0, 6.22 },
    {  6, 54, 58.80, - 2, 48, 13.0, 6.04 },
    { 20, 25, 42.50, - 2, 48,  1.1, 6.11 },
    { 19, 30, 39.79, - 2, 47, 20.0, 5.03 },
    {  2, 58, 42.00, - 2, 46, 57.0, 5.23 },
    {  2, 24, 58.39, - 2, 46, 48.0, 6.33 },
    {  9, 29,  8.90, - 2, 46,  8.0, 4.60 },
    { 23, 47, 56.50, - 2, 45, 42.1, 5.49 },
    { 15,  1, 19.80, - 2, 45, 18.0, 5.52 },
    { 10, 29, 28.70, - 2, 44, 21.1, 5.21 },
    { 16, 50, 22.30, - 2, 39, 14.0, 6.32 },
    {  8, 45, 20.81, - 2, 36,  2.9, 6.41 },
    {  5, 38, 44.81, - 2, 36,   .0, 3.81 },
    {  5, 38, 47.11, - 2, 35, 39.1, 6.65 },
    { 20, 36, 43.61, - 2, 33,   .0, 4.89 },
    {  0,  7, 44.11, - 2, 32, 56.0, 6.43 },
    {  6, 38, 20.50, - 2, 32, 37.0, 6.14 },
    {  8, 28, 29.21, - 2, 31,  1.9, 6.39 },
    {  6, 12, 44.40, - 2, 30, 15.8, 6.62 },
    {  1, 16, 36.31, - 2, 30,  1.1, 5.41 },
    {  5, 11, 19.20, - 2, 29, 26.9, 5.90 },
    { 20, 47,  3.60, - 2, 29, 12.1, 6.27 },
    { 11,  1, 49.70, - 2, 29,  4.9, 4.74 },
    {  4, 37, 36.10, - 2, 28, 23.9, 5.23 },
    {  2, 59, 41.21, - 2, 27, 54.0, 5.56 },
    { 19, 51, 11.11, - 2, 27, 38.9, 6.13 },
    {  0,  8, 12.10, - 2, 26, 52.1, 6.07 },
    { 11, 38, 24.10, - 2, 26, 10.0, 6.22 },
    { 15, 20, 47.09, - 2, 24, 47.9, 6.35 },
    { 20, 39, 13.20, - 2, 24, 46.1, 6.22 },
    {  5, 24, 28.61, - 2, 23, 48.8, 3.36 },
    { 22, 58, 15.50, - 2, 23, 43.1, 6.16 },
    {  2, 12, 47.50, - 2, 23, 37.0, 5.54 },
    { 17, 22, 51.29, - 2, 23, 17.9, 6.29 },
    { 16, 36, 21.50, - 2, 19, 28.9, 5.75 },
    { 14, 51,  1.01, - 2, 17, 57.1, 4.94 },
    {  6, 49, 16.39, - 2, 16, 18.8, 5.74 },
    { 14, 19, 32.50, - 2, 15, 56.2, 5.14 },
    { 10, 53, 24.89, - 2, 15, 19.1, 6.12 },
    {  5, 10, 58.01, - 2, 15, 14.0, 6.25 },
    {  1, 11, 43.49, - 2, 15,  4.0, 5.94 },
    { 14, 28, 12.10, - 2, 13, 41.2, 4.81 },
    {  0, 24, 29.71, - 2, 13,  9.1, 6.07 },
    {  4, 58, 10.80, - 2, 12, 45.0, 6.35 },
    {  9, 29, 24.50, - 2, 12, 19.1, 6.14 },
    { 22,  3, 18.89, - 2,  9, 19.1, 4.69 },
    { 17, 40, 11.81, - 2,  9,  9.0, 6.19 },
    {  8, 34,  1.61, - 2,  9,  6.1, 5.81 },
    { 10, 53, 43.70, - 2,  7, 45.1, 5.45 },
    { 16, 22, 38.90, - 2,  4, 46.9, 6.23 },
    {  5,  0, 39.79, - 2,  3, 56.2, 6.32 },
    {  8, 46,  2.50, - 2,  2, 56.0, 5.70 },
    { 18, 29, 40.99, - 1, 59,  7.1, 5.39 },
    { 10, 48, 40.61, - 1, 57, 32.0, 5.93 },
    {  5, 40, 45.60, - 1, 56, 34.1, 4.21 },
    {  5, 40, 45.50, - 1, 56, 34.1, 2.05 },
    {  7, 29, 18.70, - 1, 54, 19.1, 5.59 },
    {  8, 47, 15.00, - 1, 53, 49.9, 5.29 },
    {  2, 11, 35.81, - 1, 49, 31.1, 5.93 },
    { 15, 46,  5.59, - 1, 48, 15.8, 5.40 },
    { 18, 56, 22.70, - 1, 48,   .0, 6.22 },
    { 12,  1,  1.80, - 1, 46,  5.2, 6.31 },
    {  6, 54, 42.10, - 1, 45, 23.0, 6.21 },
    { 10, 41, 24.19, - 1, 44, 30.1, 6.26 },
    {  5, 33,  7.20, - 1, 43,  5.9, 6.46 },
    { 11, 27, 53.71, - 1, 42,   .0, 6.25 },
    { 17,  6, 52.90, - 1, 39, 23.0, 6.38 },
    { 17, 25, 57.89, - 1, 39,  6.1, 6.44 },
    {  5, 43,  9.29, - 1, 36, 47.2, 6.31 },
    { 16, 54, 10.61, - 1, 36, 43.9, 6.25 },
    { 21, 16, 39.60, - 1, 36, 28.1, 6.48 },
    {  8, 21, 20.21, - 1, 36,  7.9, 6.50 },
    { 22, 16, 33.60, - 1, 35, 47.0, 6.15 },
    {  5, 32, 41.30, - 1, 35, 30.8, 5.35 },
    { 18, 24, 57.00, - 1, 34, 45.8, 6.15 },
    { 12, 43, 38.11, - 1, 34, 36.8, 5.93 },
    { 22, 34,  2.90, - 1, 34, 27.1, 5.89 },
    {  4,  1, 31.99, - 1, 32, 58.9, 5.28 },
    { 19,  5, 18.60, - 1, 30, 46.1, 6.53 },
    {  6, 26, 39.60, - 1, 30, 25.9, 5.87 },
    { 13, 54, 42.10, - 1, 30, 11.2, 5.15 },
    {  5, 34,  4.01, - 1, 28, 14.2, 5.93 },
    {  9, 26, 22.30, - 1, 27, 50.0, 6.01 },
    { 12, 41, 39.60, - 1, 26, 57.8, 3.68 },
    { 12, 41, 39.60, - 1, 26, 57.8, 3.65 },
    {  5, 59, 37.70, - 1, 26, 39.8, 6.63 },
    { 14, 45, 11.71, - 1, 25,  4.1, 6.07 },
    {  5, 19, 35.21, - 1, 24, 43.9, 6.34 },
    { 22, 58, 23.71, - 1, 24, 37.1, 6.37 },
    {  5, 15, 18.41, - 1, 24, 33.1, 6.15 },
    {  8,  1, 13.30, - 1, 23, 33.0, 4.68 },
    { 13, 16, 25.49, - 1, 23, 26.2, 6.68 },
    { 22, 21, 39.41, - 1, 23, 13.9, 3.84 },
    { 20, 55,  8.11, - 1, 22, 23.9, 6.55 },
    { 13, 29, 14.90, - 1, 21, 51.8, 6.43 },
    {  7,  1, 52.90, - 1, 20, 44.2, 6.17 },
    {  6, 48, 19.01, - 1, 19,  9.1, 5.75 },
    { 19, 36, 43.30, - 1, 17, 11.0, 4.36 },
    {  9, 29,  2.21, - 1, 15, 24.8, 6.27 },
    { 23, 34,  9.00, - 1, 14, 51.0, 5.87 },
    { 17, 51, 59.50, - 1, 14, 12.1, 6.35 },
    {  6, 33, 37.90, - 1, 13, 13.1, 5.10 },
    {  5, 36, 12.79, - 1, 12,  6.8, 1.70 },
    {  3, 12, 46.39, - 1, 11, 46.0, 5.06 },
    { 13, 26, 11.40, - 1, 11, 33.0, 5.97 },
    { 15, 32, 57.91, - 1, 11, 11.0, 5.51 },
    {  9, 31, 58.90, - 1, 11,  6.0, 4.57 },
    {  3, 44, 30.50, - 1,  9, 47.2, 5.25 },
    {  5, 33, 31.39, - 1,  9, 22.0, 5.34 },
    {  4, 13, 38.21, - 1,  8, 58.9, 6.44 },
    {  0, 53,   .50, - 1,  8, 39.1, 4.77 },
    {  9, 39, 51.41, - 1,  8, 34.1, 3.91 },
    {  5, 40, 50.59, - 1,  7, 44.0, 4.95 },
    {  6, 54, 24.60, - 1,  7, 36.8, 5.45 },
    {  3, 39, 59.50, - 1,  7, 14.2, 6.12 },
    { 18, 38, 19.10, - 1,  6, 47.9, 6.66 },
    { 20, 38, 20.30, - 1,  6, 19.1, 4.32 },
    {  5, 29, 43.99, - 1,  5, 31.9, 4.71 },
    { 23, 31, 57.60, - 1,  5,  8.9, 6.38 },
    { 17,  8, 13.61, - 1,  4, 45.8, 6.06 },
    { 20, 19, 43.30, - 1,  4, 43.0, 6.06 },
    {  4, 57, 17.21, - 1,  4,  1.9, 6.23 },
    { 17, 30, 23.81, - 1,  3, 45.0, 5.31 },
    {  4, 39, 47.21, - 1,  3, 10.1, 6.10 },
    {  5, 34,  3.91, - 1,  2,  8.2, 6.22 },
    {  2, 32,  9.41, - 1,  2,  6.0, 5.35 },
    { 15, 23, 43.70, - 1,  1, 21.0, 6.12 },
    { 20, 13, 13.90, - 1,  0, 33.8, 5.47 },
    { 18, 31, 57.00, - 1,  0, 11.2, 5.94 },
    { 16, 41, 11.50, - 1,  0,  2.2, 6.24 },
    {  5, 58, 11.71, - 0, 59, 39.1, 6.22 },
    {  1, 14, 49.20, - 0, 58, 26.0, 5.70 },
    { 18, 46, 28.49, - 0, 57, 42.1, 5.90 },
    {  6, 25, 16.39, - 0, 56, 46.0, 5.87 },
    {  3, 18, 22.39, - 0, 55, 49.1, 5.38 },
    { 21,  2, 59.59, - 0, 55, 28.9, 6.50 },
    {  8, 20, 13.10, - 0, 54, 33.8, 6.18 },
    { 22,  4, 47.40, - 0, 54, 24.1, 5.30 },
    { 19, 20, 35.69, - 0, 53, 31.9, 5.49 },
    { 17,  5, 32.30, - 0, 53, 30.8, 5.64 },
    {  5, 24, 28.90, - 0, 53, 29.0, 5.08 },
    {  2, 22, 12.41, - 0, 53,  6.0, 5.42 },
    {  5, 23, 51.41, - 0, 52,  1.9, 6.11 },
    { 14, 48, 54.10, - 0, 50, 52.1, 6.14 },
    { 14, 13, 40.80, - 0, 50, 44.2, 5.91 },
    { 11, 36, 56.90, - 0, 49, 26.0, 4.30 },
    { 20, 11, 18.31, - 0, 49, 17.0, 3.23 },
    { 12, 18, 40.30, - 0, 47, 13.9, 5.90 },
    { 11,  3, 14.59, - 0, 45,  9.0, 6.14 },
    { 20,  4, 23.21, - 0, 42, 33.8, 5.68 },
    {  2, 41, 13.90, - 0, 41, 44.9, 5.71 },
    { 20,  8,  1.80, - 0, 40, 41.9, 5.99 },
    { 13, 17, 29.90, - 0, 40, 36.1, 6.37 },
    { 12, 19, 54.41, - 0, 40,   .8, 3.89 },
    { 10, 30, 17.50, - 0, 38, 12.8, 5.09 },
    { 19, 40, 43.30, - 0, 37, 16.0, 5.67 },
    { 13, 34, 41.59, - 0, 35, 44.9, 3.37 },
    {  8,  5, 49.61, - 0, 34, 25.0, 6.41 },
    {  5, 10,  3.19, - 0, 33, 55.1, 6.10 },
    { 15, 36, 33.70, - 0, 33, 42.1, 6.51 },
    {  5, 25, 31.20, - 0, 32, 39.1, 6.57 },
    {  6, 50, 49.90, - 0, 32, 26.9, 5.77 },
    {  6, 15, 34.30, - 0, 30, 43.9, 5.65 },
    {  1, 19, 48.31, - 0, 30, 32.0, 5.87 },
    {  0, 35, 32.81, - 0, 30, 20.2, 5.93 },
    {  0,  5,  3.79, - 0, 30, 11.2, 6.29 },
    {  7, 11, 51.89, - 0, 29, 34.1, 4.15 },
    {  9,  1, 58.01, - 0, 28, 58.1, 5.67 },
    { 15, 18, 26.21, - 0, 27, 41.0, 5.89 },
    {  1, 22, 34.80, - 0, 26, 58.9, 6.49 },
    { 18,  6,  7.39, - 0, 26, 48.1, 6.34 },
    { 17, 16, 36.70, - 0, 26, 43.1, 4.73 },
    { 19,  9, 51.60, - 0, 25, 41.2, 6.34 },
    {  5, 21, 31.80, - 0, 24, 59.0, 5.68 },
    {  1, 26, 27.31, - 0, 23, 55.0, 6.41 },
    { 21, 37, 33.79, - 0, 23, 25.1, 6.25 },
    {  5, 21, 45.70, - 0, 22, 57.0, 4.73 },
    { 10,  7, 56.30, - 0, 22, 18.1, 4.49 },
    {  2,  3, 48.19, - 0, 20, 25.1, 5.93 },
    { 22,  5, 46.99, - 0, 19, 10.9, 2.96 },
    { 11, 49,  1.20, - 0, 19,  7.0, 6.15 },
    { 18, 37, 36.00, - 0, 18, 33.8, 5.75 },
    {  7, 11, 23.59, - 0, 18,  6.8, 5.45 },
    {  5, 32,   .41, - 0, 17, 57.1, 2.23 },
    {  3, 44, 56.50, - 0, 17, 48.1, 5.55 },
    {  5, 32,   .50, - 0, 17,  3.8, 6.85 },
    {  6, 27, 15.60, - 0, 16, 34.0, 5.55 },
    {  4,  2, 36.70, - 0, 16,  8.0, 5.38 },
    { 14, 51,   .10, - 0, 15, 25.9, 6.18 },
    { 19, 22, 21.50, - 0, 15,  9.0, 5.83 },
    { 22, 18,  4.30, - 0, 14, 16.1, 6.39 },
    { 10, 52, 36.10, - 0, 12,  5.0, 6.31 },
    { 14, 57, 33.29, - 0, 10,  3.0, 5.53 },
    {  7, 15, 19.30, - 0,  9, 41.0, 6.41 },
    {  5, 23, 42.29, - 0,  9, 34.9, 5.70 },
    { 15,  1, 48.91, - 0,  8, 26.2, 5.71 },
    { 22, 35, 21.41, - 0,  7,  3.0, 4.02 },
    {  4, 21, 27.10, - 0,  5, 53.2, 5.86 },
    { 11, 13, 45.60, - 0,  4, 10.9, 5.42 },
    {  0, 26, 37.39, - 0,  2, 58.9, 6.19 },
    {  4, 31, 52.70, - 0,  2, 38.0, 4.91 },
    { 22, 28, 49.70, - 0,  1, 13.1, 4.59 },
    { 22, 28, 50.09, - 0,  1, 12.0, 4.42 },
    { 11,  3, 36.60, - 0,  0,  2.9, 5.95 },
    {  2,  6, 29.30, + 0,  2,  6.0, 6.28 },
    { 17, 57,  4.30, + 0,  3, 59.0, 5.97 },
    {  9, 52, 12.00, + 0,  4, 32.2, 6.35 },
    { 21, 14, 37.01, + 0,  5, 31.9, 6.38 },
    { 20, 37, 18.31, + 0,  5, 48.8, 6.22 },
    { 23, 54, 46.61, + 0,  6, 33.1, 5.61 },
    {  2,  3, 11.69, + 0,  7, 41.9, 5.43 },
    { 11, 23, 18.00, + 0,  7, 54.1, 6.05 },
    {  7, 22,  3.50, + 0, 10, 37.9, 5.99 },
    { 23,  0, 37.90, + 0, 11,  8.9, 6.21 },
    {  7, 43,  5.40, + 0, 11, 21.8, 6.19 },
    { 18, 27, 12.50, + 0, 11, 46.0, 5.21 },
    {  3, 48, 38.90, + 0, 13, 40.1, 5.91 },
    { 19, 29, 18.00, + 0, 14, 46.0, 6.25 },
    {  2, 30, 45.19, + 0, 15, 19.1, 6.00 },
    { 19, 54, 44.81, + 0, 16, 25.0, 5.61 },
    { 23, 23, 31.90, + 0, 17, 29.0, 6.31 },
    {  6, 27, 13.80, + 0, 17, 57.1, 5.20 },
    {  2, 39, 28.99, + 0, 19, 43.0, 4.07 },
    { 17, 28, 49.70, + 0, 19, 50.2, 5.44 },
    {  5, 41,  5.59, + 0, 20, 16.1, 5.93 },
    { 19, 26, 31.10, + 0, 20, 19.0, 4.66 },
    { 19, 18, 50.90, + 0, 20, 21.1, 6.41 },
    { 17, 12, 54.41, + 0, 21,  6.8, 6.65 },
    { 15, 15, 49.10, + 0, 22, 19.9, 5.63 },
    { 14, 19, 40.90, + 0, 23,  3.1, 6.19 },
    {  2, 21, 56.59, + 0, 23, 44.9, 5.28 },
    {  3, 36, 52.39, + 0, 24,  6.1, 4.28 },
    { 20, 57, 10.61, + 0, 27, 49.0, 6.05 },
    {  4, 54, 50.71, + 0, 28,  3.0, 5.99 },
    { 20, 39, 24.91, + 0, 29, 11.0, 5.16 },
    {  6, 41,  5.40, + 0, 29, 43.1, 5.79 },
    {  5, 11, 41.40, + 0, 30, 52.9, 6.67 },
    {  5, 25, 46.99, + 0, 31, 14.9, 6.16 },
    { 11, 59,  3.41, + 0, 31, 50.2, 6.17 },
    { 21, 25, 51.50, + 0, 32,  3.8, 6.46 },
    { 11, 53, 50.30, + 0, 33,  6.8, 6.30 },
    {  5, 58, 49.61, + 0, 33, 11.2, 5.22 },
    {  5, 13, 47.21, + 0, 33, 37.1, 6.32 },
    {  3, 36, 47.30, + 0, 35, 16.1, 5.71 },
    { 22,  1,  4.99, + 0, 36, 18.0, 5.58 },
    { 18,  0, 15.50, + 0, 37, 45.8, 6.37 },
    { 19,  7,  9.10, + 0, 38, 30.1, 6.56 },
    { 16, 28, 34.01, + 0, 39, 54.0, 5.39 },
    { 17, 56, 18.41, + 0, 40, 13.1, 5.82 },
    { 17,  5, 16.90, + 0, 42,  9.0, 6.01 },
    { 15, 21,  1.99, + 0, 42, 55.1, 5.35 },
    { 14, 45, 30.19, + 0, 43,  1.9, 5.69 },
    {  5,  1, 50.30, + 0, 43, 19.9, 5.92 },
    { 10, 55, 42.41, + 0, 44, 12.8, 5.91 },
    { 14, 29, 50.50, + 0, 49, 44.0, 5.94 },
    { 18, 49, 37.10, + 0, 50,  8.9, 6.25 },
    {  6, 26, 58.70, + 0, 50, 26.9, 6.71 },
    { 20, 12, 35.21, + 0, 52,  3.0, 6.27 },
    {  6, 35, 15.79, + 0, 53, 24.0, 5.80 },
    { 15, 45, 39.70, + 0, 53, 29.0, 6.33 },
    { 22, 59, 27.41, + 0, 57, 46.1, 5.43 },
    {  5, 54, 44.09, + 0, 58,  5.9, 6.00 },
    {  4, 37, 13.70, + 0, 59, 53.9, 5.31 },
    {  6, 49,  3.70, + 1,  0,  6.8, 6.15 },
    { 19, 52, 28.39, + 1,  0, 20.2, 3.90 },
    { 18, 17,  4.80, + 1,  0, 20.9, 6.63 },
    { 16, 45, 29.69, + 1,  1, 13.1, 6.03 },
    { 10, 52, 13.70, + 1,  1, 31.1, 6.38 },
    { 16, 22,  4.39, + 1,  1, 45.1, 4.82 },
    {  5, 11, 45.31, + 1,  2, 12.8, 5.89 },
    { 13, 56, 27.91, + 1,  3,  2.2, 5.91 },
    { 22, 54, 59.50, + 1,  3, 52.9, 6.11 },
    { 20, 24, 37.49, + 1,  4,  7.0, 6.15 },
    { 23, 49, 27.50, + 1,  4, 34.0, 5.77 },
    {  6, 16, 21.19, + 1,  4, 49.1, 6.63 },
    { 19, 18, 32.50, + 1,  5,  7.1, 5.10 },
    { 21, 26, 28.10, + 1,  6, 11.9, 6.13 },
    { 23, 27, 14.81, + 1,  7, 21.0, 6.25 },
    {  7, 57, 16.20, + 1,  7, 36.8, 6.35 },
    {  5, 46, 34.99, + 1, 10,  5.2, 5.95 },
    {  6, 15, 54.00, + 1, 10,  9.1, 6.37 },
    {  5,  5, 23.69, + 1, 10, 39.0, 6.17 },
    { 16, 41, 42.50, + 1, 10, 52.0, 5.74 },
    { 17, 16, 31.70, + 1, 12, 38.2, 5.88 },
    { 16, 51, 24.89, + 1, 12, 58.0, 5.51 },
    {  5, 57, 54.19, + 1, 13, 27.8, 6.22 },
    { 14, 23, 15.31, + 1, 14, 30.1, 6.27 },
    { 23, 26, 55.99, + 1, 15, 20.2, 4.94 },
    { 21, 42, 10.10, + 1, 17,  7.1, 5.67 },
    {  5, 28,  1.61, + 1, 17, 53.9, 6.41 },
    { 17, 52, 35.40, + 1, 18, 18.0, 5.95 },
    { 18,  1, 45.19, + 1, 18, 19.1, 4.45 },
    { 23,  5, 17.59, + 1, 18, 24.8, 6.39 },
    { 14, 11, 31.20, + 1, 21, 43.9, 6.43 },
    {  1,  3, 49.01, + 1, 22,   .1, 6.04 },
    { 22, 25, 16.61, + 1, 22, 39.0, 4.66 },
    { 19, 59, 22.70, + 1, 22, 40.1, 6.17 },
    {  4, 28, 32.11, + 1, 22, 50.9, 5.55 },
    {  5, 33, 57.60, + 1, 24, 28.1, 6.59 },
    { 11, 24,  2.30, + 1, 24, 28.1, 5.39 },
    {  9,  6, 59.90, + 1, 27, 46.1, 6.17 },
    {  5, 42, 28.61, + 1, 28, 28.9, 4.91 },
    {  7,  4, 20.21, + 1, 29, 17.9, 6.57 },
    {  6, 25, 18.41, + 1, 30,  4.0, 6.66 },
    { 21,  3,  3.00, + 1, 31, 54.8, 6.25 },
    {  8, 58,  8.21, + 1, 32, 30.1, 6.59 },
    { 14,  1, 38.81, + 1, 32, 39.8, 4.26 },
    {  4, 53, 55.80, + 1, 34,  9.8, 6.61 },
    {  5,  2,   .00, + 1, 36, 32.0, 6.24 },
    {  6, 38, 38.11, + 1, 36, 49.0, 6.21 },
    { 11, 18, 55.01, + 1, 39,  2.2, 5.91 },
    { 15, 35,  4.61, + 1, 40,  8.0, 6.56 },
    {  0, 17, 47.71, + 1, 41, 20.0, 6.17 },
    {  6,  2, 17.11, + 1, 41, 39.8, 6.59 },
    {  4, 58, 32.90, + 1, 42, 51.1, 4.47 },
    {  1, 22, 37.01, + 1, 43, 35.0, 6.20 },
    {  2, 18,  1.39, + 1, 45, 28.1, 5.58 },
    { 11, 50, 41.71, + 1, 45, 52.9, 3.61 },
    { 15, 19, 18.79, + 1, 45, 55.1, 5.06 },
    {  7, 51, 42.00, + 1, 46,   .8, 5.14 },
    { 23, 42,  2.81, + 1, 46, 48.0, 4.50 },
    {  9, 46, 23.59, + 1, 47,  8.2, 5.65 },
    {  5, 29, 54.79, + 1, 47, 21.1, 5.78 },
    { 19,  3, 32.21, + 1, 49,  8.0, 5.83 },
    {  5, 58, 24.41, + 1, 50, 12.8, 5.90 },
    { 15, 28, 38.21, + 1, 50, 31.9, 5.17 },
    {  5, 24, 44.81, + 1, 50, 47.0, 4.95 },
    {  1, 55, 53.81, + 1, 50, 58.9, 6.01 },
    { 12, 38, 22.39, + 1, 51, 16.9, 5.71 },
    {  5, 52, 26.40, + 1, 51, 18.0, 4.78 },
    {  4, 28,  3.60, + 1, 51, 31.0, 6.15 },
    {  3,  4, 38.09, + 1, 51, 49.0, 6.05 },
    {  9, 32, 41.40, + 1, 51, 51.1, 6.11 },
    { 14, 46, 14.90, + 1, 53, 34.1, 3.72 },
    { 12,  9, 41.30, + 1, 53, 52.1, 5.95 },
    {  6, 28, 16.80, + 1, 54, 43.9, 6.48 },
    {  7, 32,  5.90, + 1, 54, 51.8, 5.25 },
    { 18,  4, 37.30, + 1, 55,  9.1, 6.14 },
    {  0, 25, 24.19, + 1, 56, 22.9, 5.77 },
    {  5, 16, 41.09, + 1, 56, 49.9, 6.42 },
    { 19, 29,  1.01, + 1, 57,  1.1, 5.80 },
    { 11,  6, 54.19, + 1, 57, 20.2, 5.52 },
    {  2, 28,   .00, + 1, 57, 38.9, 6.45 },
    { 17, 49, 18.89, + 1, 57, 40.0, 6.47 },
    {  5, 13, 31.61, + 1, 58,  5.2, 6.09 },
    { 16, 30, 54.79, + 1, 59,  2.0, 3.82 },
    { 11, 17, 17.40, + 2,  0, 38.2, 5.18 },
    {  5, 50, 30.00, + 2,  1, 27.8, 5.98 },
    { 17, 39,  8.50, + 2,  1, 41.2, 6.26 },
    { 19, 17, 48.19, + 2,  1, 54.1, 6.19 },
    { 18, 44, 49.90, + 2,  3, 36.0, 5.02 },
    { 16, 47,  9.79, + 2,  3, 51.8, 6.10 },
    {  4, 27,   .70, + 2,  4, 45.8, 6.23 },
    { 13, 21, 41.59, + 2,  5, 13.9, 5.69 },
    { 23, 53,  4.80, + 2,  5, 26.2, 6.28 },
    { 15,  2, 54.00, + 2,  5, 29.0, 4.40 },
    {  8, 25, 35.50, + 2,  6,  7.9, 5.73 },
    { 23, 36, 23.30, + 2,  6,  7.9, 5.68 },
    { 23,  8, 40.90, + 2,  7, 40.1, 5.40 },
    { 17, 16, 14.21, + 2, 11, 10.0, 6.17 },
    { 15, 50, 17.50, + 2, 11, 47.0, 5.23 },
    { 23, 48, 49.30, + 2, 12, 51.1, 6.46 },
    {  7, 58, 20.59, + 2, 13, 28.9, 5.29 },
    { 21, 39, 33.31, + 2, 14, 37.0, 5.10 },
    {  2, 31, 30.10, + 2, 16,  1.9, 5.25 },
    {  6, 21, 25.80, + 2, 16,  7.0, 6.31 },
    { 21,  4, 45.41, + 2, 16, 10.9, 6.33 },
    {  6, 25, 46.61, + 2, 16, 19.9, 6.51 },
    { 10, 21,  1.99, + 2, 17, 22.9, 6.66 },
    { 19, 13, 42.70, + 2, 17, 37.0, 5.15 },
    { 14,  4, 37.49, + 2, 17, 51.0, 6.28 },
    {  9, 14, 21.89, + 2, 18, 51.1, 3.88 },
    {  8,  2, 15.91, + 2, 20,  3.8, 4.39 },
    { 16, 26, 50.11, + 2, 20, 51.0, 6.07 },
    {  5, 24, 36.19, + 2, 21, 10.1, 6.32 },
    { 10, 24, 13.10, + 2, 22,  5.2, 6.32 },
    { 18, 16,  5.59, + 2, 22, 40.1, 6.01 },
    {  7, 44,  7.39, + 2, 24, 18.0, 6.47 },
    { 14, 12, 15.79, + 2, 24, 33.8, 5.01 },
    {  6, 47, 51.60, + 2, 24, 43.9, 4.47 },
    {  4, 54, 15.10, + 2, 26, 26.2, 3.72 },
    {  1, 10, 33.60, + 2, 26, 44.2, 5.95 },
    {  9, 52, 12.19, + 2, 27, 15.1, 6.02 },
    { 18, 56, 25.61, + 2, 28, 16.0, 6.15 },
    { 10, 45,  9.41, + 2, 29, 17.2, 6.28 },
    {  6,  8, 57.89, + 2, 29, 57.8, 5.73 },
    { 18,  5, 27.29, + 2, 29, 57.8, 4.03 },
    {  4, 53, 22.80, + 2, 30, 29.2, 5.33 },
    { 15, 44,  1.80, + 2, 30, 54.0, 5.88 },
    { 18, 57, 16.61, + 2, 32,  7.1, 5.57 },
    { 17, 44, 35.40, + 2, 34, 44.0, 6.56 },
    { 17, 44, 34.01, + 2, 34, 45.8, 6.17 },
    {  5, 19, 11.21, + 2, 35, 44.9, 5.34 },
    {  6, 29, 14.90, + 2, 38, 46.0, 6.16 },
    { 21, 47, 13.99, + 2, 41, 10.0, 5.64 },
    {  6, 37, 40.30, + 2, 42, 15.1, 6.17 },
    { 17, 47, 53.59, + 2, 42, 25.9, 3.75 },
    { 17, 31, 21.29, + 2, 43, 27.8, 5.59 },
    {  7, 34, 46.01, + 2, 43, 30.0, 6.55 },
    {  7, 19, 22.39, + 2, 44, 26.2, 5.89 },
    {  8, 35, 24.89, + 2, 44, 37.0, 6.33 },
    {  2,  2,  2.81, + 2, 45, 49.0, 5.23 },
    {  2,  2,  2.81, + 2, 45, 49.0, 4.33 },
    {  4,  4,  9.89, + 2, 49, 36.8, 5.36 },
    { 11, 27, 56.21, + 2, 51, 22.0, 4.95 },
    {  5, 13, 17.50, + 2, 51, 40.0, 4.46 },
    { 19, 30, 10.51, + 2, 54, 15.1, 6.09 },
    {  6, 27, 20.40, + 2, 54, 29.2, 5.55 },
    { 19, 35, 25.20, + 2, 54, 47.9, 6.38 },
    { 19, 28, 20.81, + 2, 55, 49.1, 5.85 },
    { 23, 51, 57.89, + 2, 55, 49.1, 5.55 },
    { 18,  0, 38.71, + 2, 55, 54.1, 3.97 },
    { 20, 28, 16.80, + 2, 56, 12.8, 6.21 },
    { 13, 20, 41.59, + 2, 56, 30.1, 6.26 },
    { 21,  4, 41.69, + 2, 56, 30.8, 6.42 },
    { 21,  9, 58.30, + 2, 56, 35.9, 6.45 },
    { 23,  0, 42.89, + 3,  0, 42.1, 5.83 },
    { 11, 26, 45.31, + 3,  0, 47.2, 6.50 },
    {  6, 43,  6.50, + 3,  1, 59.9, 6.19 },
    {  6, 51, 39.29, + 3,  2, 30.1, 6.38 },
    { 12, 51, 36.89, + 3,  3, 24.1, 6.02 },
    {  3, 39, 51.10, + 3,  3, 24.8, 5.57 },
    { 11, 34, 22.01, + 3,  3, 36.0, 5.77 },
    {  5, 26, 50.21, + 3,  5, 44.2, 4.59 },
    {  2,  0,  9.19, + 3,  5, 49.9, 5.88 },
    {  7, 14, 19.99, + 3,  6, 41.0, 5.35 },
    { 19, 25, 29.90, + 3,  6, 52.9, 3.36 },
    { 18,  9, 54.00, + 3,  7, 10.9, 5.69 },
    {  0, 37, 30.50, + 3,  8,  7.1, 6.39 },
    {  1, 53, 33.31, + 3, 11, 15.0, 4.62 },
    { 10,  4,  8.40, + 3, 12,  4.0, 6.45 },
    {  5, 54, 15.70, + 3, 13, 31.1, 6.31 },
    {  2, 43, 18.00, + 3, 14,  8.9, 3.47 },
    {  7, 52,  7.20, + 3, 16, 37.9, 6.31 },
    {  7, 50, 47.40, + 3, 16, 37.9, 6.18 },
    { 23, 17,  9.91, + 3, 16, 55.9, 3.69 },
    { 12, 38,  4.39, + 3, 16, 57.0, 6.33 },
    {  7, 33, 11.59, + 3, 17, 25.1, 5.59 },
    {  5, 31, 14.50, + 3, 17, 31.9, 5.46 },
    { 20, 47, 47.81, + 3, 18, 24.1, 6.40 },
    { 12, 20, 21.00, + 3, 18, 45.0, 4.96 },
    { 18, 10, 40.30, + 3, 19, 27.1, 5.51 },
    { 19,  4, 10.70, + 3, 19, 50.2, 6.73 },
    { 14, 14, 52.99, + 3, 20, 10.0, 6.45 },
    {  8, 38, 45.41, + 3, 20, 29.0, 4.44 },
    {  3, 19, 21.70, + 3, 22, 13.1, 4.83 },
    {  7, 34, 15.79, + 3, 22, 17.0, 5.81 },
    { 18, 20, 52.10, + 3, 22, 37.9, 4.86 },
    { 19, 38, 49.01, + 3, 22, 54.1, 6.35 },
    {  9, 59, 43.10, + 3, 23,  4.9, 6.70 },
    {  0, 51, 18.31, + 3, 23,  6.0, 6.37 },
    { 12, 55, 36.19, + 3, 23, 51.0, 3.38 },
    {  8, 43, 13.49, + 3, 23, 55.0, 4.30 },
    {  2, 38, 36.91, + 3, 26, 35.2, 6.21 },
    { 19, 30, 33.10, + 3, 26, 39.8, 6.05 },
    { 16,  8, 58.90, + 3, 27, 15.8, 5.91 },
    { 23, 46, 23.50, + 3, 29, 12.1, 5.04 },
    {  1, 26, 53.50, + 3, 32,  7.1, 6.58 },
    { 13, 43,  3.70, + 3, 32, 17.2, 5.36 },
    {  5, 22, 49.99, + 3, 32, 39.8, 5.00 },
    { 12, 47, 51.41, + 3, 34, 22.1, 6.41 },
    {  4, 48, 44.59, + 3, 35, 17.9, 6.03 },
    {  6, 58, 57.00, + 3, 36,  7.9, 5.97 },
    {  1, 17, 48.00, + 3, 36, 51.8, 5.16 },
    {  5,  0, 32.59, + 3, 36, 55.1, 7.03 },
    {  5,  0, 33.91, + 3, 36, 58.0, 6.66 },
    { 11,  0, 33.60, + 3, 37,  3.0, 4.84 },
    {  7, 41, 35.21, + 3, 37, 28.9, 5.94 },
    { 11, 59, 56.90, + 3, 39, 19.1, 5.37 },
    { 13, 34,  7.90, + 3, 39, 32.0, 4.94 },
    { 18, 32,  7.01, + 3, 39, 34.9, 6.43 },
    {  3, 21,  6.79, + 3, 40, 32.2, 5.69 },
    {  1, 48, 25.99, + 3, 41,  8.2, 5.91 },
    { 13, 18, 51.10, + 3, 41, 16.1, 6.62 },
    { 18, 27, 50.30, + 3, 44, 55.0, 6.07 },
    {  6, 23, 18.50, + 3, 45, 51.8, 6.40 },
    {  5, 34, 16.70, + 3, 46,   .8, 5.36 },
    { 17, 48, 20.21, + 3, 48, 15.1, 6.22 },
    { 22, 57, 32.81, + 3, 48, 37.1, 6.28 },
    { 23,  3, 52.61, + 3, 49, 12.0, 4.53 },
    { 11, 25, 49.99, + 3, 51, 36.0, 6.37 },
    {  9, 12, 12.91, + 3, 52,  1.9, 6.14 },
    {  6, 43, 38.69, + 3, 55, 55.9, 5.90 },
    {  8, 19, 49.90, + 3, 56, 52.1, 6.05 },
    { 18,  9, 33.79, + 3, 59, 35.9, 5.73 },
    {  5, 45,  1.90, + 4,  0, 29.2, 6.09 },
    {  5, 21, 19.30, + 4,  0, 42.8, 6.57 },
    { 18, 30,  5.09, + 4,  3, 55.1, 6.69 },
    {  3,  2, 16.80, + 4,  5, 22.9, 2.53 },
    {  5, 39, 11.09, + 4,  7, 17.0, 4.57 },
    { 17, 26, 30.91, + 4,  8, 25.1, 4.34 },
    {  6,  4, 58.39, + 4,  9, 31.0, 5.63 },
    { 18, 56, 14.59, + 4, 12,  6.8, 4.98 },
    { 18, 56, 13.20, + 4, 12, 13.0, 4.62 },
    {  5, 30, 19.80, + 4, 12, 15.1, 6.21 },
    { 16, 40, 35.11, + 4, 12, 25.9, 6.93 },
    { 16, 40, 38.71, + 4, 13, 10.9, 5.77 },
    {  8, 56, 36.89, + 4, 14, 12.1, 6.14 },
    { 18, 48,  2.71, + 4, 14, 29.0, 6.21 },
    {  6, 15, 46.99, + 4, 17,  1.0, 6.64 },
    { 20, 59,  4.39, + 4, 17, 37.0, 5.23 },
    {  7, 48, 58.90, + 4, 19, 58.1, 6.53 },
    {  8, 43, 59.69, + 4, 20,  4.9, 6.37 },
    {  9, 50, 30.10, + 4, 20, 37.0, 6.24 },
    {  3,  2, 22.51, + 4, 21, 10.1, 5.61 },
    { 18,  0, 15.79, + 4, 22,  7.0, 4.64 },
    { 22, 26, 37.39, + 4, 23, 37.0, 5.75 },
    { 19, 53, 22.61, + 4, 24,  2.2, 6.53 },
    {  5, 50, 13.10, + 4, 25, 23.9, 5.97 },
    { 16,  0, 51.10, + 4, 25, 39.0, 5.83 },
    { 22, 29, 58.01, + 4, 25, 54.1, 5.48 },
    { 15, 50, 49.01, + 4, 28, 40.1, 3.71 },
    {  7, 56, 23.90, + 4, 29,  8.9, 6.17 },
    {  6, 36,   .00, + 4, 29, 51.0, 6.55 },
    {  2, 57,  4.61, + 4, 30,  4.0, 6.11 },
    { 20, 55, 40.70, + 4, 31, 58.1, 6.05 },
    { 17, 43, 28.39, + 4, 34,  1.9, 2.77 },
    { 14, 59, 23.11, + 4, 34,  4.1, 5.93 },
    {  6, 23, 46.10, + 4, 35, 34.1, 4.44 },
    {  6, 23, 46.49, + 4, 35, 44.2, 6.72 },
    { 10, 12, 48.29, + 4, 36, 52.9, 5.77 },
    {  9, 38, 27.31, + 4, 38, 57.1, 4.68 },
    { 22, 27, 51.50, + 4, 41, 44.2, 4.79 },
    {  6, 38, 49.51, + 4, 42,  2.2, 6.57 },
    {  2, 45, 20.90, + 4, 42, 42.1, 6.03 },
    { 10, 43, 20.90, + 4, 44, 52.1, 5.79 },
    {  8, 33, 43.49, + 4, 45, 24.1, 5.87 },
    { 14, 30, 45.41, + 4, 46, 19.9, 6.02 },
    {  7,  1, 41.40, + 4, 49,  5.2, 6.63 },
    { 19, 16, 31.01, + 4, 50,  4.9, 5.59 },
    {  6, 32, 19.20, + 4, 51, 20.9, 5.84 },
    {  8,  1, 13.80, + 4, 52, 46.9, 5.65 },
    {  3, 23, 39.10, + 4, 52, 54.8, 6.38 },
    { 14,  3, 55.80, + 4, 54,  2.9, 6.24 },
    {  1,  5, 49.20, + 4, 54, 29.9, 6.35 },
    {  1,  5, 51.41, + 4, 54, 33.8, 7.25 },
    {  7,  7,  6.41, + 4, 54, 37.1, 6.11 },
    { 15, 15, 11.40, + 4, 56, 21.8, 5.33 },
    {  6, 37, 52.70, + 4, 57, 25.9, 6.15 },
    { 16,  3, 45.70, + 4, 59, 12.1, 6.08 },
    { 16, 13, 15.41, + 5,  1, 16.0, 5.48 },
    { 22,  5, 40.80, + 5,  3, 31.0, 4.84 },
    { 18, 25,  8.81, + 5,  5,  4.9, 6.74 },
    {  9,  5, 58.39, + 5,  5, 31.9, 4.97 },
    {  6, 17, 16.10, + 5,  6,  1.1, 5.71 },
    { 13, 22,  9.70, + 5,  9, 16.9, 5.87 },
    {  5, 14, 44.09, + 5,  9, 22.0, 5.50 },
    {  7, 39, 18.10, + 5, 13, 30.0, 0.38 },
    {  7, 40,  7.01, + 5, 13, 50.9, 6.02 },
    { 16, 47, 46.39, + 5, 14, 48.1, 5.24 },
    { 21, 15, 49.39, + 5, 14, 52.1, 3.92 },
    { 18, 39, 36.89, + 5, 15, 51.1, 6.38 },
    {  0, 48, 22.99, + 5, 16, 50.2, 5.75 },
    { 12, 22, 31.99, + 5, 18, 20.2, 6.40 },
    {  5, 23, 31.10, + 5, 19, 21.0, 6.35 },
    {  3,  1, 52.30, + 5, 20, 10.0, 6.25 },
    {  8, 52, 24.19, + 5, 20, 24.0, 6.33 },
    { 20, 23, 10.70, + 5, 20, 35.2, 5.31 },
    { 23, 20, 20.59, + 5, 22, 53.0, 5.05 },
    { 19, 39, 11.59, + 5, 23, 52.1, 5.17 },
    {  4, 55, 58.39, + 5, 23, 57.1, 6.50 },
    {  4, 32,  4.80, + 5, 24, 36.0, 6.39 },
    {  6,  4, 58.20, + 5, 25, 12.0, 5.67 },
    {  4,  3, 44.59, + 5, 26,  8.2, 5.33 },
    { 18, 21, 28.49, + 5, 26,  8.9, 6.13 },
    { 15, 45, 23.50, + 5, 26, 48.8, 5.58 },
    {  9, 11, 55.61, + 5, 28,  5.9, 6.35 },
    { 13, 17, 36.29, + 5, 28, 10.9, 4.80 },
    {  7, 12,  7.39, + 5, 28, 28.9, 6.16 },
    {  1, 41, 25.90, + 5, 29, 15.0, 4.44 },
    { 15,  4,  6.41, + 5, 29, 33.0, 6.50 },
    { 13, 50, 24.70, + 5, 29, 49.9, 6.01 },
    { 15,  7, 40.30, + 5, 29, 53.2, 6.16 },
    { 18, 45, 28.39, + 5, 29, 58.9, 5.83 },
    { 21,  4, 34.70, + 5, 30, 10.1, 5.61 },
    { 19, 13, 44.09, + 5, 30, 56.9, 6.49 },
    { 16, 32, 35.69, + 5, 31, 16.0, 5.63 },
    {  4, 11, 20.30, + 5, 31, 23.2, 5.72 },
    { 20, 49, 59.09, + 5, 32, 40.9, 6.21 },
    {  7,  1, 55.01, + 5, 33, 27.0, 6.59 },
    {  4, 34,  8.30, + 5, 34,  7.0, 5.68 },
    {  2, 35, 52.51, + 5, 35, 35.9, 4.86 },
    {  4, 51, 12.41, + 5, 36, 18.0, 3.69 },
    { 10,  6, 47.40, + 5, 36, 41.0, 6.21 },
    { 23, 39, 57.00, + 5, 37, 35.0, 4.13 },
    {  9,  1, 31.39, + 5, 38, 26.9, 6.07 },
    {  1,  8, 22.20, + 5, 38, 58.9, 5.52 },
    {  7, 11, 51.31, + 5, 39, 16.9, 6.09 },
    {  1,  4, 52.61, + 5, 39, 23.0, 6.00 },
    { 21, 42, 15.50, + 5, 40, 48.0, 5.30 },
    {  8, 45,  1.30, + 5, 40, 50.2, 6.13 },
    { 10, 23, 14.59, + 5, 41, 39.1, 6.54 },
    {  8, 37, 39.41, + 5, 42, 13.0, 4.16 },
    { 21, 38, 31.90, + 5, 46, 18.1, 5.67 },
    { 22, 20, 27.60, + 5, 47, 21.8, 5.37 },
    { 12, 10,  3.41, + 5, 48, 24.8, 5.72 },
    { 14, 24, 11.30, + 5, 49, 12.0, 5.10 },
    {  8, 48, 25.99, + 5, 50, 16.1, 4.36 },
    {  7, 36, 34.70, + 5, 51, 42.1, 5.91 },
    { 16, 14, 13.49, + 5, 54,  6.8, 6.31 },
    {  8, 55, 23.59, + 5, 56, 44.2, 3.11 },
    {  5, 30, 47.11, + 5, 56, 53.2, 4.20 },
    { 12, 47,  2.30, + 5, 57,  2.9, 6.34 },
    {  9, 53, 42.91, + 5, 57, 29.9, 5.95 },
    { 21,  5, 26.69, + 5, 57, 29.9, 5.94 },
    {  4,  3,  9.41, + 5, 59, 21.1, 3.91 },
    { 20, 47, 48.31, + 6,  0, 29.9, 5.58 },
    { 13, 29, 57.60, + 6,  0, 47.9, 6.51 },
    { 11, 21,  8.21, + 6,  1, 45.8, 4.05 },
    {  3, 57,  1.70, + 6,  2, 24.0, 6.09 },
    {  3, 45, 40.39, + 6,  3,   .0, 5.35 },
    {  6, 15, 40.10, + 6,  3, 58.0, 6.07 },
    { 19,  8, 59.90, + 6,  4, 23.9, 5.22 },
    { 17, 18, 52.80, + 6,  5,  7.1, 6.51 },
    { 17, 53, 14.21, + 6,  6,  5.0, 5.77 },
    { 11,  0, 44.81, + 6,  6,  5.0, 4.99 },
    {  2, 40, 15.70, + 6,  6, 42.8, 6.25 },
    {  4, 20, 41.21, + 6,  7, 50.9, 5.77 },
    {  6, 37, 24.10, + 6,  8,  7.1, 6.06 },
    {  1, 30, 11.09, + 6,  8, 38.0, 4.84 },
    { 10, 56,  1.51, + 6, 11,  7.1, 5.81 },
    {  4, 15, 29.21, + 6, 11, 12.1, 6.31 },
    {  3, 30, 45.41, + 6, 11, 19.0, 5.94 },
    { 18, 27, 58.80, + 6, 11, 39.1, 5.73 },
    { 22, 10, 12.00, + 6, 11, 52.1, 3.53 },
    {  4, 15, 25.80, + 6, 11, 58.9, 6.93 },
    { 18, 58, 23.81, + 6, 14, 25.1, 6.21 },
    { 18,  0, 52.90, + 6, 16,  5.9, 6.34 },
    { 17, 41, 32.30, + 6, 18, 46.1, 5.95 },
    {  6, 41, 59.30, + 6, 20, 42.0, 6.37 },
    {  5, 25,  7.90, + 6, 20, 58.9, 1.64 },
    { 13, 46, 57.10, + 6, 21,  2.2, 6.33 },
    {  6, 40, 31.80, + 6, 22, 18.1, 6.51 },
    { 10, 46,  5.69, + 6, 22, 23.2, 6.37 },
    { 16,  9, 11.21, + 6, 22, 44.0, 5.97 },
    { 23, 27, 58.10, + 6, 22, 44.0, 4.28 },
    { 19, 55, 18.79, + 6, 24, 24.1, 3.71 },
    {  3, 34, 49.20, + 6, 25,  4.1, 6.49 },
    {  8, 46, 46.61, + 6, 25,  8.0, 3.38 },
    { 15, 44, 16.10, + 6, 25, 32.2, 2.65 },
    {  5, 48,   .19, + 6, 27, 15.1, 5.27 },
    {  0, 59, 49.70, + 6, 28, 59.2, 6.11 },
    { 17, 56, 55.99, + 6, 29, 16.1, 6.29 },
    { 11, 45, 51.60, + 6, 31, 45.8, 4.03 },
    {  3, 52,   .19, + 6, 32,  4.9, 5.67 },
    { 10, 23,   .41, + 6, 32, 33.0, 6.07 },
    { 17,  0, 29.40, + 6, 35,  1.0, 6.59 },
    { 12,  0, 52.39, + 6, 36, 51.1, 4.66 },
    { 18, 55, 27.50, + 6, 36, 55.1, 5.57 },
    { 23,  4,  1.01, + 6, 37,   .1, 6.41 },
    { 21, 37, 43.70, + 6, 37,  5.9, 6.18 },
    {  8, 35, 51.00, + 6, 37, 12.0, 5.99 },
    {  8, 35, 51.29, + 6, 37, 21.0, 7.25 },
    {  3, 12, 26.40, + 6, 39, 38.9, 5.56 },
    { 18, 36, 39.10, + 6, 40, 18.8, 5.45 },
    {  7, 17, 17.81, + 6, 40, 50.2, 6.65 },
    {  9, 46, 10.01, + 6, 42, 31.0, 5.79 },
    { 22,  0,  7.90, + 6, 43,  3.0, 6.00 },
    {  0, 47, 23.59, + 6, 44, 26.9, 5.99 },
    {  3, 46,  9.50, + 6, 48, 11.2, 5.91 },
    { 12, 41, 57.10, + 6, 48, 24.1, 5.59 },
    { 21, 22, 53.59, + 6, 48, 40.0, 5.16 },
    {  9, 37, 12.70, + 6, 50,  8.9, 5.00 },
    { 23, 59, 18.70, + 6, 51, 47.9, 4.01 },
    { 21, 53, 57.79, + 6, 51, 51.8, 6.15 },
    {  5, 26, 38.81, + 6, 52,  9.1, 6.42 },
    {  2, 36,  4.90, + 6, 53, 12.8, 5.82 },
    {  7, 28,  2.11, + 6, 56, 30.8, 5.25 },
    { 16, 24, 10.80, + 6, 56, 53.2, 5.85 },
    { 10, 34, 48.00, + 6, 57, 13.0, 5.08 },
    {  0, 32, 23.81, + 6, 57, 20.2, 5.67 },
    {  4, 49, 50.40, + 6, 57, 41.0, 3.19 },
    { 12, 38, 30.00, + 6, 59, 17.9, 7.08 },
    { 21,  8, 28.20, + 6, 59, 21.8, 6.15 },
    {  1, 14, 42.41, + 6, 59, 43.1, 6.03 },
    {  6, 16, 58.39, + 7,  3, 11.2, 6.57 },
    { 23, 55,  7.80, + 7,  4, 16.0, 6.21 },
    {  6, 25, 13.10, + 7,  5,  8.9, 5.98 },
    { 19, 54, 40.30, + 7,  8, 25.1, 6.15 },
    {  7, 19, 47.59, + 7,  8, 34.1, 5.91 },
    { 13, 30,   .10, + 7, 10, 44.0, 6.17 },
    {  7, 58,  5.81, + 7, 12, 49.0, 6.41 },
    { 16, 50, 19.39, + 7, 14, 52.1, 5.49 },
    { 23, 41, 56.69, + 7, 15,  2.2, 5.89 },
    { 18, 19,  9.50, + 7, 15, 34.9, 5.39 },
    { 20,  4,  8.30, + 7, 16, 41.2, 5.52 },
    {  9,  2, 44.81, + 7, 17, 53.2, 5.85 },
    {  0, 48, 17.40, + 7, 18,   .0, 5.93 },
    {  6, 59, 20.09, + 7, 19,   .8, 6.35 },
    {  6, 32, 54.19, + 7, 19, 59.2, 4.50 },
    { 11,  5,  1.01, + 7, 20, 10.0, 4.63 },
    { 22, 58, 42.60, + 7, 20, 22.9, 6.33 },
    { 15, 46, 26.59, + 7, 21, 11.2, 4.43 },
    { 21, 21,  4.80, + 7, 21, 15.8, 5.82 },
    { 18, 39, 51.60, + 7, 21, 29.9, 6.28 },
    { 19, 34,  5.40, + 7, 22, 44.0, 4.45 },
    {  5, 55, 10.30, + 7, 24, 24.8, 0.50 },
    {  7,  7, 49.51, + 7, 28, 16.0, 5.75 },
    {  2, 35,  4.10, + 7, 28, 17.0, 6.18 },
    { 21,  0,  3.89, + 7, 30, 59.0, 5.99 },
    {  5, 38,  1.10, + 7, 32, 29.0, 5.88 },
    { 14,  3, 36.79, + 7, 32, 47.0, 6.26 },
    {  8, 25, 54.79, + 7, 33, 51.8, 5.13 },
    {  6, 34, 46.39, + 7, 34, 21.0, 6.45 },
    {  1, 13, 43.90, + 7, 34, 31.1, 5.24 },
    {  1, 13, 45.29, + 7, 34, 41.9, 6.30 },
    {  0, 48, 40.99, + 7, 35,  6.0, 4.43 },
    { 17, 26, 19.01, + 7, 35, 44.2, 6.06 },
    { 12, 31, 21.41, + 7, 36, 15.1, 6.05 },
    { 19, 45, 39.91, + 7, 36, 47.9, 5.91 },
    {  6, 58, 39.00, + 7, 37, 18.8, 6.27 },
    { 12, 45, 37.10, + 7, 40, 23.9, 5.22 },
    {  2, 38,   .79, + 7, 41, 43.1, 6.39 },
    {  4, 13, 33.10, + 7, 42, 58.0, 5.29 },
    {  2, 36, 35.11, + 7, 43, 46.9, 5.81 },
    {  4, 54, 47.81, + 7, 46, 45.1, 5.33 },
    { 20, 49, 48.31, + 7, 51, 51.1, 6.33 },
    {  4, 39,  6.19, + 7, 52, 14.9, 5.39 },
    {  1,  2, 56.59, + 7, 53, 24.0, 4.28 },
    { 17, 11, 45.19, + 7, 53, 40.9, 6.33 },
    { 19, 50, 17.50, + 7, 54,  9.0, 6.51 },
    {  1, 28, 22.90, + 7, 57, 41.0, 6.20 },
    {  7, 15, 39.41, + 7, 58, 40.1, 5.82 },
    {  8, 39, 24.60, + 8,  1,  1.9, 6.45 },
    { 18, 25, 38.81, + 8,  1, 54.8, 5.65 },
    {  6, 47, 19.80, + 8,  2, 13.9, 4.77 },
    { 10,  0, 12.79, + 8,  2, 39.1, 4.70 },
    { 11, 14,  1.80, + 8,  3, 38.2, 5.79 },
    { 14, 24, 18.29, + 8,  5,  6.0, 6.19 },
    { 16,  5, 37.80, + 8,  5, 46.0, 6.29 },
    { 11, 38, 27.60, + 8,  8,  3.1, 5.36 },
    { 14, 41, 38.81, + 8,  9, 42.1, 4.86 },
    { 22, 20, 55.80, + 8, 11, 12.1, 6.17 },
    {  9, 28, 29.21, + 8, 11, 17.9, 5.71 },
    {  0, 20, 35.90, + 8, 11, 25.1, 5.37 },
    { 21, 28, 24.79, + 8, 11, 44.2, 6.40 },
    {  4,  3, 56.59, + 8, 11, 49.9, 5.46 },
    { 19,  6, 22.20, + 8, 13, 48.0, 6.09 },
    {  0, 16, 34.10, + 8, 14, 24.0, 6.11 },
    { 14, 24,   .91, + 8, 14, 37.0, 5.95 },
    { 11, 47, 54.89, + 8, 14, 44.9, 5.32 },
    {  2,  6, 12.31, + 8, 14, 51.0, 6.31 },
    { 22,  1,  9.19, + 8, 15, 25.9, 5.65 },
    { 11, 45, 17.09, + 8, 15, 29.9, 4.85 },
    { 18, 33, 23.30, + 8, 16,  5.9, 6.42 },
    {  7, 27,  9.00, + 8, 17, 21.8, 2.90 },
    {  9, 58,  7.61, + 8, 18, 51.1, 6.04 },
    {  6, 55, 34.61, + 8, 19, 28.9, 6.29 },
    { 19,  2, 21.60, + 8, 22, 27.1, 6.30 },
    {  6, 52, 49.39, + 8, 22, 49.1, 5.77 },
    {  2, 56, 13.80, + 8, 22, 54.1, 5.97 },
    { 13, 42, 12.70, + 8, 23, 17.9, 6.16 },
    {  5, 21, 43.61, + 8, 25, 43.0, 5.80 },
    { 20, 28,  7.49, + 8, 26, 15.0, 6.25 },
    { 11, 55,  3.10, + 8, 26, 38.0, 5.58 },
    { 14, 23, 22.61, + 8, 26, 42.0, 6.86 },
    { 14, 23, 22.70, + 8, 26, 48.1, 5.12 },
    { 17,  1, 59.09, + 8, 27,  2.2, 6.33 },
    {  8, 34, 13.30, + 8, 27,  6.8, 6.03 },
    {  2, 28,  9.50, + 8, 27, 36.0, 4.28 },
    { 19, 54, 14.90, + 8, 27, 41.0, 4.71 },
    {  3,  8, 38.71, + 8, 28, 14.9, 6.28 },
    {  0,  2, 29.69, + 8, 29,  8.2, 5.63 },
    {  5,  7, 52.90, + 8, 29, 53.9, 5.34 },
    { 16,  8, 28.01, + 8, 32,  3.1, 5.73 },
    { 22, 15, 59.81, + 8, 32, 57.8, 6.21 },
    { 20,  0, 58.90, + 8, 33, 29.2, 5.91 },
    {  2, 11, 21.10, + 8, 34, 10.9, 5.63 },
    { 15, 30, 55.39, + 8, 34, 45.1, 6.57 },
    { 15, 54, 40.30, + 8, 34, 49.1, 6.29 },
    { 16, 45, 49.90, + 8, 34, 57.0, 5.15 },
    {  6, 46, 32.40, + 8, 35, 13.9, 5.93 },
    {  4, 26, 21.10, + 8, 35, 25.1, 6.06 },
    { 12, 27, 42.10, + 8, 36, 37.1, 6.37 },
    {  7, 57, 15.91, + 8, 38, 29.0, 6.05 },
    { 10, 35,  2.21, + 8, 39,  1.1, 5.67 },
    {  6,  8, 47.21, + 8, 40, 12.0, 6.55 },
    { 23,  9, 31.51, + 8, 40, 37.9, 5.12 },
    { 23, 11, 44.21, + 8, 43, 12.0, 5.16 },
    { 12,  5, 12.50, + 8, 43, 59.2, 4.12 },
    { 18,  7, 18.41, + 8, 44,  2.0, 4.64 },
    { 10, 25, 15.19, + 8, 47,  4.9, 5.61 },
    { 22, 55, 13.70, + 8, 48, 56.9, 4.90 },
    {  0, 14, 58.80, + 8, 49, 14.9, 5.79 },
    { 18, 38, 21.00, + 8, 50,  2.0, 6.40 },
    {  2, 13,   .00, + 8, 50, 48.1, 4.37 },
    { 17, 23, 57.60, + 8, 51, 10.1, 5.77 },
    {  7, 55, 31.39, + 8, 51, 46.1, 5.86 },
    {  8, 17, 31.70, + 8, 51, 58.0, 6.29 },
    { 19, 50, 46.99, + 8, 52,  5.9, 0.77 },
    { 11, 38,  9.79, + 8, 53,  3.1, 6.17 },
    {  6, 24,  2.30, + 8, 53,  4.9, 6.26 },
    {  4, 13, 31.30, + 8, 53, 26.2, 6.51 },
    {  4, 15, 32.11, + 8, 53, 31.9, 4.29 },
    { 14,  1, 20.40, + 8, 53, 40.9, 5.99 },
    {  4, 50, 36.70, + 8, 54,  1.1, 4.36 },
    {  2, 59, 42.89, + 8, 54, 27.0, 4.70 },
    {  8,  1, 50.71, + 8, 54, 50.0, 6.22 },
    {  7, 28,  9.79, + 8, 55, 32.2, 4.32 },
    {  9, 56, 25.99, + 8, 55, 59.2, 5.85 },
    {  5, 37, 19.30, + 8, 57,  6.8, 6.12 },
    {  0,  2, 24.19, + 8, 57, 24.8, 6.32 },
    {  3, 24, 48.79, + 9,  1, 44.0, 3.60 },
    {  6, 30,  5.50, + 9,  1, 45.1, 6.57 },
    {  6, 18, 40.49, + 9,  2, 49.9, 6.24 },
    {  9, 28, 27.50, + 9,  3, 24.1, 5.41 },
    { 18, 36, 27.79, + 9,  7, 21.0, 5.39 },
    { 22, 29,  7.99, + 9,  7, 44.0, 5.58 },
    {  7,  3, 17.90, + 9,  8, 17.9, 5.97 },
    {  1, 45, 23.59, + 9,  9, 28.1, 4.26 },
    {  8, 16, 30.91, + 9, 11,  8.2, 3.52 },
    {  7,  5, 39.10, + 9, 11,  8.9, 5.78 },
    {  4, 20, 49.01, + 9, 13, 32.2, 6.53 },
    {  4, 13, 56.40, + 9, 15, 49.0, 4.84 },
    {  7, 25, 38.90, + 9, 16, 34.0, 4.99 },
    {  5, 36, 54.29, + 9, 17, 26.2, 4.09 },
    { 10, 32, 48.70, + 9, 18, 24.1, 3.85 },
    { 23, 51, 21.19, + 9, 18, 47.9, 5.79 },
    { 22, 58, 35.09, + 9, 21, 24.8, 6.43 },
    {  3, 32, 36.00, + 9, 22, 25.0, 5.77 },
    { 16, 57, 40.10, + 9, 22, 30.0, 3.20 },
    {  8, 57, 42.00, + 9, 23, 16.1, 6.19 },
    { 20,  7, 50.30, + 9, 23, 58.9, 6.43 },
    { 23,  7,   .31, + 9, 24, 33.8, 4.52 },
    {  4, 33, 48.10, + 9, 24, 47.2, 6.01 },
    { 13, 16, 46.51, + 9, 25, 27.1, 5.22 },
    {  4, 23, 51.89, + 9, 27, 38.9, 5.12 },
    {  5,  7, 38.30, + 9, 28, 18.8, 6.17 },
    {  4, 18, 24.50, + 9, 29, 12.1, 6.54 },
    {  5, 34, 49.20, + 9, 29, 21.8, 4.41 },
    {  5, 56, 28.01, + 9, 30, 34.9, 5.99 },
    {  5, 46, 52.10, + 9, 31, 19.9, 5.79 },
    { 12, 46, 22.51, + 9, 32, 24.0, 5.67 },
    { 18,  7, 21.00, + 9, 33, 50.0, 3.73 },
    {  2, 29, 35.30, + 9, 33, 56.9, 6.07 },
    {  8, 38,  5.21, + 9, 34, 28.9, 6.53 },
    { 17, 34, 36.70, + 9, 35, 12.1, 5.81 },
    { 19, 18, 52.70, + 9, 37,  5.2, 6.32 },
    { 19, 51, 17.71, + 9, 37, 49.1, 6.25 },
    {  6,  2, 22.99, + 9, 38, 51.0, 4.12 },
    {  8, 37,  5.81, + 9, 39, 20.2, 5.88 },
    { 23, 39, 55.10, + 9, 40, 37.9, 5.97 },
    { 14,  2, 31.80, + 9, 41, 11.0, 6.20 },
    { 16, 11, 29.69, + 9, 42, 45.0, 6.53 },
    {  9, 31, 57.60, + 9, 42, 56.9, 5.07 },
    {  3, 27, 10.20, + 9, 43, 58.1, 3.74 },
    { 17,  6,  9.70, + 9, 43, 59.9, 6.37 },
    { 10, 27, 39.00, + 9, 45, 45.0, 6.04 },
    {  8, 31, 54.60, + 9, 48, 51.8, 6.83 },
    {  8, 11, 16.61, + 9, 49, 16.0, 6.07 },
    { 23, 10,  1.51, + 9, 49, 18.8, 5.39 },
    {  5,  9, 19.61, + 9, 49, 45.8, 5.43 },
    { 22, 52, 24.10, + 9, 50,  8.2, 5.16 },
    {  5, 50,  2.59, + 9, 52, 16.0, 5.80 },
    { 21, 44, 11.21, + 9, 52, 30.0, 2.39 },
    { 16,  7, 37.49, + 9, 53, 30.1, 5.63 },
    {  9, 41,  9.00, + 9, 53, 31.9, 3.52 },
    {  6, 40, 58.70, + 9, 53, 44.2, 4.66 },
    { 19, 22, 48.41, + 9, 54, 47.2, 6.35 },
    {  5, 35,  8.30, + 9, 56,  3.1, 3.54 },
    {  5, 35,  8.50, + 9, 56,  6.0, 5.61 },
    {  6, 17,  6.60, + 9, 56, 33.0, 5.39 },
    {  6, 56, 25.80, + 9, 57, 23.0, 5.92 },
    {  4, 51, 43.39, + 9, 58, 30.0, 6.11 },
    {  6, 35, 17.59, + 9, 59, 17.9, 5.88 },
    { 10,  7, 54.31, + 9, 59, 51.0, 4.37 },
    {  4,  1, 46.10, + 9, 59, 52.1, 5.67 },
    { 21, 14, 28.90, +10,  0, 24.8, 4.49 },
    { 15, 36, 29.59, +10,  0, 36.0, 5.26 },
    {  4, 14, 36.29, +10,  0, 40.0, 5.22 },
    { 13,  9, 12.41, +10,  1, 19.9, 5.78 },
    { 21, 10, 31.20, +10,  2, 56.0, 6.07 },
    { 20, 25, 43.99, +10,  3, 23.0, 6.33 },
    { 20, 33, 53.59, +10,  3, 34.9, 6.56 },
    {  8, 32, 39.89, +10,  3, 58.0, 6.46 },
    {  8, 44, 45.00, +10,  4, 54.1, 5.66 },
    { 20, 39,  7.80, +10,  5, 10.0, 5.05 },
    { 14, 14, 50.81, +10,  6,  2.2, 5.29 },
    {  2, 44, 56.50, +10,  6, 51.1, 4.27 },
    {  4, 19, 37.49, +10,  7, 17.0, 6.31 },
    { 21, 10, 20.50, +10,  7, 54.1, 4.69 },
    { 18, 59, 17.50, +10,  8, 26.9, 6.75 },
    {  4, 54, 53.81, +10,  9,  2.9, 4.65 },
    {  4, 35, 39.29, +10,  9, 38.9, 4.25 },
    { 16, 54,   .50, +10,  9, 55.1, 4.38 },
    { 21, 24, 24.60, +10, 10, 27.1, 6.35 },
    {  0, 28, 20.09, +10, 11, 22.9, 6.04 },
    { 13, 35, 33.29, +10, 12, 16.9, 6.49 },
    {  4, 13, 34.80, +10, 12, 43.9, 6.23 },
    { 12, 41, 53.11, +10, 14,  8.2, 4.88 },
    {  5, 35, 13.39, +10, 14, 24.0, 5.60 },
    { 12, 13, 25.90, +10, 15, 43.9, 5.85 },
    {  4, 30,  2.40, +10, 15, 45.0, 6.48 },
    { 12, 33,  2.90, +10, 17, 44.2, 6.26 },
    {  6, 28, 18.79, +10, 18, 14.0, 6.15 },
    {  3, 59, 40.70, +10, 19, 50.9, 6.37 },
    { 23, 43, 22.39, +10, 19, 53.0, 5.06 },
    { 19, 52, 15.60, +10, 21,  5.0, 6.54 },
    { 19, 51,  1.61, +10, 24, 56.2, 5.11 },
    { 12, 41, 34.39, +10, 25, 35.0, 6.19 },
    { 17,  6, 13.10, +10, 27, 15.1, 6.37 },
    { 22, 49, 32.30, +10, 28, 44.0, 6.54 },
    {  4, 29, 42.89, +10, 31, 18.1, 6.79 },
    { 11, 23, 55.49, +10, 31, 45.1, 3.94 },
    { 15, 34, 48.10, +10, 32, 15.0, 3.80 },
    { 15, 34, 48.10, +10, 32, 21.1, 3.80 },
    { 10, 49, 15.41, +10, 32, 43.1, 5.34 },
    {  7, 34,  5.09, +10, 34,  5.9, 6.28 },
    { 17, 12, 27.79, +10, 35,  7.1, 5.33 },
    {  5, 54, 13.39, +10, 35, 12.8, 6.12 },
    {  7, 26, 27.89, +10, 36, 29.9, 6.37 },
    {  2, 24, 49.01, +10, 36, 38.2, 5.47 },
    { 19, 46, 15.60, +10, 36, 47.9, 2.72 },
    {  6, 13, 12.60, +10, 37, 39.0, 6.45 },
    {  8, 23, 55.20, +10, 37, 54.8, 6.08 },
    {  9,  7, 44.81, +10, 40,  5.2, 5.24 },
    { 19, 48, 30.41, +10, 41, 39.1, 6.44 },
    { 20,  8, 38.30, +10, 43, 32.9, 6.31 },
    {  2, 42, 28.90, +10, 44, 30.1, 6.30 },
    { 13, 39, 34.61, +10, 44, 46.0, 5.57 },
    {  7, 46, 16.20, +10, 46,  5.9, 5.30 },
    { 14,  3, 32.30, +10, 47, 12.1, 6.30 },
    { 13, 29, 13.01, +10, 49,  5.9, 5.65 },
    { 21, 42, 33.00, +10, 49, 28.9, 6.09 },
    { 22, 41, 27.70, +10, 49, 53.0, 3.40 },
    { 20, 58, 25.90, +10, 50, 21.1, 5.48 },
    {  6, 37, 36.89, +10, 51, 11.2, 6.38 },
    { 17, 18, 37.01, +10, 51, 51.8, 5.03 },
    {  3,  0, 44.11, +10, 52, 13.1, 5.95 },
    { 18, 34, 47.50, +10, 53, 30.1, 6.40 },
    { 20, 30, 18.00, +10, 53, 44.9, 6.08 },
    { 11, 35, 43.39, +10, 54, 40.0, 6.56 },
    { 22, 43, 42.70, +10, 56, 21.1, 6.51 },
    { 23, 52, 37.10, +10, 56, 51.0, 5.30 },
    {  7,  3, 37.99, +10, 57,  6.1, 5.13 },
    { 13,  2, 10.61, +10, 57, 33.1, 2.83 },
    { 22,  2,  1.39, +10, 58, 26.0, 6.37 },
    { 18, 50, 45.60, +10, 58, 35.0, 6.55 },
    {  0, 20, 54.50, +10, 58, 36.8, 6.56 },
    {  6, 53, 22.51, +10, 59, 47.0, 6.24 },
    {  6, 41, 17.21, +11,  0, 11.9, 6.11 },
    {  7, 26, 41.30, +11,  0, 33.1, 6.41 },
    {  6, 29,   .00, +11,  1,  9.8, 6.59 },
    { 11, 34, 10.01, +11,  1, 25.0, 6.55 },
    {  5, 37,  4.39, +11,  2,  6.0, 5.94 },
    {  1, 50, 52.01, +11,  2, 35.9, 5.94 },
    { 17, 57, 26.90, +11,  2, 39.1, 6.36 },
    { 23, 13, 26.50, +11,  3, 54.0, 5.82 },
    { 19,  6, 58.61, +11,  4, 17.0, 5.09 },
    { 17, 54, 14.21, +11,  7, 50.2, 6.38 },
    {  3, 48, 16.30, +11,  8, 35.9, 5.07 },
    {  0, 10,  2.30, +11,  8, 44.2, 5.51 },
    {  4, 44, 25.80, +11,  8, 46.0, 5.40 },
    { 19, 36,  7.99, +11,  9,   .0, 6.68 },
    { 21, 18, 52.01, +11, 12, 11.9, 5.96 },
    {  0, 18, 17.21, +11, 12, 20.9, 6.05 },
    {  4, 27, 28.80, +11, 12, 45.0, 5.88 },
    { 20, 39, 51.79, +11, 14, 58.9, 6.42 },
    {  6, 31,  9.50, +11, 15,  2.9, 6.14 },
    { 20, 31, 13.01, +11, 15, 38.2, 7.11 },
    { 15, 35, 53.40, +11, 15, 56.2, 6.07 },
    { 19, 36, 52.51, +11, 16, 23.9, 5.98 },
    {  9, 31, 56.71, +11, 17, 58.9, 4.97 },
    { 20, 33, 12.79, +11, 18, 11.9, 4.03 },
    { 13, 14, 31.30, +11, 19, 54.1, 5.67 },
    {  3, 30, 24.50, +11, 20, 11.0, 5.14 },
    {  5, 16,  4.10, +11, 20, 29.0, 5.56 },
    { 20, 37, 49.10, +11, 22, 40.1, 5.43 },
    { 22,  3, 19.01, +11, 23, 11.0, 5.80 },
    { 16, 26, 11.50, +11, 24, 27.0, 6.11 },
    { 18, 37, 12.60, +11, 25, 18.1, 6.42 },
    { 19, 56, 14.30, +11, 25, 26.0, 5.28 },
    {  4, 54, 46.90, +11, 25, 34.0, 5.19 },
    {  9, 47, 33.50, +11, 25, 44.0, 6.02 },
    { 11, 24, 58.90, +11, 25, 49.1, 5.80 },
    { 16, 32, 36.29, +11, 29, 17.2, 4.84 },
    {  9, 17, 51.41, +11, 30,  4.0, 6.41 },
    {  5, 56, 49.51, +11, 31, 16.0, 5.87 },
    { 19, 19, 52.99, +11, 32,  6.0, 6.02 },
    {  6, 31, 48.29, +11, 32, 39.8, 5.23 },
    { 13, 12, 32.90, +11, 33, 22.0, 5.77 },
    {  9,  9, 46.39, +11, 33, 51.8, 6.48 },
    {  9, 47, 25.90, +11, 34,  5.9, 6.45 },
    { 19, 17, 49.01, +11, 35, 43.1, 5.28 },
    { 22, 10, 37.39, +11, 37, 27.8, 5.78 },
    {  8, 55, 55.61, +11, 37, 34.0, 5.41 },
    { 19, 52,  3.50, +11, 37, 44.0, 6.13 },
    { 14, 41, 43.49, +11, 39, 38.2, 5.56 },
    {  7, 24, 58.20, +11, 40, 10.9, 5.30 },
    {  6, 32, 23.30, +11, 40, 25.0, 6.03 },
    {  6,  3, 24.70, +11, 40, 50.9, 6.08 },
    { 22, 36, 36.41, +11, 41, 48.8, 6.40 },
    {  4, 46,  1.70, +11, 42, 20.2, 5.37 },
    { 10, 59, 41.09, +11, 42, 20.9, 6.55 },
    {  8, 16, 33.91, +11, 43, 35.0, 7.13 },
    { 22, 59, 11.81, +11, 43, 44.0, 5.75 },
    {  6, 20, 52.30, +11, 45, 23.0, 6.54 },
    {  5, 54, 32.21, +11, 45, 45.0, 6.59 },
    {  6, 31, 39.19, +11, 47, 31.9, 6.65 },
    {  9, 46, 23.30, +11, 48, 36.0, 5.63 },
    {  8, 50, 26.10, +11, 48, 45.0,      },
    { 19, 48, 42.10, +11, 48, 56.9, 5.72 },
    { 19, 42, 34.01, +11, 49, 36.1, 5.27 },
    { 22, 56, 51.50, +11, 50, 53.9, 6.51 },
    {  8, 58, 29.21, +11, 51, 28.1, 4.25 },
    {  3, 10, 38.90, +11, 52, 21.0, 5.98 },
    {  6, 57, 25.70, +11, 54, 27.0, 6.27 },
    { 17, 30, 22.39, +11, 55, 30.0, 6.39 },
    { 17, 32, 15.00, +11, 55, 49.1, 6.42 },
    { 19, 24, 58.20, +11, 56, 39.8, 5.16 },
    { 17, 50, 43.49, +11, 56, 48.1, 6.17 },
    { 12, 47, 13.61, +11, 57, 29.2, 6.07 },
    { 10,  8, 22.30, +11, 58,  1.9, 1.35 },
    {  0, 47,  1.51, +11, 58, 26.0, 5.50 },
    { 11, 18, 21.00, +11, 59,  4.9, 6.66 },
    { 18,  5, 43.30, +12,  0, 14.0, 7.04 },
    {  7, 29, 47.81, +12,  0, 24.1, 4.54 },
    { 18, 22, 35.30, +12,  1, 44.0, 5.89 },
    { 15, 40, 10.39, +12,  3, 11.2, 6.25 },
    { 21, 56, 56.40, +12,  4, 35.0, 5.54 },
    {  8, 46, 55.99, +12,  6, 36.0, 5.87 },
    {  7, 14, 32.59, +12,  6, 56.9, 5.62 },
    { 21, 31,  9.60, +12,  8, 15.0, 6.08 },
    {  1, 37,  5.90, +12,  8, 30.1, 5.57 },
    { 13, 52, 18.41, +12,  9, 55.1, 6.04 },
    { 22, 46, 41.59, +12, 10, 22.1, 4.19 },
    { 19, 42, 12.79, +12, 11, 35.9, 6.34 },
    {  4, 40,  3.41, +12, 11, 52.1, 5.46 },
    { 22, 21, 31.10, +12, 12, 19.1, 5.01 },
    {  6, 16, 26.59, +12, 16, 19.9, 5.04 },
    { 11, 50, 55.30, +12, 16, 44.0, 6.35 },
    {  1, 59, 25.90, +12, 17, 40.9, 6.09 },
    { 23, 23,  4.61, +12, 18, 50.0, 5.08 },
    { 19, 19, 39.31, +12, 22, 28.9, 5.53 },
    { 16, 40, 51.41, +12, 23, 42.0, 6.08 },
    { 12, 53, 49.70, +12, 25,  7.0, 6.25 },
    { 13, 24, 30.50, +12, 25, 54.8, 6.44 },
    {  9, 58, 13.39, +12, 26, 40.9, 5.26 },
    {  2, 44, 57.60, +12, 26, 44.9, 5.18 },
    {  2, 36, 37.90, +12, 26, 51.0, 5.68 },
    { 17, 10, 45.79, +12, 28,  1.9, 6.57 },
    {  4,  0, 40.80, +12, 29, 25.1, 3.47 },
    {  4, 38,  9.50, +12, 30, 38.9, 4.27 },
    { 20, 49, 37.80, +12, 32, 43.1, 5.98 },
    {  6, 15, 45.00, +12, 33,  4.0, 5.33 },
    { 17, 34, 56.11, +12, 33, 36.0, 2.08 },
    { 15, 22, 23.21, +12, 34,  3.0, 6.28 },
    { 20, 55, 38.59, +12, 34,  7.0, 5.58 },
    {  6, 22, 36.50, +12, 34, 12.0, 6.00 },
    { 22, 37,  4.70, +12, 34, 37.9, 6.30 },
    {  7,  3, 51.60, +12, 35, 39.8, 5.98 },
    {  3, 24, 10.10, +12, 37, 45.8, 6.04 },
    {  5, 49, 32.90, +12, 39,  4.0, 4.91 },
    {  8, 26, 43.90, +12, 39, 15.8, 5.50 },
    {  8, 43, 12.31, +12, 40, 50.9, 5.64 },
    {  6, 45, 54.19, +12, 41, 37.0, 6.46 },
    {  3, 27, 18.70, +12, 44,  6.0, 6.28 },
    { 17,  5, 22.70, +12, 44, 26.9, 4.91 },
    {  4, 13, 49.90, +12, 45, 11.9, 6.25 },
    { 23, 29,  9.31, +12, 45, 38.2, 4.55 },
    {  5, 58, 53.21, +12, 48, 31.0, 5.70 },
    { 11, 15, 57.79, +12, 50, 40.9, 6.67 },
    { 15, 41, 47.40, +12, 50, 51.0, 5.33 },
    {  7, 44, 13.99, +12, 51, 33.8, 6.43 },
    {  6, 45, 17.40, +12, 53, 44.2, 3.36 },
    {  3, 30, 52.39, +12, 56, 12.1, 4.11 },
    {  1,  6, 33.60, +12, 57, 22.0, 6.12 },
    { 14, 14,  5.21, +12, 57, 33.8, 5.54 },
    {  6, 39, 47.59, +12, 58, 59.2, 5.97 },
    { 14, 19, 16.30, +13,  0, 15.1, 5.41 },
    { 19, 26, 24.10, +13,  1, 26.0, 5.74 },
    { 20, 33, 57.00, +13,  1, 37.9, 5.38 },
    {  3, 51, 15.79, +13,  2, 44.9, 6.30 },
    {  4, 28, 50.21, +13,  2, 51.0, 5.03 },
    {  3, 11, 21.91, +13,  2, 52.1, 6.12 },
    {  8, 14, 21.00, +13,  2, 53.9, 6.38 },
    {  9, 51,  1.99, +13,  3, 58.0, 6.46 },
    { 18,  7, 48.41, +13,  4, 16.0, 6.63 },
    {  8,  5,  4.51, +13,  7,  5.2, 5.12 },
    { 22,  1,  5.40, +13,  7, 10.9, 5.60 },
    {  6, 54, 38.69, +13, 10, 40.1, 4.65 },
    {  3,  6, 23.71, +13, 11, 13.9, 5.62 },
    { 15, 53, 12.10, +13, 11, 48.1, 6.10 },
    {  0, 35, 54.70, +13, 12, 24.1, 6.41 },
    { 20, 19, 29.21, +13, 13,   .8, 6.21 },
    {  6, 43, 59.30, +13, 13, 40.1, 4.49 },
    { 15,  8, 53.40, +13, 14,  6.0, 6.10 },
    {  7, 59, 35.09, +13, 14, 31.9, 6.02 },
    {  8, 33, 45.10, +13, 15, 25.9, 6.28 },
    { 16, 49, 34.61, +13, 15, 41.0, 5.91 },
    { 19, 44, 34.10, +13, 18, 10.1, 6.26 },
    { 11, 15, 51.89, +13, 18, 27.0, 5.32 },
    { 20, 38, 43.90, +13, 18, 54.0, 5.72 },
    { 17, 38, 57.79, +13, 19, 45.1, 6.12 },
    { 10, 11, 38.21, +13, 21, 18.0, 6.44 },
    {  7, 49,  1.99, +13, 22, 14.9, 6.04 },
    {  0, 34, 55.30, +13, 22, 16.0, 6.40 },
    {  0,  5, 42.00, +13, 23, 46.0, 5.51 },
    {  4,  9,  1.61, +13, 23, 53.9, 5.95 },
    {  6, 50, 25.49, +13, 24, 47.9, 5.65 },
    {  2,  2, 35.21, +13, 28, 36.1, 5.94 },
    {  7, 41, 51.79, +13, 28, 50.2, 5.77 },
    {  0, 22, 25.49, +13, 28, 57.0, 6.23 },
    {  4, 56, 22.30, +13, 30, 51.8, 4.07 },
    { 14, 40, 42.41, +13, 32,  3.1, 5.91 },
    { 20, 20,   .19, +13, 32, 53.2, 5.95 },
    { 12, 48, 14.30, +13, 33, 11.2, 6.56 },
    { 17,  3, 58.01, +13, 34,  3.0, 6.08 },
    { 16, 48,  8.90, +13, 35, 26.2, 6.35 },
    { 17,  3, 39.31, +13, 36, 19.1, 5.93 },
    { 16, 55, 16.01, +13, 37, 10.9, 6.34 },
    { 18, 59,  5.69, +13, 37, 21.0, 5.23 },
    {  6, 11, 27.89, +13, 38, 19.0, 6.04 },
    {  8,  8, 42.41, +13, 38, 26.9, 6.27 },
    { 15, 43, 10.61, +13, 40,  4.1, 6.48 },
    { 13, 17, 15.60, +13, 40, 32.2, 5.33 },
    {  5, 28, 34.80, +13, 40, 44.0, 6.35 },
    { 16, 37, 48.00, +13, 41, 12.8, 6.31 },
    {  0, 57, 54.50, +13, 41, 44.9, 6.32 },
    { 20, 55, 36.70, +13, 43, 17.0, 5.17 },
    {  4, 30, 37.30, +13, 43, 27.8, 5.40 },
    { 10, 16, 40.70, +13, 43, 41.9, 5.41 },
    { 14, 41,  8.90, +13, 43, 41.9, 4.83 },
    { 14, 41,  8.90, +13, 43, 41.9, 4.43 },
    {  7, 40, 47.30, +13, 46, 14.9, 6.24 },
    { 18, 18,  2.90, +13, 46, 36.8, 6.30 },
    { 13, 28, 25.80, +13, 46, 44.0, 4.98 },
    { 15, 48, 13.30, +13, 47, 19.0, 6.00 },
    { 19, 41,  5.50, +13, 48, 56.2, 6.01 },
    {  6, 15,  8.50, +13, 51,  4.0, 5.91 },
    { 19,  5, 24.60, +13, 51, 47.9, 2.99 },
    {  4, 20, 52.80, +13, 51, 51.1, 6.17 },
    { 16, 57, 31.99, +13, 53,  3.1, 6.37 },
    {  5, 47, 42.89, +13, 53, 58.9, 5.29 },
    { 18, 58, 46.90, +13, 54, 24.1, 5.89 },
    {  5, 56,  3.50, +13, 55, 31.1, 6.60 },
    { 18, 52,  1.90, +13, 57, 56.2, 6.14 },
    {  8, 12, 22.10, +14,  0, 14.0, 6.54 },
    {  9, 43, 43.90, +14,  1, 18.1, 5.35 },
    { 16, 25, 25.01, +14,  1, 59.9, 4.57 },
    {  4, 19, 57.70, +14,  2,  7.1, 5.59 },
    { 13, 55, 49.99, +14,  3, 23.0, 6.16 },
    {  6, 17, 33.29, +14,  3, 29.9, 6.59 },
    {  4, 22,  3.50, +14,  4, 37.9, 5.72 },
    { 17,  3,  7.80, +14,  5, 30.8, 4.98 },
    { 15, 47, 17.30, +14,  6, 55.1, 5.71 },
    { 12, 48, 54.19, +14,  7, 21.0, 5.70 },
    { 10, 32, 11.81, +14,  8, 13.9, 5.46 },
    {  6, 33, 36.10, +14,  9, 19.1, 5.53 },
    {  5, 52, 22.30, +14, 10, 18.1, 5.59 },
    { 10, 46, 25.30, +14, 11, 40.9, 5.48 },
    {  7, 42,  3.19, +14, 12, 29.9, 5.56 },
    {  6, 11, 56.40, +14, 12, 32.0, 4.48 },
    {  8, 28, 37.30, +14, 12, 38.9, 5.95 },
    {  4, 52, 31.99, +14, 15,  2.2, 4.74 },
    { 19, 27, 33.89, +14, 16, 57.0, 6.32 },
    { 11, 48, 38.71, +14, 17,  3.1, 5.88 },
    { 18,  8, 33.70, +14, 17,  4.9, 6.37 },
    { 17, 43, 22.01, +14, 17, 42.0, 6.24 },
    { 13, 38,  7.90, +14, 18,  6.1, 6.52 },
    {  5, 33, 54.29, +14, 18, 20.2, 5.64 },
    {  5, 50, 28.90, +14, 18, 20.2, 5.52 },
    { 11, 31, 44.90, +14, 21, 51.8, 6.20 },
    {  9, 35, 52.90, +14, 22, 46.9, 6.36 },
    {  6, 18,  5.59, +14, 22, 58.1, 6.16 },
    { 17, 14, 39.19, +14, 23, 24.0, 5.39 },
    { 17, 14, 38.90, +14, 23, 25.1, 3.48 },
    { 19, 36, 15.79, +14, 23, 30.1, 6.38 },
    { 11, 11, 43.70, +14, 24,  1.1, 6.30 },
    { 17, 44, 17.30, +14, 24, 37.1, 6.19 },
    { 15, 57, 14.59, +14, 24, 51.8, 5.54 },
    { 14, 56, 13.20, +14, 26, 47.0, 5.77 },
    {  5, 47, 13.20, +14, 29, 17.9, 5.72 },
    { 17,  3, 10.39, +14, 30, 40.0, 6.52 },
    { 22, 41, 57.41, +14, 30, 59.0, 5.90 },
    {  4, 58, 59.40, +14, 32, 34.1, 6.09 },
    { 19, 16, 26.81, +14, 32, 40.9, 5.63 },
    { 22, 40, 52.70, +14, 32, 57.8, 5.71 },
    { 20, 22, 52.30, +14, 33,  5.0, 6.17 },
    { 20, 20, 20.50, +14, 34,  9.1, 6.13 },
    { 11, 49,  3.60, +14, 34, 18.8, 2.14 },
    { 20, 41, 16.20, +14, 34, 59.2, 5.99 },
    { 20, 37, 33.00, +14, 35, 43.1, 3.63 },
    { 19, 29, 22.10, +14, 35, 44.9, 5.56 },
    {  8, 10, 58.80, +14, 37, 45.8, 6.23 },
    { 22, 10, 22.20, +14, 37, 48.0, 6.33 },
    { 13, 58, 39.89, +14, 38, 57.8, 6.00 },
    {  6, 20,  4.20, +14, 39,  4.0, 5.69 },
    {  1, 35, 46.39, +14, 39, 41.0, 6.22 },
    { 20, 35, 18.50, +14, 40, 27.1, 4.68 },
    {  4, 26, 36.41, +14, 42, 49.0, 4.69 },
    {  6, 25, 28.10, +14, 43, 18.8, 6.24 },
    { 21,  3,  1.80, +14, 43, 48.0, 6.31 },
    {  4, 28, 23.40, +14, 44, 26.9, 5.90 },
    {  6,  7, 34.30, +14, 46,  5.9, 4.42 },
    { 21, 44, 31.30, +14, 46, 18.8, 5.94 },
    { 17, 33, 42.79, +14, 50, 30.1, 6.48 },
    {  4, 33, 50.90, +14, 50, 39.8, 4.65 },
    { 12, 16,   .19, +14, 53, 56.0, 5.10 },
    { 19, 23,  8.21, +14, 55, 16.0, 6.64 },
    {  9, 15, 13.80, +14, 56, 29.0, 5.34 },
    {  1,  5,  5.40, +14, 56, 46.0, 5.68 },
    { 17,  1, 33.00, +14, 56, 57.8, 6.31 },
    { 18, 25, 55.39, +14, 58,   .1, 6.37 },
    { 16, 52,  4.90, +14, 58, 27.1, 6.52 },
    { 10, 21, 50.30, +14, 58, 32.2, 6.12 },
    {  9, 12, 17.59, +14, 59, 46.0, 6.51 },
    {  2, 32, 54.10, +15,  2,  4.9, 6.04 },
    {  4, 55, 50.30, +15,  2, 24.0, 5.81 },
    { 18, 59, 37.39, +15,  4,  5.9, 4.02 },
    { 20, 43, 27.50, +15,  4, 27.8, 4.43 },
    {  2, 51, 29.59, +15,  4, 54.8, 5.49 },
    { 19, 15, 20.09, +15,  5,  1.0, 5.57 },
    { 18,  0, 57.19, +15,  5, 35.9, 6.26 },
    {  4, 20, 36.31, +15,  5, 43.1, 5.26 },
    {  7, 28, 47.30, +15,  6, 33.8, 6.22 },
    { 14, 46,  6.00, +15,  7, 54.8, 5.63 },
    { 15, 50, 41.71, +15,  8,  1.0, 5.20 },
    {  7, 20,  6.89, +15,  8, 34.1, 6.45 },
    { 12, 17, 44.30, +15,  8, 39.1, 6.34 },
    {  4,  7, 42.00, +15,  9, 46.1, 6.01 },
    { 17, 41, 10.99, +15, 10, 41.2, 6.34 },
    {  0, 13, 14.21, +15, 11,  1.0, 2.83 },
    { 20, 14, 16.61, +15, 11, 51.0, 4.95 },
    { 23,  4, 45.70, +15, 12, 19.1, 2.49 },
    {  0, 36, 47.30, +15, 13, 54.1, 5.89 },
    {  5, 27, 13.80, +15, 15, 28.1, 6.16 },
    { 14, 17, 28.39, +15, 15, 47.9, 5.80 },
    {  2, 13,  3.29, +15, 16, 46.9, 5.71 },
    {  2, 44, 32.90, +15, 18, 42.1, 5.77 },
    {  8, 36,  7.70, +15, 18, 49.0, 6.32 },
    {  8, 57, 14.90, +15, 19, 22.1, 5.20 },
    { 17, 51, 58.49, +15, 19, 32.9, 6.46 },
    {  7,  2, 17.40, +15, 20, 10.0, 5.74 },
    {  1, 31, 28.99, +15, 20, 44.9, 3.62 },
    {  8, 51,  1.51, +15, 21,  2.2, 6.38 },
    {  5, 30, 26.09, +15, 21, 37.1, 5.94 },
    {  9, 21, 15.41, +15, 22, 16.0, 6.53 },
    {  4, 15, 46.30, +15, 24,  2.2, 6.32 },
    {  5,  4, 34.10, +15, 24, 15.1, 4.68 },
    { 11, 29, 41.90, +15, 24, 47.9, 5.74 },
    { 15, 46, 11.30, +15, 25, 18.8, 3.67 },
    { 15, 25, 47.40, +15, 25, 41.2, 5.17 },
    { 11, 14, 14.40, +15, 25, 45.8, 3.34 },
    {  3, 37, 47.81, +15, 25, 50.9, 6.39 },
    {  0, 46, 33.00, +15, 28, 32.2, 5.38 },
    { 16, 36, 43.01, +15, 29, 53.2, 6.30 },
    { 20,  5, 26.50, +15, 30,  1.1, 6.34 },
    {  7, 24, 27.70, +15, 31,  1.9, 6.41 },
    {  8, 57, 35.21, +15, 34, 53.0, 5.67 },
    {  5,  9, 42.00, +15, 35, 49.9, 4.82 },
    { 17, 24, 33.79, +15, 36, 22.0, 6.35 },
    {  4, 26, 20.81, +15, 37,  5.9, 4.49 },
    {  4, 19, 47.59, +15, 37, 39.0, 3.65 },
    {  4, 30,  8.59, +15, 38, 17.2, 5.58 },
    { 11, 55, 40.49, +15, 38, 48.1, 5.53 },
    { 21,  7, 33.60, +15, 39, 31.0, 6.34 },
    { 15, 56, 27.19, +15, 39, 42.1, 3.85 },
    {  1, 10, 11.50, +15, 40, 27.1, 6.06 },
    {  4, 30, 38.90, +15, 41, 30.8, 5.48 },
    { 14, 53, 23.30, +15, 42, 15.8, 6.40 },
    { 16, 45, 22.51, +15, 44, 43.1, 5.56 },
    { 10,  5, 40.90, +15, 45, 27.0, 6.37 },
    {  7, 56, 59.40, +15, 47, 25.1, 5.78 },
    { 13, 49, 28.61, +15, 47, 52.1, 4.07 },
    {  4, 39,  9.19, +15, 47, 58.9, 5.07 },
    {  5, 46, 45.50, +15, 49, 21.0, 6.00 },
    {  7, 33, 36.50, +15, 49, 36.1, 5.25 },
    { 20, 39,  4.99, +15, 50, 17.2, 5.97 },
    {  4, 31, 51.79, +15, 51,  6.1, 6.02 },
    {  3,  4, 40.70, +15, 51, 22.0, 6.49 },
    { 22, 32, 46.90, +15, 51, 47.9, 6.32 },
    {  4, 28, 39.70, +15, 52, 14.9, 3.40 },
    {  5, 27, 45.60, +15, 52, 27.1, 5.50 },
    {  6, 31, 37.39, +15, 54, 11.9, 6.40 },
    {  4, 49, 44.09, +15, 54, 15.1, 6.08 },
    { 20, 39, 38.30, +15, 54, 42.8, 3.77 },
    {  4, 39, 16.49, +15, 55,  5.2, 4.69 },
    {  7,  8, 22.01, +15, 55, 50.9, 5.44 },
    {  4, 25, 37.30, +15, 56, 26.9, 6.46 },
    { 17, 41, 58.70, +15, 57,  6.8, 5.52 },
    {  4, 28, 34.51, +15, 57, 43.9, 3.84 },
    { 21, 13, 28.80, +15, 58, 57.0, 6.27 },
    { 15, 40, 59.21, +16,  1, 28.9, 6.01 },
    { 20,  3, 30.00, +16,  1, 53.0, 5.67 },
    {  4, 38,  9.41, +16,  1, 59.9, 5.79 },
    { 22, 11, 51.29, +16,  2, 26.2, 5.95 },
    {  5, 11, 41.59, +16,  2, 44.2, 5.18 },
    { 15, 32,  9.70, +16,  3, 22.0, 6.22 },
    {  6, 24, 52.90, +16,  3, 24.8, 6.33 },
    { 15, 53, 34.90, +16,  4, 30.0, 6.09 },
    {  7,  0, 15.79, +16,  4, 44.0, 5.68 },
    { 15, 36, 29.30, +16,  7,  8.0, 5.93 },
    { 12, 52, 27.60, +16,  7, 21.0, 6.30 },
    { 20, 46, 39.50, +16,  7, 27.1, 4.27 },
    { 20, 46, 38.71, +16,  7, 27.8, 5.14 },
    {  6, 12,  3.29, +16,  7, 50.2, 4.95 },
    {  1, 14,  7.61, +16,  8,  1.0, 5.98 },
    {  6, 15, 25.10, +16,  8, 35.2, 5.30 },
    {  7, 13, 22.30, +16,  9, 32.0, 5.00 },
    {  4, 30, 33.70, +16, 11, 38.0, 4.78 },
    { 18, 37,  9.00, +16, 11, 53.9, 6.29 },
    {  6, 49, 49.80, +16, 12, 10.1, 5.85 },
    {  6, 28, 28.01, +16, 14, 17.9, 6.23 },
    { 11, 49, 14.90, +16, 14, 34.1, 6.04 },
    { 17, 24, 31.51, +16, 18,  4.0, 5.71 },
    { 14, 19, 45.19, +16, 18, 24.8, 4.86 },
    { 17, 33, 39.41, +16, 19,  3.0, 5.69 },
    {  4, 28, 26.40, +16, 21, 34.9, 4.97 },
    { 14, 57, 11.71, +16, 23, 17.9, 5.71 },
    {  6, 41, 21.79, +16, 23, 51.0, 6.28 },
    {  6, 37, 42.70, +16, 23, 57.1, 1.93 },
    {  1, 39, 40.80, +16, 24, 20.9, 5.97 },
    { 14, 40, 43.90, +16, 25,  4.1, 5.88 },
    { 14, 40, 43.61, +16, 25,  5.9, 4.94 },
    {  9, 37,  2.59, +16, 26, 16.1, 5.69 },
    {  0, 28, 12.70, +16, 26, 42.0, 6.06 },
    {  8,  1, 30.31, +16, 27, 19.1, 5.99 },
    { 11, 25, 36.41, +16, 27, 23.0, 5.57 },
    { 19, 37, 17.40, +16, 27, 46.1, 5.66 },
    { 18, 10,  8.71, +16, 28, 36.1, 6.09 },
    {  2, 53, 11.71, +16, 28, 59.9, 6.31 },
    { 17, 34, 27.19, +16, 30, 14.0, 6.40 },
    {  4, 35, 55.20, +16, 30, 33.1, 0.85 },
    {  8, 12, 59.81, +16, 30, 51.1, 6.01 },
    {  7, 58, 31.49, +16, 31,  7.0, 5.99 },
    {  5, 41, 17.71, +16, 32,  2.0, 4.86 },
    {  3, 39, 25.70, +16, 32, 12.1, 6.16 },
    {  7, 18,  5.59, +16, 32, 25.1, 3.58 },
    { 23,  5,  6.29, +16, 33, 47.2, 6.44 },
    { 19, 39, 25.39, +16, 34, 17.0, 6.38 },
    { 12, 46, 38.71, +16, 34, 39.0, 5.12 },
    {  9, 25, 32.50, +16, 35,  8.2, 6.29 },
    { 19, 56,  1.30, +16, 38,  4.9, 5.36 },
    { 20,  8,  6.50, +16, 39, 51.1, 6.42 },
    { 16, 11, 28.70, +16, 39, 56.2, 6.08 },
    {  7,  2, 33.50, +16, 40, 27.1, 5.82 },
    { 18, 23,  2.90, +16, 41, 17.2, 6.22 },
    {  5, 23, 37.70, +16, 41, 57.8, 6.08 },
    {  5, 26,  5.71, +16, 42,  1.1, 6.25 },
    { 17, 21, 33.41, +16, 43, 50.9, 6.35 },
    { 18,  0,  3.41, +16, 45,  2.9, 4.67 },
    { 10,  7, 19.99, +16, 45, 46.1, 3.52 },
    {  4, 23, 25.01, +16, 46, 37.9, 5.64 },
    { 19, 57, 45.41, +16, 47, 21.1, 5.53 },
    { 11, 34, 42.50, +16, 47, 48.8, 5.95 },
    { 12, 10, 31.61, +16, 48, 33.1, 6.39 },
    { 20, 59, 50.81, +16, 49, 27.1, 6.66 },
    { 23, 37, 39.79, +16, 49, 32.2, 6.26 },
    { 22, 53,  2.30, +16, 50, 28.0, 5.64 },
    { 19, 12, 34.39, +16, 50, 47.0, 6.73 },
    { 13,  9, 47.81, +16, 50, 55.0, 5.91 },
    { 19,  8, 40.20, +16, 51,  5.0, 6.48 },
    { 19,  7, 57.29, +16, 51, 11.9, 6.07 },
    { 17, 25, 54.41, +16, 55,  3.0, 5.98 },
    { 18, 31,  4.39, +16, 55, 43.0, 5.77 },
    { 19, 24, 22.10, +16, 56, 16.1, 6.25 },
    {  6, 31, 10.10, +16, 56, 19.0, 6.20 },
    {  0, 48, 58.70, +16, 56, 26.2, 5.07 },
    { 22, 54, 35.69, +16, 56, 30.1, 6.12 },
    {  1, 48, 10.90, +16, 57, 20.2, 5.84 },
    { 14, 45, 14.50, +16, 57, 51.8, 4.60 },
    { 18, 35, 53.21, +16, 58, 32.2, 6.21 },
    {  5, 37,  3.79, +17,  2, 25.1, 5.54 },
    {  8, 25, 49.90, +17,  2, 46.0, 6.14 },
    { 16,  8,  4.51, +17,  2, 48.8, 5.00 },
    { 16,  8,  4.90, +17,  3, 15.8, 6.25 },
    { 16, 35, 26.30, +17,  3, 25.9, 6.41 },
    {  5, 32, 14.21, +17,  3, 29.2, 5.46 },
    { 20,  4,  6.19, +17,  4, 12.0, 5.80 },
    { 12, 52, 12.31, +17,  4, 26.0, 6.32 },
    {  7, 31, 48.41, +17,  5, 10.0, 5.42 },
    { 12, 36, 58.30, +17,  5, 21.8, 5.68 },
    { 13,  1,  9.60, +17,  7, 23.2, 5.96 },
    { 15, 33, 52.80, +17,  8, 16.1, 6.45 },
    {  8, 57,  8.21, +17,  8, 38.0, 6.17 },
    {  4, 57, 22.30, +17,  9, 13.0, 5.48 },
    {  6, 16, 23.81, +17, 10, 53.0, 6.39 },
    { 21, 47,  4.70, +17, 11, 39.1, 6.21 },
    { 16,  8, 46.61, +17, 12, 20.9, 6.14 },
    {  2,  9, 23.09, +17, 13, 27.8, 6.43 },
    {  8, 55, 22.90, +17, 13, 53.0, 6.64 },
    {  5, 28,  1.61, +17, 14, 20.0, 5.77 },
    { 15, 44, 42.10, +17, 15, 51.1, 6.14 },
    {  4, 12, 31.39, +17, 16, 39.0, 6.09 },
    { 21, 50,  8.71, +17, 17,  8.2, 5.29 },
    {  4,  0, 36.91, +17, 17, 48.1, 6.32 },
    {  8,  0, 47.30, +17, 18, 31.0, 5.55 },
    { 20, 26, 23.21, +17, 18, 56.2, 6.22 },
    { 17, 18,  4.99, +17, 19,  5.2, 6.00 },
    {  6, 19,  1.80, +17, 19, 30.0, 6.32 },
    {  3, 53, 10.01, +17, 19, 36.8, 5.97 },
    {  4,  7, 59.40, +17, 20, 22.9, 5.89 },
    { 21, 44, 30.70, +17, 21,   .0, 4.34 },
    { 18, 58, 14.69, +17, 21, 38.9, 5.38 },
    {  5, 24, 25.39, +17, 22, 59.9, 4.99 },
    { 15, 52, 56.21, +17, 24, 13.0, 6.36 },
    { 12, 58, 55.39, +17, 24, 33.8, 4.78 },
    {  1, 46, 35.30, +17, 24, 47.2, 6.55 },
    {  1, 35, 54.79, +17, 26,  1.0, 5.80 },
    {  4, 24,  5.81, +17, 26, 38.0, 4.80 },
    { 13, 47, 15.70, +17, 27, 24.1, 4.50 },
    {  2, 49, 17.50, +17, 27, 51.1, 5.22 },
    { 19, 41,  2.90, +17, 28, 34.0, 4.37 },
    { 20,  0,  3.31, +17, 31,   .1, 5.37 },
    { 20, 41, 58.20, +17, 31, 17.0, 6.22 },
    { 13,  9, 59.30, +17, 31, 45.8, 5.22 },
    { 13,  9, 59.30, +17, 31, 45.8, 5.22 },
    {  4, 22, 56.09, +17, 32, 33.0, 3.76 },
    { 23, 10, 42.60, +17, 35, 39.8, 5.71 },
    {  6, 42, 24.29, +17, 38, 43.1, 5.21 },
    {  8, 12, 12.70, +17, 38, 52.1, 6.02 },
    {  8, 12, 12.70, +17, 38, 52.1, 5.63 },
    {  8, 12, 13.30, +17, 38, 52.1, 6.20 },
    { 15, 35, 33.19, +17, 39, 20.2, 6.12 },
    {  7, 39, 28.61, +17, 40, 28.9, 5.05 },
    {  8, 14, 11.09, +17, 40, 32.9, 6.47 },
    { 17, 47,  7.99, +17, 41, 49.9, 5.72 },
    {  2, 30, 54.41, +17, 42, 14.0, 6.23 },
    {  5, 47, 26.21, +17, 43, 45.1, 5.49 },
    { 10, 16, 16.10, +17, 44, 25.1, 6.55 },
    {  7,  2, 25.49, +17, 45, 20.2, 5.94 },
    {  6, 21, 25.90, +17, 45, 49.0, 6.35 },
    {  2, 44, 19.10, +17, 45, 50.0, 6.46 },
    { 12, 20, 43.01, +17, 47, 34.1, 4.74 },
    { 20, 20, 21.41, +17, 47, 35.2, 5.80 },
    {  1, 57, 21.10, +17, 49,  3.0, 5.10 },
    { 16,  1, 14.30, +17, 49,  5.9, 5.12 },
    { 18, 22, 49.01, +17, 49, 36.1, 5.25 },
    {  3, 34,  8.30, +17, 49, 58.1, 6.17 },
    {  3,  7, 25.70, +17, 52, 48.0, 6.11 },
    {  0, 28,  2.90, +17, 53, 35.2, 5.06 },
    { 21, 28, 59.90, +17, 54, 20.9, 6.44 },
    {  6, 14, 28.61, +17, 54, 23.0, 5.88 },
    {  4, 25, 29.40, +17, 55, 41.2, 4.29 },
    { 13, 53, 12.91, +17, 55, 58.1, 5.70 },
    {  5, 27, 10.10, +17, 57, 43.9, 5.42 },
    { 18, 56,  3.89, +17, 59, 42.0, 6.63 },
    { 22,  7, 30.00, +18,  0,  2.2, 6.35 },
    { 19, 40,  5.81, +18,  0, 50.0, 4.37 },
    {  4, 33, 32.90, +18,  1,   .1, 6.25 },
    {  2, 56, 26.09, +18,  1, 23.2, 5.63 },
    { 20, 50, 37.01, +18,  3,  5.0, 6.52 },
    { 17, 20, 18.89, +18,  3, 25.9, 5.00 },
    { 20, 45, 28.20, +18,  5, 25.1, 6.38 },
    {  8, 31, 35.71, +18,  5, 39.8, 5.35 },
    { 18, 56,  6.19, +18,  6, 19.1, 5.69 },
    {  6, 11,  1.80, +18,  7, 45.8, 6.33 },
    { 18, 18,  7.70, +18,  7, 53.0, 5.99 },
    {  8, 59, 10.80, +18,  8,  4.9, 6.38 },
    { 15, 48, 44.40, +18,  8, 30.1, 4.09 },
    {  8, 44, 41.09, +18,  9, 15.1, 3.94 },
    { 18, 47,  1.30, +18, 10, 53.0, 4.36 },
    {  6, 47, 23.50, +18, 11, 35.9, 6.20 },
    {  4,  0, 48.79, +18, 11, 38.0, 5.89 },
    { 18, 35, 12.60, +18, 12, 11.9, 5.78 },
    {  0,  9,  2.40, +18, 12, 42.8, 5.53 },
    {  2,  3, 42.60, +18, 15, 11.9, 6.21 },
    { 13, 39,  2.30, +18, 15, 55.1, 6.48 },
    { 20, 37, 54.60, +18, 16,  9.1, 6.25 },
    {  2, 48, 32.11, +18, 17,  1.0, 5.82 },
    { 14, 38, 13.99, +18, 17, 53.9, 5.91 },
    {  2, 55, 48.50, +18, 19, 54.1, 5.91 },
    {  8, 23, 21.79, +18, 19, 55.9, 5.95 },
    {  1, 29, 52.90, +18, 21, 20.2, 6.02 },
    { 13,  0, 38.81, +18, 22, 23.2, 6.20 },
    { 12, 35,  7.80, +18, 22, 36.8, 5.02 },
    { 12, 35,  6.29, +18, 22, 37.9, 6.56 },
    { 13, 54, 41.09, +18, 23, 52.1, 2.68 },
    { 23, 37, 56.81, +18, 24,  2.2, 5.53 },
    { 11, 30, 28.99, +18, 24, 34.9, 5.52 },
    { 16, 55, 22.20, +18, 25, 59.9, 5.35 },
    { 15,  7, 20.40, +18, 26, 30.1, 6.02 },
    { 22, 25, 40.70, +18, 26, 39.8, 6.26 },
    {  1, 34, 49.10, +18, 27, 38.2, 5.89 },
    { 15, 41, 54.70, +18, 27, 50.0, 5.81 },
    { 20,  3, 16.39, +18, 30,  2.2, 5.96 },
    {  7, 46,  7.39, +18, 30, 36.0, 4.88 },
    { 23,  6, 18.19, +18, 31,  3.0, 6.13 },
    { 19, 47, 23.30, +18, 32,  3.1, 3.82 },
    {  5, 33, 31.61, +18, 32, 25.1, 5.69 },
    {  5, 32, 12.79, +18, 35, 39.8, 4.38 },
    { 15, 55, 39.79, +18, 37, 14.2, 6.26 },
    {  5,  7, 27.00, +18, 38, 42.0, 5.00 },
    { 19, 52, 21.79, +18, 40, 18.8, 6.23 },
    {  6, 13, 33.41, +18, 40, 49.1, 6.58 },
    { 18, 46, 41.40, +18, 42, 20.9, 6.17 },
    { 13, 13, 12.41, +18, 43, 36.8, 6.11 },
    {  4, 46, 16.80, +18, 44,  6.0, 6.01 },
    {  4, 20, 25.10, +18, 44, 33.0, 6.12 },
    { 13, 12, 35.90, +18, 45,  6.1, 6.53 },
    {  3, 27,  3.19, +18, 45, 23.0, 6.57 },
    {  3,  8, 21.19, +18, 47, 42.0, 6.27 },
    { 16, 15, 28.70, +18, 48, 29.9, 5.69 },
    {  8, 50, 45.10, +18, 49, 55.9, 6.16 },
    {  4, 51, 22.51, +18, 50, 22.9, 5.10 },
    {  8,  4, 45.19, +18, 50, 31.9, 6.15 },
    {  9, 44, 30.00, +18, 51, 49.0, 6.50 },
    { 14, 45, 20.69, +18, 53,  4.9, 6.13 },
    { 10, 46, 24.50, +18, 53, 29.0, 5.49 },
    { 16, 25, 47.69, +18, 53, 33.0, 6.70 },
    { 14, 16,  4.20, +18, 54, 42.8, 5.98 },
    { 15, 12,  4.30, +18, 58, 32.9, 5.89 },
    {  4, 24, 57.10, +19,  2, 30.1, 5.98 },
    { 13, 16, 14.30, +19,  3,  6.1, 6.45 },
    { 14, 51, 23.30, +19,  6,  4.0, 4.55 },
    { 23, 52, 29.30, +19,  7, 13.1, 5.08 },
    { 22, 50, 39.10, +19,  8, 26.9, 6.40 },
    { 19, 48, 58.70, +19,  8, 31.9, 5.00 },
    { 14, 53, 23.71, +19,  9, 10.1, 6.01 },
    { 16, 21, 55.20, +19,  9, 11.2, 3.75 },
    {  6, 14, 50.90, +19,  9, 23.0, 5.20 },
    {  1, 26, 15.29, +19, 10, 19.9, 5.38 },
    {  4, 28, 37.01, +19, 10, 49.1, 3.53 },
    { 14, 15, 39.70, +19, 10, 57.0,-0.04 },
    {  0, 54, 35.21, +19, 11, 17.9, 5.74 },
    { 14, 26, 27.41, +19, 13, 36.8, 5.39 },
    {  1, 26, 41.69, +19, 14, 25.1, 5.50 },
    { 17, 48, 47.90, +19, 15, 19.1, 6.12 },
    { 17, 33, 22.80, +19, 15, 24.1, 5.64 },
    { 15, 12, 43.49, +19, 17,  8.9, 6.68 },
    {  1, 53, 31.80, +19, 17, 37.0, 4.75 },
    {  1, 53, 31.80, +19, 17, 44.9, 4.83 },
    { 19,  1,  5.50, +19, 18, 34.9, 6.39 },
    { 21, 37, 45.41, +19, 19,  7.0, 5.45 },
    {  7, 51, 56.71, +19, 19, 31.1, 5.99 },
    { 18, 48, 53.40, +19, 19, 43.0, 5.88 },
    { 21,  0, 27.70, +19, 19, 45.8, 5.65 },
    { 10, 27,   .50, +19, 21, 51.8, 6.15 },
    { 22, 45, 28.20, +19, 22,   .1, 6.25 },
    { 21, 26, 26.69, +19, 22, 32.2, 6.07 },
    { 10, 19, 44.09, +19, 28, 14.9, 4.79 },
    { 22,  7, 28.61, +19, 28, 32.2, 5.75 },
    { 15, 25, 53.30, +19, 28, 50.9, 6.27 },
    {  4, 54, 58.30, +19, 29,  7.1, 6.37 },
    { 19, 58, 45.41, +19, 29, 31.9, 3.47 },
    {  2, 10, 37.61, +19, 30,  1.1, 5.70 },
    { 18,  0, 27.70, +19, 30, 20.9, 6.50 },
    { 22, 38, 52.61, +19, 31, 19.9, 5.82 },
    {  8, 40, 27.00, +19, 32, 42.0, 6.30 },
    {  0, 47, 13.61, +19, 34, 44.0, 6.13 },
    {  8, 35, 19.39, +19, 35, 24.0, 6.58 },
    { 17,  4, 41.30, +19, 35, 57.1, 6.17 },
    {  4,  9, 10.01, +19, 36, 33.1, 5.50 },
    { 19, 18, 48.50, +19, 36, 38.2, 6.58 },
    { 18,  3, 14.69, +19, 36, 47.2, 6.50 },
    { 22, 10, 19.01, +19, 37,   .8, 6.18 },
    {  1,  9, 49.20, +19, 39, 31.0, 5.55 },
    { 19,  2, 52.61, +19, 39, 40.0, 6.09 },
    {  3, 43, 47.21, +19, 39, 54.0, 6.14 },
    { 21, 53, 37.39, +19, 40,  5.9, 5.68 },
    {  8, 40, 22.10, +19, 40, 12.0, 6.44 },
    { 15, 41, 33.10, +19, 40, 13.1, 4.52 },
    { 22, 39, 46.99, +19, 40, 52.0, 6.21 },
    { 17,  3, 52.70, +19, 41, 26.2, 6.35 },
    {  6,  3, 27.29, +19, 41, 26.2, 5.14 },
    {  3, 42, 18.91, +19, 42,  1.1, 5.69 },
    { 21, 54, 17.40, +19, 43,  5.9, 6.39 },
    {  3, 11, 37.80, +19, 43, 36.1, 4.35 },
    {  5, 54, 56.71, +19, 44, 58.9, 5.92 },
    { 10, 44, 14.50, +19, 45, 31.0, 6.27 },
    { 19, 34, 34.90, +19, 46, 23.9, 5.00 },
    { 13, 16, 32.30, +19, 47,  7.1, 6.45 },
    {  6, 12,  1.30, +19, 47, 26.2, 5.75 },
    { 18, 58, 45.10, +19, 47, 39.1, 6.50 },
    { 19, 25, 28.61, +19, 47, 55.0, 5.16 },
    { 21, 22,  5.21, +19, 48, 15.8, 4.08 },
    {  5,  5, 32.11, +19, 48, 23.0, 6.44 },
    {  5, 20, 56.59, +19, 48, 51.1, 6.18 },
    {  8,  0, 48.00, +19, 48, 58.0, 6.25 },
    { 21, 51, 34.20, +19, 49, 36.1, 5.77 },
    { 10, 19, 58.61, +19, 50, 26.2, 3.80 },
    { 10, 19, 58.30, +19, 50, 30.1, 2.61 },
    {  2, 30, 38.40, +19, 51, 19.1, 6.15 },
    { 20, 26,  1.20, +19, 51, 54.0, 6.41 },
    {  5, 52, 23.40, +19, 52,  5.2, 6.06 },
    {  4, 35, 42.70, +19, 52, 54.1, 6.36 },
    {  7, 55, 39.91, +19, 53,  2.0, 5.35 },
    { 19, 26, 28.70, +19, 53, 29.0, 5.81 },
    {  2, 18,  7.49, +19, 54,  4.0, 5.62 },
    { 23,  6, 31.90, +19, 54, 38.9, 6.30 },
    { 20, 40, 45.19, +19, 56,  7.1, 6.45 },
    { 13, 40, 40.49, +19, 57, 20.2, 5.75 },
    { 20,  5,  9.50, +19, 59, 28.0, 5.10 },
    {  8, 40,  6.41, +20,  0, 28.1, 6.39 },
    {  2, 42, 22.01, +20,  0, 42.1, 5.69 },
    { 18,  8, 52.90, +20,  2, 43.1, 5.10 },
    { 17, 26, 49.10, +20,  4, 50.9, 5.54 },
    {  1, 44, 55.80, +20,  4, 59.2, 6.27 },
    { 20, 29, 21.10, +20,  5, 16.1, 6.55 },
    { 19, 26, 13.20, +20,  5, 52.1, 5.63 },
    { 14, 16, 32.81, +20,  7, 17.0, 6.25 },
    {  5, 19, 14.69, +20,  8,  4.9, 6.08 },
    {  6,  3, 55.20, +20,  8, 17.9, 4.63 },
    {  5, 55, 49.30, +20, 10, 30.0, 5.40 },
    { 11,  2, 19.80, +20, 10, 46.9, 4.42 },
    { 19, 15,  2.59, +20, 12, 11.9, 6.00 },
    {  0, 14, 36.19, +20, 12, 24.1, 4.80 },
    {  6, 28, 57.79, +20, 12, 43.9, 4.15 },
    { 11, 47, 59.09, +20, 13,  8.0, 4.53 },
    { 22, 32, 35.50, +20, 13, 48.0, 6.42 },
    {  7, 26, 56.30, +20, 15, 25.9, 5.93 },
    { 19, 23, 46.90, +20, 15, 51.8, 6.40 },
    { 21, 39,  1.10, +20, 15, 55.1, 5.85 },
    {  1, 42, 29.81, +20, 16,  7.0, 5.24 },
    { 19, 25, 22.39, +20, 16, 17.0, 6.31 },
    {  5, 54, 22.90, +20, 16, 34.0, 4.41 },
    { 19, 29, 20.90, +20, 16, 46.9, 6.33 },
    {  0, 32, 35.50, +20, 17, 39.8, 5.38 },
    {  5, 53, 19.10, +20, 17, 57.1, 6.71 },
    { 15, 54, 34.61, +20, 18, 38.9, 5.44 },
    {  7, 45,  9.29, +20, 18, 59.0, 6.33 },
    { 19, 36, 37.70, +20, 19, 58.1, 7.14 },
    {  5,  7, 48.41, +20, 25,  5.9, 5.30 },
    {  8, 32, 42.50, +20, 26, 28.0, 5.33 },
    { 11, 35,  3.79, +20, 26, 29.0, 6.45 },
    {  7, 21, 56.81, +20, 26, 37.0, 5.10 },
    { 21, 49, 26.90, +20, 27, 45.0, 6.29 },
    { 18, 34, 19.61, +20, 27, 59.0, 6.57 },
    {  1, 23, 24.91, +20, 28,  8.0, 5.97 },
    {  5, 33, 38.81, +20, 28, 27.1, 6.18 },
    { 19, 40, 28.30, +20, 28, 36.1, 6.50 },
    { 16, 30, 33.60, +20, 28, 45.1, 5.25 },
    {  6, 27, 56.59, +20, 29, 46.0, 6.22 },
    { 11, 14,  6.50, +20, 31, 25.0, 2.56 },
    { 12, 12,  9.31, +20, 32, 30.8, 5.57 },
    { 18, 45, 39.70, +20, 32, 47.0, 4.19 },
    { 17, 48, 24.79, +20, 33, 56.2, 5.69 },
    {  7,  4,  6.50, +20, 34, 13.1, 3.79 },
    { 15, 18, 24.50, +20, 34, 22.1, 5.70 },
    {  4, 17, 15.60, +20, 34, 43.0, 4.94 },
    { 20, 30, 58.10, +20, 36, 20.9, 6.18 },
    {  2, 58,  5.21, +20, 40,  7.0, 5.80 },
    {  4, 38, 15.79, +20, 41,  4.9, 5.92 },
    {  5, 45, 39.41, +20, 41, 42.0, 6.95 },
    {  1,  7, 57.19, +20, 44, 21.1, 5.55 },
    {  3, 22, 45.19, +20, 44, 30.8, 5.09 },
    {  8, 20, 21.00, +20, 44, 52.1, 5.83 },
    { 22, 57, 27.89, +20, 46,  8.0, 5.49 },
    { 19, 38, 17.50, +20, 46, 58.1, 6.48 },
    {  3, 24, 26.09, +20, 48, 13.0, 6.08 },
    {  1, 54, 38.40, +20, 48, 29.2, 2.64 },
    { 18,  8, 45.50, +20, 48, 51.8, 4.36 },
    { 18, 30, 41.59, +20, 48, 55.1, 6.50 },
    {  4, 22, 22.80, +20, 49, 17.0, 5.91 },
    { 23, 22, 40.51, +20, 49, 43.0, 6.29 },
    { 19,  1, 22.61, +20, 50,  1.0, 6.69 },
    { 18,  2, 23.11, +20, 50,  1.0, 5.28 },
    { 23, 33, 55.51, +20, 50, 26.9, 6.06 },
    { 22, 23, 39.60, +20, 50, 53.9, 6.04 },
    {  5, 48, 22.39, +20, 52,  9.8, 6.07 },
    { 12, 29, 43.20, +20, 53, 46.0, 5.69 },
    { 20,  9, 56.59, +20, 54, 55.1, 6.48 },
    {  3, 39,   .10, +20, 54, 56.9, 6.50 },
    {  0, 47, 54.79, +20, 55, 31.1, 6.54 },
    {  3, 44, 28.10, +20, 55, 43.0, 6.10 },
    { 16, 54, 55.20, +20, 57, 31.0, 5.41 },
    { 15, 51, 15.91, +20, 58, 40.1, 4.76 },
    { 22, 10, 30.19, +20, 58, 41.2, 6.46 },
    {  4, 23, 32.40, +20, 58, 55.9, 5.99 },
    { 20, 34, 10.01, +20, 59,  7.1, 6.48 },
    { 17, 35, 59.59, +20, 59, 46.0, 6.10 },
    { 19, 57,   .19, +20, 59, 53.2, 6.48 },
    {  1, 11, 27.19, +21,  2,  4.9, 4.66 },
    {  3, 14, 54.10, +21,  2, 39.8, 4.89 },
    {  1, 59, 35.71, +21,  3, 29.9, 5.87 },
    { 12, 39,  7.30, +21,  3, 45.0, 5.46 },
    { 14, 41, 54.19, +21,  7, 25.0, 6.38 },
    { 16, 20,  4.30, +21,  7, 57.0, 6.05 },
    { 23,  7, 28.70, +21,  8,  3.1, 5.99 },
    { 20, 11,  3.50, +21,  8,  4.9, 6.22 },
    {  4, 19, 26.09, +21,  8, 31.9, 5.35 },
    {  5, 37, 38.69, +21,  8, 33.0, 3.00 },
    {  3, 21, 13.61, +21,  8, 48.8, 5.28 },
    { 13,  6, 21.19, +21,  9, 11.9, 5.99 },
    { 10, 14, 29.69, +21, 10,  4.1, 6.02 },
    {  9, 49, 50.11, +21, 10, 45.8, 6.09 },
    { 20, 38, 31.30, +21, 12,  4.0, 4.82 },
    {  2, 12, 48.10, +21, 12, 38.9, 5.27 },
    { 19, 15, 17.40, +21, 13, 55.9, 5.64 },
    { 21, 56, 24.00, +21, 14, 22.9, 6.40 },
    { 12, 53, 17.81, +21, 14, 42.0, 4.90 },
    {  7, 10,  6.70, +21, 14, 48.8, 6.43 },
    {  0, 39, 21.79, +21, 15,  2.2, 5.87 },
    { 13, 49, 42.79, +21, 15, 51.1, 4.91 },
    { 19,  3, 42.50, +21, 16,  4.1, 6.52 },
    { 21, 52, 18.19, +21, 16, 23.2, 6.89 },
    {  5,  4, 21.60, +21, 16, 41.2, 6.19 },
    {  9, 13, 37.30, +21, 16, 59.9, 6.48 },
    {  2, 59, 12.70, +21, 20, 25.1, 4.63 },
    {  2, 59, 12.70, +21, 20, 25.1, 4.63 },
    { 11, 40, 47.09, +21, 21, 10.1, 5.26 },
    { 19, 16, 13.01, +21, 23, 25.1, 4.77 },
    {  0, 58, 18.89, +21, 24, 15.8, 6.37 },
    { 20, 25, 40.51, +21, 24, 34.9, 5.66 },
    { 18, 52, 16.39, +21, 25, 31.1, 5.48 },
    {  0, 39, 55.61, +21, 26, 17.9, 5.36 },
    {  7, 27, 44.40, +21, 26, 42.0, 5.22 },
    { 12,  4, 16.61, +21, 27, 33.1, 5.87 },
    {  1,  5, 41.69, +21, 27, 55.1, 5.56 },
    {  8, 43, 17.09, +21, 28,  7.0, 4.66 },
    {  1,  5, 40.90, +21, 28, 23.9, 5.34 },
    { 16, 30, 13.20, +21, 29, 22.9, 2.77 },
    {  7, 26, 50.21, +21, 32,  8.9, 6.54 },
    { 19, 12, 36.70, +21, 33, 15.8, 5.93 },
    { 14, 57,  3.60, +21, 33, 19.1, 6.49 },
    {  4, 18, 23.21, +21, 34, 45.1, 5.65 },
    {  8,  7, 45.79, +21, 34, 54.1, 5.30 },
    {  5,  3,  5.71, +21, 35, 24.0, 4.64 },
    { 18,  1, 29.90, +21, 35, 43.1, 5.18 },
    { 18,  1, 30.41, +21, 35, 44.2, 4.96 },
    { 20, 16, 19.70, +21, 35, 55.0, 6.13 },
    {  4, 28,   .79, +21, 37, 12.0, 5.72 },
    { 18,  5, 30.19, +21, 38, 48.8, 6.15 },
    { 23, 52, 23.40, +21, 40, 14.9, 6.11 },
    { 13, 58, 38.90, +21, 41, 46.0, 5.76 },
    { 19,  8,  3.60, +21, 41, 56.0, 6.23 },
    { 22,  7, 50.30, +21, 42, 10.1, 5.78 },
    {  5,  7, 55.49, +21, 42, 16.9, 5.89 },
    {  6, 51, 33.00, +21, 45, 40.0, 5.27 },
    {  5, 39, 27.00, +21, 45, 46.1, 6.34 },
    { 18, 23, 41.90, +21, 46, 10.9, 3.84 },
    {  4, 19, 36.70, +21, 46, 25.0, 5.38 },
    { 20, 39, 10.61, +21, 49,  1.9, 6.08 },
    { 16,  7, 22.20, +21, 49, 21.0, 6.14 },
    {  6, 11, 51.41, +21, 52,  7.0, 6.56 },
    { 14, 14, 40.99, +21, 52, 23.9, 6.39 },
    { 20, 11, 21.10, +21, 52, 32.2, 6.26 },
    { 18, 13, 16.51, +21, 52, 49.1, 6.12 },
    { 12, 35,  8.11, +21, 52, 53.0, 5.85 },
    {  5, 27, 38.11, +21, 56, 12.8, 4.88 },
    { 10,  2, 48.91, +21, 56, 57.1, 5.66 },
    {  2, 38, 49.01, +21, 57, 41.0, 5.43 },
    { 18, 20, 17.90, +21, 57, 41.0, 4.95 },
    { 14, 40, 21.89, +21, 58, 32.2, 6.10 },
    {  7, 20,  7.39, +21, 58, 55.9, 3.53 },
    { 18, 45, 35.69, +21, 59,  6.0, 6.51 },
    {  9, 10, 20.90, +21, 59, 47.0, 6.01 },
    {  4,  5, 20.21, +22,  0, 32.0, 5.90 },
    { 21, 20, 13.99, +22,  1, 35.0, 6.29 },
    {  6, 39,  5.30, +22,  1, 50.9, 6.04 },
    {  3, 51, 36.60, +22,  1, 54.1, 6.83 },
    {  9,  9, 21.50, +22,  2, 44.2, 5.14 },
    { 15,  0, 52.39, +22,  2, 44.2, 6.38 },
    {  4,  4, 41.71, +22,  4, 54.8, 4.36 },
    { 17,  6, 18.10, +22,  5,  3.1, 5.56 },
    {  5, 19, 16.61, +22,  5, 47.0, 4.94 },
    { 21, 28, 59.90, +22, 10, 45.8, 5.93 },
    {  6,  9, 32.40, +22, 11, 24.0, 5.93 },
    { 16, 31, 13.39, +22, 11, 43.1, 5.76 },
    {  4, 25, 25.01, +22, 11, 58.9, 5.28 },
    { 11, 42,  5.21, +22, 12, 38.9, 6.59 },
    { 18,  6,  1.90, +22, 13,  8.0, 5.06 },
    {  3, 49, 55.01, +22, 14, 39.8, 6.07 },
    { 14, 32, 32.50, +22, 15, 36.0, 5.92 },
    { 19,  1, 49.49, +22, 15, 50.0, 6.40 },
    {  1, 50,  8.50, +22, 16, 31.1, 5.86 },
    {  0, 14, 56.11, +22, 17,  3.1, 6.24 },
    {  5, 15, 27.70, +22, 17,  4.9, 6.27 },
    {  4, 25, 22.10, +22, 17, 38.0, 4.22 },
    { 17, 50, 48.41, +22, 18, 59.0, 5.98 },
    { 20, 58, 16.39, +22, 19, 32.9, 5.31 },
    { 10, 56, 16.90, +22, 21,  6.1, 6.14 },
    {  7, 43, 22.20, +22, 23, 57.8, 6.21 },
    {  6,  1, 41.59, +22, 24,  2.9, 6.37 },
    {  4, 12, 51.19, +22, 24, 49.0, 6.12 },
    { 19, 41, 14.90, +22, 27, 10.1, 6.36 },
    { 21, 10, 31.99, +22, 27, 16.9, 6.68 },
    {  5, 30, 43.39, +22, 27, 45.0, 6.29 },
    { 17, 55, 50.81, +22, 27, 51.1, 5.58 },
    {  3, 56, 52.10, +22, 28, 41.2, 5.63 },
    { 13, 41,  2.30, +22, 29, 44.9, 5.62 },
    { 23, 33, 28.10, +22, 29, 56.0, 5.32 },
    {  6, 14, 52.61, +22, 30, 24.1, 3.28 },
    {  6, 22, 57.60, +22, 30, 49.0, 2.88 },
    { 19, 36,  8.30, +22, 35,  8.9, 6.32 },
    { 19, 51,  4.10, +22, 36, 36.0, 4.95 },
    { 13,  6, 22.61, +22, 36, 58.0, 5.60 },
    { 12, 34, 51.10, +22, 37, 45.1, 4.81 },
    { 17,  0, 58.10, +22, 37, 55.9, 5.65 },
    {  8,  6, 18.41, +22, 38,  8.2, 5.99 },
    {  7,  5, 18.41, +22, 38, 13.9, 6.02 },
    { 18, 54, 44.90, +22, 38, 42.0, 4.59 },
    { 23, 56, 41.50, +22, 38, 53.2, 6.15 },
    {  2,  6, 33.91, +22, 38, 53.9, 5.03 },
    { 12, 39,  2.09, +22, 39, 33.8, 6.38 },
    {  5, 42,  3.91, +22, 39, 37.1, 6.36 },
    { 13, 43, 45.19, +22, 42,  1.1, 6.13 },
    {  7,  7, 21.41, +22, 42, 13.0, 7.68 },
    { 21, 34, 34.01, +22, 45, 16.9, 6.47 },
    {  3, 28, 26.59, +22, 48, 15.1, 6.03 },
    { 16,  2, 17.69, +22, 48, 15.8, 4.83 },
    {  4, 26, 18.50, +22, 48, 49.0, 4.28 },
    { 18, 59, 58.10, +22, 48, 52.9, 6.29 },
    { 12, 50, 17.40, +22, 51, 47.9, 6.43 },
    {  7, 32, 50.59, +22, 53, 16.1, 6.54 },
    {  6, 12, 19.10, +22, 54, 29.9, 6.39 },
    { 18,  2, 30.10, +22, 55, 23.2, 6.21 },
    {  7, 23, 28.20, +22, 56, 43.1, 6.02 },
    { 21, 46,  4.39, +22, 56, 56.0, 5.29 },
    {  4, 42, 14.69, +22, 57, 24.8, 4.28 },
    { 17, 24,  6.60, +22, 57, 37.1, 5.74 },
    {  9, 31, 43.20, +22, 58,  5.2, 4.31 },
    {  9,  7, 26.90, +22, 58, 52.0, 6.40 },
    { 15, 13, 31.90, +22, 58, 59.9, 6.30 },
    {  4, 27, 17.50, +22, 59, 47.0, 5.53 },
    {  7, 40, 58.51, +23,  1,  7.0, 5.89 },
    { 19, 17, 43.61, +23,  1, 32.2, 5.43 },
    { 12, 19, 19.10, +23,  2,  4.9, 6.27 },
    { 23, 29,  5.59, +23,  2, 52.1, 6.35 },
    { 17, 17, 35.90, +23,  5, 26.9, 6.45 },
    { 11, 15, 12.19, +23,  5, 44.2, 4.63 },
    { 19, 59, 10.51, +23,  6,  5.0, 5.67 },
    { 10, 17, 14.59, +23,  6, 22.0, 5.82 },
    {  6,  9, 43.99, +23,  6, 47.9, 5.75 },
    {  8, 13, 41.71, +23,  8, 16.1, 6.56 },
    {  7, 48, 33.60, +23,  8, 28.0, 6.18 },
    {  2, 18, 58.01, +23, 10,  4.1, 6.46 },
    {  3, 57,  3.79, +23, 10, 32.2, 6.06 },
    { 10, 43, 25.01, +23, 11, 17.9, 5.08 },
    {  5, 43, 19.51, +23, 12, 15.1, 6.21 },
    { 20,  4, 58.61, +23, 12, 37.1, 6.45 },
    { 14, 36,  6.89, +23, 15,  1.1, 6.38 },
    {  6,  4,  7.20, +23, 15, 47.9, 4.16 },
    { 18, 22,  8.71, +23, 17,  7.1, 5.41 },
    { 18, 18,  7.70, +23, 17, 48.1, 6.63 },
    { 11,  7, 39.70, +23, 19, 25.0, 6.46 },
    {  5, 41, 54.60, +23, 19, 35.0, 6.59 },
    {  6, 25, 32.90, +23, 19, 36.8, 6.06 },
    {  4, 36, 29.21, +23, 20, 26.9, 6.02 },
    { 21, 32, 27.10, +23, 23, 39.8, 6.70 },
    { 23, 25, 22.80, +23, 24, 15.1, 4.40 },
    { 10, 16, 41.40, +23, 25,  1.9, 3.44 },
    {  0, 57, 12.41, +23, 25,  3.0, 4.42 },
    {  3, 48, 20.90, +23, 25, 16.0, 5.45 },
    {  9, 33, 59.09, +23, 27, 14.0, 6.25 },
    {  2,  7, 10.39, +23, 27, 45.0, 2.00 },
    {  2, 29, 13.61, +23, 28,  8.0, 6.19 },
    { 16, 11, 37.99, +23, 29, 40.9, 5.70 },
    { 10, 16, 32.30, +23, 30, 11.2, 5.97 },
    { 20, 15, 30.19, +23, 30, 31.0, 5.15 },
    {  1, 25, 35.71, +23, 30, 42.1, 6.18 },
    { 18, 48, 16.39, +23, 30, 51.1, 6.15 },
    { 22, 46, 31.90, +23, 33, 56.2, 3.95 },
    {  1, 55, 51.00, +23, 34, 37.9, 5.74 },
    {  8,  1,   .70, +23, 34, 59.2, 6.34 },
    { 18, 44, 40.20, +23, 35, 22.9, 6.31 },
    {  1, 57, 55.70, +23, 35, 46.0, 4.79 },
    {  6, 52,   .00, +23, 36,  6.1, 5.65 },
    { 18, 35, 30.41, +23, 36, 20.2, 5.61 },
    { 20,  6, 53.40, +23, 36, 51.8, 5.07 },
    { 18, 32, 46.20, +23, 37,   .8, 5.84 },
    {  4, 45, 42.50, +23, 37, 41.2, 6.35 },
    {  0, 54, 58.01, +23, 37, 41.9, 5.47 },
    { 21, 29, 56.90, +23, 38, 20.0, 4.57 },
    { 20, 38, 35.09, +23, 40, 50.2, 5.91 },
    {  3, 49, 43.51, +23, 42, 42.1, 6.17 },
    { 19, 40, 39.70, +23, 43,  3.0, 6.64 },
    { 23, 20, 38.21, +23, 44, 25.1, 4.60 },
    {  6, 16, 58.70, +23, 44, 26.9, 6.25 },
    { 17, 15, 41.59, +23, 44, 34.1, 5.96 },
    {  2, 17, 10.39, +23, 46,  4.1, 6.55 },
    {  9, 45, 51.10, +23, 46, 27.1, 2.98 },
    { 13, 25,  6.70, +23, 51, 15.8, 5.78 },
    { 21, 21,  4.39, +23, 51, 20.9, 5.57 },
    { 18, 29, 35.69, +23, 51, 58.0, 5.90 },
    { 14, 50, 15.79, +23, 54, 42.8, 5.85 },
    { 12, 25, 15.10, +23, 55, 34.0, 6.03 },
    { 18,  4, 40.20, +23, 56, 33.0, 6.34 },
    { 12, 16, 20.50, +23, 56, 43.1, 4.95 },
    {  3, 46, 19.61, +23, 56, 53.9, 4.18 },
    {  4, 57, 48.70, +23, 56, 55.0, 5.79 },
    {  6, 16, 19.01, +23, 58, 12.0, 6.08 },
    { 17, 57, 14.30, +23, 59, 44.9, 6.30 },
    {  0, 37,  7.20, +24,  0, 51.1, 6.47 },
    {  8, 20, 32.11, +24,  1, 19.9, 5.98 },
    {  5, 35, 27.10, +24,  2, 21.8, 5.38 },
    {  3, 49,  9.70, +24,  3, 11.9, 3.63 },
    { 19, 53, 27.70, +24,  4, 46.9, 4.58 },
    {  8, 31, 30.50, +24,  4, 52.0, 5.75 },
    {  8, 33,   .10, +24,  5,  4.9, 6.36 },
    {  4, 43, 13.80, +24,  5, 20.0, 6.13 },
    { 23, 14, 36.50, +24,  6, 11.2, 6.36 },
    {  3, 47, 29.11, +24,  6, 18.0, 2.87 },
    {  4,  4, 21.70, +24,  6, 20.9, 5.47 },
    { 12, 29, 26.90, +24,  6, 32.0, 5.48 },
    {  3, 44, 52.51, +24,  6, 47.9, 3.70 },
    { 20, 38, 31.90, +24,  6, 58.0, 5.04 },
    {  7, 12, 26.40, +24,  7, 41.9, 5.85 },
    {  3, 49, 11.21, +24,  8, 12.1, 5.09 },
    {  8, 28, 36.79, +24,  8, 40.9, 6.10 },
    {  2, 12, 37.49, +24, 10,  4.1, 5.96 },
    {  7,  2, 24.79, +24, 12, 55.1, 5.18 },
    {  7, 39, 11.90, +24, 13, 21.0, 6.17 },
    { 17, 11,  3.19, +24, 14, 16.1, 6.19 },
    { 20, 13, 40.61, +24, 14, 20.0, 6.56 },
    {  5, 56, 56.09, +24, 14, 58.9, 6.02 },
    { 19,  6, 38.40, +24, 15,  2.9, 5.77 },
    { 13, 12,  8.40, +24, 15, 29.2, 6.33 },
    {  5,  8,  6.60, +24, 15, 55.1, 5.50 },
    {  0, 47, 20.30, +24, 16,  1.9, 4.06 },
    { 21, 23, 58.80, +24, 16, 27.1, 5.71 },
    { 12, 33, 34.20, +24, 16, 59.2, 6.29 },
    {  3, 44, 48.19, +24, 17, 21.8, 5.46 },
    {  4, 23, 59.81, +24, 18,  4.0, 6.36 },
    { 17, 37, 31.10, +24, 18, 36.0, 5.77 },
    { 19, 54, 31.10, +24, 19,  9.8, 5.52 },
    { 17, 43, 21.60, +24, 19, 40.1, 5.71 },
    { 13, 32, 48.10, +24, 20, 47.0, 6.11 },
    {  7, 38, 14.50, +24, 21, 37.1, 6.27 },
    { 14, 48, 23.30, +24, 22,   .1, 6.14 },
    {  3, 45, 49.61, +24, 22,  4.1, 3.87 },
    { 16, 57, 42.31, +24, 22, 53.0, 6.32 },
    {  9, 51, 52.99, +24, 23, 43.1, 5.32 },
    {  7, 44, 26.81, +24, 23, 53.2, 3.57 },
    {  6, 11, 32.30, +24, 25, 13.1, 5.80 },
    { 20, 22,  3.41, +24, 26, 46.0, 5.54 },
    { 18, 19, 10.70, +24, 26, 46.0, 5.27 },
    { 21, 35, 27.00, +24, 27,  7.9, 6.11 },
    {  9,  2, 44.30, +24, 27, 10.1, 5.45 },
    {  3, 57, 26.40, +24, 27, 42.8, 6.16 },
    {  3, 34, 26.59, +24, 27, 51.8, 5.92 },
    {  3, 45, 12.50, +24, 28,  1.9, 4.30 },
    { 17, 20, 54.19, +24, 29, 57.8, 5.12 },
    { 17, 41,  5.50, +24, 30, 47.9, 6.36 },
    {  3, 46,  2.90, +24, 31, 41.2, 6.43 },
    { 21, 24, 23.11, +24, 31, 44.0, 6.32 },
    {  8, 26, 39.79, +24, 32,  3.1, 7.02 },
    {  8, 26, 40.10, +24, 32,  7.1, 7.81 },
    {  3, 45, 54.41, +24, 33, 16.9, 5.76 },
    {  0, 55, 14.69, +24, 33, 24.8, 6.20 },
    { 23, 35, 55.90, +24, 33, 40.0, 6.45 },
    { 17, 42, 28.39, +24, 33, 51.1, 5.52 },
    { 12, 31,   .60, +24, 34,  1.9, 5.46 },
    {  5, 49,  1.01, +24, 34,  3.0, 4.86 },
    {  1, 13, 44.90, +24, 35,  1.0, 4.65 },
    {  6, 37, 27.19, +24, 35, 26.9, 6.44 },
    {  4, 56, 15.60, +24, 35, 31.9, 6.37 },
    {  6, 39, 31.39, +24, 36,   .0, 6.38 },
    { 22, 50,   .19, +24, 36,  6.1, 3.48 },
    { 13, 36, 59.09, +24, 36, 47.9, 5.74 },
    {  0, 41, 36.00, +24, 37, 45.1, 6.04 },
    {  2, 37,   .50, +24, 38, 51.0, 6.50 },
    {  2, 36, 57.70, +24, 38, 53.9, 7.09 },
    { 16, 51, 45.31, +24, 39, 23.0, 5.04 },
    { 11,  8, 49.10, +24, 39, 29.9, 5.68 },
    { 19, 28, 42.29, +24, 39, 54.0, 4.44 },
    { 20, 16, 47.11, +24, 40, 16.0, 5.32 },
    {  7, 14, 26.59, +24, 42, 38.9, 6.89 },
    { 10, 19,   .70, +24, 42, 42.1, 6.40 },
    {  3, 24, 18.50, +24, 43, 27.1, 5.50 },
    { 10, 55, 37.30, +24, 44, 56.0, 6.30 },
    { 10, 55, 36.79, +24, 44, 58.9, 4.50 },
    { 19, 28, 57.00, +24, 46,  7.0, 5.81 },
    { 23, 15, 57.89, +24, 46, 16.0, 6.60 },
    { 12, 22, 10.80, +24, 46, 26.0, 6.19 },
    { 20,  1, 44.69, +24, 48,  1.1, 5.88 },
    { 17, 15,  1.90, +24, 50, 21.1, 3.14 },
    {  3, 45,  9.70, +24, 50, 21.1, 5.64 },
    { 12, 48, 46.99, +24, 50, 25.1, 6.31 },
    { 16, 41,   .60, +24, 51, 31.0, 6.06 },
    { 15,  7, 18.10, +24, 52,  9.1, 4.93 },
    {  7, 14, 41.90, +24, 53,  6.0, 5.82 },
    { 19, 25, 25.80, +24, 54, 46.1, 6.19 },
    { 20,  2,  1.39, +24, 56, 17.2, 5.22 },
    { 22, 12,  7.99, +24, 57,   .0, 5.92 },
    { 15, 21,  6.89, +24, 57, 28.1, 6.39 },
    { 19, 52,  1.61, +24, 59, 31.9, 5.57 },
    { 15,  2,  6.50, +25,  0, 29.2, 4.81 },
    { 19,  1, 34.90, +25,  1, 32.9, 6.72 },
    {  2, 15, 42.79, +25,  2, 35.2, 5.58 },
    { 18, 49, 14.40, +25,  2, 47.0, 6.59 },
    {  4, 58,  9.41, +25,  3,  1.1, 5.81 },
    {  7, 23, 28.51, +25,  3,  2.2, 5.03 },
    {  8,  1, 43.80, +25,  5, 22.9, 6.31 },
    { 14, 10, 23.90, +25,  5, 30.1, 4.83 },
    { 15, 27, 38.90, +25,  6,  6.1, 6.02 },
    { 15,  8, 35.50, +25,  6, 31.0, 5.81 },
    {  6, 43, 55.90, +25,  7, 52.0, 2.98 },
    { 19, 46, 39.50, +25,  8,  2.0, 6.62 },
    { 23, 57, 45.50, +25,  8, 29.0, 4.66 },
    {  5, 29, 16.49, +25,  9,  2.2, 5.47 },
    { 23, 27, 40.39, +25, 10,  1.9, 5.98 },
    {  9, 23, 31.80, +25, 10, 59.2, 6.41 },
    {  2, 48, 45.89, +25, 11, 17.2, 5.86 },
    {  4, 39, 23.11, +25, 13,  5.9, 6.22 },
    { 11, 44, 13.20, +25, 13,  5.9, 6.02 },
    {  2, 30, 32.40, +25, 14,  6.0, 5.92 },
    {  3,  5, 26.71, +25, 15, 19.1, 7.00 },
    {  3,  5, 26.71, +25, 15, 19.1, 6.80 },
    { 20, 44, 52.51, +25, 16, 14.2, 4.91 },
    { 21, 24,  7.39, +25, 18, 43.9, 6.15 },
    {  3, 40, 46.30, +25, 19, 45.8, 6.11 },
    { 14, 23,  6.79, +25, 20, 17.2, 6.22 },
    { 22,  7,   .70, +25, 20, 42.0, 3.76 },
    { 16, 57, 31.01, +25, 21, 10.1, 6.28 },
    { 10, 16, 41.90, +25, 22, 17.0, 5.84 },
    {  6, 55, 18.60, +25, 22, 32.2, 5.73 },
    { 19, 47, 48.60, +25, 23,  2.0, 5.95 },
    {  8,  0, 55.90, +25, 23, 34.1, 5.83 },
    {  1, 10, 19.39, +25, 27, 28.1, 5.80 },
    {  0,  8, 52.20, +25, 27, 46.1, 6.23 },
    { 23,  7,  6.79, +25, 28,  5.9, 4.76 },
    { 10, 54, 42.19, +25, 29, 26.9, 6.20 },
    { 21, 38, 45.00, +25, 29, 56.0, 6.16 },
    { 10, 56, 34.39, +25, 30,   .0, 6.35 },
    { 17,  2, 18.70, +25, 30, 20.2, 5.75 },
    {  8, 10, 27.19, +25, 30, 25.9, 5.73 },
    { 17, 20,  9.79, +25, 32, 15.0, 5.38 },
    { 22,  8, 17.21, +25, 32, 37.0, 6.11 },
    { 21, 46, 24.00, +25, 33, 47.9, 6.28 },
    {  3, 50, 18.91, +25, 34, 45.8, 5.26 },
    { 12, 24, 26.71, +25, 34, 58.1, 6.42 },
    { 20, 15, 15.91, +25, 35, 30.8, 4.78 },
    { 17, 48, 49.20, +25, 37, 22.1, 5.12 },
    {  4, 22, 34.90, +25, 37, 45.1, 5.37 },
    {  2, 43, 51.19, +25, 38, 17.2, 6.35 },
    { 21, 44, 38.71, +25, 38, 42.0, 4.13 },
    {  3, 20, 25.61, +25, 39, 46.1, 6.12 },
    { 13, 46, 43.30, +25, 42,  7.9, 5.95 },
    {  2,  6, 49.20, +25, 42, 16.9, 6.15 },
    { 16, 55,  2.09, +25, 43, 50.2, 6.08 },
    {  1, 41, 18.41, +25, 44, 44.9, 6.17 },
    { 19, 43, 42.89, +25, 46, 18.8, 5.49 },
    {  2, 15, 46.01, +25, 46, 59.2, 5.79 },
    {  7, 44,  6.89, +25, 47,  3.1, 5.31 },
    { 20, 31, 58.20, +25, 48, 15.8, 6.34 },
    { 12, 22, 30.31, +25, 50, 46.0, 4.81 },
    { 12, 11, 51.19, +25, 52, 13.1, 5.66 },
    { 20, 36,  8.30, +25, 52, 57.0, 6.41 },
    {  5, 39, 44.21, +25, 53, 48.8, 5.18 },
    { 12, 28, 44.59, +25, 53, 57.1, 6.65 },
    {  9, 41, 38.50, +25, 54, 46.1, 6.24 },
    { 12, 28, 54.70, +25, 54, 46.1, 5.29 },
    {  6, 59, 27.89, +25, 54, 51.1, 6.40 },
    { 15, 59, 30.19, +25, 55, 13.1, 2.00 },
    { 21, 53,  3.79, +25, 55, 30.0, 5.08 },
    {  2,  3, 39.29, +25, 56,  8.2, 5.63 },
    {  2, 11, 12.00, +25, 56, 12.8, 6.02 },
    {  5, 36, 30.19, +25, 56, 21.8, 6.49 },
    {  2,  9, 25.30, +25, 56, 22.9, 4.98 },
    {  5, 57, 59.69, +25, 57, 14.0, 4.82 },
    { 23, 55, 22.99, +25, 57, 18.0, 6.54 },
    { 12, 20, 17.69, +26,  0,  6.8, 6.15 },
    {  9, 52, 45.79, +26,  0, 24.8, 3.88 },
    { 12, 19,  2.09, +26,  0, 28.1, 6.48 },
    { 17, 55, 25.20, +26,  3,   .0, 5.46 },
    { 15, 49, 35.69, +26,  4,  5.9, 4.63 },
    {  6, 58, 47.40, +26,  4, 52.0, 6.10 },
    { 18,  7, 49.49, +26,  5, 51.0, 5.90 },
    { 12, 24, 18.50, +26,  5, 55.0, 5.18 },
    { 18,  7, 49.49, +26,  6,  5.0, 5.86 },
    { 17, 30, 44.30, +26,  6, 38.2, 4.41 },
    { 21, 24, 34.01, +26, 10, 27.8, 5.68 },
    {  9, 24, 39.31, +26, 10, 55.9, 4.46 },
    { 12, 28, 38.11, +26, 13, 36.1, 6.54 },
    { 18, 59, 45.50, +26, 13, 50.2, 5.27 },
    { 19, 22, 50.90, +26, 15, 45.0, 5.18 },
    { 19,  1, 17.40, +26, 17, 29.0, 5.69 },
    { 15, 42, 44.59, +26, 17, 44.2, 3.84 },
    { 15,  8, 23.81, +26, 18,  4.0, 5.67 },
    { 10, 43,  1.80, +26, 19, 32.2, 5.51 },
    { 18, 26, 40.90, +26, 26, 57.8, 6.53 },
    { 20, 37,  4.70, +26, 27, 42.8, 5.59 },
    {  3,  1, 54.10, +26, 27, 43.9, 5.90 },
    { 20, 12,   .70, +26, 28, 44.0, 5.92 },
    {  4, 10, 49.90, +26, 28, 50.9, 5.41 },
    { 14, 43, 25.39, +26, 31, 40.1, 4.81 },
    { 23, 21, 58.20, +26, 36, 32.0, 6.62 },
    { 19, 31, 21.79, +26, 37,  1.9, 5.87 },
    {  5, 38, 57.41, +26, 37,  4.1, 6.37 },
    { 12, 20, 19.70, +26, 37,  9.8, 5.54 },
    {  9,  8, 47.30, +26, 37, 45.1, 5.98 },
    {  0,  4, 55.99, +26, 38, 56.0, 6.25 },
    { 18, 46,  4.49, +26, 39, 43.9, 4.83 },
    { 16, 12, 45.31, +26, 40, 14.9, 6.50 },
    { 22,  5, 11.40, +26, 40, 26.0, 5.78 },
    { 14, 32, 20.21, +26, 40, 37.9, 6.01 },
    { 15, 34, 41.30, +26, 42, 52.9, 2.23 },
    { 19, 11, 30.91, +26, 44,  8.9, 6.36 },
    { 22, 29, 10.20, +26, 45, 47.2, 5.79 },
    {  7, 53, 29.81, +26, 45, 56.9, 4.97 },
    { 20, 11, 48.00, +26, 48, 32.0, 5.49 },
    { 12, 26, 59.30, +26, 49, 32.2, 5.00 },
    { 23, 11, 49.20, +26, 50, 49.9, 6.17 },
    {  7, 11, 23.11, +26, 51, 24.1, 5.78 },
    { 15, 57, 35.30, +26, 52, 40.1, 4.15 },
    { 17, 26,   .91, +26, 52, 44.0, 6.41 },
    {  7, 35, 55.30, +26, 53, 44.9, 4.06 },
    {  3, 10, 27.00, +26, 53, 47.0, 6.02 },
    { 20, 10, 33.50, +26, 54, 15.1, 5.52 },
    { 16, 41, 36.70, +26, 55,   .8, 5.92 },
    {  0,  0, 23.90, +26, 55,  5.9, 6.46 },
    {  5, 37,  8.81, +26, 55, 27.1, 5.83 },
    { 21,  6, 23.50, +26, 55, 27.8, 6.12 },
    {  8, 26, 46.80, +26, 56,  3.8, 6.32 },
    { 22, 21,   .10, +26, 56,  7.1, 6.47 },
    {  8, 26, 46.99, +26, 56,  7.1, 6.30 },
    {  4, 38, 29.59, +26, 56, 24.0, 6.47 },
    { 15,  4, 26.71, +26, 56, 51.0, 4.54 },
    {  6, 28, 56.59, +26, 58,  4.1, 6.47 },
    {  0, 13, 24.00, +26, 59, 13.9, 6.30 },
    {  2, 27,  7.01, +27,  0, 47.9, 6.18 },
    { 12, 20, 41.30, +27,  3, 16.9, 7.13 },
    {  2, 40, 41.09, +27,  3, 38.9, 5.30 },
    {  3, 19, 55.80, +27,  4, 16.0, 5.90 },
    { 14, 44, 59.21, +27,  4, 27.1, 2.70 },
    { 14, 44, 59.21, +27,  4, 30.0, 5.12 },
    {  0,  2, 10.20, +27,  4, 54.8, 5.75 },
    { 20, 52,  7.70, +27,  5, 48.8, 4.59 },
    { 19, 43, 55.90, +27,  8,  8.2, 6.28 },
    { 10, 13, 49.80, +27,  8,  8.9, 6.04 },
    { 17,  1,  9.60, +27, 11, 47.0, 6.55 },
    {  0, 55, 58.49, +27, 12, 33.8, 6.09 },
    {  8, 20,  3.91, +27, 13,  4.1, 5.14 },
    {  7, 12, 49.01, +27, 13, 28.9, 6.43 },
    {  0, 36, 19.99, +27, 15, 16.9, 6.50 },
    {  3, 12, 14.21, +27, 15, 24.8, 5.79 },
    {  2, 49, 58.99, +27, 15, 38.2, 3.63 },
    {  1, 19, 28.01, +27, 15, 51.1, 4.76 },
    { 12, 26, 24.10, +27, 16,  5.9, 4.95 },
    { 12, 10, 46.10, +27, 16, 53.0, 6.01 },
    {  0, 15, 10.61, +27, 16, 59.2, 6.35 },
    { 19, 47, 37.90, +27, 18, 40.0,      },
    {  4, 20, 21.31, +27, 21,  2.9, 4.95 },
    { 14,  1, 10.49, +27, 23, 12.1, 6.23 },
    { 18, 24, 58.49, +27, 23, 43.1, 6.27 },
    { 10, 18, 10.30, +27, 24, 55.1, 6.52 },
    { 16, 15, 47.40, +27, 25, 19.9, 6.14 },
    { 19, 15, 57.00, +27, 27, 20.2, 6.54 },
    { 13, 56, 34.20, +27, 29, 30.8, 5.01 },
    {  8,  5, 37.01, +27, 31, 46.9, 6.21 },
    { 12, 51, 41.90, +27, 32, 26.2, 4.94 },
    { 12, 49, 17.40, +27, 33,  7.9, 5.78 },
    { 13,  7, 53.59, +27, 33, 20.9, 6.19 },
    {  3, 31, 20.81, +27, 34, 18.8, 5.96 },
    {  6,  1,   .41, +27, 34, 19.9, 6.05 },
    {  0, 32, 34.51, +27, 34, 50.2, 6.67 },
    {  4,  6, 36.41, +27, 36,   .0, 5.20 },
    {  3, 22, 11.90, +27, 36, 27.0, 5.52 },
    { 21, 27, 40.10, +27, 36, 31.0, 5.41 },
    {  5, 53, 19.61, +27, 36, 43.9, 4.58 },
    { 13,  7, 10.70, +27, 37, 28.9, 4.80 },
    {  7, 24, 33.41, +27, 38, 17.2, 5.76 },
    {  5, 35, 55.49, +27, 39, 43.9, 6.27 },
    {  5,  4, 37.90, +27, 41, 46.0, 6.60 },
    {  2, 43, 27.10, +27, 42, 25.9, 4.66 },
    {  0, 49, 53.21, +27, 42, 37.1, 7.10 },
    {  0, 49, 52.80, +27, 42, 38.9, 7.00 },
    { 17, 46, 27.50, +27, 43, 14.2, 3.42 },
    { 20,  1,  6.10, +27, 45, 13.0, 4.64 },
    {  9, 58, 26.09, +27, 45, 32.0, 6.30 },
    { 11, 36, 17.90, +27, 46, 52.0, 5.80 },
    {  8,  3, 31.10, +27, 47, 39.1, 4.94 },
    {  7, 25, 43.61, +27, 47, 53.2, 3.79 },
    { 22, 16, 29.69, +27, 48, 15.1, 6.37 },
    {  1, 57, 43.80, +27, 48, 15.8, 5.82 },
    { 20, 15, 46.10, +27, 48, 51.1, 4.52 },
    {  3, 10,  8.81, +27, 49, 12.0, 6.42 },
    { 13, 11, 52.39, +27, 52, 41.2, 4.26 },
    {  8, 26, 27.70, +27, 53, 37.0, 5.57 },
    {  4, 52, 47.11, +27, 53, 51.0, 5.97 },
    {  7, 15, 57.10, +27, 53, 51.0, 5.71 },
    {  9,  4,  9.89, +27, 53, 53.9, 6.38 },
    {  9,  1, 48.91, +27, 54, 10.1, 6.07 },
    { 18, 54, 13.20, +27, 54, 33.8, 5.62 },
    {  7, 29, 48.70, +27, 54, 58.0, 5.01 },
    { 19, 15, 59.40, +27, 55, 36.8, 6.16 },
    {  8, 55, 39.70, +27, 55, 39.0, 5.22 },
    {  5, 20, 59.30, +27, 57, 25.9, 6.33 },
    { 19, 30, 43.30, +27, 57, 34.9, 3.08 },
    { 19, 30, 45.31, +27, 57, 55.1, 5.11 },
    {  5, 50, 58.10, +27, 58,  4.1, 5.56 },
    { 10, 49, 53.71, +27, 58, 26.0, 6.04 },
    {  6, 35, 12.10, +28,  1, 19.9, 5.27 },
    {  7, 45, 18.91, +28,  1, 34.0, 1.14 },
    {  5,  9, 45.10, +28,  1, 50.2, 6.01 },
    { 20, 54, 33.60, +28,  3, 27.0, 5.01 },
    { 13, 40, 39.10, +28,  3, 55.1, 6.23 },
    { 23,  3, 46.51, +28,  4, 58.1, 2.42 },
    { 19, 24, 22.39, +28,  5, 16.1, 6.53 },
    {  7, 29, 20.40, +28,  7,  5.2, 5.05 },
    { 15, 48, 34.39, +28,  9, 24.1, 5.85 },
    { 12, 19, 29.59, +28,  9, 24.8, 6.33 },
    {  7,  7, 25.01, +28, 10, 37.9, 6.48 },
    { 17, 36,  7.90, +28, 11,  4.9, 6.38 },
    {  6, 41, 21.00, +28, 11, 47.0, 6.42 },
    { 21, 35, 19.01, +28, 11, 49.9, 6.31 },
    { 23, 15, 46.30, +28, 14, 52.1, 6.49 },
    { 20, 51, 28.20, +28, 15,  2.2, 5.77 },
    {  8, 52, 28.61, +28, 15, 33.1, 6.23 },
    {  6, 39, 33.10, +28, 15, 47.2, 6.03 },
    { 12, 26, 56.30, +28, 16,  5.9, 4.36 },
    {  3,  3, 30.31, +28, 16, 10.9, 6.36 },
    {  0, 32, 49.10, +28, 16, 49.1, 6.30 },
    { 14, 28, 31.51, +28, 17, 21.1, 7.62 },
    { 14, 28, 33.29, +28, 17, 26.9, 7.12 },
    { 22, 21, 19.30, +28, 19, 50.2, 4.81 },
    {  8, 52, 35.81, +28, 19, 50.9, 5.95 },
    {  9, 33, 18.29, +28, 22,  5.2, 6.53 },
    { 23, 31, 43.10, +28, 24, 13.0, 6.41 },
    { 17, 31, 49.61, +28, 24, 27.0, 5.62 },
    { 19, 49, 54.60, +28, 26, 26.2, 6.38 },
    { 20, 54, 22.39, +28, 31, 18.8, 6.56 },
    {  1, 14,  4.99, +28, 31, 46.9, 6.43 },
    { 12, 12,  1.20, +28, 32, 10.0, 6.49 },
    {  5, 26, 17.50, +28, 36, 27.0, 1.65 },
    { 22, 13, 38.59, +28, 36, 29.9, 5.89 },
    {  4, 41, 19.80, +28, 36, 54.0, 5.78 },
    { 14, 49, 58.39, +28, 36, 56.9, 5.80 },
    { 19,  6, 37.70, +28, 37, 43.0, 5.55 },
    {  2, 18, 57.00, +28, 38, 33.0, 5.03 },
    { 13, 53, 10.30, +28, 38, 53.2, 5.90 },
    { 10, 16, 28.10, +28, 40, 57.0, 6.49 },
    { 20, 14, 14.50, +28, 41, 40.9, 5.18 },
    {  1, 21,  7.39, +28, 44, 17.2, 5.23 },
    { 21, 44,  8.59, +28, 44, 34.1, 4.73 },
    { 21, 44,  8.30, +28, 44, 35.2, 6.08 },
    { 17, 21, 31.20, +28, 45, 29.2, 6.35 },
    {  8, 46, 41.81, +28, 45, 36.0, 4.02 },
    { 18,  7, 32.59, +28, 45, 45.0, 3.83 },
    {  8, 46, 40.01, +28, 45, 55.1, 6.57 },
    { 18, 51, 35.90, +28, 47,  1.0, 6.18 },
    { 21, 52, 29.90, +28, 47, 35.9, 5.53 },
    { 17, 18, 48.50, +28, 49, 23.2, 5.65 },
    { 23, 49, 39.41, +28, 50, 33.0, 5.97 },
    { 18, 21,  1.01, +28, 52, 12.0, 5.12 },
    {  7, 43, 18.70, +28, 53,  1.0, 4.28 },
    {  5, 23, 22.90, +28, 56, 12.1, 6.46 },
    { 12, 17, 30.50, +28, 56, 13.9, 5.70 },
    {  5, 56, 33.79, +28, 56, 31.9, 6.32 },
    {  4, 34, 37.99, +28, 57, 40.0, 5.88 },
    { 22,  5, 34.70, +28, 57, 50.0, 5.70 },
    {  6, 44, 45.50, +28, 58, 14.9, 5.44 },
    {  6, 38, 22.99, +28, 59,  3.1, 5.79 },
    {  0, 57, 50.21, +28, 59, 31.9, 5.42 },
    {  4,  7,   .50, +29,  0,  5.0, 5.23 },
    {  0,  6, 36.79, +29,  1, 17.0, 6.13 },
    { 13,  6, 10.20, +29,  1, 45.8, 6.54 },
    {  3, 20, 20.40, +29,  2, 53.9, 4.47 },
    {  3,  9, 36.70, +29,  4, 36.8, 5.72 },
    {  0,  8, 23.30, +29,  5, 26.2, 2.06 },
    { 15, 27, 49.70, +29,  6, 20.9, 3.68 },
    { 20, 17, 31.51, +29,  8, 53.2, 6.22 },
    { 16, 16, 44.81, +29,  9,  1.1, 5.78 },
    { 15, 14, 29.21, +29,  9, 51.1, 5.26 },
    {  5, 29, 40.61, +29, 11, 11.0, 6.24 },
    { 18, 14, 43.99, +29, 12, 25.9, 6.56 },
    {  5, 39, 18.41, +29, 12, 55.1, 5.96 },
    {  2, 47, 54.50, +29, 14, 49.9, 4.51 },
    { 17, 57, 45.91, +29, 14, 52.1, 3.70 },
    { 19, 44, 48.70, +29, 15, 52.9, 6.82 },
    { 22, 41, 45.41, +29, 18, 27.0, 4.79 },
    { 10, 16, 14.40, +29, 18, 38.2, 5.35 },
    {  0, 38, 33.31, +29, 18, 42.1, 4.37 },
    { 17, 50, 22.90, +29, 19, 19.9, 5.50 },
    { 19, 42, 49.10, +29, 19, 54.1, 6.49 },
    { 19, 37,  9.41, +29, 20,  1.0, 6.43 },
    {  7,  3, 30.41, +29, 20, 13.9, 5.93 },
    { 23, 43, 59.50, +29, 21, 42.1, 4.93 },
    { 10, 48, 57.19, +29, 24, 56.9, 6.15 },
    { 23, 13,  4.01, +29, 26, 30.1, 6.35 },
    { 19, 34, 50.90, +29, 27, 47.2, 5.38 },
    {  5, 41, 21.00, +29, 29, 15.0, 6.43 },
    {  6, 15, 22.70, +29, 29, 53.2, 4.35 },
    {  6,  6, 22.51, +29, 30, 45.0, 6.08 },
    {  6, 21, 12.10, +29, 32, 28.0, 6.43 },
    { 22, 31, 34.20, +29, 32, 34.1, 6.35 },
    {  5, 21, 12.70, +29, 34, 12.0, 5.76 },
    {  1, 53,  4.90, +29, 34, 44.0, 3.41 },
    { 10, 23, 41.81, +29, 36, 56.9, 6.39 },
    { 15, 20,  8.50, +29, 36, 58.0, 5.51 },
    { 19, 24,  7.61, +29, 37, 17.0, 4.97 },
    {  9, 59, 36.19, +29, 38, 43.1, 5.73 },
    { 20, 53,  7.39, +29, 38, 57.8, 6.34 },
    {  9,  8,   .10, +29, 39, 15.1, 5.43 },
    {  8, 13,  8.90, +29, 39, 24.1, 5.64 },
    {  1,  4, 27.60, +29, 39, 31.0, 6.19 },
    { 18, 19, 52.10, +29, 39, 58.0, 5.99 },
    {  2, 28, 10.01, +29, 40,  9.8, 5.29 },
    {  6, 24, 52.61, +29, 42, 25.9, 6.71 },
    { 14, 34, 40.80, +29, 44, 42.0, 4.46 },
    {  0, 30,  7.30, +29, 45,  6.1, 5.23 },
    { 23, 14, 21.70, +29, 46, 18.1, 6.41 },
    { 20, 40, 36.19, +29, 48, 19.1, 6.08 },
    { 16, 50, 39.00, +29, 48, 24.1, 5.72 },
    { 18, 25, 58.80, +29, 49, 44.0, 5.83 },
    { 16,  1, 26.59, +29, 51,  4.0, 4.99 },
    { 18, 20, 57.10, +29, 51, 32.0, 5.63 },
    { 20,  3, 37.39, +29, 53, 48.1, 5.71 },
    { 21, 14, 10.30, +29, 54,  4.0, 6.17 },
    { 19,  5, 47.11, +29, 55, 18.1, 6.31 },
    {  2, 28, 48.50, +29, 55, 54.8, 5.89 },
    {  6, 44, 12.10, +29, 56, 42.0,      },
    {  9, 43, 33.29, +29, 58, 27.8, 5.64 },
    { 15, 36, 53.40, +29, 59, 28.0, 6.52 },
    {  1, 41, 39.19, +30,  2, 49.9, 5.99 },
    { 21, 36, 13.90, +30,  3, 20.2, 6.36 },
    {  1, 12, 59.50, +30,  3, 51.1, 6.19 },
    {  1, 11, 39.60, +30,  5, 22.9, 4.51 },
    { 19, 39, 22.61, +30,  9, 11.9, 4.69 },
    { 21, 49, 50.69, +30, 10, 27.1, 5.04 },
    {  2, 20,  4.39, +30, 11, 17.9, 6.47 },
    { 17, 58, 30.19, +30, 11, 21.8, 4.41 },
    { 19, 55,  6.50, +30, 11, 43.1, 6.57 },
    { 21,  8, 38.90, +30, 12, 20.9, 5.59 },
    {  5, 27,  8.30, +30, 12, 31.0, 5.74 },
    { 22, 43,   .10, +30, 13, 17.0, 2.94 },
    { 21, 12, 56.21, +30, 13, 36.8, 3.20 },
    {  8, 57, 58.70, +30, 14,  1.0, 6.29 },
    {  7, 11,  8.40, +30, 14, 43.1, 4.41 },
    { 12, 18, 31.61, +30, 14, 57.1, 6.23 },
    { 15, 23, 12.31, +30, 17, 16.1, 6.08 },
    { 15, 23, 12.31, +30, 17, 16.1, 5.58 },
    {  2, 12, 22.30, +30, 18, 11.2, 4.94 },
    { 21, 22, 41.90, +30, 18, 34.9, 6.05 },
    { 20, 38, 59.50, +30, 20,  3.8, 5.68 },
    {  4, 28, 51.89, +30, 21, 41.0, 6.40 },
    { 20, 29, 23.71, +30, 22,  7.0, 4.01 },
    { 14, 31, 49.80, +30, 22, 17.0, 3.58 },
    { 23, 20, 49.61, +30, 24, 54.0, 5.59 },
    { 14, 20,  8.71, +30, 25, 45.1, 6.44 },
    {  5, 31, 59.10, +30, 26, 45.0,      },
    { 18,  9, 10.20, +30, 28,  9.8, 6.38 },
    {  5, 38, 38.11, +30, 29, 33.0, 5.40 },
    {  6, 28, 34.10, +30, 29, 35.2, 5.55 },
    {  5,  4, 14.50, +30, 29, 40.9, 6.14 },
    { 19, 15, 24.79, +30, 31, 35.0, 5.85 },
    { 22, 10, 51.60, +30, 33, 11.2, 6.32 },
    { 18, 32, 49.90, +30, 33, 15.1, 5.48 },
    {  3, 15, 20.50, +30, 33, 24.1, 5.52 },
    { 18,  7,  1.51, +30, 33, 42.8, 5.04 },
    {  8, 54, 14.69, +30, 34, 45.8, 5.39 },
    { 19, 43,  9.50, +30, 40, 43.0, 6.05 },
    { 10, 45, 51.89, +30, 40, 55.9, 5.24 },
    {  8, 45, 21.41, +30, 41, 52.1, 6.13 },
    { 20, 45, 39.70, +30, 43, 10.9, 4.22 },
    { 19,  4, 58.30, +30, 43, 59.9, 6.06 },
    { 13,  0, 16.51, +30, 47,  6.0, 4.90 },
    { 17, 36, 36.70, +30, 47,  7.1, 6.02 },
    { 18, 40,  1.99, +30, 50, 57.8, 6.36 },
    {  0, 39, 19.70, +30, 51, 38.9, 3.27 },
    { 16, 22,  5.81, +30, 53, 30.8, 4.85 },
    { 18, 33, 23.11, +30, 53, 33.0, 6.59 },
    { 17,  0, 17.40, +30, 55, 35.0, 3.92 },
    {  0, 20, 24.41, +30, 56,  8.9, 5.90 },
    {  7, 18,  4.10, +30, 57, 20.9, 6.24 },
    {  7, 35,  8.69, +30, 57, 40.0, 5.33 },
    {  9, 10, 38.71, +30, 57, 47.2, 5.95 },
    { 22, 41, 31.39, +30, 57, 56.9, 6.34 },
    { 19, 58, 37.99, +30, 59,  1.0, 5.49 },
    { 13, 40, 15.60, +31,  0, 42.8, 6.21 },
    { 19, 18,   .79, +31,  1, 19.9, 6.68 },
    {  6,  1, 10.20, +31,  2,  4.9, 5.98 },
    {  3, 55, 22.99, +31,  2, 44.9, 6.10 },
    { 23,  0, 42.50, +31,  4, 59.2, 6.60 },
    {  5, 24, 38.50, +31,  8, 35.2, 5.94 },
    { 17, 30, 55.39, +31,  9, 29.9, 5.61 },
    {  9, 36, 42.91, +31,  9, 42.1, 5.56 },
    {  3, 52,  4.30, +31, 10,  5.9, 6.25 },
    { 21,  6, 30.31, +31, 11,  4.9, 5.82 },
    { 13, 48, 38.71, +31, 11, 25.1, 5.62 },
    { 17, 39, 57.50, +31, 12,  9.0, 6.03 },
    {  5, 24, 38.30, +31, 13, 26.0, 6.28 },
    { 20, 22, 37.39, +31, 15, 54.0, 6.09 },
    {  9, 41, 35.21, +31, 16, 41.2, 5.89 },
    { 19, 11, 46.01, +31, 16, 59.9, 5.98 },
    { 15, 30, 22.70, +31, 17, 10.0, 6.46 },
    { 17, 40, 41.21, +31, 17, 15.0, 6.28 },
    { 23, 33, 57.19, +31, 19, 31.1, 4.98 },
    {  5, 40, 35.90, +31, 21, 29.2, 6.04 },
    { 15, 32, 55.80, +31, 21, 33.1, 4.14 },
    { 18, 11, 54.19, +31, 24, 19.1, 4.97 },
    {  1, 11,  6.79, +31, 25, 28.9, 5.16 },
    {  4, 49, 12.79, +31, 26, 13.9, 5.58 },
    {  4, 26,  6.31, +31, 26, 20.0, 5.28 },
    { 10, 15,  6.29, +31, 28,  5.2, 6.46 },
    { 17, 45, 40.30, +31, 30, 16.9, 6.23 },
    {  0, 18, 38.30, +31, 31,  1.9, 5.87 },
    { 20, 37, 32.59, +31, 31, 18.8, 6.49 },
    {  2, 11, 25.01, +31, 31, 35.0, 6.23 },
    { 11, 18, 10.90, +31, 31, 45.1, 4.87 },
    { 11, 18, 10.99, +31, 31, 45.1, 4.41 },
    {  0, 15,  7.01, +31, 32,  8.9, 6.45 },
    { 20, 37, 31.80, +31, 34, 21.0, 6.32 },
    { 16, 41, 17.21, +31, 36, 11.2, 2.81 },
    { 10,  8, 15.91, +31, 36, 15.1, 6.24 },
    {  2, 36, 42.89, +31, 36, 27.0, 6.10 },
    { 18, 41, 41.30, +31, 37,  4.1, 6.41 },
    { 18, 49, 43.99, +31, 37, 45.1, 6.64 },
    { 10, 42, 11.30, +31, 41, 48.8, 6.02 },
    {  5, 54, 58.99, +31, 42,  6.1, 5.90 },
    { 16, 52, 58.10, +31, 42,  6.1, 5.32 },
    { 15, 48,  1.99, +31, 44,  8.9, 6.44 },
    { 19,  4, 57.89, +31, 44, 39.8, 5.56 },
    {  1, 17, 24.10, +31, 44, 40.9, 6.73 },
    { 11, 41, 34.30, +31, 44, 46.0, 5.73 },
    { 18, 47, 57.50, +31, 45, 24.8, 6.06 },
    { 23,  2, 33.10, +31, 46, 50.2, 6.57 },
    {  7, 29,  6.70, +31, 47,  3.8, 4.18 },
    { 15, 14,  6.10, +31, 47, 17.2, 5.99 },
    { 14, 29, 49.70, +31, 47, 28.0, 6.06 },
    {  2, 27, 27.70, +31, 48,  5.0, 5.54 },
    {  1,  2, 49.10, +31, 48, 15.8, 5.50 },
    { 23, 21, 54.91, +31, 48, 45.0, 5.32 },
    { 22, 27, 46.20, +31, 50, 25.1, 5.98 },
    {  3, 54,  7.90, +31, 53,  1.0, 2.85 },
    { 17,  2, 17.21, +31, 53,  4.9, 6.36 },
    {  7, 34, 36.00, +31, 53, 17.9, 1.98 },
    {  7, 34, 36.00, +31, 53, 19.0, 2.88 },
    {  5, 40, 42.10, +31, 55, 14.9, 6.11 },
    { 10,  1,   .70, +31, 55, 25.0, 5.36 },
    { 18, 43, 51.60, +31, 55, 36.1, 5.70 },
    {  2, 57, 17.30, +31, 56,  3.1, 5.11 },
    {  8, 40, 18.29, +31, 56, 30.8, 6.10 },
    {  4, 20, 10.01, +31, 57, 11.9, 6.16 },
    { 10, 38, 43.20, +31, 58, 34.0, 4.71 },
    {  7, 39, 54.10, +32,  0, 34.9, 6.17 },
    {  1,  8,  1.30, +32,  0, 43.9, 6.25 },
    { 13, 56, 10.49, +32,  1, 57.0, 6.32 },
    {  5, 51, 25.70, +32,  7, 30.0, 6.25 },
    { 19,  0,   .91, +32,  8, 44.2, 4.93 },
    {  3, 16, 35.11, +32, 11,  1.0, 6.06 },
    { 20, 23, 51.70, +32, 11, 24.0, 4.43 },
    {  1, 43, 49.99, +32, 11, 30.1, 6.34 },
    {  5, 32, 43.70, +32, 11, 30.8, 4.76 },
    {  3, 47, 48.91, +32, 11, 42.0, 6.25 },
    { 20,  4, 36.10, +32, 13,  7.0, 5.64 },
    { 21, 28,  8.30, +32, 13, 31.1, 5.80 },
    { 18,  5, 49.61, +32, 13, 50.2, 5.71 },
    {  9,  1, 24.10, +32, 15,  9.0, 5.82 },
    { 11, 58,  7.20, +32, 16, 26.0, 6.42 },
    {  3, 44, 19.10, +32, 17, 17.9, 3.83 },
    { 14, 11, 15.10, +32, 17, 44.2, 6.11 },
    { 14, 55, 58.70, +32, 18,  1.1, 6.12 },
    { 20, 41,  2.59, +32, 18, 25.9, 5.51 },
    {  5,  4, 36.89, +32, 19, 13.1, 6.62 },
    { 16, 22, 56.50, +32, 19, 59.2, 6.40 },
    {  9,  4, 55.20, +32, 22, 36.8, 6.46 },
    { 10, 31, 51.41, +32, 22, 45.8, 5.90 },
    { 23, 58, 49.20, +32, 22, 54.1, 6.52 },
    { 23, 24, 50.81, +32, 23,  6.0, 5.57 },
    {  7,  1, 17.21, +32, 24, 51.8, 6.59 },
    {  8, 59, 32.59, +32, 25,  7.0, 5.20 },
    { 19, 42, 44.59, +32, 25, 36.1, 5.94 },
    { 21, 20, 50.09, +32, 27, 10.1, 5.68 },
    {  6, 32, 27.19, +32, 27, 16.9, 5.87 },
    {  4, 30, 38.30, +32, 27, 29.2, 6.21 },
    { 17, 20, 39.60, +32, 28,  4.1, 5.39 },
    {  8, 52, 34.61, +32, 28, 27.1, 5.66 },
    { 19,  7, 25.61, +32, 30,  6.1, 5.23 },
    { 15, 19, 30.19, +32, 30, 55.1, 6.32 },
    { 15, 43, 59.30, +32, 30, 56.9, 5.56 },
    { 23, 23, 47.50, +32, 31, 53.0, 6.69 },
    { 14, 34, 11.71, +32, 32,  3.8, 6.33 },
    {  9,  8,  4.10, +32, 32, 26.2, 6.50 },
    { 18, 49, 52.90, +32, 33,  2.9, 5.25 },
    { 16, 50, 43.10, +32, 33, 13.0, 6.13 },
    {  6, 27, 35.50, +32, 33, 47.2, 6.43 },
    { 22, 30,  1.80, +32, 34, 21.0, 5.65 },
    {  4, 49, 19.01, +32, 35, 17.9, 5.86 },
    {  6, 49, 41.30, +32, 36, 24.1, 5.71 },
    { 21, 21, 22.01, +32, 36, 46.1, 6.04 },
    {  6,  2, 55.10, +32, 38,  8.9, 6.24 },
    {  5, 15, 24.41, +32, 41, 16.1, 5.02 },
    { 18, 58, 56.59, +32, 41, 21.8, 3.24 },
    {  1, 48, 41.59, +32, 41, 25.1, 5.79 },
    {  6, 12, 20.09, +32, 41, 35.9, 5.78 },
    { 17, 38, 49.70, +32, 44, 21.8, 6.37 },
    { 14, 45, 13.70, +32, 47, 17.9, 6.28 },
    {  5, 33, 27.50, +32, 48,  4.0, 6.48 },
    {  8, 38, 19.01, +32, 48,  6.8, 5.94 },
    { 18, 49, 45.91, +32, 48, 46.1, 5.91 },
    { 23,  7, 27.70, +32, 49, 32.9, 6.02 },
    { 20, 52,   .31, +32, 50, 57.1, 6.44 },
    {  3, 15, 46.99, +32, 51, 23.0, 6.31 },
    {  4, 43, 48.29, +32, 51, 55.1, 6.45 },
    { 19, 46, 34.99, +32, 53, 19.0, 6.18 },
    {  2, 37,  6.41, +32, 53, 30.8, 6.25 },
    { 18, 57,  1.61, +32, 54,  5.0, 5.22 },
    {  9, 21, 27.19, +32, 54,  6.8, 6.16 },
    { 23, 36, 30.50, +32, 54, 15.1, 6.35 },
    {  8, 56, 56.59, +32, 54, 37.1, 5.45 },
    {  0, 20, 45.50, +32, 54, 41.0, 5.79 },
    { 19, 50, 33.89, +32, 54, 51.1, 4.23 },
    { 15, 21, 48.60, +32, 56,  2.0, 5.37 },
    { 22,  4, 34.39, +32, 56, 30.8, 6.38 },
    { 22,  0, 26.81, +33,  0, 22.0, 6.46 },
    {  6, 33, 42.70, +33,  1, 27.1, 6.42 },
    { 12, 16, 30.10, +33,  3, 41.0, 5.00 },
    {  3, 49, 32.59, +33,  5, 29.0, 5.11 },
    { 11, 18, 28.70, +33,  5, 39.1, 3.48 },
    { 17, 17, 19.49, +33,  6,   .0, 4.82 },
    {  1, 16, 18.79, +33,  6, 52.9, 6.02 },
    {  4, 56, 59.59, +33,  9, 58.0, 2.69 },
    { 11, 59, 17.59, +33, 10,  3.0, 5.96 },
    { 22,  9, 13.61, +33, 10, 19.9, 5.58 },
    { 22,  9, 59.21, +33, 10, 41.9, 4.29 },
    {  0, 14,  2.30, +33, 12, 22.0, 6.25 },
    { 18,  0, 36.41, +33, 12, 50.0, 5.99 },
    { 19, 23, 34.01, +33, 13, 19.9, 6.37 },
    {  7, 51,  2.30, +33, 14,  1.0, 6.03 },
    { 12, 33, 38.90, +33, 14, 51.0, 5.42 },
    {  5, 26, 51.31, +33, 15, 46.1, 6.15 },
    {  2,  2, 58.01, +33, 17,  2.0, 5.50 },
    {  8, 50, 32.21, +33, 17,  7.1, 6.25 },
    { 16,  1,  2.69, +33, 18, 13.0, 5.41 },
    { 18,  1, 35.90, +33, 18, 41.0, 6.15 },
    { 15, 15, 30.19, +33, 18, 52.9, 3.47 },
    { 16, 11, 39.70, +33, 20, 33.0, 6.29 },
    {  2, 15, 56.21, +33, 21, 32.0, 5.28 },
    { 18, 50,  4.80, +33, 21, 46.1, 3.45 },
    {  5, 18, 10.70, +33, 22, 18.1, 4.54 },
    { 11, 51,  9.41, +33, 22, 30.0, 6.27 },
    { 12, 33, 47.40, +33, 23,  4.9, 6.24 },
    { 19, 19,  3.79, +33, 23, 20.0, 6.60 },
    {  7, 47, 30.31, +33, 24, 56.2, 5.14 },
    { 19, 48, 50.59, +33, 26, 13.9, 6.44 },
    { 20, 53, 53.90, +33, 26, 16.1, 5.47 },
    { 18, 11, 45.10, +33, 26, 48.8, 5.88 },
    { 11, 26, 25.49, +33, 27,  2.2, 6.32 },
    { 18, 36, 37.20, +33, 28,  8.0, 5.42 },
    { 23, 34, 38.21, +33, 29, 49.9, 5.63 },
    { 10, 55, 44.40, +33, 30, 24.8, 5.03 },
    { 19, 22, 33.41, +33, 31,  5.2, 6.06 },
    { 12, 54, 13.10, +33, 32,  3.8, 6.26 },
    {  3, 24, 29.69, +33, 32,  8.9, 5.61 },
    {  5, 37, 45.70, +33, 33, 33.1, 6.33 },
    { 17,  1, 36.41, +33, 34,  5.9, 5.25 },
    {  0, 31, 25.61, +33, 34, 54.1, 5.87 },
    {  4, 10, 58.99, +33, 35, 12.1, 5.72 },
    {  6,  5, 34.01, +33, 35, 57.1, 6.23 },
    {  3, 47, 52.61, +33, 36,   .0, 6.57 },
    { 19,  1, 48.31, +33, 37, 17.0, 6.39 },
    { 11, 38, 32.21, +33, 37, 32.2, 6.27 },
    {  9, 30, 43.20, +33, 39, 20.2, 5.85 },
    {  6, 57,   .50, +33, 40, 52.0, 5.89 },
    { 16, 22, 29.21, +33, 42, 13.0, 5.39 },
    { 10, 24,  8.59, +33, 43,  7.0, 5.50 },
    {  0, 36, 52.90, +33, 43,  9.8, 4.36 },
    { 23, 59, 29.21, +33, 43, 27.8, 6.58 },
    { 23, 59, 29.21, +33, 43, 27.8, 6.58 },
    { 19, 46, 25.61, +33, 43, 40.1, 4.99 },
    { 20, 15, 23.71, +33, 43, 45.8, 5.66 },
    {  5, 19,   .00, +33, 44, 53.9, 5.41 },
    {  5, 18, 18.91, +33, 46,  1.9, 6.14 },
    { 10, 25, 54.89, +33, 47, 46.0, 4.74 },
    { 16, 22, 21.41, +33, 47, 57.1, 5.20 },
    { 19,  0, 55.20, +33, 48,  7.9, 6.01 },
    {  3, 28, 20.81, +33, 48, 27.0, 5.61 },
    {  7,  8, 13.30, +33, 49, 55.9, 6.28 },
    {  2, 30, 16.61, +33, 50,  2.0, 6.25 },
    {  2, 17, 18.91, +33, 50, 49.9, 4.01 },
    { 16, 14, 40.80, +33, 51, 29.9, 6.66 },
    { 16, 14, 40.80, +33, 51, 31.0, 5.64 },
    {  9,  8, 51.10, +33, 52, 55.9, 5.93 },
    { 10, 23,  6.29, +33, 54, 29.2, 5.90 },
    {  5, 52, 40.10, +33, 55,  3.0, 5.98 },
    {  0, 58, 14.21, +33, 57,  2.9, 5.98 },
    {  5, 20,   .91, +33, 57, 29.2, 5.03 },
    {  4, 24, 37.39, +33, 57, 34.9, 5.76 },
    {  6, 52, 47.30, +33, 57, 40.0, 3.60 },
    {  3, 42, 22.51, +33, 57, 54.0, 4.97 },
    { 18, 54, 52.51, +33, 58,  7.0, 6.02 },
    { 20, 46, 12.70, +33, 58, 13.1, 2.46 },
    { 19, 39, 45.00, +33, 58, 45.1, 6.10 },
    {  5, 19, 23.59, +33, 59,  8.2, 6.49 },
    {  7, 42, 43.51, +34,  0,  1.1, 6.02 },
    {  7,  7, 22.30, +34,  0, 33.8, 5.91 },
    { 10, 54, 58.20, +34,  2,  4.9, 5.72 },
    { 11, 59, 57.19, +34,  2,  6.0, 6.50 },
    { 16, 43, 51.70, +34,  2, 20.0, 5.99 },
    { 13, 18, 27.79, +34,  5, 53.2, 5.82 },
    {  4, 24, 29.21, +34,  7, 50.2, 5.73 },
    { 19, 43, 51.41, +34,  9, 45.0, 6.05 },
    { 11, 41,  3.00, +34, 12,  6.1, 5.33 },
    { 10, 53, 18.70, +34, 12, 54.0, 3.83 },
    {  3, 18, 43.80, +34, 13, 22.1, 4.82 },
    {  2, 17,  3.19, +34, 13, 27.1, 4.87 },
    {  1, 23, 37.49, +34, 14, 44.9, 6.29 },
    {  2, 37,  2.50, +34, 15, 50.0, 5.30 },
    { 17, 32,  1.10, +34, 16, 14.9, 6.56 },
    {  5, 16, 18.19, +34, 18, 42.8, 5.96 },
    { 20, 27,  7.70, +34, 19, 44.0, 6.39 },
    { 15, 26, 17.40, +34, 20,  8.9, 5.46 },
    {  3, 51, 53.71, +34, 21, 33.1, 5.77 },
    { 20, 47, 10.80, +34, 22, 27.1, 4.92 },
    {  1, 27,  6.19, +34, 22, 39.0, 6.27 },
    {  5, 26, 48.91, +34, 23, 30.1, 5.94 },
    {  9, 21,  3.29, +34, 23, 33.0, 3.13 },
    { 19, 44, 38.21, +34, 24, 50.0, 6.57 },
    { 20,  7, 41.40, +34, 25, 23.2, 6.11 },
    { 13, 51, 47.50, +34, 26, 39.1, 4.74 },
    { 19, 31, 46.30, +34, 27, 11.2, 4.74 },
    { 18, 35, 13.49, +34, 27, 28.1, 6.10 },
    {  7,  6, 11.59, +34, 28, 26.0, 5.55 },
    {  5, 27, 38.90, +34, 28, 32.9, 5.07 },
    {  2, 32, 52.51, +34, 32, 33.0, 5.83 },
    { 15,  3, 36.50, +34, 33, 58.0, 6.59 },
    {  4, 20, 24.60, +34, 34,   .1, 4.93 },
    {  1, 26,  8.69, +34, 34, 46.9, 6.31 },
    {  7, 39,  9.91, +34, 35,  3.1, 4.90 },
    { 19,  9,  4.39, +34, 36,  2.2, 6.74 },
    { 22, 12, 47.81, +34, 36, 16.9, 5.33 },
    {  9, 15, 14.30, +34, 38,  1.0, 5.97 },
    {  0,  4, 53.81, +34, 39, 34.9, 6.12 },
    { 13, 51,  9.19, +34, 39, 51.8, 5.87 },
    { 15, 38, 48.91, +34, 40, 30.0, 6.11 },
    {  2, 35, 46.80, +34, 41, 15.0, 5.35 },
    {  3, 16,  1.90, +34, 41, 19.0, 6.25 },
    { 17, 26, 46.20, +34, 41, 44.9, 5.94 },
    {  5, 33, 37.99, +34, 43, 32.9, 6.27 },
    { 18, 42,  8.11, +34, 44, 48.1, 6.47 },
    { 13, 51,  4.51, +34, 46, 21.0, 6.65 },
    { 17,  3, 53.50, +34, 47, 25.1, 6.04 },
    { 23, 19, 27.41, +34, 47, 35.9, 6.32 },
    {  1, 32,  7.61, +34, 48,   .0, 6.39 },
    {  3, 58,  3.10, +34, 48, 51.8, 6.53 },
    {  5, 25, 13.01, +34, 51, 19.1, 6.55 },
    { 21, 17, 55.10, +34, 53, 48.8, 4.43 },
    { 11, 49, 41.71, +34, 55, 54.1, 5.70 },
    { 23, 32, 24.60, +34, 57,  9.0, 6.65 },
    { 20, 18, 39.10, +34, 58, 58.1, 5.17 },
    {  2,  9, 32.59, +34, 59, 13.9, 3.00 },
    { 10, 33, 30.91, +34, 59, 19.0, 5.58 },
    { 13, 42, 43.39, +34, 59, 20.0, 5.98 },
    {  8, 25,  4.90, +35,  0, 41.0, 6.06 },
    { 19, 45, 51.41, +35,  0, 46.1, 6.09 },
    {  7, 38, 32.81, +35,  2, 55.0, 5.56 },
    {  2, 51, 30.79, +35,  3, 34.9, 4.53 },
    {  3, 56, 28.70, +35,  4, 52.0, 5.49 },
    { 19, 56, 18.41, +35,  4, 59.9, 3.89 },
    {  9, 42, 42.70, +35,  5, 35.9, 6.14 },
    {  9, 31, 32.40, +35,  6, 11.2, 5.37 },
    { 13, 19,  4.20, +35,  7, 41.2, 6.02 },
    {  2, 59,  3.70, +35, 10, 59.2, 4.93 },
    { 19, 20, 33.10, +35, 11, 10.0, 6.31 },
    { 15,  3,  6.10, +35, 12, 20.9, 5.51 },
    { 16, 31,  2.81, +35, 13, 30.0, 6.25 },
    { 10,  7, 25.80, +35, 14, 40.9, 4.48 },
    {  1, 42,  3.50, +35, 14, 44.2, 5.64 },
    { 20, 33, 54.19, +35, 15,  2.9, 4.61 },
    { 19, 48, 43.90, +35, 18, 41.0, 6.53 },
    {  9, 18, 25.99, +35, 21, 51.1, 5.75 },
    {  6,  6,  8.50, +35, 23, 15.0, 6.12 },
    {  0, 37, 21.10, +35, 23, 57.8, 5.48 },
    {  7, 55, 40.80, +35, 24, 46.1, 6.23 },
    {  8,  1, 55.10, +35, 24, 47.2, 6.34 },
    { 17,  3, 30.19, +35, 24, 51.1, 6.69 },
    { 20, 42, 22.20, +35, 27, 22.0, 6.66 },
    {  5, 26, 54.29, +35, 27, 25.9, 6.15 },
    {  3, 32, 40.01, +35, 27, 42.1, 5.90 },
    { 14, 17, 59.81, +35, 30, 33.8, 4.81 },
    { 21, 42,  1.10, +35, 30, 37.1, 6.07 },
    {  8, 53, 55.70, +35, 32, 17.9, 6.14 },
    {  2, 47,  3.50, +35, 33, 18.0, 6.30 },
    { 22, 36,  7.90, +35, 34, 37.9, 6.10 },
    { 20, 43, 24.19, +35, 35, 16.1, 6.47 },
    {  1,  9, 43.90, +35, 37, 14.2, 2.06 },
    { 22, 36, 48.70, +35, 39,  9.0, 6.30 },
    { 15, 51, 13.90, +35, 39, 27.0, 4.82 },
    { 22, 29, 43.90, +35, 43, 32.2, 6.56 },
    {  6, 53,  3.41, +35, 47, 19.0, 6.01 },
    {  3, 58, 57.89, +35, 47, 28.0, 4.04 },
    { 13,  5, 44.50, +35, 47, 56.0, 5.25 },
    {  8, 58, 27.50, +35, 48,  9.0, 6.51 },
    {  9, 35, 39.60, +35, 48, 37.1, 5.41 },
    { 11, 12, 32.21, +35, 48, 49.0, 6.41 },
    { 21, 45, 44.50, +35, 51, 25.9, 6.40 },
    {  6, 41, 37.70, +35, 55, 54.8, 6.46 },
    { 17,  8,  1.99, +35, 56,  7.1, 5.39 },
    {  5,  6,   .91, +35, 56, 11.0, 6.52 },
    { 12, 39, 16.90, +35, 57,  6.8, 6.45 },
    { 20,  6, 21.79, +35, 58, 21.0, 5.36 },
    {  2, 46, 58.30, +35, 59,  1.0, 6.25 },
    { 21,  1, 12.89, +36,  1, 34.0, 5.97 },
    { 12,  1, 39.50, +36,  2, 30.8, 5.59 },
    { 18, 19, 51.70, +36,  3, 51.8, 4.33 },
    { 19, 45, 39.60, +36,  5, 28.0, 6.43 },
    { 10, 59, 32.81, +36,  5, 35.2, 6.00 },
    { 19,  7, 18.10, +36,  6,  1.1, 5.28 },
    {  6, 44, 12.60, +36,  6, 34.9, 6.31 },
    {  2, 32,  6.19, +36,  8, 49.9, 5.15 },
    {  6, 15, 39.00, +36,  8, 55.0, 6.92 },
    {  4, 56, 19.90, +36, 10,  8.0, 6.07 },
    { 14, 28, 16.39, +36, 11, 48.8, 6.10 },
    { 19, 30, 46.90, +36, 13, 43.0, 6.25 },
    { 19, 56, 44.21, +36, 15,  2.9, 6.02 },
    { 17, 58, 42.29, +36, 17, 16.1, 6.00 },
    { 13, 37, 27.60, +36, 17, 42.0, 4.82 },
    { 21, 11,  3.89, +36, 17, 57.1, 6.54 },
    { 11,  9, 19.10, +36, 18, 33.8, 5.74 },
    { 19, 26,  9.10, +36, 19,  4.1, 5.15 },
    { 10, 36, 21.41, +36, 19, 36.8, 6.28 },
    { 22, 55, 44.50, +36, 21,  6.1, 5.74 },
    {  9, 34, 13.39, +36, 23, 51.0, 4.55 },
    { 18,  8,  2.21, +36, 24,  5.0, 5.48 },
    {  8, 34, 43.80, +36, 25,  9.8, 5.78 },
    { 16, 11, 48.00, +36, 25, 30.0, 5.63 },
    { 23, 49, 40.99, +36, 25, 31.1, 5.90 },
    { 19, 52, 16.30, +36, 25, 55.9, 6.10 },
    {  8, 33, 21.79, +36, 26, 11.0, 6.24 },
    { 19, 24,  6.10, +36, 27,  6.8, 6.36 },
    { 20, 29, 20.40, +36, 27, 16.9, 5.88 },
    { 15,  6, 35.11, +36, 27, 20.2, 6.35 },
    {  3, 44, 31.39, +36, 27, 36.0, 5.59 },
    { 18,  9, 58.99, +36, 27, 59.0, 5.58 },
    {  9, 33, 30.31, +36, 29, 12.8, 6.18 },
    { 20, 47, 24.50, +36, 29, 26.9, 4.53 },
    { 16,  8, 58.30, +36, 29, 26.9, 4.76 },
    { 18, 51, 36.50, +36, 32, 19.0, 6.09 },
    { 18, 43, 36.10, +36, 33, 24.1, 6.01 },
    { 21, 48,  8.30, +36, 34, 50.2, 6.47 },
    {  9, 24, 22.51, +36, 35, 12.8, 6.67 },
    { 20, 14,  4.99, +36, 36, 19.1, 6.45 },
    { 15, 31, 22.39, +36, 36, 59.0, 6.38 },
    { 14, 34, 38.50, +36, 37, 32.9, 6.03 },
    {  0,  8, 40.99, +36, 37, 36.1, 6.19 },
    { 16,  3, 19.39, +36, 37, 54.1, 5.83 },
    { 13, 49, 45.00, +36, 37, 58.1, 6.38 },
    { 21, 13, 26.30, +36, 38,  1.0, 6.05 },
    { 15, 39, 22.70, +36, 38,  8.9, 5.07 },
    { 15, 39, 22.20, +36, 38, 12.1, 6.00 },
    { 15, 58, 57.70, +36, 38, 38.0, 5.62 },
    { 21, 25, 46.99, +36, 40,  3.0, 5.94 },
    {  4, 52, 37.99, +36, 42, 11.2, 4.78 },
    { 10, 27, 52.99, +36, 42, 25.9, 4.21 },
    { 23, 40, 40.61, +36, 43, 14.9, 6.23 },
    { 11, 55, 14.09, +36, 45, 23.0, 6.49 },
    {  7, 22,  2.59, +36, 45, 38.2, 5.13 },
    {  0, 18, 19.70, +36, 47,  7.1, 4.52 },
    {  9, 18, 50.69, +36, 48,  9.0, 3.82 },
    { 15, 30, 27.91, +36, 48, 15.1, 6.37 },
    { 20, 14, 31.99, +36, 48, 23.0, 4.97 },
    { 17, 15,  2.81, +36, 48, 33.1, 3.16 },
    { 11, 33, 56.30, +36, 48, 56.2, 6.40 },
    { 20,  9, 25.61, +36, 50, 22.9, 4.93 },
    { 18, 54, 30.19, +36, 53, 56.0, 4.30 },
    {  0, 28, 56.59, +36, 54,   .0, 6.26 },
    {  8, 44, 10.10, +36, 55,  5.2, 6.33 },
    { 20, 30, 59.21, +36, 56,  8.9, 6.19 },
    { 19, 35, 48.31, +36, 56, 39.8, 6.05 },
    { 17, 24, 27.10, +36, 57,  6.8, 6.28 },
    { 14, 33, 20.30, +36, 57, 33.8, 6.43 },
    { 18, 53, 43.61, +36, 58, 18.1, 5.58 },
    {  4,  1, 14.69, +36, 59, 24.0, 6.41 },
    { 19, 54, 48.31, +36, 59, 46.0, 5.76 },
    { 20, 18, 28.61, +37,  0,   .0, 5.58 },
    { 13, 23, 54.00, +37,  2,  2.0, 6.07 },
    { 19, 59, 55.20, +37,  2, 34.1, 5.19 },
    { 20, 16, 28.20, +37,  3, 23.0, 6.48 },
    { 22, 55,  2.59, +37,  4, 36.8, 5.91 },
    { 20,  1, 15.31, +37,  5, 56.0, 6.20 },
    { 21, 27, 21.41, +37,  7,   .1, 5.31 },
    {  1, 54, 57.50, +37,  7, 41.9, 6.26 },
    { 20, 19, 48.31, +37,  7, 57.0, 6.57 },
    { 17, 23, 40.99, +37,  8, 44.9, 4.52 },
    { 17, 23, 40.70, +37,  8, 48.1, 5.47 },
    {  6, 43, 13.80, +37,  8, 48.8, 6.19 },
    { 13, 34, 47.81, +37, 10, 57.0, 4.98 },
    {  5, 59, 43.30, +37, 12, 45.0, 2.62 },
    {  1, 34, 16.61, +37, 14, 13.9, 5.88 },
    { 17, 56, 15.19, +37, 15,  2.2, 3.86 },
    {  1, 56,  9.29, +37, 15,  6.1, 5.67 },
    {  8, 31, 19.90, +37, 15, 56.9, 6.18 },
    { 14, 50, 29.59, +37, 16, 18.8, 5.48 },
    {  1, 55, 54.41, +37, 16, 40.1, 5.89 },
    { 17, 17, 40.30, +37, 17, 30.1, 4.65 },
    { 17, 35, 42.41, +37, 18,  6.1, 6.10 },
    {  5, 10, 18.91, +37, 18,  6.8, 6.02 },
    {  5, 51,  2.40, +37, 18, 20.2, 4.74 },
    {  2, 35, 38.81, +37, 18, 43.9, 5.71 },
    {  2, 49, 27.10, +37, 19, 34.0, 6.45 },
    { 19, 19, 38.90, +37, 19, 50.2, 6.31 },
    { 15, 24, 30.91, +37, 20, 52.1, 6.50 },
    { 21, 23, 48.31, +37, 21,  5.0, 6.47 },
    { 19, 44, 16.61, +37, 21, 15.8, 4.89 },
    { 15, 24, 29.40, +37, 22, 37.9, 4.31 },
    {  5, 24, 39.19, +37, 23,  8.2, 4.99 },
    {  1, 18, 46.99, +37, 23, 10.0, 6.46 },
    { 16, 25, 24.19, +37, 23, 38.0, 5.54 },
    { 10, 11, 12.79, +37, 24,  6.8, 5.85 },
    { 21, 23, 22.99, +37, 24, 24.1, 6.58 },
    { 22, 48, 10.90, +37, 25,   .1, 5.90 },
    {  0, 53, 28.20, +37, 25,  5.2, 6.06 },
    { 13,  9, 38.71, +37, 25, 23.2, 6.02 },
    { 22, 26, 45.70, +37, 26, 38.0, 6.46 },
    {  7,  8, 36.31, +37, 26, 42.0, 6.16 },
    { 19, 19,  1.20, +37, 26, 43.1, 6.22 },
    { 20, 23, 44.40, +37, 28, 35.0, 5.90 },
    {  4, 49, 54.60, +37, 29, 17.9, 4.88 },
    { 12, 50, 10.70, +37, 31,   .8, 5.89 },
    {  7, 46, 39.29, +37, 31,  3.0, 5.18 },
    {  3, 41,  7.90, +37, 34, 48.0, 5.57 },
    { 22, 39, 34.30, +37, 35, 34.1, 6.03 },
    { 18, 44, 48.19, +37, 35, 39.8, 5.73 },
    {  9,  0, 30.79, +37, 36, 15.8, 6.44 },
    { 18, 44, 46.39, +37, 36, 18.0, 4.36 },
    { 23, 40,  2.81, +37, 39,  9.0, 6.53 },
    {  0, 12, 50.40, +37, 41, 35.9, 6.73 },
    {  1, 23, 40.61, +37, 42, 54.0, 5.58 },
    { 11, 52, 58.80, +37, 43,  7.0, 6.45 },
    {  1, 11, 10.30, +37, 43, 27.1, 5.81 },
    {  2, 38, 17.81, +37, 43, 36.1, 6.18 },
    {  4,  8, 15.31, +37, 43, 40.1, 6.09 },
    { 22, 15, 58.20, +37, 44, 56.0, 4.13 },
    { 22, 18, 56.21, +37, 46,  9.8, 6.17 },
    { 22, 42, 55.51, +37, 48, 10.1, 6.43 },
    { 14, 49,  6.70, +37, 48, 40.0, 6.16 },
    { 19, 50, 46.99, +37, 49, 35.0, 6.06 },
    {  2,  8, 29.30, +37, 51, 33.1, 4.82 },
    {  4, 59, 15.41, +37, 53, 25.1, 4.94 },
    { 10, 39,  7.61, +37, 54, 36.0, 5.85 },
    { 19, 27, 36.50, +37, 56, 28.0, 6.34 },
    { 15, 55, 47.59, +37, 56, 48.8, 5.45 },
    {  1, 48, 38.90, +37, 57, 10.1, 5.94 },
    {  6,  5,  2.59, +37, 57, 51.1, 6.34 },
    {  4, 13, 59.59, +37, 58,   .8, 6.45 },
    {  0, 21,  7.30, +37, 58,  7.0, 5.18 },
    {  8, 32, 55.01, +38,  0, 59.0, 5.90 },
    { 23, 34, 46.70, +38,  1, 26.0, 6.18 },
    { 20, 17, 47.21, +38,  1, 59.2, 4.81 },
    {  4,  8, 36.60, +38,  2, 22.9, 5.51 },
    { 21, 14, 47.50, +38,  2, 44.2, 3.72 },
    {  6, 59,  2.81, +38,  3,  7.9, 6.00 },
    {  2, 38, 27.79, +38,  5, 21.8, 6.30 },
    { 19, 58, 34.39, +38,  6, 20.2, 6.32 },
    {  3,  0, 11.81, +38,  7, 54.1, 6.11 },
    { 19, 16, 22.10, +38,  8,  1.0, 4.36 },
    { 23, 20, 53.30, +38, 10, 55.9, 5.77 },
    { 11, 19,  7.90, +38, 11,  8.2, 4.78 },
    {  9, 20, 59.30, +38, 11, 17.9, 6.12 },
    { 21, 19, 22.20, +38, 14, 15.0, 5.83 },
    { 11,  4, 31.20, +38, 14, 29.0, 6.00 },
    { 15, 13, 35.59, +38, 15, 52.9, 6.20 },
    { 18, 58,  1.90, +38, 15, 58.0, 5.89 },
    {  4, 41, 50.30, +38, 16, 49.1, 5.99 },
    { 21, 43, 25.70, +38, 17,  2.0, 5.65 },
    { 14, 32,  4.70, +38, 18, 29.9, 3.03 },
    { 12, 56,   .41, +38, 18, 52.9, 5.60 },
    { 12, 56,  1.70, +38, 19,  5.9, 2.90 },
    {  2, 50, 35.11, +38, 19,  7.0, 4.23 },
    { 20, 37, 23.59, +38, 19, 43.0, 6.20 },
    {  2, 53, 42.60, +38, 20, 15.0, 5.33 },
    {  7, 40, 14.59, +38, 20, 39.8, 5.73 },
    { 18, 40, 12.19, +38, 22,  1.9, 6.45 },
    { 15, 35, 49.30, +38, 22, 26.0, 6.42 },
    { 19, 36, 56.59, +38, 23,  2.0, 6.50 },
    { 14, 25, 29.21, +38, 23, 35.2, 6.27 },
    { 19, 47, 27.79, +38, 24, 27.0, 5.77 },
    {  6, 53, 13.39, +38, 26, 17.2, 6.30 },
    { 20, 27, 34.30, +38, 26, 25.1, 5.62 },
    {  6, 36, 32.90, +38, 26, 43.1, 5.29 },
    {  9,  6, 31.80, +38, 27,  7.9, 4.56 },
    { 18,  9, 37.49, +38, 27, 27.0, 6.40 },
    { 20,  5,  9.79, +38, 28, 41.9, 6.19 },
    {  6,  6, 35.09, +38, 28, 58.1, 5.36 },
    {  5, 13, 25.70, +38, 29,  3.8, 4.86 },
    { 19, 55, 51.70, +38, 29, 12.1, 4.94 },
    { 13, 10,  3.19, +38, 29, 56.0, 5.91 },
    {  0, 56, 45.19, +38, 29, 57.8, 3.87 },
    { 13, 46, 19.01, +38, 30, 14.0, 5.94 },
    {  6, 53, 57.00, +38, 30, 18.0, 6.48 },
    { 13,  9, 42.00, +38, 32,  2.0, 6.28 },
    { 21, 34, 46.61, +38, 32,  3.1, 4.90 },
    { 13, 46, 59.81, +38, 32, 34.1, 5.50 },
    {  0, 52, 53.40, +38, 32, 55.0, 6.69 },
    { 22, 23, 54.19, +38, 34, 25.0, 6.22 },
    {  0, 24,  1.99, +38, 34, 37.9, 7.39 },
    { 17, 24,  2.21, +38, 34, 58.1, 6.49 },
    {  2, 58,  2.30, +38, 36, 54.0, 6.04 },
    { 21, 22, 46.90, +38, 38,  3.1, 6.63 },
    { 21, 48, 29.40, +38, 38, 55.0, 6.12 },
    { 21,  3,  4.80, +38, 39, 27.0, 6.07 },
    { 23, 30, 39.70, +38, 39, 42.8, 6.05 },
    {  0, 17,  5.50, +38, 40, 54.1, 4.61 },
    { 23,  0, 54.70, +38, 42, 29.2, 6.54 },
    { 19, 49, 27.50, +38, 42, 36.0, 6.11 },
    { 19, 50, 34.01, +38, 43, 21.0, 5.12 },
    {  8, 11, 21.60, +38, 43, 53.0, 6.58 },
    {  2, 36, 57.19, +38, 43, 58.1, 5.90 },
    { 18, 23, 57.41, +38, 44, 21.1, 6.36 },
    { 21,  6, 55.30, +38, 44, 35.9, 6.03 },
    { 21,  6, 54.60, +38, 44, 44.9, 5.21 },
    { 19, 33, 36.41, +38, 45, 43.9, 6.61 },
    { 14, 18, 55.70, +38, 46,  3.0, 6.86 },
    { 18, 13,  4.80, +38, 46, 25.0, 6.04 },
    { 18, 36, 56.30, +38, 47,  1.0, 0.03 },
    { 13, 34, 21.79, +38, 47, 21.1, 6.37 },
    { 14, 19, 47.69, +38, 47, 38.0, 6.33 },
    { 17, 18, 23.30, +38, 48, 41.0, 5.94 },
    {  3, 59, 40.01, +38, 49, 14.2, 6.38 },
    {  3, 58, 29.11, +38, 50, 25.1, 6.30 },
    {  3,  5, 10.61, +38, 50, 25.1, 3.39 },
    {  6, 53,  1.49, +38, 52,  9.1, 6.12 },
    { 17, 45, 53.71, +38, 52, 53.0, 6.52 },
    { 17, 30, 40.30, +38, 52, 55.9, 6.43 },
    {  7, 31, 55.70, +38, 53, 47.0, 6.54 },
    { 20, 16,  3.41, +38, 53, 52.1, 6.27 },
    { 16, 42, 53.81, +38, 55, 19.9, 3.53 },
    { 10, 30,  6.41, +38, 55, 31.1, 5.77 },
    {  7, 22, 13.39, +38, 59, 46.0, 6.40 },
    { 15, 35, 15.00, +39,  0, 36.0, 5.11 },
    { 12, 25, 50.90, +39,  1,  7.0, 5.02 },
    {  2, 10, 52.80, +39,  2, 21.8, 5.63 },
    {  2, 10, 53.71, +39,  2, 35.2, 6.10 },
    { 22, 39, 15.70, +39,  3,  1.1, 4.88 },
    { 20, 41,   .41, +39,  4, 55.9, 6.51 },
    { 19, 13, 45.50, +39,  8, 46.0, 4.39 },
    {  5, 51, 29.40, +39,  8, 55.0, 3.97 },
    {  5, 49, 10.49, +39, 10, 52.0, 4.52 },
    { 11,  0, 50.40, +39, 12, 43.9, 5.08 },
    { 18, 59, 12.29, +39, 13,  4.1, 6.41 },
    { 23, 31, 17.40, +39, 14, 11.0, 5.22 },
    { 14, 59, 36.89, +39, 15, 55.1, 5.64 },
    { 12, 44, 59.50, +39, 16, 44.0, 5.95 },
    {  3, 17, 45.79, +39, 16, 59.9, 5.96 },
    { 18, 43, 16.70, +39, 18,  1.1, 6.45 },
    { 22, 57, 40.70, +39, 18, 32.0, 6.18 },
    {  7, 11, 39.29, +39, 19, 14.2, 4.90 },
    { 17, 45, 58.49, +39, 19, 21.0, 6.68 },
    { 11, 29,  4.20, +39, 20, 12.8, 5.31 },
    {  6, 38, 39.50, +39, 23, 26.9, 5.69 },
    {  5,  0, 18.29, +39, 23, 40.9, 5.95 },
    { 21, 17, 25.01, +39, 23, 40.9, 4.23 },
    { 20, 20, 15.19, +39, 24, 11.9, 6.23 },
    {  0, 41,  7.20, +39, 27, 31.0, 5.33 },
    { 22, 44,  5.21, +39, 27, 56.2, 5.95 },
    { 18, 24, 13.80, +39, 30, 25.9, 5.12 },
    { 21, 51,  4.90, +39, 32, 12.1, 6.17 },
    { 13, 48, 57.19, +39, 32, 34.1, 7.40 },
    {  5, 52, 39.50, +39, 34, 27.8, 6.45 },
    { 15, 22, 37.39, +39, 34, 53.0, 5.50 },
    {  3, 11, 17.40, +39, 36, 42.1, 4.63 },
    { 18, 44, 22.90, +39, 36, 46.1, 5.37 },
    { 18, 44, 22.90, +39, 36, 47.2, 5.14 },
    {  9, 35,  3.79, +39, 37, 17.0, 4.81 },
    { 22, 35, 52.30, +39, 38,  3.1, 5.73 },
    {  5,  0, 23.21, +39, 39, 18.0, 6.58 },
    {  2, 58, 45.70, +39, 39, 46.1, 4.70 },
    {  2, 35, 27.89, +39, 39, 51.8, 6.36 },
    { 18, 38,  6.50, +39, 40,  5.2, 6.04 },
    { 18, 44, 20.40, +39, 40, 12.0, 5.06 },
    { 18, 44, 20.30, +39, 40, 16.0, 6.02 },
    { 15, 57, 29.90, +39, 41, 43.1, 6.31 },
    { 16, 19, 55.10, +39, 42, 31.0, 5.46 },
    {  9,  1, 40.61, +39, 42, 47.9, 6.36 },
    { 22, 13, 52.70, +39, 42, 54.0, 4.49 },
    { 14, 16, 24.19, +39, 44, 40.9, 6.38 },
    {  9, 42,   .31, +39, 45, 28.1, 5.62 },
    { 22, 32, 26.40, +39, 46, 46.9, 5.88 },
    { 22, 27, 26.50, +39, 48, 34.9, 6.14 },
    {  5, 30, 45.10, +39, 49, 32.9, 6.37 },
    {  2, 19, 37.30, +39, 50,  6.0, 6.63 },
    {  2, 37, 20.81, +39, 53, 44.9, 6.54 },
    {  3, 33, 35.11, +39, 53, 57.8, 5.81 },
    {  6, 38, 49.20, +39, 54,  9.0, 5.20 },
    {  9, 35, 22.39, +39, 57, 47.9, 6.76 },
    { 17, 21, 43.61, +39, 58, 27.8, 5.51 },
    { 17, 52,  4.70, +39, 58, 55.9, 6.04 },
    {  1,  4, 36.41, +39, 59, 28.0, 6.72 },
    { 17, 53, 18.10, +40,  0, 29.2, 5.16 },
    {  4, 31, 24.00, +40,  0, 37.1, 6.26 },
    {  3, 57, 51.19, +40,  0, 37.1, 2.89 },
    {  7, 37, 17.81, +40,  1, 31.1, 6.38 },
    { 17, 51, 13.99, +40,  4, 21.0, 6.46 },
    { 18,  4, 43.20, +40,  5,  3.1, 6.52 },
    {  5, 19,  8.50, +40,  5, 57.1, 4.71 },
    { 13, 20, 19.01, +40,  9,  2.2, 5.60 },
    { 13, 13, 43.01, +40,  9, 10.1, 4.92 },
    { 22, 53, 11.30, +40, 10,  1.9, 6.34 },
    {  5, 36, 52.39, +40, 10, 55.9, 6.09 },
    {  2, 42, 14.90, +40, 11, 38.0, 4.91 },
    {  8, 56, 30.50, +40, 12,  6.1, 5.89 },
    { 22, 41, 28.61, +40, 13, 32.2, 5.25 },
    { 23, 34, 37.49, +40, 14, 11.0, 5.59 },
    {  9, 38, 21.70, +40, 14, 22.9, 5.25 },
    { 19, 41, 57.50, +40, 15, 14.0, 6.23 },
    { 20, 22, 13.70, +40, 15, 24.1, 2.20 },
    {  4, 46, 44.40, +40, 18, 46.1, 5.97 },
    {  1, 27, 46.99, +40, 20,  8.2, 6.60 },
    { 11, 57, 14.59, +40, 20, 37.0, 6.62 },
    { 21, 21,  1.39, +40, 20, 44.2, 6.40 },
    { 15, 37, 49.61, +40, 21, 11.9, 5.24 },
    { 20, 16, 55.30, +40, 21, 54.0, 5.24 },
    { 19, 57, 13.90, +40, 22,  5.2, 5.45 },
    { 22, 54,  7.01, +40, 22, 36.8, 5.81 },
    { 15,  1, 56.81, +40, 23, 26.2, 3.50 },
    { 21, 36, 57.00, +40, 24, 49.0, 5.01 },
    { 10, 33, 13.90, +40, 25, 32.2, 4.75 },
    { 19, 11, 23.11, +40, 25, 45.1, 6.18 },
    { 10, 59, 28.01, +40, 25, 49.1, 5.05 },
    { 14, 43, 44.40, +40, 27, 33.1, 5.73 },
    {  5, 18, 40.39, +40, 27, 54.0, 6.18 },
    {  3, 17, 11.40, +40, 28, 59.9, 6.45 },
    {  4, 14, 53.30, +40, 29,  1.0, 4.71 },
    {  5, 45, 49.51, +40, 30, 25.9, 6.58 },
    { 17,  7, 46.70, +40, 30, 58.0, 6.34 },
    { 13, 17, 32.50, +40, 34, 21.0, 4.73 },
    {  1, 40, 34.80, +40, 34, 36.8, 4.94 },
    { 20, 39, 33.31, +40, 34, 45.8, 6.06 },
    {  3,  5, 20.81, +40, 34, 57.0, 6.05 },
    { 19, 50, 37.30, +40, 35, 58.9, 5.69 },
    { 12, 16,  7.61, +40, 39, 37.1, 5.66 },
    { 10, 10, 58.90, +40, 39, 41.0, 6.32 },
    {  7, 24,  8.50, +40, 40, 19.9, 5.19 },
    { 18, 58, 46.61, +40, 40, 45.1, 6.22 },
    { 19,  0, 19.01, +40, 41,  3.1, 6.65 },
    {  1, 54, 53.81, +40, 42,  6.8, 6.24 },
    { 20, 54, 22.30, +40, 42, 11.2, 6.70 },
    { 19, 44, 49.01, +40, 43,   .1, 6.34 },
    { 13, 28, 26.21, +40, 43, 46.9, 6.47 },
    {  0, 19, 41.59, +40, 43, 46.9, 6.33 },
    {  1, 53, 17.30, +40, 43, 46.9, 5.40 },
    { 20, 18,  7.01, +40, 43, 55.9, 5.84 },
    { 17,  9, 33.31, +40, 46, 37.9, 5.08 },
    {  4, 44, 12.89, +40, 47, 12.8, 6.08 },
    { 21, 41, 34.30, +40, 48, 19.1, 6.11 },
    { 15, 30, 55.80, +40, 49, 59.2, 5.02 },
    { 13, 15, 31.99, +40, 51, 19.1, 5.79 },
    { 12, 38, 46.30, +40, 52, 27.8, 6.37 },
    {  7, 18,  2.21, +40, 52, 59.9, 5.78 },
    { 15, 31, 46.99, +40, 53, 57.8, 5.02 },
    { 18, 39, 33.10, +40, 56,  6.0, 6.25 },
    { 18, 17,  6.79, +40, 56, 12.1, 6.11 },
    {  3,  8, 10.10, +40, 57, 20.2, 2.12 },
    { 14, 27, 27.31, +41,  1, 30.0, 6.63 },
    { 20, 22, 45.31, +41,  1, 34.0, 5.93 },
    {  5, 22, 50.30, +41,  1, 45.8, 5.54 },
    {  2, 59, 39.89, +41,  1, 59.2, 5.89 },
    {  0, 13, 30.79, +41,  2,  7.1, 5.72 },
    { 21, 18, 55.30, +41,  2, 26.9, 6.15 },
    {  6,  8, 22.99, +41,  3, 20.2, 6.36 },
    {  9, 57, 41.09, +41,  3, 20.2, 5.14 },
    {  6, 49, 19.01, +41,  3, 33.0,      },
    {  5,  2, 28.70, +41,  4, 32.9, 3.75 },
    {  1, 35, 52.51, +41,  4, 35.0, 6.38 },
    { 21, 42, 22.90, +41,  4, 37.9, 5.69 },
    {  0, 49, 48.79, +41,  4, 44.0, 4.53 },
    {  5, 20, 14.81, +41,  5, 10.0, 5.52 },
    { 13, 46, 13.49, +41,  5, 19.0, 5.87 },
    { 11, 13, 40.20, +41,  5, 19.0, 6.33 },
    {  1, 27, 26.59, +41,  6,  2.2, 6.46 },
    { 23, 24, 34.99, +41,  6, 46.1, 6.72 },
    { 20, 22,  3.00, +41,  7, 53.0, 6.39 },
    { 18, 12, 42.60, +41,  8, 48.8, 6.36 },
    { 21, 49, 40.10, +41,  8, 56.0, 6.48 },
    { 21, 43,  6.41, +41,  9, 18.0, 5.49 },
    { 20, 57, 10.39, +41, 10,  1.9, 3.94 },
    { 18, 54, 14.30, +41, 13, 32.2, 7.30 },
    { 10, 22, 10.49, +41, 13, 45.8, 5.76 },
    {  5,  6, 30.91, +41, 14,  3.8, 3.17 },
    { 17, 33,  7.30, +41, 14, 37.0, 5.74 },
    {  3, 25,  9.41, +41, 15, 25.9, 6.51 },
    {  0, 42, 41.70, +41, 15, 50.0,      },
    {  4, 36, 41.40, +41, 15, 52.9, 4.25 },
    {  1,  2, 54.29, +41, 20, 42.0, 5.98 },
    { 12, 33, 44.50, +41, 21, 27.0, 4.26 },
    { 18, 52,  7.10, +41, 22, 59.9, 6.28 },
    {  2, 22, 50.30, +41, 23, 47.0, 5.82 },
    {  1, 36, 47.81, +41, 24, 20.2, 4.09 },
    { 19,  6, 16.99, +41, 24, 50.0, 6.49 },
    { 18, 46, 13.01, +41, 26, 30.1, 6.07 },
    {  5,  3, 18.60, +41, 26, 30.1, 6.14 },
    {  5, 30, 48.60, +41, 27, 42.8, 6.00 },
    { 10, 22, 19.70, +41, 29, 57.8, 3.05 },
    { 14, 14, 23.50, +41, 31,  8.0, 6.24 },
    { 22, 41, 36.10, +41, 32, 57.8, 5.94 },
    { 10, 27, 28.01, +41, 36,  2.9, 6.02 },
    { 18, 54, 52.20, +41, 36, 10.1, 5.44 },
    { 22, 56, 23.59, +41, 36, 14.0, 5.59 },
    { 21,  3, 52.10, +41, 37, 41.2, 6.33 },
    { 13, 42, 28.80, +41, 40, 27.1, 6.30 },
    {  1, 57, 56.40, +41, 41, 39.8, 6.78 },
    { 20, 41, 56.50, +41, 43,   .8, 5.67 },
    { 20, 33, 48.41, +41, 46, 19.9, 6.49 },
    { 19, 43, 45.00, +41, 46, 23.2, 5.84 },
    { 23, 18, 23.40, +41, 46, 25.0, 6.02 },
    {  6, 50, 45.91, +41, 46, 53.0, 5.02 },
    {  9,  0, 38.40, +41, 46, 58.1, 3.97 },
    { 14, 29, 36.79, +41, 47, 44.9, 6.35 },
    {  5, 21, 48.41, +41, 48, 15.8, 5.23 },
    {  4, 20, 14.40, +41, 48, 29.2, 5.92 },
    { 22, 44,  5.50, +41, 49,  9.1, 5.08 },
    {  6,  7, 26.90, +41, 51, 15.1, 6.12 },
    { 16, 28, 38.50, +41, 52, 54.1, 5.04 },
    { 16, 50, 36.10, +41, 53, 48.1, 6.29 },
    { 20, 58, 30.79, +41, 56, 25.1, 6.16 },
    { 18,  5,   .79, +41, 56, 48.1, 6.34 },
    { 22, 50, 21.79, +41, 57, 13.0, 5.92 },
    {  8, 52, 10.01, +42,  0,  9.0, 5.99 },
    {  8, 24, 42.79, +42,  0, 18.0, 6.02 },
    { 10, 56, 14.50, +42,  0, 29.9, 6.03 },
    { 23, 19, 52.39, +42,  4, 41.2, 5.79 },
    { 22, 21, 50.90, +42,  4, 41.9, 6.41 },
    {  1, 10, 18.79, +42,  4, 53.0, 5.65 },
    {  0,  4, 36.70, +42,  5, 31.9, 6.01 },
    { 20, 14, 21.60, +42,  6, 13.0, 6.71 },
    { 13, 31, 15.79, +42,  6, 22.0, 6.08 },
    {  5, 33, 28.70, +42,  6, 32.0, 6.55 },
    {  4, 18,  8.21, +42,  8, 28.0, 6.22 },
    { 18, 15, 38.81, +42,  9, 33.8, 5.59 },
    { 15, 14, 10.30, +42, 10, 17.0, 6.13 },
    { 16, 47, 19.80, +42, 14, 20.0, 5.87 },
    { 21, 16, 29.59, +42, 15,  5.0, 6.43 },
    { 19, 57, 56.21, +42, 15, 38.9, 6.43 },
    { 23,  1, 55.30, +42, 19, 34.0, 3.62 },
    {  2,  3, 54.00, +42, 19, 46.9, 2.26 },
    {  2,  3, 54.70, +42, 19, 50.9, 4.84 },
    {  0,  1, 43.80, +42, 22,  1.9, 6.25 },
    { 16, 11, 47.59, +42, 22, 27.8, 5.87 },
    {  3, 12,  9.60, +42, 22, 34.0, 6.15 },
    { 20, 53, 26.40, +42, 24, 37.1, 6.66 },
    { 19, 34, 41.21, +42, 24, 46.1, 5.35 },
    {  4, 23, 35.90, +42, 25, 41.2, 6.23 },
    {  8,  9, 23.11, +42, 25, 50.2, 6.27 },
    { 16, 34,  6.19, +42, 26, 12.8, 4.20 },
    { 15, 52, 40.49, +42, 27,  6.1, 4.62 },
    {  6, 39, 19.90, +42, 29, 20.0, 4.79 },
    {  3, 14, 56.71, +42, 30, 14.0, 6.07 },
    { 16, 57, 50.21, +42, 30, 45.0, 6.34 },
    {  5, 47, 14.69, +42, 31, 36.1, 6.29 },
    { 12, 23, 46.99, +42, 32, 34.1, 6.06 },
    { 15, 55, 30.60, +42, 33, 58.0, 5.75 },
    {  3, 45, 11.59, +42, 34, 43.0, 3.77 },
    {  3, 38,   .19, +42, 34, 59.2, 6.42 },
    {  4, 52, 47.81, +42, 35, 12.1, 5.71 },
    {  1, 41, 47.21, +42, 36, 49.0, 4.95 },
    {  7, 21,  3.10, +42, 39, 20.2, 6.35 },
    { 23, 57,  3.60, +42, 39, 29.9, 5.97 },
    { 21, 17, 23.21, +42, 40, 59.9, 6.19 },
    { 20, 17, 29.09, +42, 43, 18.8, 6.29 },
    { 23,  2, 36.29, +42, 45, 28.1, 5.10 },
    {  5, 18, 15.91, +42, 47, 31.9, 5.48 },
    { 19, 39, 26.50, +42, 49,  5.9, 5.40 },
    { 21, 41, 43.80, +42, 50, 28.0,      },
    { 11,  0, 20.59, +42, 54, 41.0, 6.02 },
    {  6,  3, 18.00, +42, 54, 42.1, 6.10 },
    { 23, 27,  7.39, +42, 54, 42.8, 5.75 },
    { 10, 17,  5.81, +42, 54, 51.8, 3.45 },
    { 22, 14, 44.40, +42, 57, 14.0, 5.71 },
    {  6,  5,  3.41, +42, 58, 54.1, 5.87 },
    { 20, 22, 55.51, +42, 58, 59.9, 6.20 },
    {  7, 35, 55.99, +43,  1, 52.0, 6.30 },
    { 12,  2,  6.79, +43,  2, 44.2, 5.21 },
    { 21, 46, 16.61, +43,  3, 38.9, 6.54 },
    {  4, 33, 24.91, +43,  3, 50.0, 6.09 },
    { 19, 40, 41.21, +43,  4, 40.1, 6.16 },
    { 22, 30, 29.30, +43,  7, 23.9, 4.51 },
    { 15, 54, 37.90, +43,  8, 19.0, 5.37 },
    { 11, 30, 31.10, +43, 10, 23.9, 5.94 },
    {  5,  6, 49.61, +43, 10, 28.9, 6.20 },
    {  8, 22, 50.09, +43, 11, 17.2, 4.25 },
    { 10, 53, 58.70, +43, 11, 24.0, 4.71 },
    { 20, 32, 52.30, +43, 11, 30.1, 6.60 },
    { 11,  9, 38.50, +43, 12, 27.0, 5.89 },
    { 16, 45, 11.71, +43, 13,  1.9, 6.05 },
    {  9, 13, 48.19, +43, 13,  4.1, 5.32 },
    { 18, 36, 45.60, +43, 13, 18.8, 6.20 },
    {  8,  7,  9.91, +43, 15, 37.1, 6.26 },
    { 23, 38,  8.21, +43, 16,  5.2, 4.29 },
    { 21, 40, 11.11, +43, 16, 26.0, 5.11 },
    {  1, 40, 39.79, +43, 17, 52.1, 5.61 },
    { 22, 52,  1.99, +43, 18, 45.0, 4.94 },
    {  3, 21, 26.50, +43, 19, 45.8, 4.95 },
    {  4, 42, 54.29, +43, 21, 54.0, 5.29 },
    {  6,  2, 53.59, +43, 22, 43.0, 6.42 },
    { 20, 13, 42.79, +43, 22, 45.1, 6.14 },
    { 19, 23, 56.50, +43, 23, 17.2, 5.84 },
    { 16, 49, 40.49, +43, 25, 50.2, 6.13 },
    {  1, 26, 18.60, +43, 27, 28.1, 5.96 },
    { 20, 40,  3.10, +43, 27, 31.0, 5.95 },
    { 18,  7, 28.80, +43, 27, 42.1, 5.00 },
    { 17, 40, 37.61, +43, 28, 14.9, 6.59 },
    { 11, 22, 49.61, +43, 28, 58.1, 4.99 },
    {  0, 32, 26.81, +43, 29, 40.9, 6.70 },
    { 23, 10, 27.19, +43, 32, 39.1, 5.94 },
    {  6, 46, 44.30, +43, 34, 39.0, 5.25 },
    {  0, 16, 21.60, +43, 35, 40.9, 6.15 },
    { 11, 38, 20.59, +43, 37, 32.2, 5.59 },
    { 14, 38, 12.50, +43, 38, 30.8, 5.70 },
    {  8, 51, 56.81, +43, 43, 36.1, 5.15 },
    {  0, 18, 42.10, +43, 47, 28.0, 6.11 },
    { 17,  5,  4.99, +43, 48, 43.9, 6.43 },
    {  5,  1, 58.10, +43, 49, 23.9, 2.99 },
    { 14,  7, 55.80, +43, 51, 15.8, 5.27 },
    { 13, 22,  3.79, +43, 54, 11.2, 6.35 },
    {  3, 31, 11.80, +43, 54, 17.0,      },
    {  6, 55, 14.69, +43, 54, 36.0, 6.13 },
    { 21,  4, 55.90, +43, 55, 40.1, 3.72 },
    {  1,  8,   .89, +43, 56, 30.8, 5.03 },
    { 21, 18, 27.19, +43, 56, 44.9, 5.00 },
    { 18, 55, 20.09, +43, 56, 46.0, 4.04 },
    {  3, 49,  8.21, +43, 57, 47.2, 6.02 },
    {  7, 58, 16.61, +43, 58, 39.0, 6.34 },
    {  6, 39, 58.01, +44,  0, 50.0, 6.41 },
    {  3, 17, 47.40, +44,  1, 30.0, 5.47 },
    { 23,  2, 45.19, +44,  3, 32.0, 6.39 },
    { 20, 50,  4.90, +44,  3, 33.8, 5.04 },
    {  4, 54, 51.31, +44,  3, 38.9, 6.08 },
    { 17, 43,  5.59, +44,  5,  3.8, 6.34 },
    { 12, 44, 27.10, +44,  6, 11.2, 6.33 },
    { 23, 20, 43.99, +44,  6, 59.0, 6.13 },
    { 13, 35, 14.09, +44, 11, 48.8, 6.84 },
    {  2, 13, 13.30, +44, 13, 54.1, 4.83 },
    { 22, 40, 30.91, +44, 16, 35.0, 4.46 },
    {  2, 44,  5.21, +44, 17, 48.8, 5.43 },
    {  2, 17, 33.41, +44, 18, 24.8, 6.70 },
    { 23, 40, 24.50, +44, 20,  2.0, 4.14 },
    {  1, 39, 21.00, +44, 23, 10.0, 4.98 },
    { 20, 53, 14.81, +44, 23, 13.9, 4.78 },
    {  0, 28, 13.70, +44, 23, 39.8, 5.17 },
    { 14, 38, 50.21, +44, 24, 15.8, 5.39 },
    {  5, 20,  2.30, +44, 25, 32.2, 6.62 },
    { 23, 37, 31.99, +44, 25, 45.1, 5.80 },
    { 15, 20, 41.59, +44, 26,  3.1, 6.19 },
    {  2,  8, 33.60, +44, 27, 33.8, 6.42 },
    { 20, 58, 19.49, +44, 28, 18.1, 5.55 },
    {  0, 36, 46.61, +44, 29, 19.0, 5.13 },
    { 11,  9, 39.79, +44, 29, 55.0, 3.01 },
    {  6, 43,  4.99, +44, 31, 27.8, 5.02 },
    { 22, 46, 10.20, +44, 32, 46.0, 5.76 },
    { 23,  8, 12.29, +44, 33, 42.1, 6.56 },
    {  6,  0, 19.01, +44, 35, 30.8, 6.22 },
    { 15,  3,  6.60, +44, 38, 39.8, 6.65 },
    { 22,  2, 56.69, +44, 39,   .0, 5.60 },
    { 19, 36, 37.90, +44, 41, 42.0, 5.17 },
    { 21, 37, 27.89, +44, 41, 48.1, 6.20 },
    {  1,  0,  3.41, +44, 42, 40.0, 6.84 },
    {  1,  0,  3.60, +44, 42, 47.9, 6.04 },
    { 22, 53, 40.10, +44, 44, 57.1, 5.81 },
    { 21,  2, 24.10, +44, 47, 28.0, 6.19 },
    {  6, 53,  7.61, +44, 50, 21.8, 6.26 },
    {  3, 32, 39.10, +44, 51, 20.2, 6.41 },
    {  3,  9, 29.81, +44, 51, 25.9, 3.80 },
    {  0, 46, 10.90, +44, 51, 41.0, 6.05 },
    {  1, 17,  5.09, +44, 54,  6.8, 6.34 },
    { 20, 56, 34.70, +44, 55, 30.0, 5.96 },
    { 16,  8, 46.20, +44, 56,  6.0, 4.26 },
    {  5, 59, 31.70, +44, 56, 51.0, 1.90 },
    {  3, 50,  4.49, +44, 58,  4.1, 5.66 },
    { 23, 42, 14.81, +44, 59, 30.8, 6.57 },
    {  0, 50, 18.31, +45,  0,  7.9, 6.15 },
    { 22,  6,  1.99, +45,  0, 51.8, 5.14 },
    { 23, 33, 42.70, +45,  3, 29.2, 6.24 },
    {  6, 57, 37.10, +45,  5, 39.1, 4.90 },
    { 11, 38, 44.90, +45,  6, 31.0, 6.44 },
    { 22,  5, 50.59, +45,  6, 43.9, 6.44 },
    { 19, 44, 58.49, +45,  7, 50.9, 2.87 },
    { 23, 19,  2.40, +45,  8, 13.9, 6.50 },
    { 23, 17, 16.61, +45,  9, 51.1, 6.43 },
    { 20, 53, 18.60, +45, 10, 54.8, 5.45 },
    { 22, 38, 17.50, +45, 10, 59.2, 6.40 },
    { 18, 15, 32.59, +45, 12, 33.8, 6.29 },
    { 10, 28, 36.50, +45, 12, 43.9, 6.35 },
    {  7, 21, 17.50, +45, 13, 41.2, 5.77 },
    {  0,  5,  9.89, +45, 13, 45.1, 6.70 },
    { 22,  6, 12.41, +45, 14, 55.0, 6.19 },
    {  0,  0, 43.70, +45, 15, 11.9, 6.38 },
    { 13,  5, 52.30, +45, 16,  7.0, 5.63 },
    { 15, 24,  5.11, +45, 16, 16.0, 6.01 },
    { 20, 41, 25.90, +45, 16, 49.1, 1.25 },
    {  8, 52, 11.59, +45, 18, 45.0, 5.99 },
    {  1, 43, 16.51, +45, 19, 19.9, 6.34 },
    {  1, 12, 34.01, +45, 20, 16.1, 6.11 },
    {  3, 16,  4.70, +45, 20, 44.9, 6.16 },
    { 17, 56, 48.41, +45, 21,  2.9, 6.02 },
    { 21, 36,  2.40, +45, 22, 28.9, 5.53 },
    { 23,  0, 34.39, +45, 22, 30.0, 6.50 },
    {  1, 38, 31.70, +45, 24,   .0, 6.36 },
    {  1, 27, 39.41, +45, 24, 24.1, 4.83 },
    {  9, 57, 56.90, +45, 24, 51.8, 6.30 },
    { 12, 45,  7.80, +45, 26, 25.1, 4.99 },
    { 22, 13, 49.30, +45, 26, 26.9, 5.53 },
    { 17, 58, 52.30, +45, 28, 34.0, 6.48 },
    { 23, 17, 56.11, +45, 29, 20.0, 6.48 },
    { 17, 59, 56.21, +45, 30,  5.0, 5.67 },
    { 21,  9, 58.61, +45, 30,  9.0, 6.63 },
    { 19, 40, 50.21, +45, 31, 30.0, 5.06 },
    { 11,  0, 14.69, +45, 31, 34.0, 5.47 },
    {  1, 22, 20.40, +45, 31, 44.0, 4.88 },
    { 20, 16,   .60, +45, 34, 45.8, 5.91 },
    { 20, 47, 20.81, +45, 34, 46.9, 6.40 },
    { 21, 33, 58.90, +45, 35, 30.8, 4.02 },
    { 16, 31, 47.30, +45, 35, 53.9, 5.65 },
    {  9, 28, 40.01, +45, 36,  5.0, 5.41 },
    {  8, 56, 49.99, +45, 37, 54.8, 5.74 },
    {  8, 27, 36.79, +45, 39, 11.2, 6.32 },
    { 20, 39, 23.11, +45, 40,   .8, 6.58 },
    {  3, 45, 59.30, +45, 40, 54.8, 5.66 },
    { 22,  8, 40.99, +45, 44, 30.8, 6.11 },
    { 14,  2, 12.19, +45, 45, 13.0, 6.27 },
    { 21, 42,  8.40, +45, 45, 56.9, 6.17 },
    { 19, 59, 20.50, +45, 46, 19.9, 5.92 },
    { 20, 22,  5.40, +45, 47, 42.0, 5.58 },
    {  6, 55, 15.19, +45, 49, 35.0, 6.34 },
    {  8, 41,  1.10, +45, 50,  2.0, 5.37 },
    {  0, 57, 39.70, +45, 50, 22.9, 6.12 },
    { 21,  2, 48.50, +45, 50, 56.0, 6.48 },
    { 21, 33, 17.90, +45, 51, 15.1, 6.25 },
    { 20, 29, 59.90, +45, 55, 43.0, 6.41 },
    {  5, 59, 56.09, +45, 56, 12.8, 4.26 },
    { 19, 39, 34.39, +45, 57, 29.2, 6.20 },
    { 16, 49, 14.21, +45, 58, 59.9, 4.82 },
    {  5, 16, 41.40, +45, 59, 53.2, 0.08 },
    { 17, 39, 27.89, +46,  0, 23.0, 3.80 },
    {  9, 48, 35.40, +46,  1, 16.0, 5.09 },
    { 13, 26, 16.61, +46,  1, 41.2, 5.88 },
    { 16,  2, 47.90, +46,  2, 12.1, 4.76 },
    {  3, 32, 26.30, +46,  3, 24.8, 5.31 },
    { 23,  7, 18.10, +46,  4,  5.2, 6.66 },
    {  0, 10, 19.30, +46,  4, 19.9, 5.03 },
    { 14, 16, 22.99, +46,  5, 17.9, 4.18 },
    {  3, 44, 40.90, +46,  5, 58.9, 6.11 },
    { 20, 48, 56.30, +46,  6, 51.1, 4.84 },
    { 14, 49, 18.70, +46,  6, 58.0, 5.74 },
    {  1, 44, 26.50, +46,  8, 22.9, 6.35 },
    { 21,  1, 10.90, +46,  9, 20.9, 5.37 },
    { 12, 57,  7.70, +46, 10, 36.8, 6.12 },
    {  7, 36, 31.61, +46, 10, 49.1, 5.65 },
    { 23, 37, 58.61, +46, 11, 58.9, 6.58 },
    { 10, 43, 32.90, +46, 12, 14.0, 5.18 },
    {  1, 47, 48.00, +46, 13, 46.9, 6.32 },
    { 17, 20, 21.10, +46, 14, 26.9, 5.59 },
    {  6, 56, 32.30, +46, 16, 27.1, 5.87 },
    { 16, 19, 44.40, +46, 18, 47.9, 3.89 },
    { 18, 46, 58.99, +46, 18, 54.0, 6.52 },
    { 20, 18, 49.61, +46, 19, 22.1, 6.45 },
    {  6, 18, 16.90, +46, 21, 38.2, 6.38 },
    { 23,  7, 39.31, +46, 23, 13.9, 5.33 },
    { 23, 58, 46.51, +46, 24, 47.2, 6.54 },
    { 23, 46,  2.11, +46, 25, 13.1, 4.95 },
    {  6, 17, 34.70, +46, 25, 27.1, 6.52 },
    { 23, 37, 33.89, +46, 27, 29.2, 3.82 },
    { 11, 55, 11.21, +46, 28, 10.9, 7.03 },
    {  2, 19, 10.90, +46, 28, 21.0, 6.21 },
    { 11, 55,  5.69, +46, 28, 36.8, 6.54 },
    {  4, 21, 33.19, +46, 29, 56.0, 4.85 },
    { 20, 46, 38.50, +46, 31, 54.1, 6.30 },
    { 22, 21,  1.61, +46, 32, 12.1, 4.57 },
    { 21, 29, 27.00, +46, 32, 26.2, 5.24 },
    { 16, 36, 11.21, +46, 36, 47.9, 5.79 },
    { 17, 52,  1.01, +46, 38, 35.9, 6.38 },
    { 11, 30, 25.01, +46, 39, 27.0, 6.35 },
    { 20, 49, 54.70, +46, 39, 40.0, 6.33 },
    {  6, 30,  3.00, +46, 41,  8.2, 5.90 },
    { 20, 33, 54.91, +46, 41, 38.0, 5.78 },
    {  6, 56, 55.99, +46, 42, 18.0, 5.86 },
    { 21, 25, 19.61, +46, 42, 51.8, 5.60 },
    { 20, 13, 37.90, +46, 44, 29.0, 3.79 },
    { 22,  5, 16.39, +46, 44, 40.9, 6.13 },
    { 10, 18, 58.99, +46, 45, 38.9, 6.43 },
    { 15, 38, 16.20, +46, 47, 52.1, 5.75 },
    { 20, 13, 18.00, +46, 48, 56.9, 4.83 },
    {  9, 17, 31.20, +46, 49,  1.9, 5.97 },
    { 23, 47, 33.19, +46, 49, 57.0, 6.07 },
    { 11, 38, 33.50, +46, 50,  3.1, 6.10 },
    { 20, 19, 56.11, +46, 50, 15.0, 6.50 },
    {  2, 51, 41.71, +46, 50, 30.8, 5.88 },
    { 21,  3, 43.30, +46, 51, 42.8, 6.32 },
    {  8, 43,   .19, +46, 54,  4.0, 6.22 },
    {  9, 34, 19.61, +46, 54,  7.9, 6.52 },
    { 19,  1, 26.40, +46, 56,  4.9, 5.01 },
    {  3, 29, 26.21, +46, 56, 16.1, 6.24 },
    {  5, 10, 42.89, +46, 57, 43.9, 5.68 },
    {  5, 20, 39.29, +46, 57, 50.0, 6.54 },
    { 19, 16, 51.41, +46, 59, 57.1, 6.00 },
    {  1, 30,  6.19, +47,  0, 25.9, 5.27 },
    {  0, 43, 28.10, +47,  1, 28.9, 4.94 },
    { 19, 51, 59.09, +47,  1, 39.0, 5.62 },
    {  9,  3, 37.49, +47,  9, 24.1, 3.60 },
    {  2, 56, 33.41, +47,  9, 50.0, 6.02 },
    { 22, 43,  4.49, +47, 10,  7.0, 6.39 },
    { 12, 54, 56.50, +47, 11, 48.1, 5.84 },
    { 15, 28, 44.50, +47, 12,  5.0, 6.15 },
    {  2, 59, 49.90, +47, 13, 14.9, 5.47 },
    {  7, 15, 50.09, +47, 14, 24.0, 5.58 },
    {  1,  9, 30.19, +47, 14, 30.8, 4.25 },
    { 15,  0, 38.71, +47, 16, 40.1, 6.37 },
    {  3,  7, 47.40, +47, 18, 29.9, 6.41 },
    {  2, 20, 41.40, +47, 18, 38.9, 6.11 },
    { 23, 55, 33.60, +47, 21, 20.9, 6.00 },
    {  1,  3,  1.51, +47, 22, 34.0, 6.45 },
    { 19, 51, 19.39, +47, 22, 37.9, 6.20 },
    {  2, 19, 16.80, +47, 22, 48.0, 5.30 },
    {  7, 54, 29.30, +47, 23, 10.0, 6.25 },
    {  6, 27, 51.10, +47, 24, 19.1, 6.56 },
    { 16, 53, 17.59, +47, 25,   .8, 6.00 },
    { 20, 55, 49.80, +47, 25,  4.1, 5.67 },
    {  1, 18, 10.20, +47, 25, 10.9, 6.25 },
    {  2, 14,  2.59, +47, 29,  3.1, 6.06 },
    { 20, 59, 49.61, +47, 31, 16.0, 4.74 },
    {  7, 54, 42.70, +47, 33, 52.9, 5.45 },
    { 17, 47,  8.11, +47, 36, 43.9, 6.43 },
    { 21,  6, 36.10, +47, 38, 53.9, 4.55 },
    { 15,  3, 47.40, +47, 39, 15.8, 4.76 },
    { 21, 10, 31.01, +47, 41, 30.8, 6.46 },
    { 22, 29, 31.80, +47, 42, 24.8, 4.36 },
    {  4,  8, 39.70, +47, 42, 45.0, 4.04 },
    { 20, 15, 28.30, +47, 42, 51.8, 3.98 },
    {  5, 36, 15.91, +47, 42, 55.1, 6.11 },
    {  3, 12, 26.40, +47, 43, 32.9, 6.33 },
    { 20, 12,  3.79, +47, 44, 12.8, 6.92 },
    {  7,  5,  9.00, +47, 46, 30.0, 6.38 },
    { 11, 46,  3.00, +47, 46, 45.8, 3.71 },
    {  3, 42, 55.51, +47, 47, 15.0, 3.01 },
    { 19, 53,  1.20, +47, 48, 27.0, 6.29 },
    {  2, 15, 57.89, +47, 48, 41.0, 6.33 },
    { 20, 47, 49.30, +47, 49, 54.8, 5.57 },
    {  0, 44, 26.40, +47, 51, 51.1, 5.67 },
    {  3, 55, 58.20, +47, 52, 17.0, 5.37 },
    {  1, 49, 15.70, +47, 53, 48.8, 5.82 },
    {  6,  0, 58.61, +47, 54,  6.8, 5.73 },
    { 19, 47, 26.81, +47, 54, 28.1, 6.12 },
    { 11, 30, 52.90, +47, 55, 45.1, 6.42 },
    { 19, 52,  7.20, +47, 55, 54.8, 5.91 },
    {  0, 17,  9.10, +47, 56, 51.0, 5.89 },
    { 21, 15, 36.79, +47, 58, 25.0, 6.46 },
    {  3, 30, 34.49, +47, 59, 43.1, 4.36 },
    { 14, 17, 49.20, +48,  0,  6.1, 6.32 },
    {  3, 32,  8.59, +48,  1, 25.0, 5.47 },
    {  8, 59, 12.41, +48,  2, 30.1, 3.14 },
    {  1, 16, 24.50, +48,  4, 55.9, 6.61 },
    {  3, 30, 37.01, +48,  6, 13.0, 5.82 },
    {  7, 41, 12.41, +48,  7, 54.1, 5.56 },
    { 15,  5, 25.80, +48,  9,  4.0, 5.57 },
    {  0, 11, 59.09, +48,  9,  9.0, 6.16 },
    { 19, 34, 39.91, +48,  9, 52.9, 6.67 },
    {  3, 13, 24.00, +48, 10, 36.8, 5.90 },
    {  7, 28, 51.60, +48, 11,  2.0, 5.72 },
    { 17, 20, 33.60, +48, 11, 17.9, 6.43 },
    {  3, 36, 29.40, +48, 11, 34.1, 4.23 },
    { 20,  4, 28.80, +48, 13, 46.9, 6.16 },
    { 22,  5, 51.19, +48, 13, 54.1, 6.27 },
    { 17, 26, 44.21, +48, 15, 36.0, 5.85 },
    {  2, 43,  1.90, +48, 15, 56.2, 6.48 },
    {  0, 44, 43.49, +48, 17,  3.8, 4.54 },
    {  4, 41, 24.10, +48, 18,  2.9, 5.67 },
    { 23, 19, 41.59, +48, 22, 50.9, 6.32 },
    { 17, 50,  3.31, +48, 23, 39.1, 6.68 },
    { 10, 19, 26.81, +48, 23, 48.8, 6.00 },
    {  4, 14, 53.90, +48, 24, 33.8, 4.14 },
    {  9, 42, 43.10, +48, 25, 52.0, 6.39 },
    { 18,  3,  9.00, +48, 27, 51.8, 6.21 },
    { 12, 48, 41.81, +48, 28,   .8, 6.27 },
    {  3, 44,  6.41, +48, 31, 25.0, 6.06 },
    {  9,  5, 24.10, +48, 31, 49.1, 5.95 },
    {  2, 53, 21.19, +48, 34,  9.8, 6.26 },
    { 17, 36, 37.61, +48, 35,  8.2, 5.37 },
    { 23, 19, 29.81, +48, 37, 31.1, 5.44 },
    {  1, 37, 59.59, +48, 37, 41.9, 3.57 },
    {  3, 53, 38.71, +48, 39,  2.2, 5.76 },
    { 21, 57,  2.21, +48, 40,  7.0, 6.42 },
    {  0, 55,  5.21, +48, 40, 43.0, 6.27 },
    { 22, 57,  4.49, +48, 41,  3.1, 5.43 },
    {  6, 11, 36.60, +48, 42, 40.0, 6.09 },
    {  6, 11, 36.50, +48, 42, 47.2, 6.82 },
    { 14, 49, 41.30, +48, 43, 14.2, 5.69 },
    {  1, 36, 27.19, +48, 43, 22.1, 5.92 },
    {  4, 51,  9.29, +48, 44, 26.9, 5.66 },
    { 18, 48, 16.10, +48, 46,  3.0, 6.12 },
    {  7, 37, 53.90, +48, 46, 25.0, 5.92 },
    { 10, 28,  3.79, +48, 47,  4.9, 6.44 },
    { 11, 31, 10.20, +48, 47, 21.1, 6.56 },
    {  6, 47, 39.60, +48, 47, 21.8, 5.22 },
    { 17,  4, 49.80, +48, 48, 15.1, 6.09 },
    { 21, 26, 51.60, +48, 50,  6.0, 5.31 },
    { 18, 54, 47.11, +48, 51, 34.9, 5.77 },
    {  0, 20,  5.21, +48, 51, 55.1, 6.52 },
    { 16, 38, 44.90, +48, 55, 41.9, 4.90 },
    { 20, 30,  3.50, +48, 57,  6.1, 4.95 },
    {  2, 19, 22.70, +48, 57, 19.1, 6.37 },
    {  6,  1, 43.10, +48, 57, 33.8, 5.96 },
    { 16, 30,  6.00, +48, 57, 38.9, 6.45 },
    { 12, 19, 48.70, +48, 59,  3.1, 5.29 },
    { 23, 17, 44.69, +49,  0, 55.1, 4.85 },
    { 13, 34, 27.31, +49,  0, 58.0, 4.70 },
    {  5, 57,  4.90, +49,  1, 45.8, 6.47 },
    { 16, 19, 11.21, +49,  2, 17.2, 5.91 },
    {  3, 28,  3.10, +49,  3, 46.1, 4.98 },
    {  3, 21, 52.61, +49,  4, 14.9, 5.93 },
    { 18, 47, 40.01, +49,  4, 30.0, 6.40 },
    {  3, 25, 57.41, +49,  7, 14.9, 6.09 },
    { 18, 21, 32.71, +49,  7, 18.1, 5.05 },
    { 23, 30,  7.39, +49,  7, 59.2, 6.17 },
    { 20, 56, 25.90, +49, 11, 44.9, 5.90 },
    {  1, 58, 33.60, +49, 12, 15.1, 5.69 },
    {  3, 31, 29.40, +49, 12, 34.9, 6.29 },
    {  7, 26, 42.79, +49, 12, 41.0, 4.64 },
    {  3, 23, 13.20, +49, 12, 47.9, 5.29 },
    { 20, 31, 18.79, +49, 13, 13.1, 5.44 },
    {  2, 44, 12.00, +49, 13, 41.9, 4.12 },
    { 19, 33, 41.59, +49, 15, 45.0, 5.96 },
    { 19, 37, 56.69, +49, 17,  3.8, 6.47 },
    {  6, 24, 53.90, +49, 17, 17.2, 4.91 },
    { 23,  7, 45.41, +49, 17, 44.9, 5.70 },
    { 21, 46, 47.59, +49, 18, 33.8, 4.23 },
    { 13, 47, 32.40, +49, 18, 47.9, 1.86 },
    { 21, 24, 55.51, +49, 19, 23.9, 6.58 },
    {  0, 39,  9.91, +49, 21, 15.8, 5.43 },
    { 22, 30,  6.50, +49, 21, 22.0, 6.40 },
    { 14, 34, 39.60, +49, 22,  5.9, 5.74 },
    { 20, 27,  2.30, +49, 22, 59.9, 5.69 },
    { 21, 22,   .41, +49, 23, 20.0, 5.69 },
    {  3, 31, 49.10, +49, 24,  2.9, 6.39 },
    { 23, 12, 33.00, +49, 24, 23.0, 4.52 },
    {  9, 33,  7.20, +49, 26, 19.0, 6.76 },
    { 14,  8, 17.30, +49, 27, 29.2, 5.25 },
    {  7, 18, 31.90, +49, 27, 54.0, 5.05 },
    { 11, 16, 41.90, +49, 28, 35.0, 5.88 },
    { 22, 24, 31.01, +49, 28, 35.0, 4.57 },
    { 13, 36, 39.79, +49, 29, 12.1, 6.49 },
    {  3, 29, 22.10, +49, 30, 32.0, 4.67 },
    { 21, 19, 28.80, +49, 30, 37.1, 5.76 },
    { 23, 41, 26.90, +49, 30, 43.9, 6.26 },
    { 19, 18, 37.70, +49, 34, 10.9, 6.31 },
    { 21, 42, 38.90, +49, 36,  1.1, 6.09 },
    {  3,  9,  4.01, +49, 36, 47.9, 4.05 },
    { 14, 56, 22.99, +49, 37, 43.0, 5.63 },
    {  7, 29, 55.99, +49, 40, 21.0, 5.36 },
    { 13, 18, 14.50, +49, 40, 54.8, 5.15 },
    { 17, 16, 48.60, +49, 41, 28.0, 7.48 },
    { 18,  7,  6.29, +49, 42, 38.2, 6.32 },
    { 18, 21,  7.10, +49, 43, 32.2, 6.40 },
    { 22, 56, 25.99, +49, 44,  1.0, 4.95 },
    { 17, 11, 40.20, +49, 44, 48.1, 6.04 },
    { 22,  8, 16.51, +49, 47, 47.0, 6.42 },
    {  9, 55, 43.01, +49, 49, 12.0, 5.27 },
    {  5, 45, 54.00, +49, 49, 35.0, 5.47 },
    { 14, 28, 37.80, +49, 50, 40.9, 5.59 },
    {  3, 28, 52.39, +49, 50, 53.9, 5.58 },
    { 19, 12,  4.61, +49, 51, 15.1, 6.75 },
    { 19, 12,  4.99, +49, 51, 22.0, 6.57 },
    {  3, 24, 19.39, +49, 51, 40.0, 1.79 },
    { 15, 59,  4.39, +49, 52, 52.0, 6.05 },
    {  6,  2, 48.70, +49, 54, 20.2, 6.05 },
    { 19,  5,  9.91, +49, 55, 23.9, 6.43 },
    {  5, 59, 21.79, +49, 55, 27.8, 5.89 },
    {  4, 43, 21.60, +49, 58, 26.0, 5.87 },
    { 21, 32, 56.59, +49, 58, 40.1, 5.75 },
    {  0,  1, 19.30, +49, 58, 54.1, 6.22 },
    {  2, 24, 24.89, +50,  0, 24.1, 5.19 },
    { 16, 56,  6.41, +50,  2, 20.0, 6.56 },
    {  4, 19, 13.30, +50,  2, 56.0, 5.45 },
    { 23,  4, 10.99, +50,  3,  7.9, 4.65 },
    { 15,  8, 19.51, +50,  3, 18.0, 6.39 },
    { 19, 15, 19.30, +50,  4, 14.9, 6.27 },
    { 22, 35, 53.40, +50,  4, 16.0, 6.29 },
    {  3, 19,  7.61, +50,  5, 42.0, 5.03 },
    { 20,  1, 21.60, +50,  6, 16.9, 5.05 },
    {  2, 20, 58.20, +50,  9,  5.0, 5.59 },
    { 19, 36, 26.50, +50, 13, 16.0, 4.48 },
    {  3, 18, 37.80, +50, 13, 19.9, 5.15 },
    { 20,  7, 11.50, +50, 13, 45.1, 6.54 },
    { 20, 15, 43.39, +50, 13, 58.1, 6.31 },
    { 19, 35, 55.90, +50, 14, 19.0, 6.52 },
    { 19, 23, 23.81, +50, 16, 17.0, 6.51 },
    {  2, 25, 37.39, +50, 16, 43.0, 4.71 },
    { 22, 31, 17.50, +50, 16, 57.0, 3.77 },
    {  4, 18, 14.59, +50, 17, 44.2, 4.61 },
    { 19, 31, 19.30, +50, 18, 24.1, 5.53 },
    { 20, 42, 12.60, +50, 20, 24.0, 5.39 },
    {  4,  6, 34.99, +50, 21,  5.0, 4.29 },
    { 21,  3, 25.99, +50, 21,  6.8, 6.37 },
    { 22, 52, 52.30, +50, 24, 42.8, 6.46 },
    { 15, 38, 34.30, +50, 25, 23.9, 5.84 },
    {  7, 44,  4.20, +50, 26,  2.0, 5.27 },
    { 20, 58, 30.10, +50, 27, 43.9, 5.61 },
    { 23, 39,  8.30, +50, 28, 18.1, 5.30 },
    {  0, 42,  3.89, +50, 30, 45.0, 4.80 },
    { 19, 41, 52.01, +50, 31,  3.0, 6.20 },
    { 13, 40, 23.21, +50, 31,  9.8, 6.32 },
    { 19, 41, 48.89, +50, 31, 31.1, 5.96 },
    { 19,  0, 13.70, +50, 32,  1.0, 5.38 },
    {  2, 27, 51.79, +50, 34, 10.9, 6.12 },
    { 13, 28, 11.71, +50, 35, 13.9, 6.80 },
    { 23, 14, 14.30, +50, 37,  4.1, 6.31 },
    { 11, 37, 52.99, +50, 37,  5.9, 6.14 },
    { 22, 50, 10.20, +50, 40, 36.8, 6.21 },
    {  1, 43, 39.60, +50, 41, 19.0, 4.07 },
    {  3, 56, 36.50, +50, 41, 43.1, 5.28 },
    { 18, 53, 13.61, +50, 42, 29.9, 4.92 },
    { 13, 37, 43.01, +50, 42, 52.9, 6.48 },
    { 13, 28, 45.70, +50, 43,  5.9, 6.43 },
    { 20, 56, 25.51, +50, 43, 43.0, 5.81 },
    {  3, 48, 18.29, +50, 44, 12.1, 6.14 },
    { 17, 49,  4.30, +50, 46, 52.0, 5.02 },
    {  1, 52,  9.41, +50, 47, 34.1, 5.79 },
    { 18, 58, 59.59, +50, 48, 33.8, 6.30 },
    { 18,  6, 53.50, +50, 49, 22.1, 6.29 },
    { 22, 11,  9.91, +50, 49, 23.9, 5.40 },
    { 17,  8, 17.11, +50, 50, 31.9, 6.46 },
    { 19, 56, 45.10, +50, 54,  9.0, 6.43 },
    {  4, 20, 11.50, +50, 55, 14.9, 5.55 },
    {  3, 16, 12.19, +50, 56, 16.1, 5.03 },
    {  0, 48, 50.09, +50, 58,  5.9, 4.89 },
    { 14,  2, 59.69, +50, 58, 18.8, 6.15 },
    { 22, 20, 39.60, +50, 58, 50.9, 6.42 },
    {  1,  4, 46.80, +51,  0, 36.0, 6.54 },
    {  1,  2, 18.41, +51,  2,  6.0, 6.47 },
    {  2, 13, 36.29, +51,  3, 56.9, 5.31 },
    { 20, 56, 12.89, +51,  4, 30.0, 6.63 },
    {  6, 13, 45.31, +51, 10, 21.0, 6.04 },
    { 21, 42,  5.69, +51, 11, 22.9, 4.67 },
    { 19, 34, 19.80, +51, 14, 12.1, 5.73 },
    {  2, 56, 50.59, +51, 15, 38.9, 6.22 },
    {  9, 20, 43.80, +51, 15, 58.0, 6.13 },
    { 14, 17, 21.10, +51, 18, 25.9, 6.20 },
    { 18, 19, 56.11, +51, 20, 52.1, 6.30 },
    { 14, 16,  9.89, +51, 22,  1.9, 4.75 },
    { 14, 49, 32.30, +51, 22, 28.9, 6.51 },
    { 23, 58, 24.79, +51, 23, 19.0, 4.80 },
    { 16, 28, 43.39, +51, 24, 28.1, 6.29 },
    {  7, 13, 23.40, +51, 25, 44.0, 5.47 },
    {  0, 17, 43.01, +51, 25, 59.2, 6.14 },
    { 20, 12, 31.80, +51, 27, 49.0, 6.01 },
    {  1, 52, 50.81, +51, 28, 28.9, 6.26 },
    { 17, 56, 36.41, +51, 29, 20.0, 2.23 },
    { 11,  0, 25.61, +51, 30,  6.8, 6.43 },
    {  8,  8, 27.41, +51, 30, 24.1, 4.84 },
    {  0, 50, 57.41, +51, 30, 29.2, 6.39 },
    {  5, 50, 56.40, +51, 30, 52.9, 6.29 },
    { 12, 30,  2.90, +51, 32,  8.2, 6.21 },
    { 22, 37, 22.39, +51, 32, 43.1, 4.63 },
    { 12, 24,  1.51, +51, 33, 43.9, 4.80 },
    {  0, 51, 33.70, +51, 34, 16.0, 6.21 },
    {  6,  4, 29.09, +51, 34, 23.9, 6.45 },
    {  9, 24, 55.70, +51, 34, 26.0, 6.31 },
    {  5,  6, 40.61, +51, 35, 52.1, 5.00 },
    {  9,  8, 52.30, +51, 36, 16.9, 4.48 },
    { 23, 50, 22.30, +51, 37, 18.1, 6.44 },
    {  9, 32, 51.41, +51, 40, 37.9, 3.17 },
    { 21, 34, 27.50, +51, 41, 53.9, 6.15 },
    { 19, 29, 42.29, +51, 43, 46.9, 3.79 },
    { 14, 13, 27.70, +51, 47, 16.1, 6.69 },
    { 14, 13, 28.99, +51, 47, 25.1, 4.54 },
    {  5, 56, 14.40, +51, 48, 14.0, 6.49 },
    { 17, 41, 21.79, +51, 49,  5.2, 5.99 },
    { 20,  5,  6.70, +51, 50, 21.8, 6.14 },
    { 14, 25, 11.81, +51, 51,  2.9, 4.05 },
    { 20, 34, 50.40, +51, 51, 15.1, 6.11 },
    { 10, 59, 17.90, +51, 52, 55.9, 6.17 },
    {  7, 24, 57.19, +51, 53, 13.9, 5.80 },
    { 20, 48, 42.70, +51, 54, 38.2, 6.29 },
    {  1, 50, 57.10, +51, 55, 59.9, 5.90 },
    { 15, 20,  5.21, +51, 57, 31.0, 5.66 },
    {  0, 24, 15.60, +52,  1, 12.0, 5.57 },
    {  9, 34, 49.51, +52,  3,  5.0, 4.50 },
    { 19, 59, 15.41, +52,  3, 20.9, 6.15 },
    { 13, 43, 54.70, +52,  3, 51.8, 6.02 },
    { 15, 36,  4.10, +52,  4, 10.9, 6.74 },
    { 18, 32, 11.40, +52,  6, 56.2, 6.56 },
    {  7, 17, 33.70, +52,  7, 50.9, 5.92 },
    { 18, 39, 52.80, +52, 11, 46.0, 6.00 },
    {  3,  8,  3.91, +52, 12, 47.9, 6.31 },
    { 22, 23, 33.60, +52, 13, 45.1, 4.43 },
    { 19,  2,  7.01, +52, 15, 40.0, 6.31 },
    { 17, 30, 25.99, +52, 18,  5.0, 2.79 },
    { 20, 31, 21.10, +52, 18, 34.9, 6.18 },
    { 19, 27, 25.90, +52, 19, 14.2, 5.75 },
    {  3,  0, 52.20, +52, 21,  6.1, 5.28 },
    {  3,  0, 53.40, +52, 21,  7.9, 6.74 },
    { 18, 33, 56.69, +52, 21, 13.0, 5.36 },
    { 15, 42, 50.69, +52, 21, 38.9, 5.51 },
    { 10,  5, 10.49, +52, 22, 14.9, 6.14 },
    { 20, 47, 52.80, +52, 24, 25.9, 6.27 },
    { 17, 10, 30.60, +52, 24, 32.0, 6.29 },
    { 19,  8, 25.80, +52, 25, 32.2, 5.81 },
    { 19, 55, 37.80, +52, 26, 20.0, 4.92 },
    {  1,  4,  2.40, +52, 30,  7.9, 5.99 },
    { 10, 52, 31.90, +52, 30, 13.0, 6.44 },
    { 22, 44, 49.20, +52, 31,  1.9, 6.55 },
    { 14, 15, 16.90, +52, 32,  8.9, 6.58 },
    { 10, 52, 30.79, +52, 33, 55.1, 6.65 },
    { 21, 31, 27.50, +52, 37, 12.0, 6.16 },
    {  6, 11, 46.01, +52, 38, 49.9, 6.30 },
    { 22, 59, 10.30, +52, 39, 15.8, 6.29 },
    {  0, 53, 47.59, +52, 41, 21.1, 6.27 },
    {  8, 39, 17.59, +52, 42, 42.1, 5.91 },
    { 13, 27, 59.50, +52, 44, 44.9, 6.34 },
    {  7,  5, 39.79, +52, 45, 29.2, 6.12 },
    {  2, 54, 15.50, +52, 45, 45.0, 3.95 },
    { 11, 16,  4.01, +52, 46, 23.2, 6.50 },
    { 23,  7, 10.10, +52, 48, 59.0, 6.11 },
    {  0, 31, 41.21, +52, 50, 21.8, 5.60 },
    {  4, 53,  9.79, +52, 50, 26.9, 6.41 },
    {  4, 56,  7.10, +52, 52,  9.8, 5.75 },
    { 22,  1, 50.59, +52, 52, 55.9, 5.78 },
    { 21, 26, 45.00, +52, 53, 55.0, 6.03 },
    { 16, 36, 11.50, +52, 54,  1.1, 5.53 },
    { 16,  2,  5.50, +52, 54, 56.9, 5.93 },
    { 13, 39, 30.41, +52, 55, 17.0, 5.46 },
    { 16, 36, 14.09, +52, 55, 27.1, 6.53 },
    { 16, 36, 13.70, +52, 55, 27.8, 5.08 },
    {  8, 39,   .00, +52, 55, 30.0, 6.42 },
    { 21, 30, 20.40, +52, 57, 29.2, 6.02 },
    { 18, 51, 34.99, +52, 58, 30.0, 5.51 },
    { 18, 46, 43.10, +52, 59, 17.2, 5.88 },
    { 19, 50, 37.70, +52, 59, 17.2, 5.03 },
    { 20, 46, 21.19, +52, 59, 43.1, 6.33 },
    {  2, 52, 52.01, +52, 59, 52.1, 6.36 },
    {  0, 25,  6.41, +53,  2, 48.8, 5.74 },
    { 12, 30, 50.11, +53,  4, 36.1, 6.21 },
    {  4, 39, 54.70, +53,  4, 46.9, 5.05 },
    {  8, 32, 33.50, +53,  6, 52.9, 6.24 },
    {  4, 59, 46.30, +53,  9, 20.2, 6.08 },
    { 20,  6, 13.80, +53,  9, 56.9, 5.85 },
    { 12, 17, 29.50, +53, 11, 28.0, 5.81 },
    { 23, 16, 42.29, +53, 12, 49.0, 5.54 },
    {  5, 14, 44.30, +53, 12, 50.0, 6.20 },
    {  8, 23, 48.50, +53, 13, 10.9, 5.51 },
    { 21,  3, 47.59, +53, 17, 10.0, 5.90 },
    {  6, 44, 11.59, +53, 17, 47.0, 6.27 },
    { 18, 23, 47.81, +53, 18,  2.9, 6.32 },
    { 22,  7, 25.51, +53, 18, 25.9, 6.14 },
    { 19, 17,  6.19, +53, 22,  7.0, 3.77 },
    { 19,  4, 55.20, +53, 23, 48.1, 5.38 },
    {  8, 38, 22.20, +53, 24,  5.0, 5.66 },
    { 17, 21, 45.41, +53, 25, 14.2, 5.67 },
    { 12, 14, 43.39, +53, 26,  4.9, 6.16 },
    {  6, 21, 46.10, +53, 27,  7.9, 5.36 },
    {  4, 39, 58.10, +53, 28, 23.2, 5.35 },
    {  5, 41, 20.30, +53, 28, 52.0, 6.23 },
    { 10, 33, 43.61, +53, 29, 51.0, 6.45 },
    {  1,  7,  9.50, +53, 29, 53.9, 6.38 },
    {  3,  4, 47.81, +53, 30, 23.0, 2.93 },
    {  2, 42, 59.69, +53, 31, 34.0, 5.84 },
    { 20, 24, 32.40, +53, 33,  6.8, 6.51 },
    { 21, 10, 15.60, +53, 33, 47.9, 5.73 },
    {  8, 20, 29.09, +53, 34, 27.8, 6.49 },
    {  5, 17, 17.81, +53, 35, 10.0, 6.50 },
    { 20, 20, 30.41, +53, 35, 46.0, 6.18 },
    {  4, 16, 43.10, +53, 36, 42.8, 5.19 },
    { 10, 39,  5.69, +53, 40,  5.9, 5.52 },
    { 11, 53, 49.80, +53, 41, 40.9, 2.44 },
    { 13, 53, 51.00, +53, 43, 43.0, 5.70 },
    {  4, 57, 17.21, +53, 45,  7.9, 4.47 },
    { 10, 20, 14.81, +53, 46, 45.1, 6.45 },
    { 17, 43, 59.30, +53, 48,  6.1, 5.75 },
    {  2, 10,  7.80, +53, 50, 35.2, 6.31 },
    { 22, 40, 18.41, +53, 50, 46.0, 5.93 },
    {  1, 40, 13.10, +53, 52,  5.9, 6.39 },
    { 18, 43, 28.99, +53, 52, 18.8, 6.11 },
    { 10,  4, 36.29, +53, 53, 30.1, 5.74 },
    {  0, 36, 58.30, +53, 53, 48.8, 3.66 },
    { 22, 42, 20.81, +53, 54, 32.0, 6.12 },
    {  4, 32,  1.80, +53, 54, 38.9, 5.77 },
    {  3, 25, 48.41, +53, 55, 18.1, 6.51 },
    { 15, 35, 16.30, +53, 55, 18.8, 5.97 },
    { 21, 17,  1.99, +53, 59, 51.0, 6.13 },
    {  4,  6, 36.60, +54,  0, 31.0, 6.31 },
    { 15, 26, 32.50, +54,  1, 12.0, 6.45 },
    {  9, 16, 11.30, +54,  1, 18.8, 4.83 },
    { 14, 38, 15.19, +54,  1, 23.9, 5.85 },
    { 22, 32, 18.79, +54,  2, 15.0, 6.35 },
    { 21, 37, 38.71, +54,  2, 31.9, 6.15 },
    {  9, 52,  6.41, +54,  3, 51.8, 4.59 },
    { 12, 56, 17.59, +54,  5, 57.8, 5.82 },
    {  7, 51,  5.71, +54,  7, 45.1, 6.02 },
    {  8, 18, 15.79, +54,  8, 37.0, 6.27 },
    {  0, 36,  8.30, +54, 10,  7.0, 5.08 },
    { 10, 20, 31.20, +54, 13,   .8, 6.00 },
    {  9,  4,   .41, +54, 17,  2.0, 5.75 },
    {  5, 59, 31.61, +54, 17,  4.9, 3.72 },
    { 18, 10, 31.61, +54, 17, 12.1, 5.95 },
    { 11, 30, 12.91, +54, 21, 42.1, 6.41 },
    {  9, 43,  7.01, +54, 21, 49.0, 6.47 },
    { 19, 19, 36.50, +54, 22, 34.0, 6.26 },
    {  5,  6, 22.01, +54, 24, 20.9, 7.24 },
    { 22, 48, 47.81, +54, 24, 54.0, 6.12 },
    {  5, 36, 35.21, +54, 25, 44.0, 5.73 },
    { 13, 46, 35.69, +54, 25, 58.1, 5.70 },
    { 17,  5, 19.80, +54, 28, 13.1, 5.83 },
    { 17,  5, 19.70, +54, 28, 13.1, 5.80 },
    {  2,  2, 18.10, +54, 29, 15.0, 5.04 },
    { 15, 37, 31.99, +54, 30, 32.0, 5.87 },
    {  0, 31, 46.39, +54, 31, 19.9, 4.73 },
    {  5, 59, 48.10, +54, 32, 49.9, 6.14 },
    { 15,  6, 16.70, +54, 33, 23.0, 5.25 },
    { 10, 53, 34.51, +54, 35,  6.0, 5.10 },
    { 15, 35, 57.10, +54, 37, 50.2, 5.74 },
    { 13, 40, 44.30, +54, 40, 54.1, 4.66 },
    { 15, 57, 47.40, +54, 44, 58.9, 4.95 },
    { 11, 35,  4.90, +54, 47,  7.1, 5.63 },
    {  4,  9, 22.39, +54, 49, 44.0, 6.18 },
    { 14, 18, 55.80, +54, 51, 51.1, 6.53 },
    { 21, 40, 43.30, +54, 52, 19.9, 6.20 },
    { 11, 12, 44.50, +54, 53, 39.1, 6.63 },
    {  0, 33, 10.39, +54, 53, 42.0, 5.93 },
    { 18, 44, 55.39, +54, 53, 48.1, 6.23 },
    {  1,  8, 16.39, +54, 55, 13.1, 5.17 },
    { 13, 23, 56.40, +54, 55, 18.1, 3.95 },
    { 13, 23, 55.49, +54, 55, 31.1, 2.27 },
    { 19, 38, 41.21, +54, 58, 26.0, 5.82 },
    {  3, 33, 39.00, +54, 58, 28.9, 5.98 },
    { 13, 25, 13.49, +54, 59, 17.2, 4.01 },
    {  2, 43,  2.81, +55,  6, 20.9, 5.77 },
    {  1, 51, 59.30, +55,  8, 51.0, 5.52 },
    {  1, 11,  6.19, +55,  8, 58.9, 4.33 },
    { 11, 41, 43.61, +55, 10, 21.0, 6.27 },
    { 17, 32, 16.01, +55, 10, 23.2, 4.87 },
    { 17, 32, 10.61, +55, 11,  3.1, 4.88 },
    { 15, 28, 56.81, +55, 11, 42.0, 6.43 },
    { 16, 24, 25.30, +55, 12, 18.0, 5.74 },
    {  7, 52, 36.60, +55, 12, 33.8, 6.38 },
    {  0, 45, 17.21, +55, 13, 18.1, 5.42 },
    { 23,  2, 43.80, +55, 14, 11.0, 6.50 },
    {  4, 55,  3.10, +55, 15, 33.1, 5.52 },
    {  7, 22, 52.10, +55, 16, 53.0, 5.45 },
    {  7, 22, 50.90, +55, 17,  3.8, 6.53 },
    {  0, 46, 15.10, +55, 18, 19.1, 6.52 },
    {  5, 59, 45.70, +55, 19, 14.9, 6.44 },
    { 13, 34,  7.30, +55, 20, 55.0, 5.60 },
    {  6, 34, 32.81, +55, 21, 11.2, 6.45 },
    {  2, 23, 51.79, +55, 21, 51.8, 6.28 },
    { 15, 47, 37.99, +55, 22, 36.1, 5.86 },
    { 20, 18, 24.79, +55, 23, 49.9, 5.76 },
    { 14, 32, 30.91, +55, 23, 52.1, 5.76 },
    { 21, 28, 52.70, +55, 25,  7.0, 6.12 },
    {  3, 30,   .19, +55, 27,  6.8, 5.09 },
    { 19, 42,  4.10, +55, 27, 47.9, 6.48 },
    { 15, 46, 34.80, +55, 28, 28.9, 5.92 },
    {  2, 29, 25.01, +55, 32, 11.0, 6.51 },
    { 18, 42, 37.90, +55, 32, 21.8, 5.04 },
    {  1, 53, 48.50, +55, 35, 53.2, 6.45 },
    {  4, 48,  7.01, +55, 36,  9.0, 6.26 },
    { 11, 46, 55.61, +55, 37, 41.9, 5.27 },
    { 19,  0, 43.39, +55, 39, 29.9, 5.48 },
    { 16, 42, 58.39, +55, 41, 25.1, 6.16 },
    {  6, 48, 12.89, +55, 42, 15.8, 6.33 },
    {  6, 48, 12.29, +55, 42, 15.8, 6.28 },
    { 23, 57,  8.50, +55, 42, 20.9, 5.55 },
    {  5, 54, 50.81, +55, 42, 24.8, 4.99 },
    { 12, 27, 35.11, +55, 42, 46.1, 5.70 },
    { 19, 31, 13.61, +55, 43, 54.8, 6.37 },
    {  9, 29, 47.59, +55, 44, 44.2, 6.45 },
    { 23, 59,   .50, +55, 45, 18.0, 4.88 },
    {  7, 36, 46.99, +55, 45, 19.1, 5.92 },
    { 21, 52,  1.01, +55, 47, 48.8, 5.71 },
    { 21, 17, 14.30, +55, 47, 53.2, 5.98 },
    { 23, 44, 48.31, +55, 47, 58.9, 6.51 },
    { 15, 52, 16.61, +55, 49, 36.1, 5.81 },
    { 16,  9, 25.99, +55, 49, 44.0, 6.49 },
    {  2, 22, 21.41, +55, 50, 44.2, 5.17 },
    { 11, 25, 57.10, +55, 51,  2.2, 5.75 },
    { 13, 45, 13.20, +55, 52, 45.8, 6.50 },
    {  2, 50, 41.81, +55, 53, 44.2, 3.76 },
    { 22, 49, 46.20, +55, 54, 10.1, 5.43 },
    {  3, 47, 32.21, +55, 55, 21.0, 6.10 },
    { 12, 54,  1.70, +55, 57, 34.9, 1.77 },
    { 17, 55, 23.71, +55, 58, 17.0, 6.10 },
    { 10, 30, 37.61, +55, 58, 50.2, 4.84 },
    { 20, 39,   .19, +56,  0, 18.0, 6.48 },
    { 16, 38,   .41, +56,  0, 56.2, 5.29 },
    { 20, 29, 27.10, +56,  4,  5.2, 5.91 },
    {  3,  5, 39.89, +56,  4,  7.0, 6.11 },
    { 22, 35, 51.79, +56,  4, 12.0, 6.38 },
    {  5, 46, 30.41, +56,  6, 56.2, 5.94 },
    {  6, 26, 25.80, +56, 17,  6.0, 5.64 },
    { 20,  5, 21.50, +56, 20, 29.0, 6.21 },
    { 22,  6, 13.49, +56, 20, 35.2, 6.39 },
    { 13,  0, 43.80, +56, 21, 59.0, 4.93 },
    { 11,  1, 50.50, +56, 22, 57.0, 2.37 },
    { 22, 26, 59.21, +56, 25, 59.9, 6.57 },
    {  8, 13, 50.21, +56, 27,  7.9, 5.85 },
    { 20, 44, 22.01, +56, 29, 17.2, 5.78 },
    {  7, 56, 26.81, +56, 30, 15.8, 6.72 },
    {  4, 21, 51.79, +56, 30, 24.1, 5.88 },
    {  0, 40, 30.50, +56, 32, 13.9, 2.23 },
    { 20, 13, 23.90, +56, 34,  4.1, 4.30 },
    {  5, 43,  1.61, +56, 34, 54.1, 6.05 },
    { 10, 51, 11.09, +56, 34, 55.9, 5.67 },
    { 18, 14, 41.11, +56, 35, 17.9, 6.37 },
    { 11, 55, 58.39, +56, 35, 55.0, 5.84 },
    {  2, 25, 16.01, +56, 36, 36.0, 6.25 },
    { 21, 54, 53.21, +56, 36, 41.0, 5.80 },
    { 22, 33, 40.61, +56, 37, 30.0, 5.71 },
    { 20, 26, 23.50, +56, 38, 20.0, 6.36 },
    { 21,  2,  9.10, +56, 40, 10.9, 5.83 },
    { 19, 56, 19.01, +56, 41, 12.8, 6.12 },
    { 16, 59, 21.50, +56, 41, 19.0, 6.03 },
    {  9, 21, 43.30, +56, 41, 57.1, 5.47 },
    {  3,  5, 32.40, +56, 42, 20.9, 4.76 },
    { 11, 29, 43.49, +56, 44, 15.0, 6.28 },
    {  9, 15, 49.90, +56, 44, 29.0, 5.27 },
    {  4, 48,   .31, +56, 45, 25.9, 5.30 },
    { 12, 25,  3.19, +56, 46, 39.0, 5.81 },
    { 20, 31, 46.51, +56, 46, 48.0, 6.14 },
    { 16, 45, 17.81, +56, 46, 54.8, 4.85 },
    { 22, 38, 37.90, +56, 47, 44.9, 5.21 },
    {  9, 59, 51.70, +56, 48, 42.8, 5.48 },
    { 22, 11, 48.79, +56, 50, 21.8, 5.24 },
    {  6, 37, 38.50, +56, 51, 27.0, 5.85 },
    { 19, 11, 40.51, +56, 51, 33.1, 5.12 },
    { 17, 53, 31.70, +56, 52, 22.1, 3.75 },
    { 20, 56, 16.99, +56, 53, 15.0, 6.23 },
    {  5, 50, 34.01, +56, 55,  8.0, 6.54 },
    {  3, 38, 19.70, +56, 55, 58.1, 6.30 },
    {  1,  7,   .19, +56, 56,  6.0, 6.43 },
    { 23,  0,  5.09, +56, 56, 43.1, 5.00 },
    { 12, 15, 25.61, +57,  1, 57.0, 3.31 },
    { 19, 43, 39.60, +57,  2, 33.0, 6.27 },
    { 22, 15,  1.99, +57,  2, 37.0, 4.19 },
    { 18, 32, 34.49, +57,  2, 44.2, 4.77 },
    { 12, 11, 44.90, +57,  3, 15.8, 6.43 },
    {  2, 16, 51.70, +57,  3, 19.1, 6.48 },
    { 14, 34, 15.91, +57,  3, 55.1, 6.48 },
    { 11, 21, 49.30, +57,  4, 30.0, 6.43 },
    {  7, 40, 49.51, +57,  4, 58.1, 6.06 },
    { 10, 35,  9.70, +57,  4, 58.1, 5.16 },
    {  2, 49, 30.79, +57,  5,  3.1, 6.25 },
    {  1, 44, 46.10, +57,  5, 21.1, 6.25 },
    { 23,  1, 30.70, +57,  6, 20.2, 6.20 },
    { 20, 43, 13.49, +57,  6, 51.1, 6.32 },
    {  3, 49, 19.61, +57,  7,  5.2, 6.46 },
    {  9, 46, 31.70, +57,  7, 41.2, 5.20 },
    {  3, 15, 48.00, +57,  8, 26.9, 5.79 },
    {  0, 10, 29.69, +57,  9, 56.2, 6.74 },
    { 23, 13, 16.99, +57, 10,  5.9, 5.56 },
    {  6, 46, 49.51, +57, 10,  9.1, 5.35 },
    { 10, 43, 43.30, +57, 11, 57.1, 5.80 },
    { 13, 40, 21.29, +57, 12, 27.0, 6.29 },
    { 22, 16, 26.50, +57, 13, 13.1, 5.88 },
    {  5, 32, 33.79, +57, 13, 16.0, 6.48 },
    { 23, 41, 54.50, +57, 15, 36.0, 6.24 },
    {  8,  2, 35.81, +57, 16, 25.0, 6.49 },
    { 22, 23,   .19, +57, 17,  3.8, 6.16 },
    { 17, 40, 36.19, +57, 18, 37.1, 6.77 },
    { 10, 46, 22.51, +57, 21, 56.9, 6.34 },
    { 23, 55, 33.70, +57, 24, 43.9, 6.00 },
    {  9, 57, 13.61, +57, 25,  5.9, 5.93 },
    { 23, 47,  1.90, +57, 27,  5.0, 5.51 },
    {  4, 15,  1.80, +57, 27, 37.1, 6.08 },
    { 18, 53, 46.30, +57, 29, 12.8, 6.22 },
    { 21, 38, 57.60, +57, 29, 21.1, 5.62 },
    { 23, 54, 22.99, +57, 29, 57.8, 4.54 },
    {  2, 18,  4.49, +57, 31,   .1, 5.98 },
    { 19, 53, 17.40, +57, 31, 25.0, 5.14 },
    {  1, 44, 17.90, +57, 32, 11.0, 6.21 },
    {  5, 23, 27.79, +57, 32, 39.8, 5.28 },
    { 17, 33, 31.70, +57, 33, 32.0, 6.17 },
    {  6, 57, 13.20, +57, 33, 47.9, 6.05 },
    { 20, 45, 21.10, +57, 34, 46.9, 4.51 },
    {  4, 27,   .91, +57, 35,  7.1, 6.32 },
    { 19, 20, 16.10, +57, 38, 43.1, 5.91 },
    {  2, 11, 28.99, +57, 38, 44.9, 6.36 },
    { 21, 59, 22.99, +57, 39, 29.9, 6.59 },
    { 19, 13, 55.20, +57, 42, 18.0, 4.99 },
    {  8, 20, 26.09, +57, 44, 35.9, 5.89 },
    { 19, 21, 25.39, +57, 46,   .8, 6.43 },
    { 18, 56, 45.00, +57, 48, 54.0, 5.66 },
    {  0, 49,  6.00, +57, 48, 56.9, 3.44 },
    {  4, 17,  8.21, +57, 51, 38.2, 5.71 },
    { 12, 20, 50.81, +57, 51, 50.0, 5.55 },
    {  3, 33, 41.21, +57, 52,  8.0, 6.37 },
    { 17, 30, 43.80, +57, 52, 35.0, 6.40 },
    {  2, 17, 59.90, +57, 53, 58.9, 5.75 },
    { 15, 39,  9.50, +57, 55, 27.8, 6.45 },
    { 16,  9,  2.90, +57, 56, 16.1, 6.33 },
    { 11, 40, 27.41, +57, 58, 14.2, 6.37 },
    {  3, 53, 43.30, +57, 58, 30.0, 5.80 },
    {  1, 38,  7.61, +57, 58, 39.0, 5.56 },
    {  0, 56, 12.91, +57, 59, 48.1, 6.21 },
    { 22,  2,  4.61, +58,  0,  2.2, 5.56 },
    { 19, 43, 14.59, +58,  0, 59.0, 6.22 },
    { 19, 25, 46.70, +58,  1, 37.9, 6.60 },
    {  5, 19, 27.79, +58,  7,  1.9, 6.13 },
    {  1, 23, 21.60, +58,  8, 35.2, 6.45 },
    {  6, 30, 47.21, +58,  9, 46.1, 5.88 },
    { 22, 10, 51.29, +58, 12,  4.0, 3.35 },
    { 18, 57, 28.39, +58, 13, 31.1, 6.46 },
    {  1, 20,  4.90, +58, 13, 54.1, 4.98 },
    {  8, 10,  3.79, +58, 14, 53.2, 5.93 },
    { 19, 55, 22.10, +58, 15,  1.1, 6.09 },
    {  1,  8, 33.31, +58, 15, 49.0, 5.79 },
    {  2, 51, 45.50, +58, 18, 52.9, 6.45 },
    {  1, 33, 25.80, +58, 19, 39.0, 5.70 },
    { 12, 29, 57.31, +58, 24, 20.9, 5.35 },
    { 22, 29, 10.30, +58, 24, 55.1, 3.75 },
    {  6, 26, 48.91, +58, 25,  1.9, 5.21 },
    {  6, 57, 16.49, +58, 25, 21.0, 4.35 },
    {  2,  8, 40.51, +58, 25, 25.0, 5.67 },
    {  0,  6, 16.01, +58, 26, 12.1, 5.96 },
    { 22, 47, 23.21, +58, 28, 58.1, 6.36 },
    { 13, 50, 27.70, +58, 32, 21.8, 6.46 },
    { 23, 30,  1.99, +58, 32, 56.0, 4.91 },
    {  2, 13, 41.50, +58, 33, 40.0, 6.44 },
    { 23,  3, 21.60, +58, 33, 52.9, 6.43 },
    { 16,  1, 53.30, +58, 33, 55.1, 4.01 },
    { 21, 17, 18.79, +58, 36, 42.1, 6.42 },
    { 21, 19, 15.79, +58, 37, 25.0, 5.66 },
    {  1, 42, 17.81, +58, 37, 40.1, 6.37 },
    { 17, 26,  4.90, +58, 39,  6.8, 6.51 },
    { 23, 47,  3.50, +58, 39,  6.8, 4.87 },
    {  7, 43,   .41, +58, 42, 37.1, 4.99 },
    {  0, 42, 31.10, +58, 45, 11.9, 6.17 },
    {  3, 33, 32.11, +58, 45, 54.0, 6.40 },
    { 12, 30,  4.30, +58, 46,  3.0, 6.08 },
    { 21, 43, 30.41, +58, 46, 48.0, 4.08 },
    { 18, 23, 54.50, +58, 48,  2.2, 4.98 },
    { 22,  7,  9.60, +58, 50, 26.9, 6.32 },
    { 19, 55, 55.39, +58, 50, 46.0, 4.96 },
    {  3, 29, 54.89, +58, 52, 43.0, 4.54 },
    { 15, 55, 49.70, +58, 54, 42.1, 6.31 },
    {  6,  9, 59.09, +58, 56,  8.9, 5.36 },
    { 23, 49, 12.00, +58, 57, 47.2, 6.33 },
    {  5, 52, 17.40, +58, 57, 51.1, 6.14 },
    { 15, 24, 55.80, +58, 57, 58.0, 3.29 },
    {  5,  6,  8.50, +58, 58, 21.0, 5.08 },
    {  0, 55,   .10, +58, 58, 22.1, 4.83 },
    {  6, 19, 37.39, +59,  0, 38.9, 4.48 },
    {  5,  6, 12.19, +59,  1, 16.0, 6.08 },
    {  9, 50, 59.40, +59,  2, 19.0, 3.80 },
    {  8,  1, 20.71, +59,  2, 51.0, 5.77 },
    {  8, 53,  5.90, +59,  3, 22.0, 6.25 },
    { 22, 11, 56.90, +59,  5,  4.9, 6.30 },
    {  0,  9, 10.70, +59,  8, 58.9, 2.27 },
    {  4,  4, 27.19, +59,  9, 20.2, 5.06 },
    {  0, 56, 39.79, +59, 10, 52.0, 4.63 },
    {  1, 33, 55.90, +59, 13, 54.8, 4.71 },
    { 21, 42, 45.41, +59, 16, 16.0, 6.08 },
    { 14, 51, 26.40, +59, 17, 38.0, 5.46 },
    { 10, 51, 23.71, +59, 19, 12.0, 5.58 },
    { 23,  9, 44.09, +59, 19, 59.2, 5.70 },
    { 14,  8, 46.01, +59, 20, 16.1, 6.46 },
    {  9,  6, 43.10, +59, 20, 39.8, 6.45 },
    {  3, 30, 11.30, +59, 21, 58.0, 6.13 },
    {  6, 22,  3.60, +59, 22, 19.9, 5.94 },
    { 18, 51, 12.10, +59, 23, 17.9, 4.66 },
    {  6,  5,  8.30, +59, 23, 35.2, 6.34 },
    {  5, 15, 11.30, +59, 24, 20.2, 6.15 },
    { 16,  3,  9.31, +59, 24, 38.9, 6.19 },
    { 22, 11, 30.70, +59, 24, 51.8, 5.04 },
    { 23,  6, 36.89, +59, 25, 10.9, 4.85 },
    { 20, 59, 25.39, +59, 26, 19.0, 5.51 },
    {  6, 46, 14.09, +59, 26, 30.1, 4.87 },
    {  6, 53,  5.09, +59, 26, 55.0, 5.33 },
    { 12, 36, 23.30, +59, 29, 12.8, 5.50 },
    {  4, 43, 18.10, +59, 31, 14.9, 6.50 },
    { 18, 27, 42.29, +59, 32, 57.1, 6.43 },
    {  0,  0, 30.89, +59, 33, 34.9, 6.19 },
    {  8, 17, 50.40, +59, 34, 16.0, 5.64 },
    {  0, 46, 42.41, +59, 34, 27.8, 6.39 },
    { 20, 25,  5.09, +59, 36,   .0, 6.44 },
    {  4, 22, 57.89, +59, 36, 59.0, 6.19 },
    {  7, 15, 54.91, +59, 38, 15.0, 5.20 },
    { 19, 53, 35.40, +59, 42, 32.0, 6.06 },
    { 13,  2, 40.39, +59, 42, 58.0, 6.53 },
    { 23,  7, 10.39, +59, 43, 39.0, 6.40 },
    { 21, 27, 25.30, +59, 45,   .0, 6.10 },
    { 16, 17, 15.31, +59, 45, 18.0, 5.40 },
    {  7,  6,  1.30, +59, 48,  6.8, 6.44 },
    { 22, 59,  9.00, +59, 48, 52.9, 6.43 },
    {  5, 54, 57.79, +59, 53, 17.9, 5.20 },
    {  7, 22, 17.21, +59, 54,  6.8, 6.35 },
    {  4,  9, 27.60, +59, 54, 29.2, 6.28 },
    {  8, 39, 10.20, +59, 56, 21.8, 6.48 },
    {  3, 29,  4.10, +59, 56, 25.1, 4.21 },
    { 13, 28, 27.10, +59, 56, 44.9, 5.40 },
    {  3, 42, 42.70, +59, 58,  9.8, 5.76 },
    {  0, 30, 19.90, +59, 58, 37.9, 5.94 },
    { 23, 48, 53.90, +59, 58, 44.0, 6.34 },
    { 10, 15,  7.70, +59, 59,  8.2, 6.25 },
    { 21, 11, 48.19, +59, 59, 11.0, 5.64 },
    {  6, 15, 40.61, +59, 59, 57.1, 5.35 },
    { 23, 57, 33.50, +60,  1, 25.0, 6.47 },
    {  3, 35,   .79, +60,  2, 28.0, 6.46 },
    { 17, 25, 41.30, +60,  2, 53.9, 5.65 },
    { 22, 53,  3.79, +60,  6,  4.0, 6.01 },
    { 23, 22, 32.50, +60,  8,  1.0, 5.56 },
    { 19, 33, 10.10, +60,  9, 31.0, 6.29 },
    { 15,  1, 27.10, +60, 12, 15.8, 5.93 },
    { 14, 31, 42.79, +60, 13, 32.2, 6.27 },
    {  1, 25, 49.01, +60, 14,  7.1, 2.68 },
    {  3, 28, 23.59, +60, 15, 20.2, 6.49 },
    { 12, 48, 39.41, +60, 19, 12.0, 5.85 },
    {  8,  1, 42.41, +60, 19, 27.8, 6.01 },
    {  0, 36, 27.31, +60, 19, 34.0, 5.79 },
    {  0, 56, 47.09, +60, 21, 46.1, 5.55 },
    {  8, 15, 50.50, +60, 22, 50.2, 6.45 },
    { 18, 11,  7.10, +60, 24, 33.8, 6.49 },
    {  5,  3, 25.10, +60, 26, 31.9, 4.03 },
    { 23,  3, 23.71, +60, 26, 43.1, 6.74 },
    { 21, 30, 59.30, +60, 27, 33.8, 5.53 },
    { 20, 40, 17.90, +60, 30, 19.1, 6.01 },
    { 19, 40, 13.01, +60, 30, 25.9, 6.51 },
    {  1, 43, 19.70, +60, 33,  4.0, 5.78 },
    { 20, 42, 39.70, +60, 36,  5.0, 6.15 },
    {  8, 22, 44.09, +60, 37, 52.0, 6.41 },
    { 20, 13, 27.70, +60, 38, 26.2, 5.79 },
    { 17,  1, 16.70, +60, 38, 57.1, 6.13 },
    { 15, 27, 51.41, +60, 40, 13.1, 5.90 },
    { 17, 16, 29.40, +60, 40, 14.2, 6.32 },
    { 21, 47, 25.30, +60, 41, 34.1, 5.52 },
    {  0, 56, 42.50, +60, 43,   .1, 2.47 },
    {  8, 30, 15.91, +60, 43,  5.2, 3.36 },
    {  4, 21, 47.59, +60, 44,  8.2, 5.39 },
    { 21, 20, 33.50, +60, 45, 24.8, 6.11 },
    { 22, 12,  1.90, +60, 45, 33.8, 5.35 },
    { 16, 32, 25.70, +60, 49, 23.9, 5.94 },
    {  1, 42,  3.00, +61,  2, 17.9, 6.71 },
    { 18, 44, 18.19, +61,  2, 53.2, 5.99 },
    {  1,  3, 37.01, +61,  4, 30.0, 5.92 },
    {  5,  1, 35.90, +61,  4, 41.2, 6.03 },
    { 11, 32, 20.81, +61,  4, 57.0, 5.48 },
    {  3, 57,  8.30, +61,  6, 32.0, 5.00 },
    {  9, 55,  3.41, +61,  6, 58.0, 6.27 },
    { 21, 45, 26.90, +61,  7, 14.9, 4.29 },
    {  0, 53,  4.10, +61,  7, 27.1, 4.82 },
    { 12, 43,  4.20, +61,  9, 20.2, 6.38 },
    {  5,  6, 29.69, +61, 10, 12.0, 6.04 },
    {  0,  1, 36.91, +61, 13, 23.2, 5.55 },
    { 14, 42,  3.19, +61, 15, 42.8, 6.25 },
    { 21, 49, 19.01, +61, 16, 22.1, 6.17 },
    {  0,  5,  6.19, +61, 18, 51.1, 5.80 },
    {  1, 42, 58.39, +61, 25, 18.1, 6.34 },
    {  9, 14, 20.59, +61, 25, 23.9, 5.13 },
    { 11, 58, 20.59, +61, 27, 52.9, 6.76 },
    {  5, 44,  8.59, +61, 28, 36.1, 6.15 },
    {  6, 37, 41.40, +61, 28, 52.0, 5.94 },
    { 13, 49, 45.50, +61, 29, 21.1, 5.96 },
    { 13, 57, 32.09, +61, 29, 34.1, 6.37 },
    { 16, 23, 59.50, +61, 30, 51.1, 2.74 },
    {  6, 17, 54.79, +61, 30, 55.1, 4.98 },
    {  2, 55, 56.90, +61, 31, 16.0, 5.59 },
    {  0, 16, 57.10, +61, 31, 59.9, 5.74 },
    { 21, 55, 20.69, +61, 32, 30.8, 6.13 },
    { 11, 56, 53.21, +61, 32, 57.1, 6.22 },
    {  1,  4, 19.61, +61, 34, 49.1, 5.84 },
    { 23, 42, 31.51, +61, 40, 45.8, 6.40 },
    { 16, 23, 46.99, +61, 41, 48.1, 5.67 },
    { 22, 51, 22.80, +61, 41, 48.8, 5.60 },
    {  1, 58, 33.31, +61, 41, 53.2, 6.02 },
    {  1, 13,  9.91, +61, 42, 20.9, 6.41 },
    { 11,  3, 43.70, +61, 45,  2.9, 1.79 },
    { 11, 29,  4.61, +61, 46, 41.9, 5.83 },
    {  0, 51, 16.39, +61, 48, 20.9, 6.07 },
    {  0, 24, 47.50, +61, 49, 52.0, 5.40 },
    { 20, 45, 17.40, +61, 50, 20.0, 3.43 },
    {  5, 13,  3.19, +61, 51,   .0, 6.17 },
    {  4, 16, 53.59, +61, 51,  1.1, 5.70 },
    { 17, 34, 59.50, +61, 52, 30.0, 5.23 },
    {  8, 53, 22.61, +61, 57, 43.9, 5.73 },
    { 23, 16, 26.81, +61, 57, 47.2, 6.53 },
    { 23, 20, 14.30, +61, 58, 12.0, 6.45 },
    { 20,  5, 32.81, +61, 59, 44.2, 5.39 },
    { 13,  6, 22.70, +62,  2, 30.8, 6.14 },
    { 15, 22, 37.30, +62,  2, 49.9, 5.98 },
    { 20, 11, 34.90, +62,  4, 43.0, 5.75 },
    { 21, 37, 55.20, +62,  4, 54.8, 4.73 },
    { 15, 29, 21.19, +62,  5, 58.9, 6.38 },
    { 23, 20, 34.61, +62, 12, 47.2, 6.39 },
    { 23, 48, 50.21, +62, 12, 51.8, 5.43 },
    { 13,  9, 50.21, +62, 13, 45.1, 6.54 },
    { 20, 19, 36.70, +62, 15, 27.0, 5.72 },
    { 15, 27, 40.80, +62, 16, 32.2, 6.50 },
    { 22,  5,  8.90, +62, 16, 48.0, 5.11 },
    { 23, 24, 50.30, +62, 16, 58.1, 4.98 },
    {  0,  4, 13.61, +62, 17, 16.1, 5.88 },
    {  4,  7, 51.10, +62, 19, 48.0, 6.99 },
    { 18, 57, 17.40, +62, 23, 48.1, 6.45 },
    { 22, 23,   .19, +62, 25, 12.0, 6.04 },
    { 21, 44, 53.30, +62, 27, 38.2, 5.95 },
    { 22,  0, 39.31, +62, 29, 17.2, 6.66 },
    {  8, 19, 17.30, +62, 30, 25.9, 5.71 },
    { 18, 37, 33.50, +62, 31, 36.1, 5.74 },
    { 19, 26, 26.50, +62, 33, 25.9, 6.38 },
    { 21, 18, 34.80, +62, 35,  8.2, 2.44 },
    { 15, 46, 40.01, +62, 35, 57.8, 5.19 },
    {  5, 20, 22.61, +62, 39, 13.0, 5.61 },
    {  5, 13, 31.30, +62, 41, 29.0, 6.50 },
    { 21, 58, 53.40, +62, 41, 53.9, 5.93 },
    { 12, 41, 33.91, +62, 42, 47.2, 6.07 },
    { 18, 40, 56.30, +62, 44, 58.9, 6.09 },
    {  1,  6, 22.80, +62, 45, 42.1, 6.54 },
    { 12, 47, 18.91, +62, 46, 50.9, 5.89 },
    { 22,  5,   .50, +62, 47,  8.2, 5.27 },
    { 22, 18, 12.70, +62, 48, 15.8, 5.75 },
    {  5, 49,  4.90, +62, 48, 29.2, 6.13 },
    {  7, 46, 27.41, +62, 49, 50.2, 6.49 },
    { 17, 12, 32.59, +62, 52, 27.8, 5.56 },
    {  0, 33,   .00, +62, 55, 54.1, 4.16 },
    { 12,  5, 39.70, +62, 55, 59.2, 6.13 },
    { 22, 48, 44.21, +62, 56, 17.9, 6.06 },
    { 20, 29, 34.90, +62, 59, 39.1, 4.22 },
    {  9, 31, 31.70, +63,  3, 42.8, 3.67 },
    {  5, 30, 10.20, +63,  4,  1.9, 5.42 },
    {  3, 57, 25.51, +63,  4, 19.9, 5.03 },
    { 16, 36, 55.01, +63,  4, 22.1, 6.16 },
    {  8,  2, 30.79, +63,  5, 25.1, 6.40 },
    { 22,  3, 52.90, +63,  7, 10.9, 5.29 },
    { 22, 13, 49.49, +63,  9, 45.0, 6.11 },
    { 14, 30, 46.10, +63, 11,  8.2, 6.09 },
    {  3, 42,  9.29, +63, 13,   .1, 5.10 },
    { 13, 25, 59.90, +63, 15, 40.0, 6.50 },
    { 22, 12, 22.30, +63, 17, 29.0, 5.79 },
    { 21,  9, 28.90, +63, 17, 44.2, 6.54 },
    {  3, 49, 36.70, +63, 17, 49.9, 5.85 },
    { 15, 22, 38.40, +63, 20, 29.0, 5.79 },
    {  3, 46,  2.30, +63, 20, 42.0, 4.80 },
    { 11,  1,  5.81, +63, 25, 16.0, 6.39 },
    {  6,  6, 39.19, +63, 27, 13.0, 6.39 },
    {  4, 52,  5.21, +63, 30, 19.1, 5.44 },
    {  9, 10, 55.10, +63, 30, 49.0, 4.67 },
    { 19, 58, 28.70, +63, 32,  3.1, 5.96 },
    { 22, 38, 39.00, +63, 35,  3.8, 5.19 },
    { 13,  1, 46.80, +63, 36, 37.1, 6.00 },
    { 21, 56, 39.10, +63, 37, 32.2, 4.91 },
    { 23,  7, 47.71, +63, 37, 59.9, 6.26 },
    {  0,  3, 25.70, +63, 38, 30.8, 6.24 },
    {  9, 45, 55.39, +63, 39, 11.9, 6.34 },
    {  1, 54, 23.69, +63, 40, 12.0, 3.38 },
    { 12, 25,  6.41, +63, 48, 10.1, 6.32 },
    {  1, 47, 44.81, +63, 51,  7.9, 5.63 },
    { 20,  4, 44.59, +63, 53, 26.2, 6.26 },
    {  9, 25, 44.21, +63, 56, 26.9, 6.28 },
    { 20, 21, 11.40, +63, 58, 49.1, 5.69 },
    { 20, 49, 17.40, +64,  2, 31.9, 6.45 },
    {  3,  7, 19.01, +64,  3, 28.1, 5.89 },
    { 22, 28, 19.70, +64,  5,  8.2, 6.29 },
    {  0, 25, 17.90, +64,  8, 36.0,      },
    {  5, 37, 15.10, +64,  9, 16.9, 6.15 },
    {  0,  6, 26.50, +64, 11, 46.0, 5.59 },
    {  1, 11, 25.61, +64, 12, 10.1, 5.55 },
    { 15, 30, 55.70, +64, 12, 31.0, 5.79 },
    { 23,  7, 57.19, +64, 13, 21.0, 6.21 },
    {  0, 50, 43.61, +64, 14, 51.0, 5.39 },
    { 10, 30, 26.59, +64, 15, 27.0, 6.12 },
    {  4, 36, 24.19, +64, 15, 42.1, 5.94 },
    {  8, 40, 12.79, +64, 19, 40.1, 4.60 },
    { 11, 22, 51.29, +64, 19, 50.2, 6.02 },
    {  2, 56, 24.79, +64, 19, 57.0, 6.24 },
    {  2, 20, 12.89, +64, 20, 13.9, 6.60 },
    { 11, 38, 49.20, +64, 20, 48.8, 6.46 },
    { 14,  4, 23.30, +64, 22, 32.9, 3.65 },
    {  2,  3,   .29, +64, 23, 24.0, 5.58 },
    { 19, 19, 46.10, +64, 23, 26.9, 6.52 },
    { 18, 13, 53.81, +64, 23, 49.9, 5.03 },
    { 21, 13, 42.60, +64, 24, 14.0, 6.39 },
    { 23, 42, 20.81, +64, 30, 56.2, 6.56 },
    {  3, 24, 40.51, +64, 35, 10.0, 5.23 },
    { 16, 40, 55.10, +64, 35, 21.1, 4.83 },
    { 17,  2, 15.31, +64, 36,  2.2, 6.10 },
    {  8, 56, 37.49, +64, 36, 14.0, 5.58 },
    {  1, 59, 37.99, +64, 37, 17.0, 5.26 },
    { 22,  3, 47.40, +64, 37, 40.1, 4.29 },
    { 20,  2, 20.30, +64, 38,  3.8, 6.57 },
    {  1, 21,  5.21, +64, 39, 29.9, 6.34 },
    { 13, 27, 10.70, +64, 43,  9.8, 7.04 },
    { 13, 51, 25.90, +64, 43, 23.9, 4.65 },
    { 13, 27,  4.61, +64, 44,  8.2, 6.66 },
    { 20,  1, 28.49, +64, 49, 16.0, 5.27 },
    { 13, 41, 29.90, +64, 49, 21.0, 5.85 },
    {  9, 12,  2.60, +64, 51, 47.0,      },
    { 21, 19, 22.20, +64, 52, 18.8, 5.18 },
    { 23, 48, 39.00, +64, 52, 35.0, 6.41 },
    {  2,  2, 52.70, +64, 54,  5.0, 6.00 },
    {  5,  9, 44.50, +64, 55,  9.8, 6.41 },
    {  9, 44, 36.70, +64, 59,  2.0, 6.17 },
    {  1, 11, 41.40, +65,  1,  8.0, 5.57 },
    {  8, 39, 11.71, +65,  1, 14.9, 5.64 },
    { 16, 56, 25.20, +65,  2, 21.1, 6.41 },
    {  2,  4, 40.10, +65,  6, 11.9, 6.52 },
    { 10, 18,  1.99, +65,  6, 29.9, 5.82 },
    { 10, 48, 49.99, +65,  7, 55.9, 6.39 },
    { 22, 27,  5.30, +65,  7, 55.9, 5.46 },
    { 16, 56,  1.70, +65,  8,  4.9, 4.89 },
    {  4, 20, 40.30, +65,  8, 26.2, 5.27 },
    {  8, 34, 36.19, +65,  8, 42.0, 5.47 },
    { 18, 56, 25.61, +65, 15, 29.2, 5.63 },
    { 21, 55, 31.10, +65, 19, 14.9, 5.86 },
    { 18, 31, 14.81, +65, 26, 10.0, 6.59 },
    { 12, 55, 28.49, +65, 26, 19.0, 5.24 },
    {  7, 46, 40.10, +65, 27, 20.9, 5.92 },
    { 18, 36, 13.30, +65, 29, 19.0, 6.06 },
    {  4,  6, 39.00, +65, 31, 14.9, 6.17 },
    {  3, 49, 31.20, +65, 31, 34.0, 4.47 },
    { 18, 25, 59.09, +65, 33, 49.0, 4.82 },
    { 10, 24,  7.90, +65, 33, 59.0, 4.97 },
    {  9, 50, 23.71, +65, 35, 35.9, 6.31 },
    { 10, 29, 54.31, +65, 37, 34.0, 6.32 },
    {  3, 19, 59.40, +65, 39,  7.9, 4.84 },
    {  3, 17, 31.61, +65, 39, 31.0, 6.36 },
    {  5, 42, 26.40, +65, 41, 52.1, 5.60 },
    { 19, 20, 40.10, +65, 42, 52.9, 4.59 },
    { 17,  8, 47.21, +65, 42, 52.9, 3.17 },
    { 10, 41, 56.59, +65, 42, 59.0, 5.12 },
    {  6, 12, 51.10, +65, 43,  5.9, 5.32 },
    {  2, 37, 36.10, +65, 44, 44.2, 5.78 },
    { 21, 51, 37.30, +65, 45, 10.1, 6.37 },
    { 15,  3, 57.79, +65, 55, 10.9, 6.13 },
    { 14, 57, 34.99, +65, 55, 57.0, 4.60 },
    { 19,  9, 45.79, +65, 58, 43.0, 6.25 },
    {  5, 57, 34.99, +66,  5, 46.0, 6.25 },
    {  1, 30, 52.30, +66,  5, 53.2, 6.14 },
    {  0,  2, 36.10, +66,  5, 56.0, 5.86 },
    {  0, 42,  3.41, +66,  8, 51.0, 5.83 },
    { 21, 57, 11.11, +66,  9, 22.0, 6.43 },
    { 22, 49, 40.80, +66, 12,  2.2, 3.52 },
    {  7, 27, 25.80, +66, 19, 54.1, 6.47 },
    {  4, 54,  3.00, +66, 20, 34.1, 4.29 },
    {  0, 58, 31.10, +66, 21,  7.9, 5.97 },
    {  0, 31, 25.30, +66, 31,  9.8, 6.18 },
    {  2, 14, 29.11, +66, 31, 27.8, 6.07 },
    { 12, 59, 55.10, +66, 35, 49.9, 5.32 },
    { 20, 43, 10.99, +66, 39, 27.0, 5.58 },
    {  5, 37, 16.20, +66, 41, 46.0, 6.26 },
    {  8, 48, 49.39, +66, 42, 29.2, 6.20 },
    {  0,  3, 51.91, +66, 42, 43.9, 6.29 },
    { 11, 42, 28.39, +66, 44, 42.0, 5.30 },
    {  0, 34, 24.91, +66, 45,  1.1, 6.48 },
    { 23, 46, 36.70, +66, 46, 55.9, 5.95 },
    { 12, 47, 34.39, +66, 47, 25.1, 5.43 },
    { 21, 27, 46.10, +66, 48, 33.1, 5.44 },
    {  5,  2, 50.40, +66, 49, 22.1, 6.19 },
    { 20, 17, 31.30, +66, 51, 14.0, 5.93 },
    {  9,  8, 23.59, +66, 52, 23.9, 5.14 },
    { 11, 20, 53.81, +67,  6,  2.2, 6.21 },
    {  9, 10, 23.21, +67,  8,  4.9, 4.80 },
    { 16, 12, 25.10, +67,  8, 39.1, 6.21 },
    {  0,  4, 42.00, +67, 10,   .1, 5.67 },
    {  3, 46,   .89, +67, 12,  6.1, 5.80 },
    { 23,  3, 32.90, +67, 12, 33.1, 5.24 },
    { 11,  9, 39.89, +67, 12, 37.1, 6.06 },
    {  9, 39, 27.91, +67, 16, 19.9, 5.94 },
    {  8, 29, 46.20, +67, 17, 51.0, 5.88 },
    { 17, 25,   .19, +67, 18, 23.0, 6.43 },
    { 15, 14, 38.30, +67, 20, 48.1, 5.13 },
    {  2, 29,  4.01, +67, 24,  9.0, 4.52 },
    { 10, 45,  4.01, +67, 24, 41.0, 6.00 },
    {  6, 50, 57.10, +67, 34, 18.8, 5.14 },
    {  9,  2, 32.69, +67, 37, 46.9, 4.76 },
    { 19, 12, 33.31, +67, 39, 42.1, 3.07 },
    { 15, 10, 44.09, +67, 46, 53.0, 6.17 },
    { 23, 47, 54.79, +67, 48, 24.8, 5.04 },
    { 16,  6, 19.70, +67, 48, 37.1, 5.44 },
    {  2, 44, 49.70, +67, 49, 28.9, 5.95 },
    { 20,  2, 49.10, +67, 52, 25.0, 4.51 },
    { 20,  4, 53.30, +68,  1, 37.9, 6.28 },
    {  1, 42, 20.50, +68,  2, 35.2, 5.59 },
    { 23, 18, 37.49, +68,  6, 42.1, 4.75 },
    {  1, 25, 55.99, +68,  7, 48.0, 4.74 },
    { 17, 31, 57.89, +68,  8,  6.0, 5.05 },
    { 11, 12, 10.99, +68, 16, 18.8, 6.40 },
    { 13, 50, 59.21, +68, 18, 55.1, 6.40 },
    { 13, 16, 28.61, +68, 24, 29.2, 6.20 },
    { 19, 46, 44.69, +68, 26, 17.9, 6.34 },
    { 10, 41, 48.29, +68, 26, 35.9, 5.75 },
    {  7, 30, 52.70, +68, 27, 56.2, 5.64 },
    {  5, 52, 55.49, +68, 28, 17.0, 6.20 },
    {  8, 12, 48.79, +68, 28, 27.1, 5.32 },
    { 21,  9, 31.99, +68, 29, 25.1, 7.33 },
    {  4, 12, 51.60, +68, 30,  6.1, 6.32 },
    {  3, 51, 41.81, +68, 30, 27.0, 6.32 },
    { 16, 18,  9.41, +68, 33, 15.8, 6.41 },
    { 22, 49,   .70, +68, 34, 13.1, 6.19 },
    { 14,  1, 50.59, +68, 40, 43.0, 6.34 },
    {  4,  6,  3.10, +68, 40, 48.0, 5.87 },
    {  1, 56,   .00, +68, 41,  7.1, 4.99 },
    { 10, 21,  3.41, +68, 44, 51.0, 5.96 },
    { 18, 15, 16.99, +68, 45, 20.9, 5.95 },
    { 17, 36, 57.10, +68, 45, 29.2, 4.80 },
    { 16, 27, 58.99, +68, 46,  5.2, 5.00 },
    {  0, 56, 55.61, +68, 46, 34.0, 6.37 },
    {  1, 10, 39.29, +68, 46, 43.0, 5.29 },
    { 20, 20,  6.00, +68, 52, 49.1, 5.55 },
    {  6, 53, 42.19, +68, 53, 17.9, 5.12 },
    {  2, 51, 58.70, +68, 53, 19.0, 5.80 },
    { 15, 14, 51.89, +68, 56, 43.1, 6.51 },
    { 10, 43,  4.10, +69,  4, 34.0, 5.00 },
    { 16, 21, 48.70, +69,  6, 33.8, 5.25 },
    { 16, 59,  2.59, +69, 11, 11.0, 6.40 },
    { 12, 30,  6.70, +69, 12,  4.0, 4.95 },
    {  9, 42, 14.81, +69, 14, 15.0, 5.69 },
    { 15, 37, 39.10, +69, 16, 59.9, 5.62 },
    {  6, 18, 50.81, +69, 19, 10.9, 4.80 },
    {  8, 32, 53.40, +69, 19, 12.0, 6.31 },
    { 11, 36,  2.81, +69, 19, 22.1, 5.20 },
    {  0, 46, 39.00, +69, 19, 30.0, 6.33 },
    { 11, 31, 24.19, +69, 19, 52.0, 3.84 },
    { 19, 44, 18.50, +69, 20, 12.8, 5.92 },
    { 14, 12,  4.01, +69, 25, 57.0, 5.24 },
    { 18, 58, 52.61, +69, 31, 52.0, 6.52 },
    { 17, 36, 39.70, +69, 34, 14.9, 6.42 },
    {  2, 48, 55.51, +69, 38,  3.1, 6.18 },
    {  5,  9, 36.70, +69, 38, 21.8, 6.41 },
    { 19, 32, 21.60, +69, 39, 40.0, 4.68 },
    { 20, 44, 33.10, +69, 45,  6.8, 6.41 },
    { 12, 33, 28.99, +69, 47, 17.9, 3.87 },
    {  9, 34, 28.90, +69, 49, 49.1, 4.56 },
    { 10, 53, 30.70, +69, 51, 14.0, 5.93 },
    { 22, 33,  2.90, +69, 54, 49.0, 6.60 },
    { 12, 34, 43.99, +70,  1, 18.8, 4.94 },
    { 22, 10, 38.90, +70,  7, 58.1, 5.50 },
    { 21, 47,  1.01, +70,  9,  2.9, 6.29 },
    { 12, 15,  8.50, +70, 12,   .0, 5.71 },
    {  1, 31, 13.80, +70, 15, 52.9, 5.81 },
    { 19, 48, 10.39, +70, 16,  4.1, 3.83 },
    { 23, 27, 16.61, +70, 21, 34.9, 5.60 },
    { 19, 58, 41.90, +70, 22,   .8, 6.33 },
    { 22, 33, 16.99, +70, 22, 26.0, 6.34 },
    {  6, 28, 14.59, +70, 32,  8.2, 5.97 },
    { 21, 28, 39.60, +70, 33, 38.9, 3.23 },
    {  1, 42, 55.90, +70, 37, 21.0, 5.18 },
    {  7,  5, 51.79, +70, 43, 54.8, 6.50 },
    { 22, 26,   .79, +70, 46, 14.9, 5.47 },
    { 18, 43, 10.20, +70, 47, 34.1, 6.44 },
    {  7,  1, 21.50, +70, 48, 29.2, 5.68 },
    {  3, 49, 13.80, +70, 52, 16.0, 5.44 },
    { 23, 15, 37.80, +70, 53, 17.2, 5.56 },
    {  2,  1, 57.41, +70, 54, 24.8, 4.54 },
    {  4, 50, 36.41, +70, 56, 30.1, 6.37 },
    {  1, 25, 46.51, +70, 58, 48.0, 6.49 },
    {  0, 33, 19.30, +70, 58, 54.1, 6.42 },
    {  1,  0, 31.01, +70, 58, 59.2, 6.39 },
    { 19, 31,   .19, +70, 59, 21.8, 6.07 },
    { 10, 17, 50.59, +71,  3, 38.2, 6.66 },
    { 13, 37, 10.99, +71, 14, 31.9, 5.50 },
    { 18, 54, 23.90, +71, 17, 49.9, 4.82 },
    { 21, 41, 55.30, +71, 18, 41.0, 4.56 },
    {  3, 50, 21.50, +71, 19, 55.9, 4.63 },
    { 18, 20, 45.50, +71, 20, 16.1, 4.22 },
    { 21,  6, 23.30, +71, 25, 54.8, 5.87 },
    { 23, 34, 58.99, +71, 38, 31.9, 5.84 },
    {  9, 14,  3.19, +71, 39, 20.9, 6.55 },
    {  1, 16, 12.10, +71, 44, 38.0, 7.83 },
    {  6, 40, 32.21, +71, 44, 56.0, 5.92 },
    {  7, 13, 58.10, +71, 49,   .1, 6.35 },
    {  3, 56, 30.19, +71, 49, 18.1, 6.34 },
    { 15, 17,  5.90, +71, 49, 26.0, 5.02 },
    { 15, 20, 43.70, +71, 50,  2.0, 3.05 },
    {  3, 30, 19.49, +71, 51, 50.0, 6.32 },
    { 12, 26, 24.19, +71, 55, 46.9, 6.24 },
    { 17, 55, 11.21, +72,  0, 18.0, 5.45 },
    { 22, 10, 15.31, +72,  6, 40.0, 6.37 },
    {  4, 13, 44.90, +72,  7, 35.0, 6.03 },
    { 17, 41, 56.30, +72,  8, 56.0, 4.58 },
    { 17, 41, 58.01, +72,  9, 24.8, 5.79 },
    {  9, 34, 53.59, +72, 12, 20.2, 5.72 },
    {  9, 42, 57.19, +72, 15,  9.0, 5.17 },
    { 21, 43,  4.01, +72, 19, 13.1, 5.17 },
    { 22,  9, 48.41, +72, 20, 28.0, 4.79 },
    { 13, 26,  8.11, +72, 23, 29.0, 5.79 },
    {  8, 20, 40.30, +72, 24, 25.9, 5.98 },
    {  2,  3, 26.09, +72, 25, 17.0, 3.98 },
    { 17, 37,  8.81, +72, 27, 20.9, 5.86 },
    {  4, 33, 30.70, +72, 31, 43.0, 5.94 },
    { 20, 30,   .70, +72, 31, 54.1, 6.27 },
    { 12, 15, 41.40, +72, 33,  2.9, 6.29 },
    { 16, 31, 28.10, +72, 36, 42.8, 6.30 },
    {  0, 48,  9.10, +72, 40, 30.0, 5.87 },
    { 18, 21,  3.41, +72, 43, 58.1, 3.57 },
    { 13, 13, 31.99, +72, 47, 56.0, 6.59 },
    {  2, 38,  1.99, +72, 49,  5.9, 5.16 },
    {  9, 58, 22.80, +72, 52, 45.8, 5.83 },
    {  9, 15, 52.61, +72, 56, 46.0, 5.96 },
    { 13,  4, 49.70, +73,  1, 31.1, 6.31 },
    {  1, 38, 30.89, +73,  2, 24.0, 5.28 },
    { 10, 18,  1.10, +73,  4, 23.9, 6.40 },
    {  9, 37, 56.21, +73,  4, 50.2, 6.42 },
    { 16, 56, 16.80, +73,  7, 40.1, 6.30 },
    { 21, 59, 15.00, +73, 10, 48.0, 5.03 },
    {  5, 18, 13.30, +73, 16,  5.2, 5.74 },
    { 22, 12, 52.90, +73, 18, 25.9, 6.08 },
    {  3, 35, 12.41, +73, 20, 48.8, 6.57 },
    { 19, 15, 33.00, +73, 21, 20.2, 4.45 },
    { 16, 14, 33.50, +73, 23, 42.0, 5.98 },
    {  8, 39, 42.60, +73, 37, 46.9, 6.15 },
    { 22, 35, 46.10, +73, 38, 35.2, 5.08 },
    {  6, 37, 54.91, +73, 41, 44.2, 6.24 },
    {  5,  4, 13.01, +73, 45, 50.0, 6.66 },
    {  2,  3, 10.51, +73, 51,  2.2, 6.23 },
    {  8,  0, 11.71, +73, 55,  5.2, 5.41 },
    {  5, 12, 22.39, +73, 56, 48.1, 5.43 },
    { 23, 39, 21.10, +74,  0, 10.1, 5.98 },
    {  9, 19, 55.80, +74,  0, 59.0, 6.50 },
    {  2, 13, 21.19, +74,  1, 40.1, 6.29 },
    {  5,  4, 39.79, +74,  4,   .8, 5.96 },
    { 18, 45, 46.70, +74,  5,  8.2, 5.27 },
    { 14, 50, 42.31, +74,  9, 20.2, 2.08 },
    { 23, 14, 37.30, +74, 13, 52.0, 5.84 },
    {  5,  2, 20.09, +74, 16,  9.1, 6.06 },
    {  1, 37, 22.51, +74, 18,  2.9, 6.58 },
    {  9, 36,  6.79, +74, 19,  4.1, 6.46 },
    {  3, 11, 56.30, +74, 23, 37.0, 4.87 },
    { 14,  6, 56.40, +74, 35, 37.0, 6.45 },
    { 12,  9, 47.30, +74, 39, 41.0, 6.35 },
    {  8, 36, 48.70, +74, 43, 25.0, 6.31 },
    {  0, 47, 46.10, +74, 50, 51.0, 5.41 },
    { 20, 31, 30.41, +74, 57, 16.9, 5.20 },
    {  0, 45, 39.00, +74, 59, 17.2, 5.66 },
    { 21, 57, 51.00, +74, 59, 48.1, 6.35 },
    {  5, 39, 43.70, +75,  2, 38.0, 6.17 },
    {  9, 27, 51.60, +75,  5, 53.9, 6.29 },
    { 12, 18, 49.90, +75,  9, 38.2, 5.38 },
    { 17, 54, 26.59, +75, 10, 14.9, 6.36 },
    { 16, 12, 32.21, +75, 12, 38.2, 6.39 },
    { 23, 39, 10.39, +75, 17, 34.1, 5.95 },
    { 17,  1, 40.20, +75, 17, 49.9, 6.21 },
    { 23, 17, 18.89, +75, 17, 57.1, 6.38 },
    { 22, 37, 13.01, +75, 22, 18.1, 5.79 },
    { 23,  7, 53.90, +75, 23, 15.0, 4.41 },
    { 18, 46, 22.20, +75, 26,  2.0, 5.35 },
    { 12, 58, 47.30, +75, 28, 21.0, 6.01 },
    { 23, 52, 25.10, +75, 32, 40.9, 6.39 },
    {  6,  5,  9.29, +75, 35,  8.9, 6.40 },
    { 14, 27, 31.51, +75, 41, 46.0, 4.25 },
    { 10, 35,  5.50, +75, 42, 47.2, 4.84 },
    {  3, 39, 24.79, +75, 44, 22.9, 6.27 },
    { 16, 17, 30.31, +75, 45, 19.1, 4.95 },
    {  8, 19, 32.21, +75, 45, 24.8, 5.54 },
    { 18, 53, 33.19, +75, 47, 15.0, 6.22 },
    { 16, 10, 49.51, +75, 52, 39.0, 5.48 },
    { 20, 54, 44.30, +75, 55, 32.2, 6.05 },
    {  4, 48, 50.30, +75, 56, 28.0, 6.06 },
    {  2,  5, 31.20, +76,  6, 54.0, 5.22 },
    { 22, 32, 16.20, +76, 13, 35.0, 5.68 },
    {  1, 21, 59.11, +76, 14, 20.0, 6.38 },
    {  5, 14, 35.59, +76, 28, 22.1, 6.37 },
    { 19, 59, 36.60, +76, 28, 53.0, 6.20 },
    { 22, 18, 20.40, +76, 29, 17.2, 6.66 },
    { 13, 34, 42.79, +76, 32, 48.1, 6.57 },
    { 19,  9,  9.79, +76, 33, 38.2, 5.13 },
    {  4, 46,   .31, +76, 36, 40.0, 6.49 },
    { 16,  3, 31.30, +76, 47, 37.0, 5.56 },
    { 12,  5, 15.10, +76, 54, 20.9, 5.80 },
    {  0, 16, 13.99, +76, 57,  2.9, 6.35 },
    { 17, 49, 27.00, +76, 57, 46.1, 5.04 },
    {  7,  0,  4.01, +76, 58, 39.0, 4.55 },
    { 21, 15, 42.19, +77,  0, 43.9, 5.95 },
    {  0, 30, 55.01, +77,  1,  9.8, 6.21 },
    { 18, 57, 57.19, +77,  3,  2.9, 6.54 },
    {  2,  5,  7.39, +77, 16, 53.0, 5.38 },
    { 15, 31, 24.89, +77, 20, 57.8, 4.96 },
    { 16, 30, 38.81, +77, 26, 48.1, 6.34 },
    { 16, 43,  6.00, +77, 30, 51.1, 5.98 },
    { 18, 29, 44.90, +77, 32, 48.8, 5.64 },
    { 14,  8, 50.90, +77, 32, 51.0, 4.82 },
    {  1, 20, 19.49, +77, 34, 14.2, 6.31 },
    { 23, 51, 57.60, +77, 35, 57.8, 6.55 },
    { 12, 12, 11.90, +77, 36, 59.0, 5.14 },
    { 23, 39, 20.81, +77, 37, 57.0, 3.21 },
    { 20,  8, 53.30, +77, 42, 41.0, 4.39 },
    {  3, 20, 19.70, +77, 44,  4.9, 5.45 },
    { 10, 59, 56.81, +77, 46, 12.0, 6.20 },
    { 15, 44,  3.50, +77, 47, 39.8, 4.32 },
    {  2,  2, 57.19, +77, 54, 59.0, 6.04 },
    {  5, 29, 25.70, +77, 58, 39.0, 6.56 },
    {  6, 40, 28.80, +77, 59, 44.9, 5.73 },
    { 13, 42, 39.31, +78,  3, 51.8, 5.91 },
    { 21,  5, 29.30, +78,  7, 35.0, 5.91 },
    {  9, 45, 30.79, +78,  8,  4.9, 6.23 },
    { 22, 23, 41.30, +78, 14, 35.9, 6.76 },
    { 17, 50, 10.51, +78, 18, 24.1, 6.24 },
    { 13, 26, 56.71, +78, 38, 38.0, 5.77 },
    {  1, 23, 46.80, +78, 43, 32.9, 6.07 },
    { 22, 26, 42.50, +78, 47,  8.9, 5.83 },
    { 22, 29, 52.90, +78, 49, 27.1, 5.50 },
    { 16, 37, 52.90, +78, 55,  5.9, 6.32 },
    { 16, 25, 43.10, +78, 57, 50.0, 5.56 },
    {  9, 47, 18.00, +79,  8, 12.1, 6.17 },
    {  5, 22, 33.50, +79, 13, 52.0, 5.05 },
    {  3,  6,  7.80, +79, 25,  7.0, 5.49 },
    {  8,  4, 47.11, +79, 28, 46.9, 5.42 },
    {  6, 46, 14.09, +79, 33, 52.9, 5.45 },
    {  6, 40, 16.80, +79, 35, 57.8, 6.54 },
    { 19, 21, 40.20, +79, 36, 10.1, 6.05 },
    { 14, 33, 38.30, +79, 39, 37.1, 6.26 },
    {  1, 12, 16.70, +79, 40, 26.0, 5.64 },
    {  0,  9, 20.21, +79, 42, 52.9, 6.01 },
    {  1, 16, 30.70, +79, 54, 36.0, 6.26 },
    { 18, 45, 38.11, +79, 56, 33.0, 6.39 },
    { 18,  0,  3.41, +80,  0,  2.9, 6.04 },
    { 18,  0,  9.19, +80,  0, 15.1, 5.68 },
    {  1,  9, 12.31, +80,  0, 42.1, 6.29 },
    { 17, 19, 37.01, +80,  8, 11.0, 5.72 },
    {  7, 56, 17.30, +80, 15, 56.2, 6.56 },
    { 15, 29, 10.99, +80, 26, 55.0, 6.58 },
    { 13, 12, 25.39, +80, 28, 17.0, 6.25 },
    { 10, 36,  1.70, +80, 29, 39.8, 6.52 },
    { 21, 24, 49.70, +80, 31, 28.9, 5.97 },
    { 20, 47, 33.41, +80, 33,  7.9, 5.39 },
    { 12, 44, 25.99, +80, 37, 16.0, 6.40 },
    {  4, 10,  2.81, +80, 41, 55.0, 5.10 },
    {  4, 27,  2.81, +80, 49, 27.1, 5.43 },
    { 12,  0, 18.60, +80, 51, 11.2, 6.17 },
    {  7, 34, 39.70, +80, 53, 48.1, 6.41 },
    { 20, 29, 27.50, +81,  5, 29.0, 5.96 },
    { 11, 31, 50.40, +81,  7, 37.9, 6.15 },
    {  5,  0, 20.71, +81, 11, 38.0, 5.07 },
    { 21, 13, 21.50, +81, 13, 50.9, 6.15 },
    {  7, 25, 21.89, +81, 15, 27.0, 6.31 },
    {  2,  9, 25.30, +81, 17, 44.9, 6.05 },
    {  9, 37,  5.21, +81, 19, 35.0, 4.29 },
    { 20, 28, 14.59, +81, 25, 22.1, 5.46 },
    {  2, 47, 47.59, +81, 26, 53.9, 5.78 },
    {  3, 11, 42.79, +81, 28, 14.2, 5.95 },
    { 12, 11,   .00, +81, 42, 36.0, 6.00 },
    { 16, 45, 58.10, +82,  2, 13.9, 4.23 },
    {  6, 44, 30.19, +82,  6, 55.1, 6.65 },
    {  7, 31,  4.39, +82, 24, 41.0, 4.96 },
    {  8, 24, 32.90, +82, 25, 50.9, 6.32 },
    {  0, 39, 47.30, +82, 29, 38.0, 6.40 },
    { 14, 50, 20.40, +82, 30, 42.8, 5.64 },
    { 20, 42, 35.21, +82, 31, 52.0, 5.75 },
    { 10, 31,  4.61, +82, 33, 31.0, 5.26 },
    { 13, 42, 23.11, +82, 45,  9.0, 5.98 },
    { 21, 58, 12.70, +82, 52, 10.9, 6.98 },
    { 22, 47, 28.99, +83,  9, 14.0, 4.74 },
    { 18, 24,  9.19, +83, 10, 31.1, 6.17 },
    { 23, 56, 27.70, +83, 11, 28.0, 6.59 },
    {  4, 30,   .10, +83, 20, 26.2, 5.46 },
    { 12, 49, 13.61, +83, 24, 46.1, 5.28 },
    { 12, 49,  6.60, +83, 25,  5.2, 5.85 },
    { 19, 15,  7.80, +83, 27, 46.1, 6.53 },
    { 20, 29,  3.10, +83, 37, 32.2, 6.19 },
    {  0, 54, 53.09, +83, 42, 25.9, 5.62 },
    {  4, 28, 13.01, +83, 48, 28.1, 5.57 },
    { 10,  8, 34.30, +83, 55,  5.9, 6.37 },
    {  8, 16, 53.81, +84,  3, 28.1, 6.49 },
    {  9, 15, 21.19, +84, 10, 52.0, 6.33 },
    { 10, 29, 41.50, +84, 15,  7.9, 5.50 },
    { 22, 54, 24.79, +84, 20, 46.0, 4.71 },
    {  3, 32, 20.11, +84, 54, 40.0, 5.61 },
    {  6,  1, 20.21, +85, 10, 55.9, 6.11 },
    { 22, 51,  2.21, +85, 22, 25.0, 5.90 },
    { 12,  4, 28.10, +85, 35, 13.9, 6.27 },
    {  5, 43, 48.70, +85, 40,  5.2, 6.60 },
    {  5, 31, 48.00, +85, 56, 19.0, 6.51 },
    { 22, 13, 10.61, +86,  6, 29.2, 5.27 },
    {  1,  8, 44.71, +86, 15, 24.8, 4.25 },
    { 12, 16, 51.41, +86, 26, 10.0, 6.33 },
    { 17, 32, 12.89, +86, 35, 11.0, 4.36 },
    {  4, 10,  1.49, +86, 37, 34.0, 5.86 },
    { 17, 30, 48.00, +86, 58,  5.2, 5.79 },
    {  7, 40, 30.50, +87,  1, 12.0, 5.07 },
    {  1, 16, 13.49, +87,  8, 43.1, 6.25 },
    { 23, 27,   .79, +87, 18, 27.0, 5.58 },
    { 12, 15, 20.30, +87, 42,   .0, 6.28 },
    {  1, 33, 50.40, +89,  0, 56.2, 6.46 },
    { 17, 16, 56.81, +89,  2, 16.1, 6.38 },
    {  2, 31, 48.70, +89, 15, 51.1, 2.02 },
};

