-- $Id$ 

-- check ports which are arrays of signals.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is
	type ba is array(integer range <>) of boolean;
end package;

use t.ba;
ENTITY bottom IS
	PORT (
		x : in ba;
		y : out ba(1 to 10)
	);
END ENTITY bottom;

ARCHITECTURE bottom_impl OF bottom IS
BEGIN
	p : process(x)
		variable r : boolean;
	begin
		for i in x'range loop
			y(i) <= x(i);
		end loop;
	end process;
END ARCHITECTURE;

use t.ba;
ENTITY test_bench IS
END ENTITY test_bench;

ARCHITECTURE test_bench_impl of test_bench IS
	signal int_x : ba(1 to 10);
	signal int_y : ba(1 to 10);
BEGIN
	b : bottom port map(x => int_x, y => int_y);

	p : process
	begin
		int_x(1) <= true;
		int_x(2) <= true;
		int_x(3) <= true;
		int_x(4) <= true;
		int_x(5) <= true;
		int_x(6) <= true;
		int_x(7) <= true;
		int_x(8) <= true;
		int_x(9) <= true;
		int_x(10) <= true;

		wait on int_y for 10 ms;

		assert int_y(1) report "int_y(1)" severity failure;
		assert int_y(2) report "int_y(2)" severity failure;
		assert int_y(3) report "int_y(3)" severity failure;
		assert int_y(4) report "int_y(4)" severity failure;
		assert int_y(5) report "int_y(5)" severity failure;
		assert int_y(6) report "int_y(6)" severity failure;
		assert int_y(7) report "int_y(7)" severity failure;
		assert int_y(8) report "int_y(8)" severity failure;
		assert int_y(9) report "int_y(9)" severity failure;
		assert int_y(10) report "int_y(10)" severity failure;

		assert false report "simulation finished" severity note;
		wait;
	end process;
end;
