// Code generated by smithy-go-codegen DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an analyzer for your account.
func (c *Client) CreateAnalyzer(ctx context.Context, params *CreateAnalyzerInput, optFns ...func(*Options)) (*CreateAnalyzerOutput, error) {
	if params == nil {
		params = &CreateAnalyzerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAnalyzer", params, optFns, c.addOperationCreateAnalyzerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAnalyzerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Creates an analyzer.
type CreateAnalyzerInput struct {

	// The name of the analyzer to create.
	//
	// This member is required.
	AnalyzerName *string

	// The type of analyzer to create. Only ACCOUNT , ORGANIZATION ,
	// ACCOUNT_UNUSED_ACCESS , and ORGANIZATION_UNUSED_ACCESS analyzers are supported.
	// You can create only one analyzer per account per Region. You can create up to 5
	// analyzers per organization per Region.
	//
	// This member is required.
	Type types.Type

	// Specifies the archive rules to add for the analyzer. Archive rules
	// automatically archive findings that meet the criteria you define for the rule.
	ArchiveRules []types.InlineArchiveRule

	// A client token.
	ClientToken *string

	// Specifies the configuration of the analyzer. If the analyzer is an unused
	// access analyzer, the specified scope of unused access is used for the
	// configuration. If the analyzer is an external access analyzer, this field is not
	// used.
	Configuration types.AnalyzerConfiguration

	// An array of key-value pairs to apply to the analyzer.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The response to the request to create an analyzer.
type CreateAnalyzerOutput struct {

	// The ARN of the analyzer that was created by the request.
	Arn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAnalyzerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAnalyzer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAnalyzer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAnalyzer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAnalyzerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAnalyzerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAnalyzer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAnalyzer struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAnalyzer) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAnalyzer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAnalyzerInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAnalyzerInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAnalyzerMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAnalyzer{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAnalyzer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAnalyzer",
	}
}
