/*=========================================================================
 *
 *  Copyright Insight Software Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/
#include "itkTransformFactory.h"
#include "itkVersion.h"

#include "itkAzimuthElevationToCartesianTransform.h"
#include "itkCenteredAffineTransform.h"
#include "itkCenteredEuler3DTransform.h"
#include "itkCenteredRigid2DTransform.h"
#include "itkCenteredSimilarity2DTransform.h"
#include "itkEuler2DTransform.h"
#include "itkFixedCenterOfRotationAffineTransform.h"
#include "itkIdentityTransform.h"
#include "itkQuaternionRigidTransform.h"
#include "itkv3Rigid3DTransform.h"
#include "itkRigid3DPerspectiveTransform.h"
#include "itkScaleLogarithmicTransform.h"
#include "itkScaleVersor3DTransform.h"
#include "itkScaleSkewVersor3DTransform.h"
#include "itkSimilarity2DTransform.h"
#include "itkSimilarity3DTransform.h"
#include "itkTranslationTransform.h"
#include "itkBSplineTransform.h"
#include "itkCompositeTransform.h"

//Transforms from Filtering/DisplacementField/include
#include "itkBSplineExponentialDiffeomorphicTransform.h"
#include "itkBSplineSmoothingOnUpdateDisplacementFieldTransform.h"
#include "itkConstantVelocityFieldTransform.h"
#include "itkDisplacementFieldTransform.h"
#include "itkGaussianExponentialDiffeomorphicTransform.h"
#include "itkGaussianSmoothingOnUpdateDisplacementFieldTransform.h"
#include "itkGaussianSmoothingOnUpdateTimeVaryingVelocityFieldTransform.h"
#include "itkTimeVaryingBSplineVelocityFieldTransform.h"
#include "itkTimeVaryingVelocityFieldTransform.h"
#include "itkVelocityFieldTransform.h"

#if !defined( ITK_FUTURE_LEGACY_REMOVE )
#include "itkBSplineDeformableTransform.h"
#endif

namespace itk
{

void TransformFactoryBase::RegisterTransformFactoryFloatParameters()
{

  ////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////////
  //
  // float Parameters, double FixedParamters instances (in alphabetical order)
  //
  TransformFactory< AffineTransform<float, 2> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 3> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 4> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 5> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 6> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 7> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 8> >::RegisterTransform ();
  TransformFactory< AffineTransform<float, 9> >::RegisterTransform ();

  TransformFactory< AzimuthElevationToCartesianTransform<float, 3> >::RegisterTransform ();

  TransformFactory< BSplineTransform<float, 2, 2> >::RegisterTransform ();
  TransformFactory< BSplineTransform<float, 3, 3> >::RegisterTransform ();
#if !defined(ITK_FUTURE_LEGACY_REMOVE)
  TransformFactory< BSplineDeformableTransform<float, 2, 2> >::RegisterTransform ();
  TransformFactory< BSplineDeformableTransform<float, 3, 3> >::RegisterTransform ();
#endif

  TransformFactory< CenteredAffineTransform<float, 2> >::RegisterTransform ();
  TransformFactory< CenteredAffineTransform<float, 3> >::RegisterTransform ();
  TransformFactory< CenteredEuler3DTransform<float > >::RegisterTransform ();
  TransformFactory< CenteredRigid2DTransform<float > >::RegisterTransform();
  TransformFactory< CenteredSimilarity2DTransform<float > >::RegisterTransform ();

  TransformFactory< CompositeTransform<float, 2> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 3> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 4> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 5> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 6> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 7> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 8> >::RegisterTransform();
  TransformFactory< CompositeTransform<float, 9> >::RegisterTransform();

  TransformFactory< Euler2DTransform<float > >::RegisterTransform ();
  TransformFactory< Euler3DTransform<float > >::RegisterTransform ();

  TransformFactory< FixedCenterOfRotationAffineTransform<float, 3> >::RegisterTransform ();

  TransformFactory< IdentityTransform<float, 2> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 3> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 4> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 5> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 6> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 7> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 8> >::RegisterTransform ();
  TransformFactory< IdentityTransform<float, 9> >::RegisterTransform ();

  TransformFactory< QuaternionRigidTransform<float > >::RegisterTransform ();

  TransformFactory< Rigid2DTransform<float > >::RegisterTransform ();
  // We cannot register both Rigid3DTransform and
  // itkv3::Rigid3DTransform because they both have the same name
#ifdef ITKV3_COMPATIBILITY
  TransformFactory< Rigid3DTransform<float > >::RegisterTransform ();
#else
  TransformFactory< itkv3::Rigid3DTransform<float > >::RegisterTransform ();
#endif
  TransformFactory< Rigid3DPerspectiveTransform<float > >::RegisterTransform ();

  TransformFactory< ScalableAffineTransform<float, 3> >::RegisterTransform ();
  TransformFactory< ScaleLogarithmicTransform<float, 3> >::RegisterTransform ();
  TransformFactory< ScaleSkewVersor3DTransform<float > >::RegisterTransform ();
  TransformFactory< ScaleTransform<float, 2> >::RegisterTransform ();
  TransformFactory< ScaleTransform<float, 3> >::RegisterTransform ();
  TransformFactory< ScaleTransform<float, 4> >::RegisterTransform ();
  TransformFactory< ScaleVersor3DTransform<float > >::RegisterTransform ();

  TransformFactory< Similarity2DTransform<float > >::RegisterTransform ();
  TransformFactory< Similarity3DTransform<float > >::RegisterTransform ();

  TransformFactory< TranslationTransform<float, 2> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 3> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 4> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 5> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 6> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 7> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 8> >::RegisterTransform ();
  TransformFactory< TranslationTransform<float, 9> >::RegisterTransform ();

  TransformFactory< VersorRigid3DTransform<float > >::RegisterTransform ();
  TransformFactory< VersorTransform<float > >::RegisterTransform ();

  TransformFactory< BSplineSmoothingOnUpdateDisplacementFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< BSplineSmoothingOnUpdateDisplacementFieldTransform<float,3> >::RegisterTransform ();
  TransformFactory< ConstantVelocityFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< ConstantVelocityFieldTransform<float,3> >::RegisterTransform ();
  TransformFactory< DisplacementFieldTransform<float, 2> >::RegisterTransform ();
  TransformFactory< DisplacementFieldTransform<float, 3> >::RegisterTransform ();
  TransformFactory< GaussianExponentialDiffeomorphicTransform<float,2> >::RegisterTransform ();
  TransformFactory< GaussianExponentialDiffeomorphicTransform<float,3> >::RegisterTransform ();
  TransformFactory< GaussianSmoothingOnUpdateDisplacementFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< GaussianSmoothingOnUpdateDisplacementFieldTransform<float,3> >::RegisterTransform ();
  TransformFactory< GaussianSmoothingOnUpdateTimeVaryingVelocityFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< GaussianSmoothingOnUpdateTimeVaryingVelocityFieldTransform<float,3> >::RegisterTransform ();
  TransformFactory< TimeVaryingBSplineVelocityFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< TimeVaryingBSplineVelocityFieldTransform<float,3> >::RegisterTransform ();
  TransformFactory< TimeVaryingVelocityFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< TimeVaryingVelocityFieldTransform<float,3> >::RegisterTransform ();
  TransformFactory< VelocityFieldTransform<float,2> >::RegisterTransform ();
  TransformFactory< VelocityFieldTransform<float,3> >::RegisterTransform ();

}

} // end namespace itk
