#!/usr/bin/make -f
# Fake webpack
#
# How to use this, to update ipywidgets webpack components.
# (For a list of components, look at ALL defined below in this makefile)
#
# 1. Get the upstream build products. You can either:
#    * Build them yourself using npm(1), or
#    * Download them from PyPI or NPM or something, or
#    * `git checkout build -- upstream; git reset -- upstream` if someone already did this.
# 2. Run `$0 prep` to extract their source files.
# 3. For each component, repeat the following:
#    a) `$0 upstream-reproduce/%.stamp`
#    b) edit fakewebpack/%.modules to respond to the error
#    until there are no errors. TODO: this could be automated better.
# 4. Commit your manually-edited fakewebpack/%.modules into git.
# 5. For each component, repeat the following:
#    a) `$0 clean upstream-reproduce/%.diff`
#    b) edit our scripts (*.py *.js) to respond to any significant differences
#    until the diffs are reasonably minimal.
# 6. Commit the updated scripts into git.
# 7. Run `$0 clean all-diff` then check the diffs remain minimal.
# 8. Copy the tree-structure of upstream-unpacked/ into fakewebpack-unpacked/
#    except every file should be a symlink either to a Debian system file, or
#    if this unavailable then to a file in missing-sources/ that you add.
# 9. Check fakewebpack-unpacked/ into git.
# X. Now `$0 clean all` should build you some nice things, and you can call
#    this from debian/rules.
#
# NOTES:
#
# - The "Bottom edge touching"/"Right edge touching" extra diff is this bug:
#   https://github.com/benjamn/recast/issues/342
#   For us, it's not worth worrying about.
# - widgetsnbextension embeds two different copies of Backbone. We deduplicate
#   this and so there are some extra diffs about "var Backbone = __webpack_require__(3)"
#   instead of "...(24)"; the numbers may be a bit different after 5.2.2.

ALL = docs widgetsnbextension
TARGET_docs = index.js
TARGET_widgetsnbextension = extension.js
ISAMD_docs = False
ISAMD_widgetsnbextension = True

FAKEWEBPACK = \
	rm -rf "$(1)/$*" && mkdir -p "$(1)/$*" && \
	./fakewebpack-generate.py fakewebpack/$*.files fakewebpack/$*.modules $(2)/$*/ $(ISAMD_$*) > "$(1)/$*/$(TARGET_$*)" && \
	touch "$@"

all: $(ALL:%=fakewebpack-build/%.stamp)

all-diff: $(ALL:%=upstream-reproduce/%.diff)

fakewebpack-build/%.stamp: fakewebpack/%.files fakewebpack/%.modules fakewebpack-unpacked/%/
	$(MAKE) -f fakewebpack-prep-tree.mk all
	$(call FAKEWEBPACK,fakewebpack-build,fakewebpack-unpacked)

fakewebpack-build/%.packages: fakewebpack/%.files
	cat fakewebpack/$*.files | \
	  while read x; do \
	    y="$$(readlink -f "fakewebpack-unpacked/$*/$$x")"; \
	    case "$$y" in \
	    /usr/*) dpkg -S "$$y";; \
	    esac; \
	  done | \
	  cut -d: -f1 | \
	  sort -u | \
	  xargs -rn1 dpkg-query -f '$${source:Package} (= $${source:Version}), ' -W > "$@"

upstream-reproduce/%.stamp: fakewebpack/%.files fakewebpack/%.modules upstream-unpacked/%/
	$(call FAKEWEBPACK,upstream-reproduce,upstream-unpacked)

upstream-reproduce/%.diff: upstream-reproduce/%.stamp
	diff -ruwB upstream/$*/$(TARGET_$*) upstream-reproduce/$*/$(TARGET_$*) > "$@" || true

clean:
	$(MAKE) -f fakewebpack-prep-tree.mk clean
	rm -rf upstream-reproduce fakewebpack-build

prep: $(ALL:%=fakewebpack/%.modules)

fakewebpack/%.modules: fakewebpack/%.files
	tail -n+2 "$<" > "$@"

fakewebpack/%.files: upstream/%
	./fakewebpack-extract-source-map.py upstream/$*/$(TARGET_$*).map \
	  upstream-unpacked/$*/ > fakewebpack/$*.files

.PHONY: all all-diff clean prep
