/*
 * %kadu copyright begin%
 * Copyright 2011 Piotr Galiszewski (piotr.galiszewski@kadu.im)
 * Copyright 2014 Bartosz Brachaczek (b.brachaczek@gmail.com)
 * Copyright 2009, 2010, 2011, 2013 Rafał Przemysław Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "buddies/buddy.h"

#include <QtCore/QModelIndex>
#include <QtCore/QPointer>
#include <QtWidgets/QWidget>
#include <injeqt/injeqt.h>

class BuddyContactsTableDelegate;
class BuddyContactsTableModel;
class BuddyContactsTableModelProxy;
class ConfigurationValueStateNotifier;
class IconsManager;
class InjectedFactory;

class QPushButton;
class QTableView;

class BuddyContactsTable : public QWidget
{
	Q_OBJECT

	QPointer<IconsManager> m_iconsManager;
	QPointer<InjectedFactory> m_injectedFactory;

	Buddy MyBuddy;

	QTableView *View;
	BuddyContactsTableDelegate *Delegate;
	BuddyContactsTableModel *Model;
	BuddyContactsTableModelProxy *Proxy;

	QPushButton *MoveUpButton;
	QPushButton *MoveDownButton;
	QPushButton *AddContactButton;
	QPushButton *DetachContactButton;
	QPushButton *RemoveContactButton;

	void createGui();

private slots:
	INJEQT_SET void setIconsManager(IconsManager *iconsManager);
	INJEQT_SET void setInjectedFactory(InjectedFactory *injectedFactory);
	INJEQT_INIT void init();

	void viewSelectionChanged(const QModelIndex &current, const QModelIndex &previous);

	void moveUpClicked();
	void moveDownClicked();
	void addClicked();
	void detachClicked();
	void removeClicked();

public:
	explicit BuddyContactsTable(Buddy buddy, QWidget *parent = nullptr);
	virtual ~BuddyContactsTable();

	const ConfigurationValueStateNotifier * valueStateNotifier() const;

	void save();

};
