# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementBastionHostsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bastion_hosts_begin_delete(self, resource_group):
        response = self.client.bastion_hosts.begin_delete(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bastion_hosts_get(self, resource_group):
        response = self.client.bastion_hosts.get(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bastion_hosts_begin_create_or_update(self, resource_group):
        response = self.client.bastion_hosts.begin_create_or_update(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            parameters={
                "disableCopyPaste": False,
                "dnsName": "str",
                "enableFileCopy": False,
                "enableIpConnect": False,
                "enableKerberos": False,
                "enablePrivateOnlyBastion": False,
                "enableSessionRecording": False,
                "enableShareableLink": False,
                "enableTunneling": False,
                "etag": "str",
                "id": "str",
                "ipConfigurations": [
                    {
                        "etag": "str",
                        "id": "str",
                        "name": "str",
                        "privateIPAllocationMethod": "str",
                        "provisioningState": "str",
                        "publicIPAddress": {"id": "str"},
                        "subnet": {"id": "str"},
                        "type": "str",
                    }
                ],
                "location": "str",
                "name": "str",
                "networkAcls": {"ipRules": [{"addressPrefix": "str"}]},
                "provisioningState": "str",
                "scaleUnits": 0,
                "sku": {"name": "Standard"},
                "tags": {"str": "str"},
                "type": "str",
                "virtualNetwork": {"id": "str"},
                "zones": ["str"],
            },
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bastion_hosts_begin_update_tags(self, resource_group):
        response = self.client.bastion_hosts.begin_update_tags(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bastion_hosts_list(self, resource_group):
        response = self.client.bastion_hosts.list(
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bastion_hosts_list_by_resource_group(self, resource_group):
        response = self.client.bastion_hosts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
