# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Baseline(_serialization.Model):
    """Baseline details.

    :ivar expected_results: Expected results.
    :vartype expected_results: list[list[str]]
    :ivar updated_time: Baseline update time (UTC).
    :vartype updated_time: ~datetime.datetime
    """

    _attribute_map = {
        "expected_results": {"key": "expectedResults", "type": "[[str]]"},
        "updated_time": {"key": "updatedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        expected_results: Optional[List[List[str]]] = None,
        updated_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expected_results: Expected results.
        :paramtype expected_results: list[list[str]]
        :keyword updated_time: Baseline update time (UTC).
        :paramtype updated_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.expected_results = expected_results
        self.updated_time = updated_time


class BaselineAdjustedResult(_serialization.Model):
    """The rule result adjusted with baseline.

    :ivar baseline: Baseline details.
    :vartype baseline: ~azure.mgmt.security.v2023_02_01_preview.models.Baseline
    :ivar status: The rule result status. Known values are: "NonFinding", "Finding", and
     "InternalError".
    :vartype status: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleStatus
    :ivar results_not_in_baseline: Results the are not in baseline.
    :vartype results_not_in_baseline: list[list[str]]
    :ivar results_only_in_baseline: Results the are in baseline.
    :vartype results_only_in_baseline: list[list[str]]
    """

    _attribute_map = {
        "baseline": {"key": "baseline", "type": "Baseline"},
        "status": {"key": "status", "type": "str"},
        "results_not_in_baseline": {"key": "resultsNotInBaseline", "type": "[[str]]"},
        "results_only_in_baseline": {"key": "resultsOnlyInBaseline", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        baseline: Optional["_models.Baseline"] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        results_not_in_baseline: Optional[List[List[str]]] = None,
        results_only_in_baseline: Optional[List[List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword baseline: Baseline details.
        :paramtype baseline: ~azure.mgmt.security.v2023_02_01_preview.models.Baseline
        :keyword status: The rule result status. Known values are: "NonFinding", "Finding", and
         "InternalError".
        :paramtype status: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleStatus
        :keyword results_not_in_baseline: Results the are not in baseline.
        :paramtype results_not_in_baseline: list[list[str]]
        :keyword results_only_in_baseline: Results the are in baseline.
        :paramtype results_only_in_baseline: list[list[str]]
        """
        super().__init__(**kwargs)
        self.baseline = baseline
        self.status = status
        self.results_not_in_baseline = results_not_in_baseline
        self.results_only_in_baseline = results_only_in_baseline


class BenchmarkReference(_serialization.Model):
    """The benchmark references.

    :ivar benchmark: The benchmark name.
    :vartype benchmark: str
    :ivar reference: The benchmark reference.
    :vartype reference: str
    """

    _attribute_map = {
        "benchmark": {"key": "benchmark", "type": "str"},
        "reference": {"key": "reference", "type": "str"},
    }

    def __init__(self, *, benchmark: Optional[str] = None, reference: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword benchmark: The benchmark name.
        :paramtype benchmark: str
        :keyword reference: The benchmark reference.
        :paramtype reference: str
        """
        super().__init__(**kwargs)
        self.benchmark = benchmark
        self.reference = reference


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2023_02_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2023_02_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class EnvironmentDetails(_serialization.Model):
    """The environment details of the resource.

    :ivar native_resource_id: The native resource id of the resource (in case of Azure - the
     resource Id, in case of MC - the native resource id).
    :vartype native_resource_id: str
    :ivar environment_hierarchy_id: The hierarchy id of the connector (in case of Azure - the
     subscription Id, in case of MC - the hierarchyId id).
    :vartype environment_hierarchy_id: str
    :ivar organizational_hierarchy_id: The organizational hierarchy id of the connector (in case of
     Azure - the subscription Id, in case of MC - the organizational hierarchyId id).
    :vartype organizational_hierarchy_id: str
    :ivar subscription_id: The subscription Id.
    :vartype subscription_id: str
    :ivar tenant_id: The tenant Id.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "native_resource_id": {"key": "nativeResourceId", "type": "str"},
        "environment_hierarchy_id": {"key": "environmentHierarchyId", "type": "str"},
        "organizational_hierarchy_id": {"key": "organizationalHierarchyId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        native_resource_id: Optional[str] = None,
        environment_hierarchy_id: Optional[str] = None,
        organizational_hierarchy_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_resource_id: The native resource id of the resource (in case of Azure - the
         resource Id, in case of MC - the native resource id).
        :paramtype native_resource_id: str
        :keyword environment_hierarchy_id: The hierarchy id of the connector (in case of Azure - the
         subscription Id, in case of MC - the hierarchyId id).
        :paramtype environment_hierarchy_id: str
        :keyword organizational_hierarchy_id: The organizational hierarchy id of the connector (in case
         of Azure - the subscription Id, in case of MC - the organizational hierarchyId id).
        :paramtype organizational_hierarchy_id: str
        :keyword subscription_id: The subscription Id.
        :paramtype subscription_id: str
        :keyword tenant_id: The tenant Id.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.native_resource_id = native_resource_id
        self.environment_hierarchy_id = environment_hierarchy_id
        self.organizational_hierarchy_id = organizational_hierarchy_id
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2023_02_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2023_02_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.v2023_02_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.v2023_02_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class HealthDataClassification(_serialization.Model):
    """The classification of the health report.

    :ivar component: The component describes the name of the agent/service that scans the issue.
    :vartype component: str
    :ivar scenario: The scenario describes the health scenario issue of the component.
    :vartype scenario: str
    :ivar scope: The resource scope of the health report. Known values are: "Connectors",
     "Clusters", "VirtualMachines", and "Unknown".
    :vartype scope: str or ~azure.mgmt.security.v2023_02_01_preview.models.ScopeName
    """

    _attribute_map = {
        "component": {"key": "component", "type": "str"},
        "scenario": {"key": "scenario", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        component: Optional[str] = None,
        scenario: Optional[str] = None,
        scope: Optional[Union[str, "_models.ScopeName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component: The component describes the name of the agent/service that scans the issue.
        :paramtype component: str
        :keyword scenario: The scenario describes the health scenario issue of the component.
        :paramtype scenario: str
        :keyword scope: The resource scope of the health report. Known values are: "Connectors",
         "Clusters", "VirtualMachines", and "Unknown".
        :paramtype scope: str or ~azure.mgmt.security.v2023_02_01_preview.models.ScopeName
        """
        super().__init__(**kwargs)
        self.component = component
        self.scenario = scenario
        self.scope = scope


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class HealthReport(Resource):
    """The health report resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_details: The resource details of the health report.
    :vartype resource_details: ~azure.mgmt.security.v2023_02_01_preview.models.ResourceDetails
    :ivar environment_details: The environment details of the resource.
    :vartype environment_details:
     ~azure.mgmt.security.v2023_02_01_preview.models.EnvironmentDetails
    :ivar health_data_classification: The classification of the health report.
    :vartype health_data_classification:
     ~azure.mgmt.security.v2023_02_01_preview.models.HealthDataClassification
    :ivar status: The status of the health report.
    :vartype status: ~azure.mgmt.security.v2023_02_01_preview.models.Status
    :ivar affected_defenders_plans: The affected defenders plans by unhealthy report.
    :vartype affected_defenders_plans: list[str]
    :ivar issues: A collection of the issues in the report.
    :vartype issues: list[~azure.mgmt.security.v2023_02_01_preview.models.Issue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "environment_details": {"key": "properties.environmentDetails", "type": "EnvironmentDetails"},
        "health_data_classification": {
            "key": "properties.healthDataClassification",
            "type": "HealthDataClassification",
        },
        "status": {"key": "properties.status", "type": "Status"},
        "affected_defenders_plans": {"key": "properties.affectedDefendersPlans", "type": "[str]"},
        "issues": {"key": "properties.issues", "type": "[Issue]"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.ResourceDetails"] = None,
        environment_details: Optional["_models.EnvironmentDetails"] = None,
        health_data_classification: Optional["_models.HealthDataClassification"] = None,
        status: Optional["_models.Status"] = None,
        affected_defenders_plans: Optional[List[str]] = None,
        issues: Optional[List["_models.Issue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: The resource details of the health report.
        :paramtype resource_details: ~azure.mgmt.security.v2023_02_01_preview.models.ResourceDetails
        :keyword environment_details: The environment details of the resource.
        :paramtype environment_details:
         ~azure.mgmt.security.v2023_02_01_preview.models.EnvironmentDetails
        :keyword health_data_classification: The classification of the health report.
        :paramtype health_data_classification:
         ~azure.mgmt.security.v2023_02_01_preview.models.HealthDataClassification
        :keyword status: The status of the health report.
        :paramtype status: ~azure.mgmt.security.v2023_02_01_preview.models.Status
        :keyword affected_defenders_plans: The affected defenders plans by unhealthy report.
        :paramtype affected_defenders_plans: list[str]
        :keyword issues: A collection of the issues in the report.
        :paramtype issues: list[~azure.mgmt.security.v2023_02_01_preview.models.Issue]
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.environment_details = environment_details
        self.health_data_classification = health_data_classification
        self.status = status
        self.affected_defenders_plans = affected_defenders_plans
        self.issues = issues


class HealthReportsList(_serialization.Model):
    """Page of health reports list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of health reports in this page.
    :vartype value: list[~azure.mgmt.security.v2023_02_01_preview.models.HealthReport]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HealthReport]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Issue(_serialization.Model):
    """The issue that caused the resource to by unhealthy.

    All required parameters must be populated in order to send to server.

    :ivar issue_key: The unique issue key. Required.
    :vartype issue_key: str
    :ivar issue_name: The issue name.
    :vartype issue_name: str
    :ivar security_values: The affected security values that MDC offers that will be affected by
     the issue, for example: recommendations, alerts, etc.
    :vartype security_values: list[str]
    :ivar issue_description: The issue description.
    :vartype issue_description: str
    :ivar remediation_steps: Human readable description of what you should do to mitigate this
     health issue.
    :vartype remediation_steps: str
    :ivar remediation_script: The remediation script to solve this issue.
    :vartype remediation_script: str
    :ivar issue_additional_data: Additional data for the given issue. The additional data depends
     on the issue type.
    :vartype issue_additional_data: dict[str, str]
    """

    _validation = {
        "issue_key": {"required": True},
    }

    _attribute_map = {
        "issue_key": {"key": "issueKey", "type": "str"},
        "issue_name": {"key": "issueName", "type": "str"},
        "security_values": {"key": "securityValues", "type": "[str]"},
        "issue_description": {"key": "issueDescription", "type": "str"},
        "remediation_steps": {"key": "remediationSteps", "type": "str"},
        "remediation_script": {"key": "remediationScript", "type": "str"},
        "issue_additional_data": {"key": "issueAdditionalData", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        issue_key: str,
        issue_name: Optional[str] = None,
        security_values: Optional[List[str]] = None,
        issue_description: Optional[str] = None,
        remediation_steps: Optional[str] = None,
        remediation_script: Optional[str] = None,
        issue_additional_data: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issue_key: The unique issue key. Required.
        :paramtype issue_key: str
        :keyword issue_name: The issue name.
        :paramtype issue_name: str
        :keyword security_values: The affected security values that MDC offers that will be affected by
         the issue, for example: recommendations, alerts, etc.
        :paramtype security_values: list[str]
        :keyword issue_description: The issue description.
        :paramtype issue_description: str
        :keyword remediation_steps: Human readable description of what you should do to mitigate this
         health issue.
        :paramtype remediation_steps: str
        :keyword remediation_script: The remediation script to solve this issue.
        :paramtype remediation_script: str
        :keyword issue_additional_data: Additional data for the given issue. The additional data
         depends on the issue type.
        :paramtype issue_additional_data: dict[str, str]
        """
        super().__init__(**kwargs)
        self.issue_key = issue_key
        self.issue_name = issue_name
        self.security_values = security_values
        self.issue_description = issue_description
        self.remediation_steps = remediation_steps
        self.remediation_script = remediation_script
        self.issue_additional_data = issue_additional_data


class QueryCheck(_serialization.Model):
    """The rule query details.

    :ivar query: The rule query.
    :vartype query: str
    :ivar expected_result: Expected result.
    :vartype expected_result: list[list[str]]
    :ivar column_names: Column names of expected result.
    :vartype column_names: list[str]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "expected_result": {"key": "expectedResult", "type": "[[str]]"},
        "column_names": {"key": "columnNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        expected_result: Optional[List[List[str]]] = None,
        column_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: The rule query.
        :paramtype query: str
        :keyword expected_result: Expected result.
        :paramtype expected_result: list[list[str]]
        :keyword column_names: Column names of expected result.
        :paramtype column_names: list[str]
        """
        super().__init__(**kwargs)
        self.query = query
        self.expected_result = expected_result
        self.column_names = column_names


class Remediation(_serialization.Model):
    """Remediation details.

    :ivar description: Remediation description.
    :vartype description: str
    :ivar scripts: Remediation script.
    :vartype scripts: list[str]
    :ivar automated: Is remediation automated.
    :vartype automated: bool
    :ivar portal_link: Optional link to remediate in Azure Portal.
    :vartype portal_link: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scripts": {"key": "scripts", "type": "[str]"},
        "automated": {"key": "automated", "type": "bool"},
        "portal_link": {"key": "portalLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        scripts: Optional[List[str]] = None,
        automated: Optional[bool] = None,
        portal_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Remediation description.
        :paramtype description: str
        :keyword scripts: Remediation script.
        :paramtype scripts: list[str]
        :keyword automated: Is remediation automated.
        :paramtype automated: bool
        :keyword portal_link: Optional link to remediate in Azure Portal.
        :paramtype portal_link: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.scripts = scripts
        self.automated = automated
        self.portal_link = portal_link


class ResourceDetails(_serialization.Model):
    """The resource details of the health report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: The status of the health report. Known values are: "Aws", "Gcp", and "Azure".
    :vartype source: str or ~azure.mgmt.security.v2023_02_01_preview.models.Source
    :ivar id: The azure id of the resource.
    :vartype id: str
    :ivar connector_id: The id of the connector.
    :vartype connector_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "connector_id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "connector_id": {"key": "connectorId", "type": "str"},
    }

    def __init__(self, *, source: Optional[Union[str, "_models.Source"]] = None, **kwargs: Any) -> None:
        """
        :keyword source: The status of the health report. Known values are: "Aws", "Gcp", and "Azure".
        :paramtype source: str or ~azure.mgmt.security.v2023_02_01_preview.models.Source
        """
        super().__init__(**kwargs)
        self.source = source
        self.id = None
        self.connector_id = None


class RuleResults(Resource):
    """Rule results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Rule results properties.
    :vartype properties: ~azure.mgmt.security.v2023_02_01_preview.models.RuleResultsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "RuleResultsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.RuleResultsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Rule results properties.
        :paramtype properties: ~azure.mgmt.security.v2023_02_01_preview.models.RuleResultsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RuleResultsInput(_serialization.Model):
    """Rule results input.

    :ivar latest_scan: Take results from latest scan.
    :vartype latest_scan: bool
    :ivar results: Expected results to be inserted into the baseline.
     Leave this field empty it LatestScan == true.
    :vartype results: list[list[str]]
    """

    _attribute_map = {
        "latest_scan": {"key": "latestScan", "type": "bool"},
        "results": {"key": "results", "type": "[[str]]"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[List[List[str]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_scan: Take results from latest scan.
        :paramtype latest_scan: bool
        :keyword results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.latest_scan = latest_scan
        self.results = results


class RuleResultsProperties(_serialization.Model):
    """Rule results properties.

    :ivar results: Expected results in the baseline.
    :vartype results: list[list[str]]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[[str]]"},
    }

    def __init__(self, *, results: Optional[List[List[str]]] = None, **kwargs: Any) -> None:
        """
        :keyword results: Expected results in the baseline.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.results = results


class RulesResults(_serialization.Model):
    """A list of rules results.

    :ivar value: List of rule results.
    :vartype value: list[~azure.mgmt.security.v2023_02_01_preview.models.RuleResults]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RuleResults]"},
    }

    def __init__(self, *, value: Optional[List["_models.RuleResults"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of rule results.
        :paramtype value: list[~azure.mgmt.security.v2023_02_01_preview.models.RuleResults]
        """
        super().__init__(**kwargs)
        self.value = value


class RulesResultsInput(_serialization.Model):
    """Rules results input.

    :ivar latest_scan: Take results from latest scan.
    :vartype latest_scan: bool
    :ivar results: Expected results to be inserted into the baseline.
     Leave this field empty it LatestScan == true.
    :vartype results: dict[str, list[list[str]]]
    """

    _attribute_map = {
        "latest_scan": {"key": "latestScan", "type": "bool"},
        "results": {"key": "results", "type": "{[[str]]}"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[Dict[str, List[List[str]]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_scan: Take results from latest scan.
        :paramtype latest_scan: bool
        :keyword results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :paramtype results: dict[str, list[list[str]]]
        """
        super().__init__(**kwargs)
        self.latest_scan = latest_scan
        self.results = results


class Scan(Resource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: A vulnerability assessment scan record properties.
    :vartype properties: ~azure.mgmt.security.v2023_02_01_preview.models.ScanProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ScanProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ScanProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: A vulnerability assessment scan record properties.
        :paramtype properties: ~azure.mgmt.security.v2023_02_01_preview.models.ScanProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ScanProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A vulnerability assessment scan record properties.

    :ivar trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
    :vartype trigger_type: str or ~azure.mgmt.security.v2023_02_01_preview.models.ScanTriggerType
    :ivar state: The scan status. Known values are: "Failed", "FailedToRun", "InProgress", and
     "Passed".
    :vartype state: str or ~azure.mgmt.security.v2023_02_01_preview.models.ScanState
    :ivar server: The server name.
    :vartype server: str
    :ivar database: The database name.
    :vartype database: str
    :ivar sql_version: The SQL version.
    :vartype sql_version: str
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Scan results are valid until end time (UTC).
    :vartype end_time: ~datetime.datetime
    :ivar high_severity_failed_rules_count: The number of failed rules with high severity.
    :vartype high_severity_failed_rules_count: int
    :ivar medium_severity_failed_rules_count: The number of failed rules with medium severity.
    :vartype medium_severity_failed_rules_count: int
    :ivar low_severity_failed_rules_count: The number of failed rules with low severity.
    :vartype low_severity_failed_rules_count: int
    :ivar total_passed_rules_count: The number of total passed rules.
    :vartype total_passed_rules_count: int
    :ivar total_failed_rules_count: The number of total failed rules.
    :vartype total_failed_rules_count: int
    :ivar total_rules_count: The number of total rules assessed.
    :vartype total_rules_count: int
    :ivar is_baseline_applied: Baseline created for this database, and has one or more rules.
    :vartype is_baseline_applied: bool
    :ivar last_scan_time: Last scan time.
    :vartype last_scan_time: ~datetime.datetime
    """

    _attribute_map = {
        "trigger_type": {"key": "triggerType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "sql_version": {"key": "sqlVersion", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "high_severity_failed_rules_count": {"key": "highSeverityFailedRulesCount", "type": "int"},
        "medium_severity_failed_rules_count": {"key": "mediumSeverityFailedRulesCount", "type": "int"},
        "low_severity_failed_rules_count": {"key": "lowSeverityFailedRulesCount", "type": "int"},
        "total_passed_rules_count": {"key": "totalPassedRulesCount", "type": "int"},
        "total_failed_rules_count": {"key": "totalFailedRulesCount", "type": "int"},
        "total_rules_count": {"key": "totalRulesCount", "type": "int"},
        "is_baseline_applied": {"key": "isBaselineApplied", "type": "bool"},
        "last_scan_time": {"key": "lastScanTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        trigger_type: Optional[Union[str, "_models.ScanTriggerType"]] = None,
        state: Optional[Union[str, "_models.ScanState"]] = None,
        server: Optional[str] = None,
        database: Optional[str] = None,
        sql_version: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        high_severity_failed_rules_count: Optional[int] = None,
        medium_severity_failed_rules_count: Optional[int] = None,
        low_severity_failed_rules_count: Optional[int] = None,
        total_passed_rules_count: Optional[int] = None,
        total_failed_rules_count: Optional[int] = None,
        total_rules_count: Optional[int] = None,
        is_baseline_applied: Optional[bool] = None,
        last_scan_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
        :paramtype trigger_type: str or ~azure.mgmt.security.v2023_02_01_preview.models.ScanTriggerType
        :keyword state: The scan status. Known values are: "Failed", "FailedToRun", "InProgress", and
         "Passed".
        :paramtype state: str or ~azure.mgmt.security.v2023_02_01_preview.models.ScanState
        :keyword server: The server name.
        :paramtype server: str
        :keyword database: The database name.
        :paramtype database: str
        :keyword sql_version: The SQL version.
        :paramtype sql_version: str
        :keyword start_time: The scan start time (UTC).
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Scan results are valid until end time (UTC).
        :paramtype end_time: ~datetime.datetime
        :keyword high_severity_failed_rules_count: The number of failed rules with high severity.
        :paramtype high_severity_failed_rules_count: int
        :keyword medium_severity_failed_rules_count: The number of failed rules with medium severity.
        :paramtype medium_severity_failed_rules_count: int
        :keyword low_severity_failed_rules_count: The number of failed rules with low severity.
        :paramtype low_severity_failed_rules_count: int
        :keyword total_passed_rules_count: The number of total passed rules.
        :paramtype total_passed_rules_count: int
        :keyword total_failed_rules_count: The number of total failed rules.
        :paramtype total_failed_rules_count: int
        :keyword total_rules_count: The number of total rules assessed.
        :paramtype total_rules_count: int
        :keyword is_baseline_applied: Baseline created for this database, and has one or more rules.
        :paramtype is_baseline_applied: bool
        :keyword last_scan_time: Last scan time.
        :paramtype last_scan_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.trigger_type = trigger_type
        self.state = state
        self.server = server
        self.database = database
        self.sql_version = sql_version
        self.start_time = start_time
        self.end_time = end_time
        self.high_severity_failed_rules_count = high_severity_failed_rules_count
        self.medium_severity_failed_rules_count = medium_severity_failed_rules_count
        self.low_severity_failed_rules_count = low_severity_failed_rules_count
        self.total_passed_rules_count = total_passed_rules_count
        self.total_failed_rules_count = total_failed_rules_count
        self.total_rules_count = total_rules_count
        self.is_baseline_applied = is_baseline_applied
        self.last_scan_time = last_scan_time


class ScanResult(Resource):
    """A vulnerability assessment scan result for a single rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: A vulnerability assessment scan result properties for a single rule.
    :vartype properties: ~azure.mgmt.security.v2023_02_01_preview.models.ScanResultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ScanResultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ScanResultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: A vulnerability assessment scan result properties for a single rule.
        :paramtype properties: ~azure.mgmt.security.v2023_02_01_preview.models.ScanResultProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ScanResultProperties(_serialization.Model):
    """A vulnerability assessment scan result properties for a single rule.

    :ivar rule_id: The rule Id.
    :vartype rule_id: str
    :ivar status: The rule result status. Known values are: "NonFinding", "Finding", and
     "InternalError".
    :vartype status: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleStatus
    :ivar is_trimmed: Indicated whether the results specified here are trimmed.
    :vartype is_trimmed: bool
    :ivar query_results: The results of the query that was run.
    :vartype query_results: list[list[str]]
    :ivar remediation: Remediation details.
    :vartype remediation: ~azure.mgmt.security.v2023_02_01_preview.models.Remediation
    :ivar baseline_adjusted_result: The rule result adjusted with baseline.
    :vartype baseline_adjusted_result:
     ~azure.mgmt.security.v2023_02_01_preview.models.BaselineAdjustedResult
    :ivar rule_metadata: vulnerability assessment rule metadata details.
    :vartype rule_metadata: ~azure.mgmt.security.v2023_02_01_preview.models.VaRule
    """

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "is_trimmed": {"key": "isTrimmed", "type": "bool"},
        "query_results": {"key": "queryResults", "type": "[[str]]"},
        "remediation": {"key": "remediation", "type": "Remediation"},
        "baseline_adjusted_result": {"key": "baselineAdjustedResult", "type": "BaselineAdjustedResult"},
        "rule_metadata": {"key": "ruleMetadata", "type": "VaRule"},
    }

    def __init__(
        self,
        *,
        rule_id: Optional[str] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        is_trimmed: Optional[bool] = None,
        query_results: Optional[List[List[str]]] = None,
        remediation: Optional["_models.Remediation"] = None,
        baseline_adjusted_result: Optional["_models.BaselineAdjustedResult"] = None,
        rule_metadata: Optional["_models.VaRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_id: The rule Id.
        :paramtype rule_id: str
        :keyword status: The rule result status. Known values are: "NonFinding", "Finding", and
         "InternalError".
        :paramtype status: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleStatus
        :keyword is_trimmed: Indicated whether the results specified here are trimmed.
        :paramtype is_trimmed: bool
        :keyword query_results: The results of the query that was run.
        :paramtype query_results: list[list[str]]
        :keyword remediation: Remediation details.
        :paramtype remediation: ~azure.mgmt.security.v2023_02_01_preview.models.Remediation
        :keyword baseline_adjusted_result: The rule result adjusted with baseline.
        :paramtype baseline_adjusted_result:
         ~azure.mgmt.security.v2023_02_01_preview.models.BaselineAdjustedResult
        :keyword rule_metadata: vulnerability assessment rule metadata details.
        :paramtype rule_metadata: ~azure.mgmt.security.v2023_02_01_preview.models.VaRule
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.status = status
        self.is_trimmed = is_trimmed
        self.query_results = query_results
        self.remediation = remediation
        self.baseline_adjusted_result = baseline_adjusted_result
        self.rule_metadata = rule_metadata


class ScanResults(_serialization.Model):
    """A list of vulnerability assessment scan results.

    :ivar value: List of vulnerability assessment scan results.
    :vartype value: list[~azure.mgmt.security.v2023_02_01_preview.models.ScanResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ScanResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.ScanResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of vulnerability assessment scan results.
        :paramtype value: list[~azure.mgmt.security.v2023_02_01_preview.models.ScanResult]
        """
        super().__init__(**kwargs)
        self.value = value


class Scans(_serialization.Model):
    """A list of vulnerability assessment scan records.

    :ivar value: List of vulnerability assessment scan records.
    :vartype value: list[~azure.mgmt.security.v2023_02_01_preview.models.Scan]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Scan]"},
    }

    def __init__(self, *, value: Optional[List["_models.Scan"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of vulnerability assessment scan records.
        :paramtype value: list[~azure.mgmt.security.v2023_02_01_preview.models.Scan]
        """
        super().__init__(**kwargs)
        self.value = value


class Status(_serialization.Model):
    """The status of the health report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status of the health report. Known values are: "Healthy", "NotHealthy", and
     "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.v2023_02_01_preview.models.StatusName
    :ivar status_change_date: The date of when the status of the health report was changed in the
     last time.
    :vartype status_change_date: ~datetime.datetime
    :ivar first_evaluation_date: The date of when the resource of the health report was scanned in
     the first time.
    :vartype first_evaluation_date: ~datetime.datetime
    """

    _validation = {
        "status_change_date": {"readonly": True},
        "first_evaluation_date": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "status_change_date": {"key": "statusChangeDate", "type": "iso-8601"},
        "first_evaluation_date": {"key": "firstEvaluationDate", "type": "iso-8601"},
    }

    def __init__(self, *, code: Optional[Union[str, "_models.StatusName"]] = None, **kwargs: Any) -> None:
        """
        :keyword code: The status of the health report. Known values are: "Healthy", "NotHealthy", and
         "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.v2023_02_01_preview.models.StatusName
        """
        super().__init__(**kwargs)
        self.code = code
        self.status_change_date = None
        self.first_evaluation_date = None


class VaRule(_serialization.Model):
    """vulnerability assessment rule metadata details.

    :ivar rule_id: The rule Id.
    :vartype rule_id: str
    :ivar severity: The rule severity. Known values are: "High", "Medium", "Low", "Informational",
     and "Obsolete".
    :vartype severity: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleSeverity
    :ivar category: The rule category.
    :vartype category: str
    :ivar rule_type: The rule type. Known values are: "Binary", "BaselineExpected", "PositiveList",
     and "NegativeList".
    :vartype rule_type: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleType
    :ivar title: The rule title.
    :vartype title: str
    :ivar description: The rule description.
    :vartype description: str
    :ivar rationale: The rule rationale.
    :vartype rationale: str
    :ivar query_check: The rule query details.
    :vartype query_check: ~azure.mgmt.security.v2023_02_01_preview.models.QueryCheck
    :ivar benchmark_references: The benchmark references.
    :vartype benchmark_references:
     list[~azure.mgmt.security.v2023_02_01_preview.models.BenchmarkReference]
    """

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rationale": {"key": "rationale", "type": "str"},
        "query_check": {"key": "queryCheck", "type": "QueryCheck"},
        "benchmark_references": {"key": "benchmarkReferences", "type": "[BenchmarkReference]"},
    }

    def __init__(
        self,
        *,
        rule_id: Optional[str] = None,
        severity: Optional[Union[str, "_models.RuleSeverity"]] = None,
        category: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.RuleType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        rationale: Optional[str] = None,
        query_check: Optional["_models.QueryCheck"] = None,
        benchmark_references: Optional[List["_models.BenchmarkReference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_id: The rule Id.
        :paramtype rule_id: str
        :keyword severity: The rule severity. Known values are: "High", "Medium", "Low",
         "Informational", and "Obsolete".
        :paramtype severity: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleSeverity
        :keyword category: The rule category.
        :paramtype category: str
        :keyword rule_type: The rule type. Known values are: "Binary", "BaselineExpected",
         "PositiveList", and "NegativeList".
        :paramtype rule_type: str or ~azure.mgmt.security.v2023_02_01_preview.models.RuleType
        :keyword title: The rule title.
        :paramtype title: str
        :keyword description: The rule description.
        :paramtype description: str
        :keyword rationale: The rule rationale.
        :paramtype rationale: str
        :keyword query_check: The rule query details.
        :paramtype query_check: ~azure.mgmt.security.v2023_02_01_preview.models.QueryCheck
        :keyword benchmark_references: The benchmark references.
        :paramtype benchmark_references:
         list[~azure.mgmt.security.v2023_02_01_preview.models.BenchmarkReference]
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.severity = severity
        self.category = category
        self.rule_type = rule_type
        self.title = title
        self.description = description
        self.rationale = rationale
        self.query_check = query_check
        self.benchmark_references = benchmark_references
