#version 330

layout(triangles) in;
layout(triangle_strip, max_vertices = 56) out;
//layout(line_strip, max_vertices = 51) out;

int inl = gl_in.length();//triangles
in vec3 center[];
in float an[];
in float style[];
in vec3 eigenvalues[];
in float ci[];
in vec4 rotarr[];
in float peakheight[];
in float sg[];
in float part[];
in float mi[];
in float idx[];
in float auidx[];
in float resinr[];

uniform mat4 pmv;
uniform mat3 normalMatrix;
uniform float fiftypct = 1.54;
uniform int LOD = 2;
uniform float qpeakrad = 0.10;
uniform float qcutoff = -10.0;
uniform bool adp = true;
uniform float arad[109];
uniform bool tubes = false;
uniform bool ballStick = true;
uniform float bondradius = 0.09f;
//uniform int inFocus = -1;
uniform bool hideHydrogen = false;
uniform bool bede = true;

//flat out int Idx;
//flat out int AuIdx;
//flat out int ResiNr;
out vec3 Normal;
out vec3 vert;
out vec3 nor;
flat out int _an;
//flat out int _mi;
flat out int _sg;
flat out float _part;
out float _ph;
flat out int _style;

out gl_PerVertex{
  vec4 gl_Position;
};

mat4 r = mat4(1);
mat3 NR = mat3(1);

const float PI = 3.14159265359;
//*
#define HAS_WALLS 1
#define HAS_RINGS 2
#define HAS_SPHERE 4
#define IS_SOLID 8
#define HAS_WHITERING 16
#define HAS_NOLABEL 32
#define HAS_NOADP 64
#define HAS_PLAID 128
#define IS_METAL 256
#define IS_HIDDEN 512
#define IS_DEUTERIUM 1024
#define IS_ISO 2048
// */

mat4 rmat(vec4 arr, vec3 ev){
  float phi=-arr.x / 180 * PI;
  if (((int(style[0]) & IS_ISO)==IS_ISO)||((int(style[0]) &HAS_NOADP)==HAS_NOADP)) phi = 0.0;//is iso then phi = 0
  if (!adp) phi = 0.0;
  float c = cos(phi);
  float s = sin(phi);
  float omc = 1.0 - c;
  vec3 ar = arr.yzw;
  mat4 scale = mat4(ev.x * fiftypct,0,0,0, 0,ev.y * fiftypct,0,0, 0,0,ev.z * fiftypct,0, 0,0,0,1);
  if (an[0]<0) scale = mat4(mat3((an[0]<-65)?qpeakrad*2:qpeakrad));
  else if ((!adp)||((int(style[0]) &HAS_NOADP)==HAS_NOADP)) scale = mat4(mat3((tubes)?bondradius: arad[int(an[0])]));//arad comes here!
  mat4 m =
    mat4(c+ar.x*ar.x*omc,ar.x*ar.y*omc-s*ar.z,ar.x*ar.z*omc+s*ar.y,0,
      ar.x*ar.y*omc+s*ar.z,c+ar.y*ar.y*omc,ar.y*ar.z*omc-s*ar.x,0,
      ar.x*ar.z*omc-s*ar.y,ar.y*ar.z*omc+s*ar.x,c+ar.z*ar.z*omc,0,
      0,0,0,1);
  return m * scale;
}

mat4 rmat(float angle, vec3 ar){
  float phi = -angle / 180 * PI;
  float c = cos(phi);
  float s = sin(phi);
  float omc = 1.0 - c;
  mat4 m =
    mat4(c+ar.x*ar.x*omc,ar.x*ar.y*omc-s*ar.z,ar.x*ar.z*omc+s*ar.y,0,
      ar.x*ar.y*omc+s*ar.z,c+ar.y*ar.y*omc,ar.y*ar.z*omc-s*ar.x,0,
      ar.x*ar.z*omc-s*ar.y,ar.y*ar.z*omc+s*ar.x,c+ar.z*ar.z*omc,0,
      0,0,0,1);
  return m;
}

mat3 normama(mat4 m){// normalMatrix
  return  transpose(inverse(mat3(m)));
}
/*
vec3 normalVector(vec3 p1, vec3 p2, vec3 p3){
   return normalize(cross(p1-p2,p3-p2));
}
*/
/* // for debuging ...
void justATriangle(){
vec3 fn = normalize(normalMatrix * vec3(0,0,1));


Normal = normalize(normalMatrix * vec3(0,0,1));
vert = vec3(0,0.5,0);
_an = -1;//int(an[0]);
_ph = ci[0];//gl_in[1].gl_Position.x;
_sg = 0;
_rn = 0;
_style = 0;
gl_Position = pmv * vec4(vert,1);
EmitVertex();


Normal = normalize(normalMatrix * vec3(0,0,1));
vert = vec3(0.433,-0.25,0);
_an = -1;//int(an[1]);
_ph = ci[1];//gl_in[1].gl_Position.y;
_sg = 0;
_rn = 0;
_style = 0;
gl_Position = pmv * vec4(vert,1);;
EmitVertex();


Normal = normalize(normalMatrix * vec3(0,0,1));
vert = vec3(-0.433,-0.25,0);
_an = -1;//int(an[2]);
_ph = ci[2];//gl_in[1].gl_Position.z;
_sg = 0;
_rn = 0;
_style = 0;
gl_Position = pmv * vec4(vert,1);;
EmitVertex();
EndPrimitive();
}
// */
void dodecahedron(vec4 mitte, int an, int _sgi, float _prt, int style){//an -66 centroids
  int facecode = int(ci[0])*256+int(ci[1])*16+int(ci[2]);
  vec3 rotaxe = vec3(1,0,0);
  switch (facecode){// 20 faces 3 permutations
    case 0x108://0
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x810://0
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x081://0 => 0
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x405://1
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x540://1
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x045://1 => 4
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x50a://2
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0xa50://2
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x0a5://2 => 5
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x804://3
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x480://3
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x048://3 => 8
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0xa01://4
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x1a0://4
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x01a://4 => 1
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x618://5
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x861://5
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x186://5 => 6
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x716://6
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x671://6
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x167://6 => 7
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0xa17://7
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x7a1://7
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x17a://7 => a
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x32b://8
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0xb32://8
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x2b3://8 => 2
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x429://9
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x942://9
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x294://9 => 9
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    //case 0x524://10
    //case 0x452://10
    //case 0x245://10 => skip
    //break;
    case 0x923://11
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    case 0x392://11
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x239://11 => 3
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0xb25://12
     rotaxe = normalize(gl_in[0].gl_Position.xyz);
     break;
    case 0x5b2://12
     rotaxe = normalize(gl_in[1].gl_Position.xyz);
     break;
    case 0x25b://12 => b
     rotaxe = normalize(gl_in[2].gl_Position.xyz);
     break;
    //case 0x637://13
    //case 0x637://13
    //case 0x637://13
    //break;
    //case 0x73b://14
    //case 0x73b://14
    //case 0x73b://14
    //break;
    //case 0x936://15
    //case 0x936://15
    //case 0x936://15
    //break;
    //case 0x849://16
    //case 0x849://16
    //case 0x849://16
    //break;
    //case 0xb5a://17
    //case 0xb5a://17
    //case 0xb5a://17
    //break;
    //case 0x968://18
    //case 0x968://18
    //case 0x968://18
    //break;
    //case 0xa7b://19
    //case 0xa7b://19
    //case 0xa7b://19
    default://
    return;
  }
  vec3 pp[5];
  pp[0] = normalize(gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz);//1st point is the mid point of the triangle
  for (int i = 1; i < 5; i++){
    pp[i] = mat3(rmat(72.0, rotaxe)) * pp[i - 1];
  }
/* __3__
  /     \
 4       2  this is a pentagon
  \     /
   0---1
*/
  int idx[] = int[5](1, 2, 0, 3, 4);
  float ph = peakheight[0];
  for (int i = 0; i < idx.length(); i++){
    nor = normalize(rotaxe);
    Normal = normalize(normalMatrix * nor);
    vert = pp[idx[i]];
    _an = an;
    _ph = ph;
    _sg = _sgi;
    _part =_prt;
    _style = style;
    gl_Position = pmv * ((r * vec4(pp[idx[i]],1)) + mitte);
    EmitVertex();
  }
  EndPrimitive();
}

void cube(vec4 mitte, int an, int _sgi, float _prt, int style){
//1, 0, 8,
  if ((int(ci[0])==1)&&(int(ci[1])==0)&&(int(ci[2])==8)){//only one face creates the whole cube
  float a=inversesqrt(3.0);
  vec3 cp[] = vec3[8](vec3( a, a, a), vec3( a, a,-a), vec3( a,-a, a), vec3( a,-a,-a), vec3(-a, a, a), vec3(-a, a,-a), vec3(-a,-a, a), vec3(-a,-a,-a));
  vec3 cn[] = vec3[6](vec3( 1,0,0), vec3(0,0, 1), vec3(0, 1,0), vec3(0,-1,0), vec3(0,0,-1), vec3(-1,0,0));
  int idx[] =int[29](0,2,1,3,-1, 0,4,2,6,-1, 0,1,4,5,-1, 2,6,3,7,-1, 1,3,5,7,-1, 4,5,6,7);
  for (int i = 0; i < idx.length(); i++){
    if (idx[i]<0){
      EndPrimitive();
      continue;
    }
    Normal = normalize(normalMatrix * normalize(mat3(r) * cn[i/5]));
    vert = cp[idx[i]];
    _an = an;
    _ph = peakheight[0];
    _sg = _sgi;
    _part =_prt;
    _style = style|HAS_NOADP|IS_SOLID;
    gl_Position = pmv * ((r * vec4(cp[idx[i]],1)) + mitte);
    EmitVertex();
  }
  EndPrimitive();
  }
}

void pappe(vec4 mitte, int an, int _sgi, float _prt, int style){
  if ((style & HAS_WALLS)==0) return;
  int facecode = int(ci[0])*256+int(ci[1])*16+int(ci[2]);
  int start=0;
  int end=0;
  switch (facecode){
  //case 0x849: start=0; end=4; break;
  case 0xb5a: start=0; end=4; break;
  case 0x968: start=4; end=8; break;
  case 0xa7b: start=8; end=12; break;
  default: return;
  }

  float p=1.0;
  vec3 eck[] = vec3[12](vec3(-p,-p, 0),vec3(p,-p, 0),vec3(-p, p, 0),vec3( p, p, 0),
                        vec3(-p, 0,-p),vec3(p, 0,-p),vec3(-p, 0, p),vec3( p, 0, p),
                        vec3( 0,-p,-p),vec3(0, p,-p),vec3( 0,-p, p),vec3( 0, p, p));
  vec3 nml[] = vec3[12](vec3(0,0,1.0),vec3(0,0,1.0),vec3(0,0,1.0),vec3(0,0,1.0),
                        vec3(0,1.0,0),vec3(0,1.0,0),vec3(0,1.0,0),vec3(0,1.0,0),
                        vec3(1.0,0,0),vec3(1.0,0,0),vec3(1.0,0,0),vec3(1.0,0,0));
  for (int i=start; i<end;i++){
    Normal = normalize(normalMatrix * normalize(mat3(r) * nml[i]));
    vert = eck[i];
    _an = an;
    _ph = peakheight[0];
    _sg = _sgi;
    _part = _prt;
    _style = style|IS_SOLID|HAS_PLAID;
    gl_Position = pmv * ((r * vec4(eck[i],1)) + mitte);
    EmitVertex();
    if ((i%4)==3)EndPrimitive();
  }
  EndPrimitive(); //*/

}

void icosa(vec4 mitte, int an, int _sgi, float _prt, int style){
if ((an==-1)&&(peakheight[0]<qcutoff)) return;
vec3 nfn = vec3(1,0,0);
nfn =  normalize(gl_in[0].gl_Position.xyz+gl_in[1].gl_Position.xyz+gl_in[2].gl_Position.xyz);
for (int i = 0; i < inl; i++){
  nor = ((an<0)?nfn:(gl_in[i].gl_Position.xyz));
  Normal = normalize(normalMatrix * NR * nor);
  vert = gl_in[i].gl_Position.xyz;
  _an = an;
  _ph = peakheight[i];
  _sg = _sgi;
  _part = _prt;
  _style = style;
  gl_Position = pmv * ((r * gl_in[i].gl_Position) + mitte);
  EmitVertex();
}
EndPrimitive();
}

void icosaLOD(vec4 mitte, int an, int _sgi, float _prt, int style, int lod){
  int idx[271];
  for (int i = 0; i < idx.length(); i++) idx[i] = -1;
  vec3 np[137];
  int v[256];
  {
    int i = 0;
    for (int h = 0; h <= lod; h++){
      for (int k = 0; k <= lod; k++){
        for (int l = 0;  l <= lod; l++){
          if (h + k + l == lod){
            np[i] = normalize(h * gl_in[0].gl_Position.xyz + k * gl_in[1].gl_Position.xyz + l * gl_in[2].gl_Position.xyz);
            v[h+16*k]=i;
            i++;
          }
        }
      }
    }
    i = 0;
    for (int l = 0; l < lod; l++){
      for (int h = 0; h <= lod; h++){
        for (int k = l; (h + k <= lod) && (k < l + 2); k++){
          //printf("%d %d %d\n",h,k,l);
          idx[i] = v[h*16+k];//v[h+16*k] //the other handedness
          i++;
        }
      }
      idx[i] = -1;
      i++;
    }
  }
  vec3 nfn =vec3(1,0,0);
  float ph = peakheight[0];
  for (int i = 0; i < idx.length(); i++){
  //for (int i = idx.length()-1; i >= 0; i--){
    if (idx[i]<0){
      EndPrimitive();
      if ((i<271)&&(idx[i+1]<0)) return;
      continue;
    }
    if (((i + 2) < idx.length())&&(idx[i]>=0)&&(idx[i+1]>=0)&&(idx[i+2]>=0)) nfn =  normalize(np[idx[i]]+np[idx[i+1]]+np[idx[i+2]]);
    //Normal = normalize(normalMatrix * normalize(mat3(r) * ((an<0)?nfn:np[idx[i]])));
    nor = normalize(((an<0)?nfn:np[idx[i]]));
    Normal = normalize(normalMatrix * NR * nor);
    vert = np[idx[i]];
    _an = an;
    _ph = ph;
    _sg = _sgi;
    _part = _prt;
    _style = style;
    gl_Position = pmv * ((r * vec4(np[idx[i]],1)) + mitte);
    EmitVertex();
  }
  EndPrimitive();
}
void triacontahedron(vec4 mitte, int an, int _sgi, float _prt, int style){
  vec3 midof3 = normalize(gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz);
  int facecode = int(ci[0])*256+int(ci[1])*16+int(ci[2]);
  int codes[] = int[20](0x108,0x405,0x50a,0x804,0xa01,0x618,0x716,0xa17,0x32b,0x429,0x524,0x923,0xb25,0x637,0x73b,0x936,0x849,0xb5a,0x968,0xa7b);
  int usethisedge[] = int[20](7, 7, 6, 4, 4, 5, 5, 4, 7, 7, 1, 4, 4, 3, 4, 4, 4, 4, 0, 0);
  int edge=0;
  for (int i=0; i<20; i++){
    if (facecode==codes[i]) {edge=i;break;}
  }
  float ph = peakheight[0];
  float tau = (1 + sqrt(5))*0.5;
  vec3 r1=vec3(0,1+tau,tau);
  vec3 r2=vec3(tau,tau,tau);
  float fktr=length(r2)/ length(r1);
  for (int j=0; j < 3; j++){
  if ((usethisedge[edge]&(1<<j))==0) continue;
  vec3 other = mat3(rmat(-72.0, gl_in[j].gl_Position.xyz)) * midof3;
  int k = (j + 1) % 3;
  vec3 normal = normalize(gl_in[j].gl_Position.xyz + midof3 + other + gl_in[k].gl_Position.xyz);
  vec3 np[] = vec3[4](normalize(gl_in[j].gl_Position.xyz), fktr * other, fktr * midof3 , normalize(gl_in[k].gl_Position.xyz));

  for (int i = 0; i < 4; i++){
    vert = np[i];
    nor = normal;
    Normal = normalize(normalMatrix * NR * nor);
    _an = an;
    _ph = ph;
    _sg = _sgi;
    _part = _prt;
    _style = style;
    gl_Position = pmv * ((r * vec4(np[i],1)) + mitte);
    EmitVertex();
  }
  EndPrimitive();
  }
}
void icosa60(vec4 mitte, int an, int _sgi, float _prt, int style){
/*
2------+
 \     |
| 3----1
|/     |
0------+
*/
  float tau = (1 + sqrt(5))*0.5;
  vec3 r1=vec3(0,1+tau,tau);
  vec3 r2=vec3(tau,tau,tau);
  float fktr=length(r2)/ length(r1);
  //fktr=tau*tau/(2*sqrt(3.));
  //fktr=(0.25*sqrt(3)*(1+sqrt(5)))/(0.5*sqrt(5.0/2.0+11.0/10.0*sqrt(5.0)));

  vec3 np[] = vec3[4](normalize(gl_in[0].gl_Position.xyz), normalize(gl_in[1].gl_Position.xyz), normalize(gl_in[2].gl_Position.xyz),
                      fktr * normalize(gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz));
  int idx[] = int[5](0, 1, 3, 2, 0);
  float ph = peakheight[0];
  for (int i = 0; i < idx.length(); i++){
    if (idx[i]<0){
      EndPrimitive();
      continue;
    }
    vert = np[idx[i]];
    nor = normalize(np[idx[i]]);
    Normal = normalize(normalMatrix * NR * nor);
    _an = an;
    _ph = ph;
    _sg = _sgi;
    _part = _prt;
    _style = style;
    gl_Position = pmv * ((r * vec4(np[idx[i]],1)) + mitte);
    EmitVertex();
  }
  EndPrimitive();
}
void main(void){
  bool npd    = false;
  int _sgi    = int(sg[0]);//these values will not change
  float _prt  = part[0];
  int stil    = int(style[0]);
  if ((stil&IS_HIDDEN)==IS_HIDDEN) return;
  int _Idx    = int(idx[0]);
  int _AuIdx  = int(auidx[0]);
  int _ResiNr = int(resinr[0]);
  if (!adp) stil|=HAS_NOADP;
  vec4 mitte = vec4(center[0], 0);
  if ((hideHydrogen) && (int(an[0])==0)) return;
  if ((!bede) && (int(an[0])==-42)) return;

  if ((eigenvalues[0].x > 0.0) && (eigenvalues[0].y > 0.0) && (eigenvalues[0].z > 0.0)) {
    npd = false;
  }
  else {
    npd = true;
  }
  if ((!npd)&&(an[0]>=0)) {
    r = rmat(rotarr[0], sqrt(eigenvalues[0]));
    NR = normama(r);
  }else{
    r = rmat(vec4(0,1,0,0), vec3(1,1,1));
    NR = normama(r);
  }
  //justATriangle();
  if ((an[0] >= 0) && (npd)){
    r = mat4(mat3(0.35));
    NR = normama(r);
    cube(mitte, int(an[0]), _sgi, _prt, stil);
  } else {
  if (int(an[0])==-1) icosa(mitte, int(an[0]), _sgi, _prt, stil);//qpeaks
  else if (int(an[0])==-66) dodecahedron(mitte, int(an[0]), _sgi, _prt, stil);//centroids
  else if (int(an[0])==-42) triacontahedron(mitte, int(an[0]), _sgi, _prt, stil);//belo
  else {
  if (adp) pappe(mitte,int(an[0]), _sgi, _prt, stil);
  if (LOD==2) {icosa(mitte,int(an[0]), _sgi, _prt, stil);}
  else if (LOD==3) {icosa60(mitte, int(an[0]), _sgi, _prt, stil);}
  else {icosaLOD(mitte,int(an[0]), _sgi, _prt, stil, LOD - 2);}
  }//else qpeak centroids
  }//npd

}
