
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef HISTORYWIDGET_H
#define HISTORYWIDGET_H

#include <QWidget>
#include <QDateTime>

class historyWidget : public QWidget {
    Q_OBJECT
public:
    explicit historyWidget(QWidget *parent = 0);
    QList<double> RWerte;
    QList<double> RallWerte;
    QList<int> gooddata;
    QList<int> alldata;
    QList<int> parameters;
    QStringList saveFilesList;
    QList<QDateTime> dateTimesList;
    void setPath(QString dirName, int width);
signals:
    void message(const QString &);
    void lofi(const QString &);
public slots:
void preview();
void preview2();
void prune();
void deleteOne();
protected:
  void paintEvent(QPaintEvent *event);
  bool event(QEvent *event);
  void mousePressEvent ( QMouseEvent * event );
  void mouseMoveEvent ( QMouseEvent * event );
//  void wheelEvent ( QWheelEvent * event );
private:
  size_t gesamtGr;
  QColor farbverlauf(double wrt);
  int maxwid;
  QString dirname;
};

#endif // HISTORYWIDGET_H
