var browserTests = [
["foo[]bar",
    [["forecolor","#0000FF"]],
    "foo[]bar",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p> <p><span style=\"color:rgb(0, 0, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<p><font color=\"#0000ff\">[foo</font></p> <p><font color=\"#0000ff\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\"><span>[foo</span> <span>bar]</span></font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p><p> <span style=\"color:rgb(0, 0, 255)\"><span>bar</span></span> </p><p><span style=\"color:rgb(0, 0, 255)\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<p><font color=\"#0000ff\">[foo</font></p><p> <font color=\"#0000ff\"><span>bar</span></font> </p><p><font color=\"#0000ff\">baz]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p><p><span style=\"color:rgb(0, 0, 255)\"><br></span></p><p><span style=\"color:rgb(0, 0, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<p><font color=\"#0000ff\">[foo</font></p><p><font color=\"#0000ff\"><br></font></p><p><font color=\"#0000ff\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<b>foo[]bar</b>",
    [["forecolor","#0000FF"]],
    "<b>foo[]bar</b>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<i>foo[]bar</i>",
    [["forecolor","#0000FF"]],
    "<i>foo[]bar</i>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>foo</span>{}<span>bar</span>",
    [["forecolor","#0000FF"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>foo[</span><span>]bar</span>",
    [["forecolor","#0000FF"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar</span><b><span style=\"color:rgb(0, 0, 255)\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar</font><b><font color=\"#0000ff\">baz]</font>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar</span><i><span style=\"color:rgb(0, 0, 255)\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar</font><i><font color=\"#0000ff\">baz]</font>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "{<p></p><p> </p><p><span style=\"color:rgb(0, 0, 255)\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "{<p></p><p> </p><p><font color=\"#0000ff\">foo</font></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","blue"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","blue"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["forecolor","f"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["forecolor","#f"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","00f"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","00f"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","#00f"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","#00f"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","0000ff"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","0000ff"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","#0000ff"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","#0000ff"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["forecolor","000000fff"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["forecolor","#000000fff"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb(0, 0, 255)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb(0, 0, 255)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb(0%, 0%, 100%)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb(0%, 0%, 100%)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb( 0 ,0 ,255)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb( 0 ,0 ,255)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgba(0, 0, 255, 0.0)"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgba(0, 0, 255, 0.0)"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb(15, -10, 375)"]],
    "foo<span style=\"color:rgb(15, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(15, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb(15, -10, 375)"]],
    "foo<font color=\"#0f00ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(15, 0, 255)"]}],
["foo[bar]baz",
    [["forecolor","rgba(0, 0, 0, 1)"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgba(255, 255, 255, 1)"]],
    "foo<span style=\"color:rgb(255, 255, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 255, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgba(255, 255, 255, 1)"]],
    "foo<font color=\"#ffffff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 255, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgba(0, 0, 255, 0.5)"]],
    "foo<span style=\"color:rgba(0, 0, 255, 0.5)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0.5)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgba(0, 0, 255, 0.5)"]],
    "foo<span style=\"color:rgba(0, 0, 255, 0.5)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0.5)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","hsl(240, 100%, 50%)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","hsl(240, 100%, 50%)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","cornsilk"]],
    "foo<span style=\"color:rgb(255, 248, 220)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 248, 220)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","cornsilk"]],
    "foo<font color=\"#fff8dc\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 248, 220)"]}],
["foo[bar]baz",
    [["forecolor","potato quiche"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","transparent"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","transparent"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 0, 0)"]}],
["foo[bar]baz",
    [["forecolor","currentColor"]],
    "foo[bar]baz",
    [false],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"color:rgb(0, 0, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td><td>b<font color=\"#0000ff\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"color:rgb(0, 0, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td>{<td><font color=\"#0000ff\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody><tr>{<td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody><tr>{<td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody>{<tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody>{<tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table>{<tbody><tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table>{<tbody><tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "{<table><tbody><tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "{<table><tbody><tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=blue>[bar]</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=blue>[bar]</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=blue>bar</font>}baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo{<span style=\"color:rgb(0, 0, 255)\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=blue>bar</font>}baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo{<font color=\"#0000ff\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #00f\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #00f\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=blue>foo<font color=brown>[bar]</font>baz</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<font color=\"blue\">foo[bar]baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=blue>foo<font color=brown>[bar]</font>baz</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"blue\">foo[bar]baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">b[ar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<span style=\"color:rgb(165, 42, 42)\">b</span>[ar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">b[ar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<font color=\"#a52a2a\">b</font>[ar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<span id=purple>ba[r</span>ba]z",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span id=\"purple\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></span><span style=\"color:rgb(0, 0, 255)\">ba]</span>z",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["foo<span id=purple>ba[r</span>ba]z",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<span id=\"purple\">ba<font color=\"#0000ff\">[r</font></span><font color=\"#0000ff\">ba]</font>z",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span id=purple>b[a]r</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<span id=\"purple\">b<span style=\"color:rgb(0, 0, 255)\">[a]</span>r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span id=purple>b[a]r</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<span id=\"purple\">b<font color=\"#0000ff\">[a]</font>r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
    [["forecolor","blue"]],
    "<a href=\"http://www.google.com\">foo[bar]baz</a>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
    [["forecolor","#0000ff"]],
    "<a href=\"http://www.google.com\">foo[bar]baz</a>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
    [["forecolor","rgb(0,0,255)"]],
    "<a href=\"http://www.google.com\">foo[bar]baz</a>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"blue\">[foo]</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"blue\">[foo]</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"0000ff\">[foo]</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"0000ff\">[foo]</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"#0000ff\">[foo]</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"#0000ff\">[foo]</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0%, 0%, 100%)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0%, 0%, 100%)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb( 0 ,0 ,255)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb( 0 ,0 ,255)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.0)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 255, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.0)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 255, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(15, -10, 375)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(15, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(15, -10, 375)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(15, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 0, 1)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 0, 1)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(255, 255, 255, 1)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(255, 255, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(255, 255, 255, 1)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(255, 255, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.5)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 255, 0.5)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.5)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 255, 0.5)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: hsl(240, 100%, 50%)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: hsl(240, 100%, 50%)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: cornsilk\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(255, 248, 220)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: cornsilk\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(255, 248, 220)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: transparent\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: transparent\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: currentColor\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: currentColor\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>b]ar</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "fo<span style=\"color:rgb(0, 0, 255)\">[o</span><font color=\"brown\"><span style=\"color:rgb(0, 0, 255)\">b]</span>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>b]ar</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "fo<font color=\"#0000ff\">[o</font><font color=\"brown\"><font color=\"#0000ff\">b]</font>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>b]az",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></font><span style=\"color:rgb(0, 0, 255)\">b]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>b]az",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba<font color=\"#0000ff\">[r</font></font><font color=\"#0000ff\">b]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>bar</font>b]az",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "fo<span style=\"color:rgb(0, 0, 255)\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>bar</font>b]az",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "fo<font color=\"#0000ff\">[obarb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>b]ar</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo[<font color=\"brown\"><span style=\"color:rgb(0, 0, 255)\">b]</span>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>b]ar</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo[<font color=\"brown\"><font color=\"#0000ff\">b]</font>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>]baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></font>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>]baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba<font color=\"#0000ff\">[r</font></font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>bar</font>]baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo[<span style=\"color:rgb(0, 0, 255)\">bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>bar</font>]baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo[<font color=\"#0000ff\">bar</font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>[bar]</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>[bar]</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=brown>bar</font>}baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo{<span style=\"color:rgb(0, 0, 255)\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=brown>bar</font>}baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo{<font color=\"#0000ff\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=brown>fo[o</font><span style=color:brown>b]ar</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<font color=\"brown\">fo<span style=\"color:rgb(0, 0, 255)\">[o</span></font><span style=\"color:rgb(165, 42, 42)\"><span style=\"color:rgb(0, 0, 255)\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=brown>fo[o</font><span style=color:brown>b]ar</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"brown\">fo<font color=\"#0000ff\">[o</font></font><span style=\"color:rgb(165, 42, 42)\"><font color=\"#0000ff\">b]</font>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=color:brown>fo[o</span><span style=color:#0000ff>b]ar</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(165, 42, 42)\">fo<span style=\"color:rgb(0, 0, 255)\">[o</span></span><span style=\"color:rgb(0, 0, 255)\">b]ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=color:brown>fo[o</span><span style=color:#0000ff>b]ar</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(165, 42, 42)\">fo<font color=\"#0000ff\">[o</font></span><span style=\"color:rgb(0, 0, 255)\">b]ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}]
]
