////////////////////////////////////////////////////////////////////////////////
// 
// Statistics.cc
//
//    produced: 17 Sep 2021 jr
// last change: 17 Sep 2021 jr
//
////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <thread>
#include <cstdlib>

#include "Statistics.hh"

namespace topcom {

  std::fstream Statistics::_stats_stream;
  size_type    Statistics::_no_of_map_calls = 0;

  // initialization:
  void Statistics::init() {
     std::cerr << "initializing statistics output ..." << std::endl;
      
      std::cerr << "... output file: " << CommandlineOptions::stats_file() << " ..." << std::endl;
      Statistics::stats_stream().open(CommandlineOptions::stats_file(), std::ios::out | std::ios::trunc);
      Statistics::stats_stream() << "//////////////////////////////////////////////////////////////////////////////" << std::endl;
      Statistics::stats_stream() << "// statistics file (automatically generated by TOPCOM)" << std::endl;
      Statistics::stats_stream() << "//////////////////////////////////////////////////////////////////////////////" << std::endl;
      Statistics::stats_stream() << std::endl;
      std::cerr << "... done." << std::endl;
    }

  // termination:
  void Statistics::term() {
    std::cerr << "terminating statistics output ..." << std::endl;
    Statistics::stats_stream() << "no of map calls: \t" << _no_of_map_calls << std::endl;
    Statistics::stats_stream().close();
    std::cerr << "... done." << std::endl;    
  }

  
}; // namespace topcom

// eof CommandlineOptions.cc
